/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorSpace;
import android.util.Half;
import com.android.internal.util.XmlUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.DoubleUnaryOperator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Color
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int BLACK = -16777216;
    public static int DKGRAY = -12303292;
    public static int GRAY = -7829368;
    public static int LTGRAY = -3355444;
    public static int WHITE = -1;
    public static int RED = -65536;
    public static int GREEN = -16711936;
    public static int BLUE = -16776961;
    public static int YELLOW = -256;
    public static int CYAN = -16711681;
    public static int MAGENTA = -65281;
    public static int TRANSPARENT = 0;
    private float[] mComponents;
    private ColorSpace mColorSpace;
    private static HashMap<String, Integer> sColorNameMap;

    private void $$robo$$android_graphics_Color$__constructor__() {
        this.mComponents = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        this.mColorSpace = ColorSpace.get(ColorSpace.Named.SRGB);
    }

    private void $$robo$$android_graphics_Color$__constructor__(float r, float g, float b, float a) {
    }

    private void $$robo$$android_graphics_Color$__constructor__(float r, float g, float b, float a, ColorSpace colorSpace) {
        this.mComponents = new float[]{r, g, b, a};
        this.mColorSpace = colorSpace;
    }

    private void $$robo$$android_graphics_Color$__constructor__(float[] components, ColorSpace colorSpace) {
        this.mComponents = components;
        this.mColorSpace = colorSpace;
    }

    private final ColorSpace $$robo$$android_graphics_Color$getColorSpace() {
        return this.mColorSpace;
    }

    private final ColorSpace.Model $$robo$$android_graphics_Color$getModel() {
        return this.mColorSpace.getModel();
    }

    private final boolean $$robo$$android_graphics_Color$isWideGamut() {
        return this.getColorSpace().isWideGamut();
    }

    private final boolean $$robo$$android_graphics_Color$isSrgb() {
        return this.getColorSpace().isSrgb();
    }

    private final int $$robo$$android_graphics_Color$getComponentCount() {
        return this.mColorSpace.getComponentCount() + 1;
    }

    private final long $$robo$$android_graphics_Color$pack() {
        return Color.pack(this.mComponents[0], this.mComponents[1], this.mComponents[2], this.mComponents[3], this.mColorSpace);
    }

    private final Color $$robo$$android_graphics_Color$convert(ColorSpace colorSpace) {
        ColorSpace.Connector connector = ColorSpace.connect(this.mColorSpace, colorSpace);
        float[] color2 = new float[]{this.mComponents[0], this.mComponents[1], this.mComponents[2], this.mComponents[3]};
        connector.transform(color2);
        return new Color(color2, colorSpace);
    }

    private final int $$robo$$android_graphics_Color$toArgb() {
        if (this.mColorSpace.isSrgb()) {
            return (int)(this.mComponents[3] * 255.0f + 0.5f) << 24 | (int)(this.mComponents[0] * 255.0f + 0.5f) << 16 | (int)(this.mComponents[1] * 255.0f + 0.5f) << 8 | (int)(this.mComponents[2] * 255.0f + 0.5f);
        }
        float[] color2 = new float[]{this.mComponents[0], this.mComponents[1], this.mComponents[2], this.mComponents[3]};
        ColorSpace.connect(this.mColorSpace).transform(color2);
        return (int)(color2[3] * 255.0f + 0.5f) << 24 | (int)(color2[0] * 255.0f + 0.5f) << 16 | (int)(color2[1] * 255.0f + 0.5f) << 8 | (int)(color2[2] * 255.0f + 0.5f);
    }

    private final float $$robo$$android_graphics_Color$red() {
        return this.mComponents[0];
    }

    private final float $$robo$$android_graphics_Color$green() {
        return this.mComponents[1];
    }

    private final float $$robo$$android_graphics_Color$blue() {
        return this.mComponents[2];
    }

    private final float $$robo$$android_graphics_Color$alpha() {
        return this.mComponents[this.mComponents.length - 1];
    }

    private final float[] $$robo$$android_graphics_Color$getComponents() {
        return Arrays.copyOf(this.mComponents, this.mComponents.length);
    }

    private final float[] $$robo$$android_graphics_Color$getComponents(float[] components) {
        if (components == null) {
            return Arrays.copyOf(this.mComponents, this.mComponents.length);
        }
        if (components.length < this.mComponents.length) {
            throw new IllegalArgumentException("The specified array's length must be at least " + this.mComponents.length);
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mComponents, (int)0, (Object)components, (int)0, (int)this.mComponents.length);
        return components;
    }

    private final float $$robo$$android_graphics_Color$getComponent(int component) {
        return this.mComponents[component];
    }

    private final float $$robo$$android_graphics_Color$luminance() {
        if (this.mColorSpace.getModel() != ColorSpace.Model.RGB) {
            throw new IllegalArgumentException("The specified color must be encoded in an RGB color space. The supplied color space is " + (Object)((Object)this.mColorSpace.getModel()));
        }
        DoubleUnaryOperator eotf = ((ColorSpace.Rgb)this.mColorSpace).getEotf();
        double r = eotf.applyAsDouble(this.mComponents[0]);
        double g = eotf.applyAsDouble(this.mComponents[1]);
        double b = eotf.applyAsDouble(this.mComponents[2]);
        return Color.saturate((float)(0.2126 * r + 0.7152 * g + 0.0722 * b));
    }

    private final boolean $$robo$$android_graphics_Color$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color2 = (Color)o;
        if (!Arrays.equals(this.mComponents, color2.mComponents)) {
            return false;
        }
        return this.mColorSpace.equals(color2.mColorSpace);
    }

    private final int $$robo$$android_graphics_Color$hashCode() {
        int result = Arrays.hashCode(this.mComponents);
        result = 31 * result + this.mColorSpace.hashCode();
        return result;
    }

    private final String $$robo$$android_graphics_Color$toString() {
        StringBuilder b = new StringBuilder("Color(");
        for (float c : this.mComponents) {
            b.append(c).append(", ");
        }
        b.append(this.mColorSpace.getName());
        b.append(')');
        return b.toString();
    }

    private static final ColorSpace $$robo$$android_graphics_Color$colorSpace(long color2) {
        return ColorSpace.get((int)(color2 & 0x3FL));
    }

    private static final float $$robo$$android_graphics_Color$red(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (float)(color2 >> 48 & 0xFFL) / 255.0f;
        }
        return Half.toFloat((short)(color2 >> 48 & 0xFFFFL));
    }

    private static final float $$robo$$android_graphics_Color$green(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (float)(color2 >> 40 & 0xFFL) / 255.0f;
        }
        return Half.toFloat((short)(color2 >> 32 & 0xFFFFL));
    }

    private static final float $$robo$$android_graphics_Color$blue(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (float)(color2 >> 32 & 0xFFL) / 255.0f;
        }
        return Half.toFloat((short)(color2 >> 16 & 0xFFFFL));
    }

    private static final float $$robo$$android_graphics_Color$alpha(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (float)(color2 >> 56 & 0xFFL) / 255.0f;
        }
        return (float)(color2 >> 6 & 0x3FFL) / 1023.0f;
    }

    private static final boolean $$robo$$android_graphics_Color$isSrgb(long color2) {
        return Color.colorSpace(color2).isSrgb();
    }

    private static final boolean $$robo$$android_graphics_Color$isWideGamut(long color2) {
        return Color.colorSpace(color2).isWideGamut();
    }

    private static final boolean $$robo$$android_graphics_Color$isInColorSpace(long color2, ColorSpace colorSpace) {
        return (int)(color2 & 0x3FL) == colorSpace.getId();
    }

    private static final int $$robo$$android_graphics_Color$toArgb(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (int)(color2 >> 32);
        }
        float r = Color.red(color2);
        float g = Color.green(color2);
        float b = Color.blue(color2);
        float a = Color.alpha(color2);
        float[] c = ColorSpace.connect(Color.colorSpace(color2)).transform(r, g, b);
        return (int)(a * 255.0f + 0.5f) << 24 | (int)(c[0] * 255.0f + 0.5f) << 16 | (int)(c[1] * 255.0f + 0.5f) << 8 | (int)(c[2] * 255.0f + 0.5f);
    }

    private static final Color $$robo$$android_graphics_Color$valueOf(int color2) {
        float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color2 & 0xFF) / 255.0f;
        float a = (float)(color2 >> 24 & 0xFF) / 255.0f;
        return new Color(r, g, b, a, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    private static final Color $$robo$$android_graphics_Color$valueOf(long color2) {
        return new Color(Color.red(color2), Color.green(color2), Color.blue(color2), Color.alpha(color2), Color.colorSpace(color2));
    }

    private static final Color $$robo$$android_graphics_Color$valueOf(float r, float g, float b) {
        return new Color(r, g, b, 1.0f);
    }

    private static final Color $$robo$$android_graphics_Color$valueOf(float r, float g, float b, float a) {
        return new Color(Color.saturate(r), Color.saturate(g), Color.saturate(b), Color.saturate(a));
    }

    private static final Color $$robo$$android_graphics_Color$valueOf(float r, float g, float b, float a, ColorSpace colorSpace) {
        if (colorSpace.getComponentCount() > 3) {
            throw new IllegalArgumentException("The specified color space must use a color model with at most 3 color components");
        }
        return new Color(r, g, b, a, colorSpace);
    }

    private static final Color $$robo$$android_graphics_Color$valueOf(float[] components, ColorSpace colorSpace) {
        if (components.length < colorSpace.getComponentCount() + 1) {
            throw new IllegalArgumentException("Received a component array of length " + components.length + " but the color model requires " + (colorSpace.getComponentCount() + 1) + " (including alpha)");
        }
        return new Color(Arrays.copyOf(components, colorSpace.getComponentCount() + 1), colorSpace);
    }

    private static final long $$robo$$android_graphics_Color$pack(int color2) {
        return ((long)color2 & 0xFFFFFFFFL) << 32;
    }

    private static final long $$robo$$android_graphics_Color$pack(float red, float green, float blue) {
        return Color.pack(red, green, blue, 1.0f, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    private static final long $$robo$$android_graphics_Color$pack(float red, float green, float blue, float alpha) {
        return Color.pack(red, green, blue, alpha, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    private static final long $$robo$$android_graphics_Color$pack(float red, float green, float blue, float alpha, ColorSpace colorSpace) {
        if (colorSpace.isSrgb()) {
            int argb = (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
            return ((long)argb & 0xFFFFFFFFL) << 32;
        }
        int id2 = colorSpace.getId();
        if (id2 == -1) {
            throw new IllegalArgumentException("Unknown color space, please use a color space returned by ColorSpace.get()");
        }
        if (colorSpace.getComponentCount() > 3) {
            throw new IllegalArgumentException("The color space must use a color model with at most 3 components");
        }
        short r = Half.toHalf(red);
        short g = Half.toHalf(green);
        short b = Half.toHalf(blue);
        int a = (int)(Math.max(0.0f, Math.min(alpha, 1.0f)) * 1023.0f + 0.5f);
        return ((long)r & 0xFFFFL) << 48 | ((long)g & 0xFFFFL) << 32 | ((long)b & 0xFFFFL) << 16 | ((long)a & 0x3FFL) << 6 | (long)id2 & 0x3FL;
    }

    private static final long $$robo$$android_graphics_Color$convert(int color2, ColorSpace colorSpace) {
        float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color2 & 0xFF) / 255.0f;
        float a = (float)(color2 >> 24 & 0xFF) / 255.0f;
        ColorSpace source = ColorSpace.get(ColorSpace.Named.SRGB);
        return Color.convert(r, g, b, a, source, colorSpace);
    }

    private static final long $$robo$$android_graphics_Color$convert(long color2, ColorSpace colorSpace) {
        float r = Color.red(color2);
        float g = Color.green(color2);
        float b = Color.blue(color2);
        float a = Color.alpha(color2);
        ColorSpace source = Color.colorSpace(color2);
        return Color.convert(r, g, b, a, source, colorSpace);
    }

    private static final long $$robo$$android_graphics_Color$convert(float r, float g, float b, float a, ColorSpace source, ColorSpace destination) {
        float[] c = ColorSpace.connect(source, destination).transform(r, g, b);
        return Color.pack(c[0], c[1], c[2], a, destination);
    }

    private static final long $$robo$$android_graphics_Color$convert(long color2, ColorSpace.Connector connector) {
        float r = Color.red(color2);
        float g = Color.green(color2);
        float b = Color.blue(color2);
        float a = Color.alpha(color2);
        return Color.convert(r, g, b, a, connector);
    }

    private static final long $$robo$$android_graphics_Color$convert(float r, float g, float b, float a, ColorSpace.Connector connector) {
        float[] c = connector.transform(r, g, b);
        return Color.pack(c[0], c[1], c[2], a, connector.getDestination());
    }

    private static final float $$robo$$android_graphics_Color$luminance(long color2) {
        ColorSpace colorSpace = Color.colorSpace(color2);
        if (colorSpace.getModel() != ColorSpace.Model.RGB) {
            throw new IllegalArgumentException("The specified color must be encoded in an RGB color space. The supplied color space is " + (Object)((Object)colorSpace.getModel()));
        }
        DoubleUnaryOperator eotf = ((ColorSpace.Rgb)colorSpace).getEotf();
        double r = eotf.applyAsDouble(Color.red(color2));
        double g = eotf.applyAsDouble(Color.green(color2));
        double b = eotf.applyAsDouble(Color.blue(color2));
        return Color.saturate((float)(0.2126 * r + 0.7152 * g + 0.0722 * b));
    }

    private static final float $$robo$$android_graphics_Color$saturate(float v) {
        return v <= 0.0f ? 0.0f : (v >= 1.0f ? 1.0f : v);
    }

    private static final int $$robo$$android_graphics_Color$alpha(int color2) {
        return color2 >>> 24;
    }

    private static final int $$robo$$android_graphics_Color$red(int color2) {
        return color2 >> 16 & 0xFF;
    }

    private static final int $$robo$$android_graphics_Color$green(int color2) {
        return color2 >> 8 & 0xFF;
    }

    private static final int $$robo$$android_graphics_Color$blue(int color2) {
        return color2 & 0xFF;
    }

    private static final int $$robo$$android_graphics_Color$rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static final int $$robo$$android_graphics_Color$rgb(float red, float green, float blue) {
        return 0xFF000000 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    private static final int $$robo$$android_graphics_Color$argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private static final int $$robo$$android_graphics_Color$argb(float alpha, float red, float green, float blue) {
        return (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    private static final float $$robo$$android_graphics_Color$luminance(int color2) {
        ColorSpace.Rgb cs = (ColorSpace.Rgb)ColorSpace.get(ColorSpace.Named.SRGB);
        DoubleUnaryOperator eotf = cs.getEotf();
        double r = eotf.applyAsDouble((double)Color.red(color2) / 255.0);
        double g = eotf.applyAsDouble((double)Color.green(color2) / 255.0);
        double b = eotf.applyAsDouble((double)Color.blue(color2) / 255.0);
        return (float)(0.2126 * r + 0.7152 * g + 0.0722 * b);
    }

    private static final int $$robo$$android_graphics_Color$parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            long color2 = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color2 |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)color2;
        }
        Integer color3 = sColorNameMap.get(colorString.toLowerCase(Locale.ROOT));
        if (color3 != null) {
            return color3;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    private static final void $$robo$$android_graphics_Color$RGBToHSV(int red, int green, int blue, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        Color.nativeRGBToHSV(red, green, blue, hsv);
    }

    private static final void $$robo$$android_graphics_Color$colorToHSV(int color2, float[] hsv) {
        Color.RGBToHSV(color2 >> 16 & 0xFF, color2 >> 8 & 0xFF, color2 & 0xFF, hsv);
    }

    private static final int $$robo$$android_graphics_Color$HSVToColor(float[] hsv) {
        return Color.HSVToColor(255, hsv);
    }

    private static final int $$robo$$android_graphics_Color$HSVToColor(int alpha, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        return Color.nativeHSVToColor(alpha, hsv);
    }

    private static final void $$robo$$android_graphics_Color$nativeRGBToHSV(int n, int n2, int n3, float[] fArray) {
    }

    private static final int $$robo$$android_graphics_Color$nativeHSVToColor(int n, float[] fArray) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Color$getHtmlColor(String color2) {
        Integer i = sColorNameMap.get(color2.toLowerCase(Locale.ROOT));
        if (i != null) {
            return i;
        }
        try {
            return XmlUtils.convertValueToInt(color2, -1);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    static void __staticInitializer__() {
        sColorNameMap = new HashMap();
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", -16711681);
        sColorNameMap.put("fuchsia", -65281);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", -16711936);
        sColorNameMap.put("maroon", -8388608);
        sColorNameMap.put("navy", -16777088);
        sColorNameMap.put("olive", -8355840);
        sColorNameMap.put("purple", -8388480);
        sColorNameMap.put("silver", -4144960);
        sColorNameMap.put("teal", -16744320);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Color$__constructor__();
    }

    public Color() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Color$__constructor__(), this);
    }

    private void __constructor__(float f, float f2, float f3, float f4) {
        this.$$robo$$android_graphics_Color$__constructor__(f, f2, f3, f4);
    }

    public Color(float f, float f2, float f3, float f4) {
        this(f, f2, f3, f4, ColorSpace.get(ColorSpace.Named.SRGB));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Color$__constructor__(float float float float ), this, f, f2, f3, f4);
    }

    private void __constructor__(float f, float f2, float f3, float f4, ColorSpace colorSpace) {
        this.$$robo$$android_graphics_Color$__constructor__(f, f2, f3, f4, colorSpace);
    }

    public Color(float f, float f2, float f3, float f4, ColorSpace colorSpace) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Color$__constructor__(float float float float android.graphics.ColorSpace ), this, f, f2, f3, f4, colorSpace);
    }

    private void __constructor__(float[] fArray, ColorSpace colorSpace) {
        this.$$robo$$android_graphics_Color$__constructor__(fArray, colorSpace);
    }

    public Color(float[] fArray, ColorSpace colorSpace) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Color$__constructor__(float[] android.graphics.ColorSpace ), this, fArray, colorSpace);
    }

    public ColorSpace getColorSpace() {
        return InvokeDynamicSupport.bootstrap("getColorSpace", $$robo$$android_graphics_Color$getColorSpace(), this);
    }

    public ColorSpace.Model getModel() {
        return InvokeDynamicSupport.bootstrap("getModel", $$robo$$android_graphics_Color$getModel(), this);
    }

    public boolean isWideGamut() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWideGamut", $$robo$$android_graphics_Color$isWideGamut(), this);
    }

    public boolean isSrgb() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSrgb", $$robo$$android_graphics_Color$isSrgb(), this);
    }

    public int getComponentCount() {
        return (int)InvokeDynamicSupport.bootstrap("getComponentCount", $$robo$$android_graphics_Color$getComponentCount(), this);
    }

    public long pack() {
        return (long)InvokeDynamicSupport.bootstrap("pack", $$robo$$android_graphics_Color$pack(), this);
    }

    public Color convert(ColorSpace colorSpace) {
        return InvokeDynamicSupport.bootstrap("convert", $$robo$$android_graphics_Color$convert(android.graphics.ColorSpace ), this, colorSpace);
    }

    public int toArgb() {
        return (int)InvokeDynamicSupport.bootstrap("toArgb", $$robo$$android_graphics_Color$toArgb(), this);
    }

    public float red() {
        return (float)InvokeDynamicSupport.bootstrap("red", $$robo$$android_graphics_Color$red(), this);
    }

    public float green() {
        return (float)InvokeDynamicSupport.bootstrap("green", $$robo$$android_graphics_Color$green(), this);
    }

    public float blue() {
        return (float)InvokeDynamicSupport.bootstrap("blue", $$robo$$android_graphics_Color$blue(), this);
    }

    public float alpha() {
        return (float)InvokeDynamicSupport.bootstrap("alpha", $$robo$$android_graphics_Color$alpha(), this);
    }

    public float[] getComponents() {
        return InvokeDynamicSupport.bootstrap("getComponents", $$robo$$android_graphics_Color$getComponents(), this);
    }

    public float[] getComponents(float[] fArray) {
        return InvokeDynamicSupport.bootstrap("getComponents", $$robo$$android_graphics_Color$getComponents(float[] ), this, fArray);
    }

    public float getComponent(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_graphics_Color$getComponent(int ), this, n);
    }

    public float luminance() {
        return (float)InvokeDynamicSupport.bootstrap("luminance", $$robo$$android_graphics_Color$luminance(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_graphics_Color$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_graphics_Color$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_graphics_Color$toString(), this);
    }

    public static ColorSpace colorSpace(long l) {
        return InvokeDynamicSupport.bootstrapStatic("colorSpace", $$robo$$android_graphics_Color$colorSpace(long ), (long)l);
    }

    public static float red(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("red", $$robo$$android_graphics_Color$red(long ), (long)l);
    }

    public static float green(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("green", $$robo$$android_graphics_Color$green(long ), (long)l);
    }

    public static float blue(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("blue", $$robo$$android_graphics_Color$blue(long ), (long)l);
    }

    public static float alpha(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("alpha", $$robo$$android_graphics_Color$alpha(long ), (long)l);
    }

    public static boolean isSrgb(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSrgb", $$robo$$android_graphics_Color$isSrgb(long ), (long)l);
    }

    public static boolean isWideGamut(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWideGamut", $$robo$$android_graphics_Color$isWideGamut(long ), (long)l);
    }

    public static boolean isInColorSpace(long l, ColorSpace colorSpace) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInColorSpace", $$robo$$android_graphics_Color$isInColorSpace(long android.graphics.ColorSpace ), (long)l, (ColorSpace)colorSpace);
    }

    public static int toArgb(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("toArgb", $$robo$$android_graphics_Color$toArgb(long ), (long)l);
    }

    public static Color valueOf(int n) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Color$valueOf(int ), (int)n);
    }

    public static Color valueOf(long l) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Color$valueOf(long ), (long)l);
    }

    public static Color valueOf(float f, float f2, float f3) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Color$valueOf(float float float ), (float)f, (float)f2, (float)f3);
    }

    public static Color valueOf(float f, float f2, float f3, float f4) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Color$valueOf(float float float float ), (float)f, (float)f2, (float)f3, (float)f4);
    }

    public static Color valueOf(float f, float f2, float f3, float f4, ColorSpace colorSpace) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Color$valueOf(float float float float android.graphics.ColorSpace ), (float)f, (float)f2, (float)f3, (float)f4, (ColorSpace)colorSpace);
    }

    public static Color valueOf(float[] fArray, ColorSpace colorSpace) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Color$valueOf(float[] android.graphics.ColorSpace ), (float[])fArray, (ColorSpace)colorSpace);
    }

    public static long pack(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("pack", $$robo$$android_graphics_Color$pack(int ), (int)n);
    }

    public static long pack(float f, float f2, float f3) {
        return (long)InvokeDynamicSupport.bootstrapStatic("pack", $$robo$$android_graphics_Color$pack(float float float ), (float)f, (float)f2, (float)f3);
    }

    public static long pack(float f, float f2, float f3, float f4) {
        return (long)InvokeDynamicSupport.bootstrapStatic("pack", $$robo$$android_graphics_Color$pack(float float float float ), (float)f, (float)f2, (float)f3, (float)f4);
    }

    public static long pack(float f, float f2, float f3, float f4, ColorSpace colorSpace) {
        return (long)InvokeDynamicSupport.bootstrapStatic("pack", $$robo$$android_graphics_Color$pack(float float float float android.graphics.ColorSpace ), (float)f, (float)f2, (float)f3, (float)f4, (ColorSpace)colorSpace);
    }

    public static long convert(int n, ColorSpace colorSpace) {
        return (long)InvokeDynamicSupport.bootstrapStatic("convert", $$robo$$android_graphics_Color$convert(int android.graphics.ColorSpace ), (int)n, (ColorSpace)colorSpace);
    }

    public static long convert(long l, ColorSpace colorSpace) {
        return (long)InvokeDynamicSupport.bootstrapStatic("convert", $$robo$$android_graphics_Color$convert(long android.graphics.ColorSpace ), (long)l, (ColorSpace)colorSpace);
    }

    public static long convert(float f, float f2, float f3, float f4, ColorSpace colorSpace, ColorSpace colorSpace2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("convert", $$robo$$android_graphics_Color$convert(float float float float android.graphics.ColorSpace android.graphics.ColorSpace ), (float)f, (float)f2, (float)f3, (float)f4, (ColorSpace)colorSpace, (ColorSpace)colorSpace2);
    }

    public static long convert(long l, ColorSpace.Connector connector) {
        return (long)InvokeDynamicSupport.bootstrapStatic("convert", $$robo$$android_graphics_Color$convert(long android.graphics.ColorSpace$Connector ), (long)l, (ColorSpace.Connector)connector);
    }

    public static long convert(float f, float f2, float f3, float f4, ColorSpace.Connector connector) {
        return (long)InvokeDynamicSupport.bootstrapStatic("convert", $$robo$$android_graphics_Color$convert(float float float float android.graphics.ColorSpace$Connector ), (float)f, (float)f2, (float)f3, (float)f4, (ColorSpace.Connector)connector);
    }

    public static float luminance(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("luminance", $$robo$$android_graphics_Color$luminance(long ), (long)l);
    }

    private static float saturate(float f) {
        return (float)InvokeDynamicSupport.bootstrapStatic("saturate", $$robo$$android_graphics_Color$saturate(float ), (float)f);
    }

    public static int alpha(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("alpha", $$robo$$android_graphics_Color$alpha(int ), (int)n);
    }

    public static int red(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("red", $$robo$$android_graphics_Color$red(int ), (int)n);
    }

    public static int green(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("green", $$robo$$android_graphics_Color$green(int ), (int)n);
    }

    public static int blue(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("blue", $$robo$$android_graphics_Color$blue(int ), (int)n);
    }

    public static int rgb(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("rgb", $$robo$$android_graphics_Color$rgb(int int int ), (int)n, (int)n2, (int)n3);
    }

    public static int rgb(float f, float f2, float f3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("rgb", $$robo$$android_graphics_Color$rgb(float float float ), (float)f, (float)f2, (float)f3);
    }

    public static int argb(int n, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("argb", $$robo$$android_graphics_Color$argb(int int int int ), (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static int argb(float f, float f2, float f3, float f4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("argb", $$robo$$android_graphics_Color$argb(float float float float ), (float)f, (float)f2, (float)f3, (float)f4);
    }

    public static float luminance(int n) {
        return (float)InvokeDynamicSupport.bootstrapStatic("luminance", $$robo$$android_graphics_Color$luminance(int ), (int)n);
    }

    public static int parseColor(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseColor", $$robo$$android_graphics_Color$parseColor(java.lang.String ), (String)string2);
    }

    public static void RGBToHSV(int n, int n2, int n3, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("RGBToHSV", $$robo$$android_graphics_Color$RGBToHSV(int int int float[] ), (int)n, (int)n2, (int)n3, (float[])fArray);
    }

    public static void colorToHSV(int n, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("colorToHSV", $$robo$$android_graphics_Color$colorToHSV(int float[] ), (int)n, (float[])fArray);
    }

    public static int HSVToColor(float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("HSVToColor", $$robo$$android_graphics_Color$HSVToColor(float[] ), (float[])fArray);
    }

    public static int HSVToColor(int n, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("HSVToColor", $$robo$$android_graphics_Color$HSVToColor(int float[] ), (int)n, (float[])fArray);
    }

    private static void nativeRGBToHSV(int n, int n2, int n3, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("nativeRGBToHSV", $$robo$$android_graphics_Color$nativeRGBToHSV(int int int float[] ), (int)n, (int)n2, (int)n3, (float[])fArray);
    }

    private static int nativeHSVToColor(int n, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeHSVToColor", $$robo$$android_graphics_Color$nativeHSVToColor(int float[] ), (int)n, (float[])fArray);
    }

    public static int getHtmlColor(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getHtmlColor", $$robo$$android_graphics_Color$getHtmlColor(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(Color.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Color)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

