/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ImageDecoder;
import android.graphics.Insets;
import android.graphics.NinePatch;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NinePatchDrawable
extends Drawable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEFAULT_DITHER = false;
    private Rect mTempRect;
    private NinePatchState mNinePatchState;
    private PorterDuffColorFilter mTintFilter;
    private Rect mPadding;
    private Insets mOpticalInsets;
    private Rect mOutlineInsets;
    private float mOutlineRadius;
    private Paint mPaint;
    private boolean mMutated;
    private int mTargetDensity;
    private int mBitmapWidth;
    private int mBitmapHeight;

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__() {
        this.mOpticalInsets = Insets.NONE;
        this.mTargetDensity = 160;
        this.mBitmapWidth = -1;
        this.mBitmapHeight = -1;
        this.mNinePatchState = new NinePatchState();
    }

    @Deprecated
    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(Bitmap bitmap, byte[] chunk, Rect padding, String srcName) {
    }

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(Resources res, Bitmap bitmap, byte[] chunk, Rect padding, String srcName) {
    }

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(Resources res, Bitmap bitmap, byte[] chunk, Rect padding, Rect opticalInsets, String srcName) {
    }

    @Deprecated
    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(NinePatch patch) {
    }

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(Resources res, NinePatch patch) {
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(DisplayMetrics metrics) {
        this.setTargetDensity(metrics.densityDpi);
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(int density) {
        if (density == 0) {
            density = 160;
        }
        if (this.mTargetDensity != density) {
            this.mTargetDensity = density;
            this.computeBitmapSize();
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$draw(Canvas canvas) {
        boolean needsMirroring;
        boolean needsDensityScaling;
        int restoreAlpha;
        boolean clearColorFilter;
        NinePatchState state = this.mNinePatchState;
        Rect bounds = this.getBounds();
        int restoreToCount = -1;
        if (this.mTintFilter != null && this.getPaint().getColorFilter() == null) {
            this.mPaint.setColorFilter(this.mTintFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        if (state.mBaseAlpha != 1.0f) {
            restoreAlpha = this.getPaint().getAlpha();
            this.mPaint.setAlpha((int)((float)restoreAlpha * state.mBaseAlpha + 0.5f));
        } else {
            restoreAlpha = -1;
        }
        boolean bl = needsDensityScaling = canvas.getDensity() == 0 && 0 != state.mNinePatch.getDensity();
        if (needsDensityScaling) {
            restoreToCount = restoreToCount >= 0 ? restoreToCount : canvas.save();
            float scale = (float)this.mTargetDensity / (float)state.mNinePatch.getDensity();
            float px = bounds.left;
            float py = bounds.top;
            canvas.scale(scale, scale, px, py);
            if (this.mTempRect == null) {
                this.mTempRect = new Rect();
            }
            Rect scaledBounds = this.mTempRect;
            scaledBounds.left = bounds.left;
            scaledBounds.top = bounds.top;
            scaledBounds.right = bounds.left + Math.round((float)bounds.width() / scale);
            scaledBounds.bottom = bounds.top + Math.round((float)bounds.height() / scale);
            bounds = scaledBounds;
        }
        if (needsMirroring = this.needsMirroring()) {
            restoreToCount = restoreToCount >= 0 ? restoreToCount : canvas.save();
            float cx = (float)(bounds.left + bounds.right) / 2.0f;
            float cy = (float)(bounds.top + bounds.bottom) / 2.0f;
            canvas.scale(-1.0f, 1.0f, cx, cy);
        }
        state.mNinePatch.draw(canvas, bounds, this.mPaint);
        if (restoreToCount >= 0) {
            canvas.restoreToCount(restoreToCount);
        }
        if (clearColorFilter) {
            this.mPaint.setColorFilter(null);
        }
        if (restoreAlpha >= 0) {
            this.mPaint.setAlpha(restoreAlpha);
        }
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mNinePatchState.getChangingConfigurations();
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$getPadding(Rect padding) {
        if (this.mPadding != null) {
            padding.set(this.mPadding);
            return (padding.left | padding.top | padding.right | padding.bottom) != 0;
        }
        return super.getPadding(padding);
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$getOutline(Outline outline) {
        NinePatch.InsetStruct insets;
        Rect bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return;
        }
        if (this.mNinePatchState != null && this.mOutlineInsets != null && (insets = this.mNinePatchState.mNinePatch.getBitmap().getNinePatchInsets()) != null) {
            outline.setRoundRect(bounds.left + this.mOutlineInsets.left, bounds.top + this.mOutlineInsets.top, bounds.right - this.mOutlineInsets.right, bounds.bottom - this.mOutlineInsets.bottom, this.mOutlineRadius);
            outline.setAlpha(insets.outlineAlpha * ((float)this.getAlpha() / 255.0f));
            return;
        }
        super.getOutline(outline);
    }

    private final Insets $$robo$$android_graphics_drawable_NinePatchDrawable$getOpticalInsets() {
        Insets opticalInsets = this.mOpticalInsets;
        if (this.needsMirroring()) {
            return Insets.of(opticalInsets.right, opticalInsets.top, opticalInsets.left, opticalInsets.bottom);
        }
        return opticalInsets;
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setAlpha(int alpha) {
        if (this.mPaint == null && alpha == 255) {
            return;
        }
        this.getPaint().setAlpha(alpha);
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getAlpha() {
        if (this.mPaint == null) {
            return 255;
        }
        return this.getPaint().getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setColorFilter(ColorFilter colorFilter) {
        if (this.mPaint == null && colorFilter == null) {
            return;
        }
        this.getPaint().setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTintList(ColorStateList tint) {
        this.mNinePatchState.mTint = tint;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, this.mNinePatchState.mTintMode);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mNinePatchState.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mNinePatchState.mTint, tintMode);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setDither(boolean dither) {
        if (this.mPaint == null && !dither) {
            return;
        }
        this.getPaint().setDither(dither);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setAutoMirrored(boolean mirrored) {
        this.mNinePatchState.mAutoMirrored = mirrored;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$needsMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$isAutoMirrored() {
        return this.mNinePatchState.mAutoMirrored;
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setFilterBitmap(boolean filter) {
        this.getPaint().setFilterBitmap(filter);
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$isFilterBitmap() {
        return this.mPaint != null && this.getPaint().isFilterBitmap();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = NinePatchDrawable.obtainAttributes(r, theme, attrs, R.styleable.NinePatchDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.updateLocalState(r);
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        ColorStateList tint;
        Resources r = a.getResources();
        NinePatchState state = this.mNinePatchState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mDither = a.getBoolean(1, state.mDither);
        int srcResId = a.getResourceId(0, 0);
        if (srcResId != 0) {
            Rect padding = new Rect();
            Rect opticalInsets = new Rect();
            Bitmap bitmap = null;
            try {
                TypedValue value = new TypedValue();
                InputStream is = r.openRawResource(srcResId, value);
                int density = 0;
                if (value.density == 0) {
                    density = 160;
                } else if (value.density != 65535) {
                    density = value.density;
                }
                ImageDecoder.Source source = ImageDecoder.createSource(r, is, density);
                bitmap = ImageDecoder.decodeBitmap(source, (decoder, info, src) -> {
                    decoder.setOutPaddingRect(padding);
                    decoder.setAllocator(1);
                });
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bitmap == null) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <nine-patch> requires a valid src attribute");
            }
            if (bitmap.getNinePatchChunk() == null) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <nine-patch> requires a valid 9-patch source image");
            }
            bitmap.getOpticalInsets(opticalInsets);
            state.mNinePatch = new NinePatch(bitmap, bitmap.getNinePatchChunk());
            state.mPadding = padding;
            state.mOpticalInsets = Insets.of(opticalInsets);
        }
        state.mAutoMirrored = a.getBoolean(4, state.mAutoMirrored);
        state.mBaseAlpha = a.getFloat(3, state.mBaseAlpha);
        int tintMode = a.getInt(5, -1);
        if (tintMode != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(2)) != null) {
            state.mTint = tint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        NinePatchState state = this.mNinePatchState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.NinePatchDrawable);
            try {
                this.updateStateFromTypedArray(a);
            }
            catch (XmlPullParserException e) {
                NinePatchDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        this.updateLocalState(t.getResources());
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$canApplyTheme() {
        return this.mNinePatchState != null && this.mNinePatchState.canApplyTheme();
    }

    private final Paint $$robo$$android_graphics_drawable_NinePatchDrawable$getPaint() {
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setDither(false);
        }
        return this.mPaint;
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getOpacity() {
        return this.mNinePatchState.mNinePatch.hasAlpha() || this.mPaint != null && this.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    private final Region $$robo$$android_graphics_drawable_NinePatchDrawable$getTransparentRegion() {
        return this.mNinePatchState.mNinePatch.getTransparentRegion(this.getBounds());
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_NinePatchDrawable$getConstantState() {
        this.mNinePatchState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mNinePatchState;
    }

    private final Drawable $$robo$$android_graphics_drawable_NinePatchDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mNinePatchState = new NinePatchState(this.mNinePatchState);
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$onStateChange(int[] stateSet) {
        NinePatchState state = this.mNinePatchState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$isStateful() {
        NinePatchState s = this.mNinePatchState;
        return super.isStateful() || s.mTint != null && s.mTint.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$hasFocusStateSpecified() {
        return this.mNinePatchState.mTint != null && this.mNinePatchState.mTint.hasFocusStateSpecified();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$computeBitmapSize() {
        NinePatch ninePatch = this.mNinePatchState.mNinePatch;
        if (ninePatch == null) {
            return;
        }
        int targetDensity = this.mTargetDensity;
        int sourceDensity = ninePatch.getDensity() == 0 ? targetDensity : ninePatch.getDensity();
        Insets sourceOpticalInsets = this.mNinePatchState.mOpticalInsets;
        if (sourceOpticalInsets != Insets.NONE) {
            int left = Drawable.scaleFromDensity(sourceOpticalInsets.left, sourceDensity, targetDensity, true);
            int top = Drawable.scaleFromDensity(sourceOpticalInsets.top, sourceDensity, targetDensity, true);
            int right = Drawable.scaleFromDensity(sourceOpticalInsets.right, sourceDensity, targetDensity, true);
            int bottom = Drawable.scaleFromDensity(sourceOpticalInsets.bottom, sourceDensity, targetDensity, true);
            this.mOpticalInsets = Insets.of(left, top, right, bottom);
        } else {
            this.mOpticalInsets = Insets.NONE;
        }
        Rect sourcePadding = this.mNinePatchState.mPadding;
        if (sourcePadding != null) {
            if (this.mPadding == null) {
                this.mPadding = new Rect();
            }
            this.mPadding.left = Drawable.scaleFromDensity(sourcePadding.left, sourceDensity, targetDensity, true);
            this.mPadding.top = Drawable.scaleFromDensity(sourcePadding.top, sourceDensity, targetDensity, true);
            this.mPadding.right = Drawable.scaleFromDensity(sourcePadding.right, sourceDensity, targetDensity, true);
            this.mPadding.bottom = Drawable.scaleFromDensity(sourcePadding.bottom, sourceDensity, targetDensity, true);
        } else {
            this.mPadding = null;
        }
        this.mBitmapHeight = Drawable.scaleFromDensity(ninePatch.getHeight(), sourceDensity, targetDensity, true);
        this.mBitmapWidth = Drawable.scaleFromDensity(ninePatch.getWidth(), sourceDensity, targetDensity, true);
        NinePatch.InsetStruct insets = ninePatch.getBitmap().getNinePatchInsets();
        if (insets != null) {
            Rect outlineRect = insets.outlineRect;
            this.mOutlineInsets = NinePatch.InsetStruct.scaleInsets(outlineRect.left, outlineRect.top, outlineRect.right, outlineRect.bottom, (float)targetDensity / (float)sourceDensity);
            this.mOutlineRadius = Drawable.scaleFromDensity(insets.outlineRadius, sourceDensity, targetDensity);
        } else {
            this.mOutlineInsets = null;
        }
    }

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(NinePatchState state, Resources res) {
        this.mOpticalInsets = Insets.NONE;
        this.mTargetDensity = 160;
        this.mBitmapWidth = -1;
        this.mBitmapHeight = -1;
        this.mNinePatchState = state;
        this.updateLocalState(res);
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$updateLocalState(Resources res) {
        NinePatchState state = this.mNinePatchState;
        if (state.mDither) {
            this.setDither(state.mDither);
        }
        this.mTargetDensity = res == null && state.mNinePatch != null ? state.mNinePatch.getDensity() : Drawable.resolveDensity(res, this.mTargetDensity);
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
        this.computeBitmapSize();
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(NinePatchState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__();
    }

    public NinePatchDrawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(), this);
    }

    private void __constructor__(Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(bitmap, byArray, rect, string2);
    }

    public NinePatchDrawable(Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.graphics.Bitmap byte[] android.graphics.Rect java.lang.String ), this, bitmap, byArray, rect, string2);
    }

    private void __constructor__(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(resources, bitmap, byArray, rect, string2);
    }

    public NinePatchDrawable(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect), resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.content.res.Resources android.graphics.Bitmap byte[] android.graphics.Rect java.lang.String ), this, resources, bitmap, byArray, rect, string2);
    }

    private void __constructor__(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, Rect rect2, String string2) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(resources, bitmap, byArray, rect, rect2, string2);
    }

    public NinePatchDrawable(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, Rect rect2, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect, rect2), resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.content.res.Resources android.graphics.Bitmap byte[] android.graphics.Rect android.graphics.Rect java.lang.String ), this, resources, bitmap, byArray, rect, rect2, string2);
    }

    private void __constructor__(NinePatch ninePatch) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(ninePatch);
    }

    public NinePatchDrawable(NinePatch ninePatch) {
        this(new NinePatchState(ninePatch, new Rect()), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.graphics.NinePatch ), this, ninePatch);
    }

    private void __constructor__(Resources resources, NinePatch ninePatch) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(resources, ninePatch);
    }

    public NinePatchDrawable(Resources resources, NinePatch ninePatch) {
        this(new NinePatchState(ninePatch, new Rect()), resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.content.res.Resources android.graphics.NinePatch ), this, resources, ninePatch);
    }

    public void setTargetDensity(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(android.graphics.Canvas ), this, canvas);
    }

    public void setTargetDensity(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(android.util.DisplayMetrics ), this, displayMetrics);
    }

    public void setTargetDensity(int n) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(int ), this, n);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_NinePatchDrawable$draw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_NinePatchDrawable$getChangingConfigurations(), this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_NinePatchDrawable$getPadding(android.graphics.Rect ), this, rect);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_NinePatchDrawable$getOutline(android.graphics.Outline ), this, outline);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_NinePatchDrawable$getOpticalInsets(), this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_NinePatchDrawable$setAlpha(int ), this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_NinePatchDrawable$getAlpha(), this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_NinePatchDrawable$setColorFilter(android.graphics.ColorFilter ), this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_NinePatchDrawable$setTintList(android.content.res.ColorStateList ), this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_NinePatchDrawable$setTintMode(android.graphics.PorterDuff$Mode ), this, mode);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_NinePatchDrawable$setDither(boolean ), this, bl);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_NinePatchDrawable$setAutoMirrored(boolean ), this, bl);
    }

    private boolean needsMirroring() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsMirroring", $$robo$$android_graphics_drawable_NinePatchDrawable$needsMirroring(), this);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_NinePatchDrawable$isAutoMirrored(), this);
    }

    @Override
    public void setFilterBitmap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFilterBitmap", $$robo$$android_graphics_drawable_NinePatchDrawable$setFilterBitmap(boolean ), this, bl);
    }

    @Override
    public boolean isFilterBitmap() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFilterBitmap", $$robo$$android_graphics_drawable_NinePatchDrawable$isFilterBitmap(), this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_NinePatchDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_NinePatchDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), this, typedArray);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_NinePatchDrawable$applyTheme(android.content.res.Resources$Theme ), this, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_NinePatchDrawable$canApplyTheme(), this);
    }

    public Paint getPaint() {
        return InvokeDynamicSupport.bootstrap("getPaint", $$robo$$android_graphics_drawable_NinePatchDrawable$getPaint(), this);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_NinePatchDrawable$getIntrinsicWidth(), this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_NinePatchDrawable$getIntrinsicHeight(), this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_NinePatchDrawable$getOpacity(), this);
    }

    @Override
    public Region getTransparentRegion() {
        return InvokeDynamicSupport.bootstrap("getTransparentRegion", $$robo$$android_graphics_drawable_NinePatchDrawable$getTransparentRegion(), this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_NinePatchDrawable$getConstantState(), this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_NinePatchDrawable$mutate(), this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_NinePatchDrawable$clearMutated(), this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_NinePatchDrawable$onStateChange(int[] ), this, nArray);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_NinePatchDrawable$isStateful(), this);
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_NinePatchDrawable$hasFocusStateSpecified(), this);
    }

    private void computeBitmapSize() {
        InvokeDynamicSupport.bootstrap("computeBitmapSize", $$robo$$android_graphics_drawable_NinePatchDrawable$computeBitmapSize(), this);
    }

    private void __constructor__(NinePatchState ninePatchState, Resources resources) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(ninePatchState, resources);
    }

    public NinePatchDrawable(NinePatchState ninePatchState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.graphics.drawable.NinePatchDrawable$NinePatchState android.content.res.Resources ), this, ninePatchState, resources);
    }

    private void updateLocalState(Resources resources) {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_NinePatchDrawable$updateLocalState(android.content.res.Resources ), this, resources);
    }

    private /* synthetic */ void __constructor__(NinePatchState ninePatchState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(ninePatchState, resources, var3_3);
    }

    public /* synthetic */ NinePatchDrawable(NinePatchState ninePatchState, Resources resources, 1 var3_3) {
        this(ninePatchState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.graphics.drawable.NinePatchDrawable$NinePatchState android.content.res.Resources android.graphics.drawable.NinePatchDrawable$1 ), this, ninePatchState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NinePatchDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class NinePatchState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mChangingConfigurations;
        NinePatch mNinePatch;
        ColorStateList mTint;
        PorterDuff.Mode mTintMode;
        Rect mPadding;
        Insets mOpticalInsets;
        float mBaseAlpha;
        boolean mDither;
        boolean mAutoMirrored;
        int[] mThemeAttrs;

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__() {
            this.mNinePatch = null;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mPadding = null;
            this.mOpticalInsets = Insets.NONE;
            this.mBaseAlpha = 1.0f;
            this.mDither = false;
            this.mAutoMirrored = false;
        }

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(NinePatch ninePatch, Rect padding) {
        }

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(NinePatch ninePatch, Rect padding, Rect opticalInsets) {
        }

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(NinePatch ninePatch, Rect padding, Rect opticalInsets, boolean dither, boolean autoMirror) {
            this.mNinePatch = null;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mPadding = null;
            this.mOpticalInsets = Insets.NONE;
            this.mBaseAlpha = 1.0f;
            this.mDither = false;
            this.mAutoMirrored = false;
            this.mNinePatch = ninePatch;
            this.mPadding = padding;
            this.mOpticalInsets = Insets.of(opticalInsets);
            this.mDither = dither;
            this.mAutoMirrored = autoMirror;
        }

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(NinePatchState orig) {
            this.mNinePatch = null;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mPadding = null;
            this.mOpticalInsets = Insets.NONE;
            this.mBaseAlpha = 1.0f;
            this.mDither = false;
            this.mAutoMirrored = false;
            this.mChangingConfigurations = orig.mChangingConfigurations;
            this.mNinePatch = orig.mNinePatch;
            this.mTint = orig.mTint;
            this.mTintMode = orig.mTintMode;
            this.mPadding = orig.mPadding;
            this.mOpticalInsets = orig.mOpticalInsets;
            this.mBaseAlpha = orig.mBaseAlpha;
            this.mDither = orig.mDither;
            this.mAutoMirrored = orig.mAutoMirrored;
            this.mThemeAttrs = orig.mThemeAttrs;
        }

        private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$canApplyTheme() {
            return this.mThemeAttrs != null || this.mTint != null && this.mTint.canApplyTheme() || super.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable() {
            return new NinePatchDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable(Resources res) {
            return new NinePatchDrawable(this, res, null);
        }

        private final int $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__();
        }

        public NinePatchState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(), this);
        }

        private void __constructor__(NinePatch ninePatch, Rect rect) {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(ninePatch, rect);
        }

        public NinePatchState(NinePatch ninePatch, Rect rect) {
            this(ninePatch, rect, null, false, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(android.graphics.NinePatch android.graphics.Rect ), this, ninePatch, rect);
        }

        private void __constructor__(NinePatch ninePatch, Rect rect, Rect rect2) {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(ninePatch, rect, rect2);
        }

        public NinePatchState(NinePatch ninePatch, Rect rect, Rect rect2) {
            this(ninePatch, rect, rect2, false, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(android.graphics.NinePatch android.graphics.Rect android.graphics.Rect ), this, ninePatch, rect, rect2);
        }

        private void __constructor__(NinePatch ninePatch, Rect rect, Rect rect2, boolean bl, boolean bl2) {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(ninePatch, rect, rect2, bl, bl2);
        }

        public NinePatchState(NinePatch ninePatch, Rect rect, Rect rect2, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(android.graphics.NinePatch android.graphics.Rect android.graphics.Rect boolean boolean ), this, ninePatch, rect, rect2, bl, bl2);
        }

        private void __constructor__(NinePatchState ninePatchState) {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(ninePatchState);
        }

        public NinePatchState(NinePatchState ninePatchState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(android.graphics.drawable.NinePatchDrawable$NinePatchState ), this, ninePatchState);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$canApplyTheme(), this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable(), this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable(android.content.res.Resources ), this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$getChangingConfigurations(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NinePatchState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

