/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.SystemClock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TransitionDrawable
extends LayerDrawable
implements Drawable.Callback,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int TRANSITION_STARTING = 0;
    private static int TRANSITION_RUNNING = 1;
    private static int TRANSITION_NONE = 2;
    private int mTransitionState;
    private boolean mReverse;
    private long mStartTimeMillis;
    private int mFrom;
    private int mTo;
    private int mDuration;
    private int mOriginalDuration;
    private int mAlpha;
    private boolean mCrossFade;

    private void $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(Drawable[] layers) {
    }

    private void $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(TransitionState state, Resources res) {
        this.mTransitionState = 2;
        this.mAlpha = 0;
    }

    private void $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(TransitionState state, Drawable[] layers) {
        this.mTransitionState = 2;
        this.mAlpha = 0;
    }

    private final LayerDrawable.LayerState $$robo$$android_graphics_drawable_TransitionDrawable$createConstantState(LayerDrawable.LayerState state, Resources res) {
        return new TransitionState((TransitionState)state, this, res);
    }

    private final void $$robo$$android_graphics_drawable_TransitionDrawable$startTransition(int durationMillis) {
        this.mFrom = 0;
        this.mTo = 255;
        this.mAlpha = 0;
        this.mDuration = this.mOriginalDuration = durationMillis;
        this.mReverse = false;
        this.mTransitionState = 0;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_TransitionDrawable$showSecondLayer() {
        this.mAlpha = 255;
        this.mReverse = false;
        this.mTransitionState = 2;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_TransitionDrawable$resetTransition() {
        this.mAlpha = 0;
        this.mTransitionState = 2;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_TransitionDrawable$reverseTransition(int duration) {
        long time = SystemClock.uptimeMillis();
        if (time - this.mStartTimeMillis > (long)this.mDuration) {
            if (this.mTo == 0) {
                this.mFrom = 0;
                this.mTo = 255;
                this.mAlpha = 0;
                this.mReverse = false;
            } else {
                this.mFrom = 255;
                this.mTo = 0;
                this.mAlpha = 255;
                this.mReverse = true;
            }
            this.mDuration = this.mOriginalDuration = duration;
            this.mTransitionState = 0;
            this.invalidateSelf();
            return;
        }
        this.mReverse = !this.mReverse;
        this.mFrom = this.mAlpha;
        this.mTo = this.mReverse ? 0 : 255;
        this.mDuration = (int)(this.mReverse ? time - this.mStartTimeMillis : (long)this.mOriginalDuration - (time - this.mStartTimeMillis));
        this.mTransitionState = 0;
    }

    private final void $$robo$$android_graphics_drawable_TransitionDrawable$draw(Canvas canvas) {
        boolean done = true;
        switch (this.mTransitionState) {
            case 0: {
                this.mStartTimeMillis = SystemClock.uptimeMillis();
                done = false;
                this.mTransitionState = 1;
                break;
            }
            case 1: {
                if (this.mStartTimeMillis < 0L) break;
                float normalized = (float)(SystemClock.uptimeMillis() - this.mStartTimeMillis) / (float)this.mDuration;
                done = normalized >= 1.0f;
                normalized = Math.min(normalized, 1.0f);
                this.mAlpha = (int)((float)this.mFrom + (float)(this.mTo - this.mFrom) * normalized);
            }
        }
        int alpha = this.mAlpha;
        boolean crossFade = this.mCrossFade;
        LayerDrawable.ChildDrawable[] array2 = this.mLayerState.mChildren;
        if (done) {
            if (!crossFade || alpha == 0) {
                array2[0].mDrawable.draw(canvas);
            }
            if (alpha == 255) {
                array2[1].mDrawable.draw(canvas);
            }
            return;
        }
        Drawable d = array2[0].mDrawable;
        if (crossFade) {
            d.setAlpha(255 - alpha);
        }
        d.draw(canvas);
        if (crossFade) {
            d.setAlpha(255);
        }
        if (alpha > 0) {
            d = array2[1].mDrawable;
            d.setAlpha(alpha);
            d.draw(canvas);
            d.setAlpha(255);
        }
        if (!done) {
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_TransitionDrawable$setCrossFadeEnabled(boolean enabled) {
        this.mCrossFade = enabled;
    }

    private final boolean $$robo$$android_graphics_drawable_TransitionDrawable$isCrossFadeEnabled() {
        return this.mCrossFade;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(TransitionState x0, Resources x1, 1 x2) {
    }

    private void __constructor__(Drawable[] drawableArray) {
        this.$$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(drawableArray);
    }

    public TransitionDrawable(Drawable[] drawableArray) {
        this(new TransitionState(null, null, null), drawableArray);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(android.graphics.drawable.Drawable[] ), this, drawableArray);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_TransitionDrawable$__constructor__();
    }

    public TransitionDrawable() {
        this(new TransitionState(null, null, null), (Resources)null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(), this);
    }

    private void __constructor__(TransitionState transitionState, Resources resources) {
        this.$$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(transitionState, resources);
    }

    public TransitionDrawable(TransitionState transitionState, Resources resources) {
        super(transitionState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(android.graphics.drawable.TransitionDrawable$TransitionState android.content.res.Resources ), this, transitionState, resources);
    }

    private void __constructor__(TransitionState transitionState, Drawable[] drawableArray) {
        this.$$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(transitionState, drawableArray);
    }

    public TransitionDrawable(TransitionState transitionState, Drawable[] drawableArray) {
        super(drawableArray, transitionState);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(android.graphics.drawable.TransitionDrawable$TransitionState android.graphics.drawable.Drawable[] ), this, transitionState, drawableArray);
    }

    @Override
    LayerDrawable.LayerState createConstantState(LayerDrawable.LayerState layerState, Resources resources) {
        return InvokeDynamicSupport.bootstrap("createConstantState", $$robo$$android_graphics_drawable_TransitionDrawable$createConstantState(android.graphics.drawable.LayerDrawable$LayerState android.content.res.Resources ), this, layerState, resources);
    }

    public void startTransition(int n) {
        InvokeDynamicSupport.bootstrap("startTransition", $$robo$$android_graphics_drawable_TransitionDrawable$startTransition(int ), this, n);
    }

    public void showSecondLayer() {
        InvokeDynamicSupport.bootstrap("showSecondLayer", $$robo$$android_graphics_drawable_TransitionDrawable$showSecondLayer(), this);
    }

    public void resetTransition() {
        InvokeDynamicSupport.bootstrap("resetTransition", $$robo$$android_graphics_drawable_TransitionDrawable$resetTransition(), this);
    }

    public void reverseTransition(int n) {
        InvokeDynamicSupport.bootstrap("reverseTransition", $$robo$$android_graphics_drawable_TransitionDrawable$reverseTransition(int ), this, n);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_TransitionDrawable$draw(android.graphics.Canvas ), this, canvas);
    }

    public void setCrossFadeEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCrossFadeEnabled", $$robo$$android_graphics_drawable_TransitionDrawable$setCrossFadeEnabled(boolean ), this, bl);
    }

    public boolean isCrossFadeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCrossFadeEnabled", $$robo$$android_graphics_drawable_TransitionDrawable$isCrossFadeEnabled(), this);
    }

    private /* synthetic */ void __constructor__(TransitionState transitionState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(transitionState, resources, var3_3);
    }

    public /* synthetic */ TransitionDrawable(TransitionState transitionState, Resources resources, 1 var3_3) {
        this(transitionState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_TransitionDrawable$__constructor__(android.graphics.drawable.TransitionDrawable$TransitionState android.content.res.Resources android.graphics.drawable.TransitionDrawable$1 ), this, transitionState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransitionDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TransitionState
    extends LayerDrawable.LayerState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$__constructor__(TransitionState orig, TransitionDrawable owner, Resources res) {
        }

        private final Drawable $$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$newDrawable() {
            return new TransitionDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$newDrawable(Resources res) {
            return new TransitionDrawable(this, res, null);
        }

        private final int $$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private void __constructor__(TransitionState transitionState, TransitionDrawable transitionDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$__constructor__(transitionState, transitionDrawable, resources);
        }

        public TransitionState(TransitionState transitionState, TransitionDrawable transitionDrawable, Resources resources) {
            super(transitionState, transitionDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$__constructor__(android.graphics.drawable.TransitionDrawable$TransitionState android.graphics.drawable.TransitionDrawable android.content.res.Resources ), this, transitionState, transitionDrawable, resources);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$newDrawable(), this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$newDrawable(android.content.res.Resources ), this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_TransitionDrawable_TransitionState$getChangingConfigurations(), this);
        }

        public /* synthetic */ TransitionState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransitionState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

