/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.pdf.PdfRenderer;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PdfEditor
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private CloseGuard mCloseGuard;
    private long mNativeDocument;
    private int mPageCount;
    private ParcelFileDescriptor mInput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_graphics_pdf_PdfEditor$__constructor__(ParcelFileDescriptor input) throws IOException {
        long size;
        this.mCloseGuard = CloseGuard.get();
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Os.lseek(input.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            size = Os.fstat((FileDescriptor)input.getFileDescriptor()).st_size;
        }
        catch (ErrnoException ee) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mInput = input;
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            this.mNativeDocument = PdfEditor.nativeOpen(this.mInput.getFd(), size);
            try {
                this.mPageCount = PdfEditor.nativeGetPageCount(this.mNativeDocument);
            }
            catch (Throwable t) {
                PdfEditor.nativeClose(this.mNativeDocument);
                this.mNativeDocument = 0L;
                throw t;
            }
        }
        this.mCloseGuard.open("close");
    }

    private final int $$robo$$android_graphics_pdf_PdfEditor$getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$removePage(int pageIndex) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(pageIndex);
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            this.mPageCount = PdfEditor.nativeRemovePage(this.mNativeDocument, pageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$setTransformAndClip(int pageIndex, Matrix transform, Rect clip) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(pageIndex);
        this.throwIfNotNullAndNotAfine(transform);
        if (transform == null) {
            transform = Matrix.IDENTITY_MATRIX;
        }
        if (clip == null) {
            Point size = new Point();
            this.getPageSize(pageIndex, size);
            Object object = PdfRenderer.sPdfiumLock;
            synchronized (object) {
                PdfEditor.nativeSetTransformAndClip(this.mNativeDocument, pageIndex, transform.native_instance, 0, 0, size.x, size.y);
            }
        }
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            PdfEditor.nativeSetTransformAndClip(this.mNativeDocument, pageIndex, transform.native_instance, clip.left, clip.top, clip.right, clip.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$getPageSize(int pageIndex, Point outSize) {
        this.throwIfClosed();
        this.throwIfOutSizeNull(outSize);
        this.throwIfPageNotInDocument(pageIndex);
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            PdfEditor.nativeGetPageSize(this.mNativeDocument, pageIndex, outSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_graphics_pdf_PdfEditor$getPageMediaBox(int pageIndex, Rect outMediaBox) {
        this.throwIfClosed();
        this.throwIfOutMediaBoxNull(outMediaBox);
        this.throwIfPageNotInDocument(pageIndex);
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            return PdfEditor.nativeGetPageMediaBox(this.mNativeDocument, pageIndex, outMediaBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$setPageMediaBox(int pageIndex, Rect mediaBox) {
        this.throwIfClosed();
        this.throwIfMediaBoxNull(mediaBox);
        this.throwIfPageNotInDocument(pageIndex);
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            PdfEditor.nativeSetPageMediaBox(this.mNativeDocument, pageIndex, mediaBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_graphics_pdf_PdfEditor$getPageCropBox(int pageIndex, Rect outCropBox) {
        this.throwIfClosed();
        this.throwIfOutCropBoxNull(outCropBox);
        this.throwIfPageNotInDocument(pageIndex);
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            return PdfEditor.nativeGetPageCropBox(this.mNativeDocument, pageIndex, outCropBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$setPageCropBox(int pageIndex, Rect cropBox) {
        this.throwIfClosed();
        this.throwIfCropBoxNull(cropBox);
        this.throwIfPageNotInDocument(pageIndex);
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            PdfEditor.nativeSetPageCropBox(this.mNativeDocument, pageIndex, cropBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_graphics_pdf_PdfEditor$shouldScaleForPrinting() {
        this.throwIfClosed();
        Object object = PdfRenderer.sPdfiumLock;
        synchronized (object) {
            return PdfEditor.nativeScaleForPrinting(this.mNativeDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$write(ParcelFileDescriptor output) throws IOException {
        try {
            this.throwIfClosed();
            Object object = PdfRenderer.sPdfiumLock;
            synchronized (object) {
                PdfEditor.nativeWrite(this.mNativeDocument, output.getFd());
            }
        }
        finally {
            IoUtils.closeQuietly(output);
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$close() {
        this.throwIfClosed();
        this.doClose();
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.doClose();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$doClose() {
        if (this.mNativeDocument != 0L) {
            Object object = PdfRenderer.sPdfiumLock;
            synchronized (object) {
                PdfEditor.nativeClose(this.mNativeDocument);
            }
            this.mNativeDocument = 0L;
        }
        if (this.mInput != null) {
            IoUtils.closeQuietly(this.mInput);
            this.mInput = null;
        }
        this.mCloseGuard.close();
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfPageNotInDocument(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfNotNullAndNotAfine(Matrix matrix) {
        if (matrix != null && !matrix.isAffine()) {
            throw new IllegalStateException("Matrix must be afine");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfOutSizeNull(Point outSize) {
        if (outSize == null) {
            throw new NullPointerException("outSize cannot be null");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfOutMediaBoxNull(Rect outMediaBox) {
        if (outMediaBox == null) {
            throw new NullPointerException("outMediaBox cannot be null");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfMediaBoxNull(Rect mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox cannot be null");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfOutCropBoxNull(Rect outCropBox) {
        if (outCropBox == null) {
            throw new NullPointerException("outCropBox cannot be null");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfCropBoxNull(Rect cropBox) {
        if (cropBox == null) {
            throw new NullPointerException("cropBox cannot be null");
        }
    }

    private static final long $$robo$$android_graphics_pdf_PdfEditor$nativeOpen(int n, long l) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeClose(long l) {
    }

    private static final int $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCount(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_pdf_PdfEditor$nativeRemovePage(long l, int n) {
        return 0;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeWrite(long l, int n) {
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeSetTransformAndClip(long l, int n, long l2, int n2, int n3, int n4, int n5) {
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageSize(long l, int n, Point point) {
    }

    private static final boolean $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageMediaBox(long l, int n, Rect rect) {
        return false;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeSetPageMediaBox(long l, int n, Rect rect) {
    }

    private static final boolean $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCropBox(long l, int n, Rect rect) {
        return false;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeSetPageCropBox(long l, int n, Rect rect) {
    }

    private static final boolean $$robo$$android_graphics_pdf_PdfEditor$nativeScaleForPrinting(long l) {
        return false;
    }

    private void __constructor__(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.$$robo$$android_graphics_pdf_PdfEditor$__constructor__(parcelFileDescriptor);
    }

    public PdfEditor(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfEditor$__constructor__(android.os.ParcelFileDescriptor ), this, parcelFileDescriptor);
    }

    public int getPageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPageCount", $$robo$$android_graphics_pdf_PdfEditor$getPageCount(), this);
    }

    public void removePage(int n) {
        InvokeDynamicSupport.bootstrap("removePage", $$robo$$android_graphics_pdf_PdfEditor$removePage(int ), this, n);
    }

    public void setTransformAndClip(int n, Matrix matrix, Rect rect) {
        InvokeDynamicSupport.bootstrap("setTransformAndClip", $$robo$$android_graphics_pdf_PdfEditor$setTransformAndClip(int android.graphics.Matrix android.graphics.Rect ), this, n, matrix, rect);
    }

    public void getPageSize(int n, Point point) {
        InvokeDynamicSupport.bootstrap("getPageSize", $$robo$$android_graphics_pdf_PdfEditor$getPageSize(int android.graphics.Point ), this, n, point);
    }

    public boolean getPageMediaBox(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPageMediaBox", $$robo$$android_graphics_pdf_PdfEditor$getPageMediaBox(int android.graphics.Rect ), this, n, rect);
    }

    public void setPageMediaBox(int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("setPageMediaBox", $$robo$$android_graphics_pdf_PdfEditor$setPageMediaBox(int android.graphics.Rect ), this, n, rect);
    }

    public boolean getPageCropBox(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPageCropBox", $$robo$$android_graphics_pdf_PdfEditor$getPageCropBox(int android.graphics.Rect ), this, n, rect);
    }

    public void setPageCropBox(int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("setPageCropBox", $$robo$$android_graphics_pdf_PdfEditor$setPageCropBox(int android.graphics.Rect ), this, n, rect);
    }

    public boolean shouldScaleForPrinting() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldScaleForPrinting", $$robo$$android_graphics_pdf_PdfEditor$shouldScaleForPrinting(), this);
    }

    public void write(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$android_graphics_pdf_PdfEditor$write(android.os.ParcelFileDescriptor ), this, parcelFileDescriptor);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_pdf_PdfEditor$close(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_pdf_PdfEditor$finalize(), this);
    }

    private void doClose() {
        InvokeDynamicSupport.bootstrap("doClose", $$robo$$android_graphics_pdf_PdfEditor$doClose(), this);
    }

    private void throwIfClosed() {
        InvokeDynamicSupport.bootstrap("throwIfClosed", $$robo$$android_graphics_pdf_PdfEditor$throwIfClosed(), this);
    }

    private void throwIfPageNotInDocument(int n) {
        InvokeDynamicSupport.bootstrap("throwIfPageNotInDocument", $$robo$$android_graphics_pdf_PdfEditor$throwIfPageNotInDocument(int ), this, n);
    }

    private void throwIfNotNullAndNotAfine(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("throwIfNotNullAndNotAfine", $$robo$$android_graphics_pdf_PdfEditor$throwIfNotNullAndNotAfine(android.graphics.Matrix ), this, matrix);
    }

    private void throwIfOutSizeNull(Point point) {
        InvokeDynamicSupport.bootstrap("throwIfOutSizeNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfOutSizeNull(android.graphics.Point ), this, point);
    }

    private void throwIfOutMediaBoxNull(Rect rect) {
        InvokeDynamicSupport.bootstrap("throwIfOutMediaBoxNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfOutMediaBoxNull(android.graphics.Rect ), this, rect);
    }

    private void throwIfMediaBoxNull(Rect rect) {
        InvokeDynamicSupport.bootstrap("throwIfMediaBoxNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfMediaBoxNull(android.graphics.Rect ), this, rect);
    }

    private void throwIfOutCropBoxNull(Rect rect) {
        InvokeDynamicSupport.bootstrap("throwIfOutCropBoxNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfOutCropBoxNull(android.graphics.Rect ), this, rect);
    }

    private void throwIfCropBoxNull(Rect rect) {
        InvokeDynamicSupport.bootstrap("throwIfCropBoxNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfCropBoxNull(android.graphics.Rect ), this, rect);
    }

    private static long nativeOpen(int n, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpen", $$robo$$android_graphics_pdf_PdfEditor$nativeOpen(int long ), (int)n, (long)l);
    }

    private static void nativeClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClose", $$robo$$android_graphics_pdf_PdfEditor$nativeClose(long ), (long)l);
    }

    private static int nativeGetPageCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetPageCount", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCount(long ), (long)l);
    }

    private static int nativeRemovePage(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeRemovePage", $$robo$$android_graphics_pdf_PdfEditor$nativeRemovePage(long int ), (long)l, (int)n);
    }

    private static void nativeWrite(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeWrite", $$robo$$android_graphics_pdf_PdfEditor$nativeWrite(long int ), (long)l, (int)n);
    }

    private static void nativeSetTransformAndClip(long l, int n, long l2, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetTransformAndClip", $$robo$$android_graphics_pdf_PdfEditor$nativeSetTransformAndClip(long int long int int int int ), (long)l, (int)n, (long)l2, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    private static void nativeGetPageSize(long l, int n, Point point) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetPageSize", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageSize(long int android.graphics.Point ), (long)l, (int)n, (Point)point);
    }

    private static boolean nativeGetPageMediaBox(long l, int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeGetPageMediaBox", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageMediaBox(long int android.graphics.Rect ), (long)l, (int)n, (Rect)rect);
    }

    private static void nativeSetPageMediaBox(long l, int n, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPageMediaBox", $$robo$$android_graphics_pdf_PdfEditor$nativeSetPageMediaBox(long int android.graphics.Rect ), (long)l, (int)n, (Rect)rect);
    }

    private static boolean nativeGetPageCropBox(long l, int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeGetPageCropBox", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCropBox(long int android.graphics.Rect ), (long)l, (int)n, (Rect)rect);
    }

    private static void nativeSetPageCropBox(long l, int n, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPageCropBox", $$robo$$android_graphics_pdf_PdfEditor$nativeSetPageCropBox(long int android.graphics.Rect ), (long)l, (int)n, (Rect)rect);
    }

    private static boolean nativeScaleForPrinting(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeScaleForPrinting", $$robo$$android_graphics_pdf_PdfEditor$nativeScaleForPrinting(long ), (long)l);
    }

    public /* synthetic */ PdfEditor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PdfEditor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

