/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.graphics.Rect;
import android.hardware.camera2.CameraMetadata;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.PublicKey;
import android.hardware.camera2.impl.SyntheticKey;
import android.hardware.camera2.params.ColorSpaceTransform;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.RggbChannelVector;
import android.hardware.camera2.params.TonemapCurve;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.SurfaceUtils;
import android.hardware.camera2.utils.TypeReference;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SparseArray;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CaptureRequest
extends CameraMetadata<Key<?>>
implements Parcelable {
    public /* synthetic */ Object __robo_data__;
    private String TAG = "CaptureRequest-JV";
    private ArraySet<Surface> mSurfaceSet;
    private Object mSurfacesLock;
    private boolean mSurfaceConverted;
    private int[] mStreamIdxArray;
    private int[] mSurfaceIdxArray;
    private static ArraySet<Surface> mEmptySurfaceSet;
    private String mLogicalCameraId;
    private CameraMetadataNative mLogicalCameraSettings;
    private HashMap<String, CameraMetadataNative> mPhysicalCameraSettings;
    private boolean mIsReprocess;
    private boolean mIsPartOfCHSRequestList;
    private int mReprocessableSessionId;
    private Object mUserTag;
    public static Parcelable.Creator<CaptureRequest> CREATOR;
    @PublicKey
    public static Key<Integer> COLOR_CORRECTION_MODE;
    @PublicKey
    public static Key<ColorSpaceTransform> COLOR_CORRECTION_TRANSFORM;
    @PublicKey
    public static Key<RggbChannelVector> COLOR_CORRECTION_GAINS;
    @PublicKey
    public static Key<Integer> COLOR_CORRECTION_ABERRATION_MODE;
    @PublicKey
    public static Key<Integer> CONTROL_AE_ANTIBANDING_MODE;
    @PublicKey
    public static Key<Integer> CONTROL_AE_EXPOSURE_COMPENSATION;
    @PublicKey
    public static Key<Boolean> CONTROL_AE_LOCK;
    @PublicKey
    public static Key<Integer> CONTROL_AE_MODE;
    @PublicKey
    public static Key<MeteringRectangle[]> CONTROL_AE_REGIONS;
    @PublicKey
    public static Key<Range<Integer>> CONTROL_AE_TARGET_FPS_RANGE;
    @PublicKey
    public static Key<Integer> CONTROL_AE_PRECAPTURE_TRIGGER;
    @PublicKey
    public static Key<Integer> CONTROL_AF_MODE;
    @PublicKey
    public static Key<MeteringRectangle[]> CONTROL_AF_REGIONS;
    @PublicKey
    public static Key<Integer> CONTROL_AF_TRIGGER;
    @PublicKey
    public static Key<Boolean> CONTROL_AWB_LOCK;
    @PublicKey
    public static Key<Integer> CONTROL_AWB_MODE;
    @PublicKey
    public static Key<MeteringRectangle[]> CONTROL_AWB_REGIONS;
    @PublicKey
    public static Key<Integer> CONTROL_CAPTURE_INTENT;
    @PublicKey
    public static Key<Integer> CONTROL_EFFECT_MODE;
    @PublicKey
    public static Key<Integer> CONTROL_MODE;
    @PublicKey
    public static Key<Integer> CONTROL_SCENE_MODE;
    @PublicKey
    public static Key<Integer> CONTROL_VIDEO_STABILIZATION_MODE;
    @PublicKey
    public static Key<Integer> CONTROL_POST_RAW_SENSITIVITY_BOOST;
    @PublicKey
    public static Key<Boolean> CONTROL_ENABLE_ZSL;
    @PublicKey
    public static Key<Integer> EDGE_MODE;
    @PublicKey
    public static Key<Integer> FLASH_MODE;
    @PublicKey
    public static Key<Integer> HOT_PIXEL_MODE;
    @PublicKey
    @SyntheticKey
    public static Key<Location> JPEG_GPS_LOCATION;
    public static Key<double[]> JPEG_GPS_COORDINATES;
    public static Key<String> JPEG_GPS_PROCESSING_METHOD;
    public static Key<Long> JPEG_GPS_TIMESTAMP;
    @PublicKey
    public static Key<Integer> JPEG_ORIENTATION;
    @PublicKey
    public static Key<Byte> JPEG_QUALITY;
    @PublicKey
    public static Key<Byte> JPEG_THUMBNAIL_QUALITY;
    @PublicKey
    public static Key<Size> JPEG_THUMBNAIL_SIZE;
    @PublicKey
    public static Key<Float> LENS_APERTURE;
    @PublicKey
    public static Key<Float> LENS_FILTER_DENSITY;
    @PublicKey
    public static Key<Float> LENS_FOCAL_LENGTH;
    @PublicKey
    public static Key<Float> LENS_FOCUS_DISTANCE;
    @PublicKey
    public static Key<Integer> LENS_OPTICAL_STABILIZATION_MODE;
    @PublicKey
    public static Key<Integer> NOISE_REDUCTION_MODE;
    public static Key<Integer> REQUEST_ID;
    @PublicKey
    public static Key<Rect> SCALER_CROP_REGION;
    @PublicKey
    public static Key<Long> SENSOR_EXPOSURE_TIME;
    @PublicKey
    public static Key<Long> SENSOR_FRAME_DURATION;
    @PublicKey
    public static Key<Integer> SENSOR_SENSITIVITY;
    @PublicKey
    public static Key<int[]> SENSOR_TEST_PATTERN_DATA;
    @PublicKey
    public static Key<Integer> SENSOR_TEST_PATTERN_MODE;
    @PublicKey
    public static Key<Integer> SHADING_MODE;
    @PublicKey
    public static Key<Integer> STATISTICS_FACE_DETECT_MODE;
    @PublicKey
    public static Key<Boolean> STATISTICS_HOT_PIXEL_MAP_MODE;
    @PublicKey
    public static Key<Integer> STATISTICS_LENS_SHADING_MAP_MODE;
    @PublicKey
    public static Key<Integer> STATISTICS_OIS_DATA_MODE;
    public static Key<float[]> TONEMAP_CURVE_BLUE;
    public static Key<float[]> TONEMAP_CURVE_GREEN;
    public static Key<float[]> TONEMAP_CURVE_RED;
    @PublicKey
    @SyntheticKey
    public static Key<TonemapCurve> TONEMAP_CURVE;
    @PublicKey
    public static Key<Integer> TONEMAP_MODE;
    @PublicKey
    public static Key<Float> TONEMAP_GAMMA;
    @PublicKey
    public static Key<Integer> TONEMAP_PRESET_CURVE;
    public static Key<Boolean> LED_TRANSMIT;
    @PublicKey
    public static Key<Boolean> BLACK_LEVEL_LOCK;
    @PublicKey
    public static Key<Float> REPROCESS_EFFECTIVE_EXPOSURE_FACTOR;
    @PublicKey
    public static Key<Integer> DISTORTION_CORRECTION_MODE;

    private void $$robo$$android_hardware_camera2_CaptureRequest$__constructor__() {
        this.TAG = "CaptureRequest-JV";
        this.mSurfaceSet = new ArraySet();
        this.mSurfacesLock = new Object();
        this.mSurfaceConverted = false;
        this.mPhysicalCameraSettings = new HashMap();
        this.mIsPartOfCHSRequestList = false;
        this.mIsReprocess = false;
        this.mReprocessableSessionId = -1;
    }

    private void $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(CaptureRequest source) {
        this.TAG = "CaptureRequest-JV";
        this.mSurfaceSet = new ArraySet();
        this.mSurfacesLock = new Object();
        this.mSurfaceConverted = false;
        this.mPhysicalCameraSettings = new HashMap();
        this.mIsPartOfCHSRequestList = false;
        this.mLogicalCameraId = new String(source.mLogicalCameraId);
        for (Map.Entry<String, CameraMetadataNative> entry : source.mPhysicalCameraSettings.entrySet()) {
            this.mPhysicalCameraSettings.put(new String(entry.getKey()), new CameraMetadataNative(entry.getValue()));
        }
        this.mLogicalCameraSettings = this.mPhysicalCameraSettings.get(this.mLogicalCameraId);
        this.setNativeInstance(this.mLogicalCameraSettings);
        this.mSurfaceSet.addAll(source.mSurfaceSet);
        this.mIsReprocess = source.mIsReprocess;
        this.mIsPartOfCHSRequestList = source.mIsPartOfCHSRequestList;
        this.mReprocessableSessionId = source.mReprocessableSessionId;
        this.mUserTag = source.mUserTag;
    }

    private void $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(CameraMetadataNative settings, boolean isReprocess, int reprocessableSessionId, String logicalCameraId, Set<String> physicalCameraIdSet) {
        this.TAG = "CaptureRequest-JV";
        this.mSurfaceSet = new ArraySet();
        this.mSurfacesLock = new Object();
        this.mSurfaceConverted = false;
        this.mPhysicalCameraSettings = new HashMap();
        this.mIsPartOfCHSRequestList = false;
        if (physicalCameraIdSet != null && isReprocess) {
            throw new IllegalArgumentException("Create a reprocess capture request with with more than one physical camera is not supported!");
        }
        this.mLogicalCameraId = logicalCameraId;
        this.mLogicalCameraSettings = CameraMetadataNative.move(settings);
        this.mPhysicalCameraSettings.put(this.mLogicalCameraId, this.mLogicalCameraSettings);
        if (physicalCameraIdSet != null) {
            for (String physicalId : physicalCameraIdSet) {
                this.mPhysicalCameraSettings.put(physicalId, new CameraMetadataNative(this.mLogicalCameraSettings));
            }
        }
        this.setNativeInstance(this.mLogicalCameraSettings);
        this.mIsReprocess = isReprocess;
        if (isReprocess) {
            if (reprocessableSessionId == -1) {
                throw new IllegalArgumentException("Create a reprocess capture request with an invalid session ID: " + reprocessableSessionId);
            }
            this.mReprocessableSessionId = reprocessableSessionId;
        } else {
            this.mReprocessableSessionId = -1;
        }
    }

    private final <T> T $$robo$$android_hardware_camera2_CaptureRequest$get(Key<T> key) {
        return this.mLogicalCameraSettings.get(key);
    }

    private final <T> T $$robo$$android_hardware_camera2_CaptureRequest$getProtected(Key<?> key) {
        return (T)this.mLogicalCameraSettings.get(key);
    }

    private final Class<Key<?>> $$robo$$android_hardware_camera2_CaptureRequest$getKeyClass() {
        Class<Key> thisClass = Key.class;
        return thisClass;
    }

    private final List<Key<?>> $$robo$$android_hardware_camera2_CaptureRequest$getKeys() {
        return super.getKeys();
    }

    private final Object $$robo$$android_hardware_camera2_CaptureRequest$getTag() {
        return this.mUserTag;
    }

    private final boolean $$robo$$android_hardware_camera2_CaptureRequest$isReprocess() {
        return this.mIsReprocess;
    }

    private final boolean $$robo$$android_hardware_camera2_CaptureRequest$isPartOfCRequestList() {
        return this.mIsPartOfCHSRequestList;
    }

    private final CameraMetadataNative $$robo$$android_hardware_camera2_CaptureRequest$getNativeCopy() {
        return new CameraMetadataNative(this.mLogicalCameraSettings);
    }

    private final int $$robo$$android_hardware_camera2_CaptureRequest$getReprocessableSessionId() {
        if (!this.mIsReprocess || this.mReprocessableSessionId == -1) {
            throw new IllegalStateException("Getting the reprocessable session ID for a non-reprocess capture request is illegal.");
        }
        return this.mReprocessableSessionId;
    }

    private final boolean $$robo$$android_hardware_camera2_CaptureRequest$equals(Object other) {
        return other instanceof CaptureRequest && this.equals((CaptureRequest)other);
    }

    private final boolean $$robo$$android_hardware_camera2_CaptureRequest$equals(CaptureRequest other) {
        return other != null && Objects.equals(this.mUserTag, other.mUserTag) && this.mSurfaceSet.equals(other.mSurfaceSet) && this.mPhysicalCameraSettings.equals(other.mPhysicalCameraSettings) && this.mLogicalCameraId.equals(other.mLogicalCameraId) && this.mLogicalCameraSettings.equals(other.mLogicalCameraSettings) && this.mIsReprocess == other.mIsReprocess && this.mReprocessableSessionId == other.mReprocessableSessionId;
    }

    private final int $$robo$$android_hardware_camera2_CaptureRequest$hashCode() {
        return HashCodeHelpers.hashCodeGeneric(this.mPhysicalCameraSettings, this.mSurfaceSet, this.mUserTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_CaptureRequest$readFromParcel(Parcel in) {
        int physicalCameraCount = in.readInt();
        if (physicalCameraCount <= 0) {
            throw new RuntimeException("Physical camera count" + physicalCameraCount + " should always be positive");
        }
        this.mLogicalCameraId = in.readString();
        this.mLogicalCameraSettings = new CameraMetadataNative();
        this.mLogicalCameraSettings.readFromParcel(in);
        this.setNativeInstance(this.mLogicalCameraSettings);
        this.mPhysicalCameraSettings.put(this.mLogicalCameraId, this.mLogicalCameraSettings);
        for (int i = 1; i < physicalCameraCount; ++i) {
            String physicalId = in.readString();
            Parcelable[] physicalCameraSettings = new CameraMetadataNative();
            physicalCameraSettings.readFromParcel(in);
            this.mPhysicalCameraSettings.put(physicalId, (CameraMetadataNative)physicalCameraSettings);
        }
        this.mIsReprocess = in.readInt() != 0;
        this.mReprocessableSessionId = -1;
        Object object = this.mSurfacesLock;
        synchronized (object) {
            int streamSurfaceSize;
            this.mSurfaceSet.clear();
            Parcelable[] parcelableArray = in.readParcelableArray(Surface.class.getClassLoader());
            if (parcelableArray != null) {
                for (Parcelable p : parcelableArray) {
                    Surface s = (Surface)p;
                    this.mSurfaceSet.add(s);
                }
            }
            if ((streamSurfaceSize = in.readInt()) != 0) {
                throw new RuntimeException("Reading cached CaptureRequest is not supported");
            }
        }
    }

    private final int $$robo$$android_hardware_camera2_CaptureRequest$describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_CaptureRequest$writeToParcel(Parcel dest, int flags) {
        int physicalCameraCount = this.mPhysicalCameraSettings.size();
        dest.writeInt(physicalCameraCount);
        dest.writeString(this.mLogicalCameraId);
        this.mLogicalCameraSettings.writeToParcel(dest, flags);
        for (Map.Entry<String, CameraMetadataNative> entry : this.mPhysicalCameraSettings.entrySet()) {
            if (entry.getKey().equals(this.mLogicalCameraId)) continue;
            dest.writeString(entry.getKey());
            entry.getValue().writeToParcel(dest, flags);
        }
        dest.writeInt(this.mIsReprocess ? 1 : 0);
        Object object = this.mSurfacesLock;
        synchronized (object) {
            ArraySet<Surface> surfaces = this.mSurfaceConverted ? mEmptySurfaceSet : this.mSurfaceSet;
            dest.writeParcelableArray(surfaces.toArray(new Surface[surfaces.size()]), flags);
            if (this.mSurfaceConverted) {
                dest.writeInt(this.mStreamIdxArray.length);
                for (int i = 0; i < this.mStreamIdxArray.length; ++i) {
                    dest.writeInt(this.mStreamIdxArray[i]);
                    dest.writeInt(this.mSurfaceIdxArray[i]);
                }
            } else {
                dest.writeInt(0);
            }
        }
    }

    private final boolean $$robo$$android_hardware_camera2_CaptureRequest$containsTarget(Surface surface) {
        return this.mSurfaceSet.contains(surface);
    }

    private final Collection<Surface> $$robo$$android_hardware_camera2_CaptureRequest$getTargets() {
        return Collections.unmodifiableCollection(this.mSurfaceSet);
    }

    private final String $$robo$$android_hardware_camera2_CaptureRequest$getLogicalCameraId() {
        return this.mLogicalCameraId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_CaptureRequest$convertSurfaceToStreamId(SparseArray<OutputConfiguration> configuredOutputs) {
        Object object = this.mSurfacesLock;
        synchronized (object) {
            if (this.mSurfaceConverted) {
                Log.v("CaptureRequest-JV", "Cannot convert already converted surfaces!");
                return;
            }
            this.mStreamIdxArray = new int[this.mSurfaceSet.size()];
            this.mSurfaceIdxArray = new int[this.mSurfaceSet.size()];
            int i = 0;
            for (Surface s : this.mSurfaceSet) {
                boolean streamFound = false;
                for (int j = 0; j < configuredOutputs.size(); ++j) {
                    int streamId = configuredOutputs.keyAt(j);
                    OutputConfiguration outConfig = configuredOutputs.valueAt(j);
                    int surfaceId = 0;
                    for (Surface outSurface : outConfig.getSurfaces()) {
                        if (s == outSurface) {
                            streamFound = true;
                            this.mStreamIdxArray[i] = streamId;
                            this.mSurfaceIdxArray[i] = surfaceId;
                            ++i;
                            break;
                        }
                        ++surfaceId;
                    }
                    if (streamFound) break;
                }
                if (!streamFound) {
                    long reqSurfaceId = SurfaceUtils.getSurfaceId(s);
                    for (int j = 0; j < configuredOutputs.size(); ++j) {
                        int streamId = configuredOutputs.keyAt(j);
                        OutputConfiguration outConfig = configuredOutputs.valueAt(j);
                        int surfaceId = 0;
                        for (Surface outSurface : outConfig.getSurfaces()) {
                            if (reqSurfaceId == SurfaceUtils.getSurfaceId(outSurface)) {
                                streamFound = true;
                                this.mStreamIdxArray[i] = streamId;
                                this.mSurfaceIdxArray[i] = surfaceId;
                                ++i;
                                break;
                            }
                            ++surfaceId;
                        }
                        if (streamFound) break;
                    }
                }
                if (streamFound) continue;
                this.mStreamIdxArray = null;
                this.mSurfaceIdxArray = null;
                throw new IllegalArgumentException("CaptureRequest contains unconfigured Input/Output Surface!");
            }
            this.mSurfaceConverted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_CaptureRequest$recoverStreamIdToSurface() {
        Object object = this.mSurfacesLock;
        synchronized (object) {
            if (!this.mSurfaceConverted) {
                Log.v("CaptureRequest-JV", "Cannot convert already converted surfaces!");
                return;
            }
            this.mStreamIdxArray = null;
            this.mSurfaceIdxArray = null;
            this.mSurfaceConverted = false;
        }
    }

    private /* synthetic */ void $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(1 x0) {
    }

    private /* synthetic */ void $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(CameraMetadataNative x0, boolean x1, int x2, String x3, Set x4, 1 x5) {
    }

    private /* synthetic */ void $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(CaptureRequest x0, 1 x1) {
    }

    static void __staticInitializer__() {
        mEmptySurfaceSet = new ArraySet();
        CREATOR = new Parcelable.Creator<CaptureRequest>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_CaptureRequest_1$__constructor__() {
            }

            private final CaptureRequest $$robo$$android_hardware_camera2_CaptureRequest_1$createFromParcel(Parcel in) {
                CaptureRequest request = new CaptureRequest(null);
                request.readFromParcel(in);
                return request;
            }

            private final CaptureRequest[] $$robo$$android_hardware_camera2_CaptureRequest_1$newArray(int size) {
                return new CaptureRequest[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_CaptureRequest_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest_1$__constructor__(), this);
            }

            @Override
            public CaptureRequest createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_camera2_CaptureRequest_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public CaptureRequest[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_camera2_CaptureRequest_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        COLOR_CORRECTION_MODE = new Key<Integer>("android.colorCorrection.mode", Integer.TYPE);
        COLOR_CORRECTION_TRANSFORM = new Key<ColorSpaceTransform>("android.colorCorrection.transform", ColorSpaceTransform.class);
        COLOR_CORRECTION_GAINS = new Key<RggbChannelVector>("android.colorCorrection.gains", RggbChannelVector.class);
        COLOR_CORRECTION_ABERRATION_MODE = new Key<Integer>("android.colorCorrection.aberrationMode", Integer.TYPE);
        CONTROL_AE_ANTIBANDING_MODE = new Key<Integer>("android.control.aeAntibandingMode", Integer.TYPE);
        CONTROL_AE_EXPOSURE_COMPENSATION = new Key<Integer>("android.control.aeExposureCompensation", Integer.TYPE);
        CONTROL_AE_LOCK = new Key<Boolean>("android.control.aeLock", Boolean.TYPE);
        CONTROL_AE_MODE = new Key<Integer>("android.control.aeMode", Integer.TYPE);
        CONTROL_AE_REGIONS = new Key<MeteringRectangle[]>("android.control.aeRegions", MeteringRectangle[].class);
        CONTROL_AE_TARGET_FPS_RANGE = new Key<Range<Integer>>("android.control.aeTargetFpsRange", new TypeReference<Range<Integer>>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_CaptureRequest_2$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_CaptureRequest_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest_2$__constructor__(), this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        CONTROL_AE_PRECAPTURE_TRIGGER = new Key<Integer>("android.control.aePrecaptureTrigger", Integer.TYPE);
        CONTROL_AF_MODE = new Key<Integer>("android.control.afMode", Integer.TYPE);
        CONTROL_AF_REGIONS = new Key<MeteringRectangle[]>("android.control.afRegions", MeteringRectangle[].class);
        CONTROL_AF_TRIGGER = new Key<Integer>("android.control.afTrigger", Integer.TYPE);
        CONTROL_AWB_LOCK = new Key<Boolean>("android.control.awbLock", Boolean.TYPE);
        CONTROL_AWB_MODE = new Key<Integer>("android.control.awbMode", Integer.TYPE);
        CONTROL_AWB_REGIONS = new Key<MeteringRectangle[]>("android.control.awbRegions", MeteringRectangle[].class);
        CONTROL_CAPTURE_INTENT = new Key<Integer>("android.control.captureIntent", Integer.TYPE);
        CONTROL_EFFECT_MODE = new Key<Integer>("android.control.effectMode", Integer.TYPE);
        CONTROL_MODE = new Key<Integer>("android.control.mode", Integer.TYPE);
        CONTROL_SCENE_MODE = new Key<Integer>("android.control.sceneMode", Integer.TYPE);
        CONTROL_VIDEO_STABILIZATION_MODE = new Key<Integer>("android.control.videoStabilizationMode", Integer.TYPE);
        CONTROL_POST_RAW_SENSITIVITY_BOOST = new Key<Integer>("android.control.postRawSensitivityBoost", Integer.TYPE);
        CONTROL_ENABLE_ZSL = new Key<Boolean>("android.control.enableZsl", Boolean.TYPE);
        EDGE_MODE = new Key<Integer>("android.edge.mode", Integer.TYPE);
        FLASH_MODE = new Key<Integer>("android.flash.mode", Integer.TYPE);
        HOT_PIXEL_MODE = new Key<Integer>("android.hotPixel.mode", Integer.TYPE);
        JPEG_GPS_LOCATION = new Key<Location>("android.jpeg.gpsLocation", Location.class);
        JPEG_GPS_COORDINATES = new Key<double[]>("android.jpeg.gpsCoordinates", double[].class);
        JPEG_GPS_PROCESSING_METHOD = new Key<String>("android.jpeg.gpsProcessingMethod", String.class);
        JPEG_GPS_TIMESTAMP = new Key<Long>("android.jpeg.gpsTimestamp", Long.TYPE);
        JPEG_ORIENTATION = new Key<Integer>("android.jpeg.orientation", Integer.TYPE);
        JPEG_QUALITY = new Key<Byte>("android.jpeg.quality", Byte.TYPE);
        JPEG_THUMBNAIL_QUALITY = new Key<Byte>("android.jpeg.thumbnailQuality", Byte.TYPE);
        JPEG_THUMBNAIL_SIZE = new Key<Size>("android.jpeg.thumbnailSize", Size.class);
        LENS_APERTURE = new Key<Float>("android.lens.aperture", Float.TYPE);
        LENS_FILTER_DENSITY = new Key<Float>("android.lens.filterDensity", Float.TYPE);
        LENS_FOCAL_LENGTH = new Key<Float>("android.lens.focalLength", Float.TYPE);
        LENS_FOCUS_DISTANCE = new Key<Float>("android.lens.focusDistance", Float.TYPE);
        LENS_OPTICAL_STABILIZATION_MODE = new Key<Integer>("android.lens.opticalStabilizationMode", Integer.TYPE);
        NOISE_REDUCTION_MODE = new Key<Integer>("android.noiseReduction.mode", Integer.TYPE);
        REQUEST_ID = new Key<Integer>("android.request.id", Integer.TYPE);
        SCALER_CROP_REGION = new Key<Rect>("android.scaler.cropRegion", Rect.class);
        SENSOR_EXPOSURE_TIME = new Key<Long>("android.sensor.exposureTime", Long.TYPE);
        SENSOR_FRAME_DURATION = new Key<Long>("android.sensor.frameDuration", Long.TYPE);
        SENSOR_SENSITIVITY = new Key<Integer>("android.sensor.sensitivity", Integer.TYPE);
        SENSOR_TEST_PATTERN_DATA = new Key<int[]>("android.sensor.testPatternData", int[].class);
        SENSOR_TEST_PATTERN_MODE = new Key<Integer>("android.sensor.testPatternMode", Integer.TYPE);
        SHADING_MODE = new Key<Integer>("android.shading.mode", Integer.TYPE);
        STATISTICS_FACE_DETECT_MODE = new Key<Integer>("android.statistics.faceDetectMode", Integer.TYPE);
        STATISTICS_HOT_PIXEL_MAP_MODE = new Key<Boolean>("android.statistics.hotPixelMapMode", Boolean.TYPE);
        STATISTICS_LENS_SHADING_MAP_MODE = new Key<Integer>("android.statistics.lensShadingMapMode", Integer.TYPE);
        STATISTICS_OIS_DATA_MODE = new Key<Integer>("android.statistics.oisDataMode", Integer.TYPE);
        TONEMAP_CURVE_BLUE = new Key<float[]>("android.tonemap.curveBlue", float[].class);
        TONEMAP_CURVE_GREEN = new Key<float[]>("android.tonemap.curveGreen", float[].class);
        TONEMAP_CURVE_RED = new Key<float[]>("android.tonemap.curveRed", float[].class);
        TONEMAP_CURVE = new Key<TonemapCurve>("android.tonemap.curve", TonemapCurve.class);
        TONEMAP_MODE = new Key<Integer>("android.tonemap.mode", Integer.TYPE);
        TONEMAP_GAMMA = new Key<Float>("android.tonemap.gamma", Float.TYPE);
        TONEMAP_PRESET_CURVE = new Key<Integer>("android.tonemap.presetCurve", Integer.TYPE);
        LED_TRANSMIT = new Key<Boolean>("android.led.transmit", Boolean.TYPE);
        BLACK_LEVEL_LOCK = new Key<Boolean>("android.blackLevel.lock", Boolean.TYPE);
        REPROCESS_EFFECTIVE_EXPOSURE_FACTOR = new Key<Float>("android.reprocess.effectiveExposureFactor", Float.TYPE);
        DISTORTION_CORRECTION_MODE = new Key<Integer>("android.distortionCorrection.mode", Integer.TYPE);
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_CaptureRequest$__constructor__();
    }

    public CaptureRequest() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(), this);
    }

    private void __constructor__(CaptureRequest captureRequest) {
        this.$$robo$$android_hardware_camera2_CaptureRequest$__constructor__(captureRequest);
    }

    public CaptureRequest(CaptureRequest captureRequest) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(android.hardware.camera2.CaptureRequest ), this, captureRequest);
    }

    private void __constructor__(CameraMetadataNative cameraMetadataNative, boolean bl, int n, String string2, Set<String> set) {
        this.$$robo$$android_hardware_camera2_CaptureRequest$__constructor__(cameraMetadataNative, bl, n, string2, set);
    }

    public CaptureRequest(CameraMetadataNative cameraMetadataNative, boolean bl, int n, String string2, Set<String> set) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(android.hardware.camera2.impl.CameraMetadataNative boolean int java.lang.String java.util.Set<java.lang.String> ), this, cameraMetadataNative, bl, n, string2, set);
    }

    public <T> T get(Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("get", $$robo$$android_hardware_camera2_CaptureRequest$get(android.hardware.camera2.CaptureRequest$Key<T> ), this, key);
    }

    @Override
    protected <T> T getProtected(Key<?> key) {
        return (T)InvokeDynamicSupport.bootstrap("getProtected", $$robo$$android_hardware_camera2_CaptureRequest$getProtected(android.hardware.camera2.CaptureRequest$Key<?> ), this, key);
    }

    @Override
    protected Class<Key<?>> getKeyClass() {
        return InvokeDynamicSupport.bootstrap("getKeyClass", $$robo$$android_hardware_camera2_CaptureRequest$getKeyClass(), this);
    }

    @Override
    public List<Key<?>> getKeys() {
        return InvokeDynamicSupport.bootstrap("getKeys", $$robo$$android_hardware_camera2_CaptureRequest$getKeys(), this);
    }

    public Object getTag() {
        return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_hardware_camera2_CaptureRequest$getTag(), this);
    }

    public boolean isReprocess() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReprocess", $$robo$$android_hardware_camera2_CaptureRequest$isReprocess(), this);
    }

    public boolean isPartOfCRequestList() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPartOfCRequestList", $$robo$$android_hardware_camera2_CaptureRequest$isPartOfCRequestList(), this);
    }

    public CameraMetadataNative getNativeCopy() {
        return InvokeDynamicSupport.bootstrap("getNativeCopy", $$robo$$android_hardware_camera2_CaptureRequest$getNativeCopy(), this);
    }

    public int getReprocessableSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getReprocessableSessionId", $$robo$$android_hardware_camera2_CaptureRequest$getReprocessableSessionId(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_CaptureRequest$equals(java.lang.Object ), this, object);
    }

    private boolean equals(CaptureRequest captureRequest) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_CaptureRequest$equals(android.hardware.camera2.CaptureRequest ), this, captureRequest);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_CaptureRequest$hashCode(), this);
    }

    private void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_hardware_camera2_CaptureRequest$readFromParcel(android.os.Parcel ), this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_camera2_CaptureRequest$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_camera2_CaptureRequest$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public boolean containsTarget(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsTarget", $$robo$$android_hardware_camera2_CaptureRequest$containsTarget(android.view.Surface ), this, surface);
    }

    public Collection<Surface> getTargets() {
        return InvokeDynamicSupport.bootstrap("getTargets", $$robo$$android_hardware_camera2_CaptureRequest$getTargets(), this);
    }

    public String getLogicalCameraId() {
        return InvokeDynamicSupport.bootstrap("getLogicalCameraId", $$robo$$android_hardware_camera2_CaptureRequest$getLogicalCameraId(), this);
    }

    public void convertSurfaceToStreamId(SparseArray<OutputConfiguration> sparseArray) {
        InvokeDynamicSupport.bootstrap("convertSurfaceToStreamId", $$robo$$android_hardware_camera2_CaptureRequest$convertSurfaceToStreamId(android.util.SparseArray<android.hardware.camera2.params.OutputConfiguration> ), this, sparseArray);
    }

    public void recoverStreamIdToSurface() {
        InvokeDynamicSupport.bootstrap("recoverStreamIdToSurface", $$robo$$android_hardware_camera2_CaptureRequest$recoverStreamIdToSurface(), this);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_hardware_camera2_CaptureRequest$__constructor__(var1_1);
    }

    public /* synthetic */ CaptureRequest(1 var1_1) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(android.hardware.camera2.CaptureRequest$1 ), this, var1_1);
    }

    private /* synthetic */ void __constructor__(CameraMetadataNative cameraMetadataNative, boolean bl, int n, String string2, Set set, 1 var6_6) {
        this.$$robo$$android_hardware_camera2_CaptureRequest$__constructor__(cameraMetadataNative, bl, n, string2, set, var6_6);
    }

    public /* synthetic */ CaptureRequest(CameraMetadataNative cameraMetadataNative, boolean bl, int n, String string2, Set set, 1 var6_6) {
        this(cameraMetadataNative, bl, n, string2, set);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(android.hardware.camera2.impl.CameraMetadataNative boolean int java.lang.String java.util.Set android.hardware.camera2.CaptureRequest$1 ), this, cameraMetadataNative, bl, n, string2, set, var6_6);
    }

    private /* synthetic */ void __constructor__(CaptureRequest captureRequest, 1 var2_2) {
        this.$$robo$$android_hardware_camera2_CaptureRequest$__constructor__(captureRequest, var2_2);
    }

    public /* synthetic */ CaptureRequest(CaptureRequest captureRequest, 1 var2_2) {
        this(captureRequest);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest$__constructor__(android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureRequest$1 ), this, captureRequest, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(CaptureRequest.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptureRequest)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CaptureRequest mRequest;

        private void $$robo$$android_hardware_camera2_CaptureRequest_Builder$__constructor__(CameraMetadataNative template, boolean reprocess, int reprocessableSessionId, String logicalCameraId, Set<String> physicalCameraIdSet) {
            this.mRequest = new CaptureRequest(template, reprocess, reprocessableSessionId, logicalCameraId, physicalCameraIdSet, null);
        }

        private final void $$robo$$android_hardware_camera2_CaptureRequest_Builder$addTarget(Surface outputTarget) {
            this.mRequest.mSurfaceSet.add(outputTarget);
        }

        private final void $$robo$$android_hardware_camera2_CaptureRequest_Builder$removeTarget(Surface outputTarget) {
            this.mRequest.mSurfaceSet.remove(outputTarget);
        }

        private final <T> void $$robo$$android_hardware_camera2_CaptureRequest_Builder$set(Key<T> key, T value) {
            this.mRequest.mLogicalCameraSettings.set(key, value);
        }

        private final <T> T $$robo$$android_hardware_camera2_CaptureRequest_Builder$get(Key<T> key) {
            return this.mRequest.mLogicalCameraSettings.get(key);
        }

        private final <T> Builder $$robo$$android_hardware_camera2_CaptureRequest_Builder$setPhysicalCameraKey(Key<T> key, T value, String physicalCameraId) {
            if (!this.mRequest.mPhysicalCameraSettings.containsKey(physicalCameraId)) {
                throw new IllegalArgumentException("Physical camera id: " + physicalCameraId + " is not valid!");
            }
            ((CameraMetadataNative)this.mRequest.mPhysicalCameraSettings.get(physicalCameraId)).set(key, value);
            return this;
        }

        private final <T> T $$robo$$android_hardware_camera2_CaptureRequest_Builder$getPhysicalCameraKey(Key<T> key, String physicalCameraId) {
            if (!this.mRequest.mPhysicalCameraSettings.containsKey(physicalCameraId)) {
                throw new IllegalArgumentException("Physical camera id: " + physicalCameraId + " is not valid!");
            }
            return ((CameraMetadataNative)this.mRequest.mPhysicalCameraSettings.get(physicalCameraId)).get(key);
        }

        private final void $$robo$$android_hardware_camera2_CaptureRequest_Builder$setTag(Object tag) {
            this.mRequest.mUserTag = tag;
        }

        private final void $$robo$$android_hardware_camera2_CaptureRequest_Builder$setPartOfCHSRequestList(boolean partOfCHSList) {
            this.mRequest.mIsPartOfCHSRequestList = partOfCHSList;
        }

        private final CaptureRequest $$robo$$android_hardware_camera2_CaptureRequest_Builder$build() {
            return new CaptureRequest(this.mRequest, null);
        }

        private final boolean $$robo$$android_hardware_camera2_CaptureRequest_Builder$isEmpty() {
            return this.mRequest.mLogicalCameraSettings.isEmpty();
        }

        private void __constructor__(CameraMetadataNative cameraMetadataNative, boolean bl, int n, String string2, Set<String> set) {
            this.$$robo$$android_hardware_camera2_CaptureRequest_Builder$__constructor__(cameraMetadataNative, bl, n, string2, set);
        }

        public Builder(CameraMetadataNative cameraMetadataNative, boolean bl, int n, String string2, Set<String> set) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest_Builder$__constructor__(android.hardware.camera2.impl.CameraMetadataNative boolean int java.lang.String java.util.Set<java.lang.String> ), this, cameraMetadataNative, bl, n, string2, set);
        }

        public void addTarget(Surface surface) {
            InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_hardware_camera2_CaptureRequest_Builder$addTarget(android.view.Surface ), this, surface);
        }

        public void removeTarget(Surface surface) {
            InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_hardware_camera2_CaptureRequest_Builder$removeTarget(android.view.Surface ), this, surface);
        }

        public <T> void set(Key<T> key, T t) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_hardware_camera2_CaptureRequest_Builder$set(android.hardware.camera2.CaptureRequest$Key<T> T ), this, key, t);
        }

        public <T> T get(Key<T> key) {
            return (T)InvokeDynamicSupport.bootstrap("get", $$robo$$android_hardware_camera2_CaptureRequest_Builder$get(android.hardware.camera2.CaptureRequest$Key<T> ), this, key);
        }

        public <T> Builder setPhysicalCameraKey(Key<T> key, T t, String string2) {
            return InvokeDynamicSupport.bootstrap("setPhysicalCameraKey", $$robo$$android_hardware_camera2_CaptureRequest_Builder$setPhysicalCameraKey(android.hardware.camera2.CaptureRequest$Key<T> T java.lang.String ), this, key, t, string2);
        }

        public <T> T getPhysicalCameraKey(Key<T> key, String string2) {
            return (T)InvokeDynamicSupport.bootstrap("getPhysicalCameraKey", $$robo$$android_hardware_camera2_CaptureRequest_Builder$getPhysicalCameraKey(android.hardware.camera2.CaptureRequest$Key<T> java.lang.String ), this, key, string2);
        }

        public void setTag(Object object) {
            InvokeDynamicSupport.bootstrap("setTag", $$robo$$android_hardware_camera2_CaptureRequest_Builder$setTag(java.lang.Object ), this, object);
        }

        public void setPartOfCHSRequestList(boolean bl) {
            InvokeDynamicSupport.bootstrap("setPartOfCHSRequestList", $$robo$$android_hardware_camera2_CaptureRequest_Builder$setPartOfCHSRequestList(boolean ), this, bl);
        }

        public CaptureRequest build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_hardware_camera2_CaptureRequest_Builder$build(), this);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_hardware_camera2_CaptureRequest_Builder$isEmpty(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Key<T> {
        public /* synthetic */ Object __robo_data__;
        private CameraMetadataNative.Key<T> mKey;

        private void $$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(String name, Class<T> type, long vendorId) {
            this.mKey = new CameraMetadataNative.Key<T>(name, type, vendorId);
        }

        private void $$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(String name, Class<T> type) {
            this.mKey = new CameraMetadataNative.Key<T>(name, type);
        }

        private void $$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(String name, TypeReference<T> typeReference) {
            this.mKey = new CameraMetadataNative.Key<T>(name, typeReference);
        }

        private final String $$robo$$android_hardware_camera2_CaptureRequest_Key$getName() {
            return this.mKey.getName();
        }

        private final long $$robo$$android_hardware_camera2_CaptureRequest_Key$getVendorId() {
            return this.mKey.getVendorId();
        }

        private final int $$robo$$android_hardware_camera2_CaptureRequest_Key$hashCode() {
            return this.mKey.hashCode();
        }

        private final boolean $$robo$$android_hardware_camera2_CaptureRequest_Key$equals(Object o) {
            return o instanceof Key && ((Key)o).mKey.equals(this.mKey);
        }

        private final String $$robo$$android_hardware_camera2_CaptureRequest_Key$toString() {
            return String.format("CaptureRequest.Key(%s)", this.mKey.getName());
        }

        private final CameraMetadataNative.Key<T> $$robo$$android_hardware_camera2_CaptureRequest_Key$getNativeKey() {
            return this.mKey;
        }

        private void $$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(CameraMetadataNative.Key<?> nativeKey) {
            this.mKey = nativeKey;
        }

        private void __constructor__(String string2, Class<T> clazz, long l) {
            this.$$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(string2, clazz, l);
        }

        public Key(String string2, Class<T> clazz, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(java.lang.String java.lang.Class<T> long ), this, string2, clazz, l);
        }

        private void __constructor__(String string2, Class<T> clazz) {
            this.$$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(string2, clazz);
        }

        public Key(String string2, Class<T> clazz) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(java.lang.String java.lang.Class<T> ), this, string2, clazz);
        }

        private void __constructor__(String string2, TypeReference<T> typeReference) {
            this.$$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(string2, typeReference);
        }

        public Key(String string2, TypeReference<T> typeReference) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(java.lang.String android.hardware.camera2.utils.TypeReference<T> ), this, string2, typeReference);
        }

        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_hardware_camera2_CaptureRequest_Key$getName(), this);
        }

        public long getVendorId() {
            return (long)InvokeDynamicSupport.bootstrap("getVendorId", $$robo$$android_hardware_camera2_CaptureRequest_Key$getVendorId(), this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_CaptureRequest_Key$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_CaptureRequest_Key$equals(java.lang.Object ), this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_camera2_CaptureRequest_Key$toString(), this);
        }

        public CameraMetadataNative.Key<T> getNativeKey() {
            return InvokeDynamicSupport.bootstrap("getNativeKey", $$robo$$android_hardware_camera2_CaptureRequest_Key$getNativeKey(), this);
        }

        private void __constructor__(CameraMetadataNative.Key<?> key) {
            this.$$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(key);
        }

        public Key(CameraMetadataNative.Key<?> key) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CaptureRequest_Key$__constructor__(android.hardware.camera2.impl.CameraMetadataNative$Key<?> ), this, key);
        }

        public /* synthetic */ Key() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Key)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

