/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.utils.ParamsUtils;
import android.util.Log;
import android.util.Size;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LegacyFaceDetectMapper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG = false;
    private Camera mCamera;
    private boolean mFaceDetectSupported;
    private boolean mFaceDetectEnabled;
    private boolean mFaceDetectScenePriority;
    private boolean mFaceDetectReporting;
    private Object mLock;
    private Camera.Face[] mFaces;
    private Camera.Face[] mFacesPrev;

    private void $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper$__constructor__(Camera camera, CameraCharacteristics characteristics) {
        this.mFaceDetectEnabled = false;
        this.mFaceDetectScenePriority = false;
        this.mFaceDetectReporting = false;
        this.mLock = new Object();
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
        Preconditions.checkNotNull(characteristics, "characteristics must not be null");
        this.mFaceDetectSupported = ArrayUtils.contains(characteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES), 1);
        if (!this.mFaceDetectSupported) {
            return;
        }
        this.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ LegacyFaceDetectMapper this$0;

            private void $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper_1$__constructor__(LegacyFaceDetectMapper this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper_1$onFaceDetection(Camera.Face[] faces, Camera camera) {
                int lengthFaces = faces == null ? 0 : faces.length;
                Object object = this.this$0.mLock;
                synchronized (object) {
                    if (this.this$0.mFaceDetectEnabled) {
                        LegacyFaceDetectMapper.access$202(this.this$0, faces);
                    } else if (lengthFaces > 0) {
                        Log.d(TAG, "onFaceDetection - Ignored some incoming faces sinceface detection was disabled");
                    }
                }
            }

            private void __constructor__(LegacyFaceDetectMapper legacyFaceDetectMapper) {
                this.$$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper_1$__constructor__(legacyFaceDetectMapper);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper_1$__constructor__(android.hardware.camera2.legacy.LegacyFaceDetectMapper ), this, legacyFaceDetectMapper);
            }

            @Override
            public void onFaceDetection(Camera.Face[] faceArray, Camera camera) {
                InvokeDynamicSupport.bootstrap("onFaceDetection", $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper_1$onFaceDetection(android.hardware.Camera$Face[] android.hardware.Camera ), this, faceArray, camera);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper$processFaceDetectMode(CaptureRequest captureRequest, Camera.Parameters parameters) {
        Preconditions.checkNotNull(captureRequest, "captureRequest must not be null");
        int fdMode = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.STATISTICS_FACE_DETECT_MODE, 0);
        if (fdMode != 0 && !this.mFaceDetectSupported) {
            Log.w(TAG, "processFaceDetectMode - Ignoring statistics.faceDetectMode; face detection is not available");
            return;
        }
        int sceneMode = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_SCENE_MODE, 0);
        if (sceneMode == 1 && !this.mFaceDetectSupported) {
            Log.w(TAG, "processFaceDetectMode - ignoring control.sceneMode == FACE_PRIORITY; face detection is not available");
            return;
        }
        switch (fdMode) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                Log.w(TAG, "processFaceDetectMode - statistics.faceDetectMode == FULL unsupported, downgrading to SIMPLE");
                break;
            }
            default: {
                Log.w(TAG, "processFaceDetectMode - ignoring unknown statistics.faceDetectMode = " + fdMode);
                return;
            }
        }
        boolean enableFaceDetect = fdMode != 0 || sceneMode == 1;
        Object object = this.mLock;
        synchronized (object) {
            if (enableFaceDetect != this.mFaceDetectEnabled) {
                if (enableFaceDetect) {
                    this.mCamera.startFaceDetection();
                } else {
                    this.mCamera.stopFaceDetection();
                    this.mFaces = null;
                }
                this.mFaceDetectEnabled = enableFaceDetect;
                this.mFaceDetectScenePriority = sceneMode == 1;
                this.mFaceDetectReporting = fdMode != 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper$mapResultFaces(CameraMetadataNative result, LegacyRequest legacyRequest) {
        boolean fdScenePriority;
        Camera.Face[] faces;
        int fdMode;
        Preconditions.checkNotNull(result, "result must not be null");
        Preconditions.checkNotNull(legacyRequest, "legacyRequest must not be null");
        Object object = this.mLock;
        synchronized (object) {
            fdMode = this.mFaceDetectReporting ? 1 : 0;
            faces = this.mFaceDetectReporting ? this.mFaces : null;
            fdScenePriority = this.mFaceDetectScenePriority;
            Camera.Face[] previousFaces = this.mFacesPrev;
            this.mFacesPrev = faces;
        }
        CameraCharacteristics characteristics = legacyRequest.characteristics;
        CaptureRequest request = legacyRequest.captureRequest;
        Size previewSize = legacyRequest.previewSize;
        Camera.Parameters params = legacyRequest.parameters;
        Rect activeArray = characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        ParameterUtils.ZoomData zoomData = ParameterUtils.convertScalerCropRegion(activeArray, request.get(CaptureRequest.SCALER_CROP_REGION), previewSize, params);
        ArrayList<Face> convertedFaces = new ArrayList<Face>();
        if (faces != null) {
            for (Camera.Face face : faces) {
                if (face != null) {
                    convertedFaces.add(ParameterUtils.convertFaceFromLegacy(face, activeArray, zoomData));
                    continue;
                }
                Log.w(TAG, "mapResultFaces - read NULL face from camera1 device");
            }
        }
        result.set(CaptureResult.STATISTICS_FACES, convertedFaces.toArray(new Face[0]));
        result.set(CaptureResult.STATISTICS_FACE_DETECT_MODE, Integer.valueOf(fdMode));
        if (fdScenePriority) {
            result.set(CaptureResult.CONTROL_SCENE_MODE, Integer.valueOf(1));
        }
    }

    static /* synthetic */ Camera.Face[] access$202(LegacyFaceDetectMapper x0, Camera.Face[] x1) {
        x0.mFaces = x1;
        return x1;
    }

    static void __staticInitializer__() {
        TAG = "LegacyFaceDetectMapper";
    }

    private void __constructor__(Camera camera, CameraCharacteristics cameraCharacteristics) {
        this.$$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper$__constructor__(camera, cameraCharacteristics);
    }

    public LegacyFaceDetectMapper(Camera camera, CameraCharacteristics cameraCharacteristics) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper$__constructor__(android.hardware.Camera android.hardware.camera2.CameraCharacteristics ), this, camera, cameraCharacteristics);
    }

    public void processFaceDetectMode(CaptureRequest captureRequest, Camera.Parameters parameters) {
        InvokeDynamicSupport.bootstrap("processFaceDetectMode", $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper$processFaceDetectMode(android.hardware.camera2.CaptureRequest android.hardware.Camera$Parameters ), this, captureRequest, parameters);
    }

    public void mapResultFaces(CameraMetadataNative cameraMetadataNative, LegacyRequest legacyRequest) {
        InvokeDynamicSupport.bootstrap("mapResultFaces", $$robo$$android_hardware_camera2_legacy_LegacyFaceDetectMapper$mapResultFaces(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.legacy.LegacyRequest ), this, cameraMetadataNative, legacyRequest);
    }

    static {
        RobolectricInternals.classInitializing(LegacyFaceDetectMapper.class);
    }

    public /* synthetic */ LegacyFaceDetectMapper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyFaceDetectMapper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

