/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.BurstHolder;
import android.hardware.camera2.utils.SubmitInfo;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayDeque;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RequestQueue
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "RequestQueue";
    private static long INVALID_FRAME = -1L;
    private BurstHolder mRepeatingRequest;
    private ArrayDeque<BurstHolder> mRequestQueue;
    private long mCurrentFrameNumber;
    private long mCurrentRepeatingFrameNumber;
    private int mCurrentRequestId;
    private List<Long> mJpegSurfaceIds;

    private void $$robo$$android_hardware_camera2_legacy_RequestQueue$__constructor__(List<Long> jpegSurfaceIds) {
        this.mRepeatingRequest = null;
        this.mRequestQueue = new ArrayDeque();
        this.mCurrentFrameNumber = 0L;
        this.mCurrentRepeatingFrameNumber = -1L;
        this.mCurrentRequestId = 0;
        this.mJpegSurfaceIds = jpegSurfaceIds;
    }

    private final synchronized RequestQueueEntry $$robo$$android_hardware_camera2_legacy_RequestQueue$getNext() {
        boolean queueEmptied;
        BurstHolder next = this.mRequestQueue.poll();
        boolean bl = queueEmptied = next != null && this.mRequestQueue.size() == 0;
        if (next == null && this.mRepeatingRequest != null) {
            next = this.mRepeatingRequest;
            this.mCurrentRepeatingFrameNumber = this.mCurrentFrameNumber + (long)next.getNumberOfRequests();
        }
        if (next == null) {
            return null;
        }
        RequestQueueEntry ret = new RequestQueueEntry(this, next, this.mCurrentFrameNumber, queueEmptied);
        this.mCurrentFrameNumber += (long)next.getNumberOfRequests();
        return ret;
    }

    private final synchronized long $$robo$$android_hardware_camera2_legacy_RequestQueue$stopRepeating(int requestId) {
        long ret = -1L;
        if (this.mRepeatingRequest != null && this.mRepeatingRequest.getRequestId() == requestId) {
            this.mRepeatingRequest = null;
            ret = this.mCurrentRepeatingFrameNumber == -1L ? -1L : this.mCurrentRepeatingFrameNumber - 1L;
            this.mCurrentRepeatingFrameNumber = -1L;
            Log.i("RequestQueue", "Repeating capture request cancelled.");
        } else {
            Log.e("RequestQueue", "cancel failed: no repeating request exists for request id: " + requestId);
        }
        return ret;
    }

    private final synchronized long $$robo$$android_hardware_camera2_legacy_RequestQueue$stopRepeating() {
        if (this.mRepeatingRequest == null) {
            Log.e("RequestQueue", "cancel failed: no repeating request exists.");
            return -1L;
        }
        return this.stopRepeating(this.mRepeatingRequest.getRequestId());
    }

    private final synchronized SubmitInfo $$robo$$android_hardware_camera2_legacy_RequestQueue$submit(CaptureRequest[] requests, boolean repeating) {
        int requestId = this.mCurrentRequestId++;
        BurstHolder burst = new BurstHolder(requestId, repeating, requests, this.mJpegSurfaceIds);
        long lastFrame = -1L;
        if (burst.isRepeating()) {
            Log.i("RequestQueue", "Repeating capture request set.");
            if (this.mRepeatingRequest != null) {
                lastFrame = this.mCurrentRepeatingFrameNumber == -1L ? -1L : this.mCurrentRepeatingFrameNumber - 1L;
            }
            this.mCurrentRepeatingFrameNumber = -1L;
            this.mRepeatingRequest = burst;
        } else {
            this.mRequestQueue.offer(burst);
            lastFrame = this.calculateLastFrame(burst.getRequestId());
        }
        SubmitInfo info = new SubmitInfo(requestId, lastFrame);
        return info;
    }

    private final long $$robo$$android_hardware_camera2_legacy_RequestQueue$calculateLastFrame(int requestId) {
        long total = this.mCurrentFrameNumber;
        for (BurstHolder b : this.mRequestQueue) {
            total += (long)b.getNumberOfRequests();
            if (b.getRequestId() != requestId) continue;
            return total - 1L;
        }
        throw new IllegalStateException("At least one request must be in the queue to calculate frame number");
    }

    private void __constructor__(List<Long> list) {
        this.$$robo$$android_hardware_camera2_legacy_RequestQueue$__constructor__(list);
    }

    public RequestQueue(List<Long> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestQueue$__constructor__(java.util.List<java.lang.Long> ), this, list);
    }

    public synchronized RequestQueueEntry getNext() {
        return InvokeDynamicSupport.bootstrap("getNext", $$robo$$android_hardware_camera2_legacy_RequestQueue$getNext(), this);
    }

    public synchronized long stopRepeating(int n) {
        return (long)InvokeDynamicSupport.bootstrap("stopRepeating", $$robo$$android_hardware_camera2_legacy_RequestQueue$stopRepeating(int ), this, n);
    }

    public synchronized long stopRepeating() {
        return (long)InvokeDynamicSupport.bootstrap("stopRepeating", $$robo$$android_hardware_camera2_legacy_RequestQueue$stopRepeating(), this);
    }

    public synchronized SubmitInfo submit(CaptureRequest[] captureRequestArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("submit", $$robo$$android_hardware_camera2_legacy_RequestQueue$submit(android.hardware.camera2.CaptureRequest[] boolean ), this, captureRequestArray, bl);
    }

    private long calculateLastFrame(int n) {
        return (long)InvokeDynamicSupport.bootstrap("calculateLastFrame", $$robo$$android_hardware_camera2_legacy_RequestQueue$calculateLastFrame(int ), this, n);
    }

    public /* synthetic */ RequestQueue() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestQueue)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class RequestQueueEntry
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private BurstHolder mBurstHolder;
        private Long mFrameNumber;
        private boolean mQueueEmpty;
        /* synthetic */ RequestQueue this$0;

        private final BurstHolder $$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$getBurstHolder() {
            return this.mBurstHolder;
        }

        private final Long $$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$getFrameNumber() {
            return this.mFrameNumber;
        }

        private final boolean $$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$isQueueEmpty() {
            return this.mQueueEmpty;
        }

        private void $$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$__constructor__(RequestQueue this$0, BurstHolder burstHolder, Long frameNumber, boolean queueEmpty) {
            this.this$0 = this$0;
            this.mBurstHolder = burstHolder;
            this.mFrameNumber = frameNumber;
            this.mQueueEmpty = queueEmpty;
        }

        public BurstHolder getBurstHolder() {
            return InvokeDynamicSupport.bootstrap("getBurstHolder", $$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$getBurstHolder(), this);
        }

        public Long getFrameNumber() {
            return InvokeDynamicSupport.bootstrap("getFrameNumber", $$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$getFrameNumber(), this);
        }

        public boolean isQueueEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isQueueEmpty", $$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$isQueueEmpty(), this);
        }

        private void __constructor__(RequestQueue requestQueue, BurstHolder burstHolder, Long l, boolean bl) {
            this.$$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$__constructor__(requestQueue, burstHolder, l, bl);
        }

        public RequestQueueEntry(RequestQueue requestQueue, BurstHolder burstHolder, Long l, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestQueue_RequestQueueEntry$__constructor__(android.hardware.camera2.legacy.RequestQueue android.hardware.camera2.legacy.BurstHolder java.lang.Long boolean ), this, requestQueue, burstHolder, l, bl);
        }

        public /* synthetic */ RequestQueueEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestQueueEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

