/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import com.android.internal.util.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class TaskDrainer<T> {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "TaskDrainer";
    private boolean DEBUG = false;
    private Executor mExecutor;
    private DrainListener mListener;
    private String mName;
    private Set<T> mTaskSet;
    private Set<T> mEarlyFinishedTaskSet;
    private Object mLock;
    private boolean mDraining;
    private boolean mDrainFinished;

    private void $$robo$$android_hardware_camera2_utils_TaskDrainer$__constructor__(Executor executor, DrainListener listener) {
        this.DEBUG = false;
        this.mTaskSet = new HashSet<T>();
        this.mEarlyFinishedTaskSet = new HashSet<T>();
        this.mLock = new Object();
        this.mDraining = false;
        this.mDrainFinished = false;
        this.mExecutor = Preconditions.checkNotNull(executor, "executor must not be null");
        this.mListener = Preconditions.checkNotNull(listener, "listener must not be null");
        this.mName = null;
    }

    private void $$robo$$android_hardware_camera2_utils_TaskDrainer$__constructor__(Executor executor, DrainListener listener, String name) {
        this.DEBUG = false;
        this.mTaskSet = new HashSet<T>();
        this.mEarlyFinishedTaskSet = new HashSet<T>();
        this.mLock = new Object();
        this.mDraining = false;
        this.mDrainFinished = false;
        this.mExecutor = Preconditions.checkNotNull(executor, "executor must not be null");
        this.mListener = Preconditions.checkNotNull(listener, "listener must not be null");
        this.mName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_utils_TaskDrainer$taskStarted(T task) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDraining) {
                throw new IllegalStateException("Can't start more tasks after draining has begun");
            }
            if (!this.mEarlyFinishedTaskSet.remove(task) && !this.mTaskSet.add(task)) {
                throw new IllegalStateException("Task " + task + " was already started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_utils_TaskDrainer$taskFinished(T task) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mTaskSet.remove(task) && !this.mEarlyFinishedTaskSet.add(task)) {
                throw new IllegalStateException("Task " + task + " was already finished");
            }
            this.checkIfDrainFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_utils_TaskDrainer$beginDrain() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDraining) {
                this.mDraining = true;
                this.checkIfDrainFinished();
            }
        }
    }

    private final void $$robo$$android_hardware_camera2_utils_TaskDrainer$checkIfDrainFinished() {
        if (this.mTaskSet.isEmpty() && this.mDraining && !this.mDrainFinished) {
            this.mDrainFinished = true;
            this.postDrained();
        }
    }

    private final void $$robo$$android_hardware_camera2_utils_TaskDrainer$postDrained() {
        this.mExecutor.execute(() -> this.mListener.onDrained());
    }

    private void __constructor__(Executor executor, DrainListener drainListener) {
        this.$$robo$$android_hardware_camera2_utils_TaskDrainer$__constructor__(executor, drainListener);
    }

    public TaskDrainer(Executor executor, DrainListener drainListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_TaskDrainer$__constructor__(java.util.concurrent.Executor android.hardware.camera2.utils.TaskDrainer$DrainListener ), this, executor, drainListener);
    }

    private void __constructor__(Executor executor, DrainListener drainListener, String string2) {
        this.$$robo$$android_hardware_camera2_utils_TaskDrainer$__constructor__(executor, drainListener, string2);
    }

    public TaskDrainer(Executor executor, DrainListener drainListener, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_TaskDrainer$__constructor__(java.util.concurrent.Executor android.hardware.camera2.utils.TaskDrainer$DrainListener java.lang.String ), this, executor, drainListener, string2);
    }

    public void taskStarted(T t) {
        InvokeDynamicSupport.bootstrap("taskStarted", $$robo$$android_hardware_camera2_utils_TaskDrainer$taskStarted(T ), this, t);
    }

    public void taskFinished(T t) {
        InvokeDynamicSupport.bootstrap("taskFinished", $$robo$$android_hardware_camera2_utils_TaskDrainer$taskFinished(T ), this, t);
    }

    public void beginDrain() {
        InvokeDynamicSupport.bootstrap("beginDrain", $$robo$$android_hardware_camera2_utils_TaskDrainer$beginDrain(), this);
    }

    private void checkIfDrainFinished() {
        InvokeDynamicSupport.bootstrap("checkIfDrainFinished", $$robo$$android_hardware_camera2_utils_TaskDrainer$checkIfDrainFinished(), this);
    }

    private void postDrained() {
        InvokeDynamicSupport.bootstrap("postDrained", $$robo$$android_hardware_camera2_utils_TaskDrainer$postDrained(), this);
    }

    public /* synthetic */ TaskDrainer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TaskDrainer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface DrainListener {
        public void onDrained();
    }
}

