/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BrightnessConfiguration
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private float[] mLux;
    private float[] mNits;
    private String mDescription;
    public static Parcelable.Creator<BrightnessConfiguration> CREATOR;

    private void $$robo$$android_hardware_display_BrightnessConfiguration$__constructor__(float[] lux, float[] nits, String description) {
        this.mLux = lux;
        this.mNits = nits;
        this.mDescription = description;
    }

    private final Pair<float[], float[]> $$robo$$android_hardware_display_BrightnessConfiguration$getCurve() {
        return Pair.create(Arrays.copyOf(this.mLux, this.mLux.length), Arrays.copyOf(this.mNits, this.mNits.length));
    }

    private final String $$robo$$android_hardware_display_BrightnessConfiguration$getDescription() {
        return this.mDescription;
    }

    private final void $$robo$$android_hardware_display_BrightnessConfiguration$writeToParcel(Parcel dest, int flags) {
        dest.writeFloatArray(this.mLux);
        dest.writeFloatArray(this.mNits);
        dest.writeString(this.mDescription);
    }

    private final int $$robo$$android_hardware_display_BrightnessConfiguration$describeContents() {
        return 0;
    }

    private final String $$robo$$android_hardware_display_BrightnessConfiguration$toString() {
        StringBuilder sb = new StringBuilder("BrightnessConfiguration{[");
        int size = this.mLux.length;
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("(").append(this.mLux[i]).append(", ").append(this.mNits[i]).append(")");
        }
        sb.append("], '");
        if (this.mDescription != null) {
            sb.append(this.mDescription);
        }
        sb.append("'}");
        return sb.toString();
    }

    private final int $$robo$$android_hardware_display_BrightnessConfiguration$hashCode() {
        int result = 1;
        result = result * 31 + Arrays.hashCode(this.mLux);
        result = result * 31 + Arrays.hashCode(this.mNits);
        if (this.mDescription != null) {
            result = result * 31 + this.mDescription.hashCode();
        }
        return result;
    }

    private final boolean $$robo$$android_hardware_display_BrightnessConfiguration$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrightnessConfiguration)) {
            return false;
        }
        BrightnessConfiguration other = (BrightnessConfiguration)o;
        return Arrays.equals(this.mLux, other.mLux) && Arrays.equals(this.mNits, other.mNits) && Objects.equals(this.mDescription, other.mDescription);
    }

    private /* synthetic */ void $$robo$$android_hardware_display_BrightnessConfiguration$__constructor__(float[] x0, float[] x1, String x2, 1 x3) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<BrightnessConfiguration>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_display_BrightnessConfiguration_1$__constructor__() {
            }

            private final BrightnessConfiguration $$robo$$android_hardware_display_BrightnessConfiguration_1$createFromParcel(Parcel in) {
                float[] lux = in.createFloatArray();
                float[] nits = in.createFloatArray();
                Builder builder = new Builder(lux, nits);
                builder.setDescription(in.readString());
                return builder.build();
            }

            private final BrightnessConfiguration[] $$robo$$android_hardware_display_BrightnessConfiguration_1$newArray(int size) {
                return new BrightnessConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_display_BrightnessConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_BrightnessConfiguration_1$__constructor__(), this);
            }

            @Override
            public BrightnessConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_display_BrightnessConfiguration_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public BrightnessConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_display_BrightnessConfiguration_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(float[] fArray, float[] fArray2, String string2) {
        this.$$robo$$android_hardware_display_BrightnessConfiguration$__constructor__(fArray, fArray2, string2);
    }

    public BrightnessConfiguration(float[] fArray, float[] fArray2, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_BrightnessConfiguration$__constructor__(float[] float[] java.lang.String ), this, fArray, fArray2, string2);
    }

    public Pair<float[], float[]> getCurve() {
        return InvokeDynamicSupport.bootstrap("getCurve", $$robo$$android_hardware_display_BrightnessConfiguration$getCurve(), this);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_hardware_display_BrightnessConfiguration$getDescription(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_display_BrightnessConfiguration$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_display_BrightnessConfiguration$describeContents(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_display_BrightnessConfiguration$toString(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_display_BrightnessConfiguration$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_display_BrightnessConfiguration$equals(java.lang.Object ), this, object);
    }

    private /* synthetic */ void __constructor__(float[] fArray, float[] fArray2, String string2, 1 var4_4) {
        this.$$robo$$android_hardware_display_BrightnessConfiguration$__constructor__(fArray, fArray2, string2, var4_4);
    }

    public /* synthetic */ BrightnessConfiguration(float[] fArray, float[] fArray2, String string2, 1 var4_4) {
        this(fArray, fArray2, string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_BrightnessConfiguration$__constructor__(float[] float[] java.lang.String android.hardware.display.BrightnessConfiguration$1 ), this, fArray, fArray2, string2, var4_4);
    }

    static {
        RobolectricInternals.classInitializing(BrightnessConfiguration.class);
    }

    public /* synthetic */ BrightnessConfiguration() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BrightnessConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private float[] mCurveLux;
        private float[] mCurveNits;
        private String mDescription;

        private void $$robo$$android_hardware_display_BrightnessConfiguration_Builder$__constructor__() {
        }

        private void $$robo$$android_hardware_display_BrightnessConfiguration_Builder$__constructor__(float[] lux, float[] nits) {
            this.setCurve(lux, nits);
        }

        private final Builder $$robo$$android_hardware_display_BrightnessConfiguration_Builder$setCurve(float[] lux, float[] nits) {
            Preconditions.checkNotNull(lux);
            Preconditions.checkNotNull(nits);
            if (lux.length == 0 || nits.length == 0) {
                throw new IllegalArgumentException("Lux and nits arrays must not be empty");
            }
            if (lux.length != nits.length) {
                throw new IllegalArgumentException("Lux and nits arrays must be the same length");
            }
            if (lux[0] != 0.0f) {
                throw new IllegalArgumentException("Initial control point must be for 0 lux");
            }
            Preconditions.checkArrayElementsInRange(lux, 0.0f, Float.MAX_VALUE, "lux");
            Preconditions.checkArrayElementsInRange(nits, 0.0f, Float.MAX_VALUE, "nits");
            Builder.checkMonotonic(lux, true, "lux");
            Builder.checkMonotonic(nits, false, "nits");
            this.mCurveLux = lux;
            this.mCurveNits = nits;
            return this;
        }

        private final Builder $$robo$$android_hardware_display_BrightnessConfiguration_Builder$setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        private final BrightnessConfiguration $$robo$$android_hardware_display_BrightnessConfiguration_Builder$build() {
            if (this.mCurveLux == null || this.mCurveNits == null) {
                throw new IllegalStateException("A curve must be set!");
            }
            return new BrightnessConfiguration(this.mCurveLux, this.mCurveNits, this.mDescription, null);
        }

        private static final void $$robo$$android_hardware_display_BrightnessConfiguration_Builder$checkMonotonic(float[] vals, boolean strictlyIncreasing, String name) {
            if (vals.length <= 1) {
                return;
            }
            float prev = vals[0];
            for (int i = 1; i < vals.length; ++i) {
                if (prev > vals[i] || prev == vals[i] && strictlyIncreasing) {
                    String condition = strictlyIncreasing ? "strictly increasing" : "monotonic";
                    throw new IllegalArgumentException(name + " values must be " + condition);
                }
                prev = vals[i];
            }
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_display_BrightnessConfiguration_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_BrightnessConfiguration_Builder$__constructor__(), this);
        }

        private void __constructor__(float[] fArray, float[] fArray2) {
            this.$$robo$$android_hardware_display_BrightnessConfiguration_Builder$__constructor__(fArray, fArray2);
        }

        public Builder(float[] fArray, float[] fArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_BrightnessConfiguration_Builder$__constructor__(float[] float[] ), this, fArray, fArray2);
        }

        public Builder setCurve(float[] fArray, float[] fArray2) {
            return InvokeDynamicSupport.bootstrap("setCurve", $$robo$$android_hardware_display_BrightnessConfiguration_Builder$setCurve(float[] float[] ), this, fArray, fArray2);
        }

        public Builder setDescription(String string2) {
            return InvokeDynamicSupport.bootstrap("setDescription", $$robo$$android_hardware_display_BrightnessConfiguration_Builder$setDescription(java.lang.String ), this, string2);
        }

        public BrightnessConfiguration build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_hardware_display_BrightnessConfiguration_Builder$build(), this);
        }

        private static void checkMonotonic(float[] fArray, boolean bl, String string2) {
            InvokeDynamicSupport.bootstrapStatic("checkMonotonic", $$robo$$android_hardware_display_BrightnessConfiguration_Builder$checkMonotonic(float[] boolean java.lang.String ), (float[])fArray, (boolean)bl, (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

