/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.content.pm.ParceledListSlice;
import android.graphics.Point;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.Curve;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.IMediaProjection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.DisplayInfo;
import android.view.Surface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IDisplayManager
extends IInterface {
    public DisplayInfo getDisplayInfo(int var1) throws RemoteException;

    public int[] getDisplayIds() throws RemoteException;

    public void registerCallback(IDisplayManagerCallback var1) throws RemoteException;

    public void startWifiDisplayScan() throws RemoteException;

    public void stopWifiDisplayScan() throws RemoteException;

    public void connectWifiDisplay(String var1) throws RemoteException;

    public void disconnectWifiDisplay() throws RemoteException;

    public void renameWifiDisplay(String var1, String var2) throws RemoteException;

    public void forgetWifiDisplay(String var1) throws RemoteException;

    public void pauseWifiDisplay() throws RemoteException;

    public void resumeWifiDisplay() throws RemoteException;

    public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException;

    public void requestColorMode(int var1, int var2) throws RemoteException;

    public void setSaturationLevel(float var1) throws RemoteException;

    public int createVirtualDisplay(IVirtualDisplayCallback var1, IMediaProjection var2, String var3, String var4, int var5, int var6, int var7, Surface var8, int var9, String var10) throws RemoteException;

    public void resizeVirtualDisplay(IVirtualDisplayCallback var1, int var2, int var3, int var4) throws RemoteException;

    public void setVirtualDisplaySurface(IVirtualDisplayCallback var1, Surface var2) throws RemoteException;

    public void releaseVirtualDisplay(IVirtualDisplayCallback var1) throws RemoteException;

    public Point getStableDisplaySize() throws RemoteException;

    public ParceledListSlice getBrightnessEvents(String var1) throws RemoteException;

    public ParceledListSlice getAmbientBrightnessStats() throws RemoteException;

    public void setBrightnessConfigurationForUser(BrightnessConfiguration var1, int var2, String var3) throws RemoteException;

    public BrightnessConfiguration getBrightnessConfigurationForUser(int var1) throws RemoteException;

    public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException;

    public void setTemporaryBrightness(int var1) throws RemoteException;

    public void setTemporaryAutoBrightnessAdjustment(float var1) throws RemoteException;

    public Curve getMinimumBrightnessCurve() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayManager,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.hardware.display.IDisplayManager";
        static int TRANSACTION_getDisplayInfo = 1;
        static int TRANSACTION_getDisplayIds = 2;
        static int TRANSACTION_registerCallback = 3;
        static int TRANSACTION_startWifiDisplayScan = 4;
        static int TRANSACTION_stopWifiDisplayScan = 5;
        static int TRANSACTION_connectWifiDisplay = 6;
        static int TRANSACTION_disconnectWifiDisplay = 7;
        static int TRANSACTION_renameWifiDisplay = 8;
        static int TRANSACTION_forgetWifiDisplay = 9;
        static int TRANSACTION_pauseWifiDisplay = 10;
        static int TRANSACTION_resumeWifiDisplay = 11;
        static int TRANSACTION_getWifiDisplayStatus = 12;
        static int TRANSACTION_requestColorMode = 13;
        static int TRANSACTION_setSaturationLevel = 14;
        static int TRANSACTION_createVirtualDisplay = 15;
        static int TRANSACTION_resizeVirtualDisplay = 16;
        static int TRANSACTION_setVirtualDisplaySurface = 17;
        static int TRANSACTION_releaseVirtualDisplay = 18;
        static int TRANSACTION_getStableDisplaySize = 19;
        static int TRANSACTION_getBrightnessEvents = 20;
        static int TRANSACTION_getAmbientBrightnessStats = 21;
        static int TRANSACTION_setBrightnessConfigurationForUser = 22;
        static int TRANSACTION_getBrightnessConfigurationForUser = 23;
        static int TRANSACTION_getDefaultBrightnessConfiguration = 24;
        static int TRANSACTION_setTemporaryBrightness = 25;
        static int TRANSACTION_setTemporaryAutoBrightnessAdjustment = 26;
        static int TRANSACTION_getMinimumBrightnessCurve = 27;

        private void $$robo$$android_hardware_display_IDisplayManager_Stub$__constructor__() {
            this.attachInterface(this, "android.hardware.display.IDisplayManager");
        }

        private static final IDisplayManager $$robo$$android_hardware_display_IDisplayManager_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.hardware.display.IDisplayManager");
            if (iin != null && iin instanceof IDisplayManager) {
                return (IDisplayManager)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_hardware_display_IDisplayManager_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_hardware_display_IDisplayManager_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = "android.hardware.display.IDisplayManager";
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    DisplayInfo _result = this.getDisplayInfo(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int[] _result = this.getDisplayIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IDisplayManagerCallback _arg0 = IDisplayManagerCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.startWifiDisplayScan();
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.stopWifiDisplayScan();
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.connectWifiDisplay(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.disconnectWifiDisplay();
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.renameWifiDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.forgetWifiDisplay(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    this.pauseWifiDisplay();
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    this.resumeWifiDisplay();
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    WifiDisplayStatus _result = this.getWifiDisplayStatus();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.requestColorMode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    this.setSaturationLevel(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    IMediaProjection _arg1 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    Surface _arg7 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    int _arg8 = data.readInt();
                    String _arg9 = data.readString();
                    int _result = this.createVirtualDisplay(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.resizeVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    Surface _arg1 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    this.setVirtualDisplaySurface(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    this.releaseVirtualDisplay(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    Point _result = this.getStableDisplaySize();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ParceledListSlice _result = this.getBrightnessEvents(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    ParceledListSlice _result = this.getAmbientBrightnessStats();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    BrightnessConfiguration _arg0 = 0 != data.readInt() ? BrightnessConfiguration.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.setBrightnessConfigurationForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    BrightnessConfiguration _result = this.getBrightnessConfigurationForUser(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    BrightnessConfiguration _result = this.getDefaultBrightnessConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setTemporaryBrightness(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    this.setTemporaryAutoBrightnessAdjustment(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    Curve _result = this.getMinimumBrightnessCurve();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_display_IDisplayManager_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_IDisplayManager_Stub$__constructor__(), this);
        }

        public static IDisplayManager asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_hardware_display_IDisplayManager_Stub$asInterface(android.os.IBinder ), (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_display_IDisplayManager_Stub$asBinder(), this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_hardware_display_IDisplayManager_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IDisplayManager,
        ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getInterfaceDescriptor() {
                return "android.hardware.display.IDisplayManager";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final DisplayInfo $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getDisplayInfo(int displayId) throws RemoteException {
                DisplayInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeInt(displayId);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? DisplayInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int[] $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getDisplayIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$registerCallback(IDisplayManagerCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$startWifiDisplayScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$stopWifiDisplayScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$connectWifiDisplay(String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeString(address);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$disconnectWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$renameWifiDisplay(String address, String alias) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeString(address);
                    _data.writeString(alias);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$forgetWifiDisplay(String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeString(address);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$pauseWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$resumeWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiDisplayStatus $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getWifiDisplayStatus() throws RemoteException {
                WifiDisplayStatus _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiDisplayStatus.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$requestColorMode(int displayId, int colorMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeInt(displayId);
                    _data.writeInt(colorMode);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setSaturationLevel(float level) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeFloat(level);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$createVirtualDisplay(IVirtualDisplayCallback callback, IMediaProjection projectionToken, String packageName, String name, int width, int height, int densityDpi, Surface surface, int flags, String uniqueId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeStrongBinder(projectionToken != null ? projectionToken.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(name);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(densityDpi);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeString(uniqueId);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$resizeVirtualDisplay(IVirtualDisplayCallback token, int width, int height, int densityDpi) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(densityDpi);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$releaseVirtualDisplay(IVirtualDisplayCallback token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Point $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getStableDisplaySize() throws RemoteException {
                Point _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Point.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ParceledListSlice $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getBrightnessEvents(String callingPackage) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeString(callingPackage);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ParceledListSlice $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getAmbientBrightnessStats() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    if (c != null) {
                        _data.writeInt(1);
                        c.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final BrightnessConfiguration $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getBrightnessConfigurationForUser(int userId) throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BrightnessConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final BrightnessConfiguration $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getDefaultBrightnessConfiguration() throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? BrightnessConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setTemporaryBrightness(int brightness) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeInt(brightness);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setTemporaryAutoBrightnessAdjustment(float adjustment) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    _data.writeFloat(adjustment);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Curve $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getMinimumBrightnessCurve() throws RemoteException {
                Curve _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.hardware.display.IDisplayManager");
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Curve.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$__constructor__(iBinder);
            }

            public Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$__constructor__(android.os.IBinder ), this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$asBinder(), this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getInterfaceDescriptor(), this);
            }

            @Override
            public DisplayInfo getDisplayInfo(int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDisplayInfo", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getDisplayInfo(int ), this, n);
            }

            @Override
            public int[] getDisplayIds() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDisplayIds", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getDisplayIds(), this);
            }

            @Override
            public void registerCallback(IDisplayManagerCallback iDisplayManagerCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$registerCallback(android.hardware.display.IDisplayManagerCallback ), this, iDisplayManagerCallback);
            }

            @Override
            public void startWifiDisplayScan() throws RemoteException {
                InvokeDynamicSupport.bootstrap("startWifiDisplayScan", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$startWifiDisplayScan(), this);
            }

            @Override
            public void stopWifiDisplayScan() throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopWifiDisplayScan", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$stopWifiDisplayScan(), this);
            }

            @Override
            public void connectWifiDisplay(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("connectWifiDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$connectWifiDisplay(java.lang.String ), this, string2);
            }

            @Override
            public void disconnectWifiDisplay() throws RemoteException {
                InvokeDynamicSupport.bootstrap("disconnectWifiDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$disconnectWifiDisplay(), this);
            }

            @Override
            public void renameWifiDisplay(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("renameWifiDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$renameWifiDisplay(java.lang.String java.lang.String ), this, string2, string3);
            }

            @Override
            public void forgetWifiDisplay(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("forgetWifiDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$forgetWifiDisplay(java.lang.String ), this, string2);
            }

            @Override
            public void pauseWifiDisplay() throws RemoteException {
                InvokeDynamicSupport.bootstrap("pauseWifiDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$pauseWifiDisplay(), this);
            }

            @Override
            public void resumeWifiDisplay() throws RemoteException {
                InvokeDynamicSupport.bootstrap("resumeWifiDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$resumeWifiDisplay(), this);
            }

            @Override
            public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getWifiDisplayStatus", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getWifiDisplayStatus(), this);
            }

            @Override
            public void requestColorMode(int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("requestColorMode", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$requestColorMode(int int ), this, n, n2);
            }

            @Override
            public void setSaturationLevel(float f) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setSaturationLevel", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setSaturationLevel(float ), this, f);
            }

            @Override
            public int createVirtualDisplay(IVirtualDisplayCallback iVirtualDisplayCallback, IMediaProjection iMediaProjection, String string2, String string3, int n, int n2, int n3, Surface surface, int n4, String string4) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("createVirtualDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$createVirtualDisplay(android.hardware.display.IVirtualDisplayCallback android.media.projection.IMediaProjection java.lang.String java.lang.String int int int android.view.Surface int java.lang.String ), this, iVirtualDisplayCallback, iMediaProjection, string2, string3, n, n2, n3, surface, n4, string4);
            }

            @Override
            public void resizeVirtualDisplay(IVirtualDisplayCallback iVirtualDisplayCallback, int n, int n2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("resizeVirtualDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$resizeVirtualDisplay(android.hardware.display.IVirtualDisplayCallback int int int ), this, iVirtualDisplayCallback, n, n2, n3);
            }

            @Override
            public void setVirtualDisplaySurface(IVirtualDisplayCallback iVirtualDisplayCallback, Surface surface) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setVirtualDisplaySurface", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setVirtualDisplaySurface(android.hardware.display.IVirtualDisplayCallback android.view.Surface ), this, iVirtualDisplayCallback, surface);
            }

            @Override
            public void releaseVirtualDisplay(IVirtualDisplayCallback iVirtualDisplayCallback) throws RemoteException {
                InvokeDynamicSupport.bootstrap("releaseVirtualDisplay", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$releaseVirtualDisplay(android.hardware.display.IVirtualDisplayCallback ), this, iVirtualDisplayCallback);
            }

            @Override
            public Point getStableDisplaySize() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getStableDisplaySize", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getStableDisplaySize(), this);
            }

            @Override
            public ParceledListSlice getBrightnessEvents(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getBrightnessEvents", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getBrightnessEvents(java.lang.String ), this, string2);
            }

            @Override
            public ParceledListSlice getAmbientBrightnessStats() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getAmbientBrightnessStats", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getAmbientBrightnessStats(), this);
            }

            @Override
            public void setBrightnessConfigurationForUser(BrightnessConfiguration brightnessConfiguration, int n, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setBrightnessConfigurationForUser", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setBrightnessConfigurationForUser(android.hardware.display.BrightnessConfiguration int java.lang.String ), this, brightnessConfiguration, n, string2);
            }

            @Override
            public BrightnessConfiguration getBrightnessConfigurationForUser(int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getBrightnessConfigurationForUser", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getBrightnessConfigurationForUser(int ), this, n);
            }

            @Override
            public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDefaultBrightnessConfiguration", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getDefaultBrightnessConfiguration(), this);
            }

            @Override
            public void setTemporaryBrightness(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setTemporaryBrightness", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setTemporaryBrightness(int ), this, n);
            }

            @Override
            public void setTemporaryAutoBrightnessAdjustment(float f) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setTemporaryAutoBrightnessAdjustment", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$setTemporaryAutoBrightnessAdjustment(float ), this, f);
            }

            @Override
            public Curve getMinimumBrightnessCurve() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getMinimumBrightnessCurve", $$robo$$android_hardware_display_IDisplayManager_Stub_Proxy$getMinimumBrightnessCurve(), this);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

