/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.annotation.SystemApi;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiVendorCommandListener;
import android.os.RemoteException;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public abstract class HdmiClient
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "HdmiClient";
    IHdmiControlService mService;
    private IHdmiVendorCommandListener mIHdmiVendorCommandListener;

    abstract int getDeviceType();

    private void $$robo$$android_hardware_hdmi_HdmiClient$__constructor__(IHdmiControlService service) {
        this.mService = service;
    }

    private final HdmiDeviceInfo $$robo$$android_hardware_hdmi_HdmiClient$getActiveSource() {
        try {
            return this.mService.getActiveSource();
        }
        catch (RemoteException e) {
            Log.e("HdmiClient", "getActiveSource threw exception ", e);
            return null;
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiClient$sendKeyEvent(int keyCode, boolean isPressed) {
        try {
            this.mService.sendKeyEvent(this.getDeviceType(), keyCode, isPressed);
        }
        catch (RemoteException e) {
            Log.e("HdmiClient", "sendKeyEvent threw exception ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiClient$sendVendorCommand(int targetAddress, byte[] params, boolean hasVendorId) {
        try {
            this.mService.sendVendorCommand(this.getDeviceType(), targetAddress, params, hasVendorId);
        }
        catch (RemoteException e) {
            Log.e("HdmiClient", "failed to send vendor command: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiClient$setVendorCommandListener(HdmiControlManager.VendorCommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mIHdmiVendorCommandListener != null) {
            throw new IllegalStateException("listener was already set");
        }
        try {
            IHdmiVendorCommandListener wrappedListener = HdmiClient.getListenerWrapper(listener);
            this.mService.addVendorCommandListener(wrappedListener, this.getDeviceType());
            this.mIHdmiVendorCommandListener = wrappedListener;
        }
        catch (RemoteException e) {
            Log.e("HdmiClient", "failed to set vendor command listener: ", e);
        }
    }

    private static final IHdmiVendorCommandListener $$robo$$android_hardware_hdmi_HdmiClient$getListenerWrapper(HdmiControlManager.VendorCommandListener listener) {
        return new ShadowedObject(listener){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ HdmiControlManager.VendorCommandListener val$listener;

            private void $$robo$$android_hardware_hdmi_HdmiClient_1$__constructor__(HdmiControlManager.VendorCommandListener vendorCommandListener) {
                this.val$listener = vendorCommandListener;
            }

            private final void $$robo$$android_hardware_hdmi_HdmiClient_1$onReceived(int srcAddress, int destAddress, byte[] params, boolean hasVendorId) {
                this.val$listener.onReceived(srcAddress, destAddress, params, hasVendorId);
            }

            private final void $$robo$$android_hardware_hdmi_HdmiClient_1$onControlStateChanged(boolean enabled, int reason) {
                this.val$listener.onControlStateChanged(enabled, reason);
            }

            private void __constructor__(HdmiControlManager.VendorCommandListener vendorCommandListener) {
                this.$$robo$$android_hardware_hdmi_HdmiClient_1$__constructor__(vendorCommandListener);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiClient_1$__constructor__(android.hardware.hdmi.HdmiControlManager$VendorCommandListener ), this, vendorCommandListener);
            }

            @Override
            public void onReceived(int n, int n2, byte[] byArray, boolean bl) {
                InvokeDynamicSupport.bootstrap("onReceived", $$robo$$android_hardware_hdmi_HdmiClient_1$onReceived(int int byte[] boolean ), this, n, n2, byArray, bl);
            }

            @Override
            public void onControlStateChanged(boolean bl, int n) {
                InvokeDynamicSupport.bootstrap("onControlStateChanged", $$robo$$android_hardware_hdmi_HdmiClient_1$onControlStateChanged(boolean int ), this, bl, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(IHdmiControlService iHdmiControlService) {
        this.$$robo$$android_hardware_hdmi_HdmiClient$__constructor__(iHdmiControlService);
    }

    public HdmiClient(IHdmiControlService iHdmiControlService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiClient$__constructor__(android.hardware.hdmi.IHdmiControlService ), this, iHdmiControlService);
    }

    public HdmiDeviceInfo getActiveSource() {
        return InvokeDynamicSupport.bootstrap("getActiveSource", $$robo$$android_hardware_hdmi_HdmiClient$getActiveSource(), this);
    }

    public void sendKeyEvent(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendKeyEvent", $$robo$$android_hardware_hdmi_HdmiClient$sendKeyEvent(int boolean ), this, n, bl);
    }

    public void sendVendorCommand(int n, byte[] byArray, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendVendorCommand", $$robo$$android_hardware_hdmi_HdmiClient$sendVendorCommand(int byte[] boolean ), this, n, byArray, bl);
    }

    public void setVendorCommandListener(HdmiControlManager.VendorCommandListener vendorCommandListener) {
        InvokeDynamicSupport.bootstrap("setVendorCommandListener", $$robo$$android_hardware_hdmi_HdmiClient$setVendorCommandListener(android.hardware.hdmi.HdmiControlManager$VendorCommandListener ), this, vendorCommandListener);
    }

    private static IHdmiVendorCommandListener getListenerWrapper(HdmiControlManager.VendorCommandListener vendorCommandListener) {
        return InvokeDynamicSupport.bootstrapStatic("getListenerWrapper", $$robo$$android_hardware_hdmi_HdmiClient$getListenerWrapper(android.hardware.hdmi.HdmiControlManager$VendorCommandListener ), (HdmiControlManager.VendorCommandListener)vendorCommandListener);
    }

    public /* synthetic */ HdmiClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HdmiClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

