/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.location.ContextHubClient;
import android.hardware.location.ContextHubClientCallback;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubMessage;
import android.hardware.location.ContextHubTransaction;
import android.hardware.location.IContextHubCallback;
import android.hardware.location.IContextHubClient;
import android.hardware.location.IContextHubClientCallback;
import android.hardware.location.IContextHubService;
import android.hardware.location.IContextHubTransactionCallback;
import android.hardware.location.NanoApp;
import android.hardware.location.NanoAppBinary;
import android.hardware.location.NanoAppFilter;
import android.hardware.location.NanoAppInstanceInfo;
import android.hardware.location.NanoAppMessage;
import android.hardware.location.NanoAppState;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.List;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ContextHubManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ContextHubManager";
    private Looper mMainLooper;
    private IContextHubService mService;
    private Callback mCallback;
    private Handler mCallbackHandler;
    @Deprecated
    private ICallback mLocalCallback;
    private IContextHubCallback.Stub mClientCallback;

    @Deprecated
    private final int[] $$robo$$android_hardware_location_ContextHubManager$getContextHubHandles() {
        try {
            return this.mService.getContextHubHandles();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final ContextHubInfo $$robo$$android_hardware_location_ContextHubManager$getContextHubInfo(int hubHandle) {
        try {
            return this.mService.getContextHubInfo(hubHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final int $$robo$$android_hardware_location_ContextHubManager$loadNanoApp(int hubHandle, NanoApp app) {
        try {
            return this.mService.loadNanoApp(hubHandle, app);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final int $$robo$$android_hardware_location_ContextHubManager$unloadNanoApp(int nanoAppHandle) {
        try {
            return this.mService.unloadNanoApp(nanoAppHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final NanoAppInstanceInfo $$robo$$android_hardware_location_ContextHubManager$getNanoAppInstanceInfo(int nanoAppHandle) {
        try {
            return this.mService.getNanoAppInstanceInfo(nanoAppHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final int[] $$robo$$android_hardware_location_ContextHubManager$findNanoAppOnHub(int hubHandle, NanoAppFilter filter) {
        try {
            return this.mService.findNanoAppOnHub(hubHandle, filter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final int $$robo$$android_hardware_location_ContextHubManager$sendMessage(int hubHandle, int nanoAppHandle, ContextHubMessage message) {
        try {
            return this.mService.sendMessage(hubHandle, nanoAppHandle, message);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ContextHubInfo> $$robo$$android_hardware_location_ContextHubManager$getContextHubs() {
        try {
            return this.mService.getContextHubs();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final IContextHubTransactionCallback $$robo$$android_hardware_location_ContextHubManager$createTransactionCallback(ContextHubTransaction<Void> transaction) {
        return new ShadowedObject(this, transaction){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ContextHubTransaction val$transaction;
            /* synthetic */ ContextHubManager this$0;

            private void $$robo$$android_hardware_location_ContextHubManager_1$__constructor__(ContextHubManager this$0, ContextHubTransaction contextHubTransaction) {
                this.this$0 = this$0;
                this.val$transaction = contextHubTransaction;
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_1$onQueryResponse(int result, List<NanoAppState> nanoappList) {
                Log.e("ContextHubManager", "Received a query callback on a non-query request");
                this.val$transaction.setResponse(new ContextHubTransaction.Response<Object>(7, null));
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_1$onTransactionComplete(int result) {
                this.val$transaction.setResponse(new ContextHubTransaction.Response<Object>(result, null));
            }

            private void __constructor__(ContextHubManager contextHubManager, ContextHubTransaction contextHubTransaction) {
                this.$$robo$$android_hardware_location_ContextHubManager_1$__constructor__(contextHubManager, contextHubTransaction);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_1$__constructor__(android.hardware.location.ContextHubManager android.hardware.location.ContextHubTransaction ), this, contextHubManager, contextHubTransaction);
            }

            @Override
            public void onQueryResponse(int n, List<NanoAppState> list) {
                InvokeDynamicSupport.bootstrap("onQueryResponse", $$robo$$android_hardware_location_ContextHubManager_1$onQueryResponse(int java.util.List<android.hardware.location.NanoAppState> ), this, n, list);
            }

            @Override
            public void onTransactionComplete(int n) {
                InvokeDynamicSupport.bootstrap("onTransactionComplete", $$robo$$android_hardware_location_ContextHubManager_1$onTransactionComplete(int ), this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final IContextHubTransactionCallback $$robo$$android_hardware_location_ContextHubManager$createQueryCallback(ContextHubTransaction<List<NanoAppState>> transaction) {
        return new ShadowedObject(this, transaction){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ContextHubTransaction val$transaction;
            /* synthetic */ ContextHubManager this$0;

            private void $$robo$$android_hardware_location_ContextHubManager_2$__constructor__(ContextHubManager this$0, ContextHubTransaction contextHubTransaction) {
                this.this$0 = this$0;
                this.val$transaction = contextHubTransaction;
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_2$onQueryResponse(int result, List<NanoAppState> nanoappList) {
                this.val$transaction.setResponse(new ContextHubTransaction.Response<List<NanoAppState>>(result, nanoappList));
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_2$onTransactionComplete(int result) {
                Log.e("ContextHubManager", "Received a non-query callback on a query request");
                this.val$transaction.setResponse(new ContextHubTransaction.Response<Object>(7, null));
            }

            private void __constructor__(ContextHubManager contextHubManager, ContextHubTransaction contextHubTransaction) {
                this.$$robo$$android_hardware_location_ContextHubManager_2$__constructor__(contextHubManager, contextHubTransaction);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_2$__constructor__(android.hardware.location.ContextHubManager android.hardware.location.ContextHubTransaction ), this, contextHubManager, contextHubTransaction);
            }

            @Override
            public void onQueryResponse(int n, List<NanoAppState> list) {
                InvokeDynamicSupport.bootstrap("onQueryResponse", $$robo$$android_hardware_location_ContextHubManager_2$onQueryResponse(int java.util.List<android.hardware.location.NanoAppState> ), this, n, list);
            }

            @Override
            public void onTransactionComplete(int n) {
                InvokeDynamicSupport.bootstrap("onTransactionComplete", $$robo$$android_hardware_location_ContextHubManager_2$onTransactionComplete(int ), this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final ContextHubTransaction<Void> $$robo$$android_hardware_location_ContextHubManager$loadNanoApp(ContextHubInfo hubInfo, NanoAppBinary appBinary) {
        Preconditions.checkNotNull(hubInfo, "ContextHubInfo cannot be null");
        Preconditions.checkNotNull(appBinary, "NanoAppBinary cannot be null");
        ContextHubTransaction<Void> transaction = new ContextHubTransaction<Void>(0);
        IContextHubTransactionCallback callback = this.createTransactionCallback(transaction);
        try {
            this.mService.loadNanoAppOnHub(hubInfo.getId(), callback, appBinary);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    private final ContextHubTransaction<Void> $$robo$$android_hardware_location_ContextHubManager$unloadNanoApp(ContextHubInfo hubInfo, long nanoAppId) {
        Preconditions.checkNotNull(hubInfo, "ContextHubInfo cannot be null");
        ContextHubTransaction<Void> transaction = new ContextHubTransaction<Void>(1);
        IContextHubTransactionCallback callback = this.createTransactionCallback(transaction);
        try {
            this.mService.unloadNanoAppFromHub(hubInfo.getId(), callback, nanoAppId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    private final ContextHubTransaction<Void> $$robo$$android_hardware_location_ContextHubManager$enableNanoApp(ContextHubInfo hubInfo, long nanoAppId) {
        Preconditions.checkNotNull(hubInfo, "ContextHubInfo cannot be null");
        ContextHubTransaction<Void> transaction = new ContextHubTransaction<Void>(2);
        IContextHubTransactionCallback callback = this.createTransactionCallback(transaction);
        try {
            this.mService.enableNanoApp(hubInfo.getId(), callback, nanoAppId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    private final ContextHubTransaction<Void> $$robo$$android_hardware_location_ContextHubManager$disableNanoApp(ContextHubInfo hubInfo, long nanoAppId) {
        Preconditions.checkNotNull(hubInfo, "ContextHubInfo cannot be null");
        ContextHubTransaction<Void> transaction = new ContextHubTransaction<Void>(3);
        IContextHubTransactionCallback callback = this.createTransactionCallback(transaction);
        try {
            this.mService.disableNanoApp(hubInfo.getId(), callback, nanoAppId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    private final ContextHubTransaction<List<NanoAppState>> $$robo$$android_hardware_location_ContextHubManager$queryNanoApps(ContextHubInfo hubInfo) {
        Preconditions.checkNotNull(hubInfo, "ContextHubInfo cannot be null");
        ContextHubTransaction<List<NanoAppState>> transaction = new ContextHubTransaction<List<NanoAppState>>(4);
        IContextHubTransactionCallback callback = this.createQueryCallback(transaction);
        try {
            this.mService.queryNanoApps(hubInfo.getId(), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_hardware_location_ContextHubManager$registerCallback(Callback callback) {
        return this.registerCallback(callback, null);
    }

    @Deprecated
    private final int $$robo$$android_hardware_location_ContextHubManager$registerCallback(ICallback callback) {
        if (this.mLocalCallback != null) {
            Log.w("ContextHubManager", "Max number of local callbacks reached!");
            return -1;
        }
        this.mLocalCallback = callback;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_hardware_location_ContextHubManager$registerCallback(Callback callback, Handler handler) {
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (this.mCallback != null) {
                Log.w("ContextHubManager", "Max number of callbacks reached!");
                return -1;
            }
            this.mCallback = callback;
            this.mCallbackHandler = handler;
        }
        return 0;
    }

    private final IContextHubClientCallback $$robo$$android_hardware_location_ContextHubManager$createClientCallback(ContextHubClient client, ContextHubClientCallback callback, Executor executor) {
        return new ShadowedObject(this, executor, callback, client){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Executor val$executor;
            /* synthetic */ ContextHubClientCallback val$callback;
            /* synthetic */ ContextHubClient val$client;
            /* synthetic */ ContextHubManager this$0;

            private void $$robo$$android_hardware_location_ContextHubManager_3$__constructor__(ContextHubManager this$0, Executor executor, ContextHubClientCallback contextHubClientCallback, ContextHubClient contextHubClient) {
                this.this$0 = this$0;
                this.val$executor = executor;
                this.val$callback = contextHubClientCallback;
                this.val$client = contextHubClient;
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_3$onMessageFromNanoApp(NanoAppMessage message) {
                this.val$executor.execute(() -> this.val$callback.onMessageFromNanoApp(this.val$client, message));
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_3$onHubReset() {
                this.val$executor.execute(() -> this.val$callback.onHubReset(this.val$client));
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppAborted(long nanoAppId, int abortCode) {
                this.val$executor.execute(() -> this.val$callback.onNanoAppAborted(this.val$client, nanoAppId, abortCode));
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppLoaded(long nanoAppId) {
                this.val$executor.execute(() -> this.val$callback.onNanoAppLoaded(this.val$client, nanoAppId));
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppUnloaded(long nanoAppId) {
                this.val$executor.execute(() -> this.val$callback.onNanoAppUnloaded(this.val$client, nanoAppId));
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppEnabled(long nanoAppId) {
                this.val$executor.execute(() -> this.val$callback.onNanoAppEnabled(this.val$client, nanoAppId));
            }

            private final void $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppDisabled(long nanoAppId) {
                this.val$executor.execute(() -> this.val$callback.onNanoAppDisabled(this.val$client, nanoAppId));
            }

            private void __constructor__(ContextHubManager contextHubManager, Executor executor, ContextHubClientCallback contextHubClientCallback, ContextHubClient contextHubClient) {
                this.$$robo$$android_hardware_location_ContextHubManager_3$__constructor__(contextHubManager, executor, contextHubClientCallback, contextHubClient);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_3$__constructor__(android.hardware.location.ContextHubManager java.util.concurrent.Executor android.hardware.location.ContextHubClientCallback android.hardware.location.ContextHubClient ), this, contextHubManager, executor, contextHubClientCallback, contextHubClient);
            }

            @Override
            public void onMessageFromNanoApp(NanoAppMessage nanoAppMessage) {
                InvokeDynamicSupport.bootstrap("onMessageFromNanoApp", $$robo$$android_hardware_location_ContextHubManager_3$onMessageFromNanoApp(android.hardware.location.NanoAppMessage ), this, nanoAppMessage);
            }

            @Override
            public void onHubReset() {
                InvokeDynamicSupport.bootstrap("onHubReset", $$robo$$android_hardware_location_ContextHubManager_3$onHubReset(), this);
            }

            @Override
            public void onNanoAppAborted(long l, int n) {
                InvokeDynamicSupport.bootstrap("onNanoAppAborted", $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppAborted(long int ), this, l, n);
            }

            @Override
            public void onNanoAppLoaded(long l) {
                InvokeDynamicSupport.bootstrap("onNanoAppLoaded", $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppLoaded(long ), this, l);
            }

            @Override
            public void onNanoAppUnloaded(long l) {
                InvokeDynamicSupport.bootstrap("onNanoAppUnloaded", $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppUnloaded(long ), this, l);
            }

            @Override
            public void onNanoAppEnabled(long l) {
                InvokeDynamicSupport.bootstrap("onNanoAppEnabled", $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppEnabled(long ), this, l);
            }

            @Override
            public void onNanoAppDisabled(long l) {
                InvokeDynamicSupport.bootstrap("onNanoAppDisabled", $$robo$$android_hardware_location_ContextHubManager_3$onNanoAppDisabled(long ), this, l);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final ContextHubClient $$robo$$android_hardware_location_ContextHubManager$createClient(ContextHubInfo hubInfo, ContextHubClientCallback callback, Executor executor) {
        IContextHubClient clientProxy;
        Preconditions.checkNotNull(callback, "Callback cannot be null");
        Preconditions.checkNotNull(hubInfo, "ContextHubInfo cannot be null");
        Preconditions.checkNotNull(executor, "Executor cannot be null");
        ContextHubClient client = new ContextHubClient(hubInfo);
        IContextHubClientCallback clientInterface = this.createClientCallback(client, callback, executor);
        try {
            clientProxy = this.mService.createClient(clientInterface, hubInfo.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        client.setClientProxy(clientProxy);
        return client;
    }

    private final ContextHubClient $$robo$$android_hardware_location_ContextHubManager$createClient(ContextHubInfo hubInfo, ContextHubClientCallback callback) {
        return this.createClient(hubInfo, callback, new HandlerExecutor(Handler.getMain()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_hardware_location_ContextHubManager$unregisterCallback(Callback callback) {
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (callback != this.mCallback) {
                Log.w("ContextHubManager", "Cannot recognize callback!");
                return -1;
            }
            this.mCallback = null;
            this.mCallbackHandler = null;
        }
        return 0;
    }

    @Deprecated
    private final synchronized int $$robo$$android_hardware_location_ContextHubManager$unregisterCallback(ICallback callback) {
        if (callback != this.mLocalCallback) {
            Log.w("ContextHubManager", "Cannot recognize local callback!");
            return -1;
        }
        this.mLocalCallback = null;
        return 0;
    }

    private void $$robo$$android_hardware_location_ContextHubManager$__constructor__(Context context, Looper mainLooper) throws ServiceManager.ServiceNotFoundException {
        this.mClientCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ContextHubManager this$0;

            private void $$robo$$android_hardware_location_ContextHubManager_4$__constructor__(ContextHubManager this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_location_ContextHubManager_4$onMessageReceipt(int hubId, int nanoAppId, ContextHubMessage message) {
                if (this.this$0.mCallback != null) {
                    4 var4_4 = this;
                    synchronized (var4_4) {
                        Callback callback = this.this$0.mCallback;
                        Handler handler = this.this$0.mCallbackHandler == null ? new Handler(this.this$0.mMainLooper) : this.this$0.mCallbackHandler;
                        handler.post(new Runnable(this, callback, hubId, nanoAppId, message){
                            public /* synthetic */ Object __robo_data__;
                            /* synthetic */ Callback val$callback;
                            /* synthetic */ int val$hubId;
                            /* synthetic */ int val$nanoAppId;
                            /* synthetic */ ContextHubMessage val$message;
                            /* synthetic */ 4 this$1;

                            private void $$robo$$android_hardware_location_ContextHubManager_4_1$__constructor__(4 this$1, Callback callback, int n, int n2, ContextHubMessage contextHubMessage) {
                                this.this$1 = this$1;
                                this.val$callback = callback;
                                this.val$hubId = n;
                                this.val$nanoAppId = n2;
                                this.val$message = contextHubMessage;
                            }

                            private final void $$robo$$android_hardware_location_ContextHubManager_4_1$run() {
                                this.val$callback.onMessageReceipt(this.val$hubId, this.val$nanoAppId, this.val$message);
                            }

                            private void __constructor__(4 var1_1, Callback callback, int n, int n2, ContextHubMessage contextHubMessage) {
                                this.$$robo$$android_hardware_location_ContextHubManager_4_1$__constructor__(var1_1, callback, n, n2, contextHubMessage);
                            }
                            {
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_4_1$__constructor__(android.hardware.location.ContextHubManager$4 android.hardware.location.ContextHubManager$Callback int int android.hardware.location.ContextHubMessage ), this, var1_1, callback, n, n2, contextHubMessage);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_location_ContextHubManager_4_1$run(), this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    }
                }
                if (this.this$0.mLocalCallback != null) {
                    4 var4_5 = this;
                    synchronized (var4_5) {
                        this.this$0.mLocalCallback.onMessageReceipt(hubId, nanoAppId, message);
                    }
                }
            }

            private void __constructor__(ContextHubManager contextHubManager) {
                this.$$robo$$android_hardware_location_ContextHubManager_4$__constructor__(contextHubManager);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_4$__constructor__(android.hardware.location.ContextHubManager ), this, contextHubManager);
            }

            @Override
            public void onMessageReceipt(int n, int n2, ContextHubMessage contextHubMessage) {
                InvokeDynamicSupport.bootstrap("onMessageReceipt", $$robo$$android_hardware_location_ContextHubManager_4$onMessageReceipt(int int android.hardware.location.ContextHubMessage ), this, n, n2, contextHubMessage);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mMainLooper = mainLooper;
        this.mService = IContextHubService.Stub.asInterface(ServiceManager.getServiceOrThrow("contexthub"));
        try {
            this.mService.registerCallback(this.mClientCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int[] getContextHubHandles() {
        return InvokeDynamicSupport.bootstrap("getContextHubHandles", $$robo$$android_hardware_location_ContextHubManager$getContextHubHandles(), this);
    }

    @Deprecated
    public ContextHubInfo getContextHubInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getContextHubInfo", $$robo$$android_hardware_location_ContextHubManager$getContextHubInfo(int ), this, n);
    }

    @Deprecated
    public int loadNanoApp(int n, NanoApp nanoApp) {
        return (int)InvokeDynamicSupport.bootstrap("loadNanoApp", $$robo$$android_hardware_location_ContextHubManager$loadNanoApp(int android.hardware.location.NanoApp ), this, n, nanoApp);
    }

    @Deprecated
    public int unloadNanoApp(int n) {
        return (int)InvokeDynamicSupport.bootstrap("unloadNanoApp", $$robo$$android_hardware_location_ContextHubManager$unloadNanoApp(int ), this, n);
    }

    @Deprecated
    public NanoAppInstanceInfo getNanoAppInstanceInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getNanoAppInstanceInfo", $$robo$$android_hardware_location_ContextHubManager$getNanoAppInstanceInfo(int ), this, n);
    }

    @Deprecated
    public int[] findNanoAppOnHub(int n, NanoAppFilter nanoAppFilter) {
        return InvokeDynamicSupport.bootstrap("findNanoAppOnHub", $$robo$$android_hardware_location_ContextHubManager$findNanoAppOnHub(int android.hardware.location.NanoAppFilter ), this, n, nanoAppFilter);
    }

    @Deprecated
    public int sendMessage(int n, int n2, ContextHubMessage contextHubMessage) {
        return (int)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_hardware_location_ContextHubManager$sendMessage(int int android.hardware.location.ContextHubMessage ), this, n, n2, contextHubMessage);
    }

    public List<ContextHubInfo> getContextHubs() {
        return InvokeDynamicSupport.bootstrap("getContextHubs", $$robo$$android_hardware_location_ContextHubManager$getContextHubs(), this);
    }

    private IContextHubTransactionCallback createTransactionCallback(ContextHubTransaction<Void> contextHubTransaction) {
        return InvokeDynamicSupport.bootstrap("createTransactionCallback", $$robo$$android_hardware_location_ContextHubManager$createTransactionCallback(android.hardware.location.ContextHubTransaction<java.lang.Void> ), this, contextHubTransaction);
    }

    private IContextHubTransactionCallback createQueryCallback(ContextHubTransaction<List<NanoAppState>> contextHubTransaction) {
        return InvokeDynamicSupport.bootstrap("createQueryCallback", $$robo$$android_hardware_location_ContextHubManager$createQueryCallback(android.hardware.location.ContextHubTransaction<java.util.List<android.hardware.location.NanoAppState>> ), this, contextHubTransaction);
    }

    public ContextHubTransaction<Void> loadNanoApp(ContextHubInfo contextHubInfo, NanoAppBinary nanoAppBinary) {
        return InvokeDynamicSupport.bootstrap("loadNanoApp", $$robo$$android_hardware_location_ContextHubManager$loadNanoApp(android.hardware.location.ContextHubInfo android.hardware.location.NanoAppBinary ), this, contextHubInfo, nanoAppBinary);
    }

    public ContextHubTransaction<Void> unloadNanoApp(ContextHubInfo contextHubInfo, long l) {
        return InvokeDynamicSupport.bootstrap("unloadNanoApp", $$robo$$android_hardware_location_ContextHubManager$unloadNanoApp(android.hardware.location.ContextHubInfo long ), this, contextHubInfo, l);
    }

    public ContextHubTransaction<Void> enableNanoApp(ContextHubInfo contextHubInfo, long l) {
        return InvokeDynamicSupport.bootstrap("enableNanoApp", $$robo$$android_hardware_location_ContextHubManager$enableNanoApp(android.hardware.location.ContextHubInfo long ), this, contextHubInfo, l);
    }

    public ContextHubTransaction<Void> disableNanoApp(ContextHubInfo contextHubInfo, long l) {
        return InvokeDynamicSupport.bootstrap("disableNanoApp", $$robo$$android_hardware_location_ContextHubManager$disableNanoApp(android.hardware.location.ContextHubInfo long ), this, contextHubInfo, l);
    }

    public ContextHubTransaction<List<NanoAppState>> queryNanoApps(ContextHubInfo contextHubInfo) {
        return InvokeDynamicSupport.bootstrap("queryNanoApps", $$robo$$android_hardware_location_ContextHubManager$queryNanoApps(android.hardware.location.ContextHubInfo ), this, contextHubInfo);
    }

    @Deprecated
    public int registerCallback(Callback callback) {
        return (int)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_hardware_location_ContextHubManager$registerCallback(android.hardware.location.ContextHubManager$Callback ), this, callback);
    }

    @Deprecated
    public int registerCallback(ICallback iCallback) {
        return (int)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_hardware_location_ContextHubManager$registerCallback(android.hardware.location.ContextHubManager$ICallback ), this, iCallback);
    }

    @Deprecated
    public int registerCallback(Callback callback, Handler handler) {
        return (int)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_hardware_location_ContextHubManager$registerCallback(android.hardware.location.ContextHubManager$Callback android.os.Handler ), this, callback, handler);
    }

    private IContextHubClientCallback createClientCallback(ContextHubClient contextHubClient, ContextHubClientCallback contextHubClientCallback, Executor executor) {
        return InvokeDynamicSupport.bootstrap("createClientCallback", $$robo$$android_hardware_location_ContextHubManager$createClientCallback(android.hardware.location.ContextHubClient android.hardware.location.ContextHubClientCallback java.util.concurrent.Executor ), this, contextHubClient, contextHubClientCallback, executor);
    }

    public ContextHubClient createClient(ContextHubInfo contextHubInfo, ContextHubClientCallback contextHubClientCallback, Executor executor) {
        return InvokeDynamicSupport.bootstrap("createClient", $$robo$$android_hardware_location_ContextHubManager$createClient(android.hardware.location.ContextHubInfo android.hardware.location.ContextHubClientCallback java.util.concurrent.Executor ), this, contextHubInfo, contextHubClientCallback, executor);
    }

    public ContextHubClient createClient(ContextHubInfo contextHubInfo, ContextHubClientCallback contextHubClientCallback) {
        return InvokeDynamicSupport.bootstrap("createClient", $$robo$$android_hardware_location_ContextHubManager$createClient(android.hardware.location.ContextHubInfo android.hardware.location.ContextHubClientCallback ), this, contextHubInfo, contextHubClientCallback);
    }

    @Deprecated
    public int unregisterCallback(Callback callback) {
        return (int)InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_hardware_location_ContextHubManager$unregisterCallback(android.hardware.location.ContextHubManager$Callback ), this, callback);
    }

    @Deprecated
    public synchronized int unregisterCallback(ICallback iCallback) {
        return (int)InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_hardware_location_ContextHubManager$unregisterCallback(android.hardware.location.ContextHubManager$ICallback ), this, iCallback);
    }

    private void __constructor__(Context context, Looper looper) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_hardware_location_ContextHubManager$__constructor__(context, looper);
    }

    public ContextHubManager(Context context, Looper looper) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager$__constructor__(android.content.Context android.os.Looper ), this, context, looper);
    }

    public /* synthetic */ ContextHubManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContextHubManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Deprecated
    public static interface ICallback {
        public void onMessageReceipt(int var1, int var2, ContextHubMessage var3);
    }

    @Deprecated
    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_location_ContextHubManager_Callback$__constructor__() {
        }

        public abstract void onMessageReceipt(int var1, int var2, ContextHubMessage var3);

        private void __constructor__() {
            this.$$robo$$android_hardware_location_ContextHubManager_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_Callback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

