/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NanoAppBinary
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NanoAppBinary";
    private byte[] mNanoAppBinary;
    private int mHeaderVersion;
    private int mMagic;
    private long mNanoAppId;
    private int mNanoAppVersion;
    private int mFlags;
    private long mHwHubType;
    private byte mTargetChreApiMajorVersion;
    private byte mTargetChreApiMinorVersion;
    private boolean mHasValidHeader;
    private static int EXPECTED_HEADER_VERSION = 1;
    private static int EXPECTED_MAGIC_VALUE = 1330528590;
    private static ByteOrder HEADER_ORDER;
    private static int HEADER_SIZE_BYTES = 40;
    private static int NANOAPP_SIGNED_FLAG_BIT = 1;
    private static int NANOAPP_ENCRYPTED_FLAG_BIT = 2;
    public static Parcelable.Creator<NanoAppBinary> CREATOR;

    private void $$robo$$android_hardware_location_NanoAppBinary$__constructor__(byte[] appBinary) {
        this.mHasValidHeader = false;
        this.mNanoAppBinary = appBinary;
        this.parseBinaryHeader();
    }

    private final void $$robo$$android_hardware_location_NanoAppBinary$parseBinaryHeader() {
        ByteBuffer buf = ByteBuffer.wrap(this.mNanoAppBinary).order(HEADER_ORDER);
        this.mHasValidHeader = false;
        try {
            this.mHeaderVersion = buf.getInt();
            if (this.mHeaderVersion != 1) {
                Log.e("NanoAppBinary", "Unexpected header version " + this.mHeaderVersion + " while parsing header (expected " + 1 + ")");
                return;
            }
            this.mMagic = buf.getInt();
            this.mNanoAppId = buf.getLong();
            this.mNanoAppVersion = buf.getInt();
            this.mFlags = buf.getInt();
            this.mHwHubType = buf.getLong();
            this.mTargetChreApiMajorVersion = buf.get();
            this.mTargetChreApiMinorVersion = buf.get();
        }
        catch (BufferUnderflowException e) {
            Log.e("NanoAppBinary", "Not enough contents in nanoapp header");
            return;
        }
        if (this.mMagic != 1330528590) {
            Log.e("NanoAppBinary", "Unexpected magic value " + String.format("0x%08X", this.mMagic) + "while parsing header (expected " + String.format("0x%08X", 1330528590) + ")");
        } else {
            this.mHasValidHeader = true;
        }
    }

    private final byte[] $$robo$$android_hardware_location_NanoAppBinary$getBinary() {
        return this.mNanoAppBinary;
    }

    private final byte[] $$robo$$android_hardware_location_NanoAppBinary$getBinaryNoHeader() {
        if (this.mNanoAppBinary.length < 40) {
            throw new IndexOutOfBoundsException("NanoAppBinary binary byte size (" + this.mNanoAppBinary.length + ") is less than header size (" + 40 + ")");
        }
        return Arrays.copyOfRange(this.mNanoAppBinary, 40, this.mNanoAppBinary.length);
    }

    private final boolean $$robo$$android_hardware_location_NanoAppBinary$hasValidHeader() {
        return this.mHasValidHeader;
    }

    private final int $$robo$$android_hardware_location_NanoAppBinary$getHeaderVersion() {
        return this.mHeaderVersion;
    }

    private final long $$robo$$android_hardware_location_NanoAppBinary$getNanoAppId() {
        return this.mNanoAppId;
    }

    private final int $$robo$$android_hardware_location_NanoAppBinary$getNanoAppVersion() {
        return this.mNanoAppVersion;
    }

    private final long $$robo$$android_hardware_location_NanoAppBinary$getHwHubType() {
        return this.mHwHubType;
    }

    private final byte $$robo$$android_hardware_location_NanoAppBinary$getTargetChreApiMajorVersion() {
        return this.mTargetChreApiMajorVersion;
    }

    private final byte $$robo$$android_hardware_location_NanoAppBinary$getTargetChreApiMinorVersion() {
        return this.mTargetChreApiMinorVersion;
    }

    private final int $$robo$$android_hardware_location_NanoAppBinary$getFlags() {
        return this.mFlags;
    }

    private final boolean $$robo$$android_hardware_location_NanoAppBinary$isSigned() {
        return (this.mFlags & 1) != 0;
    }

    private final boolean $$robo$$android_hardware_location_NanoAppBinary$isEncrypted() {
        return (this.mFlags & 2) != 0;
    }

    private void $$robo$$android_hardware_location_NanoAppBinary$__constructor__(Parcel in) {
        this.mHasValidHeader = false;
        int binaryLength = in.readInt();
        this.mNanoAppBinary = new byte[binaryLength];
        in.readByteArray(this.mNanoAppBinary);
        this.parseBinaryHeader();
    }

    private final int $$robo$$android_hardware_location_NanoAppBinary$describeContents() {
        return 0;
    }

    private final void $$robo$$android_hardware_location_NanoAppBinary$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mNanoAppBinary.length);
        out.writeByteArray(this.mNanoAppBinary);
    }

    private /* synthetic */ void $$robo$$android_hardware_location_NanoAppBinary$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        HEADER_ORDER = ByteOrder.LITTLE_ENDIAN;
        CREATOR = new Parcelable.Creator<NanoAppBinary>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_location_NanoAppBinary_1$__constructor__() {
            }

            private final NanoAppBinary $$robo$$android_hardware_location_NanoAppBinary_1$createFromParcel(Parcel in) {
                return new NanoAppBinary(in, null);
            }

            private final NanoAppBinary[] $$robo$$android_hardware_location_NanoAppBinary_1$newArray(int size) {
                return new NanoAppBinary[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_location_NanoAppBinary_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_NanoAppBinary_1$__constructor__(), this);
            }

            @Override
            public NanoAppBinary createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_location_NanoAppBinary_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public NanoAppBinary[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_location_NanoAppBinary_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(byte[] byArray) {
        this.$$robo$$android_hardware_location_NanoAppBinary$__constructor__(byArray);
    }

    public NanoAppBinary(byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_NanoAppBinary$__constructor__(byte[] ), this, byArray);
    }

    private void parseBinaryHeader() {
        InvokeDynamicSupport.bootstrap("parseBinaryHeader", $$robo$$android_hardware_location_NanoAppBinary$parseBinaryHeader(), this);
    }

    public byte[] getBinary() {
        return InvokeDynamicSupport.bootstrap("getBinary", $$robo$$android_hardware_location_NanoAppBinary$getBinary(), this);
    }

    public byte[] getBinaryNoHeader() {
        return InvokeDynamicSupport.bootstrap("getBinaryNoHeader", $$robo$$android_hardware_location_NanoAppBinary$getBinaryNoHeader(), this);
    }

    public boolean hasValidHeader() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasValidHeader", $$robo$$android_hardware_location_NanoAppBinary$hasValidHeader(), this);
    }

    public int getHeaderVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getHeaderVersion", $$robo$$android_hardware_location_NanoAppBinary$getHeaderVersion(), this);
    }

    public long getNanoAppId() {
        return (long)InvokeDynamicSupport.bootstrap("getNanoAppId", $$robo$$android_hardware_location_NanoAppBinary$getNanoAppId(), this);
    }

    public int getNanoAppVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getNanoAppVersion", $$robo$$android_hardware_location_NanoAppBinary$getNanoAppVersion(), this);
    }

    public long getHwHubType() {
        return (long)InvokeDynamicSupport.bootstrap("getHwHubType", $$robo$$android_hardware_location_NanoAppBinary$getHwHubType(), this);
    }

    public byte getTargetChreApiMajorVersion() {
        return (byte)InvokeDynamicSupport.bootstrap("getTargetChreApiMajorVersion", $$robo$$android_hardware_location_NanoAppBinary$getTargetChreApiMajorVersion(), this);
    }

    public byte getTargetChreApiMinorVersion() {
        return (byte)InvokeDynamicSupport.bootstrap("getTargetChreApiMinorVersion", $$robo$$android_hardware_location_NanoAppBinary$getTargetChreApiMinorVersion(), this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_hardware_location_NanoAppBinary$getFlags(), this);
    }

    public boolean isSigned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSigned", $$robo$$android_hardware_location_NanoAppBinary$isSigned(), this);
    }

    public boolean isEncrypted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEncrypted", $$robo$$android_hardware_location_NanoAppBinary$isEncrypted(), this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_hardware_location_NanoAppBinary$__constructor__(parcel);
    }

    public NanoAppBinary(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_NanoAppBinary$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_location_NanoAppBinary$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_location_NanoAppBinary$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_hardware_location_NanoAppBinary$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ NanoAppBinary(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_NanoAppBinary$__constructor__(android.os.Parcel android.hardware.location.NanoAppBinary$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(NanoAppBinary.class);
    }

    public /* synthetic */ NanoAppBinary() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NanoAppBinary)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

