/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.radio.Announcement;
import android.hardware.radio.IAnnouncementListener;
import android.hardware.radio.ICloseHandle;
import android.hardware.radio.IRadioService;
import android.hardware.radio.ITuner;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.hardware.radio.TunerAdapter;
import android.hardware.radio.TunerCallbackAdapter;
import android.hardware.radio.Utils;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class RadioManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BroadcastRadio.manager";
    public static int STATUS_OK = 0;
    public static int STATUS_ERROR = Integer.MIN_VALUE;
    public static int STATUS_PERMISSION_DENIED = -1;
    public static int STATUS_NO_INIT = -19;
    public static int STATUS_BAD_VALUE = -22;
    public static int STATUS_DEAD_OBJECT = -32;
    public static int STATUS_INVALID_OPERATION = -38;
    public static int STATUS_TIMED_OUT = -110;
    public static int CLASS_AM_FM = 0;
    public static int CLASS_SAT = 1;
    public static int CLASS_DT = 2;
    public static int BAND_INVALID = -1;
    public static int BAND_AM = 0;
    public static int BAND_FM = 1;
    public static int BAND_FM_HD = 2;
    public static int BAND_AM_HD = 3;
    public static int REGION_ITU_1 = 0;
    public static int REGION_ITU_2 = 1;
    public static int REGION_OIRT = 2;
    public static int REGION_JAPAN = 3;
    public static int REGION_KOREA = 4;
    public static int CONFIG_FORCE_MONO = 1;
    public static int CONFIG_FORCE_ANALOG = 2;
    public static int CONFIG_FORCE_DIGITAL = 3;
    public static int CONFIG_RDS_AF = 4;
    public static int CONFIG_RDS_REG = 5;
    public static int CONFIG_DAB_DAB_LINKING = 6;
    public static int CONFIG_DAB_FM_LINKING = 7;
    public static int CONFIG_DAB_DAB_SOFT_LINKING = 8;
    public static int CONFIG_DAB_FM_SOFT_LINKING = 9;
    private Map<Announcement.OnListUpdatedListener, ICloseHandle> mAnnouncementListeners;
    private Context mContext;
    private IRadioService mService;

    private final int $$robo$$android_hardware_radio_RadioManager$listModules(List<ModuleProperties> modules) {
        List<ModuleProperties> returnedList;
        if (modules == null) {
            Log.e("BroadcastRadio.manager", "the output list must not be empty");
            return -22;
        }
        Log.d("BroadcastRadio.manager", "Listing available tuners...");
        try {
            returnedList = this.mService.listModules();
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.manager", "Failed listing available tuners", e);
            return -32;
        }
        if (returnedList == null) {
            Log.e("BroadcastRadio.manager", "Returned list was a null");
            return Integer.MIN_VALUE;
        }
        modules.addAll(returnedList);
        return 0;
    }

    private final int $$robo$$android_hardware_radio_RadioManager$nativeListModules(List<ModuleProperties> list) {
        return 0;
    }

    private final RadioTuner $$robo$$android_hardware_radio_RadioManager$openTuner(int moduleId, BandConfig config, boolean withAudio, RadioTuner.Callback callback, Handler handler) {
        ITuner tuner;
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be empty");
        }
        Log.d("BroadcastRadio.manager", "Opening tuner " + moduleId + "...");
        TunerCallbackAdapter halCallback = new TunerCallbackAdapter(callback, handler);
        try {
            tuner = this.mService.openTuner(moduleId, config, withAudio, halCallback);
        }
        catch (RemoteException | IllegalArgumentException ex) {
            Log.e("BroadcastRadio.manager", "Failed to open tuner", ex);
            return null;
        }
        if (tuner == null) {
            Log.e("BroadcastRadio.manager", "Failed to open tuner");
            return null;
        }
        return new TunerAdapter(tuner, halCallback, config != null ? config.getType() : -1);
    }

    private final void $$robo$$android_hardware_radio_RadioManager$addAnnouncementListener(Set<Integer> enabledAnnouncementTypes, Announcement.OnListUpdatedListener listener) {
        this.addAnnouncementListener(cmd -> cmd.run(), enabledAnnouncementTypes, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_RadioManager$addAnnouncementListener(Executor executor, Set<Integer> enabledAnnouncementTypes, Announcement.OnListUpdatedListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        int[] types = enabledAnnouncementTypes.stream().mapToInt(Integer::intValue).toArray();
        ShadowedObject listenerIface = new ShadowedObject(this, executor, listener){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Executor val$executor;
            /* synthetic */ Announcement.OnListUpdatedListener val$listener;
            /* synthetic */ RadioManager this$0;

            private void $$robo$$android_hardware_radio_RadioManager_1$__constructor__(RadioManager this$0, Executor executor, Announcement.OnListUpdatedListener onListUpdatedListener) {
                this.this$0 = this$0;
                this.val$executor = executor;
                this.val$listener = onListUpdatedListener;
            }

            private final void $$robo$$android_hardware_radio_RadioManager_1$onListUpdated(List<Announcement> activeAnnouncements) {
                this.val$executor.execute(() -> this.val$listener.onListUpdated(activeAnnouncements));
            }

            private void __constructor__(RadioManager radioManager, Executor executor, Announcement.OnListUpdatedListener onListUpdatedListener) {
                this.$$robo$$android_hardware_radio_RadioManager_1$__constructor__(radioManager, executor, onListUpdatedListener);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_1$__constructor__(android.hardware.radio.RadioManager java.util.concurrent.Executor android.hardware.radio.Announcement$OnListUpdatedListener ), this, radioManager, executor, onListUpdatedListener);
            }

            @Override
            public void onListUpdated(List<Announcement> list) {
                InvokeDynamicSupport.bootstrap("onListUpdated", $$robo$$android_hardware_radio_RadioManager_1$onListUpdated(java.util.List<android.hardware.radio.Announcement> ), this, list);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        Map<Announcement.OnListUpdatedListener, ICloseHandle> map = this.mAnnouncementListeners;
        synchronized (map) {
            ICloseHandle closeHandle = null;
            try {
                closeHandle = this.mService.addAnnouncementListener(types, (IAnnouncementListener)listenerIface);
            }
            catch (RemoteException ex) {
                ex.rethrowFromSystemServer();
            }
            Objects.requireNonNull(closeHandle);
            ICloseHandle oldCloseHandle = this.mAnnouncementListeners.put(listener, closeHandle);
            if (oldCloseHandle != null) {
                Utils.close(oldCloseHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_RadioManager$removeAnnouncementListener(Announcement.OnListUpdatedListener listener) {
        Objects.requireNonNull(listener);
        Map<Announcement.OnListUpdatedListener, ICloseHandle> map = this.mAnnouncementListeners;
        synchronized (map) {
            ICloseHandle closeHandle = this.mAnnouncementListeners.remove(listener);
            if (closeHandle != null) {
                Utils.close(closeHandle);
            }
        }
    }

    private void $$robo$$android_hardware_radio_RadioManager$__constructor__(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mAnnouncementListeners = new HashMap<Announcement.OnListUpdatedListener, ICloseHandle>();
        this.mContext = context;
        this.mService = IRadioService.Stub.asInterface(ServiceManager.getServiceOrThrow("broadcastradio"));
    }

    public int listModules(List<ModuleProperties> list) {
        return (int)InvokeDynamicSupport.bootstrap("listModules", $$robo$$android_hardware_radio_RadioManager$listModules(java.util.List<android.hardware.radio.RadioManager$ModuleProperties> ), this, list);
    }

    private int nativeListModules(List<ModuleProperties> list) {
        return (int)InvokeDynamicSupport.bootstrap("nativeListModules", $$robo$$android_hardware_radio_RadioManager$nativeListModules(java.util.List<android.hardware.radio.RadioManager$ModuleProperties> ), this, list);
    }

    public RadioTuner openTuner(int n, BandConfig bandConfig, boolean bl, RadioTuner.Callback callback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("openTuner", $$robo$$android_hardware_radio_RadioManager$openTuner(int android.hardware.radio.RadioManager$BandConfig boolean android.hardware.radio.RadioTuner$Callback android.os.Handler ), this, n, bandConfig, bl, callback, handler);
    }

    public void addAnnouncementListener(Set<Integer> set, Announcement.OnListUpdatedListener onListUpdatedListener) {
        InvokeDynamicSupport.bootstrap("addAnnouncementListener", $$robo$$android_hardware_radio_RadioManager$addAnnouncementListener(java.util.Set<java.lang.Integer> android.hardware.radio.Announcement$OnListUpdatedListener ), this, set, onListUpdatedListener);
    }

    public void addAnnouncementListener(Executor executor, Set<Integer> set, Announcement.OnListUpdatedListener onListUpdatedListener) {
        InvokeDynamicSupport.bootstrap("addAnnouncementListener", $$robo$$android_hardware_radio_RadioManager$addAnnouncementListener(java.util.concurrent.Executor java.util.Set<java.lang.Integer> android.hardware.radio.Announcement$OnListUpdatedListener ), this, executor, set, onListUpdatedListener);
    }

    public void removeAnnouncementListener(Announcement.OnListUpdatedListener onListUpdatedListener) {
        InvokeDynamicSupport.bootstrap("removeAnnouncementListener", $$robo$$android_hardware_radio_RadioManager$removeAnnouncementListener(android.hardware.radio.Announcement$OnListUpdatedListener ), this, onListUpdatedListener);
    }

    private void __constructor__(Context context) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_hardware_radio_RadioManager$__constructor__(context);
    }

    public RadioManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager$__constructor__(android.content.Context ), this, context);
    }

    public /* synthetic */ RadioManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadioManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ProgramInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int FLAG_LIVE = 1;
        private static int FLAG_MUTED = 2;
        private static int FLAG_TRAFFIC_PROGRAM = 4;
        private static int FLAG_TRAFFIC_ANNOUNCEMENT = 8;
        private static int FLAG_TUNED = 16;
        private static int FLAG_STEREO = 32;
        private ProgramSelector mSelector;
        private ProgramSelector.Identifier mLogicallyTunedTo;
        private ProgramSelector.Identifier mPhysicallyTunedTo;
        private Collection<ProgramSelector.Identifier> mRelatedContent;
        private int mInfoFlags;
        private int mSignalQuality;
        private RadioMetadata mMetadata;
        private Map<String, String> mVendorInfo;
        public static Parcelable.Creator<ProgramInfo> CREATOR;

        private void $$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(ProgramSelector selector, ProgramSelector.Identifier logicallyTunedTo, ProgramSelector.Identifier physicallyTunedTo, Collection<ProgramSelector.Identifier> relatedContent, int infoFlags, int signalQuality, RadioMetadata metadata, Map<String, String> vendorInfo) {
            this.mSelector = Objects.requireNonNull(selector);
            this.mLogicallyTunedTo = logicallyTunedTo;
            this.mPhysicallyTunedTo = physicallyTunedTo;
            if (relatedContent == null) {
                this.mRelatedContent = Collections.emptyList();
            } else {
                Preconditions.checkCollectionElementsNotNull(relatedContent, "relatedContent");
                this.mRelatedContent = relatedContent;
            }
            this.mInfoFlags = infoFlags;
            this.mSignalQuality = signalQuality;
            this.mMetadata = metadata;
            this.mVendorInfo = vendorInfo == null ? new HashMap() : vendorInfo;
        }

        private final ProgramSelector $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getSelector() {
            return this.mSelector;
        }

        private final ProgramSelector.Identifier $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getLogicallyTunedTo() {
            return this.mLogicallyTunedTo;
        }

        private final ProgramSelector.Identifier $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getPhysicallyTunedTo() {
            return this.mPhysicallyTunedTo;
        }

        private final Collection<ProgramSelector.Identifier> $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getRelatedContent() {
            return this.mRelatedContent;
        }

        @Deprecated
        private final int $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getChannel() {
            try {
                return (int)this.mSelector.getFirstId(1);
            }
            catch (IllegalArgumentException ex) {
                Log.w("BroadcastRadio.manager", "Not an AM/FM program");
                return 0;
            }
        }

        @Deprecated
        private final int $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getSubChannel() {
            try {
                return (int)this.mSelector.getFirstId(4) + 1;
            }
            catch (IllegalArgumentException ex) {
                return 0;
            }
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isTuned() {
            return (this.mInfoFlags & 0x10) != 0;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isStereo() {
            return (this.mInfoFlags & 0x20) != 0;
        }

        @Deprecated
        private final boolean $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isDigital() {
            int type;
            ProgramSelector.Identifier id2 = this.mLogicallyTunedTo;
            if (id2 == null) {
                id2 = this.mSelector.getPrimaryId();
            }
            return (type = id2.getType()) != 1 && type != 2;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isLive() {
            return (this.mInfoFlags & 1) != 0;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isMuted() {
            return (this.mInfoFlags & 2) != 0;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isTrafficProgram() {
            return (this.mInfoFlags & 4) != 0;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isTrafficAnnouncementActive() {
            return (this.mInfoFlags & 8) != 0;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getSignalStrength() {
            return this.mSignalQuality;
        }

        private final RadioMetadata $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getMetadata() {
            return this.mMetadata;
        }

        private final Map<String, String> $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getVendorInfo() {
            return this.mVendorInfo;
        }

        private void $$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(Parcel in) {
            this.mSelector = Objects.requireNonNull(in.readTypedObject(ProgramSelector.CREATOR));
            this.mLogicallyTunedTo = in.readTypedObject(ProgramSelector.Identifier.CREATOR);
            this.mPhysicallyTunedTo = in.readTypedObject(ProgramSelector.Identifier.CREATOR);
            this.mRelatedContent = in.createTypedArrayList(ProgramSelector.Identifier.CREATOR);
            this.mInfoFlags = in.readInt();
            this.mSignalQuality = in.readInt();
            this.mMetadata = in.readTypedObject(RadioMetadata.CREATOR);
            this.mVendorInfo = Utils.readStringMap(in);
        }

        private final void $$robo$$android_hardware_radio_RadioManager_ProgramInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeTypedObject(this.mSelector, flags);
            dest.writeTypedObject(this.mLogicallyTunedTo, flags);
            dest.writeTypedObject(this.mPhysicallyTunedTo, flags);
            Utils.writeTypedCollection(dest, this.mRelatedContent);
            dest.writeInt(this.mInfoFlags);
            dest.writeInt(this.mSignalQuality);
            dest.writeTypedObject(this.mMetadata, flags);
            Utils.writeStringMap(dest, this.mVendorInfo);
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ProgramInfo$describeContents() {
            return 0;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_ProgramInfo$toString() {
            return "ProgramInfo [selector=" + this.mSelector + ", logicallyTunedTo=" + Objects.toString(this.mLogicallyTunedTo) + ", physicallyTunedTo=" + Objects.toString(this.mPhysicallyTunedTo) + ", relatedContent=" + this.mRelatedContent.size() + ", infoFlags=" + this.mInfoFlags + ", mSignalQuality=" + this.mSignalQuality + ", mMetadata=" + Objects.toString(this.mMetadata) + "]";
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ProgramInfo$hashCode() {
            return Objects.hash(this.mSelector, this.mLogicallyTunedTo, this.mPhysicallyTunedTo, this.mRelatedContent, this.mInfoFlags, this.mSignalQuality, this.mMetadata, this.mVendorInfo);
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ProgramInfo$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProgramInfo)) {
                return false;
            }
            ProgramInfo other = (ProgramInfo)obj;
            if (!Objects.equals(this.mSelector, other.mSelector)) {
                return false;
            }
            if (!Objects.equals(this.mLogicallyTunedTo, other.mLogicallyTunedTo)) {
                return false;
            }
            if (!Objects.equals(this.mPhysicallyTunedTo, other.mPhysicallyTunedTo)) {
                return false;
            }
            if (!Objects.equals(this.mRelatedContent, other.mRelatedContent)) {
                return false;
            }
            if (this.mInfoFlags != other.mInfoFlags) {
                return false;
            }
            if (this.mSignalQuality != other.mSignalQuality) {
                return false;
            }
            if (!Objects.equals(this.mMetadata, other.mMetadata)) {
                return false;
            }
            return Objects.equals(this.mVendorInfo, other.mVendorInfo);
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ProgramInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioManager_ProgramInfo_1$__constructor__() {
                }

                private final ProgramInfo $$robo$$android_hardware_radio_RadioManager_ProgramInfo_1$createFromParcel(Parcel in) {
                    return new ProgramInfo(in, null);
                }

                private final ProgramInfo[] $$robo$$android_hardware_radio_RadioManager_ProgramInfo_1$newArray(int size) {
                    return new ProgramInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioManager_ProgramInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_ProgramInfo_1$__constructor__(), this);
                }

                @Override
                public ProgramInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioManager_ProgramInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ProgramInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioManager_ProgramInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ProgramSelector programSelector, ProgramSelector.Identifier identifier, ProgramSelector.Identifier identifier2, Collection<ProgramSelector.Identifier> collection, int n, int n2, RadioMetadata radioMetadata, Map<String, String> map) {
            this.$$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(programSelector, identifier, identifier2, collection, n, n2, radioMetadata, map);
        }

        public ProgramInfo(ProgramSelector programSelector, ProgramSelector.Identifier identifier, ProgramSelector.Identifier identifier2, Collection<ProgramSelector.Identifier> collection, int n, int n2, RadioMetadata radioMetadata, Map<String, String> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(android.hardware.radio.ProgramSelector android.hardware.radio.ProgramSelector$Identifier android.hardware.radio.ProgramSelector$Identifier java.util.Collection<android.hardware.radio.ProgramSelector$Identifier> int int android.hardware.radio.RadioMetadata java.util.Map<java.lang.String, java.lang.String> ), this, programSelector, identifier, identifier2, collection, n, n2, radioMetadata, map);
        }

        public ProgramSelector getSelector() {
            return InvokeDynamicSupport.bootstrap("getSelector", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getSelector(), this);
        }

        public ProgramSelector.Identifier getLogicallyTunedTo() {
            return InvokeDynamicSupport.bootstrap("getLogicallyTunedTo", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getLogicallyTunedTo(), this);
        }

        public ProgramSelector.Identifier getPhysicallyTunedTo() {
            return InvokeDynamicSupport.bootstrap("getPhysicallyTunedTo", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getPhysicallyTunedTo(), this);
        }

        public Collection<ProgramSelector.Identifier> getRelatedContent() {
            return InvokeDynamicSupport.bootstrap("getRelatedContent", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getRelatedContent(), this);
        }

        @Deprecated
        public int getChannel() {
            return (int)InvokeDynamicSupport.bootstrap("getChannel", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getChannel(), this);
        }

        @Deprecated
        public int getSubChannel() {
            return (int)InvokeDynamicSupport.bootstrap("getSubChannel", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getSubChannel(), this);
        }

        public boolean isTuned() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTuned", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isTuned(), this);
        }

        public boolean isStereo() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStereo", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isStereo(), this);
        }

        @Deprecated
        public boolean isDigital() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDigital", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isDigital(), this);
        }

        public boolean isLive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLive", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isLive(), this);
        }

        public boolean isMuted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isMuted", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isMuted(), this);
        }

        public boolean isTrafficProgram() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTrafficProgram", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isTrafficProgram(), this);
        }

        public boolean isTrafficAnnouncementActive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTrafficAnnouncementActive", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$isTrafficAnnouncementActive(), this);
        }

        public int getSignalStrength() {
            return (int)InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getSignalStrength(), this);
        }

        public RadioMetadata getMetadata() {
            return InvokeDynamicSupport.bootstrap("getMetadata", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getMetadata(), this);
        }

        public Map<String, String> getVendorInfo() {
            return InvokeDynamicSupport.bootstrap("getVendorInfo", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$getVendorInfo(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(parcel);
        }

        public ProgramInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$describeContents(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$toString(), this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ ProgramInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_ProgramInfo$__constructor__(android.os.Parcel android.hardware.radio.RadioManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(ProgramInfo.class);
        }

        public /* synthetic */ ProgramInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgramInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AmBandConfig
    extends BandConfig
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mStereo;
        public static Parcelable.Creator<AmBandConfig> CREATOR;

        private void $$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(AmBandDescriptor descriptor) {
            this.mStereo = descriptor.isStereoSupported();
        }

        private void $$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo) {
            this.mStereo = stereo;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_AmBandConfig$getStereo() {
            return this.mStereo;
        }

        private void $$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(Parcel in) {
            this.mStereo = in.readByte() == 1;
        }

        private final void $$robo$$android_hardware_radio_RadioManager_AmBandConfig$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
        }

        private final int $$robo$$android_hardware_radio_RadioManager_AmBandConfig$describeContents() {
            return 0;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_AmBandConfig$toString() {
            return "AmBandConfig [" + super.toString() + ", mStereo=" + this.mStereo + "]";
        }

        private final int $$robo$$android_hardware_radio_RadioManager_AmBandConfig$hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            return result;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_AmBandConfig$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof AmBandConfig)) {
                return false;
            }
            AmBandConfig other = (AmBandConfig)obj;
            return this.mStereo == other.getStereo();
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<AmBandConfig>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioManager_AmBandConfig_1$__constructor__() {
                }

                private final AmBandConfig $$robo$$android_hardware_radio_RadioManager_AmBandConfig_1$createFromParcel(Parcel in) {
                    return new AmBandConfig(in, null);
                }

                private final AmBandConfig[] $$robo$$android_hardware_radio_RadioManager_AmBandConfig_1$newArray(int size) {
                    return new AmBandConfig[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioManager_AmBandConfig_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandConfig_1$__constructor__(), this);
                }

                @Override
                public AmBandConfig createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioManager_AmBandConfig_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public AmBandConfig[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioManager_AmBandConfig_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(AmBandDescriptor amBandDescriptor) {
            this.$$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(amBandDescriptor);
        }

        public AmBandConfig(AmBandDescriptor amBandDescriptor) {
            super(amBandDescriptor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(android.hardware.radio.RadioManager$AmBandDescriptor ), this, amBandDescriptor);
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.$$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(n, n2, n3, n4, n5, bl);
        }

        public AmBandConfig(int n, int n2, int n3, int n4, int n5, boolean bl) {
            super(n, n2, n3, n4, n5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(int int int int int boolean ), this, n, n2, n3, n4, n5, bl);
        }

        public boolean getStereo() {
            return (boolean)InvokeDynamicSupport.bootstrap("getStereo", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$getStereo(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(parcel);
        }

        public AmBandConfig(Parcel parcel) {
            super(parcel, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$describeContents(), this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$toString(), this);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$hashCode(), this);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ AmBandConfig(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandConfig$__constructor__(android.os.Parcel android.hardware.radio.RadioManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(AmBandConfig.class);
        }

        public /* synthetic */ AmBandConfig() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AmBandConfig)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private BandDescriptor mDescriptor;
            private boolean mStereo;

            private void $$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$__constructor__(AmBandDescriptor descriptor) {
                this.mDescriptor = new BandDescriptor(descriptor.getRegion(), descriptor.getType(), descriptor.getLowerLimit(), descriptor.getUpperLimit(), descriptor.getSpacing());
                this.mStereo = descriptor.isStereoSupported();
            }

            private void $$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$__constructor__(AmBandConfig config) {
                this.mDescriptor = new BandDescriptor(config.getRegion(), config.getType(), config.getLowerLimit(), config.getUpperLimit(), config.getSpacing());
                this.mStereo = config.getStereo();
            }

            private final AmBandConfig $$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$build() {
                AmBandConfig config = new AmBandConfig(this.mDescriptor.getRegion(), this.mDescriptor.getType(), this.mDescriptor.getLowerLimit(), this.mDescriptor.getUpperLimit(), this.mDescriptor.getSpacing(), this.mStereo);
                return config;
            }

            private final Builder $$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$setStereo(boolean state) {
                this.mStereo = state;
                return this;
            }

            private void __constructor__(AmBandDescriptor amBandDescriptor) {
                this.$$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$__constructor__(amBandDescriptor);
            }

            public Builder(AmBandDescriptor amBandDescriptor) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$__constructor__(android.hardware.radio.RadioManager$AmBandDescriptor ), this, amBandDescriptor);
            }

            private void __constructor__(AmBandConfig amBandConfig) {
                this.$$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$__constructor__(amBandConfig);
            }

            public Builder(AmBandConfig amBandConfig) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$__constructor__(android.hardware.radio.RadioManager$AmBandConfig ), this, amBandConfig);
            }

            public AmBandConfig build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$build(), this);
            }

            public Builder setStereo(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setStereo", $$robo$$android_hardware_radio_RadioManager_AmBandConfig_Builder$setStereo(boolean ), this, bl);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class FmBandConfig
    extends BandConfig
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mStereo;
        private boolean mRds;
        private boolean mTa;
        private boolean mAf;
        private boolean mEa;
        public static Parcelable.Creator<FmBandConfig> CREATOR;

        private void $$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(FmBandDescriptor descriptor) {
            this.mStereo = descriptor.isStereoSupported();
            this.mRds = descriptor.isRdsSupported();
            this.mTa = descriptor.isTaSupported();
            this.mAf = descriptor.isAfSupported();
            this.mEa = descriptor.isEaSupported();
        }

        private void $$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo, boolean rds, boolean ta, boolean af, boolean ea) {
            this.mStereo = stereo;
            this.mRds = rds;
            this.mTa = ta;
            this.mAf = af;
            this.mEa = ea;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getStereo() {
            return this.mStereo;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getRds() {
            return this.mRds;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getTa() {
            return this.mTa;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getAf() {
            return this.mAf;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getEa() {
            return this.mEa;
        }

        private void $$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(Parcel in) {
            this.mStereo = in.readByte() == 1;
            this.mRds = in.readByte() == 1;
            this.mTa = in.readByte() == 1;
            this.mAf = in.readByte() == 1;
            this.mEa = in.readByte() == 1;
        }

        private final void $$robo$$android_hardware_radio_RadioManager_FmBandConfig$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
            dest.writeByte((byte)(this.mRds ? 1 : 0));
            dest.writeByte((byte)(this.mTa ? 1 : 0));
            dest.writeByte((byte)(this.mAf ? 1 : 0));
            dest.writeByte((byte)(this.mEa ? 1 : 0));
        }

        private final int $$robo$$android_hardware_radio_RadioManager_FmBandConfig$describeContents() {
            return 0;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_FmBandConfig$toString() {
            return "FmBandConfig [" + super.toString() + ", mStereo=" + this.mStereo + ", mRds=" + this.mRds + ", mTa=" + this.mTa + ", mAf=" + this.mAf + ", mEa =" + this.mEa + "]";
        }

        private final int $$robo$$android_hardware_radio_RadioManager_FmBandConfig$hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            result = 31 * result + (this.mRds ? 1 : 0);
            result = 31 * result + (this.mTa ? 1 : 0);
            result = 31 * result + (this.mAf ? 1 : 0);
            result = 31 * result + (this.mEa ? 1 : 0);
            return result;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandConfig$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof FmBandConfig)) {
                return false;
            }
            FmBandConfig other = (FmBandConfig)obj;
            if (this.mStereo != other.mStereo) {
                return false;
            }
            if (this.mRds != other.mRds) {
                return false;
            }
            if (this.mTa != other.mTa) {
                return false;
            }
            if (this.mAf != other.mAf) {
                return false;
            }
            return this.mEa == other.mEa;
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<FmBandConfig>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioManager_FmBandConfig_1$__constructor__() {
                }

                private final FmBandConfig $$robo$$android_hardware_radio_RadioManager_FmBandConfig_1$createFromParcel(Parcel in) {
                    return new FmBandConfig(in, null);
                }

                private final FmBandConfig[] $$robo$$android_hardware_radio_RadioManager_FmBandConfig_1$newArray(int size) {
                    return new FmBandConfig[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioManager_FmBandConfig_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_1$__constructor__(), this);
                }

                @Override
                public FmBandConfig createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public FmBandConfig[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(FmBandDescriptor fmBandDescriptor) {
            this.$$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(fmBandDescriptor);
        }

        public FmBandConfig(FmBandDescriptor fmBandDescriptor) {
            super(fmBandDescriptor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(android.hardware.radio.RadioManager$FmBandDescriptor ), this, fmBandDescriptor);
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this.$$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(n, n2, n3, n4, n5, bl, bl2, bl3, bl4, bl5);
        }

        public FmBandConfig(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            super(n, n2, n3, n4, n5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(int int int int int boolean boolean boolean boolean boolean ), this, n, n2, n3, n4, n5, bl, bl2, bl3, bl4, bl5);
        }

        public boolean getStereo() {
            return (boolean)InvokeDynamicSupport.bootstrap("getStereo", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getStereo(), this);
        }

        public boolean getRds() {
            return (boolean)InvokeDynamicSupport.bootstrap("getRds", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getRds(), this);
        }

        public boolean getTa() {
            return (boolean)InvokeDynamicSupport.bootstrap("getTa", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getTa(), this);
        }

        public boolean getAf() {
            return (boolean)InvokeDynamicSupport.bootstrap("getAf", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getAf(), this);
        }

        public boolean getEa() {
            return (boolean)InvokeDynamicSupport.bootstrap("getEa", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$getEa(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(parcel);
        }

        public FmBandConfig(Parcel parcel) {
            super(parcel, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$describeContents(), this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$toString(), this);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$hashCode(), this);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ FmBandConfig(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandConfig$__constructor__(android.os.Parcel android.hardware.radio.RadioManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(FmBandConfig.class);
        }

        public /* synthetic */ FmBandConfig() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FmBandConfig)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Builder
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private BandDescriptor mDescriptor;
            private boolean mStereo;
            private boolean mRds;
            private boolean mTa;
            private boolean mAf;
            private boolean mEa;

            private void $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$__constructor__(FmBandDescriptor descriptor) {
                this.mDescriptor = new BandDescriptor(descriptor.getRegion(), descriptor.getType(), descriptor.getLowerLimit(), descriptor.getUpperLimit(), descriptor.getSpacing());
                this.mStereo = descriptor.isStereoSupported();
                this.mRds = descriptor.isRdsSupported();
                this.mTa = descriptor.isTaSupported();
                this.mAf = descriptor.isAfSupported();
                this.mEa = descriptor.isEaSupported();
            }

            private void $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$__constructor__(FmBandConfig config) {
                this.mDescriptor = new BandDescriptor(config.getRegion(), config.getType(), config.getLowerLimit(), config.getUpperLimit(), config.getSpacing());
                this.mStereo = config.getStereo();
                this.mRds = config.getRds();
                this.mTa = config.getTa();
                this.mAf = config.getAf();
                this.mEa = config.getEa();
            }

            private final FmBandConfig $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$build() {
                FmBandConfig config = new FmBandConfig(this.mDescriptor.getRegion(), this.mDescriptor.getType(), this.mDescriptor.getLowerLimit(), this.mDescriptor.getUpperLimit(), this.mDescriptor.getSpacing(), this.mStereo, this.mRds, this.mTa, this.mAf, this.mEa);
                return config;
            }

            private final Builder $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setStereo(boolean state) {
                this.mStereo = state;
                return this;
            }

            private final Builder $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setRds(boolean state) {
                this.mRds = state;
                return this;
            }

            private final Builder $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setTa(boolean state) {
                this.mTa = state;
                return this;
            }

            private final Builder $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setAf(boolean state) {
                this.mAf = state;
                return this;
            }

            private final Builder $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setEa(boolean state) {
                this.mEa = state;
                return this;
            }

            private void __constructor__(FmBandDescriptor fmBandDescriptor) {
                this.$$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$__constructor__(fmBandDescriptor);
            }

            public Builder(FmBandDescriptor fmBandDescriptor) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$__constructor__(android.hardware.radio.RadioManager$FmBandDescriptor ), this, fmBandDescriptor);
            }

            private void __constructor__(FmBandConfig fmBandConfig) {
                this.$$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$__constructor__(fmBandConfig);
            }

            public Builder(FmBandConfig fmBandConfig) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$__constructor__(android.hardware.radio.RadioManager$FmBandConfig ), this, fmBandConfig);
            }

            public FmBandConfig build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$build(), this);
            }

            public Builder setStereo(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setStereo", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setStereo(boolean ), this, bl);
            }

            public Builder setRds(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setRds", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setRds(boolean ), this, bl);
            }

            public Builder setTa(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setTa", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setTa(boolean ), this, bl);
            }

            public Builder setAf(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setAf", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setAf(boolean ), this, bl);
            }

            public Builder setEa(boolean bl) {
                return InvokeDynamicSupport.bootstrap("setEa", $$robo$$android_hardware_radio_RadioManager_FmBandConfig_Builder$setEa(boolean ), this, bl);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class BandConfig
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        BandDescriptor mDescriptor;
        public static Parcelable.Creator<BandConfig> CREATOR;

        private void $$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(BandDescriptor descriptor) {
            this.mDescriptor = Objects.requireNonNull(descriptor);
        }

        private void $$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(int region, int type, int lowerLimit, int upperLimit, int spacing) {
            this.mDescriptor = new BandDescriptor(region, type, lowerLimit, upperLimit, spacing);
        }

        private void $$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(Parcel in) {
            this.mDescriptor = new BandDescriptor(in, null);
        }

        private final BandDescriptor $$robo$$android_hardware_radio_RadioManager_BandConfig$getDescriptor() {
            return this.mDescriptor;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandConfig$getRegion() {
            return this.mDescriptor.getRegion();
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandConfig$getType() {
            return this.mDescriptor.getType();
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandConfig$getLowerLimit() {
            return this.mDescriptor.getLowerLimit();
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandConfig$getUpperLimit() {
            return this.mDescriptor.getUpperLimit();
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandConfig$getSpacing() {
            return this.mDescriptor.getSpacing();
        }

        private final void $$robo$$android_hardware_radio_RadioManager_BandConfig$writeToParcel(Parcel dest, int flags) {
            this.mDescriptor.writeToParcel(dest, flags);
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandConfig$describeContents() {
            return 0;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_BandConfig$toString() {
            return "BandConfig [ " + this.mDescriptor.toString() + "]";
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandConfig$hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mDescriptor.hashCode();
            return result;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_BandConfig$equals(Object obj) {
            BandConfig other;
            BandDescriptor otherDesc;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BandConfig)) {
                return false;
            }
            if (this.mDescriptor == null != ((otherDesc = (other = (BandConfig)obj).getDescriptor()) == null)) {
                return false;
            }
            return this.mDescriptor == null || this.mDescriptor.equals(otherDesc);
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<BandConfig>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioManager_BandConfig_1$__constructor__() {
                }

                private final BandConfig $$robo$$android_hardware_radio_RadioManager_BandConfig_1$createFromParcel(Parcel in) {
                    int type = BandDescriptor.lookupTypeFromParcel(in);
                    switch (type) {
                        case 1: 
                        case 2: {
                            return new FmBandConfig(in, null);
                        }
                        case 0: 
                        case 3: {
                            return new AmBandConfig(in, null);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported band: " + type);
                }

                private final BandConfig[] $$robo$$android_hardware_radio_RadioManager_BandConfig_1$newArray(int size) {
                    return new BandConfig[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioManager_BandConfig_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandConfig_1$__constructor__(), this);
                }

                @Override
                public BandConfig createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioManager_BandConfig_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public BandConfig[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioManager_BandConfig_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(BandDescriptor bandDescriptor) {
            this.$$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(bandDescriptor);
        }

        public BandConfig(BandDescriptor bandDescriptor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(android.hardware.radio.RadioManager$BandDescriptor ), this, bandDescriptor);
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(n, n2, n3, n4, n5);
        }

        public BandConfig(int n, int n2, int n3, int n4, int n5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(int int int int int ), this, n, n2, n3, n4, n5);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(parcel);
        }

        public BandConfig(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(android.os.Parcel ), this, parcel);
        }

        BandDescriptor getDescriptor() {
            return InvokeDynamicSupport.bootstrap("getDescriptor", $$robo$$android_hardware_radio_RadioManager_BandConfig$getDescriptor(), this);
        }

        public int getRegion() {
            return (int)InvokeDynamicSupport.bootstrap("getRegion", $$robo$$android_hardware_radio_RadioManager_BandConfig$getRegion(), this);
        }

        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_hardware_radio_RadioManager_BandConfig$getType(), this);
        }

        public int getLowerLimit() {
            return (int)InvokeDynamicSupport.bootstrap("getLowerLimit", $$robo$$android_hardware_radio_RadioManager_BandConfig$getLowerLimit(), this);
        }

        public int getUpperLimit() {
            return (int)InvokeDynamicSupport.bootstrap("getUpperLimit", $$robo$$android_hardware_radio_RadioManager_BandConfig$getUpperLimit(), this);
        }

        public int getSpacing() {
            return (int)InvokeDynamicSupport.bootstrap("getSpacing", $$robo$$android_hardware_radio_RadioManager_BandConfig$getSpacing(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioManager_BandConfig$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioManager_BandConfig$describeContents(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_RadioManager_BandConfig$toString(), this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_RadioManager_BandConfig$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_RadioManager_BandConfig$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ BandConfig(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandConfig$__constructor__(android.os.Parcel android.hardware.radio.RadioManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(BandConfig.class);
        }

        public /* synthetic */ BandConfig() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BandConfig)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AmBandDescriptor
    extends BandDescriptor
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mStereo;
        public static Parcelable.Creator<AmBandDescriptor> CREATOR;

        private void $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo) {
            this.mStereo = stereo;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$isStereoSupported() {
            return this.mStereo;
        }

        private void $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(Parcel in) {
            this.mStereo = in.readByte() == 1;
        }

        private final void $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
        }

        private final int $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$describeContents() {
            return 0;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$toString() {
            return "AmBandDescriptor [ " + super.toString() + " mStereo=" + this.mStereo + "]";
        }

        private final int $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            return result;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof AmBandDescriptor)) {
                return false;
            }
            AmBandDescriptor other = (AmBandDescriptor)obj;
            return this.mStereo == other.isStereoSupported();
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<AmBandDescriptor>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor_1$__constructor__() {
                }

                private final AmBandDescriptor $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor_1$createFromParcel(Parcel in) {
                    return new AmBandDescriptor(in, null);
                }

                private final AmBandDescriptor[] $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor_1$newArray(int size) {
                    return new AmBandDescriptor[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioManager_AmBandDescriptor_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor_1$__constructor__(), this);
                }

                @Override
                public AmBandDescriptor createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public AmBandDescriptor[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.$$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(n, n2, n3, n4, n5, bl);
        }

        public AmBandDescriptor(int n, int n2, int n3, int n4, int n5, boolean bl) {
            super(n, n2, n3, n4, n5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(int int int int int boolean ), this, n, n2, n3, n4, n5, bl);
        }

        public boolean isStereoSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStereoSupported", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$isStereoSupported(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(parcel);
        }

        public AmBandDescriptor(Parcel parcel) {
            super(parcel, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$describeContents(), this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$toString(), this);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$hashCode(), this);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ AmBandDescriptor(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_AmBandDescriptor$__constructor__(android.os.Parcel android.hardware.radio.RadioManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(AmBandDescriptor.class);
        }

        public /* synthetic */ AmBandDescriptor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AmBandDescriptor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class FmBandDescriptor
    extends BandDescriptor
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mStereo;
        private boolean mRds;
        private boolean mTa;
        private boolean mAf;
        private boolean mEa;
        public static Parcelable.Creator<FmBandDescriptor> CREATOR;

        private void $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo, boolean rds, boolean ta, boolean af, boolean ea) {
            this.mStereo = stereo;
            this.mRds = rds;
            this.mTa = ta;
            this.mAf = af;
            this.mEa = ea;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isStereoSupported() {
            return this.mStereo;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isRdsSupported() {
            return this.mRds;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isTaSupported() {
            return this.mTa;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isAfSupported() {
            return this.mAf;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isEaSupported() {
            return this.mEa;
        }

        private void $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(Parcel in) {
            this.mStereo = in.readByte() == 1;
            this.mRds = in.readByte() == 1;
            this.mTa = in.readByte() == 1;
            this.mAf = in.readByte() == 1;
            this.mEa = in.readByte() == 1;
        }

        private final void $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
            dest.writeByte((byte)(this.mRds ? 1 : 0));
            dest.writeByte((byte)(this.mTa ? 1 : 0));
            dest.writeByte((byte)(this.mAf ? 1 : 0));
            dest.writeByte((byte)(this.mEa ? 1 : 0));
        }

        private final int $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$describeContents() {
            return 0;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$toString() {
            return "FmBandDescriptor [ " + super.toString() + " mStereo=" + this.mStereo + ", mRds=" + this.mRds + ", mTa=" + this.mTa + ", mAf=" + this.mAf + ", mEa =" + this.mEa + "]";
        }

        private final int $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            result = 31 * result + (this.mRds ? 1 : 0);
            result = 31 * result + (this.mTa ? 1 : 0);
            result = 31 * result + (this.mAf ? 1 : 0);
            result = 31 * result + (this.mEa ? 1 : 0);
            return result;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof FmBandDescriptor)) {
                return false;
            }
            FmBandDescriptor other = (FmBandDescriptor)obj;
            if (this.mStereo != other.isStereoSupported()) {
                return false;
            }
            if (this.mRds != other.isRdsSupported()) {
                return false;
            }
            if (this.mTa != other.isTaSupported()) {
                return false;
            }
            if (this.mAf != other.isAfSupported()) {
                return false;
            }
            return this.mEa == other.isEaSupported();
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<FmBandDescriptor>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor_1$__constructor__() {
                }

                private final FmBandDescriptor $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor_1$createFromParcel(Parcel in) {
                    return new FmBandDescriptor(in, null);
                }

                private final FmBandDescriptor[] $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor_1$newArray(int size) {
                    return new FmBandDescriptor[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioManager_FmBandDescriptor_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor_1$__constructor__(), this);
                }

                @Override
                public FmBandDescriptor createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public FmBandDescriptor[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this.$$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(n, n2, n3, n4, n5, bl, bl2, bl3, bl4, bl5);
        }

        public FmBandDescriptor(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            super(n, n2, n3, n4, n5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(int int int int int boolean boolean boolean boolean boolean ), this, n, n2, n3, n4, n5, bl, bl2, bl3, bl4, bl5);
        }

        public boolean isStereoSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStereoSupported", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isStereoSupported(), this);
        }

        public boolean isRdsSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRdsSupported", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isRdsSupported(), this);
        }

        public boolean isTaSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTaSupported", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isTaSupported(), this);
        }

        public boolean isAfSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAfSupported", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isAfSupported(), this);
        }

        public boolean isEaSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEaSupported", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$isEaSupported(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(parcel);
        }

        public FmBandDescriptor(Parcel parcel) {
            super(parcel, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$describeContents(), this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$toString(), this);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$hashCode(), this);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ FmBandDescriptor(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_FmBandDescriptor$__constructor__(android.os.Parcel android.hardware.radio.RadioManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(FmBandDescriptor.class);
        }

        public /* synthetic */ FmBandDescriptor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FmBandDescriptor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BandDescriptor
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mRegion;
        private int mType;
        private int mLowerLimit;
        private int mUpperLimit;
        private int mSpacing;
        public static Parcelable.Creator<BandDescriptor> CREATOR;

        private void $$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(int region, int type, int lowerLimit, int upperLimit, int spacing) {
            if (type != 0 && type != 1 && type != 2 && type != 3) {
                throw new IllegalArgumentException("Unsupported band: " + type);
            }
            this.mRegion = region;
            this.mType = type;
            this.mLowerLimit = lowerLimit;
            this.mUpperLimit = upperLimit;
            this.mSpacing = spacing;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getRegion() {
            return this.mRegion;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getType() {
            return this.mType;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_BandDescriptor$isAmBand() {
            return this.mType == 0 || this.mType == 3;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_BandDescriptor$isFmBand() {
            return this.mType == 1 || this.mType == 2;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getLowerLimit() {
            return this.mLowerLimit;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getUpperLimit() {
            return this.mUpperLimit;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getSpacing() {
            return this.mSpacing;
        }

        private void $$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(Parcel in) {
            this.mRegion = in.readInt();
            this.mType = in.readInt();
            this.mLowerLimit = in.readInt();
            this.mUpperLimit = in.readInt();
            this.mSpacing = in.readInt();
        }

        private static final int $$robo$$android_hardware_radio_RadioManager_BandDescriptor$lookupTypeFromParcel(Parcel in) {
            int pos = in.dataPosition();
            in.readInt();
            int type = in.readInt();
            in.setDataPosition(pos);
            return type;
        }

        private final void $$robo$$android_hardware_radio_RadioManager_BandDescriptor$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRegion);
            dest.writeInt(this.mType);
            dest.writeInt(this.mLowerLimit);
            dest.writeInt(this.mUpperLimit);
            dest.writeInt(this.mSpacing);
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandDescriptor$describeContents() {
            return 0;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_BandDescriptor$toString() {
            return "BandDescriptor [mRegion=" + this.mRegion + ", mType=" + this.mType + ", mLowerLimit=" + this.mLowerLimit + ", mUpperLimit=" + this.mUpperLimit + ", mSpacing=" + this.mSpacing + "]";
        }

        private final int $$robo$$android_hardware_radio_RadioManager_BandDescriptor$hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mRegion;
            result = 31 * result + this.mType;
            result = 31 * result + this.mLowerLimit;
            result = 31 * result + this.mUpperLimit;
            result = 31 * result + this.mSpacing;
            return result;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_BandDescriptor$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BandDescriptor)) {
                return false;
            }
            BandDescriptor other = (BandDescriptor)obj;
            if (this.mRegion != other.getRegion()) {
                return false;
            }
            if (this.mType != other.getType()) {
                return false;
            }
            if (this.mLowerLimit != other.getLowerLimit()) {
                return false;
            }
            if (this.mUpperLimit != other.getUpperLimit()) {
                return false;
            }
            return this.mSpacing == other.getSpacing();
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<BandDescriptor>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioManager_BandDescriptor_1$__constructor__() {
                }

                private final BandDescriptor $$robo$$android_hardware_radio_RadioManager_BandDescriptor_1$createFromParcel(Parcel in) {
                    int type = BandDescriptor.lookupTypeFromParcel(in);
                    switch (type) {
                        case 1: 
                        case 2: {
                            return new FmBandDescriptor(in, null);
                        }
                        case 0: 
                        case 3: {
                            return new AmBandDescriptor(in, null);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported band: " + type);
                }

                private final BandDescriptor[] $$robo$$android_hardware_radio_RadioManager_BandDescriptor_1$newArray(int size) {
                    return new BandDescriptor[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioManager_BandDescriptor_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandDescriptor_1$__constructor__(), this);
                }

                @Override
                public BandDescriptor createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioManager_BandDescriptor_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public BandDescriptor[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioManager_BandDescriptor_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(n, n2, n3, n4, n5);
        }

        public BandDescriptor(int n, int n2, int n3, int n4, int n5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(int int int int int ), this, n, n2, n3, n4, n5);
        }

        public int getRegion() {
            return (int)InvokeDynamicSupport.bootstrap("getRegion", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getRegion(), this);
        }

        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getType(), this);
        }

        public boolean isAmBand() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAmBand", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$isAmBand(), this);
        }

        public boolean isFmBand() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFmBand", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$isFmBand(), this);
        }

        public int getLowerLimit() {
            return (int)InvokeDynamicSupport.bootstrap("getLowerLimit", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getLowerLimit(), this);
        }

        public int getUpperLimit() {
            return (int)InvokeDynamicSupport.bootstrap("getUpperLimit", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getUpperLimit(), this);
        }

        public int getSpacing() {
            return (int)InvokeDynamicSupport.bootstrap("getSpacing", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$getSpacing(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(parcel);
        }

        public BandDescriptor(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(android.os.Parcel ), this, parcel);
        }

        private static int lookupTypeFromParcel(Parcel parcel) {
            return (int)InvokeDynamicSupport.bootstrapStatic("lookupTypeFromParcel", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$lookupTypeFromParcel(android.os.Parcel ), (Parcel)parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$describeContents(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$toString(), this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ BandDescriptor(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_BandDescriptor$__constructor__(android.os.Parcel android.hardware.radio.RadioManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(BandDescriptor.class);
        }

        public /* synthetic */ BandDescriptor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BandDescriptor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ModuleProperties
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mId;
        private String mServiceName;
        private int mClassId;
        private String mImplementor;
        private String mProduct;
        private String mVersion;
        private String mSerial;
        private int mNumTuners;
        private int mNumAudioSources;
        private boolean mIsInitializationRequired;
        private boolean mIsCaptureSupported;
        private BandDescriptor[] mBands;
        private boolean mIsBgScanSupported;
        private Set<Integer> mSupportedProgramTypes;
        private Set<Integer> mSupportedIdentifierTypes;
        private Map<String, Integer> mDabFrequencyTable;
        private Map<String, String> mVendorInfo;
        public static Parcelable.Creator<ModuleProperties> CREATOR;

        private void $$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(int id2, String serviceName, int classId, String implementor, String product, String version, String serial, int numTuners, int numAudioSources, boolean isInitializationRequired, boolean isCaptureSupported, BandDescriptor[] bands, boolean isBgScanSupported, int[] supportedProgramTypes, int[] supportedIdentifierTypes, Map<String, Integer> dabFrequencyTable, Map<String, String> vendorInfo) {
            this.mId = id2;
            this.mServiceName = TextUtils.isEmpty(serviceName) ? "default" : serviceName;
            this.mClassId = classId;
            this.mImplementor = implementor;
            this.mProduct = product;
            this.mVersion = version;
            this.mSerial = serial;
            this.mNumTuners = numTuners;
            this.mNumAudioSources = numAudioSources;
            this.mIsInitializationRequired = isInitializationRequired;
            this.mIsCaptureSupported = isCaptureSupported;
            this.mBands = bands;
            this.mIsBgScanSupported = isBgScanSupported;
            this.mSupportedProgramTypes = ModuleProperties.arrayToSet(supportedProgramTypes);
            this.mSupportedIdentifierTypes = ModuleProperties.arrayToSet(supportedIdentifierTypes);
            if (dabFrequencyTable != null) {
                for (Map.Entry<String, Integer> entry : dabFrequencyTable.entrySet()) {
                    Objects.requireNonNull(entry.getKey());
                    Objects.requireNonNull(entry.getValue());
                }
            }
            this.mDabFrequencyTable = dabFrequencyTable;
            this.mVendorInfo = vendorInfo == null ? new HashMap() : vendorInfo;
        }

        private static final Set<Integer> $$robo$$android_hardware_radio_RadioManager_ModuleProperties$arrayToSet(int[] arr) {
            return Arrays.stream(arr).boxed().collect(Collectors.toSet());
        }

        private static final int[] $$robo$$android_hardware_radio_RadioManager_ModuleProperties$setToArray(Set<Integer> set) {
            return set.stream().mapToInt(Integer::intValue).toArray();
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getId() {
            return this.mId;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getServiceName() {
            return this.mServiceName;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getClassId() {
            return this.mClassId;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getImplementor() {
            return this.mImplementor;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getProduct() {
            return this.mProduct;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getVersion() {
            return this.mVersion;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getSerial() {
            return this.mSerial;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getNumTuners() {
            return this.mNumTuners;
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getNumAudioSources() {
            return this.mNumAudioSources;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isInitializationRequired() {
            return this.mIsInitializationRequired;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isCaptureSupported() {
            return this.mIsCaptureSupported;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isBackgroundScanningSupported() {
            return this.mIsBgScanSupported;
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isProgramTypeSupported(int type) {
            return this.mSupportedProgramTypes.contains(type);
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isProgramIdentifierSupported(int type) {
            return this.mSupportedIdentifierTypes.contains(type);
        }

        private final Map<String, Integer> $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getDabFrequencyTable() {
            return this.mDabFrequencyTable;
        }

        private final Map<String, String> $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getVendorInfo() {
            return this.mVendorInfo;
        }

        private final BandDescriptor[] $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getBands() {
            return this.mBands;
        }

        private void $$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(Parcel in) {
            this.mId = in.readInt();
            String serviceName = in.readString();
            this.mServiceName = TextUtils.isEmpty(serviceName) ? "default" : serviceName;
            this.mClassId = in.readInt();
            this.mImplementor = in.readString();
            this.mProduct = in.readString();
            this.mVersion = in.readString();
            this.mSerial = in.readString();
            this.mNumTuners = in.readInt();
            this.mNumAudioSources = in.readInt();
            this.mIsInitializationRequired = in.readInt() == 1;
            this.mIsCaptureSupported = in.readInt() == 1;
            Parcelable[] tmp = in.readParcelableArray(BandDescriptor.class.getClassLoader());
            this.mBands = new BandDescriptor[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.mBands[i] = (BandDescriptor)tmp[i];
            }
            this.mIsBgScanSupported = in.readInt() == 1;
            this.mSupportedProgramTypes = ModuleProperties.arrayToSet(in.createIntArray());
            this.mSupportedIdentifierTypes = ModuleProperties.arrayToSet(in.createIntArray());
            this.mDabFrequencyTable = Utils.readStringIntMap(in);
            this.mVendorInfo = Utils.readStringMap(in);
        }

        private final void $$robo$$android_hardware_radio_RadioManager_ModuleProperties$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mId);
            dest.writeString(this.mServiceName);
            dest.writeInt(this.mClassId);
            dest.writeString(this.mImplementor);
            dest.writeString(this.mProduct);
            dest.writeString(this.mVersion);
            dest.writeString(this.mSerial);
            dest.writeInt(this.mNumTuners);
            dest.writeInt(this.mNumAudioSources);
            dest.writeInt(this.mIsInitializationRequired ? 1 : 0);
            dest.writeInt(this.mIsCaptureSupported ? 1 : 0);
            dest.writeParcelableArray(this.mBands, flags);
            dest.writeInt(this.mIsBgScanSupported ? 1 : 0);
            dest.writeIntArray(ModuleProperties.setToArray(this.mSupportedProgramTypes));
            dest.writeIntArray(ModuleProperties.setToArray(this.mSupportedIdentifierTypes));
            Utils.writeStringIntMap(dest, this.mDabFrequencyTable);
            Utils.writeStringMap(dest, this.mVendorInfo);
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ModuleProperties$describeContents() {
            return 0;
        }

        private final String $$robo$$android_hardware_radio_RadioManager_ModuleProperties$toString() {
            return "ModuleProperties [mId=" + this.mId + ", mServiceName=" + this.mServiceName + ", mClassId=" + this.mClassId + ", mImplementor=" + this.mImplementor + ", mProduct=" + this.mProduct + ", mVersion=" + this.mVersion + ", mSerial=" + this.mSerial + ", mNumTuners=" + this.mNumTuners + ", mNumAudioSources=" + this.mNumAudioSources + ", mIsInitializationRequired=" + this.mIsInitializationRequired + ", mIsCaptureSupported=" + this.mIsCaptureSupported + ", mIsBgScanSupported=" + this.mIsBgScanSupported + ", mBands=" + Arrays.toString(this.mBands) + "]";
        }

        private final int $$robo$$android_hardware_radio_RadioManager_ModuleProperties$hashCode() {
            return Objects.hash(this.mId, this.mServiceName, this.mClassId, this.mImplementor, this.mProduct, this.mVersion, this.mSerial, this.mNumTuners, this.mNumAudioSources, this.mIsInitializationRequired, this.mIsCaptureSupported, this.mBands, this.mIsBgScanSupported, this.mDabFrequencyTable, this.mVendorInfo);
        }

        private final boolean $$robo$$android_hardware_radio_RadioManager_ModuleProperties$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleProperties)) {
                return false;
            }
            ModuleProperties other = (ModuleProperties)obj;
            if (this.mId != other.getId()) {
                return false;
            }
            if (!TextUtils.equals(this.mServiceName, other.mServiceName)) {
                return false;
            }
            if (this.mClassId != other.mClassId) {
                return false;
            }
            if (!Objects.equals(this.mImplementor, other.mImplementor)) {
                return false;
            }
            if (!Objects.equals(this.mProduct, other.mProduct)) {
                return false;
            }
            if (!Objects.equals(this.mVersion, other.mVersion)) {
                return false;
            }
            if (!Objects.equals(this.mSerial, other.mSerial)) {
                return false;
            }
            if (this.mNumTuners != other.mNumTuners) {
                return false;
            }
            if (this.mNumAudioSources != other.mNumAudioSources) {
                return false;
            }
            if (this.mIsInitializationRequired != other.mIsInitializationRequired) {
                return false;
            }
            if (this.mIsCaptureSupported != other.mIsCaptureSupported) {
                return false;
            }
            if (!Objects.equals(this.mBands, other.mBands)) {
                return false;
            }
            if (this.mIsBgScanSupported != other.mIsBgScanSupported) {
                return false;
            }
            if (!Objects.equals(this.mDabFrequencyTable, other.mDabFrequencyTable)) {
                return false;
            }
            return Objects.equals(this.mVendorInfo, other.mVendorInfo);
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ModuleProperties>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioManager_ModuleProperties_1$__constructor__() {
                }

                private final ModuleProperties $$robo$$android_hardware_radio_RadioManager_ModuleProperties_1$createFromParcel(Parcel in) {
                    return new ModuleProperties(in, null);
                }

                private final ModuleProperties[] $$robo$$android_hardware_radio_RadioManager_ModuleProperties_1$newArray(int size) {
                    return new ModuleProperties[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioManager_ModuleProperties_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_ModuleProperties_1$__constructor__(), this);
                }

                @Override
                public ModuleProperties createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioManager_ModuleProperties_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ModuleProperties[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioManager_ModuleProperties_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, String string2, int n2, String string3, String string4, String string5, String string6, int n3, int n4, boolean bl, boolean bl2, BandDescriptor[] bandDescriptorArray, boolean bl3, int[] nArray, int[] nArray2, Map<String, Integer> map, Map<String, String> map2) {
            this.$$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(n, string2, n2, string3, string4, string5, string6, n3, n4, bl, bl2, bandDescriptorArray, bl3, nArray, nArray2, map, map2);
        }

        public ModuleProperties(int n, String string2, int n2, String string3, String string4, String string5, String string6, int n3, int n4, boolean bl, boolean bl2, BandDescriptor[] bandDescriptorArray, boolean bl3, int[] nArray, int[] nArray2, Map<String, Integer> map, Map<String, String> map2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(int java.lang.String int java.lang.String java.lang.String java.lang.String java.lang.String int int boolean boolean android.hardware.radio.RadioManager$BandDescriptor[] boolean int[] int[] java.util.Map<java.lang.String, java.lang.Integer> java.util.Map<java.lang.String, java.lang.String> ), this, n, string2, n2, string3, string4, string5, string6, n3, n4, bl, bl2, bandDescriptorArray, bl3, nArray, nArray2, map, map2);
        }

        private static Set<Integer> arrayToSet(int[] nArray) {
            return InvokeDynamicSupport.bootstrapStatic("arrayToSet", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$arrayToSet(int[] ), (int[])nArray);
        }

        private static int[] setToArray(Set<Integer> set) {
            return InvokeDynamicSupport.bootstrapStatic("setToArray", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$setToArray(java.util.Set<java.lang.Integer> ), set);
        }

        public int getId() {
            return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getId(), this);
        }

        public String getServiceName() {
            return InvokeDynamicSupport.bootstrap("getServiceName", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getServiceName(), this);
        }

        public int getClassId() {
            return (int)InvokeDynamicSupport.bootstrap("getClassId", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getClassId(), this);
        }

        public String getImplementor() {
            return InvokeDynamicSupport.bootstrap("getImplementor", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getImplementor(), this);
        }

        public String getProduct() {
            return InvokeDynamicSupport.bootstrap("getProduct", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getProduct(), this);
        }

        public String getVersion() {
            return InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getVersion(), this);
        }

        public String getSerial() {
            return InvokeDynamicSupport.bootstrap("getSerial", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getSerial(), this);
        }

        public int getNumTuners() {
            return (int)InvokeDynamicSupport.bootstrap("getNumTuners", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getNumTuners(), this);
        }

        public int getNumAudioSources() {
            return (int)InvokeDynamicSupport.bootstrap("getNumAudioSources", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getNumAudioSources(), this);
        }

        public boolean isInitializationRequired() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInitializationRequired", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isInitializationRequired(), this);
        }

        public boolean isCaptureSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isCaptureSupported", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isCaptureSupported(), this);
        }

        public boolean isBackgroundScanningSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("isBackgroundScanningSupported", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isBackgroundScanningSupported(), this);
        }

        public boolean isProgramTypeSupported(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isProgramTypeSupported", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isProgramTypeSupported(int ), this, n);
        }

        public boolean isProgramIdentifierSupported(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isProgramIdentifierSupported", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$isProgramIdentifierSupported(int ), this, n);
        }

        public Map<String, Integer> getDabFrequencyTable() {
            return InvokeDynamicSupport.bootstrap("getDabFrequencyTable", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getDabFrequencyTable(), this);
        }

        public Map<String, String> getVendorInfo() {
            return InvokeDynamicSupport.bootstrap("getVendorInfo", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getVendorInfo(), this);
        }

        public BandDescriptor[] getBands() {
            return InvokeDynamicSupport.bootstrap("getBands", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$getBands(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(parcel);
        }

        public ModuleProperties(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$describeContents(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$toString(), this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$equals(java.lang.Object ), this, object);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ ModuleProperties(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioManager_ModuleProperties$__constructor__(android.os.Parcel android.hardware.radio.RadioManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(ModuleProperties.class);
        }

        public /* synthetic */ ModuleProperties() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ModuleProperties)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Band {
    }
}

