/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.util.Slog;
import com.android.internal.util.dump.DualDumpOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DeviceFilter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    public int mVendorId;
    public int mProductId;
    public int mClass;
    public int mSubclass;
    public int mProtocol;
    public String mManufacturerName;
    public String mProductName;
    public String mSerialNumber;

    private void $$robo$$android_hardware_usb_DeviceFilter$__constructor__(int vid, int pid, int clasz, int subclass, int protocol, String manufacturer, String product, String serialnum) {
        this.mVendorId = vid;
        this.mProductId = pid;
        this.mClass = clasz;
        this.mSubclass = subclass;
        this.mProtocol = protocol;
        this.mManufacturerName = manufacturer;
        this.mProductName = product;
        this.mSerialNumber = serialnum;
    }

    private void $$robo$$android_hardware_usb_DeviceFilter$__constructor__(UsbDevice device) {
        this.mVendorId = device.getVendorId();
        this.mProductId = device.getProductId();
        this.mClass = device.getDeviceClass();
        this.mSubclass = device.getDeviceSubclass();
        this.mProtocol = device.getDeviceProtocol();
        this.mManufacturerName = device.getManufacturerName();
        this.mProductName = device.getProductName();
        this.mSerialNumber = device.getSerialNumber();
    }

    private static final DeviceFilter $$robo$$android_hardware_usb_DeviceFilter$read(XmlPullParser parser) throws XmlPullParserException, IOException {
        int vendorId = -1;
        int productId = -1;
        int deviceClass = -1;
        int deviceSubclass = -1;
        int deviceProtocol = -1;
        String manufacturerName = null;
        String productName = null;
        String serialNumber = null;
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            int intValue;
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if ("manufacturer-name".equals(name)) {
                manufacturerName = value;
                continue;
            }
            if ("product-name".equals(name)) {
                productName = value;
                continue;
            }
            if ("serial-number".equals(name)) {
                serialNumber = value;
                continue;
            }
            int radix = 10;
            if (value != null && value.length() > 2 && value.charAt(0) == '0' && (value.charAt(1) == 'x' || value.charAt(1) == 'X')) {
                radix = 16;
                value = value.substring(2);
            }
            try {
                intValue = Integer.parseInt(value, radix);
            }
            catch (NumberFormatException e) {
                Slog.e(TAG, "invalid number for field " + name, e);
                continue;
            }
            if ("vendor-id".equals(name)) {
                vendorId = intValue;
                continue;
            }
            if ("product-id".equals(name)) {
                productId = intValue;
                continue;
            }
            if ("class".equals(name)) {
                deviceClass = intValue;
                continue;
            }
            if ("subclass".equals(name)) {
                deviceSubclass = intValue;
                continue;
            }
            if (!"protocol".equals(name)) continue;
            deviceProtocol = intValue;
        }
        return new DeviceFilter(vendorId, productId, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, serialNumber);
    }

    private final void $$robo$$android_hardware_usb_DeviceFilter$write(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "usb-device");
        if (this.mVendorId != -1) {
            serializer.attribute(null, "vendor-id", Integer.toString(this.mVendorId));
        }
        if (this.mProductId != -1) {
            serializer.attribute(null, "product-id", Integer.toString(this.mProductId));
        }
        if (this.mClass != -1) {
            serializer.attribute(null, "class", Integer.toString(this.mClass));
        }
        if (this.mSubclass != -1) {
            serializer.attribute(null, "subclass", Integer.toString(this.mSubclass));
        }
        if (this.mProtocol != -1) {
            serializer.attribute(null, "protocol", Integer.toString(this.mProtocol));
        }
        if (this.mManufacturerName != null) {
            serializer.attribute(null, "manufacturer-name", this.mManufacturerName);
        }
        if (this.mProductName != null) {
            serializer.attribute(null, "product-name", this.mProductName);
        }
        if (this.mSerialNumber != null) {
            serializer.attribute(null, "serial-number", this.mSerialNumber);
        }
        serializer.endTag(null, "usb-device");
    }

    private final boolean $$robo$$android_hardware_usb_DeviceFilter$matches(int clasz, int subclass, int protocol) {
        return !(this.mClass != -1 && clasz != this.mClass || this.mSubclass != -1 && subclass != this.mSubclass || this.mProtocol != -1 && protocol != this.mProtocol);
    }

    private final boolean $$robo$$android_hardware_usb_DeviceFilter$matches(UsbDevice device) {
        if (this.mVendorId != -1 && device.getVendorId() != this.mVendorId) {
            return false;
        }
        if (this.mProductId != -1 && device.getProductId() != this.mProductId) {
            return false;
        }
        if (this.mManufacturerName != null && device.getManufacturerName() == null) {
            return false;
        }
        if (this.mProductName != null && device.getProductName() == null) {
            return false;
        }
        if (this.mSerialNumber != null && device.getSerialNumber() == null) {
            return false;
        }
        if (this.mManufacturerName != null && device.getManufacturerName() != null && !this.mManufacturerName.equals(device.getManufacturerName())) {
            return false;
        }
        if (this.mProductName != null && device.getProductName() != null && !this.mProductName.equals(device.getProductName())) {
            return false;
        }
        if (this.mSerialNumber != null && device.getSerialNumber() != null && !this.mSerialNumber.equals(device.getSerialNumber())) {
            return false;
        }
        if (this.matches(device.getDeviceClass(), device.getDeviceSubclass(), device.getDeviceProtocol())) {
            return true;
        }
        int count = device.getInterfaceCount();
        for (int i = 0; i < count; ++i) {
            UsbInterface intf = device.getInterface(i);
            if (!this.matches(intf.getInterfaceClass(), intf.getInterfaceSubclass(), intf.getInterfaceProtocol())) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_hardware_usb_DeviceFilter$contains(DeviceFilter device) {
        if (this.mVendorId != -1 && device.mVendorId != this.mVendorId) {
            return false;
        }
        if (this.mProductId != -1 && device.mProductId != this.mProductId) {
            return false;
        }
        if (this.mManufacturerName != null && !Objects.equals(this.mManufacturerName, device.mManufacturerName)) {
            return false;
        }
        if (this.mProductName != null && !Objects.equals(this.mProductName, device.mProductName)) {
            return false;
        }
        if (this.mSerialNumber != null && !Objects.equals(this.mSerialNumber, device.mSerialNumber)) {
            return false;
        }
        return this.matches(device.mClass, device.mSubclass, device.mProtocol);
    }

    private final boolean $$robo$$android_hardware_usb_DeviceFilter$equals(Object obj) {
        if (this.mVendorId == -1 || this.mProductId == -1 || this.mClass == -1 || this.mSubclass == -1 || this.mProtocol == -1) {
            return false;
        }
        if (obj instanceof DeviceFilter) {
            DeviceFilter filter = (DeviceFilter)obj;
            if (filter.mVendorId != this.mVendorId || filter.mProductId != this.mProductId || filter.mClass != this.mClass || filter.mSubclass != this.mSubclass || filter.mProtocol != this.mProtocol) {
                return false;
            }
            if (filter.mManufacturerName != null && this.mManufacturerName == null || filter.mManufacturerName == null && this.mManufacturerName != null || filter.mProductName != null && this.mProductName == null || filter.mProductName == null && this.mProductName != null || filter.mSerialNumber != null && this.mSerialNumber == null || filter.mSerialNumber == null && this.mSerialNumber != null) {
                return false;
            }
            return !(filter.mManufacturerName != null && this.mManufacturerName != null && !this.mManufacturerName.equals(filter.mManufacturerName) || filter.mProductName != null && this.mProductName != null && !this.mProductName.equals(filter.mProductName)) && (filter.mSerialNumber == null || this.mSerialNumber == null || this.mSerialNumber.equals(filter.mSerialNumber));
        }
        if (obj instanceof UsbDevice) {
            UsbDevice device = (UsbDevice)obj;
            if (device.getVendorId() != this.mVendorId || device.getProductId() != this.mProductId || device.getDeviceClass() != this.mClass || device.getDeviceSubclass() != this.mSubclass || device.getDeviceProtocol() != this.mProtocol) {
                return false;
            }
            if (this.mManufacturerName != null && device.getManufacturerName() == null || this.mManufacturerName == null && device.getManufacturerName() != null || this.mProductName != null && device.getProductName() == null || this.mProductName == null && device.getProductName() != null || this.mSerialNumber != null && device.getSerialNumber() == null || this.mSerialNumber == null && device.getSerialNumber() != null) {
                return false;
            }
            return !(device.getManufacturerName() != null && !this.mManufacturerName.equals(device.getManufacturerName()) || device.getProductName() != null && !this.mProductName.equals(device.getProductName())) && (device.getSerialNumber() == null || this.mSerialNumber.equals(device.getSerialNumber()));
        }
        return false;
    }

    private final int $$robo$$android_hardware_usb_DeviceFilter$hashCode() {
        return (this.mVendorId << 16 | this.mProductId) ^ (this.mClass << 16 | this.mSubclass << 8 | this.mProtocol);
    }

    private final String $$robo$$android_hardware_usb_DeviceFilter$toString() {
        return "DeviceFilter[mVendorId=" + this.mVendorId + ",mProductId=" + this.mProductId + ",mClass=" + this.mClass + ",mSubclass=" + this.mSubclass + ",mProtocol=" + this.mProtocol + ",mManufacturerName=" + this.mManufacturerName + ",mProductName=" + this.mProductName + ",mSerialNumber=" + this.mSerialNumber + "]";
    }

    private final void $$robo$$android_hardware_usb_DeviceFilter$dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        dump.write("vendor_id", 0x10500000001L, this.mVendorId);
        dump.write("product_id", 1120986464258L, this.mProductId);
        dump.write("class", 1120986464259L, this.mClass);
        dump.write("subclass", 1120986464260L, this.mSubclass);
        dump.write("protocol", 0x10500000005L, this.mProtocol);
        dump.write("manufacturer_name", 1138166333446L, this.mManufacturerName);
        dump.write("product_name", 1138166333447L, this.mProductName);
        dump.write("serial_number", 1138166333448L, this.mSerialNumber);
        dump.end(token);
    }

    static void __staticInitializer__() {
        TAG = DeviceFilter.class.getSimpleName();
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, String string2, String string3, String string4) {
        this.$$robo$$android_hardware_usb_DeviceFilter$__constructor__(n, n2, n3, n4, n5, string2, string3, string4);
    }

    public DeviceFilter(int n, int n2, int n3, int n4, int n5, String string2, String string3, String string4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_DeviceFilter$__constructor__(int int int int int java.lang.String java.lang.String java.lang.String ), this, n, n2, n3, n4, n5, string2, string3, string4);
    }

    private void __constructor__(UsbDevice usbDevice) {
        this.$$robo$$android_hardware_usb_DeviceFilter$__constructor__(usbDevice);
    }

    public DeviceFilter(UsbDevice usbDevice) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_DeviceFilter$__constructor__(android.hardware.usb.UsbDevice ), this, usbDevice);
    }

    public static DeviceFilter read(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("read", $$robo$$android_hardware_usb_DeviceFilter$read(org.xmlpull.v1.XmlPullParser ), (XmlPullParser)xmlPullParser);
    }

    public void write(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$android_hardware_usb_DeviceFilter$write(org.xmlpull.v1.XmlSerializer ), this, xmlSerializer);
    }

    private boolean matches(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_hardware_usb_DeviceFilter$matches(int int int ), this, n, n2, n3);
    }

    public boolean matches(UsbDevice usbDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_hardware_usb_DeviceFilter$matches(android.hardware.usb.UsbDevice ), this, usbDevice);
    }

    public boolean contains(DeviceFilter deviceFilter) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_hardware_usb_DeviceFilter$contains(android.hardware.usb.DeviceFilter ), this, deviceFilter);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_usb_DeviceFilter$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_usb_DeviceFilter$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_usb_DeviceFilter$toString(), this);
    }

    public void dump(DualDumpOutputStream dualDumpOutputStream, String string2, long l) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_hardware_usb_DeviceFilter$dump(com.android.internal.util.dump.DualDumpOutputStream java.lang.String long ), this, dualDumpOutputStream, string2, l);
    }

    static {
        RobolectricInternals.classInitializing(DeviceFilter.class);
    }

    public /* synthetic */ DeviceFilter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeviceFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

