/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.CurrencyData;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.StandardPlural;
import android.icu.impl.UResource;
import android.icu.util.ICUException;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ICUCurrencyDisplayInfoProvider
implements CurrencyData.CurrencyDisplayInfoProvider,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private volatile ICUCurrencyDisplayInfo currencyDisplayInfoCache;

    private void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider$__constructor__() {
        this.currencyDisplayInfoCache = null;
    }

    private final CurrencyData.CurrencyDisplayInfo $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider$getInstance(ULocale locale, boolean withFallback) {
        ICUCurrencyDisplayInfo instance;
        if (locale == null) {
            locale = ULocale.ROOT;
        }
        if ((instance = this.currencyDisplayInfoCache) == null || !instance.locale.equals(locale) || instance.fallback != withFallback) {
            ICUResourceBundle rb;
            if (withFallback) {
                rb = ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b/curr", locale, ICUResourceBundle.OpenType.LOCALE_DEFAULT_ROOT);
            } else {
                try {
                    rb = ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b/curr", locale, ICUResourceBundle.OpenType.LOCALE_ONLY);
                }
                catch (MissingResourceException e) {
                    return null;
                }
            }
            this.currencyDisplayInfoCache = instance = new ICUCurrencyDisplayInfo(locale, rb, withFallback);
        }
        return instance;
    }

    private final boolean $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider$hasData() {
        return true;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider$__constructor__();
    }

    public ICUCurrencyDisplayInfoProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider$__constructor__(), this);
    }

    @Override
    public CurrencyData.CurrencyDisplayInfo getInstance(ULocale uLocale, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getInstance", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider$getInstance(android.icu.util.ULocale boolean ), this, uLocale, bl);
    }

    @Override
    public boolean hasData() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasData", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider$hasData(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUCurrencyDisplayInfoProvider)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ICUCurrencyDisplayInfo
    extends CurrencyData.CurrencyDisplayInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ULocale locale;
        boolean fallback;
        private ICUResourceBundle rb;
        private volatile FormattingData formattingDataCache;
        private volatile NarrowSymbol narrowSymbolCache;
        private volatile String[] pluralsDataCache;
        private volatile SoftReference<ParsingData> parsingDataCache;
        private volatile Map<String, String> unitPatternsCache;
        private volatile CurrencyData.CurrencySpacingInfo spacingInfoCache;

        private void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$__constructor__(ULocale locale, ICUResourceBundle rb, boolean fallback) {
            this.formattingDataCache = null;
            this.narrowSymbolCache = null;
            this.pluralsDataCache = null;
            this.parsingDataCache = new SoftReference<Object>(null);
            this.unitPatternsCache = null;
            this.spacingInfoCache = null;
            this.locale = locale;
            this.fallback = fallback;
            this.rb = rb;
        }

        private final ULocale $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getULocale() {
            return this.rb.getULocale();
        }

        private final String $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getName(String isoCode) {
            FormattingData formattingData = this.fetchFormattingData(isoCode);
            if (formattingData.displayName == null && this.fallback) {
                return isoCode;
            }
            return formattingData.displayName;
        }

        private final String $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getSymbol(String isoCode) {
            FormattingData formattingData = this.fetchFormattingData(isoCode);
            if (formattingData.symbol == null && this.fallback) {
                return isoCode;
            }
            return formattingData.symbol;
        }

        private final String $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getNarrowSymbol(String isoCode) {
            NarrowSymbol narrowSymbol = this.fetchNarrowSymbol(isoCode);
            if (narrowSymbol.narrowSymbol == null && this.fallback) {
                return isoCode;
            }
            return narrowSymbol.narrowSymbol;
        }

        private final String $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getPluralName(String isoCode, String pluralKey) {
            StandardPlural plural = StandardPlural.orNullFromString(pluralKey);
            String[] pluralsData = this.fetchPluralsData(isoCode);
            String result = null;
            if (plural != null) {
                result = pluralsData[1 + plural.ordinal()];
            }
            if (result == null && this.fallback) {
                result = pluralsData[1 + StandardPlural.OTHER.ordinal()];
            }
            if (result == null && this.fallback) {
                FormattingData formattingData = this.fetchFormattingData(isoCode);
                result = formattingData.displayName;
            }
            if (result == null && this.fallback) {
                result = isoCode;
            }
            return result;
        }

        private final Map<String, String> $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$symbolMap() {
            ParsingData parsingData = this.fetchParsingData();
            return parsingData.symbolToIsoCode;
        }

        private final Map<String, String> $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$nameMap() {
            ParsingData parsingData = this.fetchParsingData();
            return parsingData.nameToIsoCode;
        }

        private final Map<String, String> $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getUnitPatterns() {
            Map<String, String> unitPatterns = this.fetchUnitPatterns();
            return unitPatterns;
        }

        private final CurrencyData.CurrencyFormatInfo $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getFormatInfo(String isoCode) {
            FormattingData formattingData = this.fetchFormattingData(isoCode);
            return formattingData.formatInfo;
        }

        private final CurrencyData.CurrencySpacingInfo $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getSpacingInfo() {
            CurrencyData.CurrencySpacingInfo spacingInfo = this.fetchSpacingInfo();
            if (!(spacingInfo.hasBeforeCurrency && spacingInfo.hasAfterCurrency || !this.fallback)) {
                return CurrencyData.CurrencySpacingInfo.DEFAULT;
            }
            return spacingInfo;
        }

        private final FormattingData $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchFormattingData(String isoCode) {
            FormattingData result = this.formattingDataCache;
            if (result == null || !result.isoCode.equals(isoCode)) {
                result = new FormattingData(isoCode);
                CurrencySink sink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCIES);
                sink.formattingData = result;
                this.rb.getAllItemsWithFallbackNoFail("Currencies/" + isoCode, sink);
                this.formattingDataCache = result;
            }
            return result;
        }

        private final NarrowSymbol $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchNarrowSymbol(String isoCode) {
            NarrowSymbol result = this.narrowSymbolCache;
            if (result == null || !result.isoCode.equals(isoCode)) {
                result = new NarrowSymbol(isoCode);
                CurrencySink sink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCY_NARROW);
                sink.narrowSymbol = result;
                this.rb.getAllItemsWithFallbackNoFail("Currencies%narrow/" + isoCode, sink);
                this.narrowSymbolCache = result;
            }
            return result;
        }

        private final String[] $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchPluralsData(String isoCode) {
            String[] result = this.pluralsDataCache;
            if (result == null || !result[0].equals(isoCode)) {
                result = new String[1 + StandardPlural.COUNT];
                result[0] = isoCode;
                CurrencySink sink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCY_PLURALS);
                sink.pluralsData = result;
                this.rb.getAllItemsWithFallbackNoFail("CurrencyPlurals/" + isoCode, sink);
                this.pluralsDataCache = result;
            }
            return result;
        }

        private final ParsingData $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchParsingData() {
            ParsingData result = this.parsingDataCache.get();
            if (result == null) {
                result = new ParsingData();
                CurrencySink sink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.TOP);
                sink.parsingData = result;
                this.rb.getAllItemsWithFallback("", sink);
                this.parsingDataCache = new SoftReference<ParsingData>(result);
            }
            return result;
        }

        private final Map<String, String> $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchUnitPatterns() {
            Map<String, String> result = this.unitPatternsCache;
            if (result == null) {
                result = new HashMap<String, String>();
                CurrencySink sink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCY_UNIT_PATTERNS);
                sink.unitPatterns = result;
                this.rb.getAllItemsWithFallback("CurrencyUnitPatterns", sink);
                this.unitPatternsCache = result;
            }
            return result;
        }

        private final CurrencyData.CurrencySpacingInfo $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchSpacingInfo() {
            CurrencyData.CurrencySpacingInfo result = this.spacingInfoCache;
            if (result == null) {
                result = new CurrencyData.CurrencySpacingInfo();
                CurrencySink sink = new CurrencySink(!this.fallback, CurrencySink.EntrypointTable.CURRENCY_SPACING);
                sink.spacingInfo = result;
                this.rb.getAllItemsWithFallback("currencySpacing", sink);
                this.spacingInfoCache = result;
            }
            return result;
        }

        private void __constructor__(ULocale uLocale, ICUResourceBundle iCUResourceBundle, boolean bl) {
            this.$$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$__constructor__(uLocale, iCUResourceBundle, bl);
        }

        public ICUCurrencyDisplayInfo(ULocale uLocale, ICUResourceBundle iCUResourceBundle, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$__constructor__(android.icu.util.ULocale android.icu.impl.ICUResourceBundle boolean ), this, uLocale, iCUResourceBundle, bl);
        }

        @Override
        public ULocale getULocale() {
            return InvokeDynamicSupport.bootstrap("getULocale", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getULocale(), this);
        }

        @Override
        public String getName(String string2) {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getName(java.lang.String ), this, string2);
        }

        @Override
        public String getSymbol(String string2) {
            return InvokeDynamicSupport.bootstrap("getSymbol", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getSymbol(java.lang.String ), this, string2);
        }

        @Override
        public String getNarrowSymbol(String string2) {
            return InvokeDynamicSupport.bootstrap("getNarrowSymbol", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getNarrowSymbol(java.lang.String ), this, string2);
        }

        @Override
        public String getPluralName(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getPluralName", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getPluralName(java.lang.String java.lang.String ), this, string2, string3);
        }

        @Override
        public Map<String, String> symbolMap() {
            return InvokeDynamicSupport.bootstrap("symbolMap", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$symbolMap(), this);
        }

        @Override
        public Map<String, String> nameMap() {
            return InvokeDynamicSupport.bootstrap("nameMap", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$nameMap(), this);
        }

        @Override
        public Map<String, String> getUnitPatterns() {
            return InvokeDynamicSupport.bootstrap("getUnitPatterns", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getUnitPatterns(), this);
        }

        @Override
        public CurrencyData.CurrencyFormatInfo getFormatInfo(String string2) {
            return InvokeDynamicSupport.bootstrap("getFormatInfo", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getFormatInfo(java.lang.String ), this, string2);
        }

        @Override
        public CurrencyData.CurrencySpacingInfo getSpacingInfo() {
            return InvokeDynamicSupport.bootstrap("getSpacingInfo", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$getSpacingInfo(), this);
        }

        FormattingData fetchFormattingData(String string2) {
            return InvokeDynamicSupport.bootstrap("fetchFormattingData", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchFormattingData(java.lang.String ), this, string2);
        }

        NarrowSymbol fetchNarrowSymbol(String string2) {
            return InvokeDynamicSupport.bootstrap("fetchNarrowSymbol", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchNarrowSymbol(java.lang.String ), this, string2);
        }

        String[] fetchPluralsData(String string2) {
            return InvokeDynamicSupport.bootstrap("fetchPluralsData", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchPluralsData(java.lang.String ), this, string2);
        }

        ParsingData fetchParsingData() {
            return InvokeDynamicSupport.bootstrap("fetchParsingData", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchParsingData(), this);
        }

        Map<String, String> fetchUnitPatterns() {
            return InvokeDynamicSupport.bootstrap("fetchUnitPatterns", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchUnitPatterns(), this);
        }

        CurrencyData.CurrencySpacingInfo fetchSpacingInfo() {
            return InvokeDynamicSupport.bootstrap("fetchSpacingInfo", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo$fetchSpacingInfo(), this);
        }

        public /* synthetic */ ICUCurrencyDisplayInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUCurrencyDisplayInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class CurrencySink
        extends UResource.Sink
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            boolean noRoot;
            EntrypointTable entrypointTable;
            FormattingData formattingData;
            String[] pluralsData;
            ParsingData parsingData;
            Map<String, String> unitPatterns;
            CurrencyData.CurrencySpacingInfo spacingInfo;
            NarrowSymbol narrowSymbol;
            static /* synthetic */ boolean $assertionsDisabled;

            private void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$__constructor__(boolean noRoot, EntrypointTable entrypointTable) {
                this.formattingData = null;
                this.pluralsData = null;
                this.parsingData = null;
                this.unitPatterns = null;
                this.spacingInfo = null;
                this.narrowSymbol = null;
                this.noRoot = noRoot;
                this.entrypointTable = entrypointTable;
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$put(UResource.Key key, UResource.Value value, boolean isRoot) {
                if (this.noRoot && isRoot) {
                    return;
                }
                switch (1.$SwitchMap$android$icu$impl$ICUCurrencyDisplayInfoProvider$ICUCurrencyDisplayInfo$CurrencySink$EntrypointTable[this.entrypointTable.ordinal()]) {
                    case 1: {
                        this.consumeTopTable(key, value);
                        break;
                    }
                    case 2: {
                        this.consumeCurrenciesEntry(key, value);
                        break;
                    }
                    case 3: {
                        this.consumeCurrencyPluralsEntry(key, value);
                        break;
                    }
                    case 4: {
                        this.consumeCurrenciesNarrowEntry(key, value);
                        break;
                    }
                    case 5: {
                        this.consumeCurrencySpacingTable(key, value);
                        break;
                    }
                    case 6: {
                        this.consumeCurrencyUnitPatternsTable(key, value);
                    }
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeTopTable(UResource.Key key, UResource.Value value) {
                UResource.Table table = value.getTable();
                int i = 0;
                while (table.getKeyAndValue(i, key, value)) {
                    if (key.contentEquals("Currencies")) {
                        this.consumeCurrenciesTable(key, value);
                    } else if (key.contentEquals("Currencies%variant")) {
                        this.consumeCurrenciesVariantTable(key, value);
                    } else if (key.contentEquals("CurrencyPlurals")) {
                        this.consumeCurrencyPluralsTable(key, value);
                    }
                    ++i;
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrenciesTable(UResource.Key key, UResource.Value value) {
                if (!$assertionsDisabled && this.parsingData == null) {
                    throw new AssertionError();
                }
                UResource.Table table = value.getTable();
                int i = 0;
                while (table.getKeyAndValue(i, key, value)) {
                    String isoCode = key.toString();
                    if (value.getType() != 8) {
                        throw new ICUException("Unexpected data type in Currencies table for " + isoCode);
                    }
                    UResource.Array array2 = value.getArray();
                    this.parsingData.symbolToIsoCode.put(isoCode, isoCode);
                    array2.getValue(0, value);
                    this.parsingData.symbolToIsoCode.put(value.getString(), isoCode);
                    array2.getValue(1, value);
                    this.parsingData.nameToIsoCode.put(value.getString(), isoCode);
                    ++i;
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrenciesEntry(UResource.Key key, UResource.Value value) {
                if (!$assertionsDisabled && this.formattingData == null) {
                    throw new AssertionError();
                }
                String isoCode = key.toString();
                if (value.getType() != 8) {
                    throw new ICUException("Unexpected data type in Currencies table for " + isoCode);
                }
                UResource.Array array2 = value.getArray();
                if (this.formattingData.symbol == null) {
                    array2.getValue(0, value);
                    this.formattingData.symbol = value.getString();
                }
                if (this.formattingData.displayName == null) {
                    array2.getValue(1, value);
                    this.formattingData.displayName = value.getString();
                }
                if (array2.getSize() > 2 && this.formattingData.formatInfo == null) {
                    array2.getValue(2, value);
                    UResource.Array formatArray = value.getArray();
                    formatArray.getValue(0, value);
                    String formatPattern = value.getString();
                    formatArray.getValue(1, value);
                    String decimalSeparator = value.getString();
                    formatArray.getValue(2, value);
                    String groupingSeparator = value.getString();
                    this.formattingData.formatInfo = new CurrencyData.CurrencyFormatInfo(isoCode, formatPattern, decimalSeparator, groupingSeparator);
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrenciesNarrowEntry(UResource.Key key, UResource.Value value) {
                if (!$assertionsDisabled && this.narrowSymbol == null) {
                    throw new AssertionError();
                }
                if (this.narrowSymbol.narrowSymbol == null) {
                    this.narrowSymbol.narrowSymbol = value.getString();
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrenciesVariantTable(UResource.Key key, UResource.Value value) {
                if (!$assertionsDisabled && this.parsingData == null) {
                    throw new AssertionError();
                }
                UResource.Table table = value.getTable();
                int i = 0;
                while (table.getKeyAndValue(i, key, value)) {
                    String isoCode = key.toString();
                    this.parsingData.symbolToIsoCode.put(value.getString(), isoCode);
                    ++i;
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrencyPluralsTable(UResource.Key key, UResource.Value value) {
                if (!$assertionsDisabled && this.parsingData == null) {
                    throw new AssertionError();
                }
                UResource.Table table = value.getTable();
                int i = 0;
                while (table.getKeyAndValue(i, key, value)) {
                    String isoCode = key.toString();
                    UResource.Table pluralsTable = value.getTable();
                    int j = 0;
                    while (pluralsTable.getKeyAndValue(j, key, value)) {
                        StandardPlural plural = StandardPlural.orNullFromString(key.toString());
                        if (plural == null) {
                            throw new ICUException("Could not make StandardPlural from keyword " + key);
                        }
                        this.parsingData.nameToIsoCode.put(value.getString(), isoCode);
                        ++j;
                    }
                    ++i;
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrencyPluralsEntry(UResource.Key key, UResource.Value value) {
                if (!$assertionsDisabled && this.pluralsData == null) {
                    throw new AssertionError();
                }
                UResource.Table pluralsTable = value.getTable();
                int j = 0;
                while (pluralsTable.getKeyAndValue(j, key, value)) {
                    StandardPlural plural = StandardPlural.orNullFromString(key.toString());
                    if (plural == null) {
                        throw new ICUException("Could not make StandardPlural from keyword " + key);
                    }
                    if (this.pluralsData[1 + plural.ordinal()] == null) {
                        this.pluralsData[1 + plural.ordinal()] = value.getString();
                    }
                    ++j;
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrencySpacingTable(UResource.Key key, UResource.Value value) {
                if (!$assertionsDisabled && this.spacingInfo == null) {
                    throw new AssertionError();
                }
                UResource.Table spacingTypesTable = value.getTable();
                int i = 0;
                while (spacingTypesTable.getKeyAndValue(i, key, value)) {
                    block8: {
                        CurrencyData.CurrencySpacingInfo.SpacingType type;
                        block7: {
                            block6: {
                                if (!key.contentEquals("beforeCurrency")) break block6;
                                type = CurrencyData.CurrencySpacingInfo.SpacingType.BEFORE;
                                this.spacingInfo.hasBeforeCurrency = true;
                                break block7;
                            }
                            if (!key.contentEquals("afterCurrency")) break block8;
                            type = CurrencyData.CurrencySpacingInfo.SpacingType.AFTER;
                            this.spacingInfo.hasAfterCurrency = true;
                        }
                        UResource.Table patternsTable = value.getTable();
                        int j = 0;
                        while (patternsTable.getKeyAndValue(j, key, value)) {
                            block12: {
                                CurrencyData.CurrencySpacingInfo.SpacingPattern pattern;
                                block10: {
                                    block11: {
                                        block9: {
                                            if (!key.contentEquals("currencyMatch")) break block9;
                                            pattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.CURRENCY_MATCH;
                                            break block10;
                                        }
                                        if (!key.contentEquals("surroundingMatch")) break block11;
                                        pattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.SURROUNDING_MATCH;
                                        break block10;
                                    }
                                    if (!key.contentEquals("insertBetween")) break block12;
                                    pattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.INSERT_BETWEEN;
                                }
                                this.spacingInfo.setSymbolIfNull(type, pattern, value.getString());
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }

            private final void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrencyUnitPatternsTable(UResource.Key key, UResource.Value value) {
                if (!$assertionsDisabled && this.unitPatterns == null) {
                    throw new AssertionError();
                }
                UResource.Table table = value.getTable();
                int i = 0;
                while (table.getKeyAndValue(i, key, value)) {
                    String pluralKeyword = key.toString();
                    if (this.unitPatterns.get(pluralKeyword) == null) {
                        this.unitPatterns.put(pluralKeyword, value.getString());
                    }
                    ++i;
                }
            }

            static void __staticInitializer__() {
                $assertionsDisabled = !ICUCurrencyDisplayInfoProvider.class.desiredAssertionStatus();
            }

            private void __constructor__(boolean bl, EntrypointTable entrypointTable) {
                this.$$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$__constructor__(bl, entrypointTable);
            }

            public CurrencySink(boolean bl, EntrypointTable entrypointTable) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$__constructor__(boolean android.icu.impl.ICUCurrencyDisplayInfoProvider$ICUCurrencyDisplayInfo$CurrencySink$EntrypointTable ), this, bl, entrypointTable);
            }

            @Override
            public void put(UResource.Key key, UResource.Value value, boolean bl) {
                InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), this, key, value, bl);
            }

            private void consumeTopTable(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeTopTable", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeTopTable(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            void consumeCurrenciesTable(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeCurrenciesTable", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrenciesTable(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            void consumeCurrenciesEntry(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeCurrenciesEntry", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrenciesEntry(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            void consumeCurrenciesNarrowEntry(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeCurrenciesNarrowEntry", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrenciesNarrowEntry(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            void consumeCurrenciesVariantTable(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeCurrenciesVariantTable", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrenciesVariantTable(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            void consumeCurrencyPluralsTable(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeCurrencyPluralsTable", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrencyPluralsTable(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            void consumeCurrencyPluralsEntry(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeCurrencyPluralsEntry", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrencyPluralsEntry(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            void consumeCurrencySpacingTable(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeCurrencySpacingTable", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrencySpacingTable(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            void consumeCurrencyUnitPatternsTable(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("consumeCurrencyUnitPatternsTable", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink$consumeCurrencyUnitPatternsTable(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), this, key, value);
            }

            static {
                RobolectricInternals.classInitializing(CurrencySink.class);
            }

            public /* synthetic */ CurrencySink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurrencySink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
            public static final class EntrypointTable
            extends Enum<EntrypointTable> {
                public /* synthetic */ Object __robo_data__;
                public static /* enum */ EntrypointTable TOP;
                public static /* enum */ EntrypointTable CURRENCIES;
                public static /* enum */ EntrypointTable CURRENCY_PLURALS;
                public static /* enum */ EntrypointTable CURRENCY_NARROW;
                public static /* enum */ EntrypointTable CURRENCY_SPACING;
                public static /* enum */ EntrypointTable CURRENCY_UNIT_PATTERNS;
                private static /* synthetic */ EntrypointTable[] $VALUES;

                private static final EntrypointTable[] $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink_EntrypointTable$values() {
                    return (EntrypointTable[])$VALUES.clone();
                }

                private static final EntrypointTable $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink_EntrypointTable$valueOf(String name) {
                    return Enum.valueOf(EntrypointTable.class, name);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                private void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink_EntrypointTable$__constructor__(String string2, int n) {
                }

                static void __staticInitializer__() {
                    TOP = new EntrypointTable();
                    CURRENCIES = new EntrypointTable();
                    CURRENCY_PLURALS = new EntrypointTable();
                    CURRENCY_NARROW = new EntrypointTable();
                    CURRENCY_SPACING = new EntrypointTable();
                    CURRENCY_UNIT_PATTERNS = new EntrypointTable();
                    $VALUES = new EntrypointTable[]{TOP, CURRENCIES, CURRENCY_PLURALS, CURRENCY_NARROW, CURRENCY_SPACING, CURRENCY_UNIT_PATTERNS};
                }

                public static EntrypointTable[] values() {
                    return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink_EntrypointTable$values());
                }

                public static EntrypointTable valueOf(String string2) {
                    return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink_EntrypointTable$valueOf(java.lang.String ), (String)string2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                private void __constructor__(String string2, int n) {
                    this.$$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink_EntrypointTable$__constructor__(string2, n);
                }

                public EntrypointTable() {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_CurrencySink_EntrypointTable$__constructor__(java.lang.String int ), this, string2, n);
                }

                static {
                    RobolectricInternals.classInitializing(EntrypointTable.class);
                }

                public /* synthetic */ EntrypointTable() {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntrypointTable)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
        }

        public static class ParsingData
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            Map<String, String> symbolToIsoCode;
            Map<String, String> nameToIsoCode;

            private void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_ParsingData$__constructor__() {
                this.symbolToIsoCode = new HashMap<String, String>();
                this.nameToIsoCode = new HashMap<String, String>();
            }

            private void __constructor__() {
                this.$$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_ParsingData$__constructor__();
            }

            public ParsingData() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_ParsingData$__constructor__(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParsingData)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class NarrowSymbol
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            String isoCode;
            String narrowSymbol;

            private void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_NarrowSymbol$__constructor__(String isoCode) {
                this.narrowSymbol = null;
                this.isoCode = isoCode;
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_NarrowSymbol$__constructor__(string2);
            }

            public NarrowSymbol(String string2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_NarrowSymbol$__constructor__(java.lang.String ), this, string2);
            }

            public /* synthetic */ NarrowSymbol() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NarrowSymbol)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class FormattingData
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            String isoCode;
            String displayName;
            String symbol;
            CurrencyData.CurrencyFormatInfo formatInfo;

            private void $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_FormattingData$__constructor__(String isoCode) {
                this.displayName = null;
                this.symbol = null;
                this.formatInfo = null;
                this.isoCode = isoCode;
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_FormattingData$__constructor__(string2);
            }

            public FormattingData(String string2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyDisplayInfoProvider_ICUCurrencyDisplayInfo_FormattingData$__constructor__(java.lang.String ), this, string2);
            }

            public /* synthetic */ FormattingData() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FormattingData)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

