/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.Punycode;
import android.icu.text.StringPrep;
import android.icu.text.StringPrepParseException;
import android.icu.text.UCharacterIterator;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IDNA2003
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static char[] ACE_PREFIX;
    private static int MAX_LABEL_LENGTH = 63;
    private static int HYPHEN = 45;
    private static int CAPITAL_A = 65;
    private static int CAPITAL_Z = 90;
    private static int LOWER_CASE_DELTA = 32;
    private static int FULL_STOP = 46;
    private static int MAX_DOMAIN_NAME_LENGTH = 255;
    private static StringPrep namePrep;

    private void $$robo$$android_icu_impl_IDNA2003$__constructor__() {
    }

    private static final boolean $$robo$$android_icu_impl_IDNA2003$startsWithPrefix(StringBuffer src) {
        boolean startsWithPrefix = true;
        if (src.length() < ACE_PREFIX.length) {
            return false;
        }
        for (int i = 0; i < ACE_PREFIX.length; ++i) {
            if (IDNA2003.toASCIILower(src.charAt(i)) == ACE_PREFIX[i]) continue;
            startsWithPrefix = false;
        }
        return startsWithPrefix;
    }

    private static final char $$robo$$android_icu_impl_IDNA2003$toASCIILower(char ch) {
        if ('A' <= ch && ch <= 'Z') {
            return (char)(ch + 32);
        }
        return ch;
    }

    private static final StringBuffer $$robo$$android_icu_impl_IDNA2003$toASCIILower(CharSequence src) {
        StringBuffer dest = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            dest.append(IDNA2003.toASCIILower(src.charAt(i)));
        }
        return dest;
    }

    private static final int $$robo$$android_icu_impl_IDNA2003$compareCaseInsensitiveASCII(StringBuffer s1, StringBuffer s2) {
        int i = 0;
        while (i != s1.length()) {
            int rc;
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(i)) && (rc = IDNA2003.toASCIILower(c1) - IDNA2003.toASCIILower(c2)) != 0) {
                return rc;
            }
            ++i;
        }
        return 0;
    }

    private static final int $$robo$$android_icu_impl_IDNA2003$getSeparatorIndex(char[] src, int start, int limit) {
        while (start < limit) {
            if (IDNA2003.isLabelSeparator(src[start])) {
                return start;
            }
            ++start;
        }
        return start;
    }

    private static final boolean $$robo$$android_icu_impl_IDNA2003$isLDHChar(int ch) {
        if (ch > 122) {
            return false;
        }
        return ch == 45 || 48 <= ch && ch <= 57 || 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122;
    }

    private static final boolean $$robo$$android_icu_impl_IDNA2003$isLabelSeparator(int ch) {
        switch (ch) {
            case 46: 
            case 12290: 
            case 65294: 
            case 65377: {
                return true;
            }
        }
        return false;
    }

    private static final StringBuffer $$robo$$android_icu_impl_IDNA2003$convertToASCII(UCharacterIterator src, int options) throws StringPrepParseException {
        int ch;
        boolean useSTD3ASCIIRules;
        boolean[] caseFlags = null;
        boolean srcIsASCII = true;
        boolean srcIsLDH = true;
        boolean bl = useSTD3ASCIIRules = (options & 2) != 0;
        while ((ch = src.next()) != -1) {
            if (ch <= 127) continue;
            srcIsASCII = false;
        }
        int failPos = -1;
        src.setToStart();
        StringBuffer processOut = null;
        processOut = !srcIsASCII ? namePrep.prepare(src, options) : new StringBuffer(src.getText());
        int poLen = processOut.length();
        if (poLen == 0) {
            throw new StringPrepParseException("Found zero length lable after NamePrep.", 10);
        }
        StringBuffer dest = new StringBuffer();
        srcIsASCII = true;
        for (int j = 0; j < poLen; ++j) {
            ch = processOut.charAt(j);
            if (ch > 127) {
                srcIsASCII = false;
                continue;
            }
            if (IDNA2003.isLDHChar(ch)) continue;
            srcIsLDH = false;
            failPos = j;
        }
        if (useSTD3ASCIIRules && (!srcIsLDH || processOut.charAt(0) == '-' || processOut.charAt(processOut.length() - 1) == '-')) {
            if (!srcIsLDH) {
                throw new StringPrepParseException("The input does not conform to the STD 3 ASCII rules", 5, processOut.toString(), failPos > 0 ? failPos - 1 : failPos);
            }
            if (processOut.charAt(0) == '-') {
                throw new StringPrepParseException("The input does not conform to the STD 3 ASCII rules", 5, processOut.toString(), 0);
            }
            throw new StringPrepParseException("The input does not conform to the STD 3 ASCII rules", 5, processOut.toString(), poLen > 0 ? poLen - 1 : poLen);
        }
        if (srcIsASCII) {
            dest = processOut;
        } else if (!IDNA2003.startsWithPrefix(processOut)) {
            caseFlags = new boolean[poLen];
            StringBuilder punyout = Punycode.encode(processOut, caseFlags);
            StringBuffer lowerOut = IDNA2003.toASCIILower(punyout);
            dest.append(ACE_PREFIX, 0, ACE_PREFIX.length);
            dest.append(lowerOut);
        } else {
            throw new StringPrepParseException("The input does not start with the ACE Prefix.", 6, processOut.toString(), 0);
        }
        if (dest.length() > 63) {
            throw new StringPrepParseException("The labels in the input are too long. Length > 63.", 8, dest.toString(), 0);
        }
        return dest;
    }

    private static final StringBuffer $$robo$$android_icu_impl_IDNA2003$convertIDNToASCII(String src, int options) throws StringPrepParseException {
        char[] srcArr = src.toCharArray();
        StringBuffer result = new StringBuffer();
        int sepIndex = 0;
        int oldSepIndex = 0;
        while (true) {
            String label;
            if ((label = new String(srcArr, oldSepIndex, (sepIndex = IDNA2003.getSeparatorIndex(srcArr, sepIndex, srcArr.length)) - oldSepIndex)).length() != 0 || sepIndex != srcArr.length) {
                UCharacterIterator iter = UCharacterIterator.getInstance(label);
                result.append(IDNA2003.convertToASCII(iter, options));
            }
            if (sepIndex == srcArr.length) break;
            oldSepIndex = ++sepIndex;
            result.append('.');
        }
        if (result.length() > 255) {
            throw new StringPrepParseException("The output exceed the max allowed length.", 11);
        }
        return result;
    }

    private static final StringBuffer $$robo$$android_icu_impl_IDNA2003$convertToUnicode(UCharacterIterator src, int options) throws StringPrepParseException {
        StringBuffer processOut;
        int ch;
        boolean[] caseFlags = null;
        boolean srcIsASCII = true;
        int saveIndex = src.getIndex();
        while ((ch = src.next()) != -1) {
            if (ch <= 127) continue;
            srcIsASCII = false;
        }
        if (!srcIsASCII) {
            try {
                src.setIndex(saveIndex);
                processOut = namePrep.prepare(src, options);
            }
            catch (StringPrepParseException ex) {
                return new StringBuffer(src.getText());
            }
        } else {
            processOut = new StringBuffer(src.getText());
        }
        if (IDNA2003.startsWithPrefix(processOut)) {
            StringBuffer toASCIIOut;
            StringBuffer decodeOut = null;
            String temp = processOut.substring(ACE_PREFIX.length, processOut.length());
            try {
                decodeOut = new StringBuffer(Punycode.decode(temp, caseFlags));
            }
            catch (StringPrepParseException e) {
                decodeOut = null;
            }
            if (decodeOut != null && IDNA2003.compareCaseInsensitiveASCII(processOut, toASCIIOut = IDNA2003.convertToASCII(UCharacterIterator.getInstance(decodeOut), options)) != 0) {
                decodeOut = null;
            }
            if (decodeOut != null) {
                return decodeOut;
            }
        }
        return new StringBuffer(src.getText());
    }

    private static final StringBuffer $$robo$$android_icu_impl_IDNA2003$convertIDNToUnicode(String src, int options) throws StringPrepParseException {
        char[] srcArr = src.toCharArray();
        StringBuffer result = new StringBuffer();
        int sepIndex = 0;
        int oldSepIndex = 0;
        while (true) {
            String label;
            if ((label = new String(srcArr, oldSepIndex, (sepIndex = IDNA2003.getSeparatorIndex(srcArr, sepIndex, srcArr.length)) - oldSepIndex)).length() == 0 && sepIndex != srcArr.length) {
                throw new StringPrepParseException("Found zero length lable after NamePrep.", 10);
            }
            UCharacterIterator iter = UCharacterIterator.getInstance(label);
            result.append(IDNA2003.convertToUnicode(iter, options));
            if (sepIndex == srcArr.length) break;
            result.append(srcArr[sepIndex]);
            oldSepIndex = ++sepIndex;
        }
        if (result.length() > 255) {
            throw new StringPrepParseException("The output exceed the max allowed length.", 11);
        }
        return result;
    }

    private static final int $$robo$$android_icu_impl_IDNA2003$compare(String s1, String s2, int options) throws StringPrepParseException {
        StringBuffer s1Out = IDNA2003.convertIDNToASCII(s1, options);
        StringBuffer s2Out = IDNA2003.convertIDNToASCII(s2, options);
        return IDNA2003.compareCaseInsensitiveASCII(s1Out, s2Out);
    }

    static void __staticInitializer__() {
        ACE_PREFIX = new char[]{'x', 'n', '-', '-'};
        namePrep = StringPrep.getInstance(0);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_IDNA2003$__constructor__();
    }

    public IDNA2003() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_IDNA2003$__constructor__(), this);
    }

    private static boolean startsWithPrefix(StringBuffer stringBuffer) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("startsWithPrefix", $$robo$$android_icu_impl_IDNA2003$startsWithPrefix(java.lang.StringBuffer ), (StringBuffer)stringBuffer);
    }

    private static char toASCIILower(char c) {
        return (char)InvokeDynamicSupport.bootstrapStatic("toASCIILower", $$robo$$android_icu_impl_IDNA2003$toASCIILower(char ), (char)c);
    }

    private static StringBuffer toASCIILower(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("toASCIILower", $$robo$$android_icu_impl_IDNA2003$toASCIILower(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    private static int compareCaseInsensitiveASCII(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareCaseInsensitiveASCII", $$robo$$android_icu_impl_IDNA2003$compareCaseInsensitiveASCII(java.lang.StringBuffer java.lang.StringBuffer ), (StringBuffer)stringBuffer, (StringBuffer)stringBuffer2);
    }

    private static int getSeparatorIndex(char[] cArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSeparatorIndex", $$robo$$android_icu_impl_IDNA2003$getSeparatorIndex(char[] int int ), (char[])cArray, (int)n, (int)n2);
    }

    private static boolean isLDHChar(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLDHChar", $$robo$$android_icu_impl_IDNA2003$isLDHChar(int ), (int)n);
    }

    private static boolean isLabelSeparator(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLabelSeparator", $$robo$$android_icu_impl_IDNA2003$isLabelSeparator(int ), (int)n);
    }

    public static StringBuffer convertToASCII(UCharacterIterator uCharacterIterator, int n) throws StringPrepParseException {
        return InvokeDynamicSupport.bootstrapStatic("convertToASCII", $$robo$$android_icu_impl_IDNA2003$convertToASCII(android.icu.text.UCharacterIterator int ), (UCharacterIterator)uCharacterIterator, (int)n);
    }

    public static StringBuffer convertIDNToASCII(String string2, int n) throws StringPrepParseException {
        return InvokeDynamicSupport.bootstrapStatic("convertIDNToASCII", $$robo$$android_icu_impl_IDNA2003$convertIDNToASCII(java.lang.String int ), (String)string2, (int)n);
    }

    public static StringBuffer convertToUnicode(UCharacterIterator uCharacterIterator, int n) throws StringPrepParseException {
        return InvokeDynamicSupport.bootstrapStatic("convertToUnicode", $$robo$$android_icu_impl_IDNA2003$convertToUnicode(android.icu.text.UCharacterIterator int ), (UCharacterIterator)uCharacterIterator, (int)n);
    }

    public static StringBuffer convertIDNToUnicode(String string2, int n) throws StringPrepParseException {
        return InvokeDynamicSupport.bootstrapStatic("convertIDNToUnicode", $$robo$$android_icu_impl_IDNA2003$convertIDNToUnicode(java.lang.String int ), (String)string2, (int)n);
    }

    public static int compare(String string2, String string3, int n) throws StringPrepParseException {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_impl_IDNA2003$compare(java.lang.String java.lang.String int ), (String)string2, (String)string3, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(IDNA2003.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IDNA2003)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

