/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.Grego;
import android.icu.impl.ICUDebug;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.Utility;
import android.icu.impl.ZoneMeta;
import android.icu.util.AnnualTimeZoneRule;
import android.icu.util.BasicTimeZone;
import android.icu.util.DateTimeRule;
import android.icu.util.InitialTimeZoneRule;
import android.icu.util.SimpleTimeZone;
import android.icu.util.TimeArrayTimeZoneRule;
import android.icu.util.TimeZone;
import android.icu.util.TimeZoneRule;
import android.icu.util.TimeZoneTransition;
import android.icu.util.UResourceBundle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Date;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class OlsonTimeZone
extends BasicTimeZone
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static long serialVersionUID = -6281977362477515376L;
    private static int MAX_OFFSET_SECONDS = 86400;
    private int transitionCount;
    private int typeCount;
    private long[] transitionTimes64;
    private int[] typeOffsets;
    private byte[] typeMapData;
    private int finalStartYear;
    private double finalStartMillis;
    private SimpleTimeZone finalZone;
    private volatile String canonicalID;
    private static String ZONEINFORES = "zoneinfo64";
    private static boolean DEBUG;
    private static int SECONDS_PER_DAY = 86400;
    private transient InitialTimeZoneRule initialRule;
    private transient TimeZoneTransition firstTZTransition;
    private transient int firstTZTransitionIdx;
    private transient TimeZoneTransition firstFinalTZTransition;
    private transient TimeArrayTimeZoneRule[] historicRules;
    private transient SimpleTimeZone finalZoneWithStartYear;
    private transient boolean transitionRulesInitialized;
    private static int currentSerialVersion = 1;
    private int serialVersionOnStream;
    private volatile transient boolean isFrozen;
    static /* synthetic */ boolean $assertionsDisabled;

    private final int $$robo$$android_icu_impl_OlsonTimeZone$getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Month is not in the legal range: " + month);
        }
        return this.getOffset(era, year, month, day, dayOfWeek, milliseconds, Grego.monthLength(year, month));
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$getOffset(int era, int year, int month, int dom, int dow, int millis, int monthLength) {
        if (era != 1 && era != 0 || month < 0 || month > 11 || dom < 1 || dom > monthLength || dow < 1 || dow > 7 || millis < 0 || millis >= 86400000 || monthLength < 28 || monthLength > 31) {
            throw new IllegalArgumentException();
        }
        if (era == 0) {
            year = -year;
        }
        if (this.finalZone != null && year >= this.finalStartYear) {
            return this.finalZone.getOffset(era, year, month, dom, dow, millis);
        }
        long time = Grego.fieldsToDay(year, month, dom) * 86400000L + (long)millis;
        int[] offsets = new int[2];
        this.getHistoricalOffset(time, true, 3, 1, offsets);
        return offsets[0] + offsets[1];
    }

    private final void $$robo$$android_icu_impl_OlsonTimeZone$setRawOffset(int offsetMillis) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen OlsonTimeZone instance.");
        }
        if (this.getRawOffset() == offsetMillis) {
            return;
        }
        CallSite current = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if ((double)current < this.finalStartMillis) {
            SimpleTimeZone stz = new SimpleTimeZone(offsetMillis, this.getID());
            boolean bDst = this.useDaylightTime();
            if (bDst) {
                TimeZoneTransition tzt;
                TimeZoneRule[] currentRules = this.getSimpleTimeZoneRulesNear((long)current);
                if (currentRules.length != 3 && (tzt = this.getPreviousTransition((long)current, false)) != null) {
                    currentRules = this.getSimpleTimeZoneRulesNear(tzt.getTime() - 1L);
                }
                if (currentRules.length == 3 && currentRules[1] instanceof AnnualTimeZoneRule && currentRules[2] instanceof AnnualTimeZoneRule) {
                    int sav;
                    DateTimeRule end;
                    DateTimeRule start;
                    int offset2;
                    AnnualTimeZoneRule r1 = (AnnualTimeZoneRule)currentRules[1];
                    AnnualTimeZoneRule r2 = (AnnualTimeZoneRule)currentRules[2];
                    int offset1 = r1.getRawOffset() + r1.getDSTSavings();
                    if (offset1 > (offset2 = r2.getRawOffset() + r2.getDSTSavings())) {
                        start = r1.getRule();
                        end = r2.getRule();
                        sav = offset1 - offset2;
                    } else {
                        start = r2.getRule();
                        end = r1.getRule();
                        sav = offset2 - offset1;
                    }
                    stz.setStartRule(start.getRuleMonth(), start.getRuleWeekInMonth(), start.getRuleDayOfWeek(), start.getRuleMillisInDay());
                    stz.setEndRule(end.getRuleMonth(), end.getRuleWeekInMonth(), end.getRuleDayOfWeek(), end.getRuleMillisInDay());
                    stz.setDSTSavings(sav);
                } else {
                    stz.setStartRule(0, 1, 0);
                    stz.setEndRule(11, 31, 86399999);
                }
            }
            int[] fields = Grego.timeToFields((long)current, null);
            this.finalStartYear = fields[0];
            this.finalStartMillis = Grego.fieldsToDay(fields[0], 0, 1);
            if (bDst) {
                stz.setStartYear(this.finalStartYear);
            }
            this.finalZone = stz;
        } else {
            this.finalZone.setRawOffset(offsetMillis);
        }
        this.transitionRulesInitialized = false;
    }

    private final Object $$robo$$android_icu_impl_OlsonTimeZone$clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    private final void $$robo$$android_icu_impl_OlsonTimeZone$getOffset(long date, boolean local, int[] offsets) {
        if (this.finalZone != null && (double)date >= this.finalStartMillis) {
            this.finalZone.getOffset(date, local, offsets);
        } else {
            this.getHistoricalOffset(date, local, 4, 12, offsets);
        }
    }

    private final void $$robo$$android_icu_impl_OlsonTimeZone$getOffsetFromLocal(long date, int nonExistingTimeOpt, int duplicatedTimeOpt, int[] offsets) {
        if (this.finalZone != null && (double)date >= this.finalStartMillis) {
            this.finalZone.getOffsetFromLocal(date, nonExistingTimeOpt, duplicatedTimeOpt, offsets);
        } else {
            this.getHistoricalOffset(date, true, nonExistingTimeOpt, duplicatedTimeOpt, offsets);
        }
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$getRawOffset() {
        int[] ret = new int[2];
        this.getOffset((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), false, ret);
        return ret[0];
    }

    private final boolean $$robo$$android_icu_impl_OlsonTimeZone$useDaylightTime() {
        CallSite current = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.finalZone != null && (double)current >= this.finalStartMillis) {
            return this.finalZone != null && this.finalZone.useDaylightTime();
        }
        int[] fields = Grego.timeToFields((long)current, null);
        long start = Grego.fieldsToDay(fields[0], 0, 1) * 86400L;
        long limit = Grego.fieldsToDay(fields[0] + 1, 0, 1) * 86400L;
        for (int i = 0; i < this.transitionCount && this.transitionTimes64[i] < limit; ++i) {
            if ((this.transitionTimes64[i] < start || this.dstOffsetAt(i) == 0) && (this.transitionTimes64[i] <= start || i <= 0 || this.dstOffsetAt(i - 1) == 0)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_icu_impl_OlsonTimeZone$observesDaylightTime() {
        CallSite current = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.finalZone != null) {
            if (this.finalZone.useDaylightTime()) {
                return true;
            }
            if ((double)current >= this.finalStartMillis) {
                return false;
            }
        }
        long currentSec = Grego.floorDivide((long)current, 1000L);
        int trsIdx = this.transitionCount - 1;
        if (this.dstOffsetAt(trsIdx) != 0) {
            return true;
        }
        while (trsIdx >= 0 && this.transitionTimes64[trsIdx] > currentSec) {
            if (this.dstOffsetAt(trsIdx - 1) != 0) {
                return true;
            }
            --trsIdx;
        }
        return false;
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$getDSTSavings() {
        if (this.finalZone != null) {
            return this.finalZone.getDSTSavings();
        }
        return super.getDSTSavings();
    }

    private final boolean $$robo$$android_icu_impl_OlsonTimeZone$inDaylightTime(Date date) {
        int[] temp = new int[2];
        this.getOffset(date.getTime(), false, temp);
        return temp[1] != 0;
    }

    private final boolean $$robo$$android_icu_impl_OlsonTimeZone$hasSameRules(TimeZone other) {
        if (this == other) {
            return true;
        }
        if (!super.hasSameRules(other)) {
            return false;
        }
        if (!(other instanceof OlsonTimeZone)) {
            return false;
        }
        OlsonTimeZone o = (OlsonTimeZone)other;
        if (this.finalZone == null ? o.finalZone != null : o.finalZone == null || this.finalStartYear != o.finalStartYear || !this.finalZone.hasSameRules(o.finalZone)) {
            return false;
        }
        return this.transitionCount == o.transitionCount && Arrays.equals(this.transitionTimes64, o.transitionTimes64) && this.typeCount == o.typeCount && Arrays.equals(this.typeMapData, o.typeMapData) && Arrays.equals(this.typeOffsets, o.typeOffsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_impl_OlsonTimeZone$getCanonicalID() {
        if (this.canonicalID == null) {
            OlsonTimeZone olsonTimeZone = this;
            synchronized (olsonTimeZone) {
                if (this.canonicalID == null) {
                    this.canonicalID = OlsonTimeZone.getCanonicalID(this.getID());
                    if (!$assertionsDisabled && this.canonicalID == null) {
                        throw new AssertionError();
                    }
                    if (this.canonicalID == null) {
                        this.canonicalID = this.getID();
                    }
                }
            }
        }
        return this.canonicalID;
    }

    private final void $$robo$$android_icu_impl_OlsonTimeZone$constructEmpty() {
        this.transitionCount = 0;
        this.transitionTimes64 = null;
        this.typeMapData = null;
        this.typeCount = 1;
        this.typeOffsets = new int[]{0, 0};
        this.finalZone = null;
        this.finalStartYear = Integer.MAX_VALUE;
        this.finalStartMillis = Double.MAX_VALUE;
        this.transitionRulesInitialized = false;
    }

    private void $$robo$$android_icu_impl_OlsonTimeZone$__constructor__(UResourceBundle top, UResourceBundle res, String id2) {
        this.finalStartYear = Integer.MAX_VALUE;
        this.finalStartMillis = Double.MAX_VALUE;
        this.finalZone = null;
        this.canonicalID = null;
        this.serialVersionOnStream = 1;
        this.isFrozen = false;
        this.construct(top, res);
    }

    private final void $$robo$$android_icu_impl_OlsonTimeZone$construct(UResourceBundle top, UResourceBundle res) {
        block25: {
            UResourceBundle r;
            if (top == null || res == null) {
                throw new IllegalArgumentException();
            }
            if (DEBUG) {
                System.out.println("OlsonTimeZone(" + res.getKey() + ")");
            }
            int[] transPost32 = null;
            int[] trans32 = null;
            int[] transPre32 = null;
            this.transitionCount = 0;
            try {
                r = res.get("transPre32");
                transPre32 = r.getIntVector();
                if (transPre32.length % 2 != 0) {
                    throw new IllegalArgumentException("Invalid Format");
                }
                this.transitionCount += transPre32.length / 2;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                r = res.get("trans");
                trans32 = r.getIntVector();
                this.transitionCount += trans32.length;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                r = res.get("transPost32");
                transPost32 = r.getIntVector();
                if (transPost32.length % 2 != 0) {
                    throw new IllegalArgumentException("Invalid Format");
                }
                this.transitionCount += transPost32.length / 2;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (this.transitionCount > 0) {
                int i;
                this.transitionTimes64 = new long[this.transitionCount];
                int idx = 0;
                if (transPre32 != null) {
                    i = 0;
                    while (i < transPre32.length / 2) {
                        this.transitionTimes64[idx] = ((long)transPre32[i * 2] & 0xFFFFFFFFL) << 32 | (long)transPre32[i * 2 + 1] & 0xFFFFFFFFL;
                        ++i;
                        ++idx;
                    }
                }
                if (trans32 != null) {
                    i = 0;
                    while (i < trans32.length) {
                        this.transitionTimes64[idx] = trans32[i];
                        ++i;
                        ++idx;
                    }
                }
                if (transPost32 != null) {
                    i = 0;
                    while (i < transPost32.length / 2) {
                        this.transitionTimes64[idx] = ((long)transPost32[i * 2] & 0xFFFFFFFFL) << 32 | (long)transPost32[i * 2 + 1] & 0xFFFFFFFFL;
                        ++i;
                        ++idx;
                    }
                }
            } else {
                this.transitionTimes64 = null;
            }
            r = res.get("typeOffsets");
            this.typeOffsets = r.getIntVector();
            if (this.typeOffsets.length < 2 || this.typeOffsets.length > 32766 || this.typeOffsets.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid Format");
            }
            this.typeCount = this.typeOffsets.length / 2;
            if (this.transitionCount > 0) {
                r = res.get("typeMap");
                this.typeMapData = r.getBinary(null);
                if (this.typeMapData == null || this.typeMapData.length != this.transitionCount) {
                    throw new IllegalArgumentException("Invalid Format");
                }
            } else {
                this.typeMapData = null;
            }
            this.finalZone = null;
            this.finalStartYear = Integer.MAX_VALUE;
            this.finalStartMillis = Double.MAX_VALUE;
            String ruleID = null;
            try {
                ruleID = res.getString("finalRule");
                r = res.get("finalRaw");
                int ruleRaw = r.getInt() * 1000;
                r = OlsonTimeZone.loadRule(top, ruleID);
                int[] ruleData = r.getIntVector();
                if (ruleData == null || ruleData.length != 11) {
                    throw new IllegalArgumentException("Invalid Format");
                }
                this.finalZone = new SimpleTimeZone(ruleRaw, "", ruleData[0], ruleData[1], ruleData[2], ruleData[3] * 1000, ruleData[4], ruleData[5], ruleData[6], ruleData[7], ruleData[8] * 1000, ruleData[9], ruleData[10] * 1000);
                r = res.get("finalYear");
                this.finalStartYear = r.getInt();
                this.finalStartMillis = Grego.fieldsToDay(this.finalStartYear, 0, 1) * 86400000L;
            }
            catch (MissingResourceException e) {
                if (ruleID == null) break block25;
                throw new IllegalArgumentException("Invalid Format");
            }
        }
    }

    private void $$robo$$android_icu_impl_OlsonTimeZone$__constructor__(String id2) {
        this.finalStartYear = Integer.MAX_VALUE;
        this.finalStartMillis = Double.MAX_VALUE;
        this.finalZone = null;
        this.canonicalID = null;
        this.serialVersionOnStream = 1;
        this.isFrozen = false;
        UResourceBundle top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b", "zoneinfo64", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle res = ZoneMeta.openOlsonResource(top, id2);
        this.construct(top, res);
        if (this.finalZone != null) {
            this.finalZone.setID(id2);
        }
    }

    private final void $$robo$$android_icu_impl_OlsonTimeZone$setID(String id2) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen OlsonTimeZone instance.");
        }
        if (this.canonicalID == null) {
            this.canonicalID = OlsonTimeZone.getCanonicalID(this.getID());
            if (!$assertionsDisabled && this.canonicalID == null) {
                throw new AssertionError();
            }
            if (this.canonicalID == null) {
                this.canonicalID = this.getID();
            }
        }
        if (this.finalZone != null) {
            this.finalZone.setID(id2);
        }
        super.setID(id2);
        this.transitionRulesInitialized = false;
    }

    private final void $$robo$$android_icu_impl_OlsonTimeZone$getHistoricalOffset(long date, boolean local, int NonExistingTimeOpt, int DuplicatedTimeOpt, int[] offsets) {
        if (this.transitionCount != 0) {
            long sec = Grego.floorDivide(date, 1000L);
            if (!local && sec < this.transitionTimes64[0]) {
                offsets[0] = this.initialRawOffset() * 1000;
                offsets[1] = this.initialDstOffset() * 1000;
            } else {
                int transIdx;
                for (transIdx = this.transitionCount - 1; transIdx >= 0; --transIdx) {
                    long transition2 = this.transitionTimes64[transIdx];
                    if (local && sec >= transition2 - 86400L) {
                        boolean stdToDst;
                        int offsetBefore = this.zoneOffsetAt(transIdx - 1);
                        boolean dstBefore = this.dstOffsetAt(transIdx - 1) != 0;
                        int offsetAfter = this.zoneOffsetAt(transIdx);
                        boolean dstAfter = this.dstOffsetAt(transIdx) != 0;
                        boolean dstToStd = dstBefore && !dstAfter;
                        boolean bl = stdToDst = !dstBefore && dstAfter;
                        transition2 = offsetAfter - offsetBefore >= 0 ? ((NonExistingTimeOpt & 3) == 1 && dstToStd || (NonExistingTimeOpt & 3) == 3 && stdToDst ? (transition2 += (long)offsetBefore) : ((NonExistingTimeOpt & 3) == 1 && stdToDst || (NonExistingTimeOpt & 3) == 3 && dstToStd ? (transition2 += (long)offsetAfter) : ((NonExistingTimeOpt & 0xC) == 12 ? (transition2 += (long)offsetBefore) : (transition2 += (long)offsetAfter)))) : ((DuplicatedTimeOpt & 3) == 1 && dstToStd || (DuplicatedTimeOpt & 3) == 3 && stdToDst ? (transition2 += (long)offsetAfter) : ((DuplicatedTimeOpt & 3) == 1 && stdToDst || (DuplicatedTimeOpt & 3) == 3 && dstToStd ? (transition2 += (long)offsetBefore) : ((DuplicatedTimeOpt & 0xC) == 4 ? (transition2 += (long)offsetBefore) : (transition2 += (long)offsetAfter))));
                    }
                    if (sec >= transition2) break;
                }
                offsets[0] = this.rawOffsetAt(transIdx) * 1000;
                offsets[1] = this.dstOffsetAt(transIdx) * 1000;
            }
        } else {
            offsets[0] = this.initialRawOffset() * 1000;
            offsets[1] = this.initialDstOffset() * 1000;
        }
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$getInt(byte val) {
        return val & 0xFF;
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$zoneOffsetAt(int transIdx) {
        int typeIdx = transIdx >= 0 ? this.getInt(this.typeMapData[transIdx]) * 2 : 0;
        return this.typeOffsets[typeIdx] + this.typeOffsets[typeIdx + 1];
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$rawOffsetAt(int transIdx) {
        int typeIdx = transIdx >= 0 ? this.getInt(this.typeMapData[transIdx]) * 2 : 0;
        return this.typeOffsets[typeIdx];
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$dstOffsetAt(int transIdx) {
        int typeIdx = transIdx >= 0 ? this.getInt(this.typeMapData[transIdx]) * 2 : 0;
        return this.typeOffsets[typeIdx + 1];
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$initialRawOffset() {
        return this.typeOffsets[0];
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$initialDstOffset() {
        return this.typeOffsets[1];
    }

    private final String $$robo$$android_icu_impl_OlsonTimeZone$toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('[');
        buf.append("transitionCount=" + this.transitionCount);
        buf.append(",typeCount=" + this.typeCount);
        buf.append(",transitionTimes=");
        if (this.transitionTimes64 != null) {
            buf.append('[');
            for (i = 0; i < this.transitionTimes64.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(Long.toString(this.transitionTimes64[i]));
            }
            buf.append(']');
        } else {
            buf.append("null");
        }
        buf.append(",typeOffsets=");
        if (this.typeOffsets != null) {
            buf.append('[');
            for (i = 0; i < this.typeOffsets.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(Integer.toString(this.typeOffsets[i]));
            }
            buf.append(']');
        } else {
            buf.append("null");
        }
        buf.append(",typeMapData=");
        if (this.typeMapData != null) {
            buf.append('[');
            for (i = 0; i < this.typeMapData.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(Byte.toString(this.typeMapData[i]));
            }
        } else {
            buf.append("null");
        }
        buf.append(",finalStartYear=" + this.finalStartYear);
        buf.append(",finalStartMillis=" + this.finalStartMillis);
        buf.append(",finalZone=" + this.finalZone);
        buf.append(']');
        return buf.toString();
    }

    private static final UResourceBundle $$robo$$android_icu_impl_OlsonTimeZone$loadRule(UResourceBundle top, String ruleid) {
        UResourceBundle r = top.get("Rules");
        r = r.get(ruleid);
        return r;
    }

    private final boolean $$robo$$android_icu_impl_OlsonTimeZone$equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        OlsonTimeZone z = (OlsonTimeZone)obj;
        return Utility.arrayEquals(this.typeMapData, (Object)z.typeMapData) || this.finalStartYear == z.finalStartYear && (this.finalZone == null && z.finalZone == null || this.finalZone != null && z.finalZone != null && this.finalZone.equals(z.finalZone) && this.transitionCount == z.transitionCount && this.typeCount == z.typeCount && Utility.arrayEquals((Object)this.transitionTimes64, (Object)z.transitionTimes64) && Utility.arrayEquals(this.typeOffsets, (Object)z.typeOffsets) && Utility.arrayEquals(this.typeMapData, (Object)z.typeMapData));
    }

    private final int $$robo$$android_icu_impl_OlsonTimeZone$hashCode() {
        int i;
        int ret = (int)((long)(this.finalStartYear ^ (this.finalStartYear >>> 4) + this.transitionCount ^ (this.transitionCount >>> 6) + this.typeCount) ^ (long)(this.typeCount >>> 8) + Double.doubleToLongBits(this.finalStartMillis) + (long)(this.finalZone == null ? 0 : this.finalZone.hashCode()) + (long)super.hashCode());
        if (this.transitionTimes64 != null) {
            for (i = 0; i < this.transitionTimes64.length; ++i) {
                ret = (int)((long)ret + (this.transitionTimes64[i] ^ this.transitionTimes64[i] >>> 8));
            }
        }
        for (i = 0; i < this.typeOffsets.length; ++i) {
            ret += this.typeOffsets[i] ^ this.typeOffsets[i] >>> 8;
        }
        if (this.typeMapData != null) {
            for (i = 0; i < this.typeMapData.length; ++i) {
                ret += this.typeMapData[i] & 0xFF;
            }
        }
        return ret;
    }

    private final TimeZoneTransition $$robo$$android_icu_impl_OlsonTimeZone$getNextTransition(long base, boolean inclusive) {
        this.initTransitionRules();
        if (this.finalZone != null) {
            if (inclusive && base == this.firstFinalTZTransition.getTime()) {
                return this.firstFinalTZTransition;
            }
            if (base >= this.firstFinalTZTransition.getTime()) {
                if (this.finalZone.useDaylightTime()) {
                    return this.finalZoneWithStartYear.getNextTransition(base, inclusive);
                }
                return null;
            }
        }
        if (this.historicRules != null) {
            long t;
            int ttidx;
            for (ttidx = this.transitionCount - 1; ttidx >= this.firstTZTransitionIdx && base <= (t = this.transitionTimes64[ttidx] * 1000L) && (inclusive || base != t); --ttidx) {
            }
            if (ttidx == this.transitionCount - 1) {
                return this.firstFinalTZTransition;
            }
            if (ttidx < this.firstTZTransitionIdx) {
                return this.firstTZTransition;
            }
            TimeArrayTimeZoneRule to = this.historicRules[this.getInt(this.typeMapData[ttidx + 1])];
            TimeArrayTimeZoneRule from = this.historicRules[this.getInt(this.typeMapData[ttidx])];
            long startTime = this.transitionTimes64[ttidx + 1] * 1000L;
            if (from.getName().equals(to.getName()) && from.getRawOffset() == to.getRawOffset() && from.getDSTSavings() == to.getDSTSavings()) {
                return this.getNextTransition(startTime, false);
            }
            return new TimeZoneTransition(startTime, from, to);
        }
        return null;
    }

    private final TimeZoneTransition $$robo$$android_icu_impl_OlsonTimeZone$getPreviousTransition(long base, boolean inclusive) {
        this.initTransitionRules();
        if (this.finalZone != null) {
            if (inclusive && base == this.firstFinalTZTransition.getTime()) {
                return this.firstFinalTZTransition;
            }
            if (base > this.firstFinalTZTransition.getTime()) {
                if (this.finalZone.useDaylightTime()) {
                    return this.finalZoneWithStartYear.getPreviousTransition(base, inclusive);
                }
                return this.firstFinalTZTransition;
            }
        }
        if (this.historicRules != null) {
            long t;
            int ttidx;
            for (ttidx = this.transitionCount - 1; !(ttidx < this.firstTZTransitionIdx || base > (t = this.transitionTimes64[ttidx] * 1000L) || inclusive && base == t); --ttidx) {
            }
            if (ttidx < this.firstTZTransitionIdx) {
                return null;
            }
            if (ttidx == this.firstTZTransitionIdx) {
                return this.firstTZTransition;
            }
            TimeArrayTimeZoneRule to = this.historicRules[this.getInt(this.typeMapData[ttidx])];
            TimeArrayTimeZoneRule from = this.historicRules[this.getInt(this.typeMapData[ttidx - 1])];
            long startTime = this.transitionTimes64[ttidx] * 1000L;
            if (from.getName().equals(to.getName()) && from.getRawOffset() == to.getRawOffset() && from.getDSTSavings() == to.getDSTSavings()) {
                return this.getPreviousTransition(startTime, false);
            }
            return new TimeZoneTransition(startTime, from, to);
        }
        return null;
    }

    private final TimeZoneRule[] $$robo$$android_icu_impl_OlsonTimeZone$getTimeZoneRules() {
        this.initTransitionRules();
        int size = 1;
        if (this.historicRules != null) {
            for (int i = 0; i < this.historicRules.length; ++i) {
                if (this.historicRules[i] == null) continue;
                ++size;
            }
        }
        if (this.finalZone != null) {
            size = this.finalZone.useDaylightTime() ? (size += 2) : ++size;
        }
        TimeZoneRule[] rules = new TimeZoneRule[size];
        int idx = 0;
        rules[idx++] = this.initialRule;
        if (this.historicRules != null) {
            for (int i = 0; i < this.historicRules.length; ++i) {
                if (this.historicRules[i] == null) continue;
                rules[idx++] = this.historicRules[i];
            }
        }
        if (this.finalZone != null) {
            if (this.finalZone.useDaylightTime()) {
                TimeZoneRule[] stzr = this.finalZoneWithStartYear.getTimeZoneRules();
                rules[idx++] = stzr[1];
                rules[idx++] = stzr[2];
            } else {
                rules[idx++] = new TimeArrayTimeZoneRule(this.getID() + "(STD)", this.finalZone.getRawOffset(), 0, new long[]{(long)this.finalStartMillis}, 2);
            }
        }
        return rules;
    }

    private final synchronized void $$robo$$android_icu_impl_OlsonTimeZone$initTransitionRules() {
        if (this.transitionRulesInitialized) {
            return;
        }
        this.initialRule = null;
        this.firstTZTransition = null;
        this.firstFinalTZTransition = null;
        this.historicRules = null;
        this.firstTZTransitionIdx = 0;
        this.finalZoneWithStartYear = null;
        String stdName = this.getID() + "(STD)";
        String dstName = this.getID() + "(DST)";
        int raw2 = this.initialRawOffset() * 1000;
        int dst = this.initialDstOffset() * 1000;
        this.initialRule = new InitialTimeZoneRule(dst == 0 ? stdName : dstName, raw2, dst);
        if (this.transitionCount > 0) {
            int transitionIdx;
            for (transitionIdx = 0; transitionIdx < this.transitionCount && this.getInt(this.typeMapData[transitionIdx]) == 0; ++transitionIdx) {
                ++this.firstTZTransitionIdx;
            }
            if (transitionIdx != this.transitionCount) {
                int typeIdx;
                long[] times = new long[this.transitionCount];
                for (typeIdx = 0; typeIdx < this.typeCount; ++typeIdx) {
                    int nTimes = 0;
                    for (transitionIdx = this.firstTZTransitionIdx; transitionIdx < this.transitionCount; ++transitionIdx) {
                        long tt;
                        if (typeIdx != this.getInt(this.typeMapData[transitionIdx]) || !((double)(tt = this.transitionTimes64[transitionIdx] * 1000L) < this.finalStartMillis)) continue;
                        times[nTimes++] = tt;
                    }
                    if (nTimes <= 0) continue;
                    long[] startTimes = new long[nTimes];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)times, (int)0, (Object)startTimes, (int)0, (int)nTimes);
                    raw2 = this.typeOffsets[typeIdx * 2] * 1000;
                    dst = this.typeOffsets[typeIdx * 2 + 1] * 1000;
                    if (this.historicRules == null) {
                        this.historicRules = new TimeArrayTimeZoneRule[this.typeCount];
                    }
                    this.historicRules[typeIdx] = new TimeArrayTimeZoneRule(dst == 0 ? stdName : dstName, raw2, dst, startTimes, 2);
                }
                typeIdx = this.getInt(this.typeMapData[this.firstTZTransitionIdx]);
                this.firstTZTransition = new TimeZoneTransition(this.transitionTimes64[this.firstTZTransitionIdx] * 1000L, this.initialRule, this.historicRules[typeIdx]);
            }
        }
        if (this.finalZone != null) {
            TimeZoneRule firstFinalRule;
            long startTime = (long)this.finalStartMillis;
            if (this.finalZone.useDaylightTime()) {
                this.finalZoneWithStartYear = (SimpleTimeZone)this.finalZone.clone();
                this.finalZoneWithStartYear.setStartYear(this.finalStartYear);
                TimeZoneTransition tzt = this.finalZoneWithStartYear.getNextTransition(startTime, false);
                firstFinalRule = tzt.getTo();
                startTime = tzt.getTime();
            } else {
                this.finalZoneWithStartYear = this.finalZone;
                firstFinalRule = new TimeArrayTimeZoneRule(this.finalZone.getID(), this.finalZone.getRawOffset(), 0, new long[]{startTime}, 2);
            }
            TimeZoneRule prevRule = null;
            if (this.transitionCount > 0) {
                prevRule = this.historicRules[this.getInt(this.typeMapData[this.transitionCount - 1])];
            }
            if (prevRule == null) {
                prevRule = this.initialRule;
            }
            this.firstFinalTZTransition = new TimeZoneTransition(startTime, prevRule, firstFinalRule);
        }
        this.transitionRulesInitialized = true;
    }

    private final void $$robo$$android_icu_impl_OlsonTimeZone$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            boolean initialized = false;
            String tzid = this.getID();
            if (tzid != null) {
                try {
                    UResourceBundle top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b", "zoneinfo64", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                    UResourceBundle res = ZoneMeta.openOlsonResource(top, tzid);
                    this.construct(top, res);
                    if (this.finalZone != null) {
                        this.finalZone.setID(tzid);
                    }
                    initialized = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!initialized) {
                this.constructEmpty();
            }
        }
        this.transitionRulesInitialized = false;
    }

    private final boolean $$robo$$android_icu_impl_OlsonTimeZone$isFrozen() {
        return this.isFrozen;
    }

    private final TimeZone $$robo$$android_icu_impl_OlsonTimeZone$freeze() {
        this.isFrozen = true;
        return this;
    }

    private final TimeZone $$robo$$android_icu_impl_OlsonTimeZone$cloneAsThawed() {
        OlsonTimeZone tz = (OlsonTimeZone)super.cloneAsThawed();
        if (this.finalZone != null) {
            this.finalZone.setID(this.getID());
            tz.finalZone = (SimpleTimeZone)this.finalZone.clone();
        }
        tz.isFrozen = false;
        return tz;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !OlsonTimeZone.class.desiredAssertionStatus();
        DEBUG = ICUDebug.enabled("olson");
    }

    @Override
    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_impl_OlsonTimeZone$getOffset(int int int int int int ), this, n, n2, n3, n4, n5, n6);
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_impl_OlsonTimeZone$getOffset(int int int int int int int ), this, n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void setRawOffset(int n) {
        InvokeDynamicSupport.bootstrap("setRawOffset", $$robo$$android_icu_impl_OlsonTimeZone$setRawOffset(int ), this, n);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_impl_OlsonTimeZone$clone(), this);
    }

    @Override
    public void getOffset(long l, boolean bl, int[] nArray) {
        InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_impl_OlsonTimeZone$getOffset(long boolean int[] ), this, l, bl, nArray);
    }

    @Override
    public void getOffsetFromLocal(long l, int n, int n2, int[] nArray) {
        InvokeDynamicSupport.bootstrap("getOffsetFromLocal", $$robo$$android_icu_impl_OlsonTimeZone$getOffsetFromLocal(long int int int[] ), this, l, n, n2, nArray);
    }

    @Override
    public int getRawOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getRawOffset", $$robo$$android_icu_impl_OlsonTimeZone$getRawOffset(), this);
    }

    @Override
    public boolean useDaylightTime() {
        return (boolean)InvokeDynamicSupport.bootstrap("useDaylightTime", $$robo$$android_icu_impl_OlsonTimeZone$useDaylightTime(), this);
    }

    @Override
    public boolean observesDaylightTime() {
        return (boolean)InvokeDynamicSupport.bootstrap("observesDaylightTime", $$robo$$android_icu_impl_OlsonTimeZone$observesDaylightTime(), this);
    }

    @Override
    public int getDSTSavings() {
        return (int)InvokeDynamicSupport.bootstrap("getDSTSavings", $$robo$$android_icu_impl_OlsonTimeZone$getDSTSavings(), this);
    }

    @Override
    public boolean inDaylightTime(Date date) {
        return (boolean)InvokeDynamicSupport.bootstrap("inDaylightTime", $$robo$$android_icu_impl_OlsonTimeZone$inDaylightTime(java.util.Date ), this, date);
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameRules", $$robo$$android_icu_impl_OlsonTimeZone$hasSameRules(android.icu.util.TimeZone ), this, timeZone);
    }

    public String getCanonicalID() {
        return InvokeDynamicSupport.bootstrap("getCanonicalID", $$robo$$android_icu_impl_OlsonTimeZone$getCanonicalID(), this);
    }

    private void constructEmpty() {
        InvokeDynamicSupport.bootstrap("constructEmpty", $$robo$$android_icu_impl_OlsonTimeZone$constructEmpty(), this);
    }

    private void __constructor__(UResourceBundle uResourceBundle, UResourceBundle uResourceBundle2, String string2) {
        this.$$robo$$android_icu_impl_OlsonTimeZone$__constructor__(uResourceBundle, uResourceBundle2, string2);
    }

    public OlsonTimeZone(UResourceBundle uResourceBundle, UResourceBundle uResourceBundle2, String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_OlsonTimeZone$__constructor__(android.icu.util.UResourceBundle android.icu.util.UResourceBundle java.lang.String ), this, uResourceBundle, uResourceBundle2, string2);
    }

    private void construct(UResourceBundle uResourceBundle, UResourceBundle uResourceBundle2) {
        InvokeDynamicSupport.bootstrap("construct", $$robo$$android_icu_impl_OlsonTimeZone$construct(android.icu.util.UResourceBundle android.icu.util.UResourceBundle ), this, uResourceBundle, uResourceBundle2);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_impl_OlsonTimeZone$__constructor__(string2);
    }

    public OlsonTimeZone(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_OlsonTimeZone$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public void setID(String string2) {
        InvokeDynamicSupport.bootstrap("setID", $$robo$$android_icu_impl_OlsonTimeZone$setID(java.lang.String ), this, string2);
    }

    private void getHistoricalOffset(long l, boolean bl, int n, int n2, int[] nArray) {
        InvokeDynamicSupport.bootstrap("getHistoricalOffset", $$robo$$android_icu_impl_OlsonTimeZone$getHistoricalOffset(long boolean int int int[] ), this, l, bl, n, n2, nArray);
    }

    private int getInt(byte by) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_icu_impl_OlsonTimeZone$getInt(byte ), this, by);
    }

    private int zoneOffsetAt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("zoneOffsetAt", $$robo$$android_icu_impl_OlsonTimeZone$zoneOffsetAt(int ), this, n);
    }

    private int rawOffsetAt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("rawOffsetAt", $$robo$$android_icu_impl_OlsonTimeZone$rawOffsetAt(int ), this, n);
    }

    private int dstOffsetAt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("dstOffsetAt", $$robo$$android_icu_impl_OlsonTimeZone$dstOffsetAt(int ), this, n);
    }

    private int initialRawOffset() {
        return (int)InvokeDynamicSupport.bootstrap("initialRawOffset", $$robo$$android_icu_impl_OlsonTimeZone$initialRawOffset(), this);
    }

    private int initialDstOffset() {
        return (int)InvokeDynamicSupport.bootstrap("initialDstOffset", $$robo$$android_icu_impl_OlsonTimeZone$initialDstOffset(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_OlsonTimeZone$toString(), this);
    }

    private static UResourceBundle loadRule(UResourceBundle uResourceBundle, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("loadRule", $$robo$$android_icu_impl_OlsonTimeZone$loadRule(android.icu.util.UResourceBundle java.lang.String ), (UResourceBundle)uResourceBundle, (String)string2);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_OlsonTimeZone$equals(java.lang.Object ), this, object);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_OlsonTimeZone$hashCode(), this);
    }

    @Override
    public TimeZoneTransition getNextTransition(long l, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getNextTransition", $$robo$$android_icu_impl_OlsonTimeZone$getNextTransition(long boolean ), this, l, bl);
    }

    @Override
    public TimeZoneTransition getPreviousTransition(long l, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPreviousTransition", $$robo$$android_icu_impl_OlsonTimeZone$getPreviousTransition(long boolean ), this, l, bl);
    }

    @Override
    public TimeZoneRule[] getTimeZoneRules() {
        return InvokeDynamicSupport.bootstrap("getTimeZoneRules", $$robo$$android_icu_impl_OlsonTimeZone$getTimeZoneRules(), this);
    }

    private synchronized void initTransitionRules() {
        InvokeDynamicSupport.bootstrap("initTransitionRules", $$robo$$android_icu_impl_OlsonTimeZone$initTransitionRules(), this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_impl_OlsonTimeZone$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_impl_OlsonTimeZone$isFrozen(), this);
    }

    @Override
    public TimeZone freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_impl_OlsonTimeZone$freeze(), this);
    }

    @Override
    public TimeZone cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_impl_OlsonTimeZone$cloneAsThawed(), this);
    }

    static {
        RobolectricInternals.classInitializing(OlsonTimeZone.class);
    }

    public /* synthetic */ OlsonTimeZone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OlsonTimeZone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

