/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SoftCache;
import android.icu.impl.TextTrieMap;
import android.icu.impl.ZoneMeta;
import android.icu.text.LocaleDisplayNames;
import android.icu.text.TimeZoneFormat;
import android.icu.text.TimeZoneNames;
import android.icu.util.BasicTimeZone;
import android.icu.util.Freezable;
import android.icu.util.Output;
import android.icu.util.TimeZone;
import android.icu.util.TimeZoneTransition;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimeZoneGenericNames
implements Serializable,
Freezable<TimeZoneGenericNames> {
    public /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 2729910342063468417L;
    private ULocale _locale;
    private TimeZoneNames _tznames;
    private volatile transient boolean _frozen;
    private transient String _region;
    private transient WeakReference<LocaleDisplayNames> _localeDisplayNamesRef;
    private transient MessageFormat[] _patternFormatters;
    private transient ConcurrentHashMap<String, String> _genericLocationNamesMap;
    private transient ConcurrentHashMap<String, String> _genericPartialLocationNamesMap;
    private transient TextTrieMap<NameInfo> _gnamesTrie;
    private transient boolean _gnamesTrieFullyLoaded;
    private static Cache GENERIC_NAMES_CACHE;
    private static long DST_CHECK_RANGE = 15897600000L;
    private static TimeZoneNames.NameType[] GENERIC_NON_LOCATION_TYPES;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(ULocale locale, TimeZoneNames tznames) {
        this._locale = locale;
        this._tznames = tznames;
        this.init();
    }

    private final void $$robo$$android_icu_impl_TimeZoneGenericNames$init() {
        if (this._tznames == null) {
            this._tznames = TimeZoneNames.getInstance(this._locale);
        }
        this._genericLocationNamesMap = new ConcurrentHashMap();
        this._genericPartialLocationNamesMap = new ConcurrentHashMap();
        this._gnamesTrie = new TextTrieMap(true);
        this._gnamesTrieFullyLoaded = false;
        TimeZone tz = TimeZone.getDefault();
        String tzCanonicalID = ZoneMeta.getCanonicalCLDRID(tz);
        if (tzCanonicalID != null) {
            this.loadStrings(tzCanonicalID);
        }
    }

    private void $$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(ULocale locale) {
    }

    private static final TimeZoneGenericNames $$robo$$android_icu_impl_TimeZoneGenericNames$getInstance(ULocale locale) {
        String key = locale.getBaseName();
        return (TimeZoneGenericNames)GENERIC_NAMES_CACHE.getInstance(key, locale);
    }

    private final String $$robo$$android_icu_impl_TimeZoneGenericNames$getDisplayName(TimeZone tz, GenericNameType type, long date) {
        String name = null;
        String tzCanonicalID = null;
        switch (1.$SwitchMap$android$icu$impl$TimeZoneGenericNames$GenericNameType[type.ordinal()]) {
            case 1: {
                tzCanonicalID = ZoneMeta.getCanonicalCLDRID(tz);
                if (tzCanonicalID == null) break;
                name = this.getGenericLocationName(tzCanonicalID);
                break;
            }
            case 2: 
            case 3: {
                name = this.formatGenericNonLocationName(tz, type, date);
                if (name != null || (tzCanonicalID = ZoneMeta.getCanonicalCLDRID(tz)) == null) break;
                name = this.getGenericLocationName(tzCanonicalID);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_impl_TimeZoneGenericNames$getGenericLocationName(String canonicalTzID) {
        if (canonicalTzID == null || canonicalTzID.length() == 0) {
            return null;
        }
        String name = this._genericLocationNamesMap.get(canonicalTzID);
        if (name != null) {
            if (name.length() == 0) {
                return null;
            }
            return name;
        }
        Output<Boolean> isPrimary = new Output<Boolean>();
        String countryCode = ZoneMeta.getCanonicalCountry(canonicalTzID, isPrimary);
        if (countryCode != null) {
            if (((Boolean)isPrimary.value).booleanValue()) {
                String country = this.getLocaleDisplayNames().regionDisplayName(countryCode);
                name = this.formatPattern(Pattern.REGION_FORMAT, country);
            } else {
                String city = this._tznames.getExemplarLocationName(canonicalTzID);
                name = this.formatPattern(Pattern.REGION_FORMAT, city);
            }
        }
        if (name == null) {
            this._genericLocationNamesMap.putIfAbsent(canonicalTzID.intern(), "");
        } else {
            TimeZoneGenericNames timeZoneGenericNames = this;
            synchronized (timeZoneGenericNames) {
                canonicalTzID = canonicalTzID.intern();
                String tmp = this._genericLocationNamesMap.putIfAbsent(canonicalTzID, name.intern());
                if (tmp == null) {
                    NameInfo info = new NameInfo(canonicalTzID, GenericNameType.LOCATION);
                    this._gnamesTrie.put(name, info);
                } else {
                    name = tmp;
                }
            }
        }
        return name;
    }

    private final TimeZoneGenericNames $$robo$$android_icu_impl_TimeZoneGenericNames$setFormatPattern(Pattern patType, String patStr) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (!this._genericLocationNamesMap.isEmpty()) {
            this._genericLocationNamesMap = new ConcurrentHashMap();
        }
        if (!this._genericPartialLocationNamesMap.isEmpty()) {
            this._genericPartialLocationNamesMap = new ConcurrentHashMap();
        }
        this._gnamesTrie = null;
        this._gnamesTrieFullyLoaded = false;
        if (this._patternFormatters == null) {
            this._patternFormatters = new MessageFormat[Pattern.values().length];
        }
        this._patternFormatters[patType.ordinal()] = new MessageFormat(patStr);
        return this;
    }

    private final String $$robo$$android_icu_impl_TimeZoneGenericNames$formatGenericNonLocationName(TimeZone tz, GenericNameType type, long date) {
        if (!$assertionsDisabled && type != GenericNameType.LONG && type != GenericNameType.SHORT) {
            throw new AssertionError();
        }
        String tzID = ZoneMeta.getCanonicalCLDRID(tz);
        if (tzID == null) {
            return null;
        }
        TimeZoneNames.NameType nameType = type == GenericNameType.LONG ? TimeZoneNames.NameType.LONG_GENERIC : TimeZoneNames.NameType.SHORT_GENERIC;
        String name = this._tznames.getTimeZoneDisplayName(tzID, nameType);
        if (name != null) {
            return name;
        }
        String mzID = this._tznames.getMetaZoneID(tzID, date);
        if (mzID != null) {
            String mzName;
            TimeZoneNames.NameType stdNameType;
            String stdName;
            boolean useStandard = false;
            int[] offsets = new int[]{0, 0};
            tz.getOffset(date, false, offsets);
            if (offsets[1] == 0) {
                useStandard = true;
                if (tz instanceof BasicTimeZone) {
                    BasicTimeZone btz = (BasicTimeZone)tz;
                    TimeZoneTransition before = btz.getPreviousTransition(date, true);
                    if (before != null && date - before.getTime() < 15897600000L && before.getFrom().getDSTSavings() != 0) {
                        useStandard = false;
                    } else {
                        TimeZoneTransition after = btz.getNextTransition(date, false);
                        if (after != null && after.getTime() - date < 15897600000L && after.getTo().getDSTSavings() != 0) {
                            useStandard = false;
                        }
                    }
                } else {
                    int[] tmpOffsets = new int[2];
                    tz.getOffset(date - 15897600000L, false, tmpOffsets);
                    if (tmpOffsets[1] != 0) {
                        useStandard = false;
                    } else {
                        tz.getOffset(date + 15897600000L, false, tmpOffsets);
                        if (tmpOffsets[1] != 0) {
                            useStandard = false;
                        }
                    }
                }
            }
            if (useStandard && (stdName = this._tznames.getDisplayName(tzID, stdNameType = nameType == TimeZoneNames.NameType.LONG_GENERIC ? TimeZoneNames.NameType.LONG_STANDARD : TimeZoneNames.NameType.SHORT_STANDARD, date)) != null) {
                name = stdName;
                String mzGenericName = this._tznames.getMetaZoneDisplayName(mzID, nameType);
                if (stdName.equalsIgnoreCase(mzGenericName)) {
                    name = null;
                }
            }
            if (name == null && (mzName = this._tznames.getMetaZoneDisplayName(mzID, nameType)) != null) {
                String goldenID = this._tznames.getReferenceZoneID(mzID, this.getTargetRegion());
                if (goldenID != null && !goldenID.equals(tzID)) {
                    TimeZone goldenZone = TimeZone.getFrozenTimeZone(goldenID);
                    int[] offsets1 = new int[]{0, 0};
                    goldenZone.getOffset(date + (long)offsets[0] + (long)offsets[1], true, offsets1);
                    name = offsets[0] != offsets1[0] || offsets[1] != offsets1[1] ? this.getPartialLocationName(tzID, mzID, nameType == TimeZoneNames.NameType.LONG_GENERIC, mzName) : mzName;
                } else {
                    name = mzName;
                }
            }
        }
        return name;
    }

    private final synchronized String $$robo$$android_icu_impl_TimeZoneGenericNames$formatPattern(Pattern pat, String ... args) {
        int idx;
        if (this._patternFormatters == null) {
            this._patternFormatters = new MessageFormat[Pattern.values().length];
        }
        if (this._patternFormatters[idx = pat.ordinal()] == null) {
            String patText;
            try {
                ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b/zone", this._locale);
                patText = bundle.getStringWithFallback("zoneStrings/" + pat.key());
            }
            catch (MissingResourceException e) {
                patText = pat.defaultValue();
            }
            this._patternFormatters[idx] = new MessageFormat(patText);
        }
        return this._patternFormatters[idx].format(args);
    }

    private final synchronized LocaleDisplayNames $$robo$$android_icu_impl_TimeZoneGenericNames$getLocaleDisplayNames() {
        LocaleDisplayNames locNames = null;
        if (this._localeDisplayNamesRef != null) {
            locNames = (LocaleDisplayNames)this._localeDisplayNamesRef.get();
        }
        if (locNames == null) {
            locNames = LocaleDisplayNames.getInstance(this._locale);
            this._localeDisplayNamesRef = new WeakReference<LocaleDisplayNames>(locNames);
        }
        return locNames;
    }

    private final synchronized void $$robo$$android_icu_impl_TimeZoneGenericNames$loadStrings(String tzCanonicalID) {
        if (tzCanonicalID == null || tzCanonicalID.length() == 0) {
            return;
        }
        this.getGenericLocationName(tzCanonicalID);
        Set<String> mzIDs = this._tznames.getAvailableMetaZoneIDs(tzCanonicalID);
        for (String mzID : mzIDs) {
            String goldenID = this._tznames.getReferenceZoneID(mzID, this.getTargetRegion());
            if (tzCanonicalID.equals(goldenID)) continue;
            for (TimeZoneNames.NameType genNonLocType : GENERIC_NON_LOCATION_TYPES) {
                String mzGenName = this._tznames.getMetaZoneDisplayName(mzID, genNonLocType);
                if (mzGenName == null) continue;
                this.getPartialLocationName(tzCanonicalID, mzID, genNonLocType == TimeZoneNames.NameType.LONG_GENERIC, mzGenName);
            }
        }
    }

    private final synchronized String $$robo$$android_icu_impl_TimeZoneGenericNames$getTargetRegion() {
        if (this._region == null) {
            this._region = this._locale.getCountry();
            if (this._region.length() == 0) {
                ULocale tmp = ULocale.addLikelySubtags(this._locale);
                this._region = tmp.getCountry();
                if (this._region.length() == 0) {
                    this._region = "001";
                }
            }
        }
        return this._region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_impl_TimeZoneGenericNames$getPartialLocationName(String tzID, String mzID, boolean isLong, String mzDisplayName) {
        String letter = isLong ? "L" : "S";
        String key = tzID + "&" + mzID + "#" + letter;
        String name = this._genericPartialLocationNamesMap.get(key);
        if (name != null) {
            return name;
        }
        String location = null;
        String countryCode = ZoneMeta.getCanonicalCountry(tzID);
        if (countryCode != null) {
            String regionalGolden = this._tznames.getReferenceZoneID(mzID, countryCode);
            location = tzID.equals(regionalGolden) ? this.getLocaleDisplayNames().regionDisplayName(countryCode) : this._tznames.getExemplarLocationName(tzID);
        } else {
            location = this._tznames.getExemplarLocationName(tzID);
            if (location == null) {
                location = tzID;
            }
        }
        name = this.formatPattern(Pattern.FALLBACK_FORMAT, location, mzDisplayName);
        TimeZoneGenericNames timeZoneGenericNames = this;
        synchronized (timeZoneGenericNames) {
            String tmp = this._genericPartialLocationNamesMap.putIfAbsent(key.intern(), name.intern());
            if (tmp == null) {
                NameInfo info = new NameInfo(tzID.intern(), isLong ? GenericNameType.LONG : GenericNameType.SHORT);
                this._gnamesTrie.put(name, info);
            } else {
                name = tmp;
            }
        }
        return name;
    }

    private final GenericMatchInfo $$robo$$android_icu_impl_TimeZoneGenericNames$findBestMatch(String text, int start, EnumSet<GenericNameType> genericTypes) {
        Collection<GenericMatchInfo> localMatches;
        if (text == null || text.length() == 0 || start < 0 || start >= text.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        GenericMatchInfo bestMatch = null;
        Collection<TimeZoneNames.MatchInfo> tznamesMatches = this.findTimeZoneNames(text, start, genericTypes);
        if (tznamesMatches != null) {
            TimeZoneNames.MatchInfo longestMatch = null;
            for (TimeZoneNames.MatchInfo matchInfo : tznamesMatches) {
                if (longestMatch != null && matchInfo.matchLength() <= longestMatch.matchLength()) continue;
                longestMatch = matchInfo;
            }
            if (longestMatch != null && (bestMatch = this.createGenericMatchInfo(longestMatch)).matchLength() == text.length() - start && bestMatch.timeType != TimeZoneFormat.TimeType.STANDARD) {
                return bestMatch;
            }
        }
        if ((localMatches = this.findLocal(text, start, genericTypes)) != null) {
            for (GenericMatchInfo genericMatchInfo : localMatches) {
                if (bestMatch != null && genericMatchInfo.matchLength() < bestMatch.matchLength()) continue;
                bestMatch = genericMatchInfo;
            }
        }
        return bestMatch;
    }

    private final Collection<GenericMatchInfo> $$robo$$android_icu_impl_TimeZoneGenericNames$find(String text, int start, EnumSet<GenericNameType> genericTypes) {
        if (text == null || text.length() == 0 || start < 0 || start >= text.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        Collection<GenericMatchInfo> results = this.findLocal(text, start, genericTypes);
        Collection<TimeZoneNames.MatchInfo> tznamesMatches = this.findTimeZoneNames(text, start, genericTypes);
        if (tznamesMatches != null) {
            for (TimeZoneNames.MatchInfo match : tznamesMatches) {
                if (results == null) {
                    results = new LinkedList<GenericMatchInfo>();
                }
                results.add(this.createGenericMatchInfo(match));
            }
        }
        return results;
    }

    private final GenericMatchInfo $$robo$$android_icu_impl_TimeZoneGenericNames$createGenericMatchInfo(TimeZoneNames.MatchInfo matchInfo) {
        GenericNameType nameType = null;
        TimeZoneFormat.TimeType timeType = TimeZoneFormat.TimeType.UNKNOWN;
        switch (1.$SwitchMap$android$icu$text$TimeZoneNames$NameType[matchInfo.nameType().ordinal()]) {
            case 1: {
                nameType = GenericNameType.LONG;
                timeType = TimeZoneFormat.TimeType.STANDARD;
                break;
            }
            case 2: {
                nameType = GenericNameType.LONG;
                break;
            }
            case 3: {
                nameType = GenericNameType.SHORT;
                timeType = TimeZoneFormat.TimeType.STANDARD;
                break;
            }
            case 4: {
                nameType = GenericNameType.SHORT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected MatchInfo name type - " + (Object)((Object)matchInfo.nameType()));
            }
        }
        String tzID = matchInfo.tzID();
        if (tzID == null) {
            String mzID = matchInfo.mzID();
            if (!$assertionsDisabled && mzID == null) {
                throw new AssertionError();
            }
            tzID = this._tznames.getReferenceZoneID(mzID, this.getTargetRegion());
        }
        if (!$assertionsDisabled && tzID == null) {
            throw new AssertionError();
        }
        GenericMatchInfo gmatch = new GenericMatchInfo(nameType, tzID, matchInfo.matchLength(), timeType, null);
        return gmatch;
    }

    private final Collection<TimeZoneNames.MatchInfo> $$robo$$android_icu_impl_TimeZoneGenericNames$findTimeZoneNames(String text, int start, EnumSet<GenericNameType> types) {
        Collection<TimeZoneNames.MatchInfo> tznamesMatches = null;
        EnumSet<TimeZoneNames.NameType> nameTypes = EnumSet.noneOf(TimeZoneNames.NameType.class);
        if (types.contains((Object)GenericNameType.LONG)) {
            nameTypes.add(TimeZoneNames.NameType.LONG_GENERIC);
            nameTypes.add(TimeZoneNames.NameType.LONG_STANDARD);
        }
        if (types.contains((Object)GenericNameType.SHORT)) {
            nameTypes.add(TimeZoneNames.NameType.SHORT_GENERIC);
            nameTypes.add(TimeZoneNames.NameType.SHORT_STANDARD);
        }
        if (!nameTypes.isEmpty()) {
            tznamesMatches = this._tznames.find(text, start, nameTypes);
        }
        return tznamesMatches;
    }

    private final synchronized Collection<GenericMatchInfo> $$robo$$android_icu_impl_TimeZoneGenericNames$findLocal(String text, int start, EnumSet<GenericNameType> types) {
        GenericNameSearchHandler handler = new GenericNameSearchHandler(types);
        this._gnamesTrie.find(text, start, (TextTrieMap.ResultHandler<NameInfo>)handler);
        if (handler.getMaxMatchLen() == text.length() - start || this._gnamesTrieFullyLoaded) {
            return handler.getMatches();
        }
        Set<String> tzIDs = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, null, null);
        for (String tzID : tzIDs) {
            this.loadStrings(tzID);
        }
        this._gnamesTrieFullyLoaded = true;
        handler.resetResults();
        this._gnamesTrie.find(text, start, (TextTrieMap.ResultHandler<NameInfo>)handler);
        return handler.getMatches();
    }

    private final void $$robo$$android_icu_impl_TimeZoneGenericNames$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private final boolean $$robo$$android_icu_impl_TimeZoneGenericNames$isFrozen() {
        return this._frozen;
    }

    private final TimeZoneGenericNames $$robo$$android_icu_impl_TimeZoneGenericNames$freeze() {
        this._frozen = true;
        return this;
    }

    private final TimeZoneGenericNames $$robo$$android_icu_impl_TimeZoneGenericNames$cloneAsThawed() {
        TimeZoneGenericNames copy = null;
        try {
            copy = (TimeZoneGenericNames)super.clone();
            copy._frozen = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return copy;
    }

    private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(ULocale x0, 1 x1) {
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !TimeZoneGenericNames.class.desiredAssertionStatus();
        GENERIC_NAMES_CACHE = new Cache(null);
        GENERIC_NON_LOCATION_TYPES = new TimeZoneNames.NameType[]{TimeZoneNames.NameType.LONG_GENERIC, TimeZoneNames.NameType.SHORT_GENERIC};
    }

    private void __constructor__(ULocale uLocale, TimeZoneNames timeZoneNames) {
        this.$$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(uLocale, timeZoneNames);
    }

    public TimeZoneGenericNames(ULocale uLocale, TimeZoneNames timeZoneNames) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(android.icu.util.ULocale android.icu.text.TimeZoneNames ), this, uLocale, timeZoneNames);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_icu_impl_TimeZoneGenericNames$init(), this);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(uLocale);
    }

    public TimeZoneGenericNames(ULocale uLocale) {
        this(uLocale, (TimeZoneNames)null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(android.icu.util.ULocale ), this, uLocale);
    }

    public static TimeZoneGenericNames getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_impl_TimeZoneGenericNames$getInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public String getDisplayName(TimeZone timeZone, GenericNameType genericNameType, long l) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_impl_TimeZoneGenericNames$getDisplayName(android.icu.util.TimeZone android.icu.impl.TimeZoneGenericNames$GenericNameType long ), this, timeZone, genericNameType, l);
    }

    public String getGenericLocationName(String string2) {
        return InvokeDynamicSupport.bootstrap("getGenericLocationName", $$robo$$android_icu_impl_TimeZoneGenericNames$getGenericLocationName(java.lang.String ), this, string2);
    }

    public TimeZoneGenericNames setFormatPattern(Pattern pattern, String string2) {
        return InvokeDynamicSupport.bootstrap("setFormatPattern", $$robo$$android_icu_impl_TimeZoneGenericNames$setFormatPattern(android.icu.impl.TimeZoneGenericNames$Pattern java.lang.String ), this, pattern, string2);
    }

    private String formatGenericNonLocationName(TimeZone timeZone, GenericNameType genericNameType, long l) {
        return InvokeDynamicSupport.bootstrap("formatGenericNonLocationName", $$robo$$android_icu_impl_TimeZoneGenericNames$formatGenericNonLocationName(android.icu.util.TimeZone android.icu.impl.TimeZoneGenericNames$GenericNameType long ), this, timeZone, genericNameType, l);
    }

    private synchronized String formatPattern(Pattern pattern, String ... stringArray) {
        return InvokeDynamicSupport.bootstrap("formatPattern", $$robo$$android_icu_impl_TimeZoneGenericNames$formatPattern(android.icu.impl.TimeZoneGenericNames$Pattern java.lang.String[] ), this, pattern, stringArray);
    }

    private synchronized LocaleDisplayNames getLocaleDisplayNames() {
        return InvokeDynamicSupport.bootstrap("getLocaleDisplayNames", $$robo$$android_icu_impl_TimeZoneGenericNames$getLocaleDisplayNames(), this);
    }

    private synchronized void loadStrings(String string2) {
        InvokeDynamicSupport.bootstrap("loadStrings", $$robo$$android_icu_impl_TimeZoneGenericNames$loadStrings(java.lang.String ), this, string2);
    }

    private synchronized String getTargetRegion() {
        return InvokeDynamicSupport.bootstrap("getTargetRegion", $$robo$$android_icu_impl_TimeZoneGenericNames$getTargetRegion(), this);
    }

    private String getPartialLocationName(String string2, String string3, boolean bl, String string4) {
        return InvokeDynamicSupport.bootstrap("getPartialLocationName", $$robo$$android_icu_impl_TimeZoneGenericNames$getPartialLocationName(java.lang.String java.lang.String boolean java.lang.String ), this, string2, string3, bl, string4);
    }

    public GenericMatchInfo findBestMatch(String string2, int n, EnumSet<GenericNameType> enumSet) {
        return InvokeDynamicSupport.bootstrap("findBestMatch", $$robo$$android_icu_impl_TimeZoneGenericNames$findBestMatch(java.lang.String int java.util.EnumSet<android.icu.impl.TimeZoneGenericNames$GenericNameType> ), this, string2, n, enumSet);
    }

    public Collection<GenericMatchInfo> find(String string2, int n, EnumSet<GenericNameType> enumSet) {
        return InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_impl_TimeZoneGenericNames$find(java.lang.String int java.util.EnumSet<android.icu.impl.TimeZoneGenericNames$GenericNameType> ), this, string2, n, enumSet);
    }

    private GenericMatchInfo createGenericMatchInfo(TimeZoneNames.MatchInfo matchInfo) {
        return InvokeDynamicSupport.bootstrap("createGenericMatchInfo", $$robo$$android_icu_impl_TimeZoneGenericNames$createGenericMatchInfo(android.icu.text.TimeZoneNames$MatchInfo ), this, matchInfo);
    }

    private Collection<TimeZoneNames.MatchInfo> findTimeZoneNames(String string2, int n, EnumSet<GenericNameType> enumSet) {
        return InvokeDynamicSupport.bootstrap("findTimeZoneNames", $$robo$$android_icu_impl_TimeZoneGenericNames$findTimeZoneNames(java.lang.String int java.util.EnumSet<android.icu.impl.TimeZoneGenericNames$GenericNameType> ), this, string2, n, enumSet);
    }

    private synchronized Collection<GenericMatchInfo> findLocal(String string2, int n, EnumSet<GenericNameType> enumSet) {
        return InvokeDynamicSupport.bootstrap("findLocal", $$robo$$android_icu_impl_TimeZoneGenericNames$findLocal(java.lang.String int java.util.EnumSet<android.icu.impl.TimeZoneGenericNames$GenericNameType> ), this, string2, n, enumSet);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_impl_TimeZoneGenericNames$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_impl_TimeZoneGenericNames$isFrozen(), this);
    }

    @Override
    public TimeZoneGenericNames freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_impl_TimeZoneGenericNames$freeze(), this);
    }

    @Override
    public TimeZoneGenericNames cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_impl_TimeZoneGenericNames$cloneAsThawed(), this);
    }

    private /* synthetic */ void __constructor__(ULocale uLocale, 1 var2_2) {
        this.$$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(uLocale, var2_2);
    }

    public /* synthetic */ TimeZoneGenericNames(ULocale uLocale, 1 var2_2) {
        this(uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames$__constructor__(android.icu.util.ULocale android.icu.impl.TimeZoneGenericNames$1 ), this, uLocale, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(TimeZoneGenericNames.class);
    }

    public /* synthetic */ TimeZoneGenericNames() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneGenericNames)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Cache
    extends SoftCache<String, TimeZoneGenericNames, ULocale> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_TimeZoneGenericNames_Cache$__constructor__() {
        }

        private final TimeZoneGenericNames $$robo$$android_icu_impl_TimeZoneGenericNames_Cache$createInstance(String key, ULocale data) {
            return new TimeZoneGenericNames(data, null).freeze();
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneGenericNames_Cache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_Cache$__constructor__();
        }

        public Cache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_Cache$__constructor__(), this);
        }

        @Override
        protected TimeZoneGenericNames createInstance(String string2, ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_impl_TimeZoneGenericNames_Cache$createInstance(java.lang.String android.icu.util.ULocale ), this, string2, uLocale);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_Cache$__constructor__(var1_1);
        }

        public /* synthetic */ Cache(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_Cache$__constructor__(android.icu.impl.TimeZoneGenericNames$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class GenericNameSearchHandler
    implements TextTrieMap.ResultHandler<NameInfo> {
        public /* synthetic */ Object __robo_data__;
        private EnumSet<GenericNameType> _types;
        private Collection<GenericMatchInfo> _matches;
        private int _maxMatchLen;

        private void $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$__constructor__(EnumSet<GenericNameType> types) {
            this._types = types;
        }

        private final boolean $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$handlePrefixMatch(int matchLength, Iterator<NameInfo> values) {
            while (values.hasNext()) {
                NameInfo info = values.next();
                if (this._types != null && !this._types.contains((Object)info.type)) continue;
                GenericMatchInfo matchInfo = new GenericMatchInfo(info.type, info.tzID, matchLength, null);
                if (this._matches == null) {
                    this._matches = new LinkedList<GenericMatchInfo>();
                }
                this._matches.add(matchInfo);
                if (matchLength <= this._maxMatchLen) continue;
                this._maxMatchLen = matchLength;
            }
            return true;
        }

        private final Collection<GenericMatchInfo> $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$getMatches() {
            return this._matches;
        }

        private final int $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$getMaxMatchLen() {
            return this._maxMatchLen;
        }

        private final void $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$resetResults() {
            this._matches = null;
            this._maxMatchLen = 0;
        }

        private void __constructor__(EnumSet<GenericNameType> enumSet) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$__constructor__(enumSet);
        }

        public GenericNameSearchHandler(EnumSet<GenericNameType> enumSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$__constructor__(java.util.EnumSet<android.icu.impl.TimeZoneGenericNames$GenericNameType> ), this, enumSet);
        }

        @Override
        public boolean handlePrefixMatch(int n, Iterator<NameInfo> iterator) {
            return (boolean)InvokeDynamicSupport.bootstrap("handlePrefixMatch", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$handlePrefixMatch(int java.util.Iterator<android.icu.impl.TimeZoneGenericNames$NameInfo> ), this, n, iterator);
        }

        public Collection<GenericMatchInfo> getMatches() {
            return InvokeDynamicSupport.bootstrap("getMatches", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$getMatches(), this);
        }

        public int getMaxMatchLen() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxMatchLen", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$getMaxMatchLen(), this);
        }

        public void resetResults() {
            InvokeDynamicSupport.bootstrap("resetResults", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameSearchHandler$resetResults(), this);
        }

        public /* synthetic */ GenericNameSearchHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GenericNameSearchHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class GenericMatchInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        GenericNameType nameType;
        String tzID;
        int matchLength;
        TimeZoneFormat.TimeType timeType;

        private void $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(GenericNameType nameType, String tzID, int matchLength) {
        }

        private void $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(GenericNameType nameType, String tzID, int matchLength, TimeZoneFormat.TimeType timeType) {
            this.nameType = nameType;
            this.tzID = tzID;
            this.matchLength = matchLength;
            this.timeType = timeType;
        }

        private final GenericNameType $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$nameType() {
            return this.nameType;
        }

        private final String $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$tzID() {
            return this.tzID;
        }

        private final TimeZoneFormat.TimeType $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$timeType() {
            return this.timeType;
        }

        private final int $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$matchLength() {
            return this.matchLength;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(GenericNameType x0, String x1, int x2, 1 x3) {
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(GenericNameType x0, String x1, int x2, TimeZoneFormat.TimeType x3, 1 x4) {
        }

        private void __constructor__(GenericNameType genericNameType, String string2, int n) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(genericNameType, string2, n);
        }

        public GenericMatchInfo(GenericNameType genericNameType, String string2, int n) {
            this(genericNameType, string2, n, TimeZoneFormat.TimeType.UNKNOWN);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(android.icu.impl.TimeZoneGenericNames$GenericNameType java.lang.String int ), this, genericNameType, string2, n);
        }

        private void __constructor__(GenericNameType genericNameType, String string2, int n, TimeZoneFormat.TimeType timeType) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(genericNameType, string2, n, timeType);
        }

        public GenericMatchInfo(GenericNameType genericNameType, String string2, int n, TimeZoneFormat.TimeType timeType) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(android.icu.impl.TimeZoneGenericNames$GenericNameType java.lang.String int android.icu.text.TimeZoneFormat$TimeType ), this, genericNameType, string2, n, timeType);
        }

        public GenericNameType nameType() {
            return InvokeDynamicSupport.bootstrap("nameType", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$nameType(), this);
        }

        public String tzID() {
            return InvokeDynamicSupport.bootstrap("tzID", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$tzID(), this);
        }

        public TimeZoneFormat.TimeType timeType() {
            return InvokeDynamicSupport.bootstrap("timeType", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$timeType(), this);
        }

        public int matchLength() {
            return (int)InvokeDynamicSupport.bootstrap("matchLength", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$matchLength(), this);
        }

        private /* synthetic */ void __constructor__(GenericNameType genericNameType, String string2, int n, 1 var4_4) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(genericNameType, string2, n, var4_4);
        }

        public /* synthetic */ GenericMatchInfo(GenericNameType genericNameType, String string2, int n, 1 var4_4) {
            this(genericNameType, string2, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(android.icu.impl.TimeZoneGenericNames$GenericNameType java.lang.String int android.icu.impl.TimeZoneGenericNames$1 ), this, genericNameType, string2, n, var4_4);
        }

        private /* synthetic */ void __constructor__(GenericNameType genericNameType, String string2, int n, TimeZoneFormat.TimeType timeType, 1 var5_5) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(genericNameType, string2, n, timeType, var5_5);
        }

        public /* synthetic */ GenericMatchInfo(GenericNameType genericNameType, String string2, int n, TimeZoneFormat.TimeType timeType, 1 var5_5) {
            this(genericNameType, string2, n, timeType);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericMatchInfo$__constructor__(android.icu.impl.TimeZoneGenericNames$GenericNameType java.lang.String int android.icu.text.TimeZoneFormat$TimeType android.icu.impl.TimeZoneGenericNames$1 ), this, genericNameType, string2, n, timeType, var5_5);
        }

        public /* synthetic */ GenericMatchInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GenericMatchInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class NameInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String tzID;
        GenericNameType type;

        private void $$robo$$android_icu_impl_TimeZoneGenericNames_NameInfo$__constructor__(String tzID, GenericNameType type) {
            this.tzID = tzID;
            this.type = type;
        }

        private void __constructor__(String string2, GenericNameType genericNameType) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_NameInfo$__constructor__(string2, genericNameType);
        }

        public NameInfo(String string2, GenericNameType genericNameType) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_NameInfo$__constructor__(java.lang.String android.icu.impl.TimeZoneGenericNames$GenericNameType ), this, string2, genericNameType);
        }

        public /* synthetic */ NameInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NameInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Pattern
    extends Enum<Pattern> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Pattern REGION_FORMAT;
        public static /* enum */ Pattern FALLBACK_FORMAT;
        String _key;
        String _defaultVal;
        private static /* synthetic */ Pattern[] $VALUES;

        private static final Pattern[] $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$values() {
            return (Pattern[])$VALUES.clone();
        }

        private static final Pattern $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$valueOf(String name) {
            return Enum.valueOf(Pattern.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$__constructor__(String string2, int n, String key, String defaultVal) {
            this._key = key;
            this._defaultVal = defaultVal;
        }

        private final String $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$key() {
            return this._key;
        }

        private final String $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$defaultValue() {
            return this._defaultVal;
        }

        static void __staticInitializer__() {
            REGION_FORMAT = new Pattern("regionFormat", "({0})");
            FALLBACK_FORMAT = new Pattern("fallbackFormat", "{1} ({0})");
            $VALUES = new Pattern[]{REGION_FORMAT, FALLBACK_FORMAT};
        }

        public static Pattern[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$values());
        }

        public static Pattern valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, String string3, String string4) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$__constructor__(string2, n, string3, string4);
        }

        public Pattern(String string3, String string4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$__constructor__(java.lang.String int java.lang.String java.lang.String ), this, string2, n, string3, string4);
        }

        String key() {
            return InvokeDynamicSupport.bootstrap("key", $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$key(), this);
        }

        String defaultValue() {
            return InvokeDynamicSupport.bootstrap("defaultValue", $$robo$$android_icu_impl_TimeZoneGenericNames_Pattern$defaultValue(), this);
        }

        static {
            RobolectricInternals.classInitializing(Pattern.class);
        }

        public /* synthetic */ Pattern() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Pattern)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class GenericNameType
    extends Enum<GenericNameType> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ GenericNameType LOCATION;
        public static /* enum */ GenericNameType LONG;
        public static /* enum */ GenericNameType SHORT;
        String[] _fallbackTypeOf;
        private static /* synthetic */ GenericNameType[] $VALUES;

        private static final GenericNameType[] $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$values() {
            return (GenericNameType[])$VALUES.clone();
        }

        private static final GenericNameType $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$valueOf(String name) {
            return Enum.valueOf(GenericNameType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$__constructor__(String string2, int n, String ... fallbackTypeOf) {
            this._fallbackTypeOf = fallbackTypeOf;
        }

        private final boolean $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$isFallbackTypeOf(GenericNameType type) {
            String typeStr = type.toString();
            for (String t : this._fallbackTypeOf) {
                if (!t.equals(typeStr)) continue;
                return true;
            }
            return false;
        }

        static void __staticInitializer__() {
            LOCATION = new GenericNameType("LONG", "SHORT");
            LONG = new GenericNameType(new String[0]);
            SHORT = new GenericNameType(new String[0]);
            $VALUES = new GenericNameType[]{LOCATION, LONG, SHORT};
        }

        public static GenericNameType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$values());
        }

        public static GenericNameType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, String ... stringArray) {
            this.$$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$__constructor__(string2, n, stringArray);
        }

        public GenericNameType(String ... stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$__constructor__(java.lang.String int java.lang.String[] ), this, string2, n, stringArray);
        }

        public boolean isFallbackTypeOf(GenericNameType genericNameType) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFallbackTypeOf", $$robo$$android_icu_impl_TimeZoneGenericNames_GenericNameType$isFallbackTypeOf(android.icu.impl.TimeZoneGenericNames$GenericNameType ), this, genericNameType);
        }

        static {
            RobolectricInternals.classInitializing(GenericNameType.class);
        }

        public /* synthetic */ GenericNameType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GenericNameType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

