/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.text.UTF16;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Trie
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected static int LEAD_INDEX_OFFSET_ = 320;
    protected static int INDEX_STAGE_1_SHIFT_ = 5;
    protected static int INDEX_STAGE_2_SHIFT_ = 2;
    protected static int DATA_BLOCK_LENGTH = 32;
    protected static int INDEX_STAGE_3_MASK_ = 31;
    protected static int SURROGATE_BLOCK_BITS = 5;
    protected static int SURROGATE_BLOCK_COUNT = 32;
    protected static int BMP_INDEX_LENGTH = 2048;
    protected static int SURROGATE_MASK_ = 1023;
    protected char[] m_index_;
    protected DataManipulate m_dataManipulate_;
    protected int m_dataOffset_;
    protected int m_dataLength_;
    protected static int HEADER_LENGTH_ = 16;
    protected static int HEADER_OPTIONS_LATIN1_IS_LINEAR_MASK_ = 512;
    protected static int HEADER_SIGNATURE_ = 1416784229;
    private static int HEADER_OPTIONS_SHIFT_MASK_ = 15;
    protected static int HEADER_OPTIONS_INDEX_SHIFT_ = 4;
    protected static int HEADER_OPTIONS_DATA_IS_32_BIT_ = 256;
    private boolean m_isLatin1Linear_;
    private int m_options_;
    static /* synthetic */ boolean $assertionsDisabled;

    private final boolean $$robo$$android_icu_impl_Trie$isLatin1Linear() {
        return this.m_isLatin1Linear_;
    }

    private final boolean $$robo$$android_icu_impl_Trie$equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Trie)) {
            return false;
        }
        Trie othertrie = (Trie)other;
        return this.m_isLatin1Linear_ == othertrie.m_isLatin1Linear_ && this.m_options_ == othertrie.m_options_ && this.m_dataLength_ == othertrie.m_dataLength_ && Arrays.equals(this.m_index_, othertrie.m_index_);
    }

    private final int $$robo$$android_icu_impl_Trie$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    private final int $$robo$$android_icu_impl_Trie$getSerializedDataSize() {
        int result = 16;
        result += this.m_dataOffset_ << 1;
        if (this.isCharTrie()) {
            result += this.m_dataLength_ << 1;
        } else if (this.isIntTrie()) {
            result += this.m_dataLength_ << 2;
        }
        return result;
    }

    private void $$robo$$android_icu_impl_Trie$__constructor__(ByteBuffer bytes, DataManipulate dataManipulate) {
        int signature = bytes.getInt();
        this.m_options_ = bytes.getInt();
        if (!this.checkHeader(signature)) {
            throw new IllegalArgumentException("ICU data file error: Trie header authentication failed, please check if you have the most updated ICU data file");
        }
        this.m_dataManipulate_ = dataManipulate != null ? dataManipulate : new DefaultGetFoldingOffset(null);
        this.m_isLatin1Linear_ = (this.m_options_ & 0x200) != 0;
        this.m_dataOffset_ = bytes.getInt();
        this.m_dataLength_ = bytes.getInt();
        this.unserialize(bytes);
    }

    private void $$robo$$android_icu_impl_Trie$__constructor__(char[] index, int options, DataManipulate dataManipulate) {
        this.m_options_ = options;
        this.m_dataManipulate_ = dataManipulate != null ? dataManipulate : new DefaultGetFoldingOffset(null);
        this.m_isLatin1Linear_ = (this.m_options_ & 0x200) != 0;
        this.m_index_ = index;
        this.m_dataOffset_ = this.m_index_.length;
    }

    protected abstract int getSurrogateOffset(char var1, char var2);

    protected abstract int getValue(int var1);

    protected abstract int getInitialValue();

    private final int $$robo$$android_icu_impl_Trie$getRawOffset(int offset, char ch) {
        return (this.m_index_[offset + (ch >> 5)] << 2) + (ch & 0x1F);
    }

    private final int $$robo$$android_icu_impl_Trie$getBMPOffset(char ch) {
        return ch >= '\ud800' && ch <= '\udbff' ? this.getRawOffset(320, ch) : this.getRawOffset(0, ch);
    }

    private final int $$robo$$android_icu_impl_Trie$getLeadOffset(char ch) {
        return this.getRawOffset(0, ch);
    }

    private final int $$robo$$android_icu_impl_Trie$getCodePointOffset(int ch) {
        if (ch < 0) {
            return -1;
        }
        if (ch < 55296) {
            return this.getRawOffset(0, (char)ch);
        }
        if (ch < 65536) {
            return this.getBMPOffset((char)ch);
        }
        if (ch <= 0x10FFFF) {
            return this.getSurrogateOffset(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF));
        }
        return -1;
    }

    private final void $$robo$$android_icu_impl_Trie$unserialize(ByteBuffer bytes) {
        this.m_index_ = ICUBinary.getChars(bytes, this.m_dataOffset_, 0);
    }

    private final boolean $$robo$$android_icu_impl_Trie$isIntTrie() {
        return (this.m_options_ & 0x100) != 0;
    }

    private final boolean $$robo$$android_icu_impl_Trie$isCharTrie() {
        return (this.m_options_ & 0x100) == 0;
    }

    private final boolean $$robo$$android_icu_impl_Trie$checkHeader(int signature) {
        if (signature != 1416784229) {
            return false;
        }
        return (this.m_options_ & 0xF) == 5 && (this.m_options_ >> 4 & 0xF) == 2;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !Trie.class.desiredAssertionStatus();
    }

    public boolean isLatin1Linear() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLatin1Linear", $$robo$$android_icu_impl_Trie$isLatin1Linear(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_Trie$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_Trie$hashCode(), this);
    }

    public int getSerializedDataSize() {
        return (int)InvokeDynamicSupport.bootstrap("getSerializedDataSize", $$robo$$android_icu_impl_Trie$getSerializedDataSize(), this);
    }

    private void __constructor__(ByteBuffer byteBuffer, DataManipulate dataManipulate) {
        this.$$robo$$android_icu_impl_Trie$__constructor__(byteBuffer, dataManipulate);
    }

    public Trie(ByteBuffer byteBuffer, DataManipulate dataManipulate) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie$__constructor__(java.nio.ByteBuffer android.icu.impl.Trie$DataManipulate ), this, byteBuffer, dataManipulate);
    }

    private void __constructor__(char[] cArray, int n, DataManipulate dataManipulate) {
        this.$$robo$$android_icu_impl_Trie$__constructor__(cArray, n, dataManipulate);
    }

    public Trie(char[] cArray, int n, DataManipulate dataManipulate) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie$__constructor__(char[] int android.icu.impl.Trie$DataManipulate ), this, cArray, n, dataManipulate);
    }

    protected int getRawOffset(int n, char c) {
        return (int)InvokeDynamicSupport.bootstrap("getRawOffset", $$robo$$android_icu_impl_Trie$getRawOffset(int char ), this, n, c);
    }

    protected int getBMPOffset(char c) {
        return (int)InvokeDynamicSupport.bootstrap("getBMPOffset", $$robo$$android_icu_impl_Trie$getBMPOffset(char ), this, c);
    }

    protected int getLeadOffset(char c) {
        return (int)InvokeDynamicSupport.bootstrap("getLeadOffset", $$robo$$android_icu_impl_Trie$getLeadOffset(char ), this, c);
    }

    protected int getCodePointOffset(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCodePointOffset", $$robo$$android_icu_impl_Trie$getCodePointOffset(int ), this, n);
    }

    protected void unserialize(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("unserialize", $$robo$$android_icu_impl_Trie$unserialize(java.nio.ByteBuffer ), this, byteBuffer);
    }

    protected boolean isIntTrie() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIntTrie", $$robo$$android_icu_impl_Trie$isIntTrie(), this);
    }

    protected boolean isCharTrie() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCharTrie", $$robo$$android_icu_impl_Trie$isCharTrie(), this);
    }

    private boolean checkHeader(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkHeader", $$robo$$android_icu_impl_Trie$checkHeader(int ), this, n);
    }

    static {
        RobolectricInternals.classInitializing(Trie.class);
    }

    public /* synthetic */ Trie() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Trie)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DefaultGetFoldingOffset
    implements DataManipulate,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_Trie_DefaultGetFoldingOffset$__constructor__() {
        }

        private final int $$robo$$android_icu_impl_Trie_DefaultGetFoldingOffset$getFoldingOffset(int value) {
            return value;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_Trie_DefaultGetFoldingOffset$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_Trie_DefaultGetFoldingOffset$__constructor__();
        }

        public DefaultGetFoldingOffset() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie_DefaultGetFoldingOffset$__constructor__(), this);
        }

        @Override
        public int getFoldingOffset(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getFoldingOffset", $$robo$$android_icu_impl_Trie_DefaultGetFoldingOffset$getFoldingOffset(int ), this, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_Trie_DefaultGetFoldingOffset$__constructor__(var1_1);
        }

        public /* synthetic */ DefaultGetFoldingOffset(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Trie_DefaultGetFoldingOffset$__constructor__(android.icu.impl.Trie$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultGetFoldingOffset)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface DataManipulate {
        public int getFoldingOffset(int var1);
    }
}

