/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.Norm2AllModes;
import android.icu.impl.Normalizer2Impl;
import android.icu.impl.coll.Collation;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationDataBuilder;
import android.icu.impl.coll.CollationFastLatin;
import android.icu.impl.coll.CollationLoader;
import android.icu.impl.coll.CollationRootElements;
import android.icu.impl.coll.CollationRuleParser;
import android.icu.impl.coll.CollationSettings;
import android.icu.impl.coll.CollationTailoring;
import android.icu.impl.coll.CollationWeights;
import android.icu.impl.coll.UTF16CollationIterator;
import android.icu.impl.coll.UVector32;
import android.icu.impl.coll.UVector64;
import android.icu.text.CanonicalIterator;
import android.icu.text.Normalizer2;
import android.icu.text.UnicodeSet;
import android.icu.text.UnicodeSetIterator;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.text.ParseException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CollationBuilder
extends CollationRuleParser.Sink
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static UnicodeSet COMPOSITES;
    private static int MAX_INDEX = 1048575;
    private static int HAS_BEFORE2 = 64;
    private static int HAS_BEFORE3 = 32;
    private static int IS_TAILORED = 8;
    private Normalizer2 nfd;
    private Normalizer2 fcd;
    private Normalizer2Impl nfcImpl;
    private CollationTailoring base;
    private CollationData baseData;
    private CollationRootElements rootElements;
    private long variableTop;
    private CollationDataBuilder dataBuilder;
    private boolean fastLatinEnabled;
    private UnicodeSet optimizeSet;
    private long[] ces;
    private int cesLength;
    private UVector32 rootPrimaryIndexes;
    private UVector64 nodes;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_coll_CollationBuilder$__constructor__(CollationTailoring b) {
        this.optimizeSet = new UnicodeSet();
        this.ces = new long[31];
        this.nfd = Normalizer2.getNFDInstance();
        this.fcd = Norm2AllModes.getFCDNormalizer2();
        this.nfcImpl = Norm2AllModes.getNFCInstance().impl;
        this.base = b;
        this.baseData = b.data;
        this.rootElements = new CollationRootElements(b.data.rootElements);
        this.variableTop = 0L;
        this.dataBuilder = new CollationDataBuilder();
        this.fastLatinEnabled = true;
        this.cesLength = 0;
        this.rootPrimaryIndexes = new UVector32();
        this.nodes = new UVector64();
        this.nfcImpl.ensureCanonIterData();
        this.dataBuilder.initForTailoring(this.baseData);
    }

    private final CollationTailoring $$robo$$android_icu_impl_coll_CollationBuilder$parseAndBuild(String ruleString) throws ParseException {
        if (this.baseData.rootElements == null) {
            throw new UnsupportedOperationException("missing root elements data, tailoring not supported");
        }
        CollationTailoring tailoring = new CollationTailoring(this.base.settings);
        CollationRuleParser parser = new CollationRuleParser(this.baseData);
        this.variableTop = this.base.settings.readOnly().variableTop;
        parser.setSink(this);
        parser.setImporter(new BundleImporter());
        CollationSettings ownedSettings = tailoring.settings.copyOnWrite();
        parser.parse(ruleString, ownedSettings);
        if (this.dataBuilder.hasMappings()) {
            this.makeTailoredCEs();
            this.closeOverComposites();
            this.finalizeCEs();
            this.optimizeSet.add(0, 127);
            this.optimizeSet.add(192, 255);
            this.optimizeSet.remove(44032, 55203);
            this.dataBuilder.optimize(this.optimizeSet);
            tailoring.ensureOwnedData();
            if (this.fastLatinEnabled) {
                this.dataBuilder.enableFastLatin();
            }
            this.dataBuilder.build(tailoring.ownedData);
            this.dataBuilder = null;
        } else {
            tailoring.data = this.baseData;
        }
        ownedSettings.fastLatinOptions = CollationFastLatin.getOptions(tailoring.data, ownedSettings, ownedSettings.fastLatinPrimaries);
        tailoring.setRules(ruleString);
        tailoring.setVersion(this.base.version, 0);
        return tailoring;
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$addReset(int strength, CharSequence str) {
        if (!$assertionsDisabled && str.length() == 0) {
            throw new AssertionError();
        }
        if (str.charAt(0) == '\ufffe') {
            this.ces[0] = this.getSpecialResetPosition(str);
            this.cesLength = 1;
            if (!$assertionsDisabled && (this.ces[0] & 0xC0C0L) != 0L) {
                throw new AssertionError();
            }
        } else {
            String nfdString = this.nfd.normalize(str);
            this.cesLength = this.dataBuilder.getCEs(nfdString, this.ces, 0);
            if (this.cesLength > 31) {
                throw new IllegalArgumentException("reset position maps to too many collation elements (more than 31)");
            }
        }
        if (strength == 15) {
            return;
        }
        if (!($assertionsDisabled || 0 <= strength && strength <= 2)) {
            throw new AssertionError();
        }
        int index = this.findOrInsertNodeForCEs(strength);
        long node = this.nodes.elementAti(index);
        while (CollationBuilder.strengthFromNode(node) > strength) {
            index = CollationBuilder.previousIndexFromNode(node);
            node = this.nodes.elementAti(index);
        }
        if (CollationBuilder.strengthFromNode(node) == strength && CollationBuilder.isTailoredNode(node)) {
            index = CollationBuilder.previousIndexFromNode(node);
        } else if (strength == 0) {
            int nextIndex;
            long p = CollationBuilder.weight32FromNode(node);
            if (p == 0L) {
                throw new UnsupportedOperationException("reset primary-before ignorable not possible");
            }
            if (p <= this.rootElements.getFirstPrimary()) {
                throw new UnsupportedOperationException("reset primary-before first non-ignorable not supported");
            }
            if (p == 0xFF020200L) {
                throw new UnsupportedOperationException("reset primary-before [first trailing] not supported");
            }
            p = this.rootElements.getPrimaryBefore(p, this.baseData.isCompressiblePrimary(p));
            index = this.findOrInsertNodeForPrimary(p);
            while ((nextIndex = CollationBuilder.nextIndexFromNode(node = this.nodes.elementAti(index))) != 0) {
                index = nextIndex;
            }
        } else {
            index = this.findCommonNode(index, 1);
            if (strength >= 2) {
                index = this.findCommonNode(index, 2);
            }
            if (CollationBuilder.strengthFromNode(node = this.nodes.elementAti(index)) == strength) {
                int previousWeight16;
                int previousIndex;
                int weight16 = CollationBuilder.weight16FromNode(node);
                if (weight16 == 0) {
                    throw new UnsupportedOperationException(strength == 1 ? "reset secondary-before secondary ignorable not possible" : "reset tertiary-before completely ignorable not possible");
                }
                if (!$assertionsDisabled && weight16 <= 256) {
                    throw new AssertionError();
                }
                weight16 = this.getWeight16Before(index, node, strength);
                int i = previousIndex = CollationBuilder.previousIndexFromNode(node);
                while (true) {
                    int previousStrength;
                    if ((previousStrength = CollationBuilder.strengthFromNode(node = this.nodes.elementAti(i))) < strength) {
                        if (!$assertionsDisabled && weight16 < 1280 && i != previousIndex) {
                            throw new AssertionError();
                        }
                        previousWeight16 = 1280;
                        break;
                    }
                    if (previousStrength == strength && !CollationBuilder.isTailoredNode(node)) {
                        previousWeight16 = CollationBuilder.weight16FromNode(node);
                        break;
                    }
                    i = CollationBuilder.previousIndexFromNode(node);
                }
                if (previousWeight16 == weight16) {
                    index = previousIndex;
                } else {
                    node = CollationBuilder.nodeFromWeight16(weight16) | CollationBuilder.nodeFromStrength(strength);
                    index = this.insertNodeBetween(previousIndex, index, node);
                }
            } else {
                int weight16 = this.getWeight16Before(index, node, strength);
                index = this.findOrInsertWeakNode(index, weight16, strength);
            }
            strength = CollationBuilder.ceStrength(this.ces[this.cesLength - 1]);
        }
        this.ces[this.cesLength - 1] = CollationBuilder.tempCEFromIndexAndStrength(index, strength);
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$getWeight16Before(int index, long node, int level) {
        int weight16;
        if (!$assertionsDisabled && CollationBuilder.strengthFromNode(node) >= level && CollationBuilder.isTailoredNode(node)) {
            throw new AssertionError();
        }
        int t = CollationBuilder.strengthFromNode(node) == 2 ? CollationBuilder.weight16FromNode(node) : 1280;
        while (CollationBuilder.strengthFromNode(node) > 1) {
            index = CollationBuilder.previousIndexFromNode(node);
            node = this.nodes.elementAti(index);
        }
        if (CollationBuilder.isTailoredNode(node)) {
            return 256;
        }
        int s = CollationBuilder.strengthFromNode(node) == 1 ? CollationBuilder.weight16FromNode(node) : 1280;
        while (CollationBuilder.strengthFromNode(node) > 0) {
            index = CollationBuilder.previousIndexFromNode(node);
            node = this.nodes.elementAti(index);
        }
        if (CollationBuilder.isTailoredNode(node)) {
            return 256;
        }
        long p = CollationBuilder.weight32FromNode(node);
        if (level == 1) {
            weight16 = this.rootElements.getSecondaryBefore(p, s);
        } else {
            weight16 = this.rootElements.getTertiaryBefore(p, s, t);
            if (!$assertionsDisabled && (weight16 & 0xFFFFC0C0) != 0) {
                throw new AssertionError();
            }
        }
        return weight16;
    }

    private final long $$robo$$android_icu_impl_coll_CollationBuilder$getSpecialResetPosition(CharSequence str) {
        long node;
        int index;
        long ce;
        if (!$assertionsDisabled && str.length() != 2) {
            throw new AssertionError();
        }
        int strength = 0;
        boolean isBoundary = false;
        CollationRuleParser.Position pos = CollationRuleParser.POSITION_VALUES[str.charAt(1) - 10240];
        switch (1.$SwitchMap$android$icu$impl$coll$CollationRuleParser$Position[pos.ordinal()]) {
            case 1: {
                return 0L;
            }
            case 2: {
                return 0L;
            }
            case 3: {
                int index2 = this.findOrInsertNodeForRootCE(0L, 2);
                long node2 = this.nodes.elementAti(index2);
                index2 = CollationBuilder.nextIndexFromNode(node2);
                if (index2 != 0) {
                    node2 = this.nodes.elementAti(index2);
                    if (!$assertionsDisabled && CollationBuilder.strengthFromNode(node2) > 2) {
                        throw new AssertionError();
                    }
                    if (CollationBuilder.isTailoredNode(node2) && CollationBuilder.strengthFromNode(node2) == 2) {
                        return CollationBuilder.tempCEFromIndexAndStrength(index2, 2);
                    }
                }
                return this.rootElements.getFirstTertiaryCE();
            }
            case 4: {
                ce = this.rootElements.getLastTertiaryCE();
                strength = 2;
                break;
            }
            case 5: {
                index = this.findOrInsertNodeForRootCE(0L, 1);
                node = this.nodes.elementAti(index);
                while ((index = CollationBuilder.nextIndexFromNode(node)) != 0 && (strength = CollationBuilder.strengthFromNode(node = this.nodes.elementAti(index))) >= 1) {
                    if (strength != 1) continue;
                    if (!CollationBuilder.isTailoredNode(node)) break;
                    if (CollationBuilder.nodeHasBefore3(node)) {
                        index = CollationBuilder.nextIndexFromNode(this.nodes.elementAti(CollationBuilder.nextIndexFromNode(node)));
                        if (!$assertionsDisabled && !CollationBuilder.isTailoredNode(this.nodes.elementAti(index))) {
                            throw new AssertionError();
                        }
                    }
                    return CollationBuilder.tempCEFromIndexAndStrength(index, 1);
                }
                ce = this.rootElements.getFirstSecondaryCE();
                strength = 1;
                break;
            }
            case 6: {
                ce = this.rootElements.getLastSecondaryCE();
                strength = 1;
                break;
            }
            case 7: {
                ce = this.rootElements.getFirstPrimaryCE();
                isBoundary = true;
                break;
            }
            case 8: {
                ce = this.rootElements.lastCEWithPrimaryBefore(this.variableTop + 1L);
                break;
            }
            case 9: {
                ce = this.rootElements.firstCEWithPrimaryAtLeast(this.variableTop + 1L);
                isBoundary = true;
                break;
            }
            case 10: {
                ce = this.rootElements.firstCEWithPrimaryAtLeast(this.baseData.getFirstPrimaryForGroup(17));
                break;
            }
            case 11: {
                ce = this.baseData.getSingleCE(19968);
                break;
            }
            case 12: {
                throw new UnsupportedOperationException("reset to [last implicit] not supported");
            }
            case 13: {
                ce = Collation.makeCE(0xFF020200L);
                isBoundary = true;
                break;
            }
            case 14: {
                throw new IllegalArgumentException("LDML forbids tailoring to U+FFFF");
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return 0L;
            }
        }
        index = this.findOrInsertNodeForRootCE(ce, strength);
        node = this.nodes.elementAti(index);
        if ((pos.ordinal() & 1) == 0) {
            if (!CollationBuilder.nodeHasAnyBefore(node) && isBoundary) {
                index = CollationBuilder.nextIndexFromNode(node);
                if (index != 0) {
                    node = this.nodes.elementAti(index);
                    if (!$assertionsDisabled && !CollationBuilder.isTailoredNode(node)) {
                        throw new AssertionError();
                    }
                    ce = CollationBuilder.tempCEFromIndexAndStrength(index, strength);
                } else {
                    if (!$assertionsDisabled && strength != 0) {
                        throw new AssertionError();
                    }
                    long p = ce >>> 32;
                    int pIndex = this.rootElements.findPrimary(p);
                    boolean isCompressible = this.baseData.isCompressiblePrimary(p);
                    p = this.rootElements.getPrimaryAfter(p, pIndex, isCompressible);
                    ce = Collation.makeCE(p);
                    index = this.findOrInsertNodeForRootCE(ce, 0);
                    node = this.nodes.elementAti(index);
                }
            }
            if (CollationBuilder.nodeHasAnyBefore(node)) {
                if (CollationBuilder.nodeHasBefore2(node)) {
                    index = CollationBuilder.nextIndexFromNode(this.nodes.elementAti(CollationBuilder.nextIndexFromNode(node)));
                    node = this.nodes.elementAti(index);
                }
                if (CollationBuilder.nodeHasBefore3(node)) {
                    index = CollationBuilder.nextIndexFromNode(this.nodes.elementAti(CollationBuilder.nextIndexFromNode(node)));
                }
                if (!$assertionsDisabled && !CollationBuilder.isTailoredNode(this.nodes.elementAti(index))) {
                    throw new AssertionError();
                }
                ce = CollationBuilder.tempCEFromIndexAndStrength(index, strength);
            }
        } else {
            long nextNode;
            int nextIndex;
            while ((nextIndex = CollationBuilder.nextIndexFromNode(node)) != 0 && CollationBuilder.strengthFromNode(nextNode = this.nodes.elementAti(nextIndex)) >= strength) {
                index = nextIndex;
                node = nextNode;
            }
            if (CollationBuilder.isTailoredNode(node)) {
                ce = CollationBuilder.tempCEFromIndexAndStrength(index, strength);
            }
        }
        return ce;
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$addRelation(int strength, CharSequence prefix, CharSequence str, CharSequence extension) {
        String nfdPrefix = prefix.length() == 0 ? "" : this.nfd.normalize(prefix);
        String nfdString = this.nfd.normalize(str);
        int nfdLength = nfdString.length();
        if (nfdLength >= 2) {
            char c = nfdString.charAt(0);
            if (Normalizer2Impl.Hangul.isJamoL(c) || Normalizer2Impl.Hangul.isJamoV(c)) {
                throw new UnsupportedOperationException("contractions starting with conjoining Jamo L or V not supported");
            }
            c = nfdString.charAt(nfdLength - 1);
            if (Normalizer2Impl.Hangul.isJamoL(c) || Normalizer2Impl.Hangul.isJamoV(c) && Normalizer2Impl.Hangul.isJamoL(nfdString.charAt(nfdLength - 2))) {
                throw new UnsupportedOperationException("contractions ending with conjoining Jamo L or L+V not supported");
            }
        }
        if (strength != 15) {
            int index = this.findOrInsertNodeForCEs(strength);
            if (!$assertionsDisabled && this.cesLength <= 0) {
                throw new AssertionError();
            }
            long ce = this.ces[this.cesLength - 1];
            if (strength == 0 && !CollationBuilder.isTempCE(ce) && ce >>> 32 == 0L) {
                throw new UnsupportedOperationException("tailoring primary after ignorables not supported");
            }
            if (strength == 3 && ce == 0L) {
                throw new UnsupportedOperationException("tailoring quaternary after tertiary ignorables not supported");
            }
            index = this.insertTailoredNodeAfter(index, strength);
            int tempStrength = CollationBuilder.ceStrength(ce);
            if (strength < tempStrength) {
                tempStrength = strength;
            }
            this.ces[this.cesLength - 1] = CollationBuilder.tempCEFromIndexAndStrength(index, tempStrength);
        }
        this.setCaseBits(nfdString);
        int cesLengthBeforeExtension = this.cesLength;
        if (extension.length() != 0) {
            String nfdExtension = this.nfd.normalize(extension);
            this.cesLength = this.dataBuilder.getCEs(nfdExtension, this.ces, this.cesLength);
            if (this.cesLength > 31) {
                throw new IllegalArgumentException("extension string adds too many collation elements (more than 31 total)");
            }
        }
        int ce32 = -1;
        if (!(nfdPrefix.contentEquals(prefix) && nfdString.contentEquals(str) || this.ignorePrefix(prefix) || this.ignoreString(str))) {
            ce32 = this.addIfDifferent(prefix, str, this.ces, this.cesLength, ce32);
        }
        this.addWithClosure(nfdPrefix, nfdString, this.ces, this.cesLength, ce32);
        this.cesLength = cesLengthBeforeExtension;
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$findOrInsertNodeForCEs(int strength) {
        long ce;
        if (!($assertionsDisabled || 0 <= strength && strength <= 3)) {
            throw new AssertionError();
        }
        while (true) {
            if (this.cesLength == 0) {
                this.ces[0] = 0L;
                ce = 0L;
                this.cesLength = 1;
                break;
            }
            ce = this.ces[this.cesLength - 1];
            if (CollationBuilder.ceStrength(ce) <= strength) break;
            --this.cesLength;
        }
        if (CollationBuilder.isTempCE(ce)) {
            return CollationBuilder.indexFromTempCE(ce);
        }
        if ((int)(ce >>> 56) == 254) {
            throw new UnsupportedOperationException("tailoring relative to an unassigned code point not supported");
        }
        return this.findOrInsertNodeForRootCE(ce, strength);
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$findOrInsertNodeForRootCE(long ce, int strength) {
        if (!$assertionsDisabled && (int)(ce >>> 56) == 254) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (ce & 0xC0L) != 0L) {
            throw new AssertionError();
        }
        int index = this.findOrInsertNodeForPrimary(ce >>> 32);
        if (strength >= 1) {
            int lower32 = (int)ce;
            index = this.findOrInsertWeakNode(index, lower32 >>> 16, 1);
            if (strength >= 2) {
                index = this.findOrInsertWeakNode(index, lower32 & 0x3F3F, 2);
            }
        }
        return index;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$binarySearchForRootPrimaryNode(int[] rootPrimaryIndexes, int length, long[] nodes, long p) {
        if (length == 0) {
            return -1;
        }
        int start = 0;
        int limit = length;
        int i;
        long node;
        long nodePrimary;
        while (p != (nodePrimary = (node = nodes[rootPrimaryIndexes[i = (int)(((long)start + (long)limit) / 2L)]]) >>> 32)) {
            if (p < nodePrimary) {
                if (i == start) {
                    return ~start;
                }
                limit = i;
                continue;
            }
            if (i == start) {
                return ~(start + 1);
            }
            start = i;
        }
        return i;
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$findOrInsertNodeForPrimary(long p) {
        int rootIndex = CollationBuilder.binarySearchForRootPrimaryNode(this.rootPrimaryIndexes.getBuffer(), this.rootPrimaryIndexes.size(), this.nodes.getBuffer(), p);
        if (rootIndex >= 0) {
            return this.rootPrimaryIndexes.elementAti(rootIndex);
        }
        int index = this.nodes.size();
        this.nodes.addElement(CollationBuilder.nodeFromWeight32(p));
        this.rootPrimaryIndexes.insertElementAt(index, ~rootIndex);
        return index;
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$findOrInsertWeakNode(int index, int weight16, int level) {
        int nextIndex;
        if (!($assertionsDisabled || 0 <= index && index < this.nodes.size())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 1 <= level && level <= 2)) {
            throw new AssertionError();
        }
        if (weight16 == 1280) {
            return this.findCommonNode(index, level);
        }
        long node = this.nodes.elementAti(index);
        if (!$assertionsDisabled && CollationBuilder.strengthFromNode(node) >= level) {
            throw new AssertionError();
        }
        if (weight16 != 0 && weight16 < 1280) {
            int hasThisLevelBefore;
            int n = hasThisLevelBefore = level == 1 ? 64 : 32;
            if ((node & (long)hasThisLevelBefore) == 0L) {
                long commonNode = CollationBuilder.nodeFromWeight16(1280) | CollationBuilder.nodeFromStrength(level);
                if (level == 1) {
                    commonNode |= node & 0x20L;
                    node &= 0xFFFFFFFFFFFFFFDFL;
                }
                this.nodes.setElementAt(node | (long)hasThisLevelBefore, index);
                int nextIndex2 = CollationBuilder.nextIndexFromNode(node);
                node = CollationBuilder.nodeFromWeight16(weight16) | CollationBuilder.nodeFromStrength(level);
                index = this.insertNodeBetween(index, nextIndex2, node);
                this.insertNodeBetween(index, nextIndex2, commonNode);
                return index;
            }
        }
        while ((nextIndex = CollationBuilder.nextIndexFromNode(node)) != 0) {
            node = this.nodes.elementAti(nextIndex);
            int nextStrength = CollationBuilder.strengthFromNode(node);
            if (nextStrength <= level) {
                if (nextStrength < level) break;
                if (!CollationBuilder.isTailoredNode(node)) {
                    int nextWeight16 = CollationBuilder.weight16FromNode(node);
                    if (nextWeight16 == weight16) {
                        return nextIndex;
                    }
                    if (nextWeight16 > weight16) break;
                }
            }
            index = nextIndex;
        }
        node = CollationBuilder.nodeFromWeight16(weight16) | CollationBuilder.nodeFromStrength(level);
        return this.insertNodeBetween(index, nextIndex, node);
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$insertTailoredNodeAfter(int index, int strength) {
        int nextIndex;
        if (!($assertionsDisabled || 0 <= index && index < this.nodes.size())) {
            throw new AssertionError();
        }
        if (strength >= 1) {
            index = this.findCommonNode(index, 1);
            if (strength >= 2) {
                index = this.findCommonNode(index, 2);
            }
        }
        long node = this.nodes.elementAti(index);
        while ((nextIndex = CollationBuilder.nextIndexFromNode(node)) != 0 && CollationBuilder.strengthFromNode(node = this.nodes.elementAti(nextIndex)) > strength) {
            index = nextIndex;
        }
        node = 8L | CollationBuilder.nodeFromStrength(strength);
        return this.insertNodeBetween(index, nextIndex, node);
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$insertNodeBetween(int index, int nextIndex, long node) {
        if (!$assertionsDisabled && CollationBuilder.previousIndexFromNode(node) != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && CollationBuilder.nextIndexFromNode(node) != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && CollationBuilder.nextIndexFromNode(this.nodes.elementAti(index)) != nextIndex) {
            throw new AssertionError();
        }
        int newIndex = this.nodes.size();
        this.nodes.addElement(node |= CollationBuilder.nodeFromPreviousIndex(index) | CollationBuilder.nodeFromNextIndex(nextIndex));
        node = this.nodes.elementAti(index);
        this.nodes.setElementAt(CollationBuilder.changeNodeNextIndex(node, newIndex), index);
        if (nextIndex != 0) {
            node = this.nodes.elementAti(nextIndex);
            this.nodes.setElementAt(CollationBuilder.changeNodePreviousIndex(node, newIndex), nextIndex);
        }
        return newIndex;
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$findCommonNode(int index, int strength) {
        if (!($assertionsDisabled || 1 <= strength && strength <= 2)) {
            throw new AssertionError();
        }
        long node = this.nodes.elementAti(index);
        if (CollationBuilder.strengthFromNode(node) >= strength) {
            return index;
        }
        if (strength == 1 ? !CollationBuilder.nodeHasBefore2(node) : !CollationBuilder.nodeHasBefore3(node)) {
            return index;
        }
        index = CollationBuilder.nextIndexFromNode(node);
        node = this.nodes.elementAti(index);
        if (!$assertionsDisabled && (CollationBuilder.isTailoredNode(node) || CollationBuilder.strengthFromNode(node) != strength || CollationBuilder.weight16FromNode(node) >= 1280)) {
            throw new AssertionError();
        }
        do {
            index = CollationBuilder.nextIndexFromNode(node);
            node = this.nodes.elementAti(index);
            if (!$assertionsDisabled && CollationBuilder.strengthFromNode(node) < strength) {
                throw new AssertionError();
            }
        } while (CollationBuilder.isTailoredNode(node) || CollationBuilder.strengthFromNode(node) > strength || CollationBuilder.weight16FromNode(node) < 1280);
        if (!$assertionsDisabled && CollationBuilder.weight16FromNode(node) != 1280) {
            throw new AssertionError();
        }
        return index;
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$setCaseBits(CharSequence nfdString) {
        int numTailoredPrimaries = 0;
        for (int i = 0; i < this.cesLength; ++i) {
            if (CollationBuilder.ceStrength(this.ces[i]) != 0) continue;
            ++numTailoredPrimaries;
        }
        if (!$assertionsDisabled && numTailoredPrimaries > 31) {
            throw new AssertionError();
        }
        long cases = 0L;
        if (numTailoredPrimaries > 0) {
            CharSequence s = nfdString;
            UTF16CollationIterator baseCEs = new UTF16CollationIterator(this.baseData, false, s, 0);
            int baseCEsLength = baseCEs.fetchCEs() - 1;
            if (!($assertionsDisabled || baseCEsLength >= 0 && baseCEs.getCE(baseCEsLength) == 0x101000100L)) {
                throw new AssertionError();
            }
            int lastCase = 0;
            int numBasePrimaries = 0;
            for (int i = 0; i < baseCEsLength; ++i) {
                long ce = baseCEs.getCE(i);
                if (ce >>> 32 == 0L) continue;
                ++numBasePrimaries;
                int c = (int)ce >> 14 & 3;
                if (!$assertionsDisabled && c != 0 && c != 2) {
                    throw new AssertionError();
                }
                if (numBasePrimaries < numTailoredPrimaries) {
                    cases |= (long)c << (numBasePrimaries - 1) * 2;
                    continue;
                }
                if (numBasePrimaries == numTailoredPrimaries) {
                    lastCase = c;
                    continue;
                }
                if (c == lastCase) continue;
                lastCase = 1;
                break;
            }
            if (numBasePrimaries >= numTailoredPrimaries) {
                cases |= (long)lastCase << (numTailoredPrimaries - 1) * 2;
            }
        }
        for (int i = 0; i < this.cesLength; ++i) {
            long ce = this.ces[i] & 0xFFFFFFFFFFFF3FFFL;
            int strength = CollationBuilder.ceStrength(ce);
            if (strength == 0) {
                ce |= (cases & 3L) << 14;
                cases >>>= 2;
            } else if (strength == 2) {
                ce |= 0x8000L;
            }
            this.ces[i] = ce;
        }
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$suppressContractions(UnicodeSet set) {
        this.dataBuilder.suppressContractions(set);
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$optimize(UnicodeSet set) {
        this.optimizeSet.addAll(set);
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$addWithClosure(CharSequence nfdPrefix, CharSequence nfdString, long[] newCEs, int newCEsLength, int ce32) {
        ce32 = this.addIfDifferent(nfdPrefix, nfdString, newCEs, newCEsLength, ce32);
        ce32 = this.addOnlyClosure(nfdPrefix, nfdString, newCEs, newCEsLength, ce32);
        this.addTailComposites(nfdPrefix, nfdString);
        return ce32;
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$addOnlyClosure(CharSequence nfdPrefix, CharSequence nfdString, long[] newCEs, int newCEsLength, int ce32) {
        if (nfdPrefix.length() == 0) {
            String str;
            CanonicalIterator stringIter = new CanonicalIterator(nfdString.toString());
            String prefix = "";
            while ((str = stringIter.next()) != null) {
                if (this.ignoreString(str) || str.contentEquals(nfdString)) continue;
                ce32 = this.addIfDifferent(prefix, str, newCEs, newCEsLength, ce32);
            }
        } else {
            String prefix;
            CanonicalIterator prefixIter = new CanonicalIterator(nfdPrefix.toString());
            CanonicalIterator stringIter = new CanonicalIterator(nfdString.toString());
            while ((prefix = prefixIter.next()) != null) {
                String str;
                if (this.ignorePrefix(prefix)) continue;
                boolean samePrefix = prefix.contentEquals(nfdPrefix);
                while ((str = stringIter.next()) != null) {
                    if (this.ignoreString(str) || samePrefix && str.contentEquals(nfdString)) continue;
                    ce32 = this.addIfDifferent(prefix, str, newCEs, newCEsLength, ce32);
                }
                stringIter.reset();
            }
        }
        return ce32;
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$addTailComposites(CharSequence nfdPrefix, CharSequence nfdString) {
        int lastStarter;
        int indexAfterLastStarter = nfdString.length();
        while (true) {
            if (indexAfterLastStarter == 0) {
                return;
            }
            lastStarter = Character.codePointBefore(nfdString, indexAfterLastStarter);
            if (this.nfd.getCombiningClass(lastStarter) == 0) break;
            indexAfterLastStarter -= Character.charCount(lastStarter);
        }
        if (Normalizer2Impl.Hangul.isJamoL(lastStarter)) {
            return;
        }
        UnicodeSet composites = new UnicodeSet();
        if (!this.nfcImpl.getCanonStartSet(lastStarter, composites)) {
            return;
        }
        StringBuilder newNFDString = new StringBuilder();
        StringBuilder newString = new StringBuilder();
        long[] newCEs = new long[31];
        UnicodeSetIterator iter = new UnicodeSetIterator(composites);
        while (iter.next()) {
            int ce32;
            int newCEsLength;
            if (!$assertionsDisabled && iter.codepoint == UnicodeSetIterator.IS_STRING) {
                throw new AssertionError();
            }
            int composite = iter.codepoint;
            String decomp = this.nfd.getDecomposition(composite);
            if (!this.mergeCompositeIntoString(nfdString, indexAfterLastStarter, composite, decomp, newNFDString, newString) || (newCEsLength = this.dataBuilder.getCEs(nfdPrefix, newNFDString, newCEs, 0)) > 31 || (ce32 = this.addIfDifferent(nfdPrefix, newString, newCEs, newCEsLength, -1)) == -1) continue;
            this.addOnlyClosure(nfdPrefix, newNFDString, newCEs, newCEsLength, ce32);
        }
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationBuilder$mergeCompositeIntoString(CharSequence nfdString, int indexAfterLastStarter, int composite, CharSequence decomp, StringBuilder newNFDString, StringBuilder newString) {
        if (!$assertionsDisabled && Character.codePointBefore(nfdString, indexAfterLastStarter) != Character.codePointAt(decomp, 0)) {
            throw new AssertionError();
        }
        int lastStarterLength = Character.offsetByCodePoints(decomp, 0, 1);
        if (lastStarterLength == decomp.length()) {
            return false;
        }
        if (this.equalSubSequences(nfdString, indexAfterLastStarter, decomp, lastStarterLength)) {
            return false;
        }
        newNFDString.setLength(0);
        newNFDString.append(nfdString, 0, indexAfterLastStarter);
        newString.setLength(0);
        newString.append(nfdString, 0, indexAfterLastStarter - lastStarterLength).appendCodePoint(composite);
        int sourceIndex = indexAfterLastStarter;
        int decompIndex = lastStarterLength;
        int sourceChar = -1;
        int sourceCC = 0;
        int decompCC = 0;
        while (true) {
            if (sourceChar < 0) {
                if (sourceIndex >= nfdString.length()) break;
                sourceChar = Character.codePointAt(nfdString, sourceIndex);
                sourceCC = this.nfd.getCombiningClass(sourceChar);
                if (!$assertionsDisabled && sourceCC == 0) {
                    throw new AssertionError();
                }
            }
            if (decompIndex >= decomp.length()) break;
            int decompChar = Character.codePointAt(decomp, decompIndex);
            decompCC = this.nfd.getCombiningClass(decompChar);
            if (decompCC == 0) {
                return false;
            }
            if (sourceCC < decompCC) {
                return false;
            }
            if (decompCC < sourceCC) {
                newNFDString.appendCodePoint(decompChar);
                decompIndex += Character.charCount(decompChar);
                continue;
            }
            if (decompChar != sourceChar) {
                return false;
            }
            newNFDString.appendCodePoint(decompChar);
            decompIndex += Character.charCount(decompChar);
            sourceIndex += Character.charCount(decompChar);
            sourceChar = -1;
        }
        if (sourceChar >= 0) {
            if (sourceCC < decompCC) {
                return false;
            }
            newNFDString.append(nfdString, sourceIndex, nfdString.length());
            newString.append(nfdString, sourceIndex, nfdString.length());
        } else if (decompIndex < decomp.length()) {
            newNFDString.append(decomp, decompIndex, decomp.length());
        }
        if (!$assertionsDisabled && !this.nfd.isNormalized(newNFDString)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.fcd.isNormalized(newString)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.nfd.normalize(newString).equals(newNFDString.toString())) {
            throw new AssertionError();
        }
        return true;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationBuilder$equalSubSequences(CharSequence left, int leftStart, CharSequence right, int rightStart) {
        int leftLength = left.length();
        if (leftLength - leftStart != right.length() - rightStart) {
            return false;
        }
        while (leftStart < leftLength) {
            if (left.charAt(leftStart++) == right.charAt(rightStart++)) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationBuilder$ignorePrefix(CharSequence s) {
        return !this.isFCD(s);
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationBuilder$ignoreString(CharSequence s) {
        return !this.isFCD(s) || Normalizer2Impl.Hangul.isHangul(s.charAt(0));
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationBuilder$isFCD(CharSequence s) {
        return this.fcd.isNormalized(s);
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$closeOverComposites() {
        String prefix = "";
        UnicodeSetIterator iter = new UnicodeSetIterator(COMPOSITES);
        while (iter.next()) {
            if (!$assertionsDisabled && iter.codepoint == UnicodeSetIterator.IS_STRING) {
                throw new AssertionError();
            }
            String nfdString = this.nfd.getDecomposition(iter.codepoint);
            this.cesLength = this.dataBuilder.getCEs(nfdString, this.ces, 0);
            if (this.cesLength > 31) continue;
            String composite = iter.getString();
            this.addIfDifferent(prefix, composite, this.ces, this.cesLength, -1);
        }
    }

    private final int $$robo$$android_icu_impl_coll_CollationBuilder$addIfDifferent(CharSequence prefix, CharSequence str, long[] newCEs, int newCEsLength, int ce32) {
        long[] oldCEs = new long[31];
        int oldCEsLength = this.dataBuilder.getCEs(prefix, str, oldCEs, 0);
        if (!CollationBuilder.sameCEs(newCEs, newCEsLength, oldCEs, oldCEsLength)) {
            if (ce32 == -1) {
                ce32 = this.dataBuilder.encodeCEs(newCEs, newCEsLength);
            }
            this.dataBuilder.addCE32(prefix, str, ce32);
        }
        return ce32;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationBuilder$sameCEs(long[] ces1, int ces1Length, long[] ces2, int ces2Length) {
        if (ces1Length != ces2Length) {
            return false;
        }
        if (!$assertionsDisabled && ces1Length > 31) {
            throw new AssertionError();
        }
        for (int i = 0; i < ces1Length; ++i) {
            if (ces1[i] == ces2[i]) continue;
            return false;
        }
        return true;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$alignWeightRight(int w) {
        if (w != 0) {
            while ((w & 0xFF) == 0) {
                w >>>= 8;
            }
        }
        return w;
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$makeTailoredCEs() {
        CollationWeights primaries = new CollationWeights();
        CollationWeights secondaries = new CollationWeights();
        CollationWeights tertiaries = new CollationWeights();
        long[] nodesArray = this.nodes.getBuffer();
        for (int rpi = 0; rpi < this.rootPrimaryIndexes.size(); ++rpi) {
            int s;
            int i = this.rootPrimaryIndexes.elementAti(rpi);
            long node = nodesArray[i];
            long p = CollationBuilder.weight32FromNode(node);
            int t = s = p == 0L ? 0 : 1280;
            int q = 0;
            boolean pIsTailored = false;
            boolean sIsTailored = false;
            boolean tIsTailored = false;
            int pIndex = p == 0L ? 0 : this.rootElements.findPrimary(p);
            int nextIndex = CollationBuilder.nextIndexFromNode(node);
            while (nextIndex != 0) {
                i = nextIndex;
                node = nodesArray[i];
                nextIndex = CollationBuilder.nextIndexFromNode(node);
                int strength = CollationBuilder.strengthFromNode(node);
                if (strength == 3) {
                    if (!$assertionsDisabled && !CollationBuilder.isTailoredNode(node)) {
                        throw new AssertionError();
                    }
                    if (q == 3) {
                        throw new UnsupportedOperationException("quaternary tailoring gap too small");
                    }
                    ++q;
                } else {
                    if (strength == 2) {
                        if (CollationBuilder.isTailoredNode(node)) {
                            if (!tIsTailored) {
                                int tLimit;
                                int tCount = CollationBuilder.countTailoredNodes(nodesArray, nextIndex, 2) + 1;
                                if (t == 0) {
                                    t = this.rootElements.getTertiaryBoundary() - 256;
                                    tLimit = (int)this.rootElements.getFirstTertiaryCE() & 0x3F3F;
                                } else if (!pIsTailored && !sIsTailored) {
                                    tLimit = this.rootElements.getTertiaryAfter(pIndex, s, t);
                                } else if (t == 256) {
                                    tLimit = 1280;
                                } else {
                                    if (!$assertionsDisabled && t != 1280) {
                                        throw new AssertionError();
                                    }
                                    tLimit = this.rootElements.getTertiaryBoundary();
                                }
                                if (!$assertionsDisabled && tLimit != 16384 && (tLimit & 0xFFFFC0C0) != 0) {
                                    throw new AssertionError();
                                }
                                tertiaries.initForTertiary();
                                if (!tertiaries.allocWeights(t, tLimit, tCount)) {
                                    throw new UnsupportedOperationException("tertiary tailoring gap too small");
                                }
                                tIsTailored = true;
                            }
                            t = (int)tertiaries.nextWeight();
                            if (!$assertionsDisabled && t == -1) {
                                throw new AssertionError();
                            }
                        } else {
                            t = CollationBuilder.weight16FromNode(node);
                            tIsTailored = false;
                        }
                    } else {
                        if (strength == 1) {
                            if (CollationBuilder.isTailoredNode(node)) {
                                if (!sIsTailored) {
                                    int sLimit;
                                    int sCount = CollationBuilder.countTailoredNodes(nodesArray, nextIndex, 1) + 1;
                                    if (s == 0) {
                                        s = this.rootElements.getSecondaryBoundary() - 256;
                                        sLimit = (int)(this.rootElements.getFirstSecondaryCE() >> 16);
                                    } else if (!pIsTailored) {
                                        sLimit = this.rootElements.getSecondaryAfter(pIndex, s);
                                    } else if (s == 256) {
                                        sLimit = 1280;
                                    } else {
                                        if (!$assertionsDisabled && s != 1280) {
                                            throw new AssertionError();
                                        }
                                        sLimit = this.rootElements.getSecondaryBoundary();
                                    }
                                    if (s == 1280) {
                                        s = this.rootElements.getLastCommonSecondary();
                                    }
                                    secondaries.initForSecondary();
                                    if (!secondaries.allocWeights(s, sLimit, sCount)) {
                                        throw new UnsupportedOperationException("secondary tailoring gap too small");
                                    }
                                    sIsTailored = true;
                                }
                                s = (int)secondaries.nextWeight();
                                if (!$assertionsDisabled && s == -1) {
                                    throw new AssertionError();
                                }
                            } else {
                                s = CollationBuilder.weight16FromNode(node);
                                sIsTailored = false;
                            }
                        } else {
                            if (!$assertionsDisabled && !CollationBuilder.isTailoredNode(node)) {
                                throw new AssertionError();
                            }
                            if (!pIsTailored) {
                                int pCount = CollationBuilder.countTailoredNodes(nodesArray, nextIndex, 0) + 1;
                                boolean isCompressible = this.baseData.isCompressiblePrimary(p);
                                long pLimit = this.rootElements.getPrimaryAfter(p, pIndex, isCompressible);
                                primaries.initForPrimary(isCompressible);
                                if (!primaries.allocWeights(p, pLimit, pCount)) {
                                    throw new UnsupportedOperationException("primary tailoring gap too small");
                                }
                                pIsTailored = true;
                            }
                            p = primaries.nextWeight();
                            if (!$assertionsDisabled && p == 0xFFFFFFFFL) {
                                throw new AssertionError();
                            }
                            s = 1280;
                            sIsTailored = false;
                        }
                        t = s == 0 ? 0 : 1280;
                        tIsTailored = false;
                    }
                    q = 0;
                }
                if (!CollationBuilder.isTailoredNode(node)) continue;
                nodesArray[i] = Collation.makeCE(p, s, t, q);
            }
        }
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$countTailoredNodes(long[] nodesArray, int i, int strength) {
        long node;
        int count = 0;
        while (i != 0 && CollationBuilder.strengthFromNode(node = nodesArray[i]) >= strength) {
            if (CollationBuilder.strengthFromNode(node) == strength) {
                if (!CollationBuilder.isTailoredNode(node)) break;
                ++count;
            }
            i = CollationBuilder.nextIndexFromNode(node);
        }
        return count;
    }

    private final void $$robo$$android_icu_impl_coll_CollationBuilder$finalizeCEs() {
        CollationDataBuilder newBuilder = new CollationDataBuilder();
        newBuilder.initForTailoring(this.baseData);
        CEFinalizer finalizer = new CEFinalizer(this.nodes.getBuffer());
        newBuilder.copyFrom(this.dataBuilder, finalizer);
        this.dataBuilder = newBuilder;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$tempCEFromIndexAndStrength(int index, int strength) {
        return 4629700417037541376L + ((long)(index & 0xFE000) << 43) + ((long)(index & 0x1FC0) << 42) + (long)((index & 0x3F) << 24) + (long)(strength << 8);
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$indexFromTempCE(long tempCE) {
        return (int)((tempCE -= 4629700417037541376L) >> 43) & 0xFE000 | (int)(tempCE >> 42) & 0x1FC0 | (int)(tempCE >> 24) & 0x3F;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$strengthFromTempCE(long tempCE) {
        return (int)tempCE >> 8 & 3;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationBuilder$isTempCE(long ce) {
        int sec = (int)ce >>> 24;
        return 6 <= sec && sec <= 69;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$indexFromTempCE32(int tempCE32) {
        return (tempCE32 -= 1077937696) >> 11 & 0xFE000 | tempCE32 >> 10 & 0x1FC0 | tempCE32 >> 8 & 0x3F;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationBuilder$isTempCE32(int ce32) {
        return (ce32 & 0xFF) >= 2 && 6 <= (ce32 >> 8 & 0xFF) && (ce32 >> 8 & 0xFF) <= 69;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$ceStrength(long ce) {
        return CollationBuilder.isTempCE(ce) ? CollationBuilder.strengthFromTempCE(ce) : ((ce & 0xFF00000000000000L) != 0L ? 0 : (((int)ce & 0xFF000000) != 0 ? 1 : (ce != 0L ? 2 : 15)));
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromWeight32(long weight32) {
        return weight32 << 32;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromWeight16(int weight16) {
        return (long)weight16 << 48;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromPreviousIndex(int previous) {
        return (long)previous << 28;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromNextIndex(int next) {
        return next << 8;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromStrength(int strength) {
        return strength;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$weight32FromNode(long node) {
        return node >>> 32;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$weight16FromNode(long node) {
        return (int)(node >> 48) & 0xFFFF;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$previousIndexFromNode(long node) {
        return (int)(node >> 28) & 0xFFFFF;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$nextIndexFromNode(long node) {
        return (int)node >> 8 & 0xFFFFF;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationBuilder$strengthFromNode(long node) {
        return (int)node & 3;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationBuilder$nodeHasBefore2(long node) {
        return (node & 0x40L) != 0L;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationBuilder$nodeHasBefore3(long node) {
        return (node & 0x20L) != 0L;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationBuilder$nodeHasAnyBefore(long node) {
        return (node & 0x60L) != 0L;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationBuilder$isTailoredNode(long node) {
        return (node & 8L) != 0L;
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$changeNodePreviousIndex(long node, int previous) {
        return node & 0xFFFF00000FFFFFFFL | CollationBuilder.nodeFromPreviousIndex(previous);
    }

    private static final long $$robo$$android_icu_impl_coll_CollationBuilder$changeNodeNextIndex(long node, int next) {
        return node & 0xFFFFFFFFF00000FFL | CollationBuilder.nodeFromNextIndex(next);
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CollationBuilder.class.desiredAssertionStatus();
        COMPOSITES = new UnicodeSet("[:NFD_QC=N:]");
        COMPOSITES.remove(44032, 55203);
    }

    private void __constructor__(CollationTailoring collationTailoring) {
        this.$$robo$$android_icu_impl_coll_CollationBuilder$__constructor__(collationTailoring);
    }

    public CollationBuilder(CollationTailoring collationTailoring) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationBuilder$__constructor__(android.icu.impl.coll.CollationTailoring ), this, collationTailoring);
    }

    public CollationTailoring parseAndBuild(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parseAndBuild", $$robo$$android_icu_impl_coll_CollationBuilder$parseAndBuild(java.lang.String ), this, string2);
    }

    @Override
    void addReset(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("addReset", $$robo$$android_icu_impl_coll_CollationBuilder$addReset(int java.lang.CharSequence ), this, n, charSequence);
    }

    private int getWeight16Before(int n, long l, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getWeight16Before", $$robo$$android_icu_impl_coll_CollationBuilder$getWeight16Before(int long int ), this, n, l, n2);
    }

    private long getSpecialResetPosition(CharSequence charSequence) {
        return (long)InvokeDynamicSupport.bootstrap("getSpecialResetPosition", $$robo$$android_icu_impl_coll_CollationBuilder$getSpecialResetPosition(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    void addRelation(int n, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        InvokeDynamicSupport.bootstrap("addRelation", $$robo$$android_icu_impl_coll_CollationBuilder$addRelation(int java.lang.CharSequence java.lang.CharSequence java.lang.CharSequence ), this, n, charSequence, charSequence2, charSequence3);
    }

    private int findOrInsertNodeForCEs(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findOrInsertNodeForCEs", $$robo$$android_icu_impl_coll_CollationBuilder$findOrInsertNodeForCEs(int ), this, n);
    }

    private int findOrInsertNodeForRootCE(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrap("findOrInsertNodeForRootCE", $$robo$$android_icu_impl_coll_CollationBuilder$findOrInsertNodeForRootCE(long int ), this, l, n);
    }

    private static int binarySearchForRootPrimaryNode(int[] nArray, int n, long[] lArray, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("binarySearchForRootPrimaryNode", $$robo$$android_icu_impl_coll_CollationBuilder$binarySearchForRootPrimaryNode(int[] int long[] long ), (int[])nArray, (int)n, (long[])lArray, (long)l);
    }

    private int findOrInsertNodeForPrimary(long l) {
        return (int)InvokeDynamicSupport.bootstrap("findOrInsertNodeForPrimary", $$robo$$android_icu_impl_coll_CollationBuilder$findOrInsertNodeForPrimary(long ), this, l);
    }

    private int findOrInsertWeakNode(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("findOrInsertWeakNode", $$robo$$android_icu_impl_coll_CollationBuilder$findOrInsertWeakNode(int int int ), this, n, n2, n3);
    }

    private int insertTailoredNodeAfter(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("insertTailoredNodeAfter", $$robo$$android_icu_impl_coll_CollationBuilder$insertTailoredNodeAfter(int int ), this, n, n2);
    }

    private int insertNodeBetween(int n, int n2, long l) {
        return (int)InvokeDynamicSupport.bootstrap("insertNodeBetween", $$robo$$android_icu_impl_coll_CollationBuilder$insertNodeBetween(int int long ), this, n, n2, l);
    }

    private int findCommonNode(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("findCommonNode", $$robo$$android_icu_impl_coll_CollationBuilder$findCommonNode(int int ), this, n, n2);
    }

    private void setCaseBits(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setCaseBits", $$robo$$android_icu_impl_coll_CollationBuilder$setCaseBits(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    void suppressContractions(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("suppressContractions", $$robo$$android_icu_impl_coll_CollationBuilder$suppressContractions(android.icu.text.UnicodeSet ), this, unicodeSet);
    }

    @Override
    void optimize(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("optimize", $$robo$$android_icu_impl_coll_CollationBuilder$optimize(android.icu.text.UnicodeSet ), this, unicodeSet);
    }

    private int addWithClosure(CharSequence charSequence, CharSequence charSequence2, long[] lArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("addWithClosure", $$robo$$android_icu_impl_coll_CollationBuilder$addWithClosure(java.lang.CharSequence java.lang.CharSequence long[] int int ), this, charSequence, charSequence2, lArray, n, n2);
    }

    private int addOnlyClosure(CharSequence charSequence, CharSequence charSequence2, long[] lArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("addOnlyClosure", $$robo$$android_icu_impl_coll_CollationBuilder$addOnlyClosure(java.lang.CharSequence java.lang.CharSequence long[] int int ), this, charSequence, charSequence2, lArray, n, n2);
    }

    private void addTailComposites(CharSequence charSequence, CharSequence charSequence2) {
        InvokeDynamicSupport.bootstrap("addTailComposites", $$robo$$android_icu_impl_coll_CollationBuilder$addTailComposites(java.lang.CharSequence java.lang.CharSequence ), this, charSequence, charSequence2);
    }

    private boolean mergeCompositeIntoString(CharSequence charSequence, int n, int n2, CharSequence charSequence2, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        return (boolean)InvokeDynamicSupport.bootstrap("mergeCompositeIntoString", $$robo$$android_icu_impl_coll_CollationBuilder$mergeCompositeIntoString(java.lang.CharSequence int int java.lang.CharSequence java.lang.StringBuilder java.lang.StringBuilder ), this, charSequence, n, n2, charSequence2, stringBuilder, stringBuilder2);
    }

    private boolean equalSubSequences(CharSequence charSequence, int n, CharSequence charSequence2, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalSubSequences", $$robo$$android_icu_impl_coll_CollationBuilder$equalSubSequences(java.lang.CharSequence int java.lang.CharSequence int ), this, charSequence, n, charSequence2, n2);
    }

    private boolean ignorePrefix(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("ignorePrefix", $$robo$$android_icu_impl_coll_CollationBuilder$ignorePrefix(java.lang.CharSequence ), this, charSequence);
    }

    private boolean ignoreString(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("ignoreString", $$robo$$android_icu_impl_coll_CollationBuilder$ignoreString(java.lang.CharSequence ), this, charSequence);
    }

    private boolean isFCD(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFCD", $$robo$$android_icu_impl_coll_CollationBuilder$isFCD(java.lang.CharSequence ), this, charSequence);
    }

    private void closeOverComposites() {
        InvokeDynamicSupport.bootstrap("closeOverComposites", $$robo$$android_icu_impl_coll_CollationBuilder$closeOverComposites(), this);
    }

    private int addIfDifferent(CharSequence charSequence, CharSequence charSequence2, long[] lArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("addIfDifferent", $$robo$$android_icu_impl_coll_CollationBuilder$addIfDifferent(java.lang.CharSequence java.lang.CharSequence long[] int int ), this, charSequence, charSequence2, lArray, n, n2);
    }

    private static boolean sameCEs(long[] lArray, int n, long[] lArray2, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("sameCEs", $$robo$$android_icu_impl_coll_CollationBuilder$sameCEs(long[] int long[] int ), (long[])lArray, (int)n, (long[])lArray2, (int)n2);
    }

    private static int alignWeightRight(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("alignWeightRight", $$robo$$android_icu_impl_coll_CollationBuilder$alignWeightRight(int ), (int)n);
    }

    private void makeTailoredCEs() {
        InvokeDynamicSupport.bootstrap("makeTailoredCEs", $$robo$$android_icu_impl_coll_CollationBuilder$makeTailoredCEs(), this);
    }

    private static int countTailoredNodes(long[] lArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countTailoredNodes", $$robo$$android_icu_impl_coll_CollationBuilder$countTailoredNodes(long[] int int ), (long[])lArray, (int)n, (int)n2);
    }

    private void finalizeCEs() {
        InvokeDynamicSupport.bootstrap("finalizeCEs", $$robo$$android_icu_impl_coll_CollationBuilder$finalizeCEs(), this);
    }

    private static long tempCEFromIndexAndStrength(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("tempCEFromIndexAndStrength", $$robo$$android_icu_impl_coll_CollationBuilder$tempCEFromIndexAndStrength(int int ), (int)n, (int)n2);
    }

    private static int indexFromTempCE(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexFromTempCE", $$robo$$android_icu_impl_coll_CollationBuilder$indexFromTempCE(long ), (long)l);
    }

    private static int strengthFromTempCE(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("strengthFromTempCE", $$robo$$android_icu_impl_coll_CollationBuilder$strengthFromTempCE(long ), (long)l);
    }

    private static boolean isTempCE(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTempCE", $$robo$$android_icu_impl_coll_CollationBuilder$isTempCE(long ), (long)l);
    }

    private static int indexFromTempCE32(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexFromTempCE32", $$robo$$android_icu_impl_coll_CollationBuilder$indexFromTempCE32(int ), (int)n);
    }

    private static boolean isTempCE32(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTempCE32", $$robo$$android_icu_impl_coll_CollationBuilder$isTempCE32(int ), (int)n);
    }

    private static int ceStrength(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("ceStrength", $$robo$$android_icu_impl_coll_CollationBuilder$ceStrength(long ), (long)l);
    }

    private static long nodeFromWeight32(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nodeFromWeight32", $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromWeight32(long ), (long)l);
    }

    private static long nodeFromWeight16(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nodeFromWeight16", $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromWeight16(int ), (int)n);
    }

    private static long nodeFromPreviousIndex(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nodeFromPreviousIndex", $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromPreviousIndex(int ), (int)n);
    }

    private static long nodeFromNextIndex(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nodeFromNextIndex", $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromNextIndex(int ), (int)n);
    }

    private static long nodeFromStrength(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nodeFromStrength", $$robo$$android_icu_impl_coll_CollationBuilder$nodeFromStrength(int ), (int)n);
    }

    private static long weight32FromNode(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("weight32FromNode", $$robo$$android_icu_impl_coll_CollationBuilder$weight32FromNode(long ), (long)l);
    }

    private static int weight16FromNode(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("weight16FromNode", $$robo$$android_icu_impl_coll_CollationBuilder$weight16FromNode(long ), (long)l);
    }

    private static int previousIndexFromNode(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("previousIndexFromNode", $$robo$$android_icu_impl_coll_CollationBuilder$previousIndexFromNode(long ), (long)l);
    }

    private static int nextIndexFromNode(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nextIndexFromNode", $$robo$$android_icu_impl_coll_CollationBuilder$nextIndexFromNode(long ), (long)l);
    }

    private static int strengthFromNode(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("strengthFromNode", $$robo$$android_icu_impl_coll_CollationBuilder$strengthFromNode(long ), (long)l);
    }

    private static boolean nodeHasBefore2(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nodeHasBefore2", $$robo$$android_icu_impl_coll_CollationBuilder$nodeHasBefore2(long ), (long)l);
    }

    private static boolean nodeHasBefore3(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nodeHasBefore3", $$robo$$android_icu_impl_coll_CollationBuilder$nodeHasBefore3(long ), (long)l);
    }

    private static boolean nodeHasAnyBefore(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nodeHasAnyBefore", $$robo$$android_icu_impl_coll_CollationBuilder$nodeHasAnyBefore(long ), (long)l);
    }

    private static boolean isTailoredNode(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTailoredNode", $$robo$$android_icu_impl_coll_CollationBuilder$isTailoredNode(long ), (long)l);
    }

    private static long changeNodePreviousIndex(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("changeNodePreviousIndex", $$robo$$android_icu_impl_coll_CollationBuilder$changeNodePreviousIndex(long int ), (long)l, (int)n);
    }

    private static long changeNodeNextIndex(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("changeNodeNextIndex", $$robo$$android_icu_impl_coll_CollationBuilder$changeNodeNextIndex(long int ), (long)l, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(CollationBuilder.class);
    }

    public /* synthetic */ CollationBuilder() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationBuilder)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CEFinalizer
    implements CollationDataBuilder.CEModifier,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long[] finalCEs;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_coll_CollationBuilder_CEFinalizer$__constructor__(long[] ces) {
            this.finalCEs = ces;
        }

        private final long $$robo$$android_icu_impl_coll_CollationBuilder_CEFinalizer$modifyCE32(int ce32) {
            if (!$assertionsDisabled && Collation.isSpecialCE32(ce32)) {
                throw new AssertionError();
            }
            if (CollationBuilder.isTempCE32(ce32)) {
                return this.finalCEs[CollationBuilder.indexFromTempCE32(ce32)] | (long)((ce32 & 0xC0) << 8);
            }
            return 0x101000100L;
        }

        private final long $$robo$$android_icu_impl_coll_CollationBuilder_CEFinalizer$modifyCE(long ce) {
            if (CollationBuilder.isTempCE(ce)) {
                return this.finalCEs[CollationBuilder.indexFromTempCE(ce)] | ce & 0xC000L;
            }
            return 0x101000100L;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !CollationBuilder.class.desiredAssertionStatus();
        }

        private void __constructor__(long[] lArray) {
            this.$$robo$$android_icu_impl_coll_CollationBuilder_CEFinalizer$__constructor__(lArray);
        }

        public CEFinalizer(long[] lArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationBuilder_CEFinalizer$__constructor__(long[] ), this, lArray);
        }

        @Override
        public long modifyCE32(int n) {
            return (long)InvokeDynamicSupport.bootstrap("modifyCE32", $$robo$$android_icu_impl_coll_CollationBuilder_CEFinalizer$modifyCE32(int ), this, n);
        }

        @Override
        public long modifyCE(long l) {
            return (long)InvokeDynamicSupport.bootstrap("modifyCE", $$robo$$android_icu_impl_coll_CollationBuilder_CEFinalizer$modifyCE(long ), this, l);
        }

        static {
            RobolectricInternals.classInitializing(CEFinalizer.class);
        }

        public /* synthetic */ CEFinalizer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CEFinalizer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class BundleImporter
    implements CollationRuleParser.Importer,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_coll_CollationBuilder_BundleImporter$__constructor__() {
        }

        private final String $$robo$$android_icu_impl_coll_CollationBuilder_BundleImporter$getRules(String localeID, String collationType) {
            return CollationLoader.loadRules(new ULocale(localeID), collationType);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_coll_CollationBuilder_BundleImporter$__constructor__();
        }

        public BundleImporter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationBuilder_BundleImporter$__constructor__(), this);
        }

        @Override
        public String getRules(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getRules", $$robo$$android_icu_impl_coll_CollationBuilder_BundleImporter$getRules(java.lang.String java.lang.String ), this, string2, string3);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BundleImporter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

