/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.StandardPlural;
import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.RoundingUtils;
import android.icu.text.PluralRules;
import android.icu.text.UFieldPosition;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.FieldPosition;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class DecimalQuantity_AbstractBCD
implements DecimalQuantity,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected int scale;
    protected int precision;
    protected byte flags;
    protected static int NEGATIVE_FLAG = 1;
    protected static int INFINITY_FLAG = 2;
    protected static int NAN_FLAG = 4;
    protected double origDouble;
    protected int origDelta;
    protected boolean isApproximate;
    protected int lOptPos;
    protected int lReqPos;
    protected int rReqPos;
    protected int rOptPos;
    private static double[] DOUBLE_MULTIPLIERS;
    @Deprecated
    public boolean explicitExactDouble;
    private static int SECTION_LOWER_EDGE = -1;
    private static int SECTION_UPPER_EDGE = -2;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$__constructor__() {
        this.lOptPos = Integer.MAX_VALUE;
        this.lReqPos = 0;
        this.rReqPos = 0;
        this.rOptPos = Integer.MIN_VALUE;
        this.explicitExactDouble = false;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$copyFrom(DecimalQuantity _other) {
        this.copyBcdFrom(_other);
        DecimalQuantity_AbstractBCD other = (DecimalQuantity_AbstractBCD)_other;
        this.lOptPos = other.lOptPos;
        this.lReqPos = other.lReqPos;
        this.rReqPos = other.rReqPos;
        this.rOptPos = other.rOptPos;
        this.scale = other.scale;
        this.precision = other.precision;
        this.flags = other.flags;
        this.origDouble = other.origDouble;
        this.origDelta = other.origDelta;
        this.isApproximate = other.isApproximate;
    }

    private final DecimalQuantity_AbstractBCD $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$clear() {
        this.lOptPos = Integer.MAX_VALUE;
        this.lReqPos = 0;
        this.rReqPos = 0;
        this.rOptPos = Integer.MIN_VALUE;
        this.flags = 0;
        this.setBcdToZero();
        return this;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setIntegerLength(int minInt, int maxInt) {
        if (!$assertionsDisabled && minInt < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && maxInt < minInt) {
            throw new AssertionError();
        }
        this.lOptPos = maxInt;
        this.lReqPos = minInt;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setFractionLength(int minFrac, int maxFrac) {
        if (!$assertionsDisabled && minFrac < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && maxFrac < minFrac) {
            throw new AssertionError();
        }
        this.rReqPos = -minFrac;
        this.rOptPos = -maxFrac;
    }

    private final long $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getPositionFingerprint() {
        long fingerprint = 0L;
        fingerprint ^= (long)this.lOptPos;
        fingerprint ^= (long)(this.lReqPos << 16);
        fingerprint ^= (long)this.rReqPos << 32;
        return fingerprint ^= (long)this.rOptPos << 48;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$roundToIncrement(BigDecimal roundingIncrement, MathContext mathContext) {
        BigDecimal temp = this.toBigDecimal();
        if ((temp = temp.divide(roundingIncrement, 0, mathContext.getRoundingMode()).multiply(roundingIncrement).round(mathContext)).signum() == 0) {
            this.setBcdToZero();
        } else {
            this.setToBigDecimal(temp);
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$multiplyBy(BigDecimal multiplicand) {
        if (this.isInfinite() || this.isZero() || this.isNaN()) {
            return;
        }
        BigDecimal temp = this.toBigDecimal();
        temp = temp.multiply(multiplicand);
        this.setToBigDecimal(temp);
    }

    private final int $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getMagnitude() throws ArithmeticException {
        if (this.precision == 0) {
            throw new ArithmeticException("Magnitude is not well-defined for zero");
        }
        return this.scale + this.precision - 1;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$adjustMagnitude(int delta) {
        if (this.precision != 0) {
            this.scale += delta;
            this.origDelta += delta;
        }
    }

    private final StandardPlural $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getStandardPlural(PluralRules rules) {
        if (rules == null) {
            return StandardPlural.OTHER;
        }
        String ruleString = rules.select(this);
        return StandardPlural.orOtherFromString(ruleString);
    }

    private final double $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getPluralOperand(PluralRules.Operand operand) {
        if (!$assertionsDisabled && this.isApproximate) {
            throw new AssertionError();
        }
        switch (1.$SwitchMap$android$icu$text$PluralRules$Operand[operand.ordinal()]) {
            case 1: {
                return this.toLong();
            }
            case 2: {
                return this.toFractionLong(true);
            }
            case 3: {
                return this.toFractionLong(false);
            }
            case 4: {
                return this.fractionCount();
            }
            case 5: {
                return this.fractionCountWithoutTrailingZeros();
            }
        }
        return Math.abs(this.toDouble());
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$populateUFieldPosition(FieldPosition fp) {
        if (fp instanceof UFieldPosition) {
            ((UFieldPosition)fp).setFractionDigits((int)this.getPluralOperand(PluralRules.Operand.v), (long)this.getPluralOperand(PluralRules.Operand.f));
        }
    }

    private final int $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getUpperDisplayMagnitude() {
        if (!$assertionsDisabled && this.isApproximate) {
            throw new AssertionError();
        }
        int magnitude = this.scale + this.precision;
        int result = this.lReqPos > magnitude ? this.lReqPos : (this.lOptPos < magnitude ? this.lOptPos : magnitude);
        return result - 1;
    }

    private final int $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getLowerDisplayMagnitude() {
        if (!$assertionsDisabled && this.isApproximate) {
            throw new AssertionError();
        }
        int magnitude = this.scale;
        int result = this.rReqPos < magnitude ? this.rReqPos : (this.rOptPos > magnitude ? this.rOptPos : magnitude);
        return result;
    }

    private final byte $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getDigit(int magnitude) {
        if (!$assertionsDisabled && this.isApproximate) {
            throw new AssertionError();
        }
        return this.getDigitPos(magnitude - this.scale);
    }

    private final int $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$fractionCount() {
        return -this.getLowerDisplayMagnitude();
    }

    private final int $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$fractionCountWithoutTrailingZeros() {
        return Math.max(-this.scale, 0);
    }

    private final boolean $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$isNegative() {
        return (this.flags & 1) != 0;
    }

    private final boolean $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$isInfinite() {
        return (this.flags & 2) != 0;
    }

    private final boolean $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$isNaN() {
        return (this.flags & 4) != 0;
    }

    private final boolean $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$isZero() {
        return this.precision == 0;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToInt(int n) {
        this.setBcdToZero();
        this.flags = 0;
        if (n < 0) {
            this.flags = (byte)(this.flags | 1);
            n = -n;
        }
        if (n != 0) {
            this._setToInt(n);
            this.compact();
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToInt(int n) {
        if (n == Integer.MIN_VALUE) {
            this.readLongToBcd(-((long)n));
        } else {
            this.readIntToBcd(n);
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToLong(long n) {
        this.setBcdToZero();
        this.flags = 0;
        if (n < 0L) {
            this.flags = (byte)(this.flags | 1);
            n = -n;
        }
        if (n != 0L) {
            this._setToLong(n);
            this.compact();
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToLong(long n) {
        if (n == Long.MIN_VALUE) {
            this.readBigIntegerToBcd(BigInteger.valueOf(n).negate());
        } else if (n <= Integer.MAX_VALUE) {
            this.readIntToBcd((int)n);
        } else {
            this.readLongToBcd(n);
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToBigInteger(BigInteger n) {
        this.setBcdToZero();
        this.flags = 0;
        if (n.signum() == -1) {
            this.flags = (byte)(this.flags | 1);
            n = n.negate();
        }
        if (n.signum() != 0) {
            this._setToBigInteger(n);
            this.compact();
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToBigInteger(BigInteger n) {
        if (n.bitLength() < 32) {
            this.readIntToBcd(n.intValue());
        } else if (n.bitLength() < 64) {
            this.readLongToBcd(n.longValue());
        } else {
            this.readBigIntegerToBcd(n);
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToDouble(double n) {
        this.setBcdToZero();
        this.flags = 0;
        if (Double.compare(n, 0.0) < 0) {
            this.flags = (byte)(this.flags | 1);
            n = -n;
        }
        if (Double.isNaN(n)) {
            this.flags = (byte)(this.flags | 4);
        } else if (Double.isInfinite(n)) {
            this.flags = (byte)(this.flags | 2);
        } else if (n != 0.0) {
            this._setToDoubleFast(n);
            this.compact();
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToDoubleFast(double n) {
        int i;
        this.isApproximate = true;
        this.origDouble = n;
        this.origDelta = 0;
        long ieeeBits = Double.doubleToLongBits(n);
        int exponent = (int)((ieeeBits & 0x7FF0000000000000L) >> 52) - 1023;
        if (exponent <= 52 && (double)((long)n) == n) {
            this._setToLong((long)n);
            return;
        }
        int fracLength = (int)((double)(52 - exponent) / 3.32192809489);
        if (fracLength >= 0) {
            for (i = fracLength; i >= 22; i -= 22) {
                n *= 1.0E22;
            }
            n *= DOUBLE_MULTIPLIERS[i];
        } else {
            for (i = fracLength; i <= -22; i += 22) {
                n /= 1.0E22;
            }
            n /= DOUBLE_MULTIPLIERS[-i];
        }
        long result = Math.round(n);
        if (result != 0L) {
            this._setToLong(result);
            this.scale -= fracLength;
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$convertToAccurateDouble() {
        double n = this.origDouble;
        if (!$assertionsDisabled && n == 0.0) {
            throw new AssertionError();
        }
        int delta = this.origDelta;
        this.setBcdToZero();
        String dstr = Double.toString(n);
        if (dstr.indexOf(69) != -1) {
            if (!$assertionsDisabled && dstr.indexOf(46) != 1) {
                throw new AssertionError();
            }
            int expPos = dstr.indexOf(69);
            this._setToLong(Long.parseLong(dstr.charAt(0) + dstr.substring(2, expPos)));
            this.scale += Integer.parseInt(dstr.substring(expPos + 1)) - (expPos - 1) + 1;
        } else if (dstr.charAt(0) == '0') {
            if (!$assertionsDisabled && dstr.indexOf(46) != 1) {
                throw new AssertionError();
            }
            this._setToLong(Long.parseLong(dstr.substring(2)));
            this.scale += 2 - dstr.length();
        } else if (dstr.charAt(dstr.length() - 1) == '0') {
            if (!$assertionsDisabled && dstr.indexOf(46) != dstr.length() - 2) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && dstr.length() - 2 > 18) {
                throw new AssertionError();
            }
            this._setToLong(Long.parseLong(dstr.substring(0, dstr.length() - 2)));
        } else {
            int decimalPos = dstr.indexOf(46);
            this._setToLong(Long.parseLong(dstr.substring(0, decimalPos) + dstr.substring(decimalPos + 1)));
            this.scale += decimalPos - dstr.length() + 1;
        }
        this.scale += delta;
        this.compact();
        this.explicitExactDouble = true;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToBigDecimal(BigDecimal n) {
        this.setBcdToZero();
        this.flags = 0;
        if (n.signum() == -1) {
            this.flags = (byte)(this.flags | 1);
            n = n.negate();
        }
        if (n.signum() != 0) {
            this._setToBigDecimal(n);
            this.compact();
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToBigDecimal(BigDecimal n) {
        int fracLength = n.scale();
        n = n.scaleByPowerOfTen(fracLength);
        BigInteger bi = n.toBigInteger();
        this._setToBigInteger(bi);
        this.scale -= fracLength;
    }

    private final long $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toLong() {
        long result = 0L;
        for (int magnitude = this.scale + this.precision - 1; magnitude >= 0; --magnitude) {
            result = result * 10L + (long)this.getDigitPos(magnitude - this.scale);
        }
        return result;
    }

    private final long $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toFractionLong(boolean includeTrailingZeros) {
        long result = 0L;
        for (int magnitude = -1; (magnitude >= this.scale || includeTrailingZeros && magnitude >= this.rReqPos) && magnitude >= this.rOptPos; --magnitude) {
            result = result * 10L + (long)this.getDigitPos(magnitude - this.scale);
        }
        return result;
    }

    private final double $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toDouble() {
        if (this.isApproximate) {
            return this.toDoubleFromOriginal();
        }
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        long tempLong = 0L;
        int lostDigits = this.precision - Math.min(this.precision, 17);
        for (int shift = this.precision - 1; shift >= lostDigits; --shift) {
            tempLong = tempLong * 10L + (long)this.getDigitPos(shift);
        }
        double result = tempLong;
        int _scale = this.scale + lostDigits;
        if (_scale >= 0) {
            int i;
            for (i = _scale; i >= 22; i -= 22) {
                result *= 1.0E22;
            }
            result *= DOUBLE_MULTIPLIERS[i];
        } else {
            int i;
            for (i = _scale; i <= -22; i += 22) {
                result /= 1.0E22;
            }
            result /= DOUBLE_MULTIPLIERS[-i];
        }
        if (this.isNegative()) {
            result = -result;
        }
        return result;
    }

    private final BigDecimal $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toBigDecimal() {
        if (this.isApproximate) {
            this.convertToAccurateDouble();
        }
        return this.bcdToBigDecimal();
    }

    private final double $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toDoubleFromOriginal() {
        double result = this.origDouble;
        int delta = this.origDelta;
        if (delta >= 0) {
            while (delta >= 22) {
                result *= 1.0E22;
                delta -= 22;
            }
            result *= DOUBLE_MULTIPLIERS[delta];
        } else {
            while (delta <= -22) {
                result /= 1.0E22;
                delta += 22;
            }
            result /= DOUBLE_MULTIPLIERS[-delta];
        }
        if (this.isNegative()) {
            result *= -1.0;
        }
        return result;
    }

    private static final int $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$safeSubtract(int a, int b) {
        int diff = a - b;
        if (b < 0 && diff < a) {
            return Integer.MAX_VALUE;
        }
        if (b > 0 && diff > a) {
            return Integer.MIN_VALUE;
        }
        return diff;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$roundToMagnitude(int magnitude, MathContext mathContext) {
        int position = DecimalQuantity_AbstractBCD.safeSubtract(magnitude, this.scale);
        int _mcPrecision = mathContext.getPrecision();
        if (magnitude == Integer.MAX_VALUE || _mcPrecision > 0 && this.precision - position > _mcPrecision) {
            position = this.precision - _mcPrecision;
        }
        if ((position > 0 || this.isApproximate) && this.precision != 0) {
            int p;
            byte leadingDigit = this.getDigitPos(DecimalQuantity_AbstractBCD.safeSubtract(position, 1));
            byte trailingDigit = this.getDigitPos(position);
            int section = 2;
            if (!this.isApproximate) {
                if (leadingDigit < 5) {
                    section = 1;
                } else if (leadingDigit > 5) {
                    section = 3;
                } else {
                    for (p = DecimalQuantity_AbstractBCD.safeSubtract(position, 2); p >= 0; --p) {
                        if (this.getDigitPos(p) == 0) continue;
                        section = 3;
                        break;
                    }
                }
            } else {
                int minP = Math.max(0, this.precision - 14);
                if (leadingDigit == 0) {
                    section = -1;
                    for (p = DecimalQuantity_AbstractBCD.safeSubtract(position, 2); p >= minP; --p) {
                        if (this.getDigitPos(p) == 0) continue;
                        section = 1;
                        break;
                    }
                } else if (leadingDigit == 4) {
                    while (p >= minP) {
                        if (this.getDigitPos(p) != 9) {
                            section = 1;
                            break;
                        }
                        --p;
                    }
                } else if (leadingDigit == 5) {
                    while (p >= minP) {
                        if (this.getDigitPos(p) != 0) {
                            section = 3;
                            break;
                        }
                        --p;
                    }
                } else if (leadingDigit == 9) {
                    section = -2;
                    while (p >= minP) {
                        if (this.getDigitPos(p) != 9) {
                            section = 3;
                            break;
                        }
                        --p;
                    }
                } else {
                    section = leadingDigit < 5 ? 1 : 3;
                }
                boolean roundsAtMidpoint = RoundingUtils.roundsAtMidpoint(mathContext.getRoundingMode().ordinal());
                if (DecimalQuantity_AbstractBCD.safeSubtract(position, 1) < this.precision - 14 || roundsAtMidpoint && section == 2 || !roundsAtMidpoint && section < 0) {
                    this.convertToAccurateDouble();
                    this.roundToMagnitude(magnitude, mathContext);
                    return;
                }
                this.isApproximate = false;
                this.origDouble = 0.0;
                this.origDelta = 0;
                if (position <= 0) {
                    return;
                }
                if (section == -1) {
                    section = 1;
                }
                if (section == -2) {
                    section = 3;
                }
            }
            boolean roundDown = RoundingUtils.getRoundingDirection(trailingDigit % 2 == 0, this.isNegative(), section, mathContext.getRoundingMode().ordinal(), this);
            if (position >= this.precision) {
                this.setBcdToZero();
                this.scale = magnitude;
            } else {
                this.shiftRight(position);
            }
            if (!roundDown) {
                if (trailingDigit == 9) {
                    int bubblePos = 0;
                    while (this.getDigitPos(bubblePos) == 9) {
                        ++bubblePos;
                    }
                    this.shiftRight(bubblePos);
                }
                byte digit0 = this.getDigitPos(0);
                if (!$assertionsDisabled && digit0 == 9) {
                    throw new AssertionError();
                }
                this.setDigitPos(0, (byte)(digit0 + 1));
                ++this.precision;
            }
            this.compact();
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$roundToInfinity() {
        if (this.isApproximate) {
            this.convertToAccurateDouble();
        }
    }

    @Deprecated
    private final void $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$appendDigit(byte value, int leadingZeros, boolean appendAsInteger) {
        if (!$assertionsDisabled && leadingZeros < 0) {
            throw new AssertionError();
        }
        if (value == 0) {
            if (appendAsInteger && this.precision != 0) {
                this.scale += leadingZeros + 1;
            }
            return;
        }
        if (this.scale > 0) {
            leadingZeros += this.scale;
            if (appendAsInteger) {
                this.scale = 0;
            }
        }
        this.shiftLeft(leadingZeros + 1);
        this.setDigitPos(0, value);
        if (appendAsInteger) {
            this.scale += leadingZeros + 1;
        }
    }

    private final String $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toPlainString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNegative()) {
            sb.append('-');
        }
        for (int m = this.getUpperDisplayMagnitude(); m >= this.getLowerDisplayMagnitude(); --m) {
            sb.append(this.getDigit(m));
            if (m != 0) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    protected abstract byte getDigitPos(int var1);

    protected abstract void setDigitPos(int var1, byte var2);

    protected abstract void shiftLeft(int var1);

    protected abstract void shiftRight(int var1);

    protected abstract void setBcdToZero();

    protected abstract void readIntToBcd(int var1);

    protected abstract void readLongToBcd(long var1);

    protected abstract void readBigIntegerToBcd(BigInteger var1);

    protected abstract BigDecimal bcdToBigDecimal();

    protected abstract void copyBcdFrom(DecimalQuantity var1);

    protected abstract void compact();

    static void __staticInitializer__() {
        $assertionsDisabled = !DecimalQuantity_AbstractBCD.class.desiredAssertionStatus();
        DOUBLE_MULTIPLIERS = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21};
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$__constructor__();
    }

    public DecimalQuantity_AbstractBCD() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$__constructor__(), this);
    }

    @Override
    public void copyFrom(DecimalQuantity decimalQuantity) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$copyFrom(android.icu.impl.number.DecimalQuantity ), this, decimalQuantity);
    }

    public DecimalQuantity_AbstractBCD clear() {
        return InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$clear(), this);
    }

    @Override
    public void setIntegerLength(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setIntegerLength", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setIntegerLength(int int ), this, n, n2);
    }

    @Override
    public void setFractionLength(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFractionLength", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setFractionLength(int int ), this, n, n2);
    }

    @Override
    public long getPositionFingerprint() {
        return (long)InvokeDynamicSupport.bootstrap("getPositionFingerprint", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getPositionFingerprint(), this);
    }

    @Override
    public void roundToIncrement(BigDecimal bigDecimal, MathContext mathContext) {
        InvokeDynamicSupport.bootstrap("roundToIncrement", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$roundToIncrement(java.math.BigDecimal java.math.MathContext ), this, bigDecimal, mathContext);
    }

    @Override
    public void multiplyBy(BigDecimal bigDecimal) {
        InvokeDynamicSupport.bootstrap("multiplyBy", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$multiplyBy(java.math.BigDecimal ), this, bigDecimal);
    }

    @Override
    public int getMagnitude() throws ArithmeticException {
        return (int)InvokeDynamicSupport.bootstrap("getMagnitude", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getMagnitude(), this);
    }

    @Override
    public void adjustMagnitude(int n) {
        InvokeDynamicSupport.bootstrap("adjustMagnitude", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$adjustMagnitude(int ), this, n);
    }

    @Override
    public StandardPlural getStandardPlural(PluralRules pluralRules) {
        return InvokeDynamicSupport.bootstrap("getStandardPlural", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getStandardPlural(android.icu.text.PluralRules ), this, pluralRules);
    }

    @Override
    public double getPluralOperand(PluralRules.Operand operand) {
        return (double)InvokeDynamicSupport.bootstrap("getPluralOperand", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getPluralOperand(android.icu.text.PluralRules$Operand ), this, operand);
    }

    @Override
    public void populateUFieldPosition(FieldPosition fieldPosition) {
        InvokeDynamicSupport.bootstrap("populateUFieldPosition", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$populateUFieldPosition(java.text.FieldPosition ), this, fieldPosition);
    }

    @Override
    public int getUpperDisplayMagnitude() {
        return (int)InvokeDynamicSupport.bootstrap("getUpperDisplayMagnitude", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getUpperDisplayMagnitude(), this);
    }

    @Override
    public int getLowerDisplayMagnitude() {
        return (int)InvokeDynamicSupport.bootstrap("getLowerDisplayMagnitude", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getLowerDisplayMagnitude(), this);
    }

    @Override
    public byte getDigit(int n) {
        return (byte)InvokeDynamicSupport.bootstrap("getDigit", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$getDigit(int ), this, n);
    }

    private int fractionCount() {
        return (int)InvokeDynamicSupport.bootstrap("fractionCount", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$fractionCount(), this);
    }

    private int fractionCountWithoutTrailingZeros() {
        return (int)InvokeDynamicSupport.bootstrap("fractionCountWithoutTrailingZeros", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$fractionCountWithoutTrailingZeros(), this);
    }

    @Override
    public boolean isNegative() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNegative", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$isNegative(), this);
    }

    @Override
    public boolean isInfinite() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInfinite", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$isInfinite(), this);
    }

    @Override
    public boolean isNaN() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNaN", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$isNaN(), this);
    }

    @Override
    public boolean isZero() {
        return (boolean)InvokeDynamicSupport.bootstrap("isZero", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$isZero(), this);
    }

    public void setToInt(int n) {
        InvokeDynamicSupport.bootstrap("setToInt", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToInt(int ), this, n);
    }

    private void _setToInt(int n) {
        InvokeDynamicSupport.bootstrap("_setToInt", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToInt(int ), this, n);
    }

    public void setToLong(long l) {
        InvokeDynamicSupport.bootstrap("setToLong", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToLong(long ), this, l);
    }

    private void _setToLong(long l) {
        InvokeDynamicSupport.bootstrap("_setToLong", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToLong(long ), this, l);
    }

    public void setToBigInteger(BigInteger bigInteger) {
        InvokeDynamicSupport.bootstrap("setToBigInteger", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToBigInteger(java.math.BigInteger ), this, bigInteger);
    }

    private void _setToBigInteger(BigInteger bigInteger) {
        InvokeDynamicSupport.bootstrap("_setToBigInteger", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToBigInteger(java.math.BigInteger ), this, bigInteger);
    }

    public void setToDouble(double d) {
        InvokeDynamicSupport.bootstrap("setToDouble", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToDouble(double ), this, d);
    }

    private void _setToDoubleFast(double d) {
        InvokeDynamicSupport.bootstrap("_setToDoubleFast", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToDoubleFast(double ), this, d);
    }

    private void convertToAccurateDouble() {
        InvokeDynamicSupport.bootstrap("convertToAccurateDouble", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$convertToAccurateDouble(), this);
    }

    @Override
    public void setToBigDecimal(BigDecimal bigDecimal) {
        InvokeDynamicSupport.bootstrap("setToBigDecimal", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$setToBigDecimal(java.math.BigDecimal ), this, bigDecimal);
    }

    private void _setToBigDecimal(BigDecimal bigDecimal) {
        InvokeDynamicSupport.bootstrap("_setToBigDecimal", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$_setToBigDecimal(java.math.BigDecimal ), this, bigDecimal);
    }

    protected long toLong() {
        return (long)InvokeDynamicSupport.bootstrap("toLong", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toLong(), this);
    }

    protected long toFractionLong(boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("toFractionLong", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toFractionLong(boolean ), this, bl);
    }

    @Override
    public double toDouble() {
        return (double)InvokeDynamicSupport.bootstrap("toDouble", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toDouble(), this);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return InvokeDynamicSupport.bootstrap("toBigDecimal", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toBigDecimal(), this);
    }

    protected double toDoubleFromOriginal() {
        return (double)InvokeDynamicSupport.bootstrap("toDoubleFromOriginal", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toDoubleFromOriginal(), this);
    }

    private static int safeSubtract(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("safeSubtract", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$safeSubtract(int int ), (int)n, (int)n2);
    }

    @Override
    public void roundToMagnitude(int n, MathContext mathContext) {
        InvokeDynamicSupport.bootstrap("roundToMagnitude", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$roundToMagnitude(int java.math.MathContext ), this, n, mathContext);
    }

    @Override
    public void roundToInfinity() {
        InvokeDynamicSupport.bootstrap("roundToInfinity", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$roundToInfinity(), this);
    }

    @Deprecated
    public void appendDigit(byte by, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("appendDigit", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$appendDigit(byte int boolean ), this, by, n, bl);
    }

    @Override
    public String toPlainString() {
        return InvokeDynamicSupport.bootstrap("toPlainString", $$robo$$android_icu_impl_number_DecimalQuantity_AbstractBCD$toPlainString(), this);
    }

    static {
        RobolectricInternals.classInitializing(DecimalQuantity_AbstractBCD.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecimalQuantity_AbstractBCD)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

