/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.text.NumberFormat;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.Format;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NumberStringBuilder
implements CharSequence,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static NumberStringBuilder EMPTY;
    private char[] chars;
    private NumberFormat.Field[] fields;
    private int zero;
    private int length;
    private static Map<NumberFormat.Field, Character> fieldToDebugChar;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__() {
    }

    private void $$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__(int capacity) {
        this.chars = new char[capacity];
        this.fields = new NumberFormat.Field[capacity];
        this.zero = capacity / 2;
        this.length = 0;
    }

    private void $$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__(NumberStringBuilder source) {
        this.copyFrom(source);
    }

    private final void $$robo$$android_icu_impl_number_NumberStringBuilder$copyFrom(NumberStringBuilder source) {
        this.chars = Arrays.copyOf(source.chars, source.chars.length);
        this.fields = Arrays.copyOf(source.fields, source.fields.length);
        this.zero = source.zero;
        this.length = source.length;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$length() {
        return this.length;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$codePointCount() {
        return Character.codePointCount(this, 0, this.length());
    }

    private final char $$robo$$android_icu_impl_number_NumberStringBuilder$charAt(int index) {
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && index >= this.length) {
            throw new AssertionError();
        }
        return this.chars[this.zero + index];
    }

    private final NumberFormat.Field $$robo$$android_icu_impl_number_NumberStringBuilder$fieldAt(int index) {
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && index >= this.length) {
            throw new AssertionError();
        }
        return this.fields[this.zero + index];
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$getFirstCodePoint() {
        if (this.length == 0) {
            return -1;
        }
        return Character.codePointAt(this.chars, this.zero, this.zero + this.length);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$getLastCodePoint() {
        if (this.length == 0) {
            return -1;
        }
        return Character.codePointBefore(this.chars, this.zero + this.length, this.zero);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$codePointAt(int index) {
        return Character.codePointAt(this.chars, this.zero + index, this.zero + this.length);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$codePointBefore(int index) {
        return Character.codePointBefore(this.chars, this.zero + index, this.zero);
    }

    private final NumberStringBuilder $$robo$$android_icu_impl_number_NumberStringBuilder$clear() {
        this.zero = this.getCapacity() / 2;
        this.length = 0;
        return this;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$appendCodePoint(int codePoint, NumberFormat.Field field) {
        return this.insertCodePoint(this.length, codePoint, field);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$insertCodePoint(int index, int codePoint, NumberFormat.Field field) {
        int count = Character.charCount(codePoint);
        int position = this.prepareForInsert(index, count);
        Character.toChars(codePoint, this.chars, position);
        this.fields[position] = field;
        if (count == 2) {
            this.fields[position + 1] = field;
        }
        return count;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$append(CharSequence sequence, NumberFormat.Field field) {
        return this.insert(this.length, sequence, field);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$insert(int index, CharSequence sequence, NumberFormat.Field field) {
        if (sequence.length() == 0) {
            return 0;
        }
        if (sequence.length() == 1) {
            return this.insertCodePoint(index, sequence.charAt(0), field);
        }
        return this.insert(index, sequence, 0, sequence.length(), field);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$insert(int index, CharSequence sequence, int start, int end, NumberFormat.Field field) {
        int count = end - start;
        int position = this.prepareForInsert(index, count);
        for (int i = 0; i < count; ++i) {
            this.chars[position + i] = sequence.charAt(start + i);
            this.fields[position + i] = field;
        }
        return count;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$append(char[] chars, NumberFormat.Field[] fields) {
        return this.insert(this.length, chars, fields);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$insert(int index, char[] chars, NumberFormat.Field[] fields) {
        if (!$assertionsDisabled && fields != null && chars.length != fields.length) {
            throw new AssertionError();
        }
        int count = chars.length;
        if (count == 0) {
            return 0;
        }
        int position = this.prepareForInsert(index, count);
        for (int i = 0; i < count; ++i) {
            this.chars[position + i] = chars[i];
            this.fields[position + i] = fields == null ? null : fields[i];
        }
        return count;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$append(NumberStringBuilder other) {
        return this.insert(this.length, other);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$insert(int index, NumberStringBuilder other) {
        if (this == other) {
            throw new IllegalArgumentException("Cannot call insert/append on myself");
        }
        int count = other.length;
        if (count == 0) {
            return 0;
        }
        int position = this.prepareForInsert(index, count);
        for (int i = 0; i < count; ++i) {
            this.chars[position + i] = other.charAt(i);
            this.fields[position + i] = other.fieldAt(i);
        }
        return count;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$prepareForInsert(int index, int count) {
        if (index == 0 && this.zero - count >= 0) {
            this.zero -= count;
            this.length += count;
            return this.zero;
        }
        if (index == this.length && this.zero + this.length + count < this.getCapacity()) {
            this.length += count;
            return this.zero + this.length - count;
        }
        return this.prepareForInsertHelper(index, count);
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$prepareForInsertHelper(int index, int count) {
        int oldCapacity = this.getCapacity();
        int oldZero = this.zero;
        char[] oldChars = this.chars;
        NumberFormat.Field[] oldFields = this.fields;
        if (this.length + count > oldCapacity) {
            int newCapacity = (this.length + count) * 2;
            int newZero = newCapacity / 2 - (this.length + count) / 2;
            char[] newChars = new char[newCapacity];
            NumberFormat.Field[] newFields = new NumberFormat.Field[newCapacity];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldChars, (int)oldZero, (Object)newChars, (int)newZero, (int)index);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldChars, (int)(oldZero + index), (Object)newChars, (int)(newZero + index + count), (int)(this.length - index));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldFields, (int)oldZero, (Object)newFields, (int)newZero, (int)index);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldFields, (int)(oldZero + index), (Object)newFields, (int)(newZero + index + count), (int)(this.length - index));
            this.chars = newChars;
            this.fields = newFields;
            this.zero = newZero;
            this.length += count;
        } else {
            int newZero = oldCapacity / 2 - (this.length + count) / 2;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldChars, (int)oldZero, (Object)oldChars, (int)newZero, (int)this.length);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldChars, (int)(newZero + index), (Object)oldChars, (int)(newZero + index + count), (int)(this.length - index));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldFields, (int)oldZero, (Object)oldFields, (int)newZero, (int)this.length);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oldFields, (int)(newZero + index), (Object)oldFields, (int)(newZero + index + count), (int)(this.length - index));
            this.zero = newZero;
            this.length += count;
        }
        return this.zero + index;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$getCapacity() {
        return this.chars.length;
    }

    private final CharSequence $$robo$$android_icu_impl_number_NumberStringBuilder$subSequence(int start, int end) {
        if (start < 0 || end > this.length || end < start) {
            throw new IndexOutOfBoundsException();
        }
        NumberStringBuilder other = new NumberStringBuilder(this);
        other.zero = this.zero + start;
        other.length = end - start;
        return other;
    }

    private final String $$robo$$android_icu_impl_number_NumberStringBuilder$toString() {
        return new String(this.chars, this.zero, this.length);
    }

    private final String $$robo$$android_icu_impl_number_NumberStringBuilder$toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<NumberStringBuilder [");
        sb.append(this.toString());
        sb.append("] [");
        for (int i = this.zero; i < this.zero + this.length; ++i) {
            if (this.fields[i] == null) {
                sb.append('n');
                continue;
            }
            sb.append(fieldToDebugChar.get(this.fields[i]));
        }
        sb.append("]>");
        return sb.toString();
    }

    private final char[] $$robo$$android_icu_impl_number_NumberStringBuilder$toCharArray() {
        return Arrays.copyOfRange(this.chars, this.zero, this.zero + this.length);
    }

    private final NumberFormat.Field[] $$robo$$android_icu_impl_number_NumberStringBuilder$toFieldArray() {
        return Arrays.copyOfRange(this.fields, this.zero, this.zero + this.length);
    }

    private final boolean $$robo$$android_icu_impl_number_NumberStringBuilder$contentEquals(char[] chars, NumberFormat.Field[] fields) {
        if (chars.length != this.length) {
            return false;
        }
        if (fields.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.chars[this.zero + i] != chars[i]) {
                return false;
            }
            if (this.fields[this.zero + i] == fields[i]) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_icu_impl_number_NumberStringBuilder$contentEquals(NumberStringBuilder other) {
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.charAt(i) == other.charAt(i) && this.fieldAt(i) == other.fieldAt(i)) continue;
            return false;
        }
        return true;
    }

    private final int $$robo$$android_icu_impl_number_NumberStringBuilder$hashCode() {
        throw new UnsupportedOperationException("Don't call #hashCode() or #equals() on a mutable.");
    }

    private final boolean $$robo$$android_icu_impl_number_NumberStringBuilder$equals(Object other) {
        throw new UnsupportedOperationException("Don't call #hashCode() or #equals() on a mutable.");
    }

    private final void $$robo$$android_icu_impl_number_NumberStringBuilder$populateFieldPosition(FieldPosition fp, int offset) {
        Format.Field rawField = fp.getFieldAttribute();
        if (rawField == null) {
            if (fp.getField() == 0) {
                rawField = NumberFormat.Field.INTEGER;
            } else if (fp.getField() == 1) {
                rawField = NumberFormat.Field.FRACTION;
            } else {
                return;
            }
        }
        if (!(rawField instanceof NumberFormat.Field)) {
            throw new IllegalArgumentException("You must pass an instance of android.icu.text.NumberFormat.Field as your FieldPosition attribute.  You passed: " + rawField.getClass().toString());
        }
        NumberFormat.Field field = (NumberFormat.Field)rawField;
        boolean seenStart = false;
        int fractionStart = -1;
        for (int i = this.zero; i <= this.zero + this.length; ++i) {
            NumberFormat.Field _field;
            NumberFormat.Field field2 = _field = i < this.zero + this.length ? this.fields[i] : null;
            if (seenStart && field != _field) {
                if (field == NumberFormat.Field.INTEGER && _field == NumberFormat.Field.GROUPING_SEPARATOR) continue;
                fp.setEndIndex(i - this.zero + offset);
                break;
            }
            if (!seenStart && field == _field) {
                fp.setBeginIndex(i - this.zero + offset);
                seenStart = true;
            }
            if (_field != NumberFormat.Field.INTEGER && _field != NumberFormat.Field.DECIMAL_SEPARATOR) continue;
            fractionStart = i - this.zero + 1;
        }
        if (field == NumberFormat.Field.FRACTION && !seenStart) {
            fp.setBeginIndex(fractionStart + offset);
            fp.setEndIndex(fractionStart + offset);
        }
    }

    private final AttributedCharacterIterator $$robo$$android_icu_impl_number_NumberStringBuilder$getIterator() {
        AttributedString as = new AttributedString(this.toString());
        NumberFormat.Field current = null;
        int currentStart = -1;
        for (int i = 0; i < this.length; ++i) {
            NumberFormat.Field field = this.fields[i + this.zero];
            if (current == NumberFormat.Field.INTEGER && field == NumberFormat.Field.GROUPING_SEPARATOR) {
                as.addAttribute(NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.GROUPING_SEPARATOR, i, i + 1);
                continue;
            }
            if (current == field) continue;
            if (current != null) {
                as.addAttribute(current, current, currentStart, i);
            }
            current = field;
            currentStart = i;
        }
        if (current != null) {
            as.addAttribute(current, current, currentStart, this.length);
        }
        return as.getIterator();
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !NumberStringBuilder.class.desiredAssertionStatus();
        EMPTY = new NumberStringBuilder();
        fieldToDebugChar = new HashMap<NumberFormat.Field, Character>();
        fieldToDebugChar.put(NumberFormat.Field.SIGN, Character.valueOf('-'));
        fieldToDebugChar.put(NumberFormat.Field.INTEGER, Character.valueOf('i'));
        fieldToDebugChar.put(NumberFormat.Field.FRACTION, Character.valueOf('f'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT, Character.valueOf('e'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT_SIGN, Character.valueOf('+'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT_SYMBOL, Character.valueOf('E'));
        fieldToDebugChar.put(NumberFormat.Field.DECIMAL_SEPARATOR, Character.valueOf('.'));
        fieldToDebugChar.put(NumberFormat.Field.GROUPING_SEPARATOR, Character.valueOf(','));
        fieldToDebugChar.put(NumberFormat.Field.PERCENT, Character.valueOf('%'));
        fieldToDebugChar.put(NumberFormat.Field.PERMILLE, Character.valueOf('\u2030'));
        fieldToDebugChar.put(NumberFormat.Field.CURRENCY, Character.valueOf('$'));
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__();
    }

    public NumberStringBuilder() {
        this(40);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__(n);
    }

    public NumberStringBuilder(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__(int ), this, n);
    }

    private void __constructor__(NumberStringBuilder numberStringBuilder) {
        this.$$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__(numberStringBuilder);
    }

    public NumberStringBuilder(NumberStringBuilder numberStringBuilder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_NumberStringBuilder$__constructor__(android.icu.impl.number.NumberStringBuilder ), this, numberStringBuilder);
    }

    public void copyFrom(NumberStringBuilder numberStringBuilder) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_icu_impl_number_NumberStringBuilder$copyFrom(android.icu.impl.number.NumberStringBuilder ), this, numberStringBuilder);
    }

    @Override
    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_icu_impl_number_NumberStringBuilder$length(), this);
    }

    public int codePointCount() {
        return (int)InvokeDynamicSupport.bootstrap("codePointCount", $$robo$$android_icu_impl_number_NumberStringBuilder$codePointCount(), this);
    }

    @Override
    public char charAt(int n) {
        return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_icu_impl_number_NumberStringBuilder$charAt(int ), this, n);
    }

    public NumberFormat.Field fieldAt(int n) {
        return InvokeDynamicSupport.bootstrap("fieldAt", $$robo$$android_icu_impl_number_NumberStringBuilder$fieldAt(int ), this, n);
    }

    public int getFirstCodePoint() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstCodePoint", $$robo$$android_icu_impl_number_NumberStringBuilder$getFirstCodePoint(), this);
    }

    public int getLastCodePoint() {
        return (int)InvokeDynamicSupport.bootstrap("getLastCodePoint", $$robo$$android_icu_impl_number_NumberStringBuilder$getLastCodePoint(), this);
    }

    public int codePointAt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("codePointAt", $$robo$$android_icu_impl_number_NumberStringBuilder$codePointAt(int ), this, n);
    }

    public int codePointBefore(int n) {
        return (int)InvokeDynamicSupport.bootstrap("codePointBefore", $$robo$$android_icu_impl_number_NumberStringBuilder$codePointBefore(int ), this, n);
    }

    public NumberStringBuilder clear() {
        return InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_impl_number_NumberStringBuilder$clear(), this);
    }

    public int appendCodePoint(int n, NumberFormat.Field field) {
        return (int)InvokeDynamicSupport.bootstrap("appendCodePoint", $$robo$$android_icu_impl_number_NumberStringBuilder$appendCodePoint(int android.icu.text.NumberFormat$Field ), this, n, field);
    }

    public int insertCodePoint(int n, int n2, NumberFormat.Field field) {
        return (int)InvokeDynamicSupport.bootstrap("insertCodePoint", $$robo$$android_icu_impl_number_NumberStringBuilder$insertCodePoint(int int android.icu.text.NumberFormat$Field ), this, n, n2, field);
    }

    public int append(CharSequence charSequence, NumberFormat.Field field) {
        return (int)InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_number_NumberStringBuilder$append(java.lang.CharSequence android.icu.text.NumberFormat$Field ), this, charSequence, field);
    }

    public int insert(int n, CharSequence charSequence, NumberFormat.Field field) {
        return (int)InvokeDynamicSupport.bootstrap("insert", $$robo$$android_icu_impl_number_NumberStringBuilder$insert(int java.lang.CharSequence android.icu.text.NumberFormat$Field ), this, n, charSequence, field);
    }

    public int insert(int n, CharSequence charSequence, int n2, int n3, NumberFormat.Field field) {
        return (int)InvokeDynamicSupport.bootstrap("insert", $$robo$$android_icu_impl_number_NumberStringBuilder$insert(int java.lang.CharSequence int int android.icu.text.NumberFormat$Field ), this, n, charSequence, n2, n3, field);
    }

    public int append(char[] cArray, NumberFormat.Field[] fieldArray) {
        return (int)InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_number_NumberStringBuilder$append(char[] android.icu.text.NumberFormat$Field[] ), this, cArray, fieldArray);
    }

    public int insert(int n, char[] cArray, NumberFormat.Field[] fieldArray) {
        return (int)InvokeDynamicSupport.bootstrap("insert", $$robo$$android_icu_impl_number_NumberStringBuilder$insert(int char[] android.icu.text.NumberFormat$Field[] ), this, n, cArray, fieldArray);
    }

    public int append(NumberStringBuilder numberStringBuilder) {
        return (int)InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_number_NumberStringBuilder$append(android.icu.impl.number.NumberStringBuilder ), this, numberStringBuilder);
    }

    public int insert(int n, NumberStringBuilder numberStringBuilder) {
        return (int)InvokeDynamicSupport.bootstrap("insert", $$robo$$android_icu_impl_number_NumberStringBuilder$insert(int android.icu.impl.number.NumberStringBuilder ), this, n, numberStringBuilder);
    }

    private int prepareForInsert(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("prepareForInsert", $$robo$$android_icu_impl_number_NumberStringBuilder$prepareForInsert(int int ), this, n, n2);
    }

    private int prepareForInsertHelper(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("prepareForInsertHelper", $$robo$$android_icu_impl_number_NumberStringBuilder$prepareForInsertHelper(int int ), this, n, n2);
    }

    private int getCapacity() {
        return (int)InvokeDynamicSupport.bootstrap("getCapacity", $$robo$$android_icu_impl_number_NumberStringBuilder$getCapacity(), this);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_icu_impl_number_NumberStringBuilder$subSequence(int int ), this, n, n2);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_number_NumberStringBuilder$toString(), this);
    }

    public String toDebugString() {
        return InvokeDynamicSupport.bootstrap("toDebugString", $$robo$$android_icu_impl_number_NumberStringBuilder$toDebugString(), this);
    }

    public char[] toCharArray() {
        return InvokeDynamicSupport.bootstrap("toCharArray", $$robo$$android_icu_impl_number_NumberStringBuilder$toCharArray(), this);
    }

    public NumberFormat.Field[] toFieldArray() {
        return InvokeDynamicSupport.bootstrap("toFieldArray", $$robo$$android_icu_impl_number_NumberStringBuilder$toFieldArray(), this);
    }

    public boolean contentEquals(char[] cArray, NumberFormat.Field[] fieldArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("contentEquals", $$robo$$android_icu_impl_number_NumberStringBuilder$contentEquals(char[] android.icu.text.NumberFormat$Field[] ), this, cArray, fieldArray);
    }

    public boolean contentEquals(NumberStringBuilder numberStringBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("contentEquals", $$robo$$android_icu_impl_number_NumberStringBuilder$contentEquals(android.icu.impl.number.NumberStringBuilder ), this, numberStringBuilder);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_number_NumberStringBuilder$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_number_NumberStringBuilder$equals(java.lang.Object ), this, object);
    }

    public void populateFieldPosition(FieldPosition fieldPosition, int n) {
        InvokeDynamicSupport.bootstrap("populateFieldPosition", $$robo$$android_icu_impl_number_NumberStringBuilder$populateFieldPosition(java.text.FieldPosition int ), this, fieldPosition, n);
    }

    public AttributedCharacterIterator getIterator() {
        return InvokeDynamicSupport.bootstrap("getIterator", $$robo$$android_icu_impl_number_NumberStringBuilder$getIterator(), this);
    }

    static {
        RobolectricInternals.classInitializing(NumberStringBuilder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumberStringBuilder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

