/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.StandardPlural;
import android.icu.impl.TextTrieMap;
import android.icu.impl.number.AffixUtils;
import android.icu.impl.number.DecimalFormatProperties;
import android.icu.impl.number.DecimalQuantity_DualStorageBCD;
import android.icu.impl.number.PatternStringParser;
import android.icu.impl.number.RoundingUtils;
import android.icu.lang.UCharacter;
import android.icu.text.CurrencyPluralInfo;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NumberFormat;
import android.icu.text.UnicodeSet;
import android.icu.util.Currency;
import android.icu.util.CurrencyAmount;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Parse
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static UnicodeSet UNISET_WHITESPACE;
    private static UnicodeSet UNISET_BIDI;
    private static UnicodeSet UNISET_PERIOD_LIKE;
    private static UnicodeSet UNISET_STRICT_PERIOD_LIKE;
    private static UnicodeSet UNISET_COMMA_LIKE;
    private static UnicodeSet UNISET_STRICT_COMMA_LIKE;
    private static UnicodeSet UNISET_OTHER_GROUPING_SEPARATORS;
    private static BigDecimal MIN_LONG_AS_BIG_DECIMAL;
    private static BigDecimal MAX_LONG_AS_BIG_DECIMAL;
    protected static ThreadLocal<ParserState> threadLocalParseState;
    protected static ThreadLocal<ParsePosition> threadLocalParsePosition;
    @Deprecated
    public static UnicodeSet UNISET_PLUS;
    @Deprecated
    public static UnicodeSet UNISET_MINUS;
    public static volatile boolean DEBUGGING;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_number_Parse$__constructor__() {
    }

    private static final TextTrieMap<Byte> $$robo$$android_icu_impl_number_Parse$makeDigitTrie(String[] digitStrings) {
        boolean requiresTrie = false;
        for (int i = 0; i < 10; ++i) {
            String str = digitStrings[i];
            if (Character.charCount(Character.codePointAt(str, 0)) == str.length()) continue;
            requiresTrie = true;
            break;
        }
        if (!requiresTrie) {
            return null;
        }
        TextTrieMap<Byte> trieMap = new TextTrieMap<Byte>(false);
        for (int i = 0; i < 10; ++i) {
            trieMap.put(digitStrings[i], (byte)i);
        }
        return trieMap;
    }

    private static final Number $$robo$$android_icu_impl_number_Parse$parse(String input, DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        ParsePosition ppos = threadLocalParsePosition.get();
        ppos.setIndex(0);
        return Parse.parse(input, ppos, properties, symbols);
    }

    private static final Number $$robo$$android_icu_impl_number_Parse$parse(CharSequence input, ParsePosition ppos, DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        StateItem best = Parse._parse(input, ppos, false, properties, symbols);
        return best == null ? (Number)null : (Number)best.toNumber(properties);
    }

    private static final CurrencyAmount $$robo$$android_icu_impl_number_Parse$parseCurrency(String input, DecimalFormatProperties properties, DecimalFormatSymbols symbols) throws ParseException {
        return Parse.parseCurrency(input, null, properties, symbols);
    }

    private static final CurrencyAmount $$robo$$android_icu_impl_number_Parse$parseCurrency(CharSequence input, ParsePosition ppos, DecimalFormatProperties properties, DecimalFormatSymbols symbols) throws ParseException {
        StateItem best;
        if (ppos == null) {
            ppos = threadLocalParsePosition.get();
            ppos.setIndex(0);
            ppos.setErrorIndex(-1);
        }
        return (best = Parse._parse(input, ppos, true, properties, symbols)) == null ? null : best.toCurrencyAmount(properties);
    }

    private static final StateItem $$robo$$android_icu_impl_number_Parse$_parse(CharSequence input, ParsePosition ppos, boolean parseCurrency, DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        StateItem item;
        int i;
        int offset;
        int cp;
        if (input == null || ppos == null || properties == null || symbols == null) {
            throw new IllegalArgumentException("All arguments are required for parse.");
        }
        ParseMode mode = properties.getParseMode();
        if (mode == null) {
            mode = ParseMode.LENIENT;
        }
        boolean integerOnly = properties.getParseIntegerOnly();
        boolean ignoreExponent = properties.getParseNoExponent();
        boolean ignoreGrouping = properties.getGroupingSize() <= 0;
        ParserState state = threadLocalParseState.get().clear();
        state.properties = properties;
        state.symbols = symbols;
        state.mode = mode;
        state.parseCurrency = parseCurrency;
        state.groupingMode = properties.getParseGroupingMode();
        if (state.groupingMode == null) {
            state.groupingMode = GroupingMode.DEFAULT;
        }
        state.caseSensitive = properties.getParseCaseSensitive();
        state.decimalCp1 = Character.codePointAt(symbols.getDecimalSeparatorString(), 0);
        state.decimalCp2 = Character.codePointAt(symbols.getMonetaryDecimalSeparatorString(), 0);
        state.groupingCp1 = Character.codePointAt(symbols.getGroupingSeparatorString(), 0);
        state.groupingCp2 = Character.codePointAt(symbols.getMonetaryGroupingSeparatorString(), 0);
        state.decimalType1 = SeparatorType.fromCp(state.decimalCp1, mode);
        state.decimalType2 = SeparatorType.fromCp(state.decimalCp2, mode);
        state.groupingType1 = SeparatorType.fromCp(state.groupingCp1, mode);
        state.groupingType2 = SeparatorType.fromCp(state.groupingCp2, mode);
        StateItem initialStateItem = state.getNext().clear();
        initialStateItem.name = StateName.BEFORE_PREFIX;
        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
            state.digitTrie = Parse.makeDigitTrie(symbols.getDigitStringsLocal());
            AffixHolder.addToState(state, properties);
            if (parseCurrency) {
                CurrencyAffixPatterns.addToState(symbols.getULocale(), state);
            }
        }
        if (DEBUGGING) {
            System.out.println("Parsing: " + input);
            System.out.println(properties);
            System.out.println(state);
        }
        for (offset = ppos.getIndex(); offset < input.length(); offset += Character.charCount(cp)) {
            cp = Character.codePointAt(input, offset);
            state.swap();
            block16: for (i = 0; i < state.prevLength; ++i) {
                item = state.prevItems[i];
                if (DEBUGGING) {
                    System.out.println(":" + offset + item.id + " " + item);
                }
                switch (3.$SwitchMap$android$icu$impl$number$Parse$StateName[item.name.ordinal()]) {
                    case 1: {
                        if (mode == ParseMode.LENIENT || mode == ParseMode.FAST) {
                            Parse.acceptMinusOrPlusSign(cp, StateName.BEFORE_PREFIX, state, item, false);
                            if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        Parse.acceptIntegerDigit(cp, StateName.AFTER_INTEGER_DIGIT, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptBidi(cp, StateName.BEFORE_PREFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_PREFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptPadding(cp, StateName.BEFORE_PREFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptNan(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptInfinity(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        if (!integerOnly) {
                            Parse.acceptDecimalPoint(cp, StateName.AFTER_FRACTION_DIGIT, state, item);
                            if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptPrefix(cp, StateName.AFTER_PREFIX, state, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        if (!ignoreGrouping) {
                            Parse.acceptGrouping(cp, StateName.AFTER_INTEGER_DIGIT, state, item);
                            if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_PREFIX, state, item);
                        continue block16;
                    }
                    case 2: {
                        Parse.acceptBidi(cp, StateName.AFTER_PREFIX, state, item);
                        Parse.acceptPadding(cp, StateName.AFTER_PREFIX, state, item);
                        Parse.acceptNan(cp, StateName.BEFORE_SUFFIX, state, item);
                        Parse.acceptInfinity(cp, StateName.BEFORE_SUFFIX, state, item);
                        Parse.acceptIntegerDigit(cp, StateName.AFTER_INTEGER_DIGIT, state, item);
                        if (!integerOnly) {
                            Parse.acceptDecimalPoint(cp, StateName.AFTER_FRACTION_DIGIT, state, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.AFTER_PREFIX, state, item);
                        if (!ignoreGrouping) {
                            Parse.acceptGrouping(cp, StateName.AFTER_INTEGER_DIGIT, state, item);
                        }
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.AFTER_PREFIX, state, item);
                        continue block16;
                    }
                    case 3: {
                        Parse.acceptIntegerDigit(cp, StateName.AFTER_INTEGER_DIGIT, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        if (!integerOnly) {
                            Parse.acceptDecimalPoint(cp, StateName.AFTER_FRACTION_DIGIT, state, item);
                            if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (!ignoreGrouping) {
                            Parse.acceptGrouping(cp, StateName.AFTER_INTEGER_DIGIT, state, item);
                            if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        if (!ignoreExponent) {
                            Parse.acceptExponentSeparator(cp, StateName.AFTER_EXPONENT_SEPARATOR, state, item);
                            if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST || state.length > 0 && mode == ParseMode.FAST || !parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX, state, item);
                        continue block16;
                    }
                    case 4: {
                        Parse.acceptFractionDigit(cp, StateName.AFTER_FRACTION_DIGIT, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        if (!ignoreExponent) {
                            Parse.acceptExponentSeparator(cp, StateName.AFTER_EXPONENT_SEPARATOR, state, item);
                            if (state.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (state.length > 0 && mode == ParseMode.FAST || state.length > 0 && mode == ParseMode.FAST || !parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX, state, item);
                        continue block16;
                    }
                    case 5: {
                        Parse.acceptBidi(cp, StateName.AFTER_EXPONENT_SEPARATOR, state, item);
                        Parse.acceptMinusOrPlusSign(cp, StateName.AFTER_EXPONENT_SEPARATOR, state, item, true);
                        Parse.acceptExponentDigit(cp, StateName.AFTER_EXPONENT_DIGIT, state, item);
                        continue block16;
                    }
                    case 6: {
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state, item);
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state, item);
                        Parse.acceptExponentDigit(cp, StateName.AFTER_EXPONENT_DIGIT, state, item);
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state, item);
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state, item);
                        continue block16;
                    }
                    case 7: {
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX, state, item);
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (!ignoreExponent) {
                            Parse.acceptExponentSeparator(cp, StateName.AFTER_EXPONENT_SEPARATOR, state, item);
                        }
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX, state, item);
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX, state, item);
                        continue block16;
                    }
                    case 8: {
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state, item);
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state, item);
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state, item);
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state, item);
                        continue block16;
                    }
                    case 9: {
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST || !parseCurrency) continue block16;
                        Parse.acceptBidi(cp, StateName.AFTER_SUFFIX, state, item);
                        Parse.acceptPadding(cp, StateName.AFTER_SUFFIX, state, item);
                        Parse.acceptWhitespace(cp, StateName.AFTER_SUFFIX, state, item);
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.AFTER_SUFFIX, state, item);
                        continue block16;
                    }
                    case 10: {
                        Parse.acceptCurrencyOffset(cp, state, item);
                        continue block16;
                    }
                    case 11: {
                        Parse.acceptDigitTrieOffset(cp, state, item);
                        continue block16;
                    }
                    case 12: {
                        Parse.acceptStringOffset(cp, state, item);
                        continue block16;
                    }
                    case 13: {
                        Parse.acceptAffixPatternOffset(cp, state, item);
                    }
                }
            }
            if (state.length != 0) continue;
            state.swapBack();
            break;
        }
        if (state.length == 0) {
            if (DEBUGGING) {
                System.out.println("No matches found");
                System.out.println("- - - - - - - - - -");
            }
            return null;
        }
        StateItem best = null;
        block17: for (i = 0; i < state.length; ++i) {
            item = state.items[i];
            if (DEBUGGING) {
                System.out.println(":end " + item);
            }
            if (!item.hasNumber()) {
                if (!DEBUGGING) continue;
                System.out.println("-> rejected due to no number value");
                continue;
            }
            if (mode == ParseMode.STRICT) {
                int numGroupingRegions;
                boolean hasEmptyAffix;
                boolean sawPrefix = item.sawPrefix || item.affix != null && item.affix.p.isEmpty();
                boolean sawSuffix = item.sawSuffix || item.affix != null && item.affix.s.isEmpty();
                boolean bl = hasEmptyAffix = state.affixHolders.contains(AffixHolder.EMPTY_POSITIVE) || state.affixHolders.contains(AffixHolder.EMPTY_NEGATIVE);
                if (!(sawPrefix && sawSuffix || !sawPrefix && !sawSuffix && hasEmptyAffix)) {
                    if (!DEBUGGING) continue;
                    System.out.println("-> rejected due to mismatched prefix/suffix");
                    continue;
                }
                if (properties.getMinimumExponentDigits() > 0 && !item.sawExponentDigit) {
                    if (!DEBUGGING) continue;
                    System.out.println("-> reject due to lack of exponent");
                    continue;
                }
                int grouping1 = properties.getGroupingSize();
                int grouping2 = properties.getSecondaryGroupingSize();
                grouping1 = grouping1 > 0 ? grouping1 : grouping2;
                grouping2 = grouping2 > 0 ? grouping2 : grouping1;
                long groupingWidths = item.groupingWidths;
                for (numGroupingRegions = 16 - Long.numberOfLeadingZeros(groupingWidths) / 4; numGroupingRegions > 1 && (groupingWidths & 0xFL) == 0L; --numGroupingRegions) {
                    if (item.sawDecimalPoint) {
                        if (!DEBUGGING) continue block17;
                        System.out.println("-> rejected due to decimal point after grouping");
                        continue block17;
                    }
                    groupingWidths >>>= 4;
                }
                if (grouping1 > 0 && numGroupingRegions > 1) {
                    if ((groupingWidths & 0xFL) != (long)grouping1) {
                        if (!DEBUGGING) continue;
                        System.out.println("-> rejected due to first grouping violation");
                        continue;
                    }
                    if ((groupingWidths >>> (numGroupingRegions - 1) * 4 & 0xFL) > (long)grouping2) {
                        if (!DEBUGGING) continue;
                        System.out.println("-> rejected due to final grouping violation");
                        continue;
                    }
                    for (int j = 1; j < numGroupingRegions - 1; ++j) {
                        if ((groupingWidths >>> j * 4 & 0xFL) == (long)grouping2) continue;
                        if (!DEBUGGING) continue block17;
                        System.out.println("-> rejected due to inner grouping violation");
                        continue block17;
                    }
                }
            }
            if (properties.getDecimalPatternMatchRequired() && item.sawDecimalPoint != (properties.getDecimalSeparatorAlwaysShown() || properties.getMaximumFractionDigits() != 0)) {
                if (!DEBUGGING) continue;
                System.out.println("-> rejected due to decimal point violation");
                continue;
            }
            if (parseCurrency && !item.sawCurrency) {
                if (!DEBUGGING) continue;
                System.out.println("-> rejected due to lack of currency");
                continue;
            }
            if (best == null) {
                best = item;
                continue;
            }
            if (item.score > best.score) {
                best = item;
                continue;
            }
            if (item.trailingCount >= best.trailingCount) continue;
            best = item;
        }
        if (DEBUGGING) {
            System.out.println("- - - - - - - - - -");
        }
        if (best != null) {
            ppos.setIndex(offset - best.trailingCount);
            return best;
        }
        ppos.setErrorIndex(offset);
        return null;
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptWhitespace(int cp, StateName nextName, ParserState state, StateItem item) {
        if (UNISET_WHITESPACE.contains(cp)) {
            state.getNext().copyFrom(item, nextName, cp);
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptBidi(int cp, StateName nextName, ParserState state, StateItem item) {
        if (UNISET_BIDI.contains(cp)) {
            state.getNext().copyFrom(item, nextName, cp);
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptPadding(int cp, StateName nextName, ParserState state, StateItem item) {
        String padding = state.properties.getPadString();
        if (padding == null || padding.length() == 0) {
            return;
        }
        int referenceCp = Character.codePointAt(padding, 0);
        if (cp == referenceCp) {
            state.getNext().copyFrom(item, nextName, cp);
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptIntegerDigit(int cp, StateName nextName, ParserState state, StateItem item) {
        Parse.acceptDigitHelper(cp, nextName, state, item, DigitType.INTEGER);
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptFractionDigit(int cp, StateName nextName, ParserState state, StateItem item) {
        Parse.acceptDigitHelper(cp, nextName, state, item, DigitType.FRACTION);
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptExponentDigit(int cp, StateName nextName, ParserState state, StateItem item) {
        Parse.acceptDigitHelper(cp, nextName, state, item, DigitType.EXPONENT);
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptDigitHelper(int cp, StateName nextName, ParserState state, StateItem item, DigitType type) {
        int digit = UCharacter.digit(cp, 10);
        StateItem next = null;
        if (digit >= 0) {
            next = state.getNext().copyFrom(item, nextName, -1);
        }
        if (digit < 0 && (state.mode == ParseMode.LENIENT || state.mode == ParseMode.STRICT)) {
            if (state.digitTrie == null) {
                for (int d = 0; d < 10; d = (int)((byte)(d + 1))) {
                    int referenceCp = Character.codePointAt(state.symbols.getDigitStringsLocal()[d], 0);
                    if (cp != referenceCp) continue;
                    digit = d;
                    next = state.getNext().copyFrom(item, nextName, -1);
                }
            } else {
                Parse.acceptDigitTrie(cp, nextName, state, item, type);
            }
        }
        Parse.recordDigit(next, (byte)digit, type);
    }

    private static final void $$robo$$android_icu_impl_number_Parse$recordDigit(StateItem next, byte digit, DigitType type) {
        if (next == null) {
            return;
        }
        next.appendDigit(digit, type);
        if (type == DigitType.INTEGER && (next.groupingWidths & 0xFL) < 15L) {
            ++next.groupingWidths;
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptMinusOrPlusSign(int cp, StateName nextName, ParserState state, StateItem item, boolean exponent) {
        Parse.acceptMinusSign(cp, nextName, null, state, item, exponent);
        Parse.acceptPlusSign(cp, nextName, null, state, item, exponent);
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptMinusSign(int cp, StateName returnTo1, StateName returnTo2, ParserState state, StateItem item, boolean exponent) {
        if (UNISET_MINUS.contains(cp)) {
            StateItem next = state.getNext().copyFrom(item, returnTo1, -1);
            next.returnTo1 = returnTo2;
            if (exponent) {
                next.sawNegativeExponent = true;
            } else {
                next.sawNegative = true;
            }
            return 1L << state.lastInsertedIndex();
        }
        return 0L;
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptPlusSign(int cp, StateName returnTo1, StateName returnTo2, ParserState state, StateItem item, boolean exponent) {
        if (UNISET_PLUS.contains(cp)) {
            StateItem next = state.getNext().copyFrom(item, returnTo1, -1);
            next.returnTo1 = returnTo2;
            return 1L << state.lastInsertedIndex();
        }
        return 0L;
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptGrouping(int cp, StateName nextName, ParserState state, StateItem item) {
        if (item.groupingCp == -1) {
            SeparatorType cpType = SeparatorType.fromCp(cp, state.mode);
            if (cp != state.groupingCp1 && cp != state.groupingCp2) {
                if (cpType == SeparatorType.UNKNOWN) {
                    return;
                }
                if (state.groupingMode == GroupingMode.RESTRICTED) {
                    if (cpType != state.groupingType1 || cpType != state.groupingType2) {
                        return;
                    }
                } else {
                    if (cpType == SeparatorType.COMMA_LIKE && (state.decimalType1 == SeparatorType.COMMA_LIKE || state.decimalType2 == SeparatorType.COMMA_LIKE)) {
                        return;
                    }
                    if (cpType == SeparatorType.PERIOD_LIKE && (state.decimalType1 == SeparatorType.PERIOD_LIKE || state.decimalType2 == SeparatorType.PERIOD_LIKE)) {
                        return;
                    }
                }
            }
            StateItem next = state.getNext().copyFrom(item, nextName, cp);
            next.groupingCp = cp;
            next.groupingWidths <<= 4;
        } else if (cp == item.groupingCp) {
            StateItem next = state.getNext().copyFrom(item, nextName, cp);
            next.groupingWidths <<= 4;
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptDecimalPoint(int cp, StateName nextName, ParserState state, StateItem item) {
        if (cp == item.groupingCp) {
            return;
        }
        SeparatorType cpType = SeparatorType.fromCp(cp, state.mode);
        if (cpType != state.decimalType1 && cpType != state.decimalType2) {
            return;
        }
        if ((cpType == SeparatorType.OTHER_GROUPING || cpType == SeparatorType.UNKNOWN) && cp != state.decimalCp1 && cp != state.decimalCp2) {
            return;
        }
        StateItem next = state.getNext().copyFrom(item, nextName, -1);
        next.sawDecimalPoint = true;
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptNan(int cp, StateName nextName, ParserState state, StateItem item) {
        String nan = state.symbols.getNaN();
        long added = Parse.acceptString(cp, nextName, null, state, item, nan, 0, false);
        int i = Long.numberOfTrailingZeros(added);
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                state.getItem((int)i).sawNaN = true;
            }
            ++i;
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptInfinity(int cp, StateName nextName, ParserState state, StateItem item) {
        String inf = state.symbols.getInfinity();
        long added = Parse.acceptString(cp, nextName, null, state, item, inf, 0, false);
        int i = Long.numberOfTrailingZeros(added);
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                state.getItem((int)i).sawInfinity = true;
            }
            ++i;
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptExponentSeparator(int cp, StateName nextName, ParserState state, StateItem item) {
        String exp = state.symbols.getExponentSeparator();
        Parse.acceptString(cp, nextName, null, state, item, exp, 0, true);
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptPrefix(int cp, StateName nextName, ParserState state, StateItem item) {
        for (AffixHolder holder : state.affixHolders) {
            Parse.acceptAffixHolder(cp, nextName, state, item, holder, true);
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptSuffix(int cp, StateName nextName, ParserState state, StateItem item) {
        if (item.affix != null) {
            Parse.acceptAffixHolder(cp, nextName, state, item, item.affix, false);
        } else {
            for (AffixHolder holder : state.affixHolders) {
                Parse.acceptAffixHolder(cp, nextName, state, item, holder, false);
            }
        }
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptAffixHolder(int cp, StateName nextName, ParserState state, StateItem item, AffixHolder holder, boolean prefix) {
        if (holder == null) {
            return;
        }
        String str = prefix ? holder.p : holder.s;
        long added = holder.strings ? Parse.acceptString(cp, nextName, null, state, item, str, 0, false) : Parse.acceptAffixPattern(cp, nextName, state, item, str, AffixUtils.nextToken(0L, str));
        int i = Long.numberOfTrailingZeros(added);
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                StateItem next = state.getItem(i);
                next.affix = holder;
                if (prefix) {
                    next.sawPrefix = true;
                }
                if (!prefix) {
                    next.sawSuffix = true;
                }
                if (holder.negative) {
                    next.sawNegative = true;
                }
                next.score += 10;
                if (!holder.negative) {
                    ++next.score;
                }
                if (!next.sawPrefix && holder.p.isEmpty()) {
                    next.score += 5;
                }
                if (!next.sawSuffix && holder.s.isEmpty()) {
                    next.score += 5;
                }
            }
            ++i;
        }
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptStringOffset(int cp, ParserState state, StateItem item) {
        return Parse.acceptString(cp, item.returnTo1, item.returnTo2, state, item, item.currentString, item.currentOffset, item.currentTrailing);
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptString(int cp, StateName ret1, StateName ret2, ParserState state, StateItem item, CharSequence str, int offset, boolean trailing) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        return Parse.acceptStringOrAffixPatternWithIgnorables(cp, ret1, ret2, state, item, str, offset, trailing, true);
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptStringNonIgnorable(int cp, StateName ret1, StateName ret2, ParserState state, StateItem item, CharSequence str, boolean trailing, int referenceCp, long firstOffsetOrTag, long nextOffsetOrTag) {
        long added = 0L;
        int firstOffset = (int)firstOffsetOrTag;
        int nextOffset = (int)nextOffsetOrTag;
        if (Parse.codePointEquals(referenceCp, cp, state)) {
            if (firstOffset < str.length()) {
                added |= Parse.acceptStringHelper(cp, ret1, ret2, state, item, str, firstOffset, trailing);
            }
            if (nextOffset >= str.length()) {
                added |= Parse.acceptStringHelper(cp, ret1, ret2, state, item, str, nextOffset, trailing);
            }
            return added;
        }
        return 0L;
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptStringHelper(int cp, StateName returnTo1, StateName returnTo2, ParserState state, StateItem item, CharSequence str, int newOffset, boolean trailing) {
        StateItem next = state.getNext().copyFrom(item, null, cp);
        ++next.score;
        if (newOffset < str.length()) {
            next.name = StateName.INSIDE_STRING;
            next.returnTo1 = returnTo1;
            next.returnTo2 = returnTo2;
            next.currentString = str;
            next.currentOffset = newOffset;
            next.currentTrailing = trailing;
        } else {
            next.name = returnTo1;
            if (!trailing) {
                next.trailingCount = 0;
            }
            next.returnTo1 = returnTo2;
            next.returnTo2 = null;
        }
        return 1L << state.lastInsertedIndex();
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptAffixPatternOffset(int cp, ParserState state, StateItem item) {
        return Parse.acceptAffixPattern(cp, item.returnTo1, state, item, item.currentAffixPattern, item.currentStepwiseParserTag);
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptAffixPattern(int cp, StateName ret1, ParserState state, StateItem item, CharSequence str, long tag) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        return Parse.acceptStringOrAffixPatternWithIgnorables(cp, ret1, null, state, item, str, tag, false, false);
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptAffixPatternNonIgnorable(int cp, StateName returnTo, ParserState state, StateItem item, CharSequence str, int typeOrCp, long firstTag, long nextTag) {
        boolean resolvedCurrency;
        boolean resolvedPlusSign;
        boolean resolvedMinusSign;
        String resolvedStr;
        int resolvedCp;
        block31: {
            block30: {
                resolvedCp = -1;
                resolvedStr = null;
                resolvedMinusSign = false;
                resolvedPlusSign = false;
                resolvedCurrency = false;
                if (typeOrCp >= 0) break block30;
                switch (typeOrCp) {
                    case -1: {
                        resolvedMinusSign = true;
                        break block31;
                    }
                    case -2: {
                        resolvedPlusSign = true;
                        break block31;
                    }
                    case -3: {
                        resolvedStr = state.symbols.getPercentString();
                        if (resolvedStr.length() != 1 || resolvedStr.charAt(0) != '%') {
                            resolvedCp = 37;
                        }
                        break block31;
                    }
                    case -4: {
                        resolvedStr = state.symbols.getPerMillString();
                        if (resolvedStr.length() != 1 || resolvedStr.charAt(0) != '\u2030') {
                            resolvedCp = 8240;
                        }
                        break block31;
                    }
                    case -15: 
                    case -9: 
                    case -8: 
                    case -7: 
                    case -6: 
                    case -5: {
                        resolvedCurrency = true;
                        break block31;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            resolvedCp = typeOrCp;
        }
        long added = 0L;
        if (resolvedCp >= 0 && Parse.codePointEquals(cp, resolvedCp, state)) {
            if (firstTag >= 0L) {
                added |= Parse.acceptAffixPatternHelper(cp, returnTo, state, item, str, firstTag);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptAffixPatternHelper(cp, returnTo, state, item, str, nextTag);
            }
        }
        if (resolvedMinusSign) {
            if (firstTag >= 0L) {
                added |= Parse.acceptMinusSign(cp, StateName.INSIDE_AFFIX_PATTERN, returnTo, state, item, false);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptMinusSign(cp, returnTo, null, state, item, false);
            }
            if (added == 0L) {
                String mss = state.symbols.getMinusSignString();
                int mssCp = Character.codePointAt(mss, 0);
                if (mss.length() != Character.charCount(mssCp) || !UNISET_MINUS.contains(mssCp)) {
                    resolvedStr = mss;
                }
            }
        }
        if (resolvedPlusSign) {
            if (firstTag >= 0L) {
                added |= Parse.acceptPlusSign(cp, StateName.INSIDE_AFFIX_PATTERN, returnTo, state, item, false);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptPlusSign(cp, returnTo, null, state, item, false);
            }
            if (added == 0L) {
                String pss = state.symbols.getPlusSignString();
                int pssCp = Character.codePointAt(pss, 0);
                if (pss.length() != Character.charCount(pssCp) || !UNISET_MINUS.contains(pssCp)) {
                    resolvedStr = pss;
                }
            }
        }
        if (resolvedStr != null) {
            if (firstTag >= 0L) {
                added |= Parse.acceptString(cp, StateName.INSIDE_AFFIX_PATTERN, returnTo, state, item, resolvedStr, 0, false);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptString(cp, returnTo, null, state, item, resolvedStr, 0, false);
            }
        }
        if (resolvedCurrency) {
            if (firstTag >= 0L) {
                added |= Parse.acceptCurrency(cp, StateName.INSIDE_AFFIX_PATTERN, returnTo, state, item);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptCurrency(cp, returnTo, null, state, item);
            }
        }
        int i = Long.numberOfTrailingZeros(added);
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                state.getItem((int)i).currentAffixPattern = str;
                state.getItem((int)i).currentStepwiseParserTag = firstTag;
            }
            ++i;
        }
        return added;
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptAffixPatternHelper(int cp, StateName returnTo, ParserState state, StateItem item, CharSequence str, long newTag) {
        StateItem next = state.getNext().copyFrom(item, null, cp);
        ++next.score;
        if (newTag >= 0L) {
            next.name = StateName.INSIDE_AFFIX_PATTERN;
            next.returnTo1 = returnTo;
            next.currentAffixPattern = str;
            next.currentStepwiseParserTag = newTag;
        } else {
            next.name = returnTo;
            next.trailingCount = 0;
            next.returnTo1 = null;
        }
        return 1L << state.lastInsertedIndex();
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptStringOrAffixPatternWithIgnorables(int cp, StateName ret1, StateName ret2, ParserState state, StateItem item, CharSequence str, long offsetOrTag, boolean trailing, boolean isString) {
        int nextTypeOrCp;
        int typeOrCp;
        int n = typeOrCp = isString ? Character.codePointAt(str, (int)offsetOrTag) : AffixUtils.getTypeOrCp(offsetOrTag);
        if (Parse.isIgnorable(typeOrCp, state)) {
            long prevOffsetOrTag;
            nextTypeOrCp = typeOrCp;
            long nextOffsetOrTag = offsetOrTag;
            long firstOffsetOrTag = 0L;
            do {
                prevOffsetOrTag = nextOffsetOrTag;
                long l = nextOffsetOrTag = isString ? nextOffsetOrTag + (long)Character.charCount(nextTypeOrCp) : AffixUtils.nextToken(nextOffsetOrTag, str);
                if (firstOffsetOrTag == 0L) {
                    firstOffsetOrTag = nextOffsetOrTag;
                }
                if (!(isString ? nextOffsetOrTag >= (long)str.length() : nextOffsetOrTag < 0L)) continue;
                nextTypeOrCp = Integer.MIN_VALUE;
                break;
            } while (Parse.isIgnorable(nextTypeOrCp = isString ? Character.codePointAt(str, (int)nextOffsetOrTag) : AffixUtils.getTypeOrCp(nextOffsetOrTag), state));
            if (nextTypeOrCp == Integer.MIN_VALUE) {
                if (Parse.codePointEquals(cp, typeOrCp, state)) {
                    long added = 0L;
                    added |= isString ? Parse.acceptStringHelper(cp, ret1, ret2, state, item, str, (int)firstOffsetOrTag, trailing) : Parse.acceptAffixPatternHelper(cp, ret1, state, item, str, firstOffsetOrTag);
                    if (firstOffsetOrTag != nextOffsetOrTag) {
                        added |= isString ? Parse.acceptStringHelper(cp, ret1, ret2, state, item, str, (int)nextOffsetOrTag, trailing) : Parse.acceptAffixPatternHelper(cp, ret1, state, item, str, nextOffsetOrTag);
                    }
                    return added;
                }
                return 0L;
            }
            if (Parse.isIgnorable(cp, state)) {
                return isString ? Parse.acceptStringHelper(cp, ret1, ret2, state, item, str, (int)prevOffsetOrTag, trailing) : Parse.acceptAffixPatternHelper(cp, ret1, state, item, str, prevOffsetOrTag);
            }
            if (!$assertionsDisabled && nextTypeOrCp == Integer.MIN_VALUE) {
                throw new AssertionError();
            }
            typeOrCp = nextTypeOrCp;
            offsetOrTag = nextOffsetOrTag;
        }
        if (!$assertionsDisabled && Parse.isIgnorable(typeOrCp, state)) {
            throw new AssertionError();
        }
        nextTypeOrCp = typeOrCp;
        long nextOffsetOrTag = offsetOrTag;
        long firstOffsetOrTag = 0L;
        do {
            long l = nextOffsetOrTag = isString ? nextOffsetOrTag + (long)Character.charCount(nextTypeOrCp) : AffixUtils.nextToken(nextOffsetOrTag, str);
            if (firstOffsetOrTag == 0L) {
                firstOffsetOrTag = nextOffsetOrTag;
            }
            if (!(isString ? nextOffsetOrTag >= (long)str.length() : nextOffsetOrTag < 0L)) continue;
            nextTypeOrCp = -1;
            break;
        } while (Parse.isIgnorable(nextTypeOrCp = isString ? Character.codePointAt(str, (int)nextOffsetOrTag) : AffixUtils.getTypeOrCp(nextOffsetOrTag), state));
        return isString ? Parse.acceptStringNonIgnorable(cp, ret1, ret2, state, item, str, trailing, typeOrCp, firstOffsetOrTag, nextOffsetOrTag) : Parse.acceptAffixPatternNonIgnorable(cp, ret1, state, item, str, typeOrCp, firstOffsetOrTag, nextOffsetOrTag);
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptCurrency(int cp, StateName nextName, ParserState state, StateItem item) {
        Parse.acceptCurrency(cp, nextName, null, state, item);
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptCurrency(int cp, StateName returnTo1, StateName returnTo2, ParserState state, StateItem item) {
        String str2;
        String str1;
        if (item.sawCurrency) {
            return 0L;
        }
        long added = 0L;
        Currency currency = state.properties.getCurrency();
        if (currency != null) {
            str1 = currency.getName(state.symbols.getULocale(), 0, null);
            str2 = currency.getCurrencyCode();
        } else {
            currency = state.symbols.getCurrency();
            str1 = state.symbols.getCurrencySymbol();
            str2 = state.symbols.getInternationalCurrencySymbol();
        }
        added |= Parse.acceptString(cp, returnTo1, returnTo2, state, item, str1, 0, false);
        int i = Long.numberOfTrailingZeros(added |= Parse.acceptString(cp, returnTo1, returnTo2, state, item, str2, 0, false));
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                state.getItem((int)i).sawCurrency = true;
                state.getItem((int)i).isoCode = str2;
            }
            ++i;
        }
        if (state.parseCurrency) {
            ULocale uloc = state.symbols.getULocale();
            TextTrieMap.ParseState trie1 = Currency.openParseState(uloc, cp, 1);
            TextTrieMap.ParseState trie2 = Currency.openParseState(uloc, cp, 0);
            added |= Parse.acceptCurrencyHelper(cp, returnTo1, returnTo2, state, item, trie1);
            added |= Parse.acceptCurrencyHelper(cp, returnTo1, returnTo2, state, item, trie2);
        }
        return added;
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptCurrencyOffset(int cp, ParserState state, StateItem item) {
        Parse.acceptCurrencyHelper(cp, item.returnTo1, item.returnTo2, state, item, item.currentCurrencyTrieState);
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptCurrencyHelper(int cp, StateName returnTo1, StateName returnTo2, ParserState state, StateItem item, TextTrieMap.ParseState trieState) {
        StateItem next;
        if (trieState == null) {
            return 0L;
        }
        trieState.accept(cp);
        long added = 0L;
        Iterator currentMatches = trieState.getCurrentMatches();
        if (currentMatches != null) {
            next = state.getNext().copyFrom(item, returnTo1, -1);
            next.returnTo1 = returnTo2;
            next.returnTo2 = null;
            next.sawCurrency = true;
            next.isoCode = ((Currency.CurrencyStringInfo)currentMatches.next()).getISOCode();
            added |= 1L << state.lastInsertedIndex();
        }
        if (!trieState.atEnd()) {
            next = state.getNext().copyFrom(item, StateName.INSIDE_CURRENCY, -1);
            next.returnTo1 = returnTo1;
            next.returnTo2 = returnTo2;
            next.currentCurrencyTrieState = trieState;
            added |= 1L << state.lastInsertedIndex();
        }
        return added;
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptDigitTrie(int cp, StateName nextName, ParserState state, StateItem item, DigitType type) {
        if (!$assertionsDisabled && state.digitTrie == null) {
            throw new AssertionError();
        }
        TextTrieMap.ParseState trieState = state.digitTrie.openParseState(cp);
        if (trieState == null) {
            return 0L;
        }
        return Parse.acceptDigitTrieHelper(cp, nextName, state, item, type, trieState);
    }

    private static final void $$robo$$android_icu_impl_number_Parse$acceptDigitTrieOffset(int cp, ParserState state, StateItem item) {
        Parse.acceptDigitTrieHelper(cp, item.returnTo1, state, item, item.currentDigitType, item.currentDigitTrieState);
    }

    private static final long $$robo$$android_icu_impl_number_Parse$acceptDigitTrieHelper(int cp, StateName returnTo1, ParserState state, StateItem item, DigitType type, TextTrieMap.ParseState trieState) {
        if (trieState == null) {
            return 0L;
        }
        trieState.accept(cp);
        long added = 0L;
        Iterator currentMatches = trieState.getCurrentMatches();
        if (currentMatches != null) {
            byte digit = (Byte)currentMatches.next();
            StateItem next = state.getNext().copyFrom(item, returnTo1, -1);
            next.returnTo1 = null;
            Parse.recordDigit(next, digit, type);
            added |= 1L << state.lastInsertedIndex();
        }
        if (!trieState.atEnd()) {
            StateItem next = state.getNext().copyFrom(item, StateName.INSIDE_DIGIT, -1);
            next.returnTo1 = returnTo1;
            next.currentDigitTrieState = trieState;
            next.currentDigitType = type;
            added |= 1L << state.lastInsertedIndex();
        }
        return added;
    }

    private static final boolean $$robo$$android_icu_impl_number_Parse$codePointEquals(int cp1, int cp2, ParserState state) {
        if (!state.caseSensitive) {
            cp1 = UCharacter.foldCase(cp1, true);
            cp2 = UCharacter.foldCase(cp2, true);
        }
        return cp1 == cp2;
    }

    private static final boolean $$robo$$android_icu_impl_number_Parse$isIgnorable(int cp, ParserState state) {
        if (cp < 0) {
            return false;
        }
        if (UNISET_BIDI.contains(cp)) {
            return true;
        }
        return state.mode == ParseMode.LENIENT && UNISET_WHITESPACE.contains(cp);
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !Parse.class.desiredAssertionStatus();
        UNISET_WHITESPACE = new UnicodeSet("[[:Zs:][\\u0009]]").freeze();
        UNISET_BIDI = new UnicodeSet("[[\\u200E\\u200F\\u061C]]").freeze();
        UNISET_PERIOD_LIKE = new UnicodeSet("[.\\u2024\\u3002\\uFE12\\uFE52\\uFF0E\\uFF61]").freeze();
        UNISET_STRICT_PERIOD_LIKE = new UnicodeSet("[.\\u2024\\uFE52\\uFF0E\\uFF61]").freeze();
        UNISET_COMMA_LIKE = new UnicodeSet("[,\\u060C\\u066B\\u3001\\uFE10\\uFE11\\uFE50\\uFE51\\uFF0C\\uFF64]").freeze();
        UNISET_STRICT_COMMA_LIKE = new UnicodeSet("[,\\u066B\\uFE10\\uFE50\\uFF0C]").freeze();
        UNISET_OTHER_GROUPING_SEPARATORS = new UnicodeSet("[\\ '\\u00A0\\u066C\\u2000-\\u200A\\u2018\\u2019\\u202F\\u205F\\u3000\\uFF07]").freeze();
        MIN_LONG_AS_BIG_DECIMAL = new BigDecimal(Long.MIN_VALUE);
        MAX_LONG_AS_BIG_DECIMAL = new BigDecimal(Long.MAX_VALUE);
        threadLocalParseState = new ThreadLocal<ParserState>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_impl_number_Parse_1$__constructor__() {
            }

            private final ParserState $$robo$$android_icu_impl_number_Parse_1$initialValue() {
                return new ParserState();
            }

            private void __constructor__() {
                this.$$robo$$android_icu_impl_number_Parse_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_1$__constructor__(), this);
            }

            @Override
            protected ParserState initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_icu_impl_number_Parse_1$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        threadLocalParsePosition = new ThreadLocal<ParsePosition>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_impl_number_Parse_2$__constructor__() {
            }

            private final ParsePosition $$robo$$android_icu_impl_number_Parse_2$initialValue() {
                return new ParsePosition(0);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_impl_number_Parse_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_2$__constructor__(), this);
            }

            @Override
            protected ParsePosition initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_icu_impl_number_Parse_2$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        UNISET_PLUS = new UnicodeSet(43, 43, 8314, 8314, 8330, 8330, 10133, 10133, 64297, 64297, 65122, 65122, 65291, 65291).freeze();
        UNISET_MINUS = new UnicodeSet(45, 45, 8315, 8315, 8331, 8331, 8722, 8722, 10134, 10134, 65123, 65123, 65293, 65293).freeze();
        DEBUGGING = false;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_number_Parse$__constructor__();
    }

    public Parse() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse$__constructor__(), this);
    }

    static TextTrieMap<Byte> makeDigitTrie(String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("makeDigitTrie", $$robo$$android_icu_impl_number_Parse$makeDigitTrie(java.lang.String[] ), (String[])stringArray);
    }

    public static Number parse(String string2, DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_icu_impl_number_Parse$parse(java.lang.String android.icu.impl.number.DecimalFormatProperties android.icu.text.DecimalFormatSymbols ), (String)string2, (DecimalFormatProperties)decimalFormatProperties, (DecimalFormatSymbols)decimalFormatSymbols);
    }

    public static Number parse(CharSequence charSequence, ParsePosition parsePosition, DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_icu_impl_number_Parse$parse(java.lang.CharSequence java.text.ParsePosition android.icu.impl.number.DecimalFormatProperties android.icu.text.DecimalFormatSymbols ), (CharSequence)charSequence, (ParsePosition)parsePosition, (DecimalFormatProperties)decimalFormatProperties, (DecimalFormatSymbols)decimalFormatSymbols);
    }

    public static CurrencyAmount parseCurrency(String string2, DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseCurrency", $$robo$$android_icu_impl_number_Parse$parseCurrency(java.lang.String android.icu.impl.number.DecimalFormatProperties android.icu.text.DecimalFormatSymbols ), (String)string2, (DecimalFormatProperties)decimalFormatProperties, (DecimalFormatSymbols)decimalFormatSymbols);
    }

    public static CurrencyAmount parseCurrency(CharSequence charSequence, ParsePosition parsePosition, DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseCurrency", $$robo$$android_icu_impl_number_Parse$parseCurrency(java.lang.CharSequence java.text.ParsePosition android.icu.impl.number.DecimalFormatProperties android.icu.text.DecimalFormatSymbols ), (CharSequence)charSequence, (ParsePosition)parsePosition, (DecimalFormatProperties)decimalFormatProperties, (DecimalFormatSymbols)decimalFormatSymbols);
    }

    private static StateItem _parse(CharSequence charSequence, ParsePosition parsePosition, boolean bl, DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols) {
        return InvokeDynamicSupport.bootstrapStatic("_parse", $$robo$$android_icu_impl_number_Parse$_parse(java.lang.CharSequence java.text.ParsePosition boolean android.icu.impl.number.DecimalFormatProperties android.icu.text.DecimalFormatSymbols ), (CharSequence)charSequence, (ParsePosition)parsePosition, (boolean)bl, (DecimalFormatProperties)decimalFormatProperties, (DecimalFormatSymbols)decimalFormatSymbols);
    }

    private static void acceptWhitespace(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptWhitespace", $$robo$$android_icu_impl_number_Parse$acceptWhitespace(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptBidi(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptBidi", $$robo$$android_icu_impl_number_Parse$acceptBidi(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptPadding(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptPadding", $$robo$$android_icu_impl_number_Parse$acceptPadding(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptIntegerDigit(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptIntegerDigit", $$robo$$android_icu_impl_number_Parse$acceptIntegerDigit(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptFractionDigit(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptFractionDigit", $$robo$$android_icu_impl_number_Parse$acceptFractionDigit(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptExponentDigit(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptExponentDigit", $$robo$$android_icu_impl_number_Parse$acceptExponentDigit(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptDigitHelper(int n, StateName stateName, ParserState parserState, StateItem stateItem, DigitType digitType) {
        InvokeDynamicSupport.bootstrapStatic("acceptDigitHelper", $$robo$$android_icu_impl_number_Parse$acceptDigitHelper(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem android.icu.impl.number.Parse$DigitType ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem, (DigitType)digitType);
    }

    private static void recordDigit(StateItem stateItem, byte by, DigitType digitType) {
        InvokeDynamicSupport.bootstrapStatic("recordDigit", $$robo$$android_icu_impl_number_Parse$recordDigit(android.icu.impl.number.Parse$StateItem byte android.icu.impl.number.Parse$DigitType ), (StateItem)stateItem, (byte)by, (DigitType)digitType);
    }

    private static void acceptMinusOrPlusSign(int n, StateName stateName, ParserState parserState, StateItem stateItem, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("acceptMinusOrPlusSign", $$robo$$android_icu_impl_number_Parse$acceptMinusOrPlusSign(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem boolean ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem, (boolean)bl);
    }

    private static long acceptMinusSign(int n, StateName stateName, StateName stateName2, ParserState parserState, StateItem stateItem, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptMinusSign", $$robo$$android_icu_impl_number_Parse$acceptMinusSign(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem boolean ), (int)n, (StateName)stateName, (StateName)stateName2, (ParserState)parserState, (StateItem)stateItem, (boolean)bl);
    }

    private static long acceptPlusSign(int n, StateName stateName, StateName stateName2, ParserState parserState, StateItem stateItem, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptPlusSign", $$robo$$android_icu_impl_number_Parse$acceptPlusSign(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem boolean ), (int)n, (StateName)stateName, (StateName)stateName2, (ParserState)parserState, (StateItem)stateItem, (boolean)bl);
    }

    private static void acceptGrouping(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptGrouping", $$robo$$android_icu_impl_number_Parse$acceptGrouping(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptDecimalPoint(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptDecimalPoint", $$robo$$android_icu_impl_number_Parse$acceptDecimalPoint(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptNan(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptNan", $$robo$$android_icu_impl_number_Parse$acceptNan(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptInfinity(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptInfinity", $$robo$$android_icu_impl_number_Parse$acceptInfinity(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptExponentSeparator(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptExponentSeparator", $$robo$$android_icu_impl_number_Parse$acceptExponentSeparator(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptPrefix(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptPrefix", $$robo$$android_icu_impl_number_Parse$acceptPrefix(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptSuffix(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptSuffix", $$robo$$android_icu_impl_number_Parse$acceptSuffix(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptAffixHolder(int n, StateName stateName, ParserState parserState, StateItem stateItem, AffixHolder affixHolder, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("acceptAffixHolder", $$robo$$android_icu_impl_number_Parse$acceptAffixHolder(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem android.icu.impl.number.Parse$AffixHolder boolean ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem, (AffixHolder)affixHolder, (boolean)bl);
    }

    private static long acceptStringOffset(int n, ParserState parserState, StateItem stateItem) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptStringOffset", $$robo$$android_icu_impl_number_Parse$acceptStringOffset(int android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (ParserState)parserState, (StateItem)stateItem);
    }

    private static long acceptString(int n, StateName stateName, StateName stateName2, ParserState parserState, StateItem stateItem, CharSequence charSequence, int n2, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptString", $$robo$$android_icu_impl_number_Parse$acceptString(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem java.lang.CharSequence int boolean ), (int)n, (StateName)stateName, (StateName)stateName2, (ParserState)parserState, (StateItem)stateItem, (CharSequence)charSequence, (int)n2, (boolean)bl);
    }

    private static long acceptStringNonIgnorable(int n, StateName stateName, StateName stateName2, ParserState parserState, StateItem stateItem, CharSequence charSequence, boolean bl, int n2, long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptStringNonIgnorable", $$robo$$android_icu_impl_number_Parse$acceptStringNonIgnorable(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem java.lang.CharSequence boolean int long long ), (int)n, (StateName)stateName, (StateName)stateName2, (ParserState)parserState, (StateItem)stateItem, (CharSequence)charSequence, (boolean)bl, (int)n2, (long)l, (long)l2);
    }

    private static long acceptStringHelper(int n, StateName stateName, StateName stateName2, ParserState parserState, StateItem stateItem, CharSequence charSequence, int n2, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptStringHelper", $$robo$$android_icu_impl_number_Parse$acceptStringHelper(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem java.lang.CharSequence int boolean ), (int)n, (StateName)stateName, (StateName)stateName2, (ParserState)parserState, (StateItem)stateItem, (CharSequence)charSequence, (int)n2, (boolean)bl);
    }

    private static long acceptAffixPatternOffset(int n, ParserState parserState, StateItem stateItem) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptAffixPatternOffset", $$robo$$android_icu_impl_number_Parse$acceptAffixPatternOffset(int android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (ParserState)parserState, (StateItem)stateItem);
    }

    private static long acceptAffixPattern(int n, StateName stateName, ParserState parserState, StateItem stateItem, CharSequence charSequence, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptAffixPattern", $$robo$$android_icu_impl_number_Parse$acceptAffixPattern(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem java.lang.CharSequence long ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem, (CharSequence)charSequence, (long)l);
    }

    private static long acceptAffixPatternNonIgnorable(int n, StateName stateName, ParserState parserState, StateItem stateItem, CharSequence charSequence, int n2, long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptAffixPatternNonIgnorable", $$robo$$android_icu_impl_number_Parse$acceptAffixPatternNonIgnorable(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem java.lang.CharSequence int long long ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem, (CharSequence)charSequence, (int)n2, (long)l, (long)l2);
    }

    private static long acceptAffixPatternHelper(int n, StateName stateName, ParserState parserState, StateItem stateItem, CharSequence charSequence, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptAffixPatternHelper", $$robo$$android_icu_impl_number_Parse$acceptAffixPatternHelper(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem java.lang.CharSequence long ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem, (CharSequence)charSequence, (long)l);
    }

    private static long acceptStringOrAffixPatternWithIgnorables(int n, StateName stateName, StateName stateName2, ParserState parserState, StateItem stateItem, CharSequence charSequence, long l, boolean bl, boolean bl2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptStringOrAffixPatternWithIgnorables", $$robo$$android_icu_impl_number_Parse$acceptStringOrAffixPatternWithIgnorables(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem java.lang.CharSequence long boolean boolean ), (int)n, (StateName)stateName, (StateName)stateName2, (ParserState)parserState, (StateItem)stateItem, (CharSequence)charSequence, (long)l, (boolean)bl, (boolean)bl2);
    }

    private static void acceptCurrency(int n, StateName stateName, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptCurrency", $$robo$$android_icu_impl_number_Parse$acceptCurrency(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem);
    }

    private static long acceptCurrency(int n, StateName stateName, StateName stateName2, ParserState parserState, StateItem stateItem) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptCurrency", $$robo$$android_icu_impl_number_Parse$acceptCurrency(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (StateName)stateName, (StateName)stateName2, (ParserState)parserState, (StateItem)stateItem);
    }

    private static void acceptCurrencyOffset(int n, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptCurrencyOffset", $$robo$$android_icu_impl_number_Parse$acceptCurrencyOffset(int android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (ParserState)parserState, (StateItem)stateItem);
    }

    private static long acceptCurrencyHelper(int n, StateName stateName, StateName stateName2, ParserState parserState, StateItem stateItem, TextTrieMap.ParseState parseState) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptCurrencyHelper", $$robo$$android_icu_impl_number_Parse$acceptCurrencyHelper(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem android.icu.impl.TextTrieMap$ParseState ), (int)n, (StateName)stateName, (StateName)stateName2, (ParserState)parserState, (StateItem)stateItem, (TextTrieMap.ParseState)parseState);
    }

    private static long acceptDigitTrie(int n, StateName stateName, ParserState parserState, StateItem stateItem, DigitType digitType) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptDigitTrie", $$robo$$android_icu_impl_number_Parse$acceptDigitTrie(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem android.icu.impl.number.Parse$DigitType ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem, (DigitType)digitType);
    }

    private static void acceptDigitTrieOffset(int n, ParserState parserState, StateItem stateItem) {
        InvokeDynamicSupport.bootstrapStatic("acceptDigitTrieOffset", $$robo$$android_icu_impl_number_Parse$acceptDigitTrieOffset(int android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem ), (int)n, (ParserState)parserState, (StateItem)stateItem);
    }

    private static long acceptDigitTrieHelper(int n, StateName stateName, ParserState parserState, StateItem stateItem, DigitType digitType, TextTrieMap.ParseState parseState) {
        return (long)InvokeDynamicSupport.bootstrapStatic("acceptDigitTrieHelper", $$robo$$android_icu_impl_number_Parse$acceptDigitTrieHelper(int android.icu.impl.number.Parse$StateName android.icu.impl.number.Parse$ParserState android.icu.impl.number.Parse$StateItem android.icu.impl.number.Parse$DigitType android.icu.impl.TextTrieMap$ParseState ), (int)n, (StateName)stateName, (ParserState)parserState, (StateItem)stateItem, (DigitType)digitType, (TextTrieMap.ParseState)parseState);
    }

    private static boolean codePointEquals(int n, int n2, ParserState parserState) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("codePointEquals", $$robo$$android_icu_impl_number_Parse$codePointEquals(int int android.icu.impl.number.Parse$ParserState ), (int)n, (int)n2, (ParserState)parserState);
    }

    private static boolean isIgnorable(int n, ParserState parserState) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isIgnorable", $$robo$$android_icu_impl_number_Parse$isIgnorable(int android.icu.impl.number.Parse$ParserState ), (int)n, (ParserState)parserState);
    }

    static {
        RobolectricInternals.classInitializing(Parse.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Parse)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CurrencyAffixPatterns
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Set<AffixHolder> set;
        private static ConcurrentHashMap<ULocale, CurrencyAffixPatterns> currencyAffixPatterns;
        private static ThreadLocal<DecimalFormatProperties> threadLocalProperties;

        private static final void $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns$addToState(ULocale uloc, ParserState state) {
            CurrencyAffixPatterns value = currencyAffixPatterns.get(uloc);
            if (value == null) {
                CurrencyAffixPatterns newValue = new CurrencyAffixPatterns(uloc);
                currencyAffixPatterns.putIfAbsent(uloc, newValue);
                value = currencyAffixPatterns.get(uloc);
            }
            state.affixHolders.addAll(value.set);
        }

        private void $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns$__constructor__(ULocale uloc) {
            this.set = new HashSet<AffixHolder>();
            String pattern = NumberFormat.getPatternForStyle(uloc, 1);
            this.addPattern(pattern);
            CurrencyPluralInfo pluralInfo = CurrencyPluralInfo.getInstance(uloc);
            for (StandardPlural plural : StandardPlural.VALUES) {
                pattern = pluralInfo.getCurrencyPluralPattern(plural.getKeyword());
                this.addPattern(pattern);
            }
        }

        private final void $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns$addPattern(String pattern) {
            DecimalFormatProperties properties = threadLocalProperties.get();
            try {
                PatternStringParser.parseToExistingProperties(pattern, properties);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.set.add(AffixHolder.fromPropertiesPositivePattern(properties));
            this.set.add(AffixHolder.fromPropertiesNegativePattern(properties));
        }

        static void __staticInitializer__() {
            currencyAffixPatterns = new ConcurrentHashMap();
            threadLocalProperties = new ThreadLocal<DecimalFormatProperties>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns_1$__constructor__() {
                }

                private final DecimalFormatProperties $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns_1$initialValue() {
                    return new DecimalFormatProperties();
                }

                private void __constructor__() {
                    this.$$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns_1$__constructor__(), this);
                }

                @Override
                protected DecimalFormatProperties initialValue() {
                    return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns_1$initialValue(), this);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        static void addToState(ULocale uLocale, ParserState parserState) {
            InvokeDynamicSupport.bootstrapStatic("addToState", $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns$addToState(android.icu.util.ULocale android.icu.impl.number.Parse$ParserState ), (ULocale)uLocale, (ParserState)parserState);
        }

        private void __constructor__(ULocale uLocale) {
            this.$$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns$__constructor__(uLocale);
        }

        public CurrencyAffixPatterns(ULocale uLocale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns$__constructor__(android.icu.util.ULocale ), this, uLocale);
        }

        private void addPattern(String string2) {
            InvokeDynamicSupport.bootstrap("addPattern", $$robo$$android_icu_impl_number_Parse_CurrencyAffixPatterns$addPattern(java.lang.String ), this, string2);
        }

        static {
            RobolectricInternals.classInitializing(CurrencyAffixPatterns.class);
        }

        public /* synthetic */ CurrencyAffixPatterns() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurrencyAffixPatterns)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AffixHolder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String p;
        String s;
        boolean strings;
        boolean negative;
        static AffixHolder EMPTY_POSITIVE;
        static AffixHolder EMPTY_NEGATIVE;

        private static final void $$robo$$android_icu_impl_number_Parse_AffixHolder$addToState(ParserState state, DecimalFormatProperties properties) {
            AffixHolder pp = AffixHolder.fromPropertiesPositivePattern(properties);
            AffixHolder np = AffixHolder.fromPropertiesNegativePattern(properties);
            AffixHolder ps = AffixHolder.fromPropertiesPositiveString(properties);
            AffixHolder ns = AffixHolder.fromPropertiesNegativeString(properties);
            if (pp != null) {
                state.affixHolders.add(pp);
            }
            if (ps != null) {
                state.affixHolders.add(ps);
            }
            if (np != null) {
                state.affixHolders.add(np);
            }
            if (ns != null) {
                state.affixHolders.add(ns);
            }
        }

        private static final AffixHolder $$robo$$android_icu_impl_number_Parse_AffixHolder$fromPropertiesPositivePattern(DecimalFormatProperties properties) {
            String ppp = properties.getPositivePrefixPattern();
            String psp = properties.getPositiveSuffixPattern();
            if (properties.getSignAlwaysShown()) {
                boolean foundSign = false;
                String npp = properties.getNegativePrefixPattern();
                String nsp = properties.getNegativeSuffixPattern();
                if (AffixUtils.containsType(npp, -1)) {
                    foundSign = true;
                    ppp = AffixUtils.replaceType(npp, -1, '+');
                }
                if (AffixUtils.containsType(nsp, -1)) {
                    foundSign = true;
                    psp = AffixUtils.replaceType(nsp, -1, '+');
                }
                if (!foundSign) {
                    ppp = "+" + ppp;
                }
            }
            return AffixHolder.getInstance(ppp, psp, false, false);
        }

        private static final AffixHolder $$robo$$android_icu_impl_number_Parse_AffixHolder$fromPropertiesNegativePattern(DecimalFormatProperties properties) {
            String npp = properties.getNegativePrefixPattern();
            String nsp = properties.getNegativeSuffixPattern();
            if (npp == null && nsp == null) {
                npp = properties.getPositivePrefixPattern();
                nsp = properties.getPositiveSuffixPattern();
                npp = npp == null ? "-" : "-" + npp;
            }
            return AffixHolder.getInstance(npp, nsp, false, true);
        }

        private static final AffixHolder $$robo$$android_icu_impl_number_Parse_AffixHolder$fromPropertiesPositiveString(DecimalFormatProperties properties) {
            String pp = properties.getPositivePrefix();
            String ps = properties.getPositiveSuffix();
            if (pp == null && ps == null) {
                return null;
            }
            return AffixHolder.getInstance(pp, ps, true, false);
        }

        private static final AffixHolder $$robo$$android_icu_impl_number_Parse_AffixHolder$fromPropertiesNegativeString(DecimalFormatProperties properties) {
            String np = properties.getNegativePrefix();
            String ns = properties.getNegativeSuffix();
            if (np == null && ns == null) {
                return null;
            }
            return AffixHolder.getInstance(np, ns, true, true);
        }

        private static final AffixHolder $$robo$$android_icu_impl_number_Parse_AffixHolder$getInstance(String p, String s, boolean strings, boolean negative) {
            if (p == null && s == null) {
                return negative ? EMPTY_NEGATIVE : EMPTY_POSITIVE;
            }
            if (p == null) {
                p = "";
            }
            if (s == null) {
                s = "";
            }
            if (p.length() == 0 && s.length() == 0) {
                return negative ? EMPTY_NEGATIVE : EMPTY_POSITIVE;
            }
            return new AffixHolder(p, s, strings, negative);
        }

        private void $$robo$$android_icu_impl_number_Parse_AffixHolder$__constructor__(String pp, String sp, boolean strings, boolean negative) {
            this.p = pp;
            this.s = sp;
            this.strings = strings;
            this.negative = negative;
        }

        private final boolean $$robo$$android_icu_impl_number_Parse_AffixHolder$equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof AffixHolder)) {
                return false;
            }
            AffixHolder _other = (AffixHolder)other;
            if (!this.p.equals(_other.p)) {
                return false;
            }
            if (!this.s.equals(_other.s)) {
                return false;
            }
            if (this.strings != _other.strings) {
                return false;
            }
            return this.negative == _other.negative;
        }

        private final int $$robo$$android_icu_impl_number_Parse_AffixHolder$hashCode() {
            return this.p.hashCode() ^ this.s.hashCode();
        }

        private final String $$robo$$android_icu_impl_number_Parse_AffixHolder$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append(this.p);
            sb.append("|");
            sb.append(this.s);
            sb.append("|");
            sb.append(this.strings ? (char)'S' : 'P');
            sb.append("}");
            return sb.toString();
        }

        static void __staticInitializer__() {
            EMPTY_POSITIVE = new AffixHolder("", "", true, false);
            EMPTY_NEGATIVE = new AffixHolder("", "", true, true);
        }

        static void addToState(ParserState parserState, DecimalFormatProperties decimalFormatProperties) {
            InvokeDynamicSupport.bootstrapStatic("addToState", $$robo$$android_icu_impl_number_Parse_AffixHolder$addToState(android.icu.impl.number.Parse$ParserState android.icu.impl.number.DecimalFormatProperties ), (ParserState)parserState, (DecimalFormatProperties)decimalFormatProperties);
        }

        static AffixHolder fromPropertiesPositivePattern(DecimalFormatProperties decimalFormatProperties) {
            return InvokeDynamicSupport.bootstrapStatic("fromPropertiesPositivePattern", $$robo$$android_icu_impl_number_Parse_AffixHolder$fromPropertiesPositivePattern(android.icu.impl.number.DecimalFormatProperties ), (DecimalFormatProperties)decimalFormatProperties);
        }

        static AffixHolder fromPropertiesNegativePattern(DecimalFormatProperties decimalFormatProperties) {
            return InvokeDynamicSupport.bootstrapStatic("fromPropertiesNegativePattern", $$robo$$android_icu_impl_number_Parse_AffixHolder$fromPropertiesNegativePattern(android.icu.impl.number.DecimalFormatProperties ), (DecimalFormatProperties)decimalFormatProperties);
        }

        static AffixHolder fromPropertiesPositiveString(DecimalFormatProperties decimalFormatProperties) {
            return InvokeDynamicSupport.bootstrapStatic("fromPropertiesPositiveString", $$robo$$android_icu_impl_number_Parse_AffixHolder$fromPropertiesPositiveString(android.icu.impl.number.DecimalFormatProperties ), (DecimalFormatProperties)decimalFormatProperties);
        }

        static AffixHolder fromPropertiesNegativeString(DecimalFormatProperties decimalFormatProperties) {
            return InvokeDynamicSupport.bootstrapStatic("fromPropertiesNegativeString", $$robo$$android_icu_impl_number_Parse_AffixHolder$fromPropertiesNegativeString(android.icu.impl.number.DecimalFormatProperties ), (DecimalFormatProperties)decimalFormatProperties);
        }

        static AffixHolder getInstance(String string2, String string3, boolean bl, boolean bl2) {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_impl_number_Parse_AffixHolder$getInstance(java.lang.String java.lang.String boolean boolean ), (String)string2, (String)string3, (boolean)bl, (boolean)bl2);
        }

        private void __constructor__(String string2, String string3, boolean bl, boolean bl2) {
            this.$$robo$$android_icu_impl_number_Parse_AffixHolder$__constructor__(string2, string3, bl, bl2);
        }

        public AffixHolder(String string2, String string3, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_AffixHolder$__constructor__(java.lang.String java.lang.String boolean boolean ), this, string2, string3, bl, bl2);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_number_Parse_AffixHolder$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_number_Parse_AffixHolder$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_number_Parse_AffixHolder$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(AffixHolder.class);
        }

        public /* synthetic */ AffixHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AffixHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ParserState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        StateItem[] items;
        StateItem[] prevItems;
        int length;
        int prevLength;
        DecimalFormatProperties properties;
        DecimalFormatSymbols symbols;
        ParseMode mode;
        boolean caseSensitive;
        boolean parseCurrency;
        GroupingMode groupingMode;
        int decimalCp1;
        int decimalCp2;
        int groupingCp1;
        int groupingCp2;
        SeparatorType decimalType1;
        SeparatorType decimalType2;
        SeparatorType groupingType1;
        SeparatorType groupingType2;
        TextTrieMap<Byte> digitTrie;
        Set<AffixHolder> affixHolders;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_number_Parse_ParserState$__constructor__() {
            this.items = new StateItem[16];
            this.prevItems = new StateItem[16];
            this.affixHolders = new HashSet<AffixHolder>();
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i] = new StateItem((char)(65 + i));
                this.prevItems[i] = new StateItem((char)(65 + i));
            }
        }

        private final ParserState $$robo$$android_icu_impl_number_Parse_ParserState$clear() {
            this.length = 0;
            this.prevLength = 0;
            this.digitTrie = null;
            this.affixHolders.clear();
            return this;
        }

        private final void $$robo$$android_icu_impl_number_Parse_ParserState$swap() {
            StateItem[] temp = this.prevItems;
            this.prevItems = this.items;
            this.items = temp;
            this.prevLength = this.length;
            this.length = 0;
        }

        private final void $$robo$$android_icu_impl_number_Parse_ParserState$swapBack() {
            StateItem[] temp = this.prevItems;
            this.prevItems = this.items;
            this.items = temp;
            this.length = this.prevLength;
            this.prevLength = 0;
        }

        private final StateItem $$robo$$android_icu_impl_number_Parse_ParserState$getNext() {
            if (this.length >= this.items.length) {
                this.length = this.items.length - 1;
            }
            StateItem item = this.items[this.length];
            ++this.length;
            return item;
        }

        private final int $$robo$$android_icu_impl_number_Parse_ParserState$lastInsertedIndex() {
            if (!$assertionsDisabled && this.length <= 0) {
                throw new AssertionError();
            }
            return this.length - 1;
        }

        private final StateItem $$robo$$android_icu_impl_number_Parse_ParserState$getItem(int i) {
            if (!($assertionsDisabled || i >= 0 && i < this.length)) {
                throw new AssertionError();
            }
            return this.items[i];
        }

        private final String $$robo$$android_icu_impl_number_Parse_ParserState$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<ParseState mode:");
            sb.append((Object)this.mode);
            sb.append(" caseSensitive:");
            sb.append(this.caseSensitive);
            sb.append(" parseCurrency:");
            sb.append(this.parseCurrency);
            sb.append(" groupingMode:");
            sb.append((Object)this.groupingMode);
            sb.append(" decimalCps:");
            sb.append((char)this.decimalCp1);
            sb.append((char)this.decimalCp2);
            sb.append(" groupingCps:");
            sb.append((char)this.groupingCp1);
            sb.append((char)this.groupingCp2);
            sb.append(" affixes:");
            sb.append(this.affixHolders);
            sb.append(">");
            return sb.toString();
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !Parse.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_number_Parse_ParserState$__constructor__();
        }

        public ParserState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_ParserState$__constructor__(), this);
        }

        ParserState clear() {
            return InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_impl_number_Parse_ParserState$clear(), this);
        }

        void swap() {
            InvokeDynamicSupport.bootstrap("swap", $$robo$$android_icu_impl_number_Parse_ParserState$swap(), this);
        }

        void swapBack() {
            InvokeDynamicSupport.bootstrap("swapBack", $$robo$$android_icu_impl_number_Parse_ParserState$swapBack(), this);
        }

        StateItem getNext() {
            return InvokeDynamicSupport.bootstrap("getNext", $$robo$$android_icu_impl_number_Parse_ParserState$getNext(), this);
        }

        public int lastInsertedIndex() {
            return (int)InvokeDynamicSupport.bootstrap("lastInsertedIndex", $$robo$$android_icu_impl_number_Parse_ParserState$lastInsertedIndex(), this);
        }

        public StateItem getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_icu_impl_number_Parse_ParserState$getItem(int ), this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_number_Parse_ParserState$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(ParserState.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParserState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StateItem
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        StateName name;
        int trailingCount;
        int score;
        DecimalQuantity_DualStorageBCD fq;
        int numDigits;
        int trailingZeros;
        int exponent;
        int groupingCp;
        long groupingWidths;
        String isoCode;
        boolean sawNegative;
        boolean sawNegativeExponent;
        boolean sawCurrency;
        boolean sawNaN;
        boolean sawInfinity;
        AffixHolder affix;
        boolean sawPrefix;
        boolean sawSuffix;
        boolean sawDecimalPoint;
        boolean sawExponentDigit;
        StateName returnTo1;
        StateName returnTo2;
        CharSequence currentString;
        int currentOffset;
        boolean currentTrailing;
        CharSequence currentAffixPattern;
        long currentStepwiseParserTag;
        TextTrieMap.ParseState currentCurrencyTrieState;
        TextTrieMap.ParseState currentDigitTrieState;
        DigitType currentDigitType;
        char id;
        String path;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_number_Parse_StateItem$__constructor__(char _id) {
            this.fq = new DecimalQuantity_DualStorageBCD();
            this.id = _id;
        }

        private final StateItem $$robo$$android_icu_impl_number_Parse_StateItem$clear() {
            this.name = StateName.BEFORE_PREFIX;
            this.trailingCount = 0;
            this.score = 0;
            this.fq.clear();
            this.numDigits = 0;
            this.trailingZeros = 0;
            this.exponent = 0;
            this.groupingCp = -1;
            this.groupingWidths = 0L;
            this.isoCode = null;
            this.sawNegative = false;
            this.sawNegativeExponent = false;
            this.sawCurrency = false;
            this.sawNaN = false;
            this.sawInfinity = false;
            this.affix = null;
            this.sawPrefix = false;
            this.sawSuffix = false;
            this.sawDecimalPoint = false;
            this.sawExponentDigit = false;
            this.returnTo1 = null;
            this.returnTo2 = null;
            this.currentString = null;
            this.currentOffset = 0;
            this.currentTrailing = false;
            this.currentAffixPattern = null;
            this.currentStepwiseParserTag = 0L;
            this.currentCurrencyTrieState = null;
            this.currentDigitTrieState = null;
            this.currentDigitType = null;
            this.path = "";
            return this;
        }

        private final StateItem $$robo$$android_icu_impl_number_Parse_StateItem$copyFrom(StateItem other, StateName newName, int trailing) {
            this.name = newName;
            this.score = other.score;
            this.trailingCount = trailing < 0 ? 0 : other.trailingCount + Character.charCount(trailing);
            this.fq.copyFrom(other.fq);
            this.numDigits = other.numDigits;
            this.trailingZeros = other.trailingZeros;
            this.exponent = other.exponent;
            this.groupingCp = other.groupingCp;
            this.groupingWidths = other.groupingWidths;
            this.isoCode = other.isoCode;
            this.sawNegative = other.sawNegative;
            this.sawNegativeExponent = other.sawNegativeExponent;
            this.sawCurrency = other.sawCurrency;
            this.sawNaN = other.sawNaN;
            this.sawInfinity = other.sawInfinity;
            this.affix = other.affix;
            this.sawPrefix = other.sawPrefix;
            this.sawSuffix = other.sawSuffix;
            this.sawDecimalPoint = other.sawDecimalPoint;
            this.sawExponentDigit = other.sawExponentDigit;
            this.returnTo1 = other.returnTo1;
            this.returnTo2 = other.returnTo2;
            this.currentString = other.currentString;
            this.currentOffset = other.currentOffset;
            this.currentTrailing = other.currentTrailing;
            this.currentAffixPattern = other.currentAffixPattern;
            this.currentStepwiseParserTag = other.currentStepwiseParserTag;
            this.currentCurrencyTrieState = other.currentCurrencyTrieState;
            this.currentDigitTrieState = other.currentDigitTrieState;
            this.currentDigitType = other.currentDigitType;
            if (DEBUGGING) {
                this.path = other.path + other.id;
            }
            return this;
        }

        private final void $$robo$$android_icu_impl_number_Parse_StateItem$appendDigit(byte digit, DigitType type) {
            if (type == DigitType.EXPONENT) {
                this.sawExponentDigit = true;
                int newExponent = this.exponent * 10 + digit;
                this.exponent = newExponent < this.exponent ? Integer.MAX_VALUE : newExponent;
            } else {
                ++this.numDigits;
                if (type == DigitType.FRACTION && digit == 0) {
                    ++this.trailingZeros;
                } else if (type == DigitType.FRACTION) {
                    this.fq.appendDigit(digit, this.trailingZeros, false);
                    this.trailingZeros = 0;
                } else {
                    this.fq.appendDigit(digit, 0, true);
                }
            }
        }

        private final boolean $$robo$$android_icu_impl_number_Parse_StateItem$hasNumber() {
            return this.numDigits > 0 || this.sawNaN || this.sawInfinity;
        }

        private final Number $$robo$$android_icu_impl_number_Parse_StateItem$toNumber(DecimalFormatProperties properties) {
            if (this.sawNaN) {
                return Double.NaN;
            }
            if (this.sawInfinity) {
                if (this.sawNegative) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (this.fq.isZero() && this.sawNegative) {
                return -0.0;
            }
            boolean forceBigDecimal = properties.getParseToBigDecimal();
            if (this.exponent == Integer.MAX_VALUE) {
                if (this.sawNegativeExponent && this.sawNegative) {
                    return -0.0;
                }
                if (this.sawNegativeExponent) {
                    return 0.0;
                }
                if (this.sawNegative) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (this.exponent > 1000) {
                forceBigDecimal = true;
            }
            BigDecimal multiplier = properties.getMultiplier();
            if (properties.getMagnitudeMultiplier() != 0) {
                if (multiplier == null) {
                    multiplier = BigDecimal.ONE;
                }
                multiplier = multiplier.scaleByPowerOfTen(properties.getMagnitudeMultiplier());
            }
            int delta = (this.sawNegativeExponent ? -1 : 1) * this.exponent;
            MathContext mc = RoundingUtils.getMathContextOr34Digits(properties);
            BigDecimal result = this.fq.toBigDecimal();
            if (this.sawNegative) {
                result = result.negate();
            }
            result = result.scaleByPowerOfTen(delta);
            if (multiplier != null) {
                result = result.divide(multiplier, mc);
            }
            result = result.stripTrailingZeros();
            if (forceBigDecimal || result.scale() > 0) {
                return result;
            }
            if (result.compareTo(MIN_LONG_AS_BIG_DECIMAL) >= 0 && result.compareTo(MAX_LONG_AS_BIG_DECIMAL) <= 0) {
                return result.longValueExact();
            }
            return result.toBigIntegerExact();
        }

        private final CurrencyAmount $$robo$$android_icu_impl_number_Parse_StateItem$toCurrencyAmount(DecimalFormatProperties properties) {
            if (!$assertionsDisabled && this.isoCode == null) {
                throw new AssertionError();
            }
            Number number = this.toNumber(properties);
            Currency currency = Currency.getInstance(this.isoCode);
            return new CurrencyAmount(number, currency);
        }

        private final String $$robo$$android_icu_impl_number_Parse_StateItem$toString() {
            char[] cArray;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(this.path);
            sb.append("] ");
            sb.append(this.name.name());
            if (this.name == StateName.INSIDE_STRING) {
                sb.append("{");
                sb.append(this.currentString);
                sb.append(":");
                sb.append(this.currentOffset);
                sb.append("}");
            }
            if (this.name == StateName.INSIDE_AFFIX_PATTERN) {
                sb.append("{");
                sb.append(this.currentAffixPattern);
                sb.append(":");
                sb.append(AffixUtils.getOffset(this.currentStepwiseParserTag) - 1);
                sb.append("}");
            }
            sb.append(" ");
            sb.append(this.fq.toBigDecimal());
            sb.append(" grouping:");
            if (this.groupingCp == -1) {
                char[] cArray2 = new char[1];
                cArray = cArray2;
                cArray2[0] = 63;
            } else {
                cArray = Character.toChars(this.groupingCp);
            }
            sb.append(cArray);
            sb.append(" widths:");
            sb.append(Long.toHexString(this.groupingWidths));
            sb.append(" seen:");
            sb.append(this.sawNegative ? 1 : 0);
            sb.append(this.sawNegativeExponent ? 1 : 0);
            sb.append(this.sawNaN ? 1 : 0);
            sb.append(this.sawInfinity ? 1 : 0);
            sb.append(this.sawPrefix ? 1 : 0);
            sb.append(this.sawSuffix ? 1 : 0);
            sb.append(this.sawDecimalPoint ? 1 : 0);
            sb.append(" trailing:");
            sb.append(this.trailingCount);
            sb.append(" score:");
            sb.append(this.score);
            sb.append(" affix:");
            sb.append(this.affix);
            sb.append(" currency:");
            sb.append(this.isoCode);
            return sb.toString();
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !Parse.class.desiredAssertionStatus();
        }

        private void __constructor__(char c) {
            this.$$robo$$android_icu_impl_number_Parse_StateItem$__constructor__(c);
        }

        public StateItem(char c) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_StateItem$__constructor__(char ), this, c);
        }

        StateItem clear() {
            return InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_impl_number_Parse_StateItem$clear(), this);
        }

        StateItem copyFrom(StateItem stateItem, StateName stateName, int n) {
            return InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_icu_impl_number_Parse_StateItem$copyFrom(android.icu.impl.number.Parse$StateItem android.icu.impl.number.Parse$StateName int ), this, stateItem, stateName, n);
        }

        void appendDigit(byte by, DigitType digitType) {
            InvokeDynamicSupport.bootstrap("appendDigit", $$robo$$android_icu_impl_number_Parse_StateItem$appendDigit(byte android.icu.impl.number.Parse$DigitType ), this, by, digitType);
        }

        public boolean hasNumber() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNumber", $$robo$$android_icu_impl_number_Parse_StateItem$hasNumber(), this);
        }

        Number toNumber(DecimalFormatProperties decimalFormatProperties) {
            return InvokeDynamicSupport.bootstrap("toNumber", $$robo$$android_icu_impl_number_Parse_StateItem$toNumber(android.icu.impl.number.DecimalFormatProperties ), this, decimalFormatProperties);
        }

        public CurrencyAmount toCurrencyAmount(DecimalFormatProperties decimalFormatProperties) {
            return InvokeDynamicSupport.bootstrap("toCurrencyAmount", $$robo$$android_icu_impl_number_Parse_StateItem$toCurrencyAmount(android.icu.impl.number.DecimalFormatProperties ), this, decimalFormatProperties);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_number_Parse_StateItem$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(StateItem.class);
        }

        public /* synthetic */ StateItem() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateItem)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DigitType
    extends Enum<DigitType> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ DigitType INTEGER;
        public static /* enum */ DigitType FRACTION;
        public static /* enum */ DigitType EXPONENT;
        private static /* synthetic */ DigitType[] $VALUES;

        private static final DigitType[] $$robo$$android_icu_impl_number_Parse_DigitType$values() {
            return (DigitType[])$VALUES.clone();
        }

        private static final DigitType $$robo$$android_icu_impl_number_Parse_DigitType$valueOf(String name) {
            return Enum.valueOf(DigitType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_number_Parse_DigitType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            INTEGER = new DigitType();
            FRACTION = new DigitType();
            EXPONENT = new DigitType();
            $VALUES = new DigitType[]{INTEGER, FRACTION, EXPONENT};
        }

        public static DigitType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_number_Parse_DigitType$values());
        }

        public static DigitType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_number_Parse_DigitType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_number_Parse_DigitType$__constructor__(string2, n);
        }

        public DigitType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_DigitType$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(DigitType.class);
        }

        public /* synthetic */ DigitType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DigitType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SeparatorType
    extends Enum<SeparatorType> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ SeparatorType COMMA_LIKE;
        public static /* enum */ SeparatorType PERIOD_LIKE;
        public static /* enum */ SeparatorType OTHER_GROUPING;
        public static /* enum */ SeparatorType UNKNOWN;
        private static /* synthetic */ SeparatorType[] $VALUES;

        private static final SeparatorType[] $$robo$$android_icu_impl_number_Parse_SeparatorType$values() {
            return (SeparatorType[])$VALUES.clone();
        }

        private static final SeparatorType $$robo$$android_icu_impl_number_Parse_SeparatorType$valueOf(String name) {
            return Enum.valueOf(SeparatorType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_number_Parse_SeparatorType$__constructor__(String string2, int n) {
        }

        private static final SeparatorType $$robo$$android_icu_impl_number_Parse_SeparatorType$fromCp(int cp, ParseMode mode) {
            if (mode == ParseMode.FAST) {
                return UNKNOWN;
            }
            if (mode == ParseMode.STRICT) {
                if (UNISET_STRICT_COMMA_LIKE.contains(cp)) {
                    return COMMA_LIKE;
                }
                if (UNISET_STRICT_PERIOD_LIKE.contains(cp)) {
                    return PERIOD_LIKE;
                }
                if (UNISET_OTHER_GROUPING_SEPARATORS.contains(cp)) {
                    return OTHER_GROUPING;
                }
                return UNKNOWN;
            }
            if (UNISET_COMMA_LIKE.contains(cp)) {
                return COMMA_LIKE;
            }
            if (UNISET_PERIOD_LIKE.contains(cp)) {
                return PERIOD_LIKE;
            }
            if (UNISET_OTHER_GROUPING_SEPARATORS.contains(cp)) {
                return OTHER_GROUPING;
            }
            return UNKNOWN;
        }

        static void __staticInitializer__() {
            COMMA_LIKE = new SeparatorType();
            PERIOD_LIKE = new SeparatorType();
            OTHER_GROUPING = new SeparatorType();
            UNKNOWN = new SeparatorType();
            $VALUES = new SeparatorType[]{COMMA_LIKE, PERIOD_LIKE, OTHER_GROUPING, UNKNOWN};
        }

        public static SeparatorType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_number_Parse_SeparatorType$values());
        }

        public static SeparatorType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_number_Parse_SeparatorType$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_number_Parse_SeparatorType$__constructor__(string2, n);
        }

        public SeparatorType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_SeparatorType$__constructor__(java.lang.String int ), this, string2, n);
        }

        static SeparatorType fromCp(int n, ParseMode parseMode) {
            return InvokeDynamicSupport.bootstrapStatic("fromCp", $$robo$$android_icu_impl_number_Parse_SeparatorType$fromCp(int android.icu.impl.number.Parse$ParseMode ), (int)n, (ParseMode)parseMode);
        }

        static {
            RobolectricInternals.classInitializing(SeparatorType.class);
        }

        public /* synthetic */ SeparatorType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SeparatorType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class StateName
    extends Enum<StateName> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ StateName BEFORE_PREFIX;
        public static /* enum */ StateName AFTER_PREFIX;
        public static /* enum */ StateName AFTER_INTEGER_DIGIT;
        public static /* enum */ StateName AFTER_FRACTION_DIGIT;
        public static /* enum */ StateName AFTER_EXPONENT_SEPARATOR;
        public static /* enum */ StateName AFTER_EXPONENT_DIGIT;
        public static /* enum */ StateName BEFORE_SUFFIX;
        public static /* enum */ StateName BEFORE_SUFFIX_SEEN_EXPONENT;
        public static /* enum */ StateName AFTER_SUFFIX;
        public static /* enum */ StateName INSIDE_CURRENCY;
        public static /* enum */ StateName INSIDE_DIGIT;
        public static /* enum */ StateName INSIDE_STRING;
        public static /* enum */ StateName INSIDE_AFFIX_PATTERN;
        private static /* synthetic */ StateName[] $VALUES;

        private static final StateName[] $$robo$$android_icu_impl_number_Parse_StateName$values() {
            return (StateName[])$VALUES.clone();
        }

        private static final StateName $$robo$$android_icu_impl_number_Parse_StateName$valueOf(String name) {
            return Enum.valueOf(StateName.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_number_Parse_StateName$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            BEFORE_PREFIX = new StateName();
            AFTER_PREFIX = new StateName();
            AFTER_INTEGER_DIGIT = new StateName();
            AFTER_FRACTION_DIGIT = new StateName();
            AFTER_EXPONENT_SEPARATOR = new StateName();
            AFTER_EXPONENT_DIGIT = new StateName();
            BEFORE_SUFFIX = new StateName();
            BEFORE_SUFFIX_SEEN_EXPONENT = new StateName();
            AFTER_SUFFIX = new StateName();
            INSIDE_CURRENCY = new StateName();
            INSIDE_DIGIT = new StateName();
            INSIDE_STRING = new StateName();
            INSIDE_AFFIX_PATTERN = new StateName();
            $VALUES = new StateName[]{BEFORE_PREFIX, AFTER_PREFIX, AFTER_INTEGER_DIGIT, AFTER_FRACTION_DIGIT, AFTER_EXPONENT_SEPARATOR, AFTER_EXPONENT_DIGIT, BEFORE_SUFFIX, BEFORE_SUFFIX_SEEN_EXPONENT, AFTER_SUFFIX, INSIDE_CURRENCY, INSIDE_DIGIT, INSIDE_STRING, INSIDE_AFFIX_PATTERN};
        }

        public static StateName[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_number_Parse_StateName$values());
        }

        public static StateName valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_number_Parse_StateName$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_number_Parse_StateName$__constructor__(string2, n);
        }

        public StateName() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_StateName$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(StateName.class);
        }

        public /* synthetic */ StateName() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateName)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class GroupingMode
    extends Enum<GroupingMode> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ GroupingMode DEFAULT;
        public static /* enum */ GroupingMode RESTRICTED;
        private static /* synthetic */ GroupingMode[] $VALUES;

        private static final GroupingMode[] $$robo$$android_icu_impl_number_Parse_GroupingMode$values() {
            return (GroupingMode[])$VALUES.clone();
        }

        private static final GroupingMode $$robo$$android_icu_impl_number_Parse_GroupingMode$valueOf(String name) {
            return Enum.valueOf(GroupingMode.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_number_Parse_GroupingMode$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DEFAULT = new GroupingMode();
            RESTRICTED = new GroupingMode();
            $VALUES = new GroupingMode[]{DEFAULT, RESTRICTED};
        }

        public static GroupingMode[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_number_Parse_GroupingMode$values());
        }

        public static GroupingMode valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_number_Parse_GroupingMode$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_number_Parse_GroupingMode$__constructor__(string2, n);
        }

        public GroupingMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_GroupingMode$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(GroupingMode.class);
        }

        public /* synthetic */ GroupingMode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GroupingMode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ParseMode
    extends Enum<ParseMode> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ ParseMode LENIENT;
        public static /* enum */ ParseMode STRICT;
        public static /* enum */ ParseMode FAST;
        private static /* synthetic */ ParseMode[] $VALUES;

        private static final ParseMode[] $$robo$$android_icu_impl_number_Parse_ParseMode$values() {
            return (ParseMode[])$VALUES.clone();
        }

        private static final ParseMode $$robo$$android_icu_impl_number_Parse_ParseMode$valueOf(String name) {
            return Enum.valueOf(ParseMode.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_number_Parse_ParseMode$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            LENIENT = new ParseMode();
            STRICT = new ParseMode();
            FAST = new ParseMode();
            $VALUES = new ParseMode[]{LENIENT, STRICT, FAST};
        }

        public static ParseMode[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_number_Parse_ParseMode$values());
        }

        public static ParseMode valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_number_Parse_ParseMode$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_number_Parse_ParseMode$__constructor__(string2, n);
        }

        public ParseMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_Parse_ParseMode$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ParseMode.class);
        }

        public /* synthetic */ ParseMode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParseMode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

