/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.CharsetDetector;
import android.icu.text.CharsetMatch;
import android.icu.text.CharsetRecognizer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class CharsetRecog_Unicode
extends CharsetRecognizer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;

    private void $$robo$$android_icu_text_CharsetRecog_Unicode$__constructor__() {
    }

    @Override
    abstract String getName();

    @Override
    abstract CharsetMatch match(CharsetDetector var1);

    private static final int $$robo$$android_icu_text_CharsetRecog_Unicode$codeUnit16FromBytes(byte hi, byte lo) {
        return (hi & 0xFF) << 8 | lo & 0xFF;
    }

    private static final int $$robo$$android_icu_text_CharsetRecog_Unicode$adjustConfidence(int codeUnit, int confidence) {
        if (codeUnit == 0) {
            confidence -= 10;
        } else if (codeUnit >= 32 && codeUnit <= 255 || codeUnit == 10) {
            confidence += 10;
        }
        if (confidence < 0) {
            confidence = 0;
        } else if (confidence > 100) {
            confidence = 100;
        }
        return confidence;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_CharsetRecog_Unicode$__constructor__();
    }

    public CharsetRecog_Unicode() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CharsetRecog_Unicode$__constructor__(), this);
    }

    static int codeUnit16FromBytes(byte by, byte by2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codeUnit16FromBytes", $$robo$$android_icu_text_CharsetRecog_Unicode$codeUnit16FromBytes(byte byte ), (byte)by, (byte)by2);
    }

    static int adjustConfidence(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("adjustConfidence", $$robo$$android_icu_text_CharsetRecog_Unicode$adjustConfidence(int int ), (int)n, (int)n2);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsetRecog_Unicode)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class CharsetRecog_UTF_32_LE
    extends CharsetRecog_UTF_32
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_LE$__constructor__() {
        }

        private final int $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_LE$getChar(byte[] input, int index) {
            return (input[index + 3] & 0xFF) << 24 | (input[index + 2] & 0xFF) << 16 | (input[index + 1] & 0xFF) << 8 | input[index + 0] & 0xFF;
        }

        private final String $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_LE$getName() {
            return "UTF-32LE";
        }

        @Override
        private void __constructor__() {
            this.$$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_LE$__constructor__();
        }

        public CharsetRecog_UTF_32_LE() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_LE$__constructor__(), this);
        }

        @Override
        int getChar(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getChar", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_LE$getChar(byte[] int ), this, byArray, n);
        }

        @Override
        String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_LE$getName(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsetRecog_UTF_32_LE)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CharsetRecog_UTF_32_BE
    extends CharsetRecog_UTF_32
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_BE$__constructor__() {
        }

        private final int $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_BE$getChar(byte[] input, int index) {
            return (input[index + 0] & 0xFF) << 24 | (input[index + 1] & 0xFF) << 16 | (input[index + 2] & 0xFF) << 8 | input[index + 3] & 0xFF;
        }

        private final String $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_BE$getName() {
            return "UTF-32BE";
        }

        @Override
        private void __constructor__() {
            this.$$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_BE$__constructor__();
        }

        public CharsetRecog_UTF_32_BE() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_BE$__constructor__(), this);
        }

        @Override
        int getChar(byte[] byArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getChar", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_BE$getChar(byte[] int ), this, byArray, n);
        }

        @Override
        String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32_BE$getName(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsetRecog_UTF_32_BE)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class CharsetRecog_UTF_32
    extends CharsetRecog_Unicode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32$__constructor__() {
        }

        abstract int getChar(byte[] var1, int var2);

        @Override
        abstract String getName();

        private final CharsetMatch $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32$match(CharsetDetector det) {
            byte[] input = det.fRawInput;
            int limit = det.fRawLength / 4 * 4;
            int numValid = 0;
            int numInvalid = 0;
            boolean hasBOM = false;
            int confidence = 0;
            if (limit == 0) {
                return null;
            }
            if (this.getChar(input, 0) == 65279) {
                hasBOM = true;
            }
            for (int i = 0; i < limit; i += 4) {
                int ch = this.getChar(input, i);
                if (ch < 0 || ch >= 0x10FFFF || ch >= 55296 && ch <= 57343) {
                    ++numInvalid;
                    continue;
                }
                ++numValid;
            }
            if (hasBOM && numInvalid == 0) {
                confidence = 100;
            } else if (hasBOM && numValid > numInvalid * 10) {
                confidence = 80;
            } else if (numValid > 3 && numInvalid == 0) {
                confidence = 100;
            } else if (numValid > 0 && numInvalid == 0) {
                confidence = 80;
            } else if (numValid > numInvalid * 10) {
                confidence = 25;
            }
            return confidence == 0 ? null : new CharsetMatch(det, this, confidence);
        }

        @Override
        private void __constructor__() {
            this.$$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32$__constructor__();
        }

        public CharsetRecog_UTF_32() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32$__constructor__(), this);
        }

        @Override
        CharsetMatch match(CharsetDetector charsetDetector) {
            return InvokeDynamicSupport.bootstrap("match", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_32$match(android.icu.text.CharsetDetector ), this, charsetDetector);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsetRecog_UTF_32)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CharsetRecog_UTF_16_LE
    extends CharsetRecog_Unicode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_LE$__constructor__() {
        }

        private final String $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_LE$getName() {
            return "UTF-16LE";
        }

        private final CharsetMatch $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_LE$match(CharsetDetector det) {
            byte[] input = det.fRawInput;
            int confidence = 10;
            int bytesToCheck = Math.min(input.length, 30);
            for (int charIndex = 0; charIndex < bytesToCheck - 1; charIndex += 2) {
                int codeUnit = CharsetRecog_UTF_16_LE.codeUnit16FromBytes(input[charIndex + 1], input[charIndex]);
                if (charIndex == 0 && codeUnit == 65279) {
                    confidence = 100;
                    break;
                }
                if ((confidence = CharsetRecog_UTF_16_LE.adjustConfidence(codeUnit, confidence)) == 0 || confidence == 100) break;
            }
            if (bytesToCheck < 4 && confidence < 100) {
                confidence = 0;
            }
            if (confidence > 0) {
                return new CharsetMatch(det, this, confidence);
            }
            return null;
        }

        @Override
        private void __constructor__() {
            this.$$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_LE$__constructor__();
        }

        public CharsetRecog_UTF_16_LE() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_LE$__constructor__(), this);
        }

        @Override
        String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_LE$getName(), this);
        }

        @Override
        CharsetMatch match(CharsetDetector charsetDetector) {
            return InvokeDynamicSupport.bootstrap("match", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_LE$match(android.icu.text.CharsetDetector ), this, charsetDetector);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsetRecog_UTF_16_LE)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CharsetRecog_UTF_16_BE
    extends CharsetRecog_Unicode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_BE$__constructor__() {
        }

        private final String $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_BE$getName() {
            return "UTF-16BE";
        }

        private final CharsetMatch $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_BE$match(CharsetDetector det) {
            byte[] input = det.fRawInput;
            int confidence = 10;
            int bytesToCheck = Math.min(input.length, 30);
            for (int charIndex = 0; charIndex < bytesToCheck - 1; charIndex += 2) {
                int codeUnit = CharsetRecog_UTF_16_BE.codeUnit16FromBytes(input[charIndex], input[charIndex + 1]);
                if (charIndex == 0 && codeUnit == 65279) {
                    confidence = 100;
                    break;
                }
                if ((confidence = CharsetRecog_UTF_16_BE.adjustConfidence(codeUnit, confidence)) == 0 || confidence == 100) break;
            }
            if (bytesToCheck < 4 && confidence < 100) {
                confidence = 0;
            }
            if (confidence > 0) {
                return new CharsetMatch(det, this, confidence);
            }
            return null;
        }

        @Override
        private void __constructor__() {
            this.$$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_BE$__constructor__();
        }

        public CharsetRecog_UTF_16_BE() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_BE$__constructor__(), this);
        }

        @Override
        String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_BE$getName(), this);
        }

        @Override
        CharsetMatch match(CharsetDetector charsetDetector) {
            return InvokeDynamicSupport.bootstrap("match", $$robo$$android_icu_text_CharsetRecog_Unicode_CharsetRecog_UTF_16_BE$match(android.icu.text.CharsetDetector ), this, charsetDetector);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsetRecog_UTF_16_BE)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

