/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CacheBase;
import android.icu.impl.CurrencyData;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SoftCache;
import android.icu.impl.UResource;
import android.icu.text.NumberingSystem;
import android.icu.util.Currency;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DecimalFormatSymbols
implements Cloneable,
Serializable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int CURRENCY_SPC_CURRENCY_MATCH = 0;
    public static int CURRENCY_SPC_SURROUNDING_MATCH = 1;
    public static int CURRENCY_SPC_INSERT = 2;
    private String[] currencySpcBeforeSym;
    private String[] currencySpcAfterSym;
    private static String[] SYMBOL_KEYS;
    private static String[] DEF_DIGIT_STRINGS_ARRAY;
    private static char[] DEF_DIGIT_CHARS_ARRAY;
    private static char DEF_DECIMAL_SEPARATOR = '.';
    private static char DEF_GROUPING_SEPARATOR = ',';
    private static char DEF_PERCENT = '%';
    private static char DEF_MINUS_SIGN = '-';
    private static char DEF_PLUS_SIGN = '+';
    private static char DEF_PERMILL = '\u2030';
    private static String[] SYMBOL_DEFAULTS;
    private static String LATIN_NUMBERING_SYSTEM = "latn";
    private static String NUMBER_ELEMENTS = "NumberElements";
    private static String SYMBOLS = "symbols";
    private char zeroDigit;
    private char[] digits;
    private String[] digitStrings;
    private transient int codePointZero;
    private char groupingSeparator;
    private String groupingSeparatorString;
    private char decimalSeparator;
    private String decimalSeparatorString;
    private char perMill;
    private String perMillString;
    private char percent;
    private String percentString;
    private char digit;
    private char sigDigit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String minusString;
    private char plusSign;
    private String plusString;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private String monetarySeparatorString;
    private char monetaryGroupingSeparator;
    private String monetaryGroupingSeparatorString;
    private char exponential;
    private String exponentSeparator;
    private char padEscape;
    private Locale requestedLocale;
    private ULocale ulocale;
    private String exponentMultiplicationSign;
    private static long serialVersionUID = 5772796243397350300L;
    private static int currentSerialVersion = 8;
    private int serialVersionOnStream;
    private static CacheBase<ULocale, CacheData, Void> cachedLocaleData;
    private String currencyPattern;
    private ULocale validLocale;
    private ULocale actualLocale;
    private transient Currency currency;

    private void $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__() {
    }

    private void $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(Locale locale) {
    }

    private void $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(ULocale locale) {
        this.exponentMultiplicationSign = null;
        this.serialVersionOnStream = 8;
        this.currencyPattern = null;
        this.initialize(locale, null);
    }

    private void $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(Locale locale, NumberingSystem ns) {
    }

    private void $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(ULocale locale, NumberingSystem ns) {
        this.exponentMultiplicationSign = null;
        this.serialVersionOnStream = 8;
        this.currencyPattern = null;
        this.initialize(locale, ns);
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormatSymbols$getInstance() {
        return new DecimalFormatSymbols();
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(Locale locale) {
        return new DecimalFormatSymbols(locale);
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(ULocale locale) {
        return new DecimalFormatSymbols(locale);
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormatSymbols$forNumberingSystem(Locale locale, NumberingSystem ns) {
        return new DecimalFormatSymbols(locale, ns);
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormatSymbols$forNumberingSystem(ULocale locale, NumberingSystem ns) {
        return new DecimalFormatSymbols(locale, ns);
    }

    private static final Locale[] $$robo$$android_icu_text_DecimalFormatSymbols$getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales();
    }

    private static final ULocale[] $$robo$$android_icu_text_DecimalFormatSymbols$getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getZeroDigit() {
        return this.zeroDigit;
    }

    private final char[] $$robo$$android_icu_text_DecimalFormatSymbols$getDigits() {
        return (char[])this.digits.clone();
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setZeroDigit(char zeroDigit) {
        this.zeroDigit = zeroDigit;
        this.digitStrings = (String[])this.digitStrings.clone();
        this.digits = (char[])this.digits.clone();
        this.digitStrings[0] = String.valueOf(zeroDigit);
        this.digits[0] = zeroDigit;
        for (int i = 1; i < 10; ++i) {
            char d = (char)(zeroDigit + i);
            this.digitStrings[i] = String.valueOf(d);
            this.digits[i] = d;
        }
        this.codePointZero = zeroDigit;
    }

    private final String[] $$robo$$android_icu_text_DecimalFormatSymbols$getDigitStrings() {
        return (String[])this.digitStrings.clone();
    }

    @Deprecated
    private final String[] $$robo$$android_icu_text_DecimalFormatSymbols$getDigitStringsLocal() {
        return this.digitStrings;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_DecimalFormatSymbols$getCodePointZero() {
        return this.codePointZero;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setDigitStrings(String[] digitStrings) {
        if (digitStrings == null) {
            throw new NullPointerException("The input digit string array is null");
        }
        if (digitStrings.length != 10) {
            throw new IllegalArgumentException("Number of digit strings is not 10");
        }
        String[] tmpDigitStrings = new String[10];
        char[] tmpDigits = new char[10];
        int tmpCodePointZero = -1;
        for (int i = 0; i < 10; ++i) {
            int cc;
            int cp;
            String digitStr = digitStrings[i];
            if (digitStr == null) {
                throw new IllegalArgumentException("The input digit string array contains a null element");
            }
            tmpDigitStrings[i] = digitStr;
            if (digitStr.length() == 0) {
                cp = -1;
                cc = 0;
            } else {
                cp = Character.codePointAt(digitStrings[i], 0);
                cc = Character.charCount(cp);
            }
            if (cc == digitStr.length()) {
                if (cc == 1 && tmpDigits != null) {
                    tmpDigits[i] = (char)cp;
                } else {
                    tmpDigits = null;
                }
                if (i == 0) {
                    tmpCodePointZero = cp;
                    continue;
                }
                if (cp == tmpCodePointZero + i) continue;
                tmpCodePointZero = -1;
                continue;
            }
            tmpCodePointZero = -1;
            tmpDigits = null;
        }
        this.digitStrings = tmpDigitStrings;
        this.codePointZero = tmpCodePointZero;
        if (tmpDigits == null) {
            this.zeroDigit = DEF_DIGIT_CHARS_ARRAY[0];
            this.digits = DEF_DIGIT_CHARS_ARRAY;
        } else {
            this.zeroDigit = tmpDigits[0];
            this.digits = tmpDigits;
        }
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getSignificantDigit() {
        return this.sigDigit;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setSignificantDigit(char sigDigit) {
        this.sigDigit = sigDigit;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getGroupingSeparator() {
        return this.groupingSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
        this.groupingSeparatorString = String.valueOf(groupingSeparator);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getGroupingSeparatorString() {
        return this.groupingSeparatorString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setGroupingSeparatorString(String groupingSeparatorString) {
        if (groupingSeparatorString == null) {
            throw new NullPointerException("The input grouping separator is null");
        }
        this.groupingSeparatorString = groupingSeparatorString;
        this.groupingSeparator = groupingSeparatorString.length() == 1 ? groupingSeparatorString.charAt(0) : (char)44;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getDecimalSeparator() {
        return this.decimalSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        this.decimalSeparatorString = String.valueOf(decimalSeparator);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getDecimalSeparatorString() {
        return this.decimalSeparatorString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setDecimalSeparatorString(String decimalSeparatorString) {
        if (decimalSeparatorString == null) {
            throw new NullPointerException("The input decimal separator is null");
        }
        this.decimalSeparatorString = decimalSeparatorString;
        this.decimalSeparator = decimalSeparatorString.length() == 1 ? decimalSeparatorString.charAt(0) : (char)46;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPerMill() {
        return this.perMill;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPerMill(char perMill) {
        this.perMill = perMill;
        this.perMillString = String.valueOf(perMill);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getPerMillString() {
        return this.perMillString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPerMillString(String perMillString) {
        if (perMillString == null) {
            throw new NullPointerException("The input permille string is null");
        }
        this.perMillString = perMillString;
        this.perMill = perMillString.length() == 1 ? perMillString.charAt(0) : (char)8240;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPercent() {
        return this.percent;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPercent(char percent) {
        this.percent = percent;
        this.percentString = String.valueOf(percent);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getPercentString() {
        return this.percentString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPercentString(String percentString) {
        if (percentString == null) {
            throw new NullPointerException("The input percent sign is null");
        }
        this.percentString = percentString;
        this.percent = percentString.length() == 1 ? percentString.charAt(0) : (char)37;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getDigit() {
        return this.digit;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setDigit(char digit) {
        this.digit = digit;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPatternSeparator() {
        return this.patternSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPatternSeparator(char patternSeparator) {
        this.patternSeparator = patternSeparator;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getInfinity() {
        return this.infinity;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setInfinity(String infinity) {
        this.infinity = infinity;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getNaN() {
        return this.NaN;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setNaN(String NaN) {
        this.NaN = NaN;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getMinusSign() {
        return this.minusSign;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMinusSign(char minusSign) {
        this.minusSign = minusSign;
        this.minusString = String.valueOf(minusSign);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getMinusSignString() {
        return this.minusString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMinusSignString(String minusSignString) {
        if (minusSignString == null) {
            throw new NullPointerException("The input minus sign is null");
        }
        this.minusString = minusSignString;
        this.minusSign = minusSignString.length() == 1 ? minusSignString.charAt(0) : (char)45;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPlusSign() {
        return this.plusSign;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPlusSign(char plus) {
        this.plusSign = plus;
        this.plusString = String.valueOf(plus);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getPlusSignString() {
        return this.plusString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPlusSignString(String plusSignString) {
        if (plusSignString == null) {
            throw new NullPointerException("The input plus sign is null");
        }
        this.plusString = plusSignString;
        this.plusSign = plusSignString.length() == 1 ? plusSignString.charAt(0) : (char)43;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getCurrencySymbol() {
        return this.currencySymbol;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setCurrencySymbol(String currency) {
        this.currencySymbol = currency;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setInternationalCurrencySymbol(String currency) {
        this.intlCurrencySymbol = currency;
    }

    private final Currency $$robo$$android_icu_text_DecimalFormatSymbols$getCurrency() {
        return this.currency;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.requestedLocale);
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryDecimalSeparator(char sep) {
        this.monetarySeparator = sep;
        this.monetarySeparatorString = String.valueOf(sep);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryDecimalSeparatorString() {
        return this.monetarySeparatorString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryDecimalSeparatorString(String sep) {
        if (sep == null) {
            throw new NullPointerException("The input monetary decimal separator is null");
        }
        this.monetarySeparatorString = sep;
        this.monetarySeparator = sep.length() == 1 ? sep.charAt(0) : (char)46;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryGroupingSeparator() {
        return this.monetaryGroupingSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryGroupingSeparator(char sep) {
        this.monetaryGroupingSeparator = sep;
        this.monetaryGroupingSeparatorString = String.valueOf(sep);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryGroupingSeparatorString() {
        return this.monetaryGroupingSeparatorString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryGroupingSeparatorString(String sep) {
        if (sep == null) {
            throw new NullPointerException("The input monetary grouping separator is null");
        }
        this.monetaryGroupingSeparatorString = sep;
        this.monetaryGroupingSeparator = sep.length() == 1 ? sep.charAt(0) : (char)44;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getCurrencyPattern() {
        return this.currencyPattern;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getExponentMultiplicationSign() {
        return this.exponentMultiplicationSign;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setExponentMultiplicationSign(String exponentMultiplicationSign) {
        this.exponentMultiplicationSign = exponentMultiplicationSign;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getExponentSeparator() {
        return this.exponentSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setExponentSeparator(String exp) {
        this.exponentSeparator = exp;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPadEscape() {
        return this.padEscape;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPadEscape(char c) {
        this.padEscape = c;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getPatternForCurrencySpacing(int itemType, boolean beforeCurrency) {
        if (itemType < 0 || itemType > 2) {
            throw new IllegalArgumentException("unknown currency spacing: " + itemType);
        }
        if (beforeCurrency) {
            return this.currencySpcBeforeSym[itemType];
        }
        return this.currencySpcAfterSym[itemType];
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPatternForCurrencySpacing(int itemType, boolean beforeCurrency, String pattern) {
        if (itemType < 0 || itemType > 2) {
            throw new IllegalArgumentException("unknown currency spacing: " + itemType);
        }
        if (beforeCurrency) {
            this.currencySpcBeforeSym[itemType] = pattern;
        } else {
            this.currencySpcAfterSym[itemType] = pattern;
        }
    }

    private final Locale $$robo$$android_icu_text_DecimalFormatSymbols$getLocale() {
        return this.requestedLocale;
    }

    private final ULocale $$robo$$android_icu_text_DecimalFormatSymbols$getULocale() {
        return this.ulocale;
    }

    private final Object $$robo$$android_icu_text_DecimalFormatSymbols$clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    private final boolean $$robo$$android_icu_text_DecimalFormatSymbols$equals(Object obj) {
        int i;
        if (!(obj instanceof DecimalFormatSymbols)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DecimalFormatSymbols other = (DecimalFormatSymbols)obj;
        for (i = 0; i <= 2; ++i) {
            if (!this.currencySpcBeforeSym[i].equals(other.currencySpcBeforeSym[i])) {
                return false;
            }
            if (this.currencySpcAfterSym[i].equals(other.currencySpcAfterSym[i])) continue;
            return false;
        }
        if (other.digits == null) {
            for (i = 0; i < 10; ++i) {
                if (this.digits[i] == other.zeroDigit + i) continue;
                return false;
            }
        } else if (!Arrays.equals(this.digits, other.digits)) {
            return false;
        }
        return this.groupingSeparator == other.groupingSeparator && this.decimalSeparator == other.decimalSeparator && this.percent == other.percent && this.perMill == other.perMill && this.digit == other.digit && this.minusSign == other.minusSign && this.minusString.equals(other.minusString) && this.patternSeparator == other.patternSeparator && this.infinity.equals(other.infinity) && this.NaN.equals(other.NaN) && this.currencySymbol.equals(other.currencySymbol) && this.intlCurrencySymbol.equals(other.intlCurrencySymbol) && this.padEscape == other.padEscape && this.plusSign == other.plusSign && this.plusString.equals(other.plusString) && this.exponentSeparator.equals(other.exponentSeparator) && this.monetarySeparator == other.monetarySeparator && this.monetaryGroupingSeparator == other.monetaryGroupingSeparator && this.exponentMultiplicationSign.equals(other.exponentMultiplicationSign);
    }

    private final int $$robo$$android_icu_text_DecimalFormatSymbols$hashCode() {
        int result = this.digits[0];
        result = result * 37 + this.groupingSeparator;
        result = result * 37 + this.decimalSeparator;
        return result;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$initialize(ULocale locale, NumberingSystem ns) {
        this.requestedLocale = locale.toLocale();
        this.ulocale = locale;
        ULocale keyLocale = ns == null ? locale : locale.setKeywordValue("numbers", ns.getName());
        CacheData data = cachedLocaleData.getInstance(keyLocale, null);
        this.setLocale(data.validLocale, data.validLocale);
        this.setDigitStrings(data.digits);
        String[] numberElements = data.numberElements;
        this.setDecimalSeparatorString(numberElements[0]);
        this.setGroupingSeparatorString(numberElements[1]);
        this.patternSeparator = numberElements[2].charAt(0);
        this.setPercentString(numberElements[3]);
        this.setMinusSignString(numberElements[4]);
        this.setPlusSignString(numberElements[5]);
        this.setExponentSeparator(numberElements[6]);
        this.setPerMillString(numberElements[7]);
        this.setInfinity(numberElements[8]);
        this.setNaN(numberElements[9]);
        this.setMonetaryDecimalSeparatorString(numberElements[10]);
        this.setMonetaryGroupingSeparatorString(numberElements[11]);
        this.setExponentMultiplicationSign(numberElements[12]);
        this.digit = (char)35;
        this.padEscape = (char)42;
        this.sigDigit = (char)64;
        CurrencyData.CurrencyDisplayInfo info = CurrencyData.provider.getInstance(locale, true);
        this.currency = Currency.getInstance(locale);
        if (this.currency != null) {
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
            this.currencySymbol = this.currency.getName(locale, 0, null);
            CurrencyData.CurrencyFormatInfo fmtInfo = info.getFormatInfo(this.intlCurrencySymbol);
            if (fmtInfo != null) {
                this.currencyPattern = fmtInfo.currencyPattern;
                this.setMonetaryDecimalSeparatorString(fmtInfo.monetaryDecimalSeparator);
                this.setMonetaryGroupingSeparatorString(fmtInfo.monetaryGroupingSeparator);
            }
        } else {
            this.intlCurrencySymbol = "XXX";
            this.currencySymbol = "\u00a4";
        }
        this.initSpacingInfo(info.getSpacingInfo());
    }

    private static final CacheData $$robo$$android_icu_text_DecimalFormatSymbols$loadData(ULocale locale) {
        String nsName;
        NumberingSystem ns = NumberingSystem.getInstance(locale);
        String[] digits = new String[10];
        if (ns != null && ns.getRadix() == 10 && !ns.isAlgorithmic() && NumberingSystem.isValidDigitString(ns.getDescription())) {
            String digitString = ns.getDescription();
            int offset = 0;
            for (int i = 0; i < 10; ++i) {
                int cp = digitString.codePointAt(offset);
                int nextOffset = offset + Character.charCount(cp);
                digits[i] = digitString.substring(offset, nextOffset);
                offset = nextOffset;
            }
            nsName = ns.getName();
        } else {
            digits = DEF_DIGIT_STRINGS_ARRAY;
            nsName = "latn";
        }
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b", locale);
        ULocale validLocale = rb.getULocale();
        String[] numberElements = new String[SYMBOL_KEYS.length];
        DecFmtDataSink sink = new DecFmtDataSink(numberElements);
        try {
            rb.getAllItemsWithFallback("NumberElements/" + nsName + "/" + "symbols", sink);
        }
        catch (MissingResourceException nextOffset) {
            // empty catch block
        }
        boolean hasNull = false;
        for (String entry : numberElements) {
            if (entry != null) continue;
            hasNull = true;
            break;
        }
        if (hasNull && !nsName.equals("latn")) {
            rb.getAllItemsWithFallback("NumberElements/latn/symbols", sink);
        }
        for (int i = 0; i < SYMBOL_KEYS.length; ++i) {
            if (numberElements[i] != null) continue;
            numberElements[i] = SYMBOL_DEFAULTS[i];
        }
        if (numberElements[10] == null) {
            numberElements[10] = numberElements[0];
        }
        if (numberElements[11] == null) {
            numberElements[11] = numberElements[1];
        }
        return new CacheData(validLocale, digits, numberElements);
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$initSpacingInfo(CurrencyData.CurrencySpacingInfo spcInfo) {
        this.currencySpcBeforeSym = spcInfo.getBeforeSymbols();
        this.currencySpcAfterSym = spcInfo.getAfterSymbols();
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.padEscape = (char)42;
            this.plusSign = (char)43;
            this.exponentSeparator = String.valueOf(this.exponential);
        }
        if (this.serialVersionOnStream < 3) {
            this.requestedLocale = Locale.getDefault();
        }
        if (this.serialVersionOnStream < 4) {
            this.ulocale = ULocale.forLocale(this.requestedLocale);
        }
        if (this.serialVersionOnStream < 5) {
            this.monetaryGroupingSeparator = this.groupingSeparator;
        }
        if (this.serialVersionOnStream < 6) {
            if (this.currencySpcBeforeSym == null) {
                this.currencySpcBeforeSym = new String[3];
            }
            if (this.currencySpcAfterSym == null) {
                this.currencySpcAfterSym = new String[3];
            }
            this.initSpacingInfo(CurrencyData.CurrencySpacingInfo.DEFAULT);
        }
        if (this.serialVersionOnStream < 7) {
            if (this.minusString == null) {
                this.minusString = String.valueOf(this.minusSign);
            }
            if (this.plusString == null) {
                this.plusString = String.valueOf(this.plusSign);
            }
        }
        if (this.serialVersionOnStream < 8 && this.exponentMultiplicationSign == null) {
            this.exponentMultiplicationSign = "\u00d7";
        }
        if (this.serialVersionOnStream < 9) {
            if (this.digitStrings == null) {
                this.digitStrings = new String[10];
                if (this.digits != null && this.digits.length == 10) {
                    this.zeroDigit = this.digits[0];
                    for (int i = 0; i < 10; ++i) {
                        this.digitStrings[i] = String.valueOf(this.digits[i]);
                    }
                } else {
                    char digit = this.zeroDigit;
                    if (this.digits == null) {
                        this.digits = new char[10];
                    }
                    for (int i = 0; i < 10; ++i) {
                        this.digits[i] = digit;
                        this.digitStrings[i] = String.valueOf(digit);
                        digit = (char)(digit + '\u0001');
                    }
                }
            }
            if (this.decimalSeparatorString == null) {
                this.decimalSeparatorString = String.valueOf(this.decimalSeparator);
            }
            if (this.groupingSeparatorString == null) {
                this.groupingSeparatorString = String.valueOf(this.groupingSeparator);
            }
            if (this.percentString == null) {
                this.percentString = String.valueOf(this.percent);
            }
            if (this.perMillString == null) {
                this.perMillString = String.valueOf(this.perMill);
            }
            if (this.monetarySeparatorString == null) {
                this.monetarySeparatorString = String.valueOf(this.monetarySeparator);
            }
            if (this.monetaryGroupingSeparatorString == null) {
                this.monetaryGroupingSeparatorString = String.valueOf(this.monetaryGroupingSeparator);
            }
        }
        this.serialVersionOnStream = 8;
        this.currency = Currency.getInstance(this.intlCurrencySymbol);
        this.setDigitStrings(this.digitStrings);
    }

    private final ULocale $$robo$$android_icu_text_DecimalFormatSymbols$getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static void __staticInitializer__() {
        SYMBOL_KEYS = new String[]{"decimal", "group", "list", "percentSign", "minusSign", "plusSign", "exponential", "perMille", "infinity", "nan", "currencyDecimal", "currencyGroup", "superscriptingExponent"};
        DEF_DIGIT_STRINGS_ARRAY = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        DEF_DIGIT_CHARS_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        SYMBOL_DEFAULTS = new String[]{String.valueOf('.'), String.valueOf(','), ";", String.valueOf('%'), String.valueOf('-'), String.valueOf('+'), "E", String.valueOf('\u2030'), "\u221e", "NaN", null, null, "\u00d7"};
        cachedLocaleData = new SoftCache<ULocale, CacheData, Void>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_text_DecimalFormatSymbols_1$__constructor__() {
            }

            private final CacheData $$robo$$android_icu_text_DecimalFormatSymbols_1$createInstance(ULocale locale, Void unused) {
                return DecimalFormatSymbols.loadData(locale);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_DecimalFormatSymbols_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols_1$__constructor__(), this);
            }

            @Override
            protected CacheData createInstance(ULocale uLocale, Void void_) {
                return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_text_DecimalFormatSymbols_1$createInstance(android.icu.util.ULocale java.lang.Void ), this, uLocale, void_);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DecimalFormatSymbols$__constructor__();
    }

    public DecimalFormatSymbols() {
        this(ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(), this);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(locale);
    }

    public DecimalFormatSymbols(Locale locale) {
        this(ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(java.util.Locale ), this, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(uLocale);
    }

    public DecimalFormatSymbols(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(android.icu.util.ULocale ), this, uLocale);
    }

    private void __constructor__(Locale locale, NumberingSystem numberingSystem) {
        this.$$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(locale, numberingSystem);
    }

    public DecimalFormatSymbols(Locale locale, NumberingSystem numberingSystem) {
        this(ULocale.forLocale(locale), numberingSystem);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(java.util.Locale android.icu.text.NumberingSystem ), this, locale, numberingSystem);
    }

    private void __constructor__(ULocale uLocale, NumberingSystem numberingSystem) {
        this.$$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(uLocale, numberingSystem);
    }

    public DecimalFormatSymbols(ULocale uLocale, NumberingSystem numberingSystem) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(android.icu.util.ULocale android.icu.text.NumberingSystem ), this, uLocale, numberingSystem);
    }

    public static DecimalFormatSymbols getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DecimalFormatSymbols$getInstance());
    }

    public static DecimalFormatSymbols getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(java.util.Locale ), (Locale)locale);
    }

    public static DecimalFormatSymbols getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    public static DecimalFormatSymbols forNumberingSystem(Locale locale, NumberingSystem numberingSystem) {
        return InvokeDynamicSupport.bootstrapStatic("forNumberingSystem", $$robo$$android_icu_text_DecimalFormatSymbols$forNumberingSystem(java.util.Locale android.icu.text.NumberingSystem ), (Locale)locale, (NumberingSystem)numberingSystem);
    }

    public static DecimalFormatSymbols forNumberingSystem(ULocale uLocale, NumberingSystem numberingSystem) {
        return InvokeDynamicSupport.bootstrapStatic("forNumberingSystem", $$robo$$android_icu_text_DecimalFormatSymbols$forNumberingSystem(android.icu.util.ULocale android.icu.text.NumberingSystem ), (ULocale)uLocale, (NumberingSystem)numberingSystem);
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_text_DecimalFormatSymbols$getAvailableLocales());
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_text_DecimalFormatSymbols$getAvailableULocales());
    }

    public char getZeroDigit() {
        return (char)InvokeDynamicSupport.bootstrap("getZeroDigit", $$robo$$android_icu_text_DecimalFormatSymbols$getZeroDigit(), this);
    }

    public char[] getDigits() {
        return InvokeDynamicSupport.bootstrap("getDigits", $$robo$$android_icu_text_DecimalFormatSymbols$getDigits(), this);
    }

    public void setZeroDigit(char c) {
        InvokeDynamicSupport.bootstrap("setZeroDigit", $$robo$$android_icu_text_DecimalFormatSymbols$setZeroDigit(char ), this, c);
    }

    public String[] getDigitStrings() {
        return InvokeDynamicSupport.bootstrap("getDigitStrings", $$robo$$android_icu_text_DecimalFormatSymbols$getDigitStrings(), this);
    }

    @Deprecated
    public String[] getDigitStringsLocal() {
        return InvokeDynamicSupport.bootstrap("getDigitStringsLocal", $$robo$$android_icu_text_DecimalFormatSymbols$getDigitStringsLocal(), this);
    }

    @Deprecated
    public int getCodePointZero() {
        return (int)InvokeDynamicSupport.bootstrap("getCodePointZero", $$robo$$android_icu_text_DecimalFormatSymbols$getCodePointZero(), this);
    }

    public void setDigitStrings(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setDigitStrings", $$robo$$android_icu_text_DecimalFormatSymbols$setDigitStrings(java.lang.String[] ), this, stringArray);
    }

    public char getSignificantDigit() {
        return (char)InvokeDynamicSupport.bootstrap("getSignificantDigit", $$robo$$android_icu_text_DecimalFormatSymbols$getSignificantDigit(), this);
    }

    public void setSignificantDigit(char c) {
        InvokeDynamicSupport.bootstrap("setSignificantDigit", $$robo$$android_icu_text_DecimalFormatSymbols$setSignificantDigit(char ), this, c);
    }

    public char getGroupingSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getGroupingSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getGroupingSeparator(), this);
    }

    public void setGroupingSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setGroupingSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setGroupingSeparator(char ), this, c);
    }

    public String getGroupingSeparatorString() {
        return InvokeDynamicSupport.bootstrap("getGroupingSeparatorString", $$robo$$android_icu_text_DecimalFormatSymbols$getGroupingSeparatorString(), this);
    }

    public void setGroupingSeparatorString(String string2) {
        InvokeDynamicSupport.bootstrap("setGroupingSeparatorString", $$robo$$android_icu_text_DecimalFormatSymbols$setGroupingSeparatorString(java.lang.String ), this, string2);
    }

    public char getDecimalSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getDecimalSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getDecimalSeparator(), this);
    }

    public void setDecimalSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setDecimalSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setDecimalSeparator(char ), this, c);
    }

    public String getDecimalSeparatorString() {
        return InvokeDynamicSupport.bootstrap("getDecimalSeparatorString", $$robo$$android_icu_text_DecimalFormatSymbols$getDecimalSeparatorString(), this);
    }

    public void setDecimalSeparatorString(String string2) {
        InvokeDynamicSupport.bootstrap("setDecimalSeparatorString", $$robo$$android_icu_text_DecimalFormatSymbols$setDecimalSeparatorString(java.lang.String ), this, string2);
    }

    public char getPerMill() {
        return (char)InvokeDynamicSupport.bootstrap("getPerMill", $$robo$$android_icu_text_DecimalFormatSymbols$getPerMill(), this);
    }

    public void setPerMill(char c) {
        InvokeDynamicSupport.bootstrap("setPerMill", $$robo$$android_icu_text_DecimalFormatSymbols$setPerMill(char ), this, c);
    }

    public String getPerMillString() {
        return InvokeDynamicSupport.bootstrap("getPerMillString", $$robo$$android_icu_text_DecimalFormatSymbols$getPerMillString(), this);
    }

    public void setPerMillString(String string2) {
        InvokeDynamicSupport.bootstrap("setPerMillString", $$robo$$android_icu_text_DecimalFormatSymbols$setPerMillString(java.lang.String ), this, string2);
    }

    public char getPercent() {
        return (char)InvokeDynamicSupport.bootstrap("getPercent", $$robo$$android_icu_text_DecimalFormatSymbols$getPercent(), this);
    }

    public void setPercent(char c) {
        InvokeDynamicSupport.bootstrap("setPercent", $$robo$$android_icu_text_DecimalFormatSymbols$setPercent(char ), this, c);
    }

    public String getPercentString() {
        return InvokeDynamicSupport.bootstrap("getPercentString", $$robo$$android_icu_text_DecimalFormatSymbols$getPercentString(), this);
    }

    public void setPercentString(String string2) {
        InvokeDynamicSupport.bootstrap("setPercentString", $$robo$$android_icu_text_DecimalFormatSymbols$setPercentString(java.lang.String ), this, string2);
    }

    public char getDigit() {
        return (char)InvokeDynamicSupport.bootstrap("getDigit", $$robo$$android_icu_text_DecimalFormatSymbols$getDigit(), this);
    }

    public void setDigit(char c) {
        InvokeDynamicSupport.bootstrap("setDigit", $$robo$$android_icu_text_DecimalFormatSymbols$setDigit(char ), this, c);
    }

    public char getPatternSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getPatternSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getPatternSeparator(), this);
    }

    public void setPatternSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setPatternSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setPatternSeparator(char ), this, c);
    }

    public String getInfinity() {
        return InvokeDynamicSupport.bootstrap("getInfinity", $$robo$$android_icu_text_DecimalFormatSymbols$getInfinity(), this);
    }

    public void setInfinity(String string2) {
        InvokeDynamicSupport.bootstrap("setInfinity", $$robo$$android_icu_text_DecimalFormatSymbols$setInfinity(java.lang.String ), this, string2);
    }

    public String getNaN() {
        return InvokeDynamicSupport.bootstrap("getNaN", $$robo$$android_icu_text_DecimalFormatSymbols$getNaN(), this);
    }

    public void setNaN(String string2) {
        InvokeDynamicSupport.bootstrap("setNaN", $$robo$$android_icu_text_DecimalFormatSymbols$setNaN(java.lang.String ), this, string2);
    }

    public char getMinusSign() {
        return (char)InvokeDynamicSupport.bootstrap("getMinusSign", $$robo$$android_icu_text_DecimalFormatSymbols$getMinusSign(), this);
    }

    public void setMinusSign(char c) {
        InvokeDynamicSupport.bootstrap("setMinusSign", $$robo$$android_icu_text_DecimalFormatSymbols$setMinusSign(char ), this, c);
    }

    public String getMinusSignString() {
        return InvokeDynamicSupport.bootstrap("getMinusSignString", $$robo$$android_icu_text_DecimalFormatSymbols$getMinusSignString(), this);
    }

    public void setMinusSignString(String string2) {
        InvokeDynamicSupport.bootstrap("setMinusSignString", $$robo$$android_icu_text_DecimalFormatSymbols$setMinusSignString(java.lang.String ), this, string2);
    }

    public char getPlusSign() {
        return (char)InvokeDynamicSupport.bootstrap("getPlusSign", $$robo$$android_icu_text_DecimalFormatSymbols$getPlusSign(), this);
    }

    public void setPlusSign(char c) {
        InvokeDynamicSupport.bootstrap("setPlusSign", $$robo$$android_icu_text_DecimalFormatSymbols$setPlusSign(char ), this, c);
    }

    public String getPlusSignString() {
        return InvokeDynamicSupport.bootstrap("getPlusSignString", $$robo$$android_icu_text_DecimalFormatSymbols$getPlusSignString(), this);
    }

    public void setPlusSignString(String string2) {
        InvokeDynamicSupport.bootstrap("setPlusSignString", $$robo$$android_icu_text_DecimalFormatSymbols$setPlusSignString(java.lang.String ), this, string2);
    }

    public String getCurrencySymbol() {
        return InvokeDynamicSupport.bootstrap("getCurrencySymbol", $$robo$$android_icu_text_DecimalFormatSymbols$getCurrencySymbol(), this);
    }

    public void setCurrencySymbol(String string2) {
        InvokeDynamicSupport.bootstrap("setCurrencySymbol", $$robo$$android_icu_text_DecimalFormatSymbols$setCurrencySymbol(java.lang.String ), this, string2);
    }

    public String getInternationalCurrencySymbol() {
        return InvokeDynamicSupport.bootstrap("getInternationalCurrencySymbol", $$robo$$android_icu_text_DecimalFormatSymbols$getInternationalCurrencySymbol(), this);
    }

    public void setInternationalCurrencySymbol(String string2) {
        InvokeDynamicSupport.bootstrap("setInternationalCurrencySymbol", $$robo$$android_icu_text_DecimalFormatSymbols$setInternationalCurrencySymbol(java.lang.String ), this, string2);
    }

    public Currency getCurrency() {
        return InvokeDynamicSupport.bootstrap("getCurrency", $$robo$$android_icu_text_DecimalFormatSymbols$getCurrency(), this);
    }

    public void setCurrency(Currency currency) {
        InvokeDynamicSupport.bootstrap("setCurrency", $$robo$$android_icu_text_DecimalFormatSymbols$setCurrency(android.icu.util.Currency ), this, currency);
    }

    public char getMonetaryDecimalSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getMonetaryDecimalSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryDecimalSeparator(), this);
    }

    public void setMonetaryDecimalSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setMonetaryDecimalSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryDecimalSeparator(char ), this, c);
    }

    public String getMonetaryDecimalSeparatorString() {
        return InvokeDynamicSupport.bootstrap("getMonetaryDecimalSeparatorString", $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryDecimalSeparatorString(), this);
    }

    public void setMonetaryDecimalSeparatorString(String string2) {
        InvokeDynamicSupport.bootstrap("setMonetaryDecimalSeparatorString", $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryDecimalSeparatorString(java.lang.String ), this, string2);
    }

    public char getMonetaryGroupingSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getMonetaryGroupingSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryGroupingSeparator(), this);
    }

    public void setMonetaryGroupingSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setMonetaryGroupingSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryGroupingSeparator(char ), this, c);
    }

    public String getMonetaryGroupingSeparatorString() {
        return InvokeDynamicSupport.bootstrap("getMonetaryGroupingSeparatorString", $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryGroupingSeparatorString(), this);
    }

    public void setMonetaryGroupingSeparatorString(String string2) {
        InvokeDynamicSupport.bootstrap("setMonetaryGroupingSeparatorString", $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryGroupingSeparatorString(java.lang.String ), this, string2);
    }

    String getCurrencyPattern() {
        return InvokeDynamicSupport.bootstrap("getCurrencyPattern", $$robo$$android_icu_text_DecimalFormatSymbols$getCurrencyPattern(), this);
    }

    public String getExponentMultiplicationSign() {
        return InvokeDynamicSupport.bootstrap("getExponentMultiplicationSign", $$robo$$android_icu_text_DecimalFormatSymbols$getExponentMultiplicationSign(), this);
    }

    public void setExponentMultiplicationSign(String string2) {
        InvokeDynamicSupport.bootstrap("setExponentMultiplicationSign", $$robo$$android_icu_text_DecimalFormatSymbols$setExponentMultiplicationSign(java.lang.String ), this, string2);
    }

    public String getExponentSeparator() {
        return InvokeDynamicSupport.bootstrap("getExponentSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getExponentSeparator(), this);
    }

    public void setExponentSeparator(String string2) {
        InvokeDynamicSupport.bootstrap("setExponentSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setExponentSeparator(java.lang.String ), this, string2);
    }

    public char getPadEscape() {
        return (char)InvokeDynamicSupport.bootstrap("getPadEscape", $$robo$$android_icu_text_DecimalFormatSymbols$getPadEscape(), this);
    }

    public void setPadEscape(char c) {
        InvokeDynamicSupport.bootstrap("setPadEscape", $$robo$$android_icu_text_DecimalFormatSymbols$setPadEscape(char ), this, c);
    }

    public String getPatternForCurrencySpacing(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPatternForCurrencySpacing", $$robo$$android_icu_text_DecimalFormatSymbols$getPatternForCurrencySpacing(int boolean ), this, n, bl);
    }

    public void setPatternForCurrencySpacing(int n, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("setPatternForCurrencySpacing", $$robo$$android_icu_text_DecimalFormatSymbols$setPatternForCurrencySpacing(int boolean java.lang.String ), this, n, bl, string2);
    }

    public Locale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_DecimalFormatSymbols$getLocale(), this);
    }

    public ULocale getULocale() {
        return InvokeDynamicSupport.bootstrap("getULocale", $$robo$$android_icu_text_DecimalFormatSymbols$getULocale(), this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_DecimalFormatSymbols$clone(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DecimalFormatSymbols$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DecimalFormatSymbols$hashCode(), this);
    }

    private void initialize(ULocale uLocale, NumberingSystem numberingSystem) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_icu_text_DecimalFormatSymbols$initialize(android.icu.util.ULocale android.icu.text.NumberingSystem ), this, uLocale, numberingSystem);
    }

    private static CacheData loadData(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("loadData", $$robo$$android_icu_text_DecimalFormatSymbols$loadData(android.icu.util.ULocale ), (ULocale)uLocale);
    }

    private void initSpacingInfo(CurrencyData.CurrencySpacingInfo currencySpacingInfo) {
        InvokeDynamicSupport.bootstrap("initSpacingInfo", $$robo$$android_icu_text_DecimalFormatSymbols$initSpacingInfo(android.icu.impl.CurrencyData$CurrencySpacingInfo ), this, currencySpacingInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_DecimalFormatSymbols$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    public ULocale getLocale(ULocale.Type type) {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_DecimalFormatSymbols$getLocale(android.icu.util.ULocale$Type ), this, type);
    }

    void setLocale(ULocale uLocale, ULocale uLocale2) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_DecimalFormatSymbols$setLocale(android.icu.util.ULocale android.icu.util.ULocale ), this, uLocale, uLocale2);
    }

    static {
        RobolectricInternals.classInitializing(DecimalFormatSymbols.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecimalFormatSymbols)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CacheData
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ULocale validLocale;
        String[] digits;
        String[] numberElements;

        private void $$robo$$android_icu_text_DecimalFormatSymbols_CacheData$__constructor__(ULocale loc, String[] digits, String[] numberElements) {
            this.validLocale = loc;
            this.digits = digits;
            this.numberElements = numberElements;
        }

        private void __constructor__(ULocale uLocale, String[] stringArray, String[] stringArray2) {
            this.$$robo$$android_icu_text_DecimalFormatSymbols_CacheData$__constructor__(uLocale, stringArray, stringArray2);
        }

        public CacheData(ULocale uLocale, String[] stringArray, String[] stringArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols_CacheData$__constructor__(android.icu.util.ULocale java.lang.String[] java.lang.String[] ), this, uLocale, stringArray, stringArray2);
        }

        public /* synthetic */ CacheData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CacheData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DecFmtDataSink
    extends UResource.Sink
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String[] numberElements;

        private void $$robo$$android_icu_text_DecimalFormatSymbols_DecFmtDataSink$__constructor__(String[] numberElements) {
            this.numberElements = numberElements;
        }

        private final void $$robo$$android_icu_text_DecimalFormatSymbols_DecFmtDataSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table symbolsTable = value.getTable();
            int j = 0;
            while (symbolsTable.getKeyAndValue(j, key, value)) {
                for (int i = 0; i < SYMBOL_KEYS.length; ++i) {
                    if (!key.contentEquals(SYMBOL_KEYS[i])) continue;
                    if (this.numberElements[i] != null) break;
                    this.numberElements[i] = value.toString();
                    break;
                }
                ++j;
            }
        }

        private void __constructor__(String[] stringArray) {
            this.$$robo$$android_icu_text_DecimalFormatSymbols_DecFmtDataSink$__constructor__(stringArray);
        }

        public DecFmtDataSink(String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols_DecFmtDataSink$__constructor__(java.lang.String[] ), this, stringArray);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_DecimalFormatSymbols_DecFmtDataSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), this, key, value, bl);
        }

        public /* synthetic */ DecFmtDataSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecFmtDataSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

