/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.Normalizer;
import android.icu.text.Normalizer2;
import android.icu.text.UnicodeSet;
import android.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FilteredNormalizer2
extends Normalizer2
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Normalizer2 norm2;
    private UnicodeSet set;

    private void $$robo$$android_icu_text_FilteredNormalizer2$__constructor__(Normalizer2 n2, UnicodeSet filterSet) {
        this.norm2 = n2;
        this.set = filterSet;
    }

    private final StringBuilder $$robo$$android_icu_text_FilteredNormalizer2$normalize(CharSequence src, StringBuilder dest) {
        if (dest == src) {
            throw new IllegalArgumentException();
        }
        dest.setLength(0);
        this.normalize(src, dest, UnicodeSet.SpanCondition.SIMPLE);
        return dest;
    }

    private final Appendable $$robo$$android_icu_text_FilteredNormalizer2$normalize(CharSequence src, Appendable dest) {
        if (dest == src) {
            throw new IllegalArgumentException();
        }
        return this.normalize(src, dest, UnicodeSet.SpanCondition.SIMPLE);
    }

    private final StringBuilder $$robo$$android_icu_text_FilteredNormalizer2$normalizeSecondAndAppend(StringBuilder first, CharSequence second) {
        return this.normalizeSecondAndAppend(first, second, true);
    }

    private final StringBuilder $$robo$$android_icu_text_FilteredNormalizer2$append(StringBuilder first, CharSequence second) {
        return this.normalizeSecondAndAppend(first, second, false);
    }

    private final String $$robo$$android_icu_text_FilteredNormalizer2$getDecomposition(int c) {
        return this.set.contains(c) ? this.norm2.getDecomposition(c) : null;
    }

    private final String $$robo$$android_icu_text_FilteredNormalizer2$getRawDecomposition(int c) {
        return this.set.contains(c) ? this.norm2.getRawDecomposition(c) : null;
    }

    private final int $$robo$$android_icu_text_FilteredNormalizer2$composePair(int a, int b) {
        return this.set.contains(a) && this.set.contains(b) ? this.norm2.composePair(a, b) : -1;
    }

    private final int $$robo$$android_icu_text_FilteredNormalizer2$getCombiningClass(int c) {
        return this.set.contains(c) ? this.norm2.getCombiningClass(c) : 0;
    }

    private final boolean $$robo$$android_icu_text_FilteredNormalizer2$isNormalized(CharSequence s) {
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int prevSpanLimit = 0;
        while (prevSpanLimit < s.length()) {
            int spanLimit = this.set.span(s, prevSpanLimit, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                if (!this.norm2.isNormalized(s.subSequence(prevSpanLimit, spanLimit))) {
                    return false;
                }
                spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            prevSpanLimit = spanLimit;
        }
        return true;
    }

    private final Normalizer.QuickCheckResult $$robo$$android_icu_text_FilteredNormalizer2$quickCheck(CharSequence s) {
        Normalizer.QuickCheckResult result = Normalizer.YES;
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int prevSpanLimit = 0;
        while (prevSpanLimit < s.length()) {
            int spanLimit = this.set.span(s, prevSpanLimit, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                Normalizer.QuickCheckResult qcResult = this.norm2.quickCheck(s.subSequence(prevSpanLimit, spanLimit));
                if (qcResult == Normalizer.NO) {
                    return qcResult;
                }
                if (qcResult == Normalizer.MAYBE) {
                    result = qcResult;
                }
                spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            prevSpanLimit = spanLimit;
        }
        return result;
    }

    private final int $$robo$$android_icu_text_FilteredNormalizer2$spanQuickCheckYes(CharSequence s) {
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int prevSpanLimit = 0;
        while (prevSpanLimit < s.length()) {
            int spanLimit = this.set.span(s, prevSpanLimit, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                int yesLimit = prevSpanLimit + this.norm2.spanQuickCheckYes(s.subSequence(prevSpanLimit, spanLimit));
                if (yesLimit < spanLimit) {
                    return yesLimit;
                }
                spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            prevSpanLimit = spanLimit;
        }
        return s.length();
    }

    private final boolean $$robo$$android_icu_text_FilteredNormalizer2$hasBoundaryBefore(int c) {
        return !this.set.contains(c) || this.norm2.hasBoundaryBefore(c);
    }

    private final boolean $$robo$$android_icu_text_FilteredNormalizer2$hasBoundaryAfter(int c) {
        return !this.set.contains(c) || this.norm2.hasBoundaryAfter(c);
    }

    private final boolean $$robo$$android_icu_text_FilteredNormalizer2$isInert(int c) {
        return !this.set.contains(c) || this.norm2.isInert(c);
    }

    private final Appendable $$robo$$android_icu_text_FilteredNormalizer2$normalize(CharSequence src, Appendable dest, UnicodeSet.SpanCondition spanCondition) {
        StringBuilder tempDest = new StringBuilder();
        try {
            int prevSpanLimit = 0;
            while (prevSpanLimit < src.length()) {
                int spanLimit = this.set.span(src, prevSpanLimit, spanCondition);
                int spanLength = spanLimit - prevSpanLimit;
                if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                    if (spanLength != 0) {
                        dest.append(src, prevSpanLimit, spanLimit);
                    }
                    spanCondition = UnicodeSet.SpanCondition.SIMPLE;
                } else {
                    if (spanLength != 0) {
                        dest.append(this.norm2.normalize(src.subSequence(prevSpanLimit, spanLimit), tempDest));
                    }
                    spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
                }
                prevSpanLimit = spanLimit;
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
        return dest;
    }

    private final StringBuilder $$robo$$android_icu_text_FilteredNormalizer2$normalizeSecondAndAppend(StringBuilder first, CharSequence second, boolean doNormalize) {
        if (first == second) {
            throw new IllegalArgumentException();
        }
        if (first.length() == 0) {
            if (doNormalize) {
                return this.normalize(second, first);
            }
            return first.append(second);
        }
        int prefixLimit = this.set.span(second, 0, UnicodeSet.SpanCondition.SIMPLE);
        if (prefixLimit != 0) {
            CharSequence prefix = second.subSequence(0, prefixLimit);
            int suffixStart = this.set.spanBack(first, Integer.MAX_VALUE, UnicodeSet.SpanCondition.SIMPLE);
            if (suffixStart == 0) {
                if (doNormalize) {
                    this.norm2.normalizeSecondAndAppend(first, prefix);
                } else {
                    this.norm2.append(first, prefix);
                }
            } else {
                StringBuilder middle = new StringBuilder(first.subSequence(suffixStart, first.length()));
                if (doNormalize) {
                    this.norm2.normalizeSecondAndAppend(middle, prefix);
                } else {
                    this.norm2.append(middle, prefix);
                }
                first.delete(suffixStart, Integer.MAX_VALUE).append((CharSequence)middle);
            }
        }
        if (prefixLimit < second.length()) {
            CharSequence rest = second.subSequence(prefixLimit, second.length());
            if (doNormalize) {
                this.normalize(rest, first, UnicodeSet.SpanCondition.NOT_CONTAINED);
            } else {
                first.append(rest);
            }
        }
        return first;
    }

    private void __constructor__(Normalizer2 normalizer2, UnicodeSet unicodeSet) {
        this.$$robo$$android_icu_text_FilteredNormalizer2$__constructor__(normalizer2, unicodeSet);
    }

    public FilteredNormalizer2(Normalizer2 normalizer2, UnicodeSet unicodeSet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_FilteredNormalizer2$__constructor__(android.icu.text.Normalizer2 android.icu.text.UnicodeSet ), this, normalizer2, unicodeSet);
    }

    @Override
    public StringBuilder normalize(CharSequence charSequence, StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("normalize", $$robo$$android_icu_text_FilteredNormalizer2$normalize(java.lang.CharSequence java.lang.StringBuilder ), this, charSequence, stringBuilder);
    }

    @Override
    public Appendable normalize(CharSequence charSequence, Appendable appendable) {
        return InvokeDynamicSupport.bootstrap("normalize", $$robo$$android_icu_text_FilteredNormalizer2$normalize(java.lang.CharSequence java.lang.Appendable ), this, charSequence, appendable);
    }

    @Override
    public StringBuilder normalizeSecondAndAppend(StringBuilder stringBuilder, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("normalizeSecondAndAppend", $$robo$$android_icu_text_FilteredNormalizer2$normalizeSecondAndAppend(java.lang.StringBuilder java.lang.CharSequence ), this, stringBuilder, charSequence);
    }

    @Override
    public StringBuilder append(StringBuilder stringBuilder, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_FilteredNormalizer2$append(java.lang.StringBuilder java.lang.CharSequence ), this, stringBuilder, charSequence);
    }

    @Override
    public String getDecomposition(int n) {
        return InvokeDynamicSupport.bootstrap("getDecomposition", $$robo$$android_icu_text_FilteredNormalizer2$getDecomposition(int ), this, n);
    }

    @Override
    public String getRawDecomposition(int n) {
        return InvokeDynamicSupport.bootstrap("getRawDecomposition", $$robo$$android_icu_text_FilteredNormalizer2$getRawDecomposition(int ), this, n);
    }

    @Override
    public int composePair(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("composePair", $$robo$$android_icu_text_FilteredNormalizer2$composePair(int int ), this, n, n2);
    }

    @Override
    public int getCombiningClass(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCombiningClass", $$robo$$android_icu_text_FilteredNormalizer2$getCombiningClass(int ), this, n);
    }

    @Override
    public boolean isNormalized(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNormalized", $$robo$$android_icu_text_FilteredNormalizer2$isNormalized(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public Normalizer.QuickCheckResult quickCheck(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("quickCheck", $$robo$$android_icu_text_FilteredNormalizer2$quickCheck(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public int spanQuickCheckYes(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrap("spanQuickCheckYes", $$robo$$android_icu_text_FilteredNormalizer2$spanQuickCheckYes(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public boolean hasBoundaryBefore(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBoundaryBefore", $$robo$$android_icu_text_FilteredNormalizer2$hasBoundaryBefore(int ), this, n);
    }

    @Override
    public boolean hasBoundaryAfter(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBoundaryAfter", $$robo$$android_icu_text_FilteredNormalizer2$hasBoundaryAfter(int ), this, n);
    }

    @Override
    public boolean isInert(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInert", $$robo$$android_icu_text_FilteredNormalizer2$isInert(int ), this, n);
    }

    private Appendable normalize(CharSequence charSequence, Appendable appendable, UnicodeSet.SpanCondition spanCondition) {
        return InvokeDynamicSupport.bootstrap("normalize", $$robo$$android_icu_text_FilteredNormalizer2$normalize(java.lang.CharSequence java.lang.Appendable android.icu.text.UnicodeSet$SpanCondition ), this, charSequence, appendable, spanCondition);
    }

    private StringBuilder normalizeSecondAndAppend(StringBuilder stringBuilder, CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("normalizeSecondAndAppend", $$robo$$android_icu_text_FilteredNormalizer2$normalizeSecondAndAppend(java.lang.StringBuilder java.lang.CharSequence boolean ), this, stringBuilder, charSequence, bl);
    }

    public /* synthetic */ FilteredNormalizer2() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FilteredNormalizer2)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

