/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.Norm2AllModes;
import android.icu.impl.Normalizer2Impl;
import android.icu.impl.UCaseProps;
import android.icu.lang.UCharacter;
import android.icu.text.FilteredNormalizer2;
import android.icu.text.Normalizer2;
import android.icu.text.UCharacterIterator;
import android.icu.text.UTF16;
import android.icu.text.UnicodeSet;
import android.icu.util.ICUCloneNotSupportedException;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.CharBuffer;
import java.text.CharacterIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Normalizer
implements Cloneable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private UCharacterIterator text;
    private Normalizer2 norm2;
    private Mode mode;
    private int options;
    private int currentIndex;
    private int nextIndex;
    private StringBuilder buffer;
    private int bufferPos;
    @Deprecated
    public static int UNICODE_3_2 = 32;
    @Deprecated
    public static int DONE = -1;
    @Deprecated
    public static Mode NONE;
    @Deprecated
    public static Mode NFD;
    @Deprecated
    public static Mode NFKD;
    @Deprecated
    public static Mode NFC;
    @Deprecated
    public static Mode DEFAULT;
    @Deprecated
    public static Mode NFKC;
    @Deprecated
    public static Mode FCD;
    @Deprecated
    public static Mode NO_OP;
    @Deprecated
    public static Mode COMPOSE;
    @Deprecated
    public static Mode COMPOSE_COMPAT;
    @Deprecated
    public static Mode DECOMP;
    @Deprecated
    public static Mode DECOMP_COMPAT;
    @Deprecated
    public static int IGNORE_HANGUL = 1;
    public static QuickCheckResult NO;
    public static QuickCheckResult YES;
    public static QuickCheckResult MAYBE;
    public static int FOLD_CASE_DEFAULT = 0;
    public static int INPUT_IS_FCD = 131072;
    public static int COMPARE_IGNORE_CASE = 65536;
    public static int COMPARE_CODE_POINT_ORDER = 32768;
    public static int FOLD_CASE_EXCLUDE_SPECIAL_I = 1;
    @Deprecated
    public static int COMPARE_NORM_OPTIONS_SHIFT = 20;
    private static int COMPARE_EQUIV = 524288;

    @Deprecated
    private void $$robo$$android_icu_text_Normalizer$__constructor__(String str, Mode mode, int opt) {
        this.text = UCharacterIterator.getInstance(str);
        this.mode = mode;
        this.options = opt;
        this.norm2 = mode.getNormalizer2(opt);
        this.buffer = new StringBuilder();
    }

    @Deprecated
    private void $$robo$$android_icu_text_Normalizer$__constructor__(CharacterIterator iter, Mode mode, int opt) {
        this.text = UCharacterIterator.getInstance((CharacterIterator)iter.clone());
        this.mode = mode;
        this.options = opt;
        this.norm2 = mode.getNormalizer2(opt);
        this.buffer = new StringBuilder();
    }

    @Deprecated
    private void $$robo$$android_icu_text_Normalizer$__constructor__(UCharacterIterator iter, Mode mode, int options) {
        try {
            this.text = (UCharacterIterator)iter.clone();
            this.mode = mode;
            this.options = options;
            this.norm2 = mode.getNormalizer2(options);
            this.buffer = new StringBuilder();
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    @Deprecated
    private final Object $$robo$$android_icu_text_Normalizer$clone() {
        try {
            Normalizer copy = (Normalizer)super.clone();
            copy.text = (UCharacterIterator)this.text.clone();
            copy.mode = this.mode;
            copy.options = this.options;
            copy.norm2 = this.norm2;
            copy.buffer = new StringBuilder(this.buffer);
            copy.bufferPos = this.bufferPos;
            copy.currentIndex = this.currentIndex;
            copy.nextIndex = this.nextIndex;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    private static final Normalizer2 $$robo$$android_icu_text_Normalizer$getComposeNormalizer2(boolean compat, int options) {
        return (compat ? NFKC : NFC).getNormalizer2(options);
    }

    private static final Normalizer2 $$robo$$android_icu_text_Normalizer$getDecomposeNormalizer2(boolean compat, int options) {
        return (compat ? NFKD : NFD).getNormalizer2(options);
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$compose(String str, boolean compat) {
        return Normalizer.compose(str, compat, 0);
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$compose(String str, boolean compat, int options) {
        return Normalizer.getComposeNormalizer2(compat, options).normalize(str);
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_Normalizer$compose(char[] source, char[] target, boolean compat, int options) {
        return Normalizer.compose(source, 0, source.length, target, 0, target.length, compat, options);
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_Normalizer$compose(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, boolean compat, int options) {
        CharBuffer srcBuffer = CharBuffer.wrap(src, srcStart, srcLimit - srcStart);
        CharsAppendable app = new CharsAppendable(dest, destStart, destLimit);
        Normalizer.getComposeNormalizer2(compat, options).normalize((CharSequence)srcBuffer, app);
        return app.length();
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$decompose(String str, boolean compat) {
        return Normalizer.decompose(str, compat, 0);
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$decompose(String str, boolean compat, int options) {
        return Normalizer.getDecomposeNormalizer2(compat, options).normalize(str);
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_Normalizer$decompose(char[] source, char[] target, boolean compat, int options) {
        return Normalizer.decompose(source, 0, source.length, target, 0, target.length, compat, options);
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_Normalizer$decompose(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, boolean compat, int options) {
        CharBuffer srcBuffer = CharBuffer.wrap(src, srcStart, srcLimit - srcStart);
        CharsAppendable app = new CharsAppendable(dest, destStart, destLimit);
        Normalizer.getDecomposeNormalizer2(compat, options).normalize((CharSequence)srcBuffer, app);
        return app.length();
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$normalize(String str, Mode mode, int options) {
        return mode.getNormalizer2(options).normalize(str);
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$normalize(String src, Mode mode) {
        return Normalizer.normalize(src, mode, 0);
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_Normalizer$normalize(char[] source, char[] target, Mode mode, int options) {
        return Normalizer.normalize(source, 0, source.length, target, 0, target.length, mode, options);
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_Normalizer$normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, Mode mode, int options) {
        CharBuffer srcBuffer = CharBuffer.wrap(src, srcStart, srcLimit - srcStart);
        CharsAppendable app = new CharsAppendable(dest, destStart, destLimit);
        mode.getNormalizer2(options).normalize((CharSequence)srcBuffer, app);
        return app.length();
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$normalize(int char32, Mode mode, int options) {
        if (mode == NFD && options == 0) {
            String decomposition = Normalizer2.getNFCInstance().getDecomposition(char32);
            if (decomposition == null) {
                decomposition = UTF16.valueOf(char32);
            }
            return decomposition;
        }
        return Normalizer.normalize(UTF16.valueOf(char32), mode, options);
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$normalize(int char32, Mode mode) {
        return Normalizer.normalize(char32, mode, 0);
    }

    @Deprecated
    private static final QuickCheckResult $$robo$$android_icu_text_Normalizer$quickCheck(String source, Mode mode) {
        return Normalizer.quickCheck(source, mode, 0);
    }

    @Deprecated
    private static final QuickCheckResult $$robo$$android_icu_text_Normalizer$quickCheck(String source, Mode mode, int options) {
        return mode.getNormalizer2(options).quickCheck(source);
    }

    @Deprecated
    private static final QuickCheckResult $$robo$$android_icu_text_Normalizer$quickCheck(char[] source, Mode mode, int options) {
        return Normalizer.quickCheck(source, 0, source.length, mode, options);
    }

    @Deprecated
    private static final QuickCheckResult $$robo$$android_icu_text_Normalizer$quickCheck(char[] source, int start, int limit, Mode mode, int options) {
        CharBuffer srcBuffer = CharBuffer.wrap(source, start, limit - start);
        return mode.getNormalizer2(options).quickCheck(srcBuffer);
    }

    @Deprecated
    private static final boolean $$robo$$android_icu_text_Normalizer$isNormalized(char[] src, int start, int limit, Mode mode, int options) {
        CharBuffer srcBuffer = CharBuffer.wrap(src, start, limit - start);
        return mode.getNormalizer2(options).isNormalized(srcBuffer);
    }

    @Deprecated
    private static final boolean $$robo$$android_icu_text_Normalizer$isNormalized(String str, Mode mode, int options) {
        return mode.getNormalizer2(options).isNormalized(str);
    }

    @Deprecated
    private static final boolean $$robo$$android_icu_text_Normalizer$isNormalized(int char32, Mode mode, int options) {
        return Normalizer.isNormalized(UTF16.valueOf(char32), mode, options);
    }

    private static final int $$robo$$android_icu_text_Normalizer$compare(char[] s1, int s1Start, int s1Limit, char[] s2, int s2Start, int s2Limit, int options) {
        if (s1 == null || s1Start < 0 || s1Limit < 0 || s2 == null || s2Start < 0 || s2Limit < 0 || s1Limit < s1Start || s2Limit < s2Start) {
            throw new IllegalArgumentException();
        }
        return Normalizer.internalCompare(CharBuffer.wrap(s1, s1Start, s1Limit - s1Start), CharBuffer.wrap(s2, s2Start, s2Limit - s2Start), options);
    }

    private static final int $$robo$$android_icu_text_Normalizer$compare(String s1, String s2, int options) {
        return Normalizer.internalCompare(s1, s2, options);
    }

    private static final int $$robo$$android_icu_text_Normalizer$compare(char[] s1, char[] s2, int options) {
        return Normalizer.internalCompare(CharBuffer.wrap(s1), CharBuffer.wrap(s2), options);
    }

    private static final int $$robo$$android_icu_text_Normalizer$compare(int char32a, int char32b, int options) {
        return Normalizer.internalCompare(UTF16.valueOf(char32a), UTF16.valueOf(char32b), options | 0x20000);
    }

    private static final int $$robo$$android_icu_text_Normalizer$compare(int char32a, String str2, int options) {
        return Normalizer.internalCompare(UTF16.valueOf(char32a), str2, options);
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_Normalizer$concatenate(char[] left, int leftStart, int leftLimit, char[] right, int rightStart, int rightLimit, char[] dest, int destStart, int destLimit, Mode mode, int options) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        if (right == dest && rightStart < destLimit && destStart < rightLimit) {
            throw new IllegalArgumentException("overlapping right and dst ranges");
        }
        StringBuilder destBuilder = new StringBuilder(leftLimit - leftStart + rightLimit - rightStart + 16);
        destBuilder.append(left, leftStart, leftLimit - leftStart);
        CharBuffer rightBuffer = CharBuffer.wrap(right, rightStart, rightLimit - rightStart);
        mode.getNormalizer2(options).append(destBuilder, rightBuffer);
        int destLength = destBuilder.length();
        if (destLength <= destLimit - destStart) {
            destBuilder.getChars(0, destLength, dest, destStart);
            return destLength;
        }
        throw new IndexOutOfBoundsException(Integer.toString(destLength));
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$concatenate(char[] left, char[] right, Mode mode, int options) {
        StringBuilder dest = new StringBuilder(left.length + right.length + 16).append(left);
        return mode.getNormalizer2(options).append(dest, CharBuffer.wrap(right)).toString();
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$concatenate(String left, String right, Mode mode, int options) {
        StringBuilder dest = new StringBuilder(left.length() + right.length() + 16).append(left);
        return mode.getNormalizer2(options).append(dest, right).toString();
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_Normalizer$getFC_NFKC_Closure(int c, char[] dest) {
        String closure = Normalizer.getFC_NFKC_Closure(c);
        int length = closure.length();
        if (length != 0 && dest != null && length <= dest.length) {
            closure.getChars(0, length, dest, 0);
        }
        return length;
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_Normalizer$getFC_NFKC_Closure(int c) {
        Normalizer2 nfkc = NFKCModeImpl.INSTANCE.normalizer2;
        UCaseProps csp = UCaseProps.INSTANCE;
        StringBuilder folded = new StringBuilder();
        int folded1Length = csp.toFullFolding(c, folded, 0);
        if (folded1Length < 0) {
            Normalizer2Impl nfkcImpl = ((Norm2AllModes.Normalizer2WithImpl)nfkc).impl;
            if (nfkcImpl.getCompQuickCheck(nfkcImpl.getNorm16(c)) != 0) {
                return "";
            }
            folded.appendCodePoint(c);
        } else if (folded1Length > 31) {
            folded.appendCodePoint(folded1Length);
        }
        String kc1 = nfkc.normalize(folded);
        String kc2 = nfkc.normalize(UCharacter.foldCase(kc1, 0));
        if (kc1.equals(kc2)) {
            return "";
        }
        return kc2;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$current() {
        if (this.bufferPos < this.buffer.length() || this.nextNormalize()) {
            return this.buffer.codePointAt(this.bufferPos);
        }
        return -1;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$next() {
        if (this.bufferPos < this.buffer.length() || this.nextNormalize()) {
            int c = this.buffer.codePointAt(this.bufferPos);
            this.bufferPos += Character.charCount(c);
            return c;
        }
        return -1;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$previous() {
        if (this.bufferPos > 0 || this.previousNormalize()) {
            int c = this.buffer.codePointBefore(this.bufferPos);
            this.bufferPos -= Character.charCount(c);
            return c;
        }
        return -1;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$reset() {
        this.text.setToStart();
        this.nextIndex = 0;
        this.currentIndex = 0;
        this.clearBuffer();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$setIndexOnly(int index) {
        this.text.setIndex(index);
        this.currentIndex = this.nextIndex = index;
        this.clearBuffer();
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$setIndex(int index) {
        this.setIndexOnly(index);
        return this.current();
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$getBeginIndex() {
        return 0;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$getEndIndex() {
        return this.endIndex();
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$first() {
        this.reset();
        return this.next();
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$last() {
        this.text.setToLimit();
        this.currentIndex = this.nextIndex = this.text.getIndex();
        this.clearBuffer();
        return this.previous();
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$getIndex() {
        if (this.bufferPos < this.buffer.length()) {
            return this.currentIndex;
        }
        return this.nextIndex;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$startIndex() {
        return 0;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$endIndex() {
        return this.text.getLength();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$setMode(Mode newMode) {
        this.mode = newMode;
        this.norm2 = this.mode.getNormalizer2(this.options);
    }

    @Deprecated
    private final Mode $$robo$$android_icu_text_Normalizer$getMode() {
        return this.mode;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$setOption(int option, boolean value) {
        this.options = value ? (this.options |= option) : (this.options &= ~option);
        this.norm2 = this.mode.getNormalizer2(this.options);
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$getOption(int option) {
        if ((this.options & option) != 0) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$getText(char[] fillIn) {
        return this.text.getText(fillIn);
    }

    @Deprecated
    private final int $$robo$$android_icu_text_Normalizer$getLength() {
        return this.text.getLength();
    }

    @Deprecated
    private final String $$robo$$android_icu_text_Normalizer$getText() {
        return this.text.getText();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$setText(StringBuffer newText) {
        UCharacterIterator newIter = UCharacterIterator.getInstance(newText);
        if (newIter == null) {
            throw new IllegalStateException("Could not create a new UCharacterIterator");
        }
        this.text = newIter;
        this.reset();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$setText(char[] newText) {
        UCharacterIterator newIter = UCharacterIterator.getInstance(newText);
        if (newIter == null) {
            throw new IllegalStateException("Could not create a new UCharacterIterator");
        }
        this.text = newIter;
        this.reset();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$setText(String newText) {
        UCharacterIterator newIter = UCharacterIterator.getInstance(newText);
        if (newIter == null) {
            throw new IllegalStateException("Could not create a new UCharacterIterator");
        }
        this.text = newIter;
        this.reset();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$setText(CharacterIterator newText) {
        UCharacterIterator newIter = UCharacterIterator.getInstance(newText);
        if (newIter == null) {
            throw new IllegalStateException("Could not create a new UCharacterIterator");
        }
        this.text = newIter;
        this.reset();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Normalizer$setText(UCharacterIterator newText) {
        try {
            UCharacterIterator newIter = (UCharacterIterator)newText.clone();
            if (newIter == null) {
                throw new IllegalStateException("Could not create a new UCharacterIterator");
            }
            this.text = newIter;
            this.reset();
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException("Could not clone the UCharacterIterator", e);
        }
    }

    private final void $$robo$$android_icu_text_Normalizer$clearBuffer() {
        this.buffer.setLength(0);
        this.bufferPos = 0;
    }

    private final boolean $$robo$$android_icu_text_Normalizer$nextNormalize() {
        this.clearBuffer();
        this.currentIndex = this.nextIndex;
        this.text.setIndex(this.nextIndex);
        int c = this.text.nextCodePoint();
        if (c < 0) {
            return false;
        }
        StringBuilder segment = new StringBuilder().appendCodePoint(c);
        while ((c = this.text.nextCodePoint()) >= 0) {
            if (this.norm2.hasBoundaryBefore(c)) {
                this.text.moveCodePointIndex(-1);
                break;
            }
            segment.appendCodePoint(c);
        }
        this.nextIndex = this.text.getIndex();
        this.norm2.normalize((CharSequence)segment, this.buffer);
        return this.buffer.length() != 0;
    }

    private final boolean $$robo$$android_icu_text_Normalizer$previousNormalize() {
        int c;
        this.clearBuffer();
        this.nextIndex = this.currentIndex;
        this.text.setIndex(this.currentIndex);
        StringBuilder segment = new StringBuilder();
        while ((c = this.text.previousCodePoint()) >= 0) {
            if (c <= 65535) {
                segment.insert(0, (char)c);
            } else {
                segment.insert(0, Character.toChars(c));
            }
            if (!this.norm2.hasBoundaryBefore(c)) continue;
        }
        this.currentIndex = this.text.getIndex();
        this.norm2.normalize((CharSequence)segment, this.buffer);
        this.bufferPos = this.buffer.length();
        return this.buffer.length() != 0;
    }

    private static final int $$robo$$android_icu_text_Normalizer$internalCompare(CharSequence s1, CharSequence s2, int options) {
        int normOptions = options >>> 20;
        if (((options |= 0x80000) & 0x20000) == 0 || (options & 1) != 0) {
            Normalizer2 n2 = (options & 1) != 0 ? NFD.getNormalizer2(normOptions) : FCD.getNormalizer2(normOptions);
            int spanQCYes1 = n2.spanQuickCheckYes(s1);
            int spanQCYes2 = n2.spanQuickCheckYes(s2);
            if (spanQCYes1 < s1.length()) {
                StringBuilder fcd1 = new StringBuilder(s1.length() + 16).append(s1, 0, spanQCYes1);
                s1 = n2.normalizeSecondAndAppend(fcd1, s1.subSequence(spanQCYes1, s1.length()));
            }
            if (spanQCYes2 < s2.length()) {
                StringBuilder fcd2 = new StringBuilder(s2.length() + 16).append(s2, 0, spanQCYes2);
                s2 = n2.normalizeSecondAndAppend(fcd2, s2.subSequence(spanQCYes2, s2.length()));
            }
        }
        return Normalizer.cmpEquivFold(s1, s2, options);
    }

    private static final CmpEquivLevel[] $$robo$$android_icu_text_Normalizer$createCmpEquivLevelStack() {
        return new CmpEquivLevel[]{new CmpEquivLevel(null), new CmpEquivLevel(null)};
    }

    private static final int $$robo$$android_icu_text_Normalizer$cmpEquivFold(CharSequence cs1, CharSequence cs2, int options) {
        StringBuilder fold2;
        StringBuilder fold1;
        UCaseProps csp;
        CmpEquivLevel[] stack1 = null;
        CmpEquivLevel[] stack2 = null;
        Normalizer2Impl nfcImpl = (options & 0x80000) != 0 ? Norm2AllModes.getNFCInstance().impl : null;
        if ((options & 0x10000) != 0) {
            csp = UCaseProps.INSTANCE;
            fold1 = new StringBuilder();
            fold2 = new StringBuilder();
        } else {
            csp = null;
            fold2 = null;
            fold1 = null;
        }
        int s1 = 0;
        int limit1 = cs1.length();
        int s2 = 0;
        int limit2 = cs2.length();
        int level2 = 0;
        int level1 = 0;
        int c2 = -1;
        int c1 = -1;
        while (true) {
            String decomp2;
            String decomp1;
            int length;
            char c;
            if (c1 < 0) {
                while (true) {
                    if (s1 == limit1) {
                        if (level1 == 0) {
                            c1 = -1;
                            break;
                        }
                    } else {
                        c1 = cs1.charAt(s1++);
                        break;
                    }
                    while ((cs1 = stack1[--level1].cs) == null) {
                    }
                    s1 = stack1[level1].s;
                    limit1 = cs1.length();
                }
            }
            if (c2 < 0) {
                while (true) {
                    if (s2 == limit2) {
                        if (level2 == 0) {
                            c2 = -1;
                            break;
                        }
                    } else {
                        c2 = cs2.charAt(s2++);
                        break;
                    }
                    while ((cs2 = stack2[--level2].cs) == null) {
                    }
                    s2 = stack2[level2].s;
                    limit2 = cs2.length();
                }
            }
            if (c1 == c2) {
                if (c1 < 0) {
                    return 0;
                }
                c2 = -1;
                c1 = -1;
                continue;
            }
            if (c1 < 0) {
                return -1;
            }
            if (c2 < 0) {
                return 1;
            }
            int cp1 = c1;
            if (UTF16.isSurrogate((char)c1)) {
                if (Normalizer2Impl.UTF16Plus.isSurrogateLead(c1)) {
                    if (s1 != limit1 && Character.isLowSurrogate(c = cs1.charAt(s1))) {
                        cp1 = Character.toCodePoint((char)c1, c);
                    }
                } else if (0 <= s1 - 2 && Character.isHighSurrogate(c = cs1.charAt(s1 - 2))) {
                    cp1 = Character.toCodePoint(c, (char)c1);
                }
            }
            int cp2 = c2;
            if (UTF16.isSurrogate((char)c2)) {
                if (Normalizer2Impl.UTF16Plus.isSurrogateLead(c2)) {
                    if (s2 != limit2 && Character.isLowSurrogate(c = cs2.charAt(s2))) {
                        cp2 = Character.toCodePoint((char)c2, c);
                    }
                } else if (0 <= s2 - 2 && Character.isHighSurrogate(c = cs2.charAt(s2 - 2))) {
                    cp2 = Character.toCodePoint(c, (char)c2);
                }
            }
            if (level1 == 0 && (options & 0x10000) != 0 && (length = csp.toFullFolding(cp1, fold1, options)) >= 0) {
                if (UTF16.isSurrogate((char)c1)) {
                    if (Normalizer2Impl.UTF16Plus.isSurrogateLead(c1)) {
                        ++s1;
                    } else {
                        c2 = cs2.charAt(--s2 - 1);
                    }
                }
                if (stack1 == null) {
                    stack1 = Normalizer.createCmpEquivLevelStack();
                }
                stack1[0].cs = cs1;
                stack1[0].s = s1;
                ++level1;
                if (length <= 31) {
                    fold1.delete(0, fold1.length() - length);
                } else {
                    fold1.setLength(0);
                    fold1.appendCodePoint(length);
                }
                cs1 = fold1;
                s1 = 0;
                limit1 = fold1.length();
                c1 = -1;
                continue;
            }
            if (level2 == 0 && (options & 0x10000) != 0 && (length = csp.toFullFolding(cp2, fold2, options)) >= 0) {
                if (UTF16.isSurrogate((char)c2)) {
                    if (Normalizer2Impl.UTF16Plus.isSurrogateLead(c2)) {
                        ++s2;
                    } else {
                        c1 = cs1.charAt(--s1 - 1);
                    }
                }
                if (stack2 == null) {
                    stack2 = Normalizer.createCmpEquivLevelStack();
                }
                stack2[0].cs = cs2;
                stack2[0].s = s2;
                ++level2;
                if (length <= 31) {
                    fold2.delete(0, fold2.length() - length);
                } else {
                    fold2.setLength(0);
                    fold2.appendCodePoint(length);
                }
                cs2 = fold2;
                s2 = 0;
                limit2 = fold2.length();
                c2 = -1;
                continue;
            }
            if (level1 < 2 && (options & 0x80000) != 0 && (decomp1 = nfcImpl.getDecomposition(cp1)) != null) {
                if (UTF16.isSurrogate((char)c1)) {
                    if (Normalizer2Impl.UTF16Plus.isSurrogateLead(c1)) {
                        ++s1;
                    } else {
                        c2 = cs2.charAt(--s2 - 1);
                    }
                }
                if (stack1 == null) {
                    stack1 = Normalizer.createCmpEquivLevelStack();
                }
                stack1[level1].cs = cs1;
                stack1[level1].s = s1;
                if (++level1 < 2) {
                    stack1[level1++].cs = null;
                }
                cs1 = decomp1;
                s1 = 0;
                limit1 = decomp1.length();
                c1 = -1;
                continue;
            }
            if (level2 >= 2 || (options & 0x80000) == 0 || (decomp2 = nfcImpl.getDecomposition(cp2)) == null) break;
            if (UTF16.isSurrogate((char)c2)) {
                if (Normalizer2Impl.UTF16Plus.isSurrogateLead(c2)) {
                    ++s2;
                } else {
                    c1 = cs1.charAt(--s1 - 1);
                }
            }
            if (stack2 == null) {
                stack2 = Normalizer.createCmpEquivLevelStack();
            }
            stack2[level2].cs = cs2;
            stack2[level2].s = s2;
            if (++level2 < 2) {
                stack2[level2++].cs = null;
            }
            cs2 = decomp2;
            s2 = 0;
            limit2 = decomp2.length();
            c2 = -1;
        }
        if (c1 >= 55296 && c2 >= 55296 && (options & 0x8000) != 0) {
            if (!(c1 <= 56319 && s1 != limit1 && Character.isLowSurrogate(cs1.charAt(s1)) || Character.isLowSurrogate((char)c1) && 0 != s1 - 1 && Character.isHighSurrogate(cs1.charAt(s1 - 2)))) {
                c1 -= 10240;
            }
            if (!(c2 <= 56319 && s2 != limit2 && Character.isLowSurrogate(cs2.charAt(s2)) || Character.isLowSurrogate((char)c2) && 0 != s2 - 1 && Character.isHighSurrogate(cs2.charAt(s2 - 2)))) {
                c2 -= 10240;
            }
        }
        return c1 - c2;
    }

    static void __staticInitializer__() {
        NONE = new NONEMode(null);
        NFD = new NFDMode(null);
        NFKD = new NFKDMode(null);
        DEFAULT = NFC = new NFCMode(null);
        NFKC = new NFKCMode(null);
        FCD = new FCDMode(null);
        NO_OP = NONE;
        COMPOSE = NFC;
        COMPOSE_COMPAT = NFKC;
        DECOMP = NFD;
        DECOMP_COMPAT = NFKD;
        NO = new QuickCheckResult(0, null);
        YES = new QuickCheckResult(1, null);
        MAYBE = new QuickCheckResult(2, null);
    }

    private void __constructor__(String string2, Mode mode, int n) {
        this.$$robo$$android_icu_text_Normalizer$__constructor__(string2, mode, n);
    }

    public Normalizer(String string2, Mode mode, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer$__constructor__(java.lang.String android.icu.text.Normalizer$Mode int ), this, string2, mode, n);
    }

    private void __constructor__(CharacterIterator characterIterator, Mode mode, int n) {
        this.$$robo$$android_icu_text_Normalizer$__constructor__(characterIterator, mode, n);
    }

    public Normalizer(CharacterIterator characterIterator, Mode mode, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer$__constructor__(java.text.CharacterIterator android.icu.text.Normalizer$Mode int ), this, characterIterator, mode, n);
    }

    private void __constructor__(UCharacterIterator uCharacterIterator, Mode mode, int n) {
        this.$$robo$$android_icu_text_Normalizer$__constructor__(uCharacterIterator, mode, n);
    }

    public Normalizer(UCharacterIterator uCharacterIterator, Mode mode, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer$__constructor__(android.icu.text.UCharacterIterator android.icu.text.Normalizer$Mode int ), this, uCharacterIterator, mode, n);
    }

    @Deprecated
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_Normalizer$clone(), this);
    }

    private static Normalizer2 getComposeNormalizer2(boolean bl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getComposeNormalizer2", $$robo$$android_icu_text_Normalizer$getComposeNormalizer2(boolean int ), (boolean)bl, (int)n);
    }

    private static Normalizer2 getDecomposeNormalizer2(boolean bl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDecomposeNormalizer2", $$robo$$android_icu_text_Normalizer$getDecomposeNormalizer2(boolean int ), (boolean)bl, (int)n);
    }

    @Deprecated
    public static String compose(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("compose", $$robo$$android_icu_text_Normalizer$compose(java.lang.String boolean ), (String)string2, (boolean)bl);
    }

    @Deprecated
    public static String compose(String string2, boolean bl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("compose", $$robo$$android_icu_text_Normalizer$compose(java.lang.String boolean int ), (String)string2, (boolean)bl, (int)n);
    }

    @Deprecated
    public static int compose(char[] cArray, char[] cArray2, boolean bl, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compose", $$robo$$android_icu_text_Normalizer$compose(char[] char[] boolean int ), (char[])cArray, (char[])cArray2, (boolean)bl, (int)n);
    }

    @Deprecated
    public static int compose(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, boolean bl, int n5) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compose", $$robo$$android_icu_text_Normalizer$compose(char[] int int char[] int int boolean int ), (char[])cArray, (int)n, (int)n2, (char[])cArray2, (int)n3, (int)n4, (boolean)bl, (int)n5);
    }

    @Deprecated
    public static String decompose(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("decompose", $$robo$$android_icu_text_Normalizer$decompose(java.lang.String boolean ), (String)string2, (boolean)bl);
    }

    @Deprecated
    public static String decompose(String string2, boolean bl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("decompose", $$robo$$android_icu_text_Normalizer$decompose(java.lang.String boolean int ), (String)string2, (boolean)bl, (int)n);
    }

    @Deprecated
    public static int decompose(char[] cArray, char[] cArray2, boolean bl, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("decompose", $$robo$$android_icu_text_Normalizer$decompose(char[] char[] boolean int ), (char[])cArray, (char[])cArray2, (boolean)bl, (int)n);
    }

    @Deprecated
    public static int decompose(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, boolean bl, int n5) {
        return (int)InvokeDynamicSupport.bootstrapStatic("decompose", $$robo$$android_icu_text_Normalizer$decompose(char[] int int char[] int int boolean int ), (char[])cArray, (int)n, (int)n2, (char[])cArray2, (int)n3, (int)n4, (boolean)bl, (int)n5);
    }

    @Deprecated
    public static String normalize(String string2, Mode mode, int n) {
        return InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_icu_text_Normalizer$normalize(java.lang.String android.icu.text.Normalizer$Mode int ), (String)string2, (Mode)mode, (int)n);
    }

    @Deprecated
    public static String normalize(String string2, Mode mode) {
        return InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_icu_text_Normalizer$normalize(java.lang.String android.icu.text.Normalizer$Mode ), (String)string2, (Mode)mode);
    }

    @Deprecated
    public static int normalize(char[] cArray, char[] cArray2, Mode mode, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_icu_text_Normalizer$normalize(char[] char[] android.icu.text.Normalizer$Mode int ), (char[])cArray, (char[])cArray2, (Mode)mode, (int)n);
    }

    @Deprecated
    public static int normalize(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, Mode mode, int n5) {
        return (int)InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_icu_text_Normalizer$normalize(char[] int int char[] int int android.icu.text.Normalizer$Mode int ), (char[])cArray, (int)n, (int)n2, (char[])cArray2, (int)n3, (int)n4, (Mode)mode, (int)n5);
    }

    @Deprecated
    public static String normalize(int n, Mode mode, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_icu_text_Normalizer$normalize(int android.icu.text.Normalizer$Mode int ), (int)n, (Mode)mode, (int)n2);
    }

    @Deprecated
    public static String normalize(int n, Mode mode) {
        return InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_icu_text_Normalizer$normalize(int android.icu.text.Normalizer$Mode ), (int)n, (Mode)mode);
    }

    @Deprecated
    public static QuickCheckResult quickCheck(String string2, Mode mode) {
        return InvokeDynamicSupport.bootstrapStatic("quickCheck", $$robo$$android_icu_text_Normalizer$quickCheck(java.lang.String android.icu.text.Normalizer$Mode ), (String)string2, (Mode)mode);
    }

    @Deprecated
    public static QuickCheckResult quickCheck(String string2, Mode mode, int n) {
        return InvokeDynamicSupport.bootstrapStatic("quickCheck", $$robo$$android_icu_text_Normalizer$quickCheck(java.lang.String android.icu.text.Normalizer$Mode int ), (String)string2, (Mode)mode, (int)n);
    }

    @Deprecated
    public static QuickCheckResult quickCheck(char[] cArray, Mode mode, int n) {
        return InvokeDynamicSupport.bootstrapStatic("quickCheck", $$robo$$android_icu_text_Normalizer$quickCheck(char[] android.icu.text.Normalizer$Mode int ), (char[])cArray, (Mode)mode, (int)n);
    }

    @Deprecated
    public static QuickCheckResult quickCheck(char[] cArray, int n, int n2, Mode mode, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("quickCheck", $$robo$$android_icu_text_Normalizer$quickCheck(char[] int int android.icu.text.Normalizer$Mode int ), (char[])cArray, (int)n, (int)n2, (Mode)mode, (int)n3);
    }

    @Deprecated
    public static boolean isNormalized(char[] cArray, int n, int n2, Mode mode, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNormalized", $$robo$$android_icu_text_Normalizer$isNormalized(char[] int int android.icu.text.Normalizer$Mode int ), (char[])cArray, (int)n, (int)n2, (Mode)mode, (int)n3);
    }

    @Deprecated
    public static boolean isNormalized(String string2, Mode mode, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNormalized", $$robo$$android_icu_text_Normalizer$isNormalized(java.lang.String android.icu.text.Normalizer$Mode int ), (String)string2, (Mode)mode, (int)n);
    }

    @Deprecated
    public static boolean isNormalized(int n, Mode mode, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNormalized", $$robo$$android_icu_text_Normalizer$isNormalized(int android.icu.text.Normalizer$Mode int ), (int)n, (Mode)mode, (int)n2);
    }

    public static int compare(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_Normalizer$compare(char[] int int char[] int int int ), (char[])cArray, (int)n, (int)n2, (char[])cArray2, (int)n3, (int)n4, (int)n5);
    }

    public static int compare(String string2, String string3, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_Normalizer$compare(java.lang.String java.lang.String int ), (String)string2, (String)string3, (int)n);
    }

    public static int compare(char[] cArray, char[] cArray2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_Normalizer$compare(char[] char[] int ), (char[])cArray, (char[])cArray2, (int)n);
    }

    public static int compare(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_Normalizer$compare(int int int ), (int)n, (int)n2, (int)n3);
    }

    public static int compare(int n, String string2, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_Normalizer$compare(int java.lang.String int ), (int)n, (String)string2, (int)n2);
    }

    @Deprecated
    public static int concatenate(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, char[] cArray3, int n5, int n6, Mode mode, int n7) {
        return (int)InvokeDynamicSupport.bootstrapStatic("concatenate", $$robo$$android_icu_text_Normalizer$concatenate(char[] int int char[] int int char[] int int android.icu.text.Normalizer$Mode int ), (char[])cArray, (int)n, (int)n2, (char[])cArray2, (int)n3, (int)n4, (char[])cArray3, (int)n5, (int)n6, (Mode)mode, (int)n7);
    }

    @Deprecated
    public static String concatenate(char[] cArray, char[] cArray2, Mode mode, int n) {
        return InvokeDynamicSupport.bootstrapStatic("concatenate", $$robo$$android_icu_text_Normalizer$concatenate(char[] char[] android.icu.text.Normalizer$Mode int ), (char[])cArray, (char[])cArray2, (Mode)mode, (int)n);
    }

    @Deprecated
    public static String concatenate(String string2, String string3, Mode mode, int n) {
        return InvokeDynamicSupport.bootstrapStatic("concatenate", $$robo$$android_icu_text_Normalizer$concatenate(java.lang.String java.lang.String android.icu.text.Normalizer$Mode int ), (String)string2, (String)string3, (Mode)mode, (int)n);
    }

    @Deprecated
    public static int getFC_NFKC_Closure(int n, char[] cArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getFC_NFKC_Closure", $$robo$$android_icu_text_Normalizer$getFC_NFKC_Closure(int char[] ), (int)n, (char[])cArray);
    }

    @Deprecated
    public static String getFC_NFKC_Closure(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getFC_NFKC_Closure", $$robo$$android_icu_text_Normalizer$getFC_NFKC_Closure(int ), (int)n);
    }

    @Deprecated
    public int current() {
        return (int)InvokeDynamicSupport.bootstrap("current", $$robo$$android_icu_text_Normalizer$current(), this);
    }

    @Deprecated
    public int next() {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_Normalizer$next(), this);
    }

    @Deprecated
    public int previous() {
        return (int)InvokeDynamicSupport.bootstrap("previous", $$robo$$android_icu_text_Normalizer$previous(), this);
    }

    @Deprecated
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_Normalizer$reset(), this);
    }

    @Deprecated
    public void setIndexOnly(int n) {
        InvokeDynamicSupport.bootstrap("setIndexOnly", $$robo$$android_icu_text_Normalizer$setIndexOnly(int ), this, n);
    }

    @Deprecated
    public int setIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setIndex", $$robo$$android_icu_text_Normalizer$setIndex(int ), this, n);
    }

    @Deprecated
    public int getBeginIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getBeginIndex", $$robo$$android_icu_text_Normalizer$getBeginIndex(), this);
    }

    @Deprecated
    public int getEndIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getEndIndex", $$robo$$android_icu_text_Normalizer$getEndIndex(), this);
    }

    @Deprecated
    public int first() {
        return (int)InvokeDynamicSupport.bootstrap("first", $$robo$$android_icu_text_Normalizer$first(), this);
    }

    @Deprecated
    public int last() {
        return (int)InvokeDynamicSupport.bootstrap("last", $$robo$$android_icu_text_Normalizer$last(), this);
    }

    @Deprecated
    public int getIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$android_icu_text_Normalizer$getIndex(), this);
    }

    @Deprecated
    public int startIndex() {
        return (int)InvokeDynamicSupport.bootstrap("startIndex", $$robo$$android_icu_text_Normalizer$startIndex(), this);
    }

    @Deprecated
    public int endIndex() {
        return (int)InvokeDynamicSupport.bootstrap("endIndex", $$robo$$android_icu_text_Normalizer$endIndex(), this);
    }

    @Deprecated
    public void setMode(Mode mode) {
        InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_icu_text_Normalizer$setMode(android.icu.text.Normalizer$Mode ), this, mode);
    }

    @Deprecated
    public Mode getMode() {
        return InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_icu_text_Normalizer$getMode(), this);
    }

    @Deprecated
    public void setOption(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setOption", $$robo$$android_icu_text_Normalizer$setOption(int boolean ), this, n, bl);
    }

    @Deprecated
    public int getOption(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOption", $$robo$$android_icu_text_Normalizer$getOption(int ), this, n);
    }

    @Deprecated
    public int getText(char[] cArray) {
        return (int)InvokeDynamicSupport.bootstrap("getText", $$robo$$android_icu_text_Normalizer$getText(char[] ), this, cArray);
    }

    @Deprecated
    public int getLength() {
        return (int)InvokeDynamicSupport.bootstrap("getLength", $$robo$$android_icu_text_Normalizer$getLength(), this);
    }

    @Deprecated
    public String getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_icu_text_Normalizer$getText(), this);
    }

    @Deprecated
    public void setText(StringBuffer stringBuffer) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_Normalizer$setText(java.lang.StringBuffer ), this, stringBuffer);
    }

    @Deprecated
    public void setText(char[] cArray) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_Normalizer$setText(char[] ), this, cArray);
    }

    @Deprecated
    public void setText(String string2) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_Normalizer$setText(java.lang.String ), this, string2);
    }

    @Deprecated
    public void setText(CharacterIterator characterIterator) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_Normalizer$setText(java.text.CharacterIterator ), this, characterIterator);
    }

    @Deprecated
    public void setText(UCharacterIterator uCharacterIterator) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_Normalizer$setText(android.icu.text.UCharacterIterator ), this, uCharacterIterator);
    }

    private void clearBuffer() {
        InvokeDynamicSupport.bootstrap("clearBuffer", $$robo$$android_icu_text_Normalizer$clearBuffer(), this);
    }

    private boolean nextNormalize() {
        return (boolean)InvokeDynamicSupport.bootstrap("nextNormalize", $$robo$$android_icu_text_Normalizer$nextNormalize(), this);
    }

    private boolean previousNormalize() {
        return (boolean)InvokeDynamicSupport.bootstrap("previousNormalize", $$robo$$android_icu_text_Normalizer$previousNormalize(), this);
    }

    private static int internalCompare(CharSequence charSequence, CharSequence charSequence2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("internalCompare", $$robo$$android_icu_text_Normalizer$internalCompare(java.lang.CharSequence java.lang.CharSequence int ), (CharSequence)charSequence, (CharSequence)charSequence2, (int)n);
    }

    private static CmpEquivLevel[] createCmpEquivLevelStack() {
        return InvokeDynamicSupport.bootstrapStatic("createCmpEquivLevelStack", $$robo$$android_icu_text_Normalizer$createCmpEquivLevelStack());
    }

    static int cmpEquivFold(CharSequence charSequence, CharSequence charSequence2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("cmpEquivFold", $$robo$$android_icu_text_Normalizer$cmpEquivFold(java.lang.CharSequence java.lang.CharSequence int ), (CharSequence)charSequence, (CharSequence)charSequence2, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(Normalizer.class);
    }

    public /* synthetic */ Normalizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Normalizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CharsAppendable
    implements Appendable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private char[] chars;
        private int start;
        private int limit;
        private int offset;

        private void $$robo$$android_icu_text_Normalizer_CharsAppendable$__constructor__(char[] dest, int destStart, int destLimit) {
            this.chars = dest;
            this.start = this.offset = destStart;
            this.limit = destLimit;
        }

        private final int $$robo$$android_icu_text_Normalizer_CharsAppendable$length() {
            int len = this.offset - this.start;
            if (this.offset <= this.limit) {
                return len;
            }
            throw new IndexOutOfBoundsException(Integer.toString(len));
        }

        private final Appendable $$robo$$android_icu_text_Normalizer_CharsAppendable$append(char c) {
            if (this.offset < this.limit) {
                this.chars[this.offset] = c;
            }
            ++this.offset;
            return this;
        }

        private final Appendable $$robo$$android_icu_text_Normalizer_CharsAppendable$append(CharSequence s) {
            return this.append(s, 0, s.length());
        }

        private final Appendable $$robo$$android_icu_text_Normalizer_CharsAppendable$append(CharSequence s, int sStart, int sLimit) {
            int len = sLimit - sStart;
            if (len <= this.limit - this.offset) {
                while (sStart < sLimit) {
                    this.chars[this.offset++] = s.charAt(sStart++);
                }
            } else {
                this.offset += len;
            }
            return this;
        }

        private void __constructor__(char[] cArray, int n, int n2) {
            this.$$robo$$android_icu_text_Normalizer_CharsAppendable$__constructor__(cArray, n, n2);
        }

        public CharsAppendable(char[] cArray, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_CharsAppendable$__constructor__(char[] int int ), this, cArray, n, n2);
        }

        public int length() {
            return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_icu_text_Normalizer_CharsAppendable$length(), this);
        }

        @Override
        public Appendable append(char c) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_Normalizer_CharsAppendable$append(char ), this, c);
        }

        @Override
        public Appendable append(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_Normalizer_CharsAppendable$append(java.lang.CharSequence ), this, charSequence);
        }

        @Override
        public Appendable append(CharSequence charSequence, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_Normalizer_CharsAppendable$append(java.lang.CharSequence int int ), this, charSequence, n, n2);
        }

        public /* synthetic */ CharsAppendable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharsAppendable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CmpEquivLevel
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        CharSequence cs;
        int s;

        private void $$robo$$android_icu_text_Normalizer_CmpEquivLevel$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_CmpEquivLevel$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_CmpEquivLevel$__constructor__();
        }

        public CmpEquivLevel() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_CmpEquivLevel$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_Normalizer_CmpEquivLevel$__constructor__(var1_1);
        }

        public /* synthetic */ CmpEquivLevel(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_CmpEquivLevel$__constructor__(android.icu.text.Normalizer$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CmpEquivLevel)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class QuickCheckResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Normalizer_QuickCheckResult$__constructor__(int value) {
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_QuickCheckResult$__constructor__(int x0, 1 x1) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_text_Normalizer_QuickCheckResult$__constructor__(n);
        }

        public QuickCheckResult(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_QuickCheckResult$__constructor__(int ), this, n);
        }

        private /* synthetic */ void __constructor__(int n, 1 var2_2) {
            this.$$robo$$android_icu_text_Normalizer_QuickCheckResult$__constructor__(n, var2_2);
        }

        public /* synthetic */ QuickCheckResult(int n, 1 var2_2) {
            this(n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_QuickCheckResult$__constructor__(int android.icu.text.Normalizer$1 ), this, n, var2_2);
        }

        public /* synthetic */ QuickCheckResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (QuickCheckResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FCDMode
    extends Mode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Normalizer_FCDMode$__constructor__() {
        }

        private final Normalizer2 $$robo$$android_icu_text_Normalizer_FCDMode$getNormalizer2(int options) {
            return (options & 0x20) != 0 ? FCD32ModeImpl.INSTANCE.normalizer2 : FCDModeImpl.INSTANCE.normalizer2;
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_FCDMode$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_FCDMode$__constructor__();
        }

        public FCDMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_FCDMode$__constructor__(), this);
        }

        @Override
        protected Normalizer2 getNormalizer2(int n) {
            return InvokeDynamicSupport.bootstrap("getNormalizer2", $$robo$$android_icu_text_Normalizer_FCDMode$getNormalizer2(int ), this, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_Normalizer_FCDMode$__constructor__(var1_1);
        }

        public /* synthetic */ FCDMode(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_FCDMode$__constructor__(android.icu.text.Normalizer$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FCDMode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFKCMode
    extends Mode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Normalizer_NFKCMode$__constructor__() {
        }

        private final Normalizer2 $$robo$$android_icu_text_Normalizer_NFKCMode$getNormalizer2(int options) {
            return (options & 0x20) != 0 ? NFKC32ModeImpl.INSTANCE.normalizer2 : NFKCModeImpl.INSTANCE.normalizer2;
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_NFKCMode$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFKCMode$__constructor__();
        }

        public NFKCMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFKCMode$__constructor__(), this);
        }

        @Override
        protected Normalizer2 getNormalizer2(int n) {
            return InvokeDynamicSupport.bootstrap("getNormalizer2", $$robo$$android_icu_text_Normalizer_NFKCMode$getNormalizer2(int ), this, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_Normalizer_NFKCMode$__constructor__(var1_1);
        }

        public /* synthetic */ NFKCMode(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFKCMode$__constructor__(android.icu.text.Normalizer$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFKCMode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFCMode
    extends Mode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Normalizer_NFCMode$__constructor__() {
        }

        private final Normalizer2 $$robo$$android_icu_text_Normalizer_NFCMode$getNormalizer2(int options) {
            return (options & 0x20) != 0 ? NFC32ModeImpl.INSTANCE.normalizer2 : NFCModeImpl.INSTANCE.normalizer2;
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_NFCMode$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFCMode$__constructor__();
        }

        public NFCMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFCMode$__constructor__(), this);
        }

        @Override
        protected Normalizer2 getNormalizer2(int n) {
            return InvokeDynamicSupport.bootstrap("getNormalizer2", $$robo$$android_icu_text_Normalizer_NFCMode$getNormalizer2(int ), this, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_Normalizer_NFCMode$__constructor__(var1_1);
        }

        public /* synthetic */ NFCMode(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFCMode$__constructor__(android.icu.text.Normalizer$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFCMode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFKDMode
    extends Mode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Normalizer_NFKDMode$__constructor__() {
        }

        private final Normalizer2 $$robo$$android_icu_text_Normalizer_NFKDMode$getNormalizer2(int options) {
            return (options & 0x20) != 0 ? NFKD32ModeImpl.INSTANCE.normalizer2 : NFKDModeImpl.INSTANCE.normalizer2;
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_NFKDMode$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFKDMode$__constructor__();
        }

        public NFKDMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFKDMode$__constructor__(), this);
        }

        @Override
        protected Normalizer2 getNormalizer2(int n) {
            return InvokeDynamicSupport.bootstrap("getNormalizer2", $$robo$$android_icu_text_Normalizer_NFKDMode$getNormalizer2(int ), this, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_Normalizer_NFKDMode$__constructor__(var1_1);
        }

        public /* synthetic */ NFKDMode(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFKDMode$__constructor__(android.icu.text.Normalizer$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFKDMode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFDMode
    extends Mode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Normalizer_NFDMode$__constructor__() {
        }

        private final Normalizer2 $$robo$$android_icu_text_Normalizer_NFDMode$getNormalizer2(int options) {
            return (options & 0x20) != 0 ? NFD32ModeImpl.INSTANCE.normalizer2 : NFDModeImpl.INSTANCE.normalizer2;
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_NFDMode$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFDMode$__constructor__();
        }

        public NFDMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFDMode$__constructor__(), this);
        }

        @Override
        protected Normalizer2 getNormalizer2(int n) {
            return InvokeDynamicSupport.bootstrap("getNormalizer2", $$robo$$android_icu_text_Normalizer_NFDMode$getNormalizer2(int ), this, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_Normalizer_NFDMode$__constructor__(var1_1);
        }

        public /* synthetic */ NFDMode(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFDMode$__constructor__(android.icu.text.Normalizer$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFDMode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NONEMode
    extends Mode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_Normalizer_NONEMode$__constructor__() {
        }

        private final Normalizer2 $$robo$$android_icu_text_Normalizer_NONEMode$getNormalizer2(int options) {
            return Norm2AllModes.NOOP_NORMALIZER2;
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_NONEMode$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NONEMode$__constructor__();
        }

        public NONEMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NONEMode$__constructor__(), this);
        }

        @Override
        protected Normalizer2 getNormalizer2(int n) {
            return InvokeDynamicSupport.bootstrap("getNormalizer2", $$robo$$android_icu_text_Normalizer_NONEMode$getNormalizer2(int ), this, n);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_Normalizer_NONEMode$__constructor__(var1_1);
        }

        public /* synthetic */ NONEMode(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NONEMode$__constructor__(android.icu.text.Normalizer$1 ), this, var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NONEMode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static abstract class Mode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        @Deprecated
        private void $$robo$$android_icu_text_Normalizer_Mode$__constructor__() {
        }

        @Deprecated
        protected abstract Normalizer2 getNormalizer2(int var1);

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_Mode$__constructor__();
        }

        public Mode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_Mode$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Mode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FCD32ModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_FCD32ModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getFCDNormalizer2(), Unicode32.INSTANCE), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_FCD32ModeImpl$__constructor__();
        }

        public FCD32ModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_FCD32ModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(FCD32ModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FCD32ModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFKC32ModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_NFKC32ModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(new FilteredNormalizer2(Normalizer2.getNFKCInstance(), Unicode32.INSTANCE), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFKC32ModeImpl$__constructor__();
        }

        public NFKC32ModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFKC32ModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NFKC32ModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFKC32ModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFC32ModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_NFC32ModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(new FilteredNormalizer2(Normalizer2.getNFCInstance(), Unicode32.INSTANCE), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFC32ModeImpl$__constructor__();
        }

        public NFC32ModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFC32ModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NFC32ModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFC32ModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFKD32ModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_NFKD32ModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(new FilteredNormalizer2(Normalizer2.getNFKDInstance(), Unicode32.INSTANCE), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFKD32ModeImpl$__constructor__();
        }

        public NFKD32ModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFKD32ModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NFKD32ModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFKD32ModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFD32ModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_NFD32ModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(new FilteredNormalizer2(Normalizer2.getNFDInstance(), Unicode32.INSTANCE), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFD32ModeImpl$__constructor__();
        }

        public NFD32ModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFD32ModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NFD32ModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFD32ModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class Unicode32
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static UnicodeSet INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_Unicode32$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new UnicodeSet("[:age=3.2:]").freeze();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_Unicode32$__constructor__();
        }

        public Unicode32() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_Unicode32$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(Unicode32.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Unicode32)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FCDModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_FCDModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(Norm2AllModes.getFCDNormalizer2(), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_FCDModeImpl$__constructor__();
        }

        public FCDModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_FCDModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(FCDModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FCDModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFKCModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_NFKCModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(Normalizer2.getNFKCInstance(), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFKCModeImpl$__constructor__();
        }

        public NFKCModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFKCModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NFKCModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFKCModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFCModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_NFCModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(Normalizer2.getNFCInstance(), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFCModeImpl$__constructor__();
        }

        public NFCModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFCModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NFCModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFCModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFKDModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_NFKDModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(Normalizer2.getNFKDInstance(), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFKDModeImpl$__constructor__();
        }

        public NFKDModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFKDModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NFKDModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFKDModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class NFDModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static ModeImpl INSTANCE;

        private void $$robo$$android_icu_text_Normalizer_NFDModeImpl$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new ModeImpl(Normalizer2.getNFDInstance(), null);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Normalizer_NFDModeImpl$__constructor__();
        }

        public NFDModeImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_NFDModeImpl$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(NFDModeImpl.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NFDModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ModeImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Normalizer2 normalizer2;

        private void $$robo$$android_icu_text_Normalizer_ModeImpl$__constructor__(Normalizer2 n2) {
            this.normalizer2 = n2;
        }

        private /* synthetic */ void $$robo$$android_icu_text_Normalizer_ModeImpl$__constructor__(Normalizer2 x0, 1 x1) {
        }

        private void __constructor__(Normalizer2 normalizer2) {
            this.$$robo$$android_icu_text_Normalizer_ModeImpl$__constructor__(normalizer2);
        }

        public ModeImpl(Normalizer2 normalizer2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_ModeImpl$__constructor__(android.icu.text.Normalizer2 ), this, normalizer2);
        }

        private /* synthetic */ void __constructor__(Normalizer2 normalizer2, 1 var2_2) {
            this.$$robo$$android_icu_text_Normalizer_ModeImpl$__constructor__(normalizer2, var2_2);
        }

        public /* synthetic */ ModeImpl(Normalizer2 normalizer2, 1 var2_2) {
            this(normalizer2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Normalizer_ModeImpl$__constructor__(android.icu.text.Normalizer2 android.icu.text.Normalizer$1 ), this, normalizer2, var2_2);
        }

        public /* synthetic */ ModeImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ModeImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

