/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.Utility;
import android.icu.text.Normalizer;
import android.icu.text.Replaceable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Comparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UTF16
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int SINGLE_CHAR_BOUNDARY = 1;
    public static int LEAD_SURROGATE_BOUNDARY = 2;
    public static int TRAIL_SURROGATE_BOUNDARY = 5;
    public static int CODEPOINT_MIN_VALUE = 0;
    public static int CODEPOINT_MAX_VALUE = 0x10FFFF;
    public static int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static int LEAD_SURROGATE_MIN_VALUE = 55296;
    public static int TRAIL_SURROGATE_MIN_VALUE = 56320;
    public static int LEAD_SURROGATE_MAX_VALUE = 56319;
    public static int TRAIL_SURROGATE_MAX_VALUE = 57343;
    public static int SURROGATE_MIN_VALUE = 55296;
    public static int SURROGATE_MAX_VALUE = 57343;
    private static int LEAD_SURROGATE_BITMASK = -1024;
    private static int TRAIL_SURROGATE_BITMASK = -1024;
    private static int SURROGATE_BITMASK = -2048;
    private static int LEAD_SURROGATE_BITS = 55296;
    private static int TRAIL_SURROGATE_BITS = 56320;
    private static int SURROGATE_BITS = 55296;
    private static int LEAD_SURROGATE_SHIFT_ = 10;
    private static int TRAIL_SURROGATE_MASK_ = 1023;
    private static int LEAD_SURROGATE_OFFSET_ = 55232;

    private void $$robo$$android_icu_text_UTF16$__constructor__() {
    }

    private static final int $$robo$$android_icu_text_UTF16$charAt(String source, int offset16) {
        char single = source.charAt(offset16);
        if (single < '\ud800') {
            return single;
        }
        return UTF16._charAt(source, offset16, single);
    }

    private static final int $$robo$$android_icu_text_UTF16$_charAt(String source, int offset16, char single) {
        char lead;
        if (single > '\udfff') {
            return single;
        }
        if (single <= '\udbff') {
            char trail;
            if (source.length() != ++offset16 && (trail = source.charAt(offset16)) >= '\udc00' && trail <= '\udfff') {
                return Character.toCodePoint(single, trail);
            }
        } else if (--offset16 >= 0 && (lead = source.charAt(offset16)) >= '\ud800' && lead <= '\udbff') {
            return Character.toCodePoint(lead, single);
        }
        return single;
    }

    private static final int $$robo$$android_icu_text_UTF16$charAt(CharSequence source, int offset16) {
        char single = source.charAt(offset16);
        if (single < '\ud800') {
            return single;
        }
        return UTF16._charAt(source, offset16, single);
    }

    private static final int $$robo$$android_icu_text_UTF16$_charAt(CharSequence source, int offset16, char single) {
        char lead;
        if (single > '\udfff') {
            return single;
        }
        if (single <= '\udbff') {
            char trail;
            if (source.length() != ++offset16 && (trail = source.charAt(offset16)) >= '\udc00' && trail <= '\udfff') {
                return Character.toCodePoint(single, trail);
            }
        } else if (--offset16 >= 0 && (lead = source.charAt(offset16)) >= '\ud800' && lead <= '\udbff') {
            return Character.toCodePoint(lead, single);
        }
        return single;
    }

    private static final int $$robo$$android_icu_text_UTF16$charAt(StringBuffer source, int offset16) {
        char lead;
        if (offset16 < 0 || offset16 >= source.length()) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        char single = source.charAt(offset16);
        if (!UTF16.isSurrogate(single)) {
            return single;
        }
        if (single <= '\udbff') {
            char trail;
            if (source.length() != ++offset16 && UTF16.isTrailSurrogate(trail = source.charAt(offset16))) {
                return Character.toCodePoint(single, trail);
            }
        } else if (--offset16 >= 0 && UTF16.isLeadSurrogate(lead = source.charAt(offset16))) {
            return Character.toCodePoint(lead, single);
        }
        return single;
    }

    private static final int $$robo$$android_icu_text_UTF16$charAt(char[] source, int start, int limit, int offset16) {
        if ((offset16 += start) < start || offset16 >= limit) {
            throw new ArrayIndexOutOfBoundsException(offset16);
        }
        char single = source[offset16];
        if (!UTF16.isSurrogate(single)) {
            return single;
        }
        if (single <= '\udbff') {
            if (++offset16 >= limit) {
                return single;
            }
            char trail = source[offset16];
            if (UTF16.isTrailSurrogate(trail)) {
                return Character.toCodePoint(single, trail);
            }
        } else {
            char lead;
            if (offset16 == start) {
                return single;
            }
            if (UTF16.isLeadSurrogate(lead = source[--offset16])) {
                return Character.toCodePoint(lead, single);
            }
        }
        return single;
    }

    private static final int $$robo$$android_icu_text_UTF16$charAt(Replaceable source, int offset16) {
        char lead;
        if (offset16 < 0 || offset16 >= source.length()) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        char single = source.charAt(offset16);
        if (!UTF16.isSurrogate(single)) {
            return single;
        }
        if (single <= '\udbff') {
            char trail;
            if (source.length() != ++offset16 && UTF16.isTrailSurrogate(trail = source.charAt(offset16))) {
                return Character.toCodePoint(single, trail);
            }
        } else if (--offset16 >= 0 && UTF16.isLeadSurrogate(lead = source.charAt(offset16))) {
            return Character.toCodePoint(lead, single);
        }
        return single;
    }

    private static final int $$robo$$android_icu_text_UTF16$getCharCount(int char32) {
        if (char32 < 65536) {
            return 1;
        }
        return 2;
    }

    private static final int $$robo$$android_icu_text_UTF16$bounds(String source, int offset16) {
        char ch = source.charAt(offset16);
        if (UTF16.isSurrogate(ch)) {
            if (UTF16.isLeadSurrogate(ch)) {
                if (++offset16 < source.length() && UTF16.isTrailSurrogate(source.charAt(offset16))) {
                    return 2;
                }
            } else if (--offset16 >= 0 && UTF16.isLeadSurrogate(source.charAt(offset16))) {
                return 5;
            }
        }
        return 1;
    }

    private static final int $$robo$$android_icu_text_UTF16$bounds(StringBuffer source, int offset16) {
        char ch = source.charAt(offset16);
        if (UTF16.isSurrogate(ch)) {
            if (UTF16.isLeadSurrogate(ch)) {
                if (++offset16 < source.length() && UTF16.isTrailSurrogate(source.charAt(offset16))) {
                    return 2;
                }
            } else if (--offset16 >= 0 && UTF16.isLeadSurrogate(source.charAt(offset16))) {
                return 5;
            }
        }
        return 1;
    }

    private static final int $$robo$$android_icu_text_UTF16$bounds(char[] source, int start, int limit, int offset16) {
        if ((offset16 += start) < start || offset16 >= limit) {
            throw new ArrayIndexOutOfBoundsException(offset16);
        }
        char ch = source[offset16];
        if (UTF16.isSurrogate(ch)) {
            if (UTF16.isLeadSurrogate(ch)) {
                if (++offset16 < limit && UTF16.isTrailSurrogate(source[offset16])) {
                    return 2;
                }
            } else if (--offset16 >= start && UTF16.isLeadSurrogate(source[offset16])) {
                return 5;
            }
        }
        return 1;
    }

    private static final boolean $$robo$$android_icu_text_UTF16$isSurrogate(char char16) {
        return (char16 & 0xFFFFF800) == 55296;
    }

    private static final boolean $$robo$$android_icu_text_UTF16$isTrailSurrogate(char char16) {
        return (char16 & 0xFFFFFC00) == 56320;
    }

    private static final boolean $$robo$$android_icu_text_UTF16$isLeadSurrogate(char char16) {
        return (char16 & 0xFFFFFC00) == 55296;
    }

    private static final char $$robo$$android_icu_text_UTF16$getLeadSurrogate(int char32) {
        if (char32 >= 65536) {
            return (char)(55232 + (char32 >> 10));
        }
        return '\u0000';
    }

    private static final char $$robo$$android_icu_text_UTF16$getTrailSurrogate(int char32) {
        if (char32 >= 65536) {
            return (char)(56320 + (char32 & 0x3FF));
        }
        return (char)char32;
    }

    private static final String $$robo$$android_icu_text_UTF16$valueOf(int char32) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint");
        }
        return UTF16.toString(char32);
    }

    private static final String $$robo$$android_icu_text_UTF16$valueOf(String source, int offset16) {
        switch (UTF16.bounds(source, offset16)) {
            case 2: {
                return source.substring(offset16, offset16 + 2);
            }
            case 5: {
                return source.substring(offset16 - 1, offset16 + 1);
            }
        }
        return source.substring(offset16, offset16 + 1);
    }

    private static final String $$robo$$android_icu_text_UTF16$valueOf(StringBuffer source, int offset16) {
        switch (UTF16.bounds(source, offset16)) {
            case 2: {
                return source.substring(offset16, offset16 + 2);
            }
            case 5: {
                return source.substring(offset16 - 1, offset16 + 1);
            }
        }
        return source.substring(offset16, offset16 + 1);
    }

    private static final String $$robo$$android_icu_text_UTF16$valueOf(char[] source, int start, int limit, int offset16) {
        switch (UTF16.bounds(source, start, limit, offset16)) {
            case 2: {
                return new String(source, start + offset16, 2);
            }
            case 5: {
                return new String(source, start + offset16 - 1, 2);
            }
        }
        return new String(source, start + offset16, 1);
    }

    private static final int $$robo$$android_icu_text_UTF16$findOffsetFromCodePoint(String source, int offset32) {
        int count;
        int size = source.length();
        int result = 0;
        if (offset32 < 0 || offset32 > size) {
            throw new StringIndexOutOfBoundsException(offset32);
        }
        for (count = offset32; result < size && count > 0; --count, ++result) {
            char ch = source.charAt(result);
            if (!UTF16.isLeadSurrogate(ch) || result + 1 >= size || !UTF16.isTrailSurrogate(source.charAt(result + 1))) continue;
            ++result;
        }
        if (count != 0) {
            throw new StringIndexOutOfBoundsException(offset32);
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$findOffsetFromCodePoint(StringBuffer source, int offset32) {
        int count;
        int size = source.length();
        int result = 0;
        if (offset32 < 0 || offset32 > size) {
            throw new StringIndexOutOfBoundsException(offset32);
        }
        for (count = offset32; result < size && count > 0; --count, ++result) {
            char ch = source.charAt(result);
            if (!UTF16.isLeadSurrogate(ch) || result + 1 >= size || !UTF16.isTrailSurrogate(source.charAt(result + 1))) continue;
            ++result;
        }
        if (count != 0) {
            throw new StringIndexOutOfBoundsException(offset32);
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$findOffsetFromCodePoint(char[] source, int start, int limit, int offset32) {
        int count;
        int result = start;
        if (offset32 > limit - start) {
            throw new ArrayIndexOutOfBoundsException(offset32);
        }
        for (count = offset32; result < limit && count > 0; --count, ++result) {
            char ch = source[result];
            if (!UTF16.isLeadSurrogate(ch) || result + 1 >= limit || !UTF16.isTrailSurrogate(source[result + 1])) continue;
            ++result;
        }
        if (count != 0) {
            throw new ArrayIndexOutOfBoundsException(offset32);
        }
        return result - start;
    }

    private static final int $$robo$$android_icu_text_UTF16$findCodePointOffset(String source, int offset16) {
        if (offset16 < 0 || offset16 > source.length()) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        int result = 0;
        boolean hadLeadSurrogate = false;
        for (int i = 0; i < offset16; ++i) {
            char ch = source.charAt(i);
            if (hadLeadSurrogate && UTF16.isTrailSurrogate(ch)) {
                hadLeadSurrogate = false;
                continue;
            }
            hadLeadSurrogate = UTF16.isLeadSurrogate(ch);
            ++result;
        }
        if (offset16 == source.length()) {
            return result;
        }
        if (hadLeadSurrogate && UTF16.isTrailSurrogate(source.charAt(offset16))) {
            --result;
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$findCodePointOffset(StringBuffer source, int offset16) {
        if (offset16 < 0 || offset16 > source.length()) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        int result = 0;
        boolean hadLeadSurrogate = false;
        for (int i = 0; i < offset16; ++i) {
            char ch = source.charAt(i);
            if (hadLeadSurrogate && UTF16.isTrailSurrogate(ch)) {
                hadLeadSurrogate = false;
                continue;
            }
            hadLeadSurrogate = UTF16.isLeadSurrogate(ch);
            ++result;
        }
        if (offset16 == source.length()) {
            return result;
        }
        if (hadLeadSurrogate && UTF16.isTrailSurrogate(source.charAt(offset16))) {
            --result;
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$findCodePointOffset(char[] source, int start, int limit, int offset16) {
        if ((offset16 += start) > limit) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        int result = 0;
        boolean hadLeadSurrogate = false;
        for (int i = start; i < offset16; ++i) {
            char ch = source[i];
            if (hadLeadSurrogate && UTF16.isTrailSurrogate(ch)) {
                hadLeadSurrogate = false;
                continue;
            }
            hadLeadSurrogate = UTF16.isLeadSurrogate(ch);
            ++result;
        }
        if (offset16 == limit) {
            return result;
        }
        if (hadLeadSurrogate && UTF16.isTrailSurrogate(source[offset16])) {
            --result;
        }
        return result;
    }

    private static final StringBuffer $$robo$$android_icu_text_UTF16$append(StringBuffer target, int char32) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint: " + Integer.toHexString(char32));
        }
        if (char32 >= 65536) {
            target.append(UTF16.getLeadSurrogate(char32));
            target.append(UTF16.getTrailSurrogate(char32));
        } else {
            target.append((char)char32);
        }
        return target;
    }

    private static final StringBuffer $$robo$$android_icu_text_UTF16$appendCodePoint(StringBuffer target, int cp) {
        return UTF16.append(target, cp);
    }

    private static final int $$robo$$android_icu_text_UTF16$append(char[] target, int limit, int char32) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint");
        }
        if (char32 >= 65536) {
            target[limit++] = UTF16.getLeadSurrogate(char32);
            target[limit++] = UTF16.getTrailSurrogate(char32);
        } else {
            target[limit++] = (char)char32;
        }
        return limit;
    }

    private static final int $$robo$$android_icu_text_UTF16$countCodePoint(String source) {
        if (source == null || source.length() == 0) {
            return 0;
        }
        return UTF16.findCodePointOffset(source, source.length());
    }

    private static final int $$robo$$android_icu_text_UTF16$countCodePoint(StringBuffer source) {
        if (source == null || source.length() == 0) {
            return 0;
        }
        return UTF16.findCodePointOffset(source, source.length());
    }

    private static final int $$robo$$android_icu_text_UTF16$countCodePoint(char[] source, int start, int limit) {
        if (source == null || source.length == 0) {
            return 0;
        }
        return UTF16.findCodePointOffset(source, start, limit, limit - start);
    }

    private static final void $$robo$$android_icu_text_UTF16$setCharAt(StringBuffer target, int offset16, int char32) {
        int count = 1;
        char single = target.charAt(offset16);
        if (UTF16.isSurrogate(single)) {
            if (UTF16.isLeadSurrogate(single) && target.length() > offset16 + 1 && UTF16.isTrailSurrogate(target.charAt(offset16 + 1))) {
                ++count;
            } else if (UTF16.isTrailSurrogate(single) && offset16 > 0 && UTF16.isLeadSurrogate(target.charAt(offset16 - 1))) {
                --offset16;
                ++count;
            }
        }
        target.replace(offset16, offset16 + count, UTF16.valueOf(char32));
    }

    private static final int $$robo$$android_icu_text_UTF16$setCharAt(char[] target, int limit, int offset16, int char32) {
        if (offset16 >= limit) {
            throw new ArrayIndexOutOfBoundsException(offset16);
        }
        int count = 1;
        char single = target[offset16];
        if (UTF16.isSurrogate(single)) {
            if (UTF16.isLeadSurrogate(single) && target.length > offset16 + 1 && UTF16.isTrailSurrogate(target[offset16 + 1])) {
                ++count;
            } else if (UTF16.isTrailSurrogate(single) && offset16 > 0 && UTF16.isLeadSurrogate(target[offset16 - 1])) {
                --offset16;
                ++count;
            }
        }
        String str = UTF16.valueOf(char32);
        int result = limit;
        int strlength = str.length();
        target[offset16] = str.charAt(0);
        if (count == strlength) {
            if (count == 2) {
                target[offset16 + 1] = str.charAt(1);
            }
        } else {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)target, (int)(offset16 + count), (Object)target, (int)(offset16 + strlength), (int)(limit - (offset16 + count)));
            if (count < strlength) {
                target[offset16 + 1] = str.charAt(1);
                if (++result < target.length) {
                    target[result] = '\u0000';
                }
            } else {
                target[--result] = '\u0000';
            }
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$moveCodePointOffset(String source, int offset16, int shift32) {
        int count;
        int result = offset16;
        int size = source.length();
        if (offset16 < 0 || offset16 > size) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        if (shift32 > 0) {
            if (shift32 + offset16 > size) {
                throw new StringIndexOutOfBoundsException(offset16);
            }
            for (count = shift32; result < size && count > 0; --count, ++result) {
                char ch = source.charAt(result);
                if (!UTF16.isLeadSurrogate(ch) || result + 1 >= size || !UTF16.isTrailSurrogate(source.charAt(result + 1))) continue;
                ++result;
            }
        } else {
            if (offset16 + shift32 < 0) {
                throw new StringIndexOutOfBoundsException(offset16);
            }
            for (count = -shift32; count > 0 && --result >= 0; --count) {
                char ch = source.charAt(result);
                if (!UTF16.isTrailSurrogate(ch) || result <= 0 || !UTF16.isLeadSurrogate(source.charAt(result - 1))) continue;
                --result;
            }
        }
        if (count != 0) {
            throw new StringIndexOutOfBoundsException(shift32);
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$moveCodePointOffset(StringBuffer source, int offset16, int shift32) {
        int count;
        int result = offset16;
        int size = source.length();
        if (offset16 < 0 || offset16 > size) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        if (shift32 > 0) {
            if (shift32 + offset16 > size) {
                throw new StringIndexOutOfBoundsException(offset16);
            }
            for (count = shift32; result < size && count > 0; --count, ++result) {
                char ch = source.charAt(result);
                if (!UTF16.isLeadSurrogate(ch) || result + 1 >= size || !UTF16.isTrailSurrogate(source.charAt(result + 1))) continue;
                ++result;
            }
        } else {
            if (offset16 + shift32 < 0) {
                throw new StringIndexOutOfBoundsException(offset16);
            }
            for (count = -shift32; count > 0 && --result >= 0; --count) {
                char ch = source.charAt(result);
                if (!UTF16.isTrailSurrogate(ch) || result <= 0 || !UTF16.isLeadSurrogate(source.charAt(result - 1))) continue;
                --result;
            }
        }
        if (count != 0) {
            throw new StringIndexOutOfBoundsException(shift32);
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$moveCodePointOffset(char[] source, int start, int limit, int offset16, int shift32) {
        int count;
        int size = source.length;
        int result = offset16 + start;
        if (start < 0 || limit < start) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (limit > size) {
            throw new StringIndexOutOfBoundsException(limit);
        }
        if (offset16 < 0 || result > limit) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        if (shift32 > 0) {
            if (shift32 + result > size) {
                throw new StringIndexOutOfBoundsException(result);
            }
            for (count = shift32; result < limit && count > 0; --count, ++result) {
                char ch = source[result];
                if (!UTF16.isLeadSurrogate(ch) || result + 1 >= limit || !UTF16.isTrailSurrogate(source[result + 1])) continue;
                ++result;
            }
        } else {
            if (result + shift32 < start) {
                throw new StringIndexOutOfBoundsException(result);
            }
            for (count = -shift32; count > 0 && --result >= start; --count) {
                char ch = source[result];
                if (!UTF16.isTrailSurrogate(ch) || result <= start || !UTF16.isLeadSurrogate(source[result - 1])) continue;
                --result;
            }
        }
        if (count != 0) {
            throw new StringIndexOutOfBoundsException(shift32);
        }
        return result -= start;
    }

    private static final StringBuffer $$robo$$android_icu_text_UTF16$insert(StringBuffer target, int offset16, int char32) {
        String str = UTF16.valueOf(char32);
        if (offset16 != target.length() && UTF16.bounds(target, offset16) == 5) {
            ++offset16;
        }
        target.insert(offset16, str);
        return target;
    }

    private static final int $$robo$$android_icu_text_UTF16$insert(char[] target, int limit, int offset16, int char32) {
        int size;
        String str = UTF16.valueOf(char32);
        if (offset16 != limit && UTF16.bounds(target, 0, limit, offset16) == 5) {
            ++offset16;
        }
        if (limit + (size = str.length()) > target.length) {
            throw new ArrayIndexOutOfBoundsException(offset16 + size);
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)target, (int)offset16, (Object)target, (int)(offset16 + size), (int)(limit - offset16));
        target[offset16] = str.charAt(0);
        if (size == 2) {
            target[offset16 + 1] = str.charAt(1);
        }
        return limit + size;
    }

    private static final StringBuffer $$robo$$android_icu_text_UTF16$delete(StringBuffer target, int offset16) {
        int count = 1;
        switch (UTF16.bounds(target, offset16)) {
            case 2: {
                ++count;
                break;
            }
            case 5: {
                ++count;
                --offset16;
            }
        }
        target.delete(offset16, offset16 + count);
        return target;
    }

    private static final int $$robo$$android_icu_text_UTF16$delete(char[] target, int limit, int offset16) {
        int count = 1;
        switch (UTF16.bounds(target, 0, limit, offset16)) {
            case 2: {
                ++count;
                break;
            }
            case 5: {
                ++count;
                --offset16;
            }
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)target, (int)(offset16 + count), (Object)target, (int)offset16, (int)(limit - (offset16 + count)));
        target[limit - count] = '\u0000';
        return limit - count;
    }

    private static final int $$robo$$android_icu_text_UTF16$indexOf(String source, int char32) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument char32 is not a valid codepoint");
        }
        if (char32 < 55296 || char32 > 57343 && char32 < 65536) {
            return source.indexOf((char)char32);
        }
        if (char32 < 65536) {
            int result = source.indexOf((char)char32);
            if (result >= 0) {
                if (UTF16.isLeadSurrogate((char)char32) && result < source.length() - 1 && UTF16.isTrailSurrogate(source.charAt(result + 1))) {
                    return UTF16.indexOf(source, char32, result + 1);
                }
                if (result > 0 && UTF16.isLeadSurrogate(source.charAt(result - 1))) {
                    return UTF16.indexOf(source, char32, result + 1);
                }
            }
            return result;
        }
        String char32str = UTF16.toString(char32);
        return source.indexOf(char32str);
    }

    private static final int $$robo$$android_icu_text_UTF16$indexOf(String source, String str) {
        int strLength = str.length();
        if (!UTF16.isTrailSurrogate(str.charAt(0)) && !UTF16.isLeadSurrogate(str.charAt(strLength - 1))) {
            return source.indexOf(str);
        }
        int result = source.indexOf(str);
        int resultEnd = result + strLength;
        if (result >= 0) {
            if (UTF16.isLeadSurrogate(str.charAt(strLength - 1)) && result < source.length() - 1 && UTF16.isTrailSurrogate(source.charAt(resultEnd + 1))) {
                return UTF16.indexOf(source, str, resultEnd + 1);
            }
            if (UTF16.isTrailSurrogate(str.charAt(0)) && result > 0 && UTF16.isLeadSurrogate(source.charAt(result - 1))) {
                return UTF16.indexOf(source, str, resultEnd + 1);
            }
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$indexOf(String source, int char32, int fromIndex) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument char32 is not a valid codepoint");
        }
        if (char32 < 55296 || char32 > 57343 && char32 < 65536) {
            return source.indexOf((char)char32, fromIndex);
        }
        if (char32 < 65536) {
            int result = source.indexOf((char)char32, fromIndex);
            if (result >= 0) {
                if (UTF16.isLeadSurrogate((char)char32) && result < source.length() - 1 && UTF16.isTrailSurrogate(source.charAt(result + 1))) {
                    return UTF16.indexOf(source, char32, result + 1);
                }
                if (result > 0 && UTF16.isLeadSurrogate(source.charAt(result - 1))) {
                    return UTF16.indexOf(source, char32, result + 1);
                }
            }
            return result;
        }
        String char32str = UTF16.toString(char32);
        return source.indexOf(char32str, fromIndex);
    }

    private static final int $$robo$$android_icu_text_UTF16$indexOf(String source, String str, int fromIndex) {
        int strLength = str.length();
        if (!UTF16.isTrailSurrogate(str.charAt(0)) && !UTF16.isLeadSurrogate(str.charAt(strLength - 1))) {
            return source.indexOf(str, fromIndex);
        }
        int result = source.indexOf(str, fromIndex);
        int resultEnd = result + strLength;
        if (result >= 0) {
            if (UTF16.isLeadSurrogate(str.charAt(strLength - 1)) && result < source.length() - 1 && UTF16.isTrailSurrogate(source.charAt(resultEnd))) {
                return UTF16.indexOf(source, str, resultEnd + 1);
            }
            if (UTF16.isTrailSurrogate(str.charAt(0)) && result > 0 && UTF16.isLeadSurrogate(source.charAt(result - 1))) {
                return UTF16.indexOf(source, str, resultEnd + 1);
            }
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$lastIndexOf(String source, int char32) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument char32 is not a valid codepoint");
        }
        if (char32 < 55296 || char32 > 57343 && char32 < 65536) {
            return source.lastIndexOf((char)char32);
        }
        if (char32 < 65536) {
            int result = source.lastIndexOf((char)char32);
            if (result >= 0) {
                if (UTF16.isLeadSurrogate((char)char32) && result < source.length() - 1 && UTF16.isTrailSurrogate(source.charAt(result + 1))) {
                    return UTF16.lastIndexOf(source, char32, result - 1);
                }
                if (result > 0 && UTF16.isLeadSurrogate(source.charAt(result - 1))) {
                    return UTF16.lastIndexOf(source, char32, result - 1);
                }
            }
            return result;
        }
        String char32str = UTF16.toString(char32);
        return source.lastIndexOf(char32str);
    }

    private static final int $$robo$$android_icu_text_UTF16$lastIndexOf(String source, String str) {
        int strLength = str.length();
        if (!UTF16.isTrailSurrogate(str.charAt(0)) && !UTF16.isLeadSurrogate(str.charAt(strLength - 1))) {
            return source.lastIndexOf(str);
        }
        int result = source.lastIndexOf(str);
        if (result >= 0) {
            if (UTF16.isLeadSurrogate(str.charAt(strLength - 1)) && result < source.length() - 1 && UTF16.isTrailSurrogate(source.charAt(result + strLength + 1))) {
                return UTF16.lastIndexOf(source, str, result - 1);
            }
            if (UTF16.isTrailSurrogate(str.charAt(0)) && result > 0 && UTF16.isLeadSurrogate(source.charAt(result - 1))) {
                return UTF16.lastIndexOf(source, str, result - 1);
            }
        }
        return result;
    }

    private static final int $$robo$$android_icu_text_UTF16$lastIndexOf(String source, int char32, int fromIndex) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument char32 is not a valid codepoint");
        }
        if (char32 < 55296 || char32 > 57343 && char32 < 65536) {
            return source.lastIndexOf((char)char32, fromIndex);
        }
        if (char32 < 65536) {
            int result = source.lastIndexOf((char)char32, fromIndex);
            if (result >= 0) {
                if (UTF16.isLeadSurrogate((char)char32) && result < source.length() - 1 && UTF16.isTrailSurrogate(source.charAt(result + 1))) {
                    return UTF16.lastIndexOf(source, char32, result - 1);
                }
                if (result > 0 && UTF16.isLeadSurrogate(source.charAt(result - 1))) {
                    return UTF16.lastIndexOf(source, char32, result - 1);
                }
            }
            return result;
        }
        String char32str = UTF16.toString(char32);
        return source.lastIndexOf(char32str, fromIndex);
    }

    private static final int $$robo$$android_icu_text_UTF16$lastIndexOf(String source, String str, int fromIndex) {
        int strLength = str.length();
        if (!UTF16.isTrailSurrogate(str.charAt(0)) && !UTF16.isLeadSurrogate(str.charAt(strLength - 1))) {
            return source.lastIndexOf(str, fromIndex);
        }
        int result = source.lastIndexOf(str, fromIndex);
        if (result >= 0) {
            if (UTF16.isLeadSurrogate(str.charAt(strLength - 1)) && result < source.length() - 1 && UTF16.isTrailSurrogate(source.charAt(result + strLength))) {
                return UTF16.lastIndexOf(source, str, result - 1);
            }
            if (UTF16.isTrailSurrogate(str.charAt(0)) && result > 0 && UTF16.isLeadSurrogate(source.charAt(result - 1))) {
                return UTF16.lastIndexOf(source, str, result - 1);
            }
        }
        return result;
    }

    private static final String $$robo$$android_icu_text_UTF16$replace(String source, int oldChar32, int newChar32) {
        if (oldChar32 <= 0 || oldChar32 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument oldChar32 is not a valid codepoint");
        }
        if (newChar32 <= 0 || newChar32 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument newChar32 is not a valid codepoint");
        }
        int index = UTF16.indexOf(source, oldChar32);
        if (index == -1) {
            return source;
        }
        String newChar32Str = UTF16.toString(newChar32);
        int oldChar32Size = 1;
        int newChar32Size = newChar32Str.length();
        StringBuffer result = new StringBuffer(source);
        int resultIndex = index;
        if (oldChar32 >= 65536) {
            oldChar32Size = 2;
        }
        while (index != -1) {
            int endResultIndex = resultIndex + oldChar32Size;
            result.replace(resultIndex, endResultIndex, newChar32Str);
            int lastEndIndex = index + oldChar32Size;
            index = UTF16.indexOf(source, oldChar32, lastEndIndex);
            resultIndex += newChar32Size + index - lastEndIndex;
        }
        return result.toString();
    }

    private static final String $$robo$$android_icu_text_UTF16$replace(String source, String oldStr, String newStr) {
        int index = UTF16.indexOf(source, oldStr);
        if (index == -1) {
            return source;
        }
        int oldStrSize = oldStr.length();
        int newStrSize = newStr.length();
        StringBuffer result = new StringBuffer(source);
        int resultIndex = index;
        while (index != -1) {
            int endResultIndex = resultIndex + oldStrSize;
            result.replace(resultIndex, endResultIndex, newStr);
            int lastEndIndex = index + oldStrSize;
            index = UTF16.indexOf(source, oldStr, lastEndIndex);
            resultIndex += newStrSize + index - lastEndIndex;
        }
        return result.toString();
    }

    private static final StringBuffer $$robo$$android_icu_text_UTF16$reverse(StringBuffer source) {
        int length = source.length();
        StringBuffer result = new StringBuffer(length);
        int i = length;
        while (i-- > 0) {
            char ch2;
            char ch = source.charAt(i);
            if (UTF16.isTrailSurrogate(ch) && i > 0 && UTF16.isLeadSurrogate(ch2 = source.charAt(i - 1))) {
                result.append(ch2);
                result.append(ch);
                --i;
                continue;
            }
            result.append(ch);
        }
        return result;
    }

    private static final boolean $$robo$$android_icu_text_UTF16$hasMoreCodePointsThan(String source, int number) {
        if (number < 0) {
            return true;
        }
        if (source == null) {
            return false;
        }
        int length = source.length();
        if (length + 1 >> 1 > number) {
            return true;
        }
        int maxsupplementary = length - number;
        if (maxsupplementary <= 0) {
            return false;
        }
        int start = 0;
        while (length != 0) {
            if (number == 0) {
                return true;
            }
            if (UTF16.isLeadSurrogate(source.charAt(start++)) && start != length && UTF16.isTrailSurrogate(source.charAt(start))) {
                ++start;
                if (--maxsupplementary <= 0) {
                    return false;
                }
            }
            --number;
        }
        return false;
    }

    private static final boolean $$robo$$android_icu_text_UTF16$hasMoreCodePointsThan(char[] source, int start, int limit, int number) {
        int length = limit - start;
        if (length < 0 || start < 0 || limit < 0) {
            throw new IndexOutOfBoundsException("Start and limit indexes should be non-negative and start <= limit");
        }
        if (number < 0) {
            return true;
        }
        if (source == null) {
            return false;
        }
        if (length + 1 >> 1 > number) {
            return true;
        }
        int maxsupplementary = length - number;
        if (maxsupplementary <= 0) {
            return false;
        }
        while (length != 0) {
            if (number == 0) {
                return true;
            }
            if (UTF16.isLeadSurrogate(source[start++]) && start != limit && UTF16.isTrailSurrogate(source[start])) {
                ++start;
                if (--maxsupplementary <= 0) {
                    return false;
                }
            }
            --number;
        }
        return false;
    }

    private static final boolean $$robo$$android_icu_text_UTF16$hasMoreCodePointsThan(StringBuffer source, int number) {
        if (number < 0) {
            return true;
        }
        if (source == null) {
            return false;
        }
        int length = source.length();
        if (length + 1 >> 1 > number) {
            return true;
        }
        int maxsupplementary = length - number;
        if (maxsupplementary <= 0) {
            return false;
        }
        int start = 0;
        while (length != 0) {
            if (number == 0) {
                return true;
            }
            if (UTF16.isLeadSurrogate(source.charAt(start++)) && start != length && UTF16.isTrailSurrogate(source.charAt(start))) {
                ++start;
                if (--maxsupplementary <= 0) {
                    return false;
                }
            }
            --number;
        }
        return false;
    }

    private static final String $$robo$$android_icu_text_UTF16$newString(int[] codePoints, int offset, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        char[] chars = new char[count];
        int w = 0;
        int e = offset + count;
        block2: for (int r = offset; r < e; ++r) {
            int cp = codePoints[r];
            if (cp < 0 || cp > 0x10FFFF) {
                throw new IllegalArgumentException();
            }
            while (true) {
                try {
                    if (cp < 65536) {
                        chars[w] = (char)cp;
                        ++w;
                        continue block2;
                    }
                    chars[w] = (char)(55232 + (cp >> 10));
                    chars[w + 1] = (char)(56320 + (cp & 0x3FF));
                    w += 2;
                    continue block2;
                }
                catch (IndexOutOfBoundsException ex) {
                    int newlen = (int)Math.ceil((double)codePoints.length * (double)(w + 2) / (double)(r - offset + 1));
                    char[] temp = new char[newlen];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)chars, (int)0, (Object)temp, (int)0, (int)w);
                    chars = temp;
                    continue;
                }
                break;
            }
        }
        return new String(chars, 0, w);
    }

    private static final int $$robo$$android_icu_text_UTF16$getSingleCodePoint(CharSequence s) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        if (s.length() > 2) {
            return -1;
        }
        int cp = Character.codePointAt(s, 0);
        if (cp > 65535) {
            return cp;
        }
        return -1;
    }

    private static final int $$robo$$android_icu_text_UTF16$compareCodePoint(int codePoint, CharSequence s) {
        if (s == null) {
            return 1;
        }
        int strLen = s.length();
        if (strLen == 0) {
            return 1;
        }
        int second = Character.codePointAt(s, 0);
        int diff = codePoint - second;
        if (diff != 0) {
            return diff;
        }
        return strLen == Character.charCount(codePoint) ? 0 : -1;
    }

    private static final String $$robo$$android_icu_text_UTF16$toString(int ch) {
        if (ch < 65536) {
            return String.valueOf((char)ch);
        }
        StringBuilder result = new StringBuilder();
        result.append(UTF16.getLeadSurrogate(ch));
        result.append(UTF16.getTrailSurrogate(ch));
        return result.toString();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_UTF16$__constructor__();
    }

    public UTF16() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UTF16$__constructor__(), this);
    }

    public static int charAt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("charAt", $$robo$$android_icu_text_UTF16$charAt(java.lang.String int ), (String)string2, (int)n);
    }

    private static int _charAt(String string2, int n, char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("_charAt", $$robo$$android_icu_text_UTF16$_charAt(java.lang.String int char ), (String)string2, (int)n, (char)c);
    }

    public static int charAt(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("charAt", $$robo$$android_icu_text_UTF16$charAt(java.lang.CharSequence int ), (CharSequence)charSequence, (int)n);
    }

    private static int _charAt(CharSequence charSequence, int n, char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("_charAt", $$robo$$android_icu_text_UTF16$_charAt(java.lang.CharSequence int char ), (CharSequence)charSequence, (int)n, (char)c);
    }

    public static int charAt(StringBuffer stringBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("charAt", $$robo$$android_icu_text_UTF16$charAt(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static int charAt(char[] cArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("charAt", $$robo$$android_icu_text_UTF16$charAt(char[] int int int ), (char[])cArray, (int)n, (int)n2, (int)n3);
    }

    public static int charAt(Replaceable replaceable, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("charAt", $$robo$$android_icu_text_UTF16$charAt(android.icu.text.Replaceable int ), (Replaceable)replaceable, (int)n);
    }

    public static int getCharCount(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCharCount", $$robo$$android_icu_text_UTF16$getCharCount(int ), (int)n);
    }

    public static int bounds(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bounds", $$robo$$android_icu_text_UTF16$bounds(java.lang.String int ), (String)string2, (int)n);
    }

    public static int bounds(StringBuffer stringBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bounds", $$robo$$android_icu_text_UTF16$bounds(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static int bounds(char[] cArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bounds", $$robo$$android_icu_text_UTF16$bounds(char[] int int int ), (char[])cArray, (int)n, (int)n2, (int)n3);
    }

    public static boolean isSurrogate(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSurrogate", $$robo$$android_icu_text_UTF16$isSurrogate(char ), (char)c);
    }

    public static boolean isTrailSurrogate(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTrailSurrogate", $$robo$$android_icu_text_UTF16$isTrailSurrogate(char ), (char)c);
    }

    public static boolean isLeadSurrogate(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLeadSurrogate", $$robo$$android_icu_text_UTF16$isLeadSurrogate(char ), (char)c);
    }

    public static char getLeadSurrogate(int n) {
        return (char)InvokeDynamicSupport.bootstrapStatic("getLeadSurrogate", $$robo$$android_icu_text_UTF16$getLeadSurrogate(int ), (int)n);
    }

    public static char getTrailSurrogate(int n) {
        return (char)InvokeDynamicSupport.bootstrapStatic("getTrailSurrogate", $$robo$$android_icu_text_UTF16$getTrailSurrogate(int ), (int)n);
    }

    public static String valueOf(int n) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_UTF16$valueOf(int ), (int)n);
    }

    public static String valueOf(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_UTF16$valueOf(java.lang.String int ), (String)string2, (int)n);
    }

    public static String valueOf(StringBuffer stringBuffer, int n) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_UTF16$valueOf(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static String valueOf(char[] cArray, int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_UTF16$valueOf(char[] int int int ), (char[])cArray, (int)n, (int)n2, (int)n3);
    }

    public static int findOffsetFromCodePoint(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findOffsetFromCodePoint", $$robo$$android_icu_text_UTF16$findOffsetFromCodePoint(java.lang.String int ), (String)string2, (int)n);
    }

    public static int findOffsetFromCodePoint(StringBuffer stringBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findOffsetFromCodePoint", $$robo$$android_icu_text_UTF16$findOffsetFromCodePoint(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static int findOffsetFromCodePoint(char[] cArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findOffsetFromCodePoint", $$robo$$android_icu_text_UTF16$findOffsetFromCodePoint(char[] int int int ), (char[])cArray, (int)n, (int)n2, (int)n3);
    }

    public static int findCodePointOffset(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findCodePointOffset", $$robo$$android_icu_text_UTF16$findCodePointOffset(java.lang.String int ), (String)string2, (int)n);
    }

    public static int findCodePointOffset(StringBuffer stringBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findCodePointOffset", $$robo$$android_icu_text_UTF16$findCodePointOffset(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static int findCodePointOffset(char[] cArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findCodePointOffset", $$robo$$android_icu_text_UTF16$findCodePointOffset(char[] int int int ), (char[])cArray, (int)n, (int)n2, (int)n3);
    }

    public static StringBuffer append(StringBuffer stringBuffer, int n) {
        return InvokeDynamicSupport.bootstrapStatic("append", $$robo$$android_icu_text_UTF16$append(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static StringBuffer appendCodePoint(StringBuffer stringBuffer, int n) {
        return InvokeDynamicSupport.bootstrapStatic("appendCodePoint", $$robo$$android_icu_text_UTF16$appendCodePoint(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static int append(char[] cArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("append", $$robo$$android_icu_text_UTF16$append(char[] int int ), (char[])cArray, (int)n, (int)n2);
    }

    public static int countCodePoint(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countCodePoint", $$robo$$android_icu_text_UTF16$countCodePoint(java.lang.String ), (String)string2);
    }

    public static int countCodePoint(StringBuffer stringBuffer) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countCodePoint", $$robo$$android_icu_text_UTF16$countCodePoint(java.lang.StringBuffer ), (StringBuffer)stringBuffer);
    }

    public static int countCodePoint(char[] cArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countCodePoint", $$robo$$android_icu_text_UTF16$countCodePoint(char[] int int ), (char[])cArray, (int)n, (int)n2);
    }

    public static void setCharAt(StringBuffer stringBuffer, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("setCharAt", $$robo$$android_icu_text_UTF16$setCharAt(java.lang.StringBuffer int int ), (StringBuffer)stringBuffer, (int)n, (int)n2);
    }

    public static int setCharAt(char[] cArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setCharAt", $$robo$$android_icu_text_UTF16$setCharAt(char[] int int int ), (char[])cArray, (int)n, (int)n2, (int)n3);
    }

    public static int moveCodePointOffset(String string2, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("moveCodePointOffset", $$robo$$android_icu_text_UTF16$moveCodePointOffset(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    public static int moveCodePointOffset(StringBuffer stringBuffer, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("moveCodePointOffset", $$robo$$android_icu_text_UTF16$moveCodePointOffset(java.lang.StringBuffer int int ), (StringBuffer)stringBuffer, (int)n, (int)n2);
    }

    public static int moveCodePointOffset(char[] cArray, int n, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("moveCodePointOffset", $$robo$$android_icu_text_UTF16$moveCodePointOffset(char[] int int int int ), (char[])cArray, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static StringBuffer insert(StringBuffer stringBuffer, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("insert", $$robo$$android_icu_text_UTF16$insert(java.lang.StringBuffer int int ), (StringBuffer)stringBuffer, (int)n, (int)n2);
    }

    public static int insert(char[] cArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("insert", $$robo$$android_icu_text_UTF16$insert(char[] int int int ), (char[])cArray, (int)n, (int)n2, (int)n3);
    }

    public static StringBuffer delete(StringBuffer stringBuffer, int n) {
        return InvokeDynamicSupport.bootstrapStatic("delete", $$robo$$android_icu_text_UTF16$delete(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static int delete(char[] cArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("delete", $$robo$$android_icu_text_UTF16$delete(char[] int int ), (char[])cArray, (int)n, (int)n2);
    }

    public static int indexOf(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_icu_text_UTF16$indexOf(java.lang.String int ), (String)string2, (int)n);
    }

    public static int indexOf(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_icu_text_UTF16$indexOf(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    public static int indexOf(String string2, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_icu_text_UTF16$indexOf(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    public static int indexOf(String string2, String string3, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_icu_text_UTF16$indexOf(java.lang.String java.lang.String int ), (String)string2, (String)string3, (int)n);
    }

    public static int lastIndexOf(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOf", $$robo$$android_icu_text_UTF16$lastIndexOf(java.lang.String int ), (String)string2, (int)n);
    }

    public static int lastIndexOf(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOf", $$robo$$android_icu_text_UTF16$lastIndexOf(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    public static int lastIndexOf(String string2, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOf", $$robo$$android_icu_text_UTF16$lastIndexOf(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    public static int lastIndexOf(String string2, String string3, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOf", $$robo$$android_icu_text_UTF16$lastIndexOf(java.lang.String java.lang.String int ), (String)string2, (String)string3, (int)n);
    }

    public static String replace(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("replace", $$robo$$android_icu_text_UTF16$replace(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    public static String replace(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("replace", $$robo$$android_icu_text_UTF16$replace(java.lang.String java.lang.String java.lang.String ), (String)string2, (String)string3, (String)string4);
    }

    public static StringBuffer reverse(StringBuffer stringBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("reverse", $$robo$$android_icu_text_UTF16$reverse(java.lang.StringBuffer ), (StringBuffer)stringBuffer);
    }

    public static boolean hasMoreCodePointsThan(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasMoreCodePointsThan", $$robo$$android_icu_text_UTF16$hasMoreCodePointsThan(java.lang.String int ), (String)string2, (int)n);
    }

    public static boolean hasMoreCodePointsThan(char[] cArray, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasMoreCodePointsThan", $$robo$$android_icu_text_UTF16$hasMoreCodePointsThan(char[] int int int ), (char[])cArray, (int)n, (int)n2, (int)n3);
    }

    public static boolean hasMoreCodePointsThan(StringBuffer stringBuffer, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasMoreCodePointsThan", $$robo$$android_icu_text_UTF16$hasMoreCodePointsThan(java.lang.StringBuffer int ), (StringBuffer)stringBuffer, (int)n);
    }

    public static String newString(int[] nArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("newString", $$robo$$android_icu_text_UTF16$newString(int[] int int ), (int[])nArray, (int)n, (int)n2);
    }

    public static int getSingleCodePoint(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSingleCodePoint", $$robo$$android_icu_text_UTF16$getSingleCodePoint(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    public static int compareCodePoint(int n, CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareCodePoint", $$robo$$android_icu_text_UTF16$compareCodePoint(int java.lang.CharSequence ), (int)n, (CharSequence)charSequence);
    }

    private static String toString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$android_icu_text_UTF16$toString(int ), (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UTF16)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class StringComparator
    implements Comparator<String> {
        public /* synthetic */ Object __robo_data__;
        public static int FOLD_CASE_DEFAULT = 0;
        public static int FOLD_CASE_EXCLUDE_SPECIAL_I = 1;
        private int m_codePointCompare_;
        private int m_foldCase_;
        private boolean m_ignoreCase_;
        private static int CODE_POINT_COMPARE_SURROGATE_OFFSET_ = 10240;

        private void $$robo$$android_icu_text_UTF16_StringComparator$__constructor__() {
        }

        private void $$robo$$android_icu_text_UTF16_StringComparator$__constructor__(boolean codepointcompare, boolean ignorecase, int foldcaseoption) {
            this.setCodePointCompare(codepointcompare);
            this.m_ignoreCase_ = ignorecase;
            if (foldcaseoption < 0 || foldcaseoption > 1) {
                throw new IllegalArgumentException("Invalid fold case option");
            }
            this.m_foldCase_ = foldcaseoption;
        }

        private final void $$robo$$android_icu_text_UTF16_StringComparator$setCodePointCompare(boolean flag) {
            this.m_codePointCompare_ = flag ? 32768 : 0;
        }

        private final void $$robo$$android_icu_text_UTF16_StringComparator$setIgnoreCase(boolean ignorecase, int foldcaseoption) {
            this.m_ignoreCase_ = ignorecase;
            if (foldcaseoption < 0 || foldcaseoption > 1) {
                throw new IllegalArgumentException("Invalid fold case option");
            }
            this.m_foldCase_ = foldcaseoption;
        }

        private final boolean $$robo$$android_icu_text_UTF16_StringComparator$getCodePointCompare() {
            return this.m_codePointCompare_ == 32768;
        }

        private final boolean $$robo$$android_icu_text_UTF16_StringComparator$getIgnoreCase() {
            return this.m_ignoreCase_;
        }

        private final int $$robo$$android_icu_text_UTF16_StringComparator$getIgnoreCaseOption() {
            return this.m_foldCase_;
        }

        private final int $$robo$$android_icu_text_UTF16_StringComparator$compare(String a, String b) {
            if (Utility.sameObjects(a, b)) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (this.m_ignoreCase_) {
                return this.compareCaseInsensitive(a, b);
            }
            return this.compareCaseSensitive(a, b);
        }

        private final int $$robo$$android_icu_text_UTF16_StringComparator$compareCaseInsensitive(String s1, String s2) {
            return Normalizer.cmpEquivFold(s1, s2, this.m_foldCase_ | this.m_codePointCompare_ | 0x10000);
        }

        private final int $$robo$$android_icu_text_UTF16_StringComparator$compareCaseSensitive(String s1, String s2) {
            boolean codepointcompare;
            int index;
            int length1 = s1.length();
            int length2 = s2.length();
            int minlength = length1;
            int result = 0;
            if (length1 < length2) {
                result = -1;
            } else if (length1 > length2) {
                result = 1;
                minlength = length2;
            }
            char c1 = '\u0000';
            char c2 = '\u0000';
            for (index = 0; index < minlength && (c1 = s1.charAt(index)) == (c2 = s2.charAt(index)); ++index) {
            }
            if (index == minlength) {
                return result;
            }
            boolean bl = codepointcompare = this.m_codePointCompare_ == 32768;
            if (c1 >= '\ud800' && c2 >= '\ud800' && codepointcompare) {
                if (!(c1 <= '\udbff' && index + 1 != length1 && UTF16.isTrailSurrogate(s1.charAt(index + 1)) || UTF16.isTrailSurrogate(c1) && index != 0 && UTF16.isLeadSurrogate(s1.charAt(index - 1)))) {
                    c1 = (char)(c1 - 10240);
                }
                if (!(c2 <= '\udbff' && index + 1 != length2 && UTF16.isTrailSurrogate(s2.charAt(index + 1)) || UTF16.isTrailSurrogate(c2) && index != 0 && UTF16.isLeadSurrogate(s2.charAt(index - 1)))) {
                    c2 = (char)(c2 - 10240);
                }
            }
            return c1 - c2;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_UTF16_StringComparator$__constructor__();
        }

        public StringComparator() {
            this(false, false, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UTF16_StringComparator$__constructor__(), this);
        }

        private void __constructor__(boolean bl, boolean bl2, int n) {
            this.$$robo$$android_icu_text_UTF16_StringComparator$__constructor__(bl, bl2, n);
        }

        public StringComparator(boolean bl, boolean bl2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UTF16_StringComparator$__constructor__(boolean boolean int ), this, bl, bl2, n);
        }

        public void setCodePointCompare(boolean bl) {
            InvokeDynamicSupport.bootstrap("setCodePointCompare", $$robo$$android_icu_text_UTF16_StringComparator$setCodePointCompare(boolean ), this, bl);
        }

        public void setIgnoreCase(boolean bl, int n) {
            InvokeDynamicSupport.bootstrap("setIgnoreCase", $$robo$$android_icu_text_UTF16_StringComparator$setIgnoreCase(boolean int ), this, bl, n);
        }

        public boolean getCodePointCompare() {
            return (boolean)InvokeDynamicSupport.bootstrap("getCodePointCompare", $$robo$$android_icu_text_UTF16_StringComparator$getCodePointCompare(), this);
        }

        public boolean getIgnoreCase() {
            return (boolean)InvokeDynamicSupport.bootstrap("getIgnoreCase", $$robo$$android_icu_text_UTF16_StringComparator$getIgnoreCase(), this);
        }

        public int getIgnoreCaseOption() {
            return (int)InvokeDynamicSupport.bootstrap("getIgnoreCaseOption", $$robo$$android_icu_text_UTF16_StringComparator$getIgnoreCaseOption(), this);
        }

        @Override
        public int compare(String string2, String string3) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_text_UTF16_StringComparator$compare(java.lang.String java.lang.String ), this, string2, string3);
        }

        private int compareCaseInsensitive(String string2, String string3) {
            return (int)InvokeDynamicSupport.bootstrap("compareCaseInsensitive", $$robo$$android_icu_text_UTF16_StringComparator$compareCaseInsensitive(java.lang.String java.lang.String ), this, string2, string3);
        }

        private int compareCaseSensitive(String string2, String string3) {
            return (int)InvokeDynamicSupport.bootstrap("compareCaseSensitive", $$robo$$android_icu_text_UTF16_StringComparator$compareCaseSensitive(java.lang.String java.lang.String ), this, string2, string3);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

