/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.util.ULocale;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocalePriorityList
implements Iterable<ULocale> {
    public /* synthetic */ Object __robo_data__;
    private static double D0 = 0.0;
    private static Double D1;
    private static Pattern languageSplitter;
    private static Pattern weightSplitter;
    private Map<ULocale, Double> languagesAndWeights;
    private static Comparator<Double> myDescendingDouble;

    private static final Builder $$robo$$android_icu_util_LocalePriorityList$add(ULocale ... languageCode) {
        return new Builder(null).add(languageCode);
    }

    private static final Builder $$robo$$android_icu_util_LocalePriorityList$add(ULocale languageCode, double weight) {
        return new Builder(null).add(languageCode, weight);
    }

    private static final Builder $$robo$$android_icu_util_LocalePriorityList$add(LocalePriorityList languagePriorityList) {
        return new Builder(null).add(languagePriorityList);
    }

    private static final Builder $$robo$$android_icu_util_LocalePriorityList$add(String acceptLanguageString) {
        return new Builder(null).add(acceptLanguageString);
    }

    private final Double $$robo$$android_icu_util_LocalePriorityList$getWeight(ULocale language) {
        return this.languagesAndWeights.get(language);
    }

    private final String $$robo$$android_icu_util_LocalePriorityList$toString() {
        StringBuilder result = new StringBuilder();
        for (ULocale language : this.languagesAndWeights.keySet()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(language);
            double weight = this.languagesAndWeights.get(language);
            if (weight == D1) continue;
            result.append(";q=").append(weight);
        }
        return result.toString();
    }

    private final Iterator<ULocale> $$robo$$android_icu_util_LocalePriorityList$iterator() {
        return this.languagesAndWeights.keySet().iterator();
    }

    private final boolean $$robo$$android_icu_util_LocalePriorityList$equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        try {
            LocalePriorityList that = (LocalePriorityList)o;
            return this.languagesAndWeights.equals(that.languagesAndWeights);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private final int $$robo$$android_icu_util_LocalePriorityList$hashCode() {
        return this.languagesAndWeights.hashCode();
    }

    private void $$robo$$android_icu_util_LocalePriorityList$__constructor__(Map<ULocale, Double> languageToWeight) {
        this.languagesAndWeights = languageToWeight;
    }

    private /* synthetic */ void $$robo$$android_icu_util_LocalePriorityList$__constructor__(Map x0, 1 x1) {
    }

    static void __staticInitializer__() {
        D1 = 1.0;
        languageSplitter = Pattern.compile("\\s*,\\s*");
        weightSplitter = Pattern.compile("\\s*(\\S*)\\s*;\\s*q\\s*=\\s*(\\S*)");
        myDescendingDouble = new Comparator<Double>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_util_LocalePriorityList_1$__constructor__() {
            }

            private final int $$robo$$android_icu_util_LocalePriorityList_1$compare(Double o1, Double o2) {
                int result = o1.compareTo(o2);
                return result > 0 ? -1 : (result < 0 ? 1 : 0);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_util_LocalePriorityList_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocalePriorityList_1$__constructor__(), this);
            }

            @Override
            public int compare(Double d, Double d2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_util_LocalePriorityList_1$compare(java.lang.Double java.lang.Double ), this, d, d2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static Builder add(ULocale ... uLocaleArray) {
        return InvokeDynamicSupport.bootstrapStatic("add", $$robo$$android_icu_util_LocalePriorityList$add(android.icu.util.ULocale[] ), (ULocale[])uLocaleArray);
    }

    public static Builder add(ULocale uLocale, double d) {
        return InvokeDynamicSupport.bootstrapStatic("add", $$robo$$android_icu_util_LocalePriorityList$add(android.icu.util.ULocale double ), (ULocale)uLocale, (double)d);
    }

    public static Builder add(LocalePriorityList localePriorityList) {
        return InvokeDynamicSupport.bootstrapStatic("add", $$robo$$android_icu_util_LocalePriorityList$add(android.icu.util.LocalePriorityList ), (LocalePriorityList)localePriorityList);
    }

    public static Builder add(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("add", $$robo$$android_icu_util_LocalePriorityList$add(java.lang.String ), (String)string2);
    }

    public Double getWeight(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getWeight", $$robo$$android_icu_util_LocalePriorityList$getWeight(android.icu.util.ULocale ), this, uLocale);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_LocalePriorityList$toString(), this);
    }

    @Override
    public Iterator<ULocale> iterator() {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_util_LocalePriorityList$iterator(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_LocalePriorityList$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_LocalePriorityList$hashCode(), this);
    }

    private void __constructor__(Map<ULocale, Double> map) {
        this.$$robo$$android_icu_util_LocalePriorityList$__constructor__(map);
    }

    public LocalePriorityList(Map<ULocale, Double> map) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocalePriorityList$__constructor__(java.util.Map<android.icu.util.ULocale, java.lang.Double> ), this, map);
    }

    private /* synthetic */ void __constructor__(Map map, 1 var2_2) {
        this.$$robo$$android_icu_util_LocalePriorityList$__constructor__(map, var2_2);
    }

    public /* synthetic */ LocalePriorityList(Map map, 1 var2_2) {
        this(map);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocalePriorityList$__constructor__(java.util.Map android.icu.util.LocalePriorityList$1 ), this, map, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(LocalePriorityList.class);
    }

    public /* synthetic */ LocalePriorityList() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalePriorityList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Map<ULocale, Double> languageToWeight;

        private void $$robo$$android_icu_util_LocalePriorityList_Builder$__constructor__() {
            this.languageToWeight = new LinkedHashMap<ULocale, Double>();
        }

        private final LocalePriorityList $$robo$$android_icu_util_LocalePriorityList_Builder$build() {
            return this.build(false);
        }

        private final LocalePriorityList $$robo$$android_icu_util_LocalePriorityList_Builder$build(boolean preserveWeights) {
            TreeMap<Double, LinkedHashSet<ULocale>> doubleCheck = new TreeMap<Double, LinkedHashSet<ULocale>>(myDescendingDouble);
            for (ULocale lang : this.languageToWeight.keySet()) {
                Double weight = this.languageToWeight.get(lang);
                LinkedHashSet<ULocale> s = (LinkedHashSet<ULocale>)doubleCheck.get(weight);
                if (s == null) {
                    s = new LinkedHashSet<ULocale>();
                    doubleCheck.put(weight, s);
                }
                s.add(lang);
            }
            LinkedHashMap<ULocale, Double> temp = new LinkedHashMap<ULocale, Double>();
            for (Map.Entry langEntry : doubleCheck.entrySet()) {
                Double weight = (Double)langEntry.getKey();
                for (ULocale lang : (Set)langEntry.getValue()) {
                    temp.put(lang, preserveWeights ? weight : D1);
                }
            }
            return new LocalePriorityList(Collections.unmodifiableMap(temp), null);
        }

        private final Builder $$robo$$android_icu_util_LocalePriorityList_Builder$add(LocalePriorityList languagePriorityList) {
            for (ULocale language : languagePriorityList.languagesAndWeights.keySet()) {
                this.add(language, (Double)languagePriorityList.languagesAndWeights.get(language));
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_LocalePriorityList_Builder$add(ULocale languageCode) {
            return this.add(languageCode, D1);
        }

        private final Builder $$robo$$android_icu_util_LocalePriorityList_Builder$add(ULocale ... languageCodes) {
            for (ULocale languageCode : languageCodes) {
                this.add(languageCode, D1);
            }
            return this;
        }

        private final Builder $$robo$$android_icu_util_LocalePriorityList_Builder$add(ULocale languageCode, double weight) {
            if (this.languageToWeight.containsKey(languageCode)) {
                this.languageToWeight.remove(languageCode);
            }
            if (weight <= 0.0) {
                return this;
            }
            if (weight > D1) {
                weight = D1;
            }
            this.languageToWeight.put(languageCode, weight);
            return this;
        }

        private final Builder $$robo$$android_icu_util_LocalePriorityList_Builder$add(String acceptLanguageList) {
            String[] items = languageSplitter.split(acceptLanguageList.trim());
            Matcher itemMatcher = weightSplitter.matcher("");
            for (String item : items) {
                if (itemMatcher.reset(item).matches()) {
                    ULocale language = new ULocale(itemMatcher.group(1));
                    double weight = Double.parseDouble(itemMatcher.group(2));
                    if (!(weight >= 0.0) || !(weight <= D1)) {
                        throw new IllegalArgumentException("Illegal weight, must be 0..1: " + weight);
                    }
                    this.add(language, weight);
                    continue;
                }
                if (item.length() == 0) continue;
                this.add(new ULocale(item));
            }
            return this;
        }

        private /* synthetic */ void $$robo$$android_icu_util_LocalePriorityList_Builder$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_LocalePriorityList_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocalePriorityList_Builder$__constructor__(), this);
        }

        public LocalePriorityList build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_icu_util_LocalePriorityList_Builder$build(), this);
        }

        public LocalePriorityList build(boolean bl) {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_icu_util_LocalePriorityList_Builder$build(boolean ), this, bl);
        }

        public Builder add(LocalePriorityList localePriorityList) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_LocalePriorityList_Builder$add(android.icu.util.LocalePriorityList ), this, localePriorityList);
        }

        public Builder add(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_LocalePriorityList_Builder$add(android.icu.util.ULocale ), this, uLocale);
        }

        public Builder add(ULocale ... uLocaleArray) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_LocalePriorityList_Builder$add(android.icu.util.ULocale[] ), this, uLocaleArray);
        }

        public Builder add(ULocale uLocale, double d) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_LocalePriorityList_Builder$add(android.icu.util.ULocale double ), this, uLocale, d);
        }

        public Builder add(String string2) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_LocalePriorityList_Builder$add(java.lang.String ), this, string2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_util_LocalePriorityList_Builder$__constructor__(var1_1);
        }

        public /* synthetic */ Builder(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocalePriorityList_Builder$__constructor__(android.icu.util.LocalePriorityList$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

