/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.media.PlayerBase;
import android.net.Uri;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.LinkedList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AsyncPlayer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int PLAY = 1;
    private static int STOP = 2;
    private static boolean mDebug = false;
    private LinkedList<Command> mCmdQueue;
    private String mTag;
    private Thread mThread;
    private MediaPlayer mPlayer;
    private PowerManager.WakeLock mWakeLock;
    private int mState;

    private final void $$robo$$android_media_AsyncPlayer$startSound(Command cmd) {
        try {
            MediaPlayer player = new MediaPlayer();
            player.setAudioAttributes(cmd.attributes);
            player.setDataSource(cmd.context, cmd.uri);
            player.setLooping(cmd.looping);
            player.prepare();
            player.start();
            if (this.mPlayer != null) {
                this.mPlayer.release();
            }
            this.mPlayer = player;
            long delay = SystemClock.uptimeMillis() - cmd.requestTime;
            if (delay > 1000L) {
                Log.w(this.mTag, "Notification sound delayed by " + delay + "msecs");
            }
        }
        catch (Exception e) {
            Log.w(this.mTag, "error loading sound for " + cmd.uri, e);
        }
    }

    private void $$robo$$android_media_AsyncPlayer$__constructor__(String tag) {
        this.mCmdQueue = new LinkedList();
        this.mState = 2;
        this.mTag = tag != null ? tag : "AsyncPlayer";
    }

    private final void $$robo$$android_media_AsyncPlayer$play(Context context, Uri uri, boolean looping, int stream) {
        PlayerBase.deprecateStreamTypeForPlayback(stream, "AsyncPlayer", "play()");
        if (context == null || uri == null) {
            return;
        }
        try {
            this.play(context, uri, looping, new AudioAttributes.Builder().setInternalLegacyStreamType(stream).build());
        }
        catch (IllegalArgumentException e) {
            Log.e(this.mTag, "Call to deprecated AsyncPlayer.play() method caused:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AsyncPlayer$play(Context context, Uri uri, boolean looping, AudioAttributes attributes) throws IllegalArgumentException {
        if (context == null || uri == null || attributes == null) {
            throw new IllegalArgumentException("Illegal null AsyncPlayer.play() argument");
        }
        Command cmd = new Command(null);
        cmd.requestTime = SystemClock.uptimeMillis();
        cmd.code = 1;
        cmd.context = context;
        cmd.uri = uri;
        cmd.looping = looping;
        cmd.attributes = attributes;
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            this.enqueueLocked(cmd);
            this.mState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AsyncPlayer$stop() {
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            if (this.mState != 2) {
                Command cmd = new Command(null);
                cmd.requestTime = SystemClock.uptimeMillis();
                cmd.code = 2;
                this.enqueueLocked(cmd);
                this.mState = 2;
            }
        }
    }

    private final void $$robo$$android_media_AsyncPlayer$enqueueLocked(Command cmd) {
        this.mCmdQueue.add(cmd);
        if (this.mThread == null) {
            this.acquireWakeLock();
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    private final void $$robo$$android_media_AsyncPlayer$setUsesWakeLock(Context context) {
        if (this.mWakeLock != null || this.mThread != null) {
            throw new RuntimeException("assertion failed mWakeLock=" + this.mWakeLock + " mThread=" + this.mThread);
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, this.mTag);
    }

    private final void $$robo$$android_media_AsyncPlayer$acquireWakeLock() {
        if (this.mWakeLock != null) {
            this.mWakeLock.acquire();
        }
    }

    private final void $$robo$$android_media_AsyncPlayer$releaseWakeLock() {
        if (this.mWakeLock != null) {
            this.mWakeLock.release();
        }
    }

    private void startSound(Command command) {
        InvokeDynamicSupport.bootstrap("startSound", $$robo$$android_media_AsyncPlayer$startSound(android.media.AsyncPlayer$Command ), this, command);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_media_AsyncPlayer$__constructor__(string2);
    }

    public AsyncPlayer(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AsyncPlayer$__constructor__(java.lang.String ), this, string2);
    }

    public void play(Context context, Uri uri, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_AsyncPlayer$play(android.content.Context android.net.Uri boolean int ), this, context, uri, bl, n);
    }

    public void play(Context context, Uri uri, boolean bl, AudioAttributes audioAttributes) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_AsyncPlayer$play(android.content.Context android.net.Uri boolean android.media.AudioAttributes ), this, context, uri, bl, audioAttributes);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_AsyncPlayer$stop(), this);
    }

    private void enqueueLocked(Command command) {
        InvokeDynamicSupport.bootstrap("enqueueLocked", $$robo$$android_media_AsyncPlayer$enqueueLocked(android.media.AsyncPlayer$Command ), this, command);
    }

    public void setUsesWakeLock(Context context) {
        InvokeDynamicSupport.bootstrap("setUsesWakeLock", $$robo$$android_media_AsyncPlayer$setUsesWakeLock(android.content.Context ), this, context);
    }

    private void acquireWakeLock() {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$android_media_AsyncPlayer$acquireWakeLock(), this);
    }

    private void releaseWakeLock() {
        InvokeDynamicSupport.bootstrap("releaseWakeLock", $$robo$$android_media_AsyncPlayer$releaseWakeLock(), this);
    }

    public /* synthetic */ AsyncPlayer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncPlayer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class Thread
    extends java.lang.Thread
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ AsyncPlayer this$0;

        private void $$robo$$android_media_AsyncPlayer_Thread$__constructor__(AsyncPlayer asyncPlayer) {
            this.this$0 = asyncPlayer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AsyncPlayer_Thread$run() {
            while (true) {
                Command cmd = null;
                LinkedList linkedList = this.this$0.mCmdQueue;
                synchronized (linkedList) {
                    cmd = (Command)this.this$0.mCmdQueue.removeFirst();
                }
                switch (cmd.code) {
                    case 1: {
                        this.this$0.startSound(cmd);
                        break;
                    }
                    case 2: {
                        if (this.this$0.mPlayer != null) {
                            long delay = SystemClock.uptimeMillis() - cmd.requestTime;
                            if (delay > 1000L) {
                                Log.w(this.this$0.mTag, "Notification stop delayed by " + delay + "msecs");
                            }
                            this.this$0.mPlayer.stop();
                            this.this$0.mPlayer.release();
                            this.this$0.mPlayer = null;
                            break;
                        }
                        Log.w(this.this$0.mTag, "STOP command without a player");
                    }
                }
                linkedList = this.this$0.mCmdQueue;
                synchronized (linkedList) {
                    if (this.this$0.mCmdQueue.size() == 0) {
                        this.this$0.mThread = null;
                        this.this$0.releaseWakeLock();
                        return;
                    }
                }
            }
        }

        private void __constructor__(AsyncPlayer asyncPlayer) {
            this.$$robo$$android_media_AsyncPlayer_Thread$__constructor__(asyncPlayer);
        }

        public Thread(AsyncPlayer asyncPlayer) {
            super("AsyncPlayer-" + asyncPlayer.mTag);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AsyncPlayer_Thread$__constructor__(android.media.AsyncPlayer ), this, asyncPlayer);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_AsyncPlayer_Thread$run(), this);
        }

        public /* synthetic */ Thread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Thread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class Command
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int code;
        Context context;
        Uri uri;
        boolean looping;
        AudioAttributes attributes;
        long requestTime;

        private void $$robo$$android_media_AsyncPlayer_Command$__constructor__() {
        }

        private final String $$robo$$android_media_AsyncPlayer_Command$toString() {
            return "{ code=" + this.code + " looping=" + this.looping + " attr=" + this.attributes + " uri=" + this.uri + " }";
        }

        private /* synthetic */ void $$robo$$android_media_AsyncPlayer_Command$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_AsyncPlayer_Command$__constructor__();
        }

        public Command() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AsyncPlayer_Command$__constructor__(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_AsyncPlayer_Command$toString(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_media_AsyncPlayer_Command$__constructor__(var1_1);
        }

        public /* synthetic */ Command(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AsyncPlayer_Command$__constructor__(android.media.AsyncPlayer$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Command)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

