/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.IPlayer;
import android.media.PlayerBase;
import android.media.PlayerProxy;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AudioPlaybackConfiguration
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG = false;
    public static int PLAYER_PIID_INVALID = -1;
    public static int PLAYER_PIID_UNASSIGNED = 0;
    public static int PLAYER_UPID_INVALID = -1;
    @SystemApi
    public static int PLAYER_TYPE_UNKNOWN = -1;
    @SystemApi
    public static int PLAYER_TYPE_JAM_AUDIOTRACK = 1;
    @SystemApi
    public static int PLAYER_TYPE_JAM_MEDIAPLAYER = 2;
    @SystemApi
    public static int PLAYER_TYPE_JAM_SOUNDPOOL = 3;
    @SystemApi
    public static int PLAYER_TYPE_SLES_AUDIOPLAYER_BUFFERQUEUE = 11;
    @SystemApi
    public static int PLAYER_TYPE_SLES_AUDIOPLAYER_URI_FD = 12;
    public static int PLAYER_TYPE_AAUDIO = 13;
    public static int PLAYER_TYPE_HW_SOURCE = 14;
    public static int PLAYER_TYPE_EXTERNAL_PROXY = 15;
    @SystemApi
    public static int PLAYER_STATE_UNKNOWN = -1;
    @SystemApi
    public static int PLAYER_STATE_RELEASED = 0;
    @SystemApi
    public static int PLAYER_STATE_IDLE = 1;
    @SystemApi
    public static int PLAYER_STATE_STARTED = 2;
    @SystemApi
    public static int PLAYER_STATE_PAUSED = 3;
    @SystemApi
    public static int PLAYER_STATE_STOPPED = 4;
    private int mPlayerIId;
    private int mPlayerType;
    private int mClientUid;
    private int mClientPid;
    private IPlayerShell mIPlayerShell;
    private int mPlayerState;
    private AudioAttributes mPlayerAttr;
    public static PlayerDeathMonitor sPlayerDeathMonitor;
    public static Parcelable.Creator<AudioPlaybackConfiguration> CREATOR;

    private void $$robo$$android_media_AudioPlaybackConfiguration$__constructor__(int piid) {
        this.mPlayerIId = piid;
        this.mIPlayerShell = null;
    }

    private void $$robo$$android_media_AudioPlaybackConfiguration$__constructor__(PlayerBase.PlayerIdCard pic, int piid, int uid, int pid) {
        this.mPlayerIId = piid;
        this.mPlayerType = pic.mPlayerType;
        this.mClientUid = uid;
        this.mClientPid = pid;
        this.mPlayerState = 1;
        this.mPlayerAttr = pic.mAttributes;
        this.mIPlayerShell = sPlayerDeathMonitor != null && pic.mIPlayer != null ? new IPlayerShell(this, pic.mIPlayer) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioPlaybackConfiguration$init() {
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            if (this.mIPlayerShell != null) {
                this.mIPlayerShell.monitorDeath();
            }
        }
    }

    private static final AudioPlaybackConfiguration $$robo$$android_media_AudioPlaybackConfiguration$anonymizedCopy(AudioPlaybackConfiguration in) {
        AudioPlaybackConfiguration anonymCopy = new AudioPlaybackConfiguration(in.mPlayerIId);
        anonymCopy.mPlayerState = in.mPlayerState;
        anonymCopy.mPlayerAttr = new AudioAttributes.Builder().setUsage(in.mPlayerAttr.getUsage()).setContentType(in.mPlayerAttr.getContentType()).setFlags(in.mPlayerAttr.getFlags()).build();
        anonymCopy.mPlayerType = -1;
        anonymCopy.mClientUid = -1;
        anonymCopy.mClientPid = -1;
        anonymCopy.mIPlayerShell = null;
        return anonymCopy;
    }

    private final AudioAttributes $$robo$$android_media_AudioPlaybackConfiguration$getAudioAttributes() {
        return this.mPlayerAttr;
    }

    @SystemApi
    private final int $$robo$$android_media_AudioPlaybackConfiguration$getClientUid() {
        return this.mClientUid;
    }

    @SystemApi
    private final int $$robo$$android_media_AudioPlaybackConfiguration$getClientPid() {
        return this.mClientPid;
    }

    @SystemApi
    private final int $$robo$$android_media_AudioPlaybackConfiguration$getPlayerType() {
        switch (this.mPlayerType) {
            case 13: 
            case 14: 
            case 15: {
                return -1;
            }
        }
        return this.mPlayerType;
    }

    @SystemApi
    private final int $$robo$$android_media_AudioPlaybackConfiguration$getPlayerState() {
        return this.mPlayerState;
    }

    @SystemApi
    private final int $$robo$$android_media_AudioPlaybackConfiguration$getPlayerInterfaceId() {
        return this.mPlayerIId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final PlayerProxy $$robo$$android_media_AudioPlaybackConfiguration$getPlayerProxy() {
        IPlayerShell ips;
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            ips = this.mIPlayerShell;
        }
        return ips == null ? null : new PlayerProxy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IPlayer $$robo$$android_media_AudioPlaybackConfiguration$getIPlayer() {
        IPlayerShell ips;
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            ips = this.mIPlayerShell;
        }
        return ips == null ? null : ips.getIPlayer();
    }

    private final boolean $$robo$$android_media_AudioPlaybackConfiguration$handleAudioAttributesEvent(AudioAttributes attr2) {
        boolean changed = !attr2.equals(this.mPlayerAttr);
        this.mPlayerAttr = attr2;
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioPlaybackConfiguration$handleStateEvent(int event) {
        boolean changed;
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            changed = this.mPlayerState != event;
            this.mPlayerState = event;
            if (changed && event == 0 && this.mIPlayerShell != null) {
                this.mIPlayerShell.release();
                this.mIPlayerShell = null;
            }
        }
        return changed;
    }

    private final void $$robo$$android_media_AudioPlaybackConfiguration$playerDied() {
        if (sPlayerDeathMonitor != null) {
            sPlayerDeathMonitor.playerDeath(this.mPlayerIId);
        }
    }

    private final boolean $$robo$$android_media_AudioPlaybackConfiguration$isActive() {
        switch (this.mPlayerState) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_media_AudioPlaybackConfiguration$dump(PrintWriter pw) {
        pw.println("  " + AudioPlaybackConfiguration.toLogFriendlyString(this));
    }

    private static final String $$robo$$android_media_AudioPlaybackConfiguration$toLogFriendlyString(AudioPlaybackConfiguration apc) {
        return new String("ID:" + apc.mPlayerIId + " -- type:" + AudioPlaybackConfiguration.toLogFriendlyPlayerType(apc.mPlayerType) + " -- u/pid:" + apc.mClientUid + "/" + apc.mClientPid + " -- state:" + AudioPlaybackConfiguration.toLogFriendlyPlayerState(apc.mPlayerState) + " -- attr:" + apc.mPlayerAttr);
    }

    private final int $$robo$$android_media_AudioPlaybackConfiguration$hashCode() {
        return Objects.hash(this.mPlayerIId, this.mPlayerType, this.mClientUid, this.mClientPid);
    }

    private final int $$robo$$android_media_AudioPlaybackConfiguration$describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioPlaybackConfiguration$writeToParcel(Parcel dest, int flags) {
        IPlayerShell ips;
        dest.writeInt(this.mPlayerIId);
        dest.writeInt(this.mPlayerType);
        dest.writeInt(this.mClientUid);
        dest.writeInt(this.mClientPid);
        dest.writeInt(this.mPlayerState);
        this.mPlayerAttr.writeToParcel(dest, 0);
        AudioPlaybackConfiguration audioPlaybackConfiguration = this;
        synchronized (audioPlaybackConfiguration) {
            ips = this.mIPlayerShell;
        }
        dest.writeStrongInterface(ips == null ? null : ips.getIPlayer());
    }

    private void $$robo$$android_media_AudioPlaybackConfiguration$__constructor__(Parcel in) {
        this.mPlayerIId = in.readInt();
        this.mPlayerType = in.readInt();
        this.mClientUid = in.readInt();
        this.mClientPid = in.readInt();
        this.mPlayerState = in.readInt();
        this.mPlayerAttr = AudioAttributes.CREATOR.createFromParcel(in);
        IPlayer p = IPlayer.Stub.asInterface(in.readStrongBinder());
        this.mIPlayerShell = p == null ? null : new IPlayerShell(null, p);
    }

    private final boolean $$robo$$android_media_AudioPlaybackConfiguration$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AudioPlaybackConfiguration)) {
            return false;
        }
        AudioPlaybackConfiguration that = (AudioPlaybackConfiguration)o;
        return this.mPlayerIId == that.mPlayerIId && this.mPlayerType == that.mPlayerType && this.mClientUid == that.mClientUid && this.mClientPid == that.mClientPid;
    }

    private static final String $$robo$$android_media_AudioPlaybackConfiguration$toLogFriendlyPlayerType(int type) {
        switch (type) {
            case -1: {
                return "unknown";
            }
            case 1: {
                return "android.media.AudioTrack";
            }
            case 2: {
                return "android.media.MediaPlayer";
            }
            case 3: {
                return "android.media.SoundPool";
            }
            case 11: {
                return "OpenSL ES AudioPlayer (Buffer Queue)";
            }
            case 12: {
                return "OpenSL ES AudioPlayer (URI/FD)";
            }
            case 13: {
                return "AAudio";
            }
            case 14: {
                return "hardware source";
            }
            case 15: {
                return "external proxy";
            }
        }
        return "unknown player type " + type + " - FIXME";
    }

    private static final String $$robo$$android_media_AudioPlaybackConfiguration$toLogFriendlyPlayerState(int state) {
        switch (state) {
            case -1: {
                return "unknown";
            }
            case 0: {
                return "released";
            }
            case 1: {
                return "idle";
            }
            case 2: {
                return "started";
            }
            case 3: {
                return "paused";
            }
            case 4: {
                return "stopped";
            }
        }
        return "unknown player state - FIXME";
    }

    private /* synthetic */ void $$robo$$android_media_AudioPlaybackConfiguration$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        TAG = new String("AudioPlaybackConfiguration");
        CREATOR = new Parcelable.Creator<AudioPlaybackConfiguration>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_AudioPlaybackConfiguration_1$__constructor__() {
            }

            private final AudioPlaybackConfiguration $$robo$$android_media_AudioPlaybackConfiguration_1$createFromParcel(Parcel p) {
                return new AudioPlaybackConfiguration(p, null);
            }

            private final AudioPlaybackConfiguration[] $$robo$$android_media_AudioPlaybackConfiguration_1$newArray(int size) {
                return new AudioPlaybackConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_AudioPlaybackConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioPlaybackConfiguration_1$__constructor__(), this);
            }

            @Override
            public AudioPlaybackConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_AudioPlaybackConfiguration_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public AudioPlaybackConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_AudioPlaybackConfiguration_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n) {
        this.$$robo$$android_media_AudioPlaybackConfiguration$__constructor__(n);
    }

    public AudioPlaybackConfiguration(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioPlaybackConfiguration$__constructor__(int ), this, n);
    }

    private void __constructor__(PlayerBase.PlayerIdCard playerIdCard, int n, int n2, int n3) {
        this.$$robo$$android_media_AudioPlaybackConfiguration$__constructor__(playerIdCard, n, n2, n3);
    }

    public AudioPlaybackConfiguration(PlayerBase.PlayerIdCard playerIdCard, int n, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioPlaybackConfiguration$__constructor__(android.media.PlayerBase$PlayerIdCard int int int ), this, playerIdCard, n, n2, n3);
    }

    public void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_media_AudioPlaybackConfiguration$init(), this);
    }

    public static AudioPlaybackConfiguration anonymizedCopy(AudioPlaybackConfiguration audioPlaybackConfiguration) {
        return InvokeDynamicSupport.bootstrapStatic("anonymizedCopy", $$robo$$android_media_AudioPlaybackConfiguration$anonymizedCopy(android.media.AudioPlaybackConfiguration ), (AudioPlaybackConfiguration)audioPlaybackConfiguration);
    }

    public AudioAttributes getAudioAttributes() {
        return InvokeDynamicSupport.bootstrap("getAudioAttributes", $$robo$$android_media_AudioPlaybackConfiguration$getAudioAttributes(), this);
    }

    @SystemApi
    public int getClientUid() {
        return (int)InvokeDynamicSupport.bootstrap("getClientUid", $$robo$$android_media_AudioPlaybackConfiguration$getClientUid(), this);
    }

    @SystemApi
    public int getClientPid() {
        return (int)InvokeDynamicSupport.bootstrap("getClientPid", $$robo$$android_media_AudioPlaybackConfiguration$getClientPid(), this);
    }

    @SystemApi
    public int getPlayerType() {
        return (int)InvokeDynamicSupport.bootstrap("getPlayerType", $$robo$$android_media_AudioPlaybackConfiguration$getPlayerType(), this);
    }

    @SystemApi
    public int getPlayerState() {
        return (int)InvokeDynamicSupport.bootstrap("getPlayerState", $$robo$$android_media_AudioPlaybackConfiguration$getPlayerState(), this);
    }

    @SystemApi
    public int getPlayerInterfaceId() {
        return (int)InvokeDynamicSupport.bootstrap("getPlayerInterfaceId", $$robo$$android_media_AudioPlaybackConfiguration$getPlayerInterfaceId(), this);
    }

    @SystemApi
    public PlayerProxy getPlayerProxy() {
        return InvokeDynamicSupport.bootstrap("getPlayerProxy", $$robo$$android_media_AudioPlaybackConfiguration$getPlayerProxy(), this);
    }

    IPlayer getIPlayer() {
        return InvokeDynamicSupport.bootstrap("getIPlayer", $$robo$$android_media_AudioPlaybackConfiguration$getIPlayer(), this);
    }

    public boolean handleAudioAttributesEvent(AudioAttributes audioAttributes) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleAudioAttributesEvent", $$robo$$android_media_AudioPlaybackConfiguration$handleAudioAttributesEvent(android.media.AudioAttributes ), this, audioAttributes);
    }

    public boolean handleStateEvent(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleStateEvent", $$robo$$android_media_AudioPlaybackConfiguration$handleStateEvent(int ), this, n);
    }

    private void playerDied() {
        InvokeDynamicSupport.bootstrap("playerDied", $$robo$$android_media_AudioPlaybackConfiguration$playerDied(), this);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_media_AudioPlaybackConfiguration$isActive(), this);
    }

    public void dump(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_AudioPlaybackConfiguration$dump(java.io.PrintWriter ), this, printWriter);
    }

    public static String toLogFriendlyString(AudioPlaybackConfiguration audioPlaybackConfiguration) {
        return InvokeDynamicSupport.bootstrapStatic("toLogFriendlyString", $$robo$$android_media_AudioPlaybackConfiguration$toLogFriendlyString(android.media.AudioPlaybackConfiguration ), (AudioPlaybackConfiguration)audioPlaybackConfiguration);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_AudioPlaybackConfiguration$hashCode(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_AudioPlaybackConfiguration$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_AudioPlaybackConfiguration$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_AudioPlaybackConfiguration$__constructor__(parcel);
    }

    public AudioPlaybackConfiguration(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioPlaybackConfiguration$__constructor__(android.os.Parcel ), this, parcel);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_AudioPlaybackConfiguration$equals(java.lang.Object ), this, object);
    }

    public static String toLogFriendlyPlayerType(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toLogFriendlyPlayerType", $$robo$$android_media_AudioPlaybackConfiguration$toLogFriendlyPlayerType(int ), (int)n);
    }

    public static String toLogFriendlyPlayerState(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toLogFriendlyPlayerState", $$robo$$android_media_AudioPlaybackConfiguration$toLogFriendlyPlayerState(int ), (int)n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_AudioPlaybackConfiguration$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ AudioPlaybackConfiguration(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioPlaybackConfiguration$__constructor__(android.os.Parcel android.media.AudioPlaybackConfiguration$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AudioPlaybackConfiguration.class);
    }

    public /* synthetic */ AudioPlaybackConfiguration() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPlaybackConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class IPlayerShell
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        AudioPlaybackConfiguration mMonitor;
        private volatile IPlayer mIPlayer;

        private void $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$__constructor__(AudioPlaybackConfiguration monitor, IPlayer iplayer) {
            this.mMonitor = monitor;
            this.mIPlayer = iplayer;
        }

        private final synchronized void $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$monitorDeath() {
            if (this.mIPlayer == null) {
                return;
            }
            try {
                this.mIPlayer.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                if (this.mMonitor != null) {
                    Log.w(TAG, "Could not link to client death for piid=" + this.mMonitor.mPlayerIId, e);
                }
                Log.w(TAG, "Could not link to client death", e);
            }
        }

        private final IPlayer $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$getIPlayer() {
            return this.mIPlayer;
        }

        private final void $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$binderDied() {
            if (this.mMonitor != null) {
                this.mMonitor.playerDied();
            }
        }

        private final synchronized void $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$release() {
            if (this.mIPlayer == null) {
                return;
            }
            this.mIPlayer.asBinder().unlinkToDeath(this, 0);
            this.mIPlayer = null;
            Binder.flushPendingCommands();
        }

        private void __constructor__(AudioPlaybackConfiguration audioPlaybackConfiguration, IPlayer iPlayer) {
            this.$$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$__constructor__(audioPlaybackConfiguration, iPlayer);
        }

        public IPlayerShell(AudioPlaybackConfiguration audioPlaybackConfiguration, IPlayer iPlayer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$__constructor__(android.media.AudioPlaybackConfiguration android.media.IPlayer ), this, audioPlaybackConfiguration, iPlayer);
        }

        synchronized void monitorDeath() {
            InvokeDynamicSupport.bootstrap("monitorDeath", $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$monitorDeath(), this);
        }

        IPlayer getIPlayer() {
            return InvokeDynamicSupport.bootstrap("getIPlayer", $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$getIPlayer(), this);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$binderDied(), this);
        }

        synchronized void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_AudioPlaybackConfiguration_IPlayerShell$release(), this);
        }

        public /* synthetic */ IPlayerShell() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IPlayerShell)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface PlayerDeathMonitor {
        public void playerDeath(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayerType {
    }
}

