/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.text.style.UpdateAppearance;
import android.util.Log;
import android.view.accessibility.CaptioningManager;
import java.util.ArrayList;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Cea608CCParser
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int MAX_ROWS = 15;
    public static int MAX_COLS = 32;
    private static String TAG = "Cea608CCParser";
    private static boolean DEBUG;
    private static int INVALID = -1;
    private static int RCL = 32;
    private static int BS = 33;
    private static int AOF = 34;
    private static int AON = 35;
    private static int DER = 36;
    private static int RU2 = 37;
    private static int RU3 = 38;
    private static int RU4 = 39;
    private static int FON = 40;
    private static int RDC = 41;
    private static int TR = 42;
    private static int RTD = 43;
    private static int EDM = 44;
    private static int CR = 45;
    private static int ENM = 46;
    private static int EOC = 47;
    private static char TS = '\u00a0';
    private static int MODE_UNKNOWN = 0;
    private static int MODE_PAINT_ON = 1;
    private static int MODE_ROLL_UP = 2;
    private static int MODE_POP_ON = 3;
    private static int MODE_TEXT = 4;
    private DisplayListener mListener;
    private int mMode;
    private int mRollUpSize;
    private int mPrevCtrlCode;
    private CCMemory mDisplay;
    private CCMemory mNonDisplay;
    private CCMemory mTextMem;

    private void $$robo$$android_media_Cea608CCParser$__constructor__(DisplayListener listener) {
        this.mMode = 1;
        this.mRollUpSize = 4;
        this.mPrevCtrlCode = -1;
        this.mDisplay = new CCMemory();
        this.mNonDisplay = new CCMemory();
        this.mTextMem = new CCMemory();
        this.mListener = listener;
    }

    private final void $$robo$$android_media_Cea608CCParser$parse(byte[] data) {
        CCData[] ccData = CCData.fromByteArray(data);
        for (int i = 0; i < ccData.length; ++i) {
            if (DEBUG) {
                Log.d("Cea608CCParser", ccData[i].toString());
            }
            if (this.handleCtrlCode(ccData[i]) || this.handleTabOffsets(ccData[i]) || this.handlePACCode(ccData[i]) || this.handleMidRowCode(ccData[i])) continue;
            this.handleDisplayableChars(ccData[i]);
        }
    }

    private final CCMemory $$robo$$android_media_Cea608CCParser$getMemory() {
        switch (this.mMode) {
            case 3: {
                return this.mNonDisplay;
            }
            case 4: {
                return this.mTextMem;
            }
            case 1: 
            case 2: {
                return this.mDisplay;
            }
        }
        Log.w("Cea608CCParser", "unrecoginized mode: " + this.mMode);
        return this.mDisplay;
    }

    private final boolean $$robo$$android_media_Cea608CCParser$handleDisplayableChars(CCData ccData) {
        if (!ccData.isDisplayableChar()) {
            return false;
        }
        if (ccData.isExtendedChar()) {
            this.getMemory().bs();
        }
        this.getMemory().writeText(ccData.getDisplayText());
        if (this.mMode == 1 || this.mMode == 2) {
            this.updateDisplay();
        }
        return true;
    }

    private final boolean $$robo$$android_media_Cea608CCParser$handleMidRowCode(CCData ccData) {
        StyleCode m = ccData.getMidRow();
        if (m != null) {
            this.getMemory().writeMidRowCode(m);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_media_Cea608CCParser$handlePACCode(CCData ccData) {
        PAC pac = ccData.getPAC();
        if (pac != null) {
            if (this.mMode == 2) {
                this.getMemory().moveBaselineTo(pac.getRow(), this.mRollUpSize);
            }
            this.getMemory().writePAC(pac);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_media_Cea608CCParser$handleTabOffsets(CCData ccData) {
        int tabs = ccData.getTabOffset();
        if (tabs > 0) {
            this.getMemory().tab(tabs);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_media_Cea608CCParser$handleCtrlCode(CCData ccData) {
        int ctrlCode = ccData.getCtrlCode();
        if (this.mPrevCtrlCode != -1 && this.mPrevCtrlCode == ctrlCode) {
            this.mPrevCtrlCode = -1;
            return true;
        }
        switch (ctrlCode) {
            case 32: {
                this.mMode = 3;
                break;
            }
            case 33: {
                this.getMemory().bs();
                break;
            }
            case 36: {
                this.getMemory().der();
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                this.mRollUpSize = ctrlCode - 35;
                if (this.mMode != 2) {
                    this.mDisplay.erase();
                    this.mNonDisplay.erase();
                }
                this.mMode = 2;
                break;
            }
            case 40: {
                Log.i("Cea608CCParser", "Flash On");
                break;
            }
            case 41: {
                this.mMode = 1;
                break;
            }
            case 42: {
                this.mMode = 4;
                this.mTextMem.erase();
                break;
            }
            case 43: {
                this.mMode = 4;
                break;
            }
            case 44: {
                this.mDisplay.erase();
                this.updateDisplay();
                break;
            }
            case 45: {
                if (this.mMode == 2) {
                    this.getMemory().rollUp(this.mRollUpSize);
                } else {
                    this.getMemory().cr();
                }
                if (this.mMode != 2) break;
                this.updateDisplay();
                break;
            }
            case 46: {
                this.mNonDisplay.erase();
                break;
            }
            case 47: {
                this.swapMemory();
                this.mMode = 3;
                this.updateDisplay();
                break;
            }
            default: {
                this.mPrevCtrlCode = -1;
                return false;
            }
        }
        this.mPrevCtrlCode = ctrlCode;
        return true;
    }

    private final void $$robo$$android_media_Cea608CCParser$updateDisplay() {
        if (this.mListener != null) {
            CaptioningManager.CaptionStyle captionStyle = this.mListener.getCaptionStyle();
            this.mListener.onDisplayChanged(this.mDisplay.getStyledText(captionStyle));
        }
    }

    private final void $$robo$$android_media_Cea608CCParser$swapMemory() {
        CCMemory temp = this.mDisplay;
        this.mDisplay = this.mNonDisplay;
        this.mNonDisplay = temp;
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("Cea608CCParser", 3);
    }

    private void __constructor__(DisplayListener displayListener) {
        this.$$robo$$android_media_Cea608CCParser$__constructor__(displayListener);
    }

    public Cea608CCParser(DisplayListener displayListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea608CCParser$__constructor__(android.media.Cea608CCParser$DisplayListener ), this, displayListener);
    }

    public void parse(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_Cea608CCParser$parse(byte[] ), this, byArray);
    }

    private CCMemory getMemory() {
        return InvokeDynamicSupport.bootstrap("getMemory", $$robo$$android_media_Cea608CCParser$getMemory(), this);
    }

    private boolean handleDisplayableChars(CCData cCData) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleDisplayableChars", $$robo$$android_media_Cea608CCParser$handleDisplayableChars(android.media.Cea608CCParser$CCData ), this, cCData);
    }

    private boolean handleMidRowCode(CCData cCData) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMidRowCode", $$robo$$android_media_Cea608CCParser$handleMidRowCode(android.media.Cea608CCParser$CCData ), this, cCData);
    }

    private boolean handlePACCode(CCData cCData) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePACCode", $$robo$$android_media_Cea608CCParser$handlePACCode(android.media.Cea608CCParser$CCData ), this, cCData);
    }

    private boolean handleTabOffsets(CCData cCData) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleTabOffsets", $$robo$$android_media_Cea608CCParser$handleTabOffsets(android.media.Cea608CCParser$CCData ), this, cCData);
    }

    private boolean handleCtrlCode(CCData cCData) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCtrlCode", $$robo$$android_media_Cea608CCParser$handleCtrlCode(android.media.Cea608CCParser$CCData ), this, cCData);
    }

    private void updateDisplay() {
        InvokeDynamicSupport.bootstrap("updateDisplay", $$robo$$android_media_Cea608CCParser$updateDisplay(), this);
    }

    private void swapMemory() {
        InvokeDynamicSupport.bootstrap("swapMemory", $$robo$$android_media_Cea608CCParser$swapMemory(), this);
    }

    static {
        RobolectricInternals.classInitializing(Cea608CCParser.class);
    }

    public /* synthetic */ Cea608CCParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cea608CCParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CCData
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private byte mType;
        private byte mData1;
        private byte mData2;
        private static String[] mCtrlCodeMap;
        private static String[] mSpecialCharMap;
        private static String[] mSpanishCharMap;
        private static String[] mProtugueseCharMap;

        private static final CCData[] $$robo$$android_media_Cea608CCParser_CCData$fromByteArray(byte[] data) {
            CCData[] ccData = new CCData[data.length / 3];
            for (int i = 0; i < ccData.length; ++i) {
                ccData[i] = new CCData(data[i * 3], data[i * 3 + 1], data[i * 3 + 2]);
            }
            return ccData;
        }

        private void $$robo$$android_media_Cea608CCParser_CCData$__constructor__(byte type, byte data1, byte data2) {
            this.mType = type;
            this.mData1 = data1;
            this.mData2 = data2;
        }

        private final int $$robo$$android_media_Cea608CCParser_CCData$getCtrlCode() {
            if ((this.mData1 == 20 || this.mData1 == 28) && this.mData2 >= 32 && this.mData2 <= 47) {
                return this.mData2;
            }
            return -1;
        }

        private final StyleCode $$robo$$android_media_Cea608CCParser_CCData$getMidRow() {
            if ((this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 32 && this.mData2 <= 47) {
                return StyleCode.fromByte(this.mData2);
            }
            return null;
        }

        private final PAC $$robo$$android_media_Cea608CCParser_CCData$getPAC() {
            if ((this.mData1 & 0x70) == 16 && (this.mData2 & 0x40) == 64 && ((this.mData1 & 7) != 0 || (this.mData2 & 0x20) == 0)) {
                return PAC.fromBytes(this.mData1, this.mData2);
            }
            return null;
        }

        private final int $$robo$$android_media_Cea608CCParser_CCData$getTabOffset() {
            if ((this.mData1 == 23 || this.mData1 == 31) && this.mData2 >= 33 && this.mData2 <= 35) {
                return this.mData2 & 3;
            }
            return 0;
        }

        private final boolean $$robo$$android_media_Cea608CCParser_CCData$isDisplayableChar() {
            return this.isBasicChar() || this.isSpecialChar() || this.isExtendedChar();
        }

        private final String $$robo$$android_media_Cea608CCParser_CCData$getDisplayText() {
            String str = this.getBasicChars();
            if (str == null && (str = this.getSpecialChar()) == null) {
                str = this.getExtendedChar();
            }
            return str;
        }

        private final String $$robo$$android_media_Cea608CCParser_CCData$ctrlCodeToString(int ctrlCode) {
            return mCtrlCodeMap[ctrlCode - 32];
        }

        private final boolean $$robo$$android_media_Cea608CCParser_CCData$isBasicChar() {
            return this.mData1 >= 32 && this.mData1 <= 127;
        }

        private final boolean $$robo$$android_media_Cea608CCParser_CCData$isSpecialChar() {
            return (this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 48 && this.mData2 <= 63;
        }

        private final boolean $$robo$$android_media_Cea608CCParser_CCData$isExtendedChar() {
            return (this.mData1 == 18 || this.mData1 == 26 || this.mData1 == 19 || this.mData1 == 27) && this.mData2 >= 32 && this.mData2 <= 63;
        }

        private final char $$robo$$android_media_Cea608CCParser_CCData$getBasicChar(byte data) {
            char c;
            switch (data) {
                case 42: {
                    c = '\u00e1';
                    break;
                }
                case 92: {
                    c = '\u00e9';
                    break;
                }
                case 94: {
                    c = '\u00ed';
                    break;
                }
                case 95: {
                    c = '\u00f3';
                    break;
                }
                case 96: {
                    c = '\u00fa';
                    break;
                }
                case 123: {
                    c = '\u00e7';
                    break;
                }
                case 124: {
                    c = '\u00f7';
                    break;
                }
                case 125: {
                    c = '\u00d1';
                    break;
                }
                case 126: {
                    c = '\u00f1';
                    break;
                }
                case 127: {
                    c = '\u2588';
                    break;
                }
                default: {
                    c = (char)data;
                }
            }
            return c;
        }

        private final String $$robo$$android_media_Cea608CCParser_CCData$getBasicChars() {
            if (this.mData1 >= 32 && this.mData1 <= 127) {
                StringBuilder builder = new StringBuilder(2);
                builder.append(this.getBasicChar(this.mData1));
                if (this.mData2 >= 32 && this.mData2 <= 127) {
                    builder.append(this.getBasicChar(this.mData2));
                }
                return builder.toString();
            }
            return null;
        }

        private final String $$robo$$android_media_Cea608CCParser_CCData$getSpecialChar() {
            if ((this.mData1 == 17 || this.mData1 == 25) && this.mData2 >= 48 && this.mData2 <= 63) {
                return mSpecialCharMap[this.mData2 - 48];
            }
            return null;
        }

        private final String $$robo$$android_media_Cea608CCParser_CCData$getExtendedChar() {
            if ((this.mData1 == 18 || this.mData1 == 26) && this.mData2 >= 32 && this.mData2 <= 63) {
                return mSpanishCharMap[this.mData2 - 32];
            }
            if ((this.mData1 == 19 || this.mData1 == 27) && this.mData2 >= 32 && this.mData2 <= 63) {
                return mProtugueseCharMap[this.mData2 - 32];
            }
            return null;
        }

        private final String $$robo$$android_media_Cea608CCParser_CCData$toString() {
            if (this.mData1 < 16 && this.mData2 < 16) {
                return String.format("[%d]Null: %02x %02x", this.mType, this.mData1, this.mData2);
            }
            int ctrlCode = this.getCtrlCode();
            if (ctrlCode != -1) {
                return String.format("[%d]%s", this.mType, this.ctrlCodeToString(ctrlCode));
            }
            int tabOffset = this.getTabOffset();
            if (tabOffset > 0) {
                return String.format("[%d]Tab%d", this.mType, tabOffset);
            }
            PAC pac = this.getPAC();
            if (pac != null) {
                return String.format("[%d]PAC: %s", this.mType, pac.toString());
            }
            StyleCode m = this.getMidRow();
            if (m != null) {
                return String.format("[%d]Mid-row: %s", this.mType, m.toString());
            }
            if (this.isDisplayableChar()) {
                return String.format("[%d]Displayable: %s (%02x %02x)", this.mType, this.getDisplayText(), this.mData1, this.mData2);
            }
            return String.format("[%d]Invalid: %02x %02x", this.mType, this.mData1, this.mData2);
        }

        static void __staticInitializer__() {
            mCtrlCodeMap = new String[]{"RCL", "BS", "AOF", "AON", "DER", "RU2", "RU3", "RU4", "FON", "RDC", "TR", "RTD", "EDM", "CR", "ENM", "EOC"};
            mSpecialCharMap = new String[]{"\u00ae", "\u00b0", "\u00bd", "\u00bf", "\u2122", "\u00a2", "\u00a3", "\u266a", "\u00e0", "\u00a0", "\u00e8", "\u00e2", "\u00ea", "\u00ee", "\u00f4", "\u00fb"};
            mSpanishCharMap = new String[]{"\u00c1", "\u00c9", "\u00d3", "\u00da", "\u00dc", "\u00fc", "\u2018", "\u00a1", "*", "'", "\u2014", "\u00a9", "\u2120", "\u2022", "\u201c", "\u201d", "\u00c0", "\u00c2", "\u00c7", "\u00c8", "\u00ca", "\u00cb", "\u00eb", "\u00ce", "\u00cf", "\u00ef", "\u00d4", "\u00d9", "\u00f9", "\u00db", "\u00ab", "\u00bb"};
            mProtugueseCharMap = new String[]{"\u00c3", "\u00e3", "\u00cd", "\u00cc", "\u00ec", "\u00d2", "\u00f2", "\u00d5", "\u00f5", "{", "}", "\\", "^", "_", "|", "~", "\u00c4", "\u00e4", "\u00d6", "\u00f6", "\u00df", "\u00a5", "\u00a4", "\u2502", "\u00c5", "\u00e5", "\u00d8", "\u00f8", "\u250c", "\u2510", "\u2514", "\u2518"};
        }

        static CCData[] fromByteArray(byte[] byArray) {
            return InvokeDynamicSupport.bootstrapStatic("fromByteArray", $$robo$$android_media_Cea608CCParser_CCData$fromByteArray(byte[] ), (byte[])byArray);
        }

        private void __constructor__(byte by, byte by2, byte by3) {
            this.$$robo$$android_media_Cea608CCParser_CCData$__constructor__(by, by2, by3);
        }

        public CCData(byte by, byte by2, byte by3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea608CCParser_CCData$__constructor__(byte byte byte ), this, by, by2, by3);
        }

        int getCtrlCode() {
            return (int)InvokeDynamicSupport.bootstrap("getCtrlCode", $$robo$$android_media_Cea608CCParser_CCData$getCtrlCode(), this);
        }

        StyleCode getMidRow() {
            return InvokeDynamicSupport.bootstrap("getMidRow", $$robo$$android_media_Cea608CCParser_CCData$getMidRow(), this);
        }

        PAC getPAC() {
            return InvokeDynamicSupport.bootstrap("getPAC", $$robo$$android_media_Cea608CCParser_CCData$getPAC(), this);
        }

        int getTabOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getTabOffset", $$robo$$android_media_Cea608CCParser_CCData$getTabOffset(), this);
        }

        boolean isDisplayableChar() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDisplayableChar", $$robo$$android_media_Cea608CCParser_CCData$isDisplayableChar(), this);
        }

        String getDisplayText() {
            return InvokeDynamicSupport.bootstrap("getDisplayText", $$robo$$android_media_Cea608CCParser_CCData$getDisplayText(), this);
        }

        private String ctrlCodeToString(int n) {
            return InvokeDynamicSupport.bootstrap("ctrlCodeToString", $$robo$$android_media_Cea608CCParser_CCData$ctrlCodeToString(int ), this, n);
        }

        private boolean isBasicChar() {
            return (boolean)InvokeDynamicSupport.bootstrap("isBasicChar", $$robo$$android_media_Cea608CCParser_CCData$isBasicChar(), this);
        }

        private boolean isSpecialChar() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSpecialChar", $$robo$$android_media_Cea608CCParser_CCData$isSpecialChar(), this);
        }

        private boolean isExtendedChar() {
            return (boolean)InvokeDynamicSupport.bootstrap("isExtendedChar", $$robo$$android_media_Cea608CCParser_CCData$isExtendedChar(), this);
        }

        private char getBasicChar(byte by) {
            return (char)InvokeDynamicSupport.bootstrap("getBasicChar", $$robo$$android_media_Cea608CCParser_CCData$getBasicChar(byte ), this, by);
        }

        private String getBasicChars() {
            return InvokeDynamicSupport.bootstrap("getBasicChars", $$robo$$android_media_Cea608CCParser_CCData$getBasicChars(), this);
        }

        private String getSpecialChar() {
            return InvokeDynamicSupport.bootstrap("getSpecialChar", $$robo$$android_media_Cea608CCParser_CCData$getSpecialChar(), this);
        }

        private String getExtendedChar() {
            return InvokeDynamicSupport.bootstrap("getExtendedChar", $$robo$$android_media_Cea608CCParser_CCData$getExtendedChar(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_Cea608CCParser_CCData$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(CCData.class);
        }

        public /* synthetic */ CCData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CCData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CCMemory
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mBlankLine;
        private CCLineBuilder[] mLines;
        private int mRow;
        private int mCol;

        private void $$robo$$android_media_Cea608CCParser_CCMemory$__constructor__() {
            this.mLines = new CCLineBuilder[17];
            char[] blank = new char[34];
            Arrays.fill(blank, '\u00a0');
            this.mBlankLine = new String(blank);
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$erase() {
            for (int i = 0; i < this.mLines.length; ++i) {
                this.mLines[i] = null;
            }
            this.mRow = 15;
            this.mCol = 1;
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$der() {
            if (this.mLines[this.mRow] != null) {
                for (int i = 0; i < this.mCol; ++i) {
                    if (this.mLines[this.mRow].charAt(i) == '\u00a0') continue;
                    for (int j = this.mCol; j < this.mLines[this.mRow].length(); ++j) {
                        this.mLines[j].setCharAt(j, '\u00a0');
                    }
                    return;
                }
                this.mLines[this.mRow] = null;
            }
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$tab(int tabs) {
            this.moveCursorByCol(tabs);
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$bs() {
            this.moveCursorByCol(-1);
            if (this.mLines[this.mRow] != null) {
                this.mLines[this.mRow].setCharAt(this.mCol, '\u00a0');
                if (this.mCol == 31) {
                    this.mLines[this.mRow].setCharAt(32, '\u00a0');
                }
            }
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$cr() {
            this.moveCursorTo(this.mRow + 1, 1);
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$rollUp(int windowSize) {
            int i;
            for (i = 0; i <= this.mRow - windowSize; ++i) {
                this.mLines[i] = null;
            }
            int startRow = this.mRow - windowSize + 1;
            if (startRow < 1) {
                startRow = 1;
            }
            for (i = startRow; i < this.mRow; ++i) {
                this.mLines[i] = this.mLines[i + 1];
            }
            for (i = this.mRow; i < this.mLines.length; ++i) {
                this.mLines[i] = null;
            }
            this.mCol = 1;
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$writeText(String text) {
            for (int i = 0; i < text.length(); ++i) {
                this.getLineBuffer(this.mRow).setCharAt(this.mCol, text.charAt(i));
                this.moveCursorByCol(1);
            }
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$writeMidRowCode(StyleCode m) {
            this.getLineBuffer(this.mRow).setMidRowAt(this.mCol, m);
            this.moveCursorByCol(1);
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$writePAC(PAC pac) {
            if (pac.isIndentPAC()) {
                this.moveCursorTo(pac.getRow(), pac.getCol());
            } else {
                this.moveCursorTo(pac.getRow(), 1);
            }
            this.getLineBuffer(this.mRow).setPACAt(this.mCol, pac);
        }

        private final SpannableStringBuilder[] $$robo$$android_media_Cea608CCParser_CCMemory$getStyledText(CaptioningManager.CaptionStyle captionStyle) {
            ArrayList<SpannableStringBuilder> rows = new ArrayList<SpannableStringBuilder>(15);
            for (int i = 1; i <= 15; ++i) {
                rows.add(this.mLines[i] != null ? this.mLines[i].getStyledText(captionStyle) : null);
            }
            return rows.toArray(new SpannableStringBuilder[15]);
        }

        private static final int $$robo$$android_media_Cea608CCParser_CCMemory$clamp(int x, int min, int max) {
            return x < min ? min : (x > max ? max : x);
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$moveCursorTo(int row, int col) {
            this.mRow = CCMemory.clamp(row, 1, 15);
            this.mCol = CCMemory.clamp(col, 1, 32);
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$moveCursorToRow(int row) {
            this.mRow = CCMemory.clamp(row, 1, 15);
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$moveCursorByCol(int col) {
            this.mCol = CCMemory.clamp(this.mCol + col, 1, 32);
        }

        private final void $$robo$$android_media_Cea608CCParser_CCMemory$moveBaselineTo(int baseRow, int windowSize) {
            int i;
            if (this.mRow == baseRow) {
                return;
            }
            int actualWindowSize = windowSize;
            if (baseRow < actualWindowSize) {
                actualWindowSize = baseRow;
            }
            if (this.mRow < actualWindowSize) {
                actualWindowSize = this.mRow;
            }
            if (baseRow < this.mRow) {
                for (i = actualWindowSize - 1; i >= 0; --i) {
                    this.mLines[baseRow - i] = this.mLines[this.mRow - i];
                }
            } else {
                for (i = 0; i < actualWindowSize; ++i) {
                    this.mLines[baseRow - i] = this.mLines[this.mRow - i];
                }
            }
            for (i = 0; i <= baseRow - windowSize; ++i) {
                this.mLines[i] = null;
            }
            for (i = baseRow + 1; i < this.mLines.length; ++i) {
                this.mLines[i] = null;
            }
        }

        private final CCLineBuilder $$robo$$android_media_Cea608CCParser_CCMemory$getLineBuffer(int row) {
            if (this.mLines[row] == null) {
                this.mLines[row] = new CCLineBuilder(this.mBlankLine);
            }
            return this.mLines[row];
        }

        private void __constructor__() {
            this.$$robo$$android_media_Cea608CCParser_CCMemory$__constructor__();
        }

        public CCMemory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea608CCParser_CCMemory$__constructor__(), this);
        }

        void erase() {
            InvokeDynamicSupport.bootstrap("erase", $$robo$$android_media_Cea608CCParser_CCMemory$erase(), this);
        }

        void der() {
            InvokeDynamicSupport.bootstrap("der", $$robo$$android_media_Cea608CCParser_CCMemory$der(), this);
        }

        void tab(int n) {
            InvokeDynamicSupport.bootstrap("tab", $$robo$$android_media_Cea608CCParser_CCMemory$tab(int ), this, n);
        }

        void bs() {
            InvokeDynamicSupport.bootstrap("bs", $$robo$$android_media_Cea608CCParser_CCMemory$bs(), this);
        }

        void cr() {
            InvokeDynamicSupport.bootstrap("cr", $$robo$$android_media_Cea608CCParser_CCMemory$cr(), this);
        }

        void rollUp(int n) {
            InvokeDynamicSupport.bootstrap("rollUp", $$robo$$android_media_Cea608CCParser_CCMemory$rollUp(int ), this, n);
        }

        void writeText(String string2) {
            InvokeDynamicSupport.bootstrap("writeText", $$robo$$android_media_Cea608CCParser_CCMemory$writeText(java.lang.String ), this, string2);
        }

        void writeMidRowCode(StyleCode styleCode) {
            InvokeDynamicSupport.bootstrap("writeMidRowCode", $$robo$$android_media_Cea608CCParser_CCMemory$writeMidRowCode(android.media.Cea608CCParser$StyleCode ), this, styleCode);
        }

        void writePAC(PAC pAC) {
            InvokeDynamicSupport.bootstrap("writePAC", $$robo$$android_media_Cea608CCParser_CCMemory$writePAC(android.media.Cea608CCParser$PAC ), this, pAC);
        }

        SpannableStringBuilder[] getStyledText(CaptioningManager.CaptionStyle captionStyle) {
            return InvokeDynamicSupport.bootstrap("getStyledText", $$robo$$android_media_Cea608CCParser_CCMemory$getStyledText(android.view.accessibility.CaptioningManager$CaptionStyle ), this, captionStyle);
        }

        private static int clamp(int n, int n2, int n3) {
            return (int)InvokeDynamicSupport.bootstrapStatic("clamp", $$robo$$android_media_Cea608CCParser_CCMemory$clamp(int int int ), (int)n, (int)n2, (int)n3);
        }

        private void moveCursorTo(int n, int n2) {
            InvokeDynamicSupport.bootstrap("moveCursorTo", $$robo$$android_media_Cea608CCParser_CCMemory$moveCursorTo(int int ), this, n, n2);
        }

        private void moveCursorToRow(int n) {
            InvokeDynamicSupport.bootstrap("moveCursorToRow", $$robo$$android_media_Cea608CCParser_CCMemory$moveCursorToRow(int ), this, n);
        }

        private void moveCursorByCol(int n) {
            InvokeDynamicSupport.bootstrap("moveCursorByCol", $$robo$$android_media_Cea608CCParser_CCMemory$moveCursorByCol(int ), this, n);
        }

        private void moveBaselineTo(int n, int n2) {
            InvokeDynamicSupport.bootstrap("moveBaselineTo", $$robo$$android_media_Cea608CCParser_CCMemory$moveBaselineTo(int int ), this, n, n2);
        }

        private CCLineBuilder getLineBuffer(int n) {
            return InvokeDynamicSupport.bootstrap("getLineBuffer", $$robo$$android_media_Cea608CCParser_CCMemory$getLineBuffer(int ), this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CCMemory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CCLineBuilder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private StringBuilder mDisplayChars;
        private StyleCode[] mMidRowStyles;
        private StyleCode[] mPACStyles;

        private void $$robo$$android_media_Cea608CCParser_CCLineBuilder$__constructor__(String str) {
            this.mDisplayChars = new StringBuilder(str);
            this.mMidRowStyles = new StyleCode[this.mDisplayChars.length()];
            this.mPACStyles = new StyleCode[this.mDisplayChars.length()];
        }

        private final void $$robo$$android_media_Cea608CCParser_CCLineBuilder$setCharAt(int index, char ch) {
            this.mDisplayChars.setCharAt(index, ch);
            this.mMidRowStyles[index] = null;
        }

        private final void $$robo$$android_media_Cea608CCParser_CCLineBuilder$setMidRowAt(int index, StyleCode m) {
            this.mDisplayChars.setCharAt(index, ' ');
            this.mMidRowStyles[index] = m;
        }

        private final void $$robo$$android_media_Cea608CCParser_CCLineBuilder$setPACAt(int index, PAC pac) {
            this.mPACStyles[index] = pac;
        }

        private final char $$robo$$android_media_Cea608CCParser_CCLineBuilder$charAt(int index) {
            return this.mDisplayChars.charAt(index);
        }

        private final int $$robo$$android_media_Cea608CCParser_CCLineBuilder$length() {
            return this.mDisplayChars.length();
        }

        private final void $$robo$$android_media_Cea608CCParser_CCLineBuilder$applyStyleSpan(SpannableStringBuilder styledText, StyleCode s, int start, int end) {
            if (s.isItalics()) {
                styledText.setSpan(new StyleSpan(2), start, end, 33);
            }
            if (s.isUnderline()) {
                styledText.setSpan(new UnderlineSpan(), start, end, 33);
            }
        }

        private final SpannableStringBuilder $$robo$$android_media_Cea608CCParser_CCLineBuilder$getStyledText(CaptioningManager.CaptionStyle captionStyle) {
            SpannableStringBuilder styledText = new SpannableStringBuilder(this.mDisplayChars);
            int start = -1;
            int styleStart = -1;
            StyleCode curStyle = null;
            for (int next = 0; next < this.mDisplayChars.length(); ++next) {
                StyleCode newStyle = null;
                if (this.mMidRowStyles[next] != null) {
                    newStyle = this.mMidRowStyles[next];
                } else if (this.mPACStyles[next] != null && (styleStart < 0 || start < 0)) {
                    newStyle = this.mPACStyles[next];
                }
                if (newStyle != null) {
                    curStyle = newStyle;
                    if (styleStart >= 0 && start >= 0) {
                        this.applyStyleSpan(styledText, newStyle, styleStart, next);
                    }
                    styleStart = next;
                }
                if (this.mDisplayChars.charAt(next) != '\u00a0') {
                    if (start >= 0) continue;
                    start = next;
                    continue;
                }
                if (start < 0) continue;
                int expandedStart = this.mDisplayChars.charAt(start) == ' ' ? start : start - 1;
                int expandedEnd = this.mDisplayChars.charAt(next - 1) == ' ' ? next : next + 1;
                styledText.setSpan(new MutableBackgroundColorSpan(captionStyle.backgroundColor), expandedStart, expandedEnd, 33);
                if (styleStart >= 0) {
                    this.applyStyleSpan(styledText, curStyle, styleStart, expandedEnd);
                }
                start = -1;
            }
            return styledText;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_Cea608CCParser_CCLineBuilder$__constructor__(string2);
        }

        public CCLineBuilder(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea608CCParser_CCLineBuilder$__constructor__(java.lang.String ), this, string2);
        }

        void setCharAt(int n, char c) {
            InvokeDynamicSupport.bootstrap("setCharAt", $$robo$$android_media_Cea608CCParser_CCLineBuilder$setCharAt(int char ), this, n, c);
        }

        void setMidRowAt(int n, StyleCode styleCode) {
            InvokeDynamicSupport.bootstrap("setMidRowAt", $$robo$$android_media_Cea608CCParser_CCLineBuilder$setMidRowAt(int android.media.Cea608CCParser$StyleCode ), this, n, styleCode);
        }

        void setPACAt(int n, PAC pAC) {
            InvokeDynamicSupport.bootstrap("setPACAt", $$robo$$android_media_Cea608CCParser_CCLineBuilder$setPACAt(int android.media.Cea608CCParser$PAC ), this, n, pAC);
        }

        char charAt(int n) {
            return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_media_Cea608CCParser_CCLineBuilder$charAt(int ), this, n);
        }

        int length() {
            return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_media_Cea608CCParser_CCLineBuilder$length(), this);
        }

        void applyStyleSpan(SpannableStringBuilder spannableStringBuilder, StyleCode styleCode, int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyStyleSpan", $$robo$$android_media_Cea608CCParser_CCLineBuilder$applyStyleSpan(android.text.SpannableStringBuilder android.media.Cea608CCParser$StyleCode int int ), this, spannableStringBuilder, styleCode, n, n2);
        }

        SpannableStringBuilder getStyledText(CaptioningManager.CaptionStyle captionStyle) {
            return InvokeDynamicSupport.bootstrap("getStyledText", $$robo$$android_media_Cea608CCParser_CCLineBuilder$getStyledText(android.view.accessibility.CaptioningManager$CaptionStyle ), this, captionStyle);
        }

        public /* synthetic */ CCLineBuilder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CCLineBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MutableBackgroundColorSpan
    extends CharacterStyle
    implements UpdateAppearance,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mColor;

        private void $$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$__constructor__(int color2) {
            this.mColor = color2;
        }

        private final void $$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$setBackgroundColor(int color2) {
            this.mColor = color2;
        }

        private final int $$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$getBackgroundColor() {
            return this.mColor;
        }

        private final void $$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$updateDrawState(TextPaint ds) {
            ds.bgColor = this.mColor;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$__constructor__(n);
        }

        public MutableBackgroundColorSpan(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$__constructor__(int ), this, n);
        }

        public void setBackgroundColor(int n) {
            InvokeDynamicSupport.bootstrap("setBackgroundColor", $$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$setBackgroundColor(int ), this, n);
        }

        public int getBackgroundColor() {
            return (int)InvokeDynamicSupport.bootstrap("getBackgroundColor", $$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$getBackgroundColor(), this);
        }

        @Override
        public void updateDrawState(TextPaint textPaint) {
            InvokeDynamicSupport.bootstrap("updateDrawState", $$robo$$android_media_Cea608CCParser_MutableBackgroundColorSpan$updateDrawState(android.text.TextPaint ), this, textPaint);
        }

        public /* synthetic */ MutableBackgroundColorSpan() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MutableBackgroundColorSpan)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class PAC
    extends StyleCode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mRow;
        int mCol;

        private static final PAC $$robo$$android_media_Cea608CCParser_PAC$fromBytes(byte data1, byte data2) {
            int[] rowTable = new int[]{11, 1, 3, 12, 14, 5, 7, 9};
            int row = rowTable[data1 & 7] + ((data2 & 0x20) >> 5);
            int style2 = 0;
            if ((data2 & 1) != 0) {
                style2 |= 2;
            }
            if ((data2 & 0x10) != 0) {
                int indent = data2 >> 1 & 7;
                return new PAC(row, indent * 4, style2, 0);
            }
            int color2 = data2 >> 1 & 7;
            if (color2 == 7) {
                color2 = 0;
                style2 |= 1;
            }
            return new PAC(row, -1, style2, color2);
        }

        private void $$robo$$android_media_Cea608CCParser_PAC$__constructor__(int row, int col, int style2, int color2) {
            this.mRow = row;
            this.mCol = col;
        }

        private final boolean $$robo$$android_media_Cea608CCParser_PAC$isIndentPAC() {
            return this.mCol >= 0;
        }

        private final int $$robo$$android_media_Cea608CCParser_PAC$getRow() {
            return this.mRow;
        }

        private final int $$robo$$android_media_Cea608CCParser_PAC$getCol() {
            return this.mCol;
        }

        private final String $$robo$$android_media_Cea608CCParser_PAC$toString() {
            return String.format("{%d, %d}, %s", this.mRow, this.mCol, super.toString());
        }

        static PAC fromBytes(byte by, byte by2) {
            return InvokeDynamicSupport.bootstrapStatic("fromBytes", $$robo$$android_media_Cea608CCParser_PAC$fromBytes(byte byte ), (byte)by, (byte)by2);
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_media_Cea608CCParser_PAC$__constructor__(n, n2, n3, n4);
        }

        public PAC(int n, int n2, int n3, int n4) {
            super(n3, n4);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea608CCParser_PAC$__constructor__(int int int int ), this, n, n2, n3, n4);
        }

        boolean isIndentPAC() {
            return (boolean)InvokeDynamicSupport.bootstrap("isIndentPAC", $$robo$$android_media_Cea608CCParser_PAC$isIndentPAC(), this);
        }

        int getRow() {
            return (int)InvokeDynamicSupport.bootstrap("getRow", $$robo$$android_media_Cea608CCParser_PAC$getRow(), this);
        }

        int getCol() {
            return (int)InvokeDynamicSupport.bootstrap("getCol", $$robo$$android_media_Cea608CCParser_PAC$getCol(), this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_Cea608CCParser_PAC$toString(), this);
        }

        public /* synthetic */ PAC() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PAC)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StyleCode
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        static int COLOR_WHITE = 0;
        static int COLOR_GREEN = 1;
        static int COLOR_BLUE = 2;
        static int COLOR_CYAN = 3;
        static int COLOR_RED = 4;
        static int COLOR_YELLOW = 5;
        static int COLOR_MAGENTA = 6;
        static int COLOR_INVALID = 7;
        static int STYLE_ITALICS = 1;
        static int STYLE_UNDERLINE = 2;
        static String[] mColorMap;
        int mStyle;
        int mColor;

        private static final StyleCode $$robo$$android_media_Cea608CCParser_StyleCode$fromByte(byte data2) {
            int style2 = 0;
            int color2 = data2 >> 1 & 7;
            if ((data2 & 1) != 0) {
                style2 |= 2;
            }
            if (color2 == 7) {
                color2 = 0;
                style2 |= 1;
            }
            return new StyleCode(style2, color2);
        }

        private void $$robo$$android_media_Cea608CCParser_StyleCode$__constructor__(int style2, int color2) {
            this.mStyle = style2;
            this.mColor = color2;
        }

        private final boolean $$robo$$android_media_Cea608CCParser_StyleCode$isItalics() {
            return (this.mStyle & 1) != 0;
        }

        private final boolean $$robo$$android_media_Cea608CCParser_StyleCode$isUnderline() {
            return (this.mStyle & 2) != 0;
        }

        private final int $$robo$$android_media_Cea608CCParser_StyleCode$getColor() {
            return this.mColor;
        }

        private final String $$robo$$android_media_Cea608CCParser_StyleCode$toString() {
            StringBuilder str = new StringBuilder();
            str.append("{");
            str.append(mColorMap[this.mColor]);
            if ((this.mStyle & 1) != 0) {
                str.append(", ITALICS");
            }
            if ((this.mStyle & 2) != 0) {
                str.append(", UNDERLINE");
            }
            str.append("}");
            return str.toString();
        }

        static void __staticInitializer__() {
            mColorMap = new String[]{"WHITE", "GREEN", "BLUE", "CYAN", "RED", "YELLOW", "MAGENTA", "INVALID"};
        }

        static StyleCode fromByte(byte by) {
            return InvokeDynamicSupport.bootstrapStatic("fromByte", $$robo$$android_media_Cea608CCParser_StyleCode$fromByte(byte ), (byte)by);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_media_Cea608CCParser_StyleCode$__constructor__(n, n2);
        }

        public StyleCode(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Cea608CCParser_StyleCode$__constructor__(int int ), this, n, n2);
        }

        boolean isItalics() {
            return (boolean)InvokeDynamicSupport.bootstrap("isItalics", $$robo$$android_media_Cea608CCParser_StyleCode$isItalics(), this);
        }

        boolean isUnderline() {
            return (boolean)InvokeDynamicSupport.bootstrap("isUnderline", $$robo$$android_media_Cea608CCParser_StyleCode$isUnderline(), this);
        }

        int getColor() {
            return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_media_Cea608CCParser_StyleCode$getColor(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_Cea608CCParser_StyleCode$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(StyleCode.class);
        }

        public /* synthetic */ StyleCode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StyleCode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface DisplayListener {
        public void onDisplayChanged(SpannableStringBuilder[] var1);

        public CaptioningManager.CaptionStyle getCaptionStyle();
    }
}

