/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.hardware.HardwareBuffer;
import android.media.Image;
import android.media.ImageUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImageReader
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int ACQUIRE_SUCCESS = 0;
    private static int ACQUIRE_NO_BUFS = 1;
    private static int ACQUIRE_MAX_IMAGES = 2;
    private static long BUFFER_USAGE_UNKNOWN = 0L;
    private int mWidth;
    private int mHeight;
    private int mFormat;
    private int mMaxImages;
    private int mNumPlanes;
    private Surface mSurface;
    private int mEstimatedNativeAllocBytes;
    private Object mListenerLock;
    private Object mCloseLock;
    private boolean mIsReaderValid;
    private OnImageAvailableListener mListener;
    private ListenerHandler mListenerHandler;
    private List<Image> mAcquiredImages;
    private long mNativeContext;

    private static final ImageReader $$robo$$android_media_ImageReader$newInstance(int width, int height, int format, int maxImages) {
        return new ImageReader(width, height, format, maxImages, 0L);
    }

    private static final ImageReader $$robo$$android_media_ImageReader$newInstance(int width, int height, int format, int maxImages, long usage) {
        if (!ImageReader.isFormatUsageCombinationAllowed(format, usage)) {
            throw new IllegalArgumentException("Format usage combination is not supported: format = " + format + ", usage = " + usage);
        }
        return new ImageReader(width, height, format, maxImages, usage);
    }

    private void $$robo$$android_media_ImageReader$__constructor__(int width, int height, int format, int maxImages, long usage) {
        this.mListenerLock = new Object();
        this.mCloseLock = new Object();
        this.mIsReaderValid = false;
        this.mAcquiredImages = new CopyOnWriteArrayList<Image>();
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mMaxImages = maxImages;
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The image dimensions must be positive");
        }
        if (this.mMaxImages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        if (format == 17) {
            throw new IllegalArgumentException("NV21 format is not supported");
        }
        this.mNumPlanes = ImageUtils.getNumPlanesForFormat(this.mFormat);
        this.nativeInit(new WeakReference<ImageReader>(this), width, height, format, maxImages, usage);
        this.mSurface = this.nativeGetSurface();
        this.mIsReaderValid = true;
        this.mEstimatedNativeAllocBytes = ImageUtils.getEstimatedNativeAllocBytes(width, height, format, 1);
        VMRuntime.getRuntime().registerNativeAllocation(this.mEstimatedNativeAllocBytes);
    }

    private final int $$robo$$android_media_ImageReader$getWidth() {
        return this.mWidth;
    }

    private final int $$robo$$android_media_ImageReader$getHeight() {
        return this.mHeight;
    }

    private final int $$robo$$android_media_ImageReader$getImageFormat() {
        return this.mFormat;
    }

    private final int $$robo$$android_media_ImageReader$getMaxImages() {
        return this.mMaxImages;
    }

    private final Surface $$robo$$android_media_ImageReader$getSurface() {
        return this.mSurface;
    }

    private final Image $$robo$$android_media_ImageReader$acquireLatestImage() {
        Image image = this.acquireNextImage();
        if (image == null) {
            return null;
        }
        try {
            while (true) {
                Image next;
                if ((next = this.acquireNextImageNoThrowISE()) == null) {
                    Image result = image;
                    image = null;
                    Image image2 = result;
                    return image2;
                }
                image.close();
                image = next;
            }
        }
        finally {
            if (image != null) {
                image.close();
            }
        }
    }

    private final Image $$robo$$android_media_ImageReader$acquireNextImageNoThrowISE() {
        SurfaceImage si = new SurfaceImage(this, this.mFormat);
        return this.acquireNextSurfaceImage(si) == 0 ? si : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_ImageReader$acquireNextSurfaceImage(SurfaceImage si) {
        Object object = this.mCloseLock;
        synchronized (object) {
            int status = 1;
            if (this.mIsReaderValid) {
                status = this.nativeImageSetup(si);
            }
            switch (status) {
                case 0: {
                    si.mIsImageValid = true;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
                }
            }
            if (status == 0) {
                this.mAcquiredImages.add(si);
            }
            return status;
        }
    }

    private final Image $$robo$$android_media_ImageReader$acquireNextImage() {
        SurfaceImage si = new SurfaceImage(this, this.mFormat);
        int status = this.acquireNextSurfaceImage(si);
        switch (status) {
            case 0: {
                return si;
            }
            case 1: {
                return null;
            }
            case 2: {
                throw new IllegalStateException(String.format("maxImages (%d) has already been acquired, call #close before acquiring more.", this.mMaxImages));
            }
        }
        throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
    }

    private final void $$robo$$android_media_ImageReader$releaseImage(Image i) {
        if (!(i instanceof SurfaceImage)) {
            throw new IllegalArgumentException("This image was not produced by an ImageReader");
        }
        SurfaceImage si = (SurfaceImage)i;
        if (!si.mIsImageValid) {
            return;
        }
        if (si.getReader() != this || !this.mAcquiredImages.contains(i)) {
            throw new IllegalArgumentException("This image was not produced by this ImageReader");
        }
        si.clearSurfacePlanes();
        this.nativeReleaseImage(i);
        si.mIsImageValid = false;
        this.mAcquiredImages.remove(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ImageReader$setOnImageAvailableListener(OnImageAvailableListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (listener != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(this, looper);
                }
                this.mListener = listener;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ImageReader$close() {
        this.setOnImageAvailableListener(null, null);
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        Object object = this.mCloseLock;
        synchronized (object) {
            this.mIsReaderValid = false;
            for (Image image : this.mAcquiredImages) {
                image.close();
            }
            this.mAcquiredImages.clear();
            this.nativeClose();
            if (this.mEstimatedNativeAllocBytes > 0) {
                VMRuntime.getRuntime().registerNativeFree(this.mEstimatedNativeAllocBytes);
                this.mEstimatedNativeAllocBytes = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ImageReader$discardFreeBuffers() {
        Object object = this.mCloseLock;
        synchronized (object) {
            this.nativeDiscardFreeBuffers();
        }
    }

    private final void $$robo$$android_media_ImageReader$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_media_ImageReader$detachImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("input image must not be null");
        }
        if (!this.isImageOwnedbyMe(image)) {
            throw new IllegalArgumentException("Trying to detach an image that is not owned by this ImageReader");
        }
        SurfaceImage si = (SurfaceImage)image;
        si.throwISEIfImageIsInvalid();
        if (si.isAttachable()) {
            throw new IllegalStateException("Image was already detached from this ImageReader");
        }
        this.nativeDetachImage(image);
        si.clearSurfacePlanes();
        SurfaceImage.access$102(si, null);
        si.setDetached(true);
    }

    private final boolean $$robo$$android_media_ImageReader$isImageOwnedbyMe(Image image) {
        if (!(image instanceof SurfaceImage)) {
            return false;
        }
        SurfaceImage si = (SurfaceImage)image;
        return si.getReader() == this;
    }

    private static final boolean $$robo$$android_media_ImageReader$isFormatUsageCombinationAllowed(int format, long usage) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            return false;
        }
        return usage != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_ImageReader$postEventFromNative(Object selfRef) {
        ListenerHandler handler;
        WeakReference weakSelf = (WeakReference)selfRef;
        ImageReader ir = (ImageReader)weakSelf.get();
        if (ir == null) {
            return;
        }
        Object object = ir.mListenerLock;
        synchronized (object) {
            handler = ir.mListenerHandler;
        }
        if (handler != null) {
            handler.sendEmptyMessage(0);
        }
    }

    private final synchronized void $$robo$$android_media_ImageReader$nativeInit(Object object, int n, int n2, int n3, int n4, long l) {
    }

    private final synchronized void $$robo$$android_media_ImageReader$nativeClose() {
    }

    private final synchronized void $$robo$$android_media_ImageReader$nativeReleaseImage(Image image) {
    }

    private final synchronized Surface $$robo$$android_media_ImageReader$nativeGetSurface() {
        return null;
    }

    private final synchronized int $$robo$$android_media_ImageReader$nativeDetachImage(Image image) {
        return 0;
    }

    private final synchronized void $$robo$$android_media_ImageReader$nativeDiscardFreeBuffers() {
    }

    private final synchronized int $$robo$$android_media_ImageReader$nativeImageSetup(Image image) {
        return 0;
    }

    private static final void $$robo$$android_media_ImageReader$nativeClassInit() {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        ImageReader.nativeClassInit();
    }

    public static ImageReader newInstance(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_media_ImageReader$newInstance(int int int int ), (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static ImageReader newInstance(int n, int n2, int n3, int n4, long l) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_media_ImageReader$newInstance(int int int int long ), (int)n, (int)n2, (int)n3, (int)n4, (long)l);
    }

    private void __constructor__(int n, int n2, int n3, int n4, long l) {
        this.$$robo$$android_media_ImageReader$__constructor__(n, n2, n3, n4, l);
    }

    public ImageReader(int n, int n2, int n3, int n4, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageReader$__constructor__(int int int int long ), this, n, n2, n3, n4, l);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_media_ImageReader$getWidth(), this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_media_ImageReader$getHeight(), this);
    }

    public int getImageFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getImageFormat", $$robo$$android_media_ImageReader$getImageFormat(), this);
    }

    public int getMaxImages() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxImages", $$robo$$android_media_ImageReader$getMaxImages(), this);
    }

    public Surface getSurface() {
        return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$android_media_ImageReader$getSurface(), this);
    }

    public Image acquireLatestImage() {
        return InvokeDynamicSupport.bootstrap("acquireLatestImage", $$robo$$android_media_ImageReader$acquireLatestImage(), this);
    }

    public Image acquireNextImageNoThrowISE() {
        return InvokeDynamicSupport.bootstrap("acquireNextImageNoThrowISE", $$robo$$android_media_ImageReader$acquireNextImageNoThrowISE(), this);
    }

    private int acquireNextSurfaceImage(SurfaceImage surfaceImage) {
        return (int)InvokeDynamicSupport.bootstrap("acquireNextSurfaceImage", $$robo$$android_media_ImageReader$acquireNextSurfaceImage(android.media.ImageReader$SurfaceImage ), this, surfaceImage);
    }

    public Image acquireNextImage() {
        return InvokeDynamicSupport.bootstrap("acquireNextImage", $$robo$$android_media_ImageReader$acquireNextImage(), this);
    }

    private void releaseImage(Image image) {
        InvokeDynamicSupport.bootstrap("releaseImage", $$robo$$android_media_ImageReader$releaseImage(android.media.Image ), this, image);
    }

    public void setOnImageAvailableListener(OnImageAvailableListener onImageAvailableListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnImageAvailableListener", $$robo$$android_media_ImageReader$setOnImageAvailableListener(android.media.ImageReader$OnImageAvailableListener android.os.Handler ), this, onImageAvailableListener, handler);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_ImageReader$close(), this);
    }

    public void discardFreeBuffers() {
        InvokeDynamicSupport.bootstrap("discardFreeBuffers", $$robo$$android_media_ImageReader$discardFreeBuffers(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_ImageReader$finalize(), this);
    }

    void detachImage(Image image) {
        InvokeDynamicSupport.bootstrap("detachImage", $$robo$$android_media_ImageReader$detachImage(android.media.Image ), this, image);
    }

    private boolean isImageOwnedbyMe(Image image) {
        return (boolean)InvokeDynamicSupport.bootstrap("isImageOwnedbyMe", $$robo$$android_media_ImageReader$isImageOwnedbyMe(android.media.Image ), this, image);
    }

    private static boolean isFormatUsageCombinationAllowed(int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFormatUsageCombinationAllowed", $$robo$$android_media_ImageReader$isFormatUsageCombinationAllowed(int long ), (int)n, (long)l);
    }

    private static void postEventFromNative(Object object) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_ImageReader$postEventFromNative(java.lang.Object ), (Object)object);
    }

    private synchronized void nativeInit(Object object, int n, int n2, int n3, int n4, long l) {
        InvokeDynamicSupport.bootstrap("nativeInit", $$robo$$android_media_ImageReader$nativeInit(java.lang.Object int int int int long ), this, object, n, n2, n3, n4, l);
    }

    private synchronized void nativeClose() {
        InvokeDynamicSupport.bootstrap("nativeClose", $$robo$$android_media_ImageReader$nativeClose(), this);
    }

    private synchronized void nativeReleaseImage(Image image) {
        InvokeDynamicSupport.bootstrap("nativeReleaseImage", $$robo$$android_media_ImageReader$nativeReleaseImage(android.media.Image ), this, image);
    }

    private synchronized Surface nativeGetSurface() {
        return InvokeDynamicSupport.bootstrap("nativeGetSurface", $$robo$$android_media_ImageReader$nativeGetSurface(), this);
    }

    private synchronized int nativeDetachImage(Image image) {
        return (int)InvokeDynamicSupport.bootstrap("nativeDetachImage", $$robo$$android_media_ImageReader$nativeDetachImage(android.media.Image ), this, image);
    }

    private synchronized void nativeDiscardFreeBuffers() {
        InvokeDynamicSupport.bootstrap("nativeDiscardFreeBuffers", $$robo$$android_media_ImageReader$nativeDiscardFreeBuffers(), this);
    }

    private synchronized int nativeImageSetup(Image image) {
        return (int)InvokeDynamicSupport.bootstrap("nativeImageSetup", $$robo$$android_media_ImageReader$nativeImageSetup(android.media.Image ), this, image);
    }

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_media_ImageReader$nativeClassInit());
    }

    static {
        RobolectricInternals.classInitializing(ImageReader.class);
    }

    public /* synthetic */ ImageReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SurfaceImage
    extends Image
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mNativeBuffer;
        private long mTimestamp;
        private int mTransform;
        private int mScalingMode;
        private SurfacePlane[] mPlanes;
        private int mFormat;
        private AtomicBoolean mIsDetached;
        /* synthetic */ ImageReader this$0;

        private void $$robo$$android_media_ImageReader_SurfaceImage$__constructor__(ImageReader imageReader, int format) {
            this.this$0 = imageReader;
            this.mFormat = 0;
            this.mIsDetached = new AtomicBoolean(false);
            this.mFormat = format;
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$close() {
            this.this$0.releaseImage(this);
        }

        private final ImageReader $$robo$$android_media_ImageReader_SurfaceImage$getReader() {
            return this.this$0;
        }

        private final int $$robo$$android_media_ImageReader_SurfaceImage$getFormat() {
            this.throwISEIfImageIsInvalid();
            int readerFormat = this.this$0.getImageFormat();
            this.mFormat = readerFormat == 34 ? readerFormat : this.nativeGetFormat(readerFormat);
            return this.mFormat;
        }

        private final int $$robo$$android_media_ImageReader_SurfaceImage$getWidth() {
            int width;
            this.throwISEIfImageIsInvalid();
            switch (this.getFormat()) {
                case 36: 
                case 256: 
                case 257: {
                    width = this.this$0.getWidth();
                    break;
                }
                default: {
                    width = this.nativeGetWidth();
                }
            }
            return width;
        }

        private final int $$robo$$android_media_ImageReader_SurfaceImage$getHeight() {
            int height;
            this.throwISEIfImageIsInvalid();
            switch (this.getFormat()) {
                case 36: 
                case 256: 
                case 257: {
                    height = this.this$0.getHeight();
                    break;
                }
                default: {
                    height = this.nativeGetHeight();
                }
            }
            return height;
        }

        private final long $$robo$$android_media_ImageReader_SurfaceImage$getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        private final int $$robo$$android_media_ImageReader_SurfaceImage$getTransform() {
            this.throwISEIfImageIsInvalid();
            return this.mTransform;
        }

        private final int $$robo$$android_media_ImageReader_SurfaceImage$getScalingMode() {
            this.throwISEIfImageIsInvalid();
            return this.mScalingMode;
        }

        private final HardwareBuffer $$robo$$android_media_ImageReader_SurfaceImage$getHardwareBuffer() {
            this.throwISEIfImageIsInvalid();
            return this.nativeGetHardwareBuffer();
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$setTimestamp(long timestampNs) {
            this.throwISEIfImageIsInvalid();
            this.mTimestamp = timestampNs;
        }

        private final Image.Plane[] $$robo$$android_media_ImageReader_SurfaceImage$getPlanes() {
            this.throwISEIfImageIsInvalid();
            if (this.mPlanes == null) {
                this.mPlanes = this.nativeCreatePlanes(this.this$0.mNumPlanes, this.this$0.mFormat);
            }
            return (Image.Plane[])this.mPlanes.clone();
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private final boolean $$robo$$android_media_ImageReader_SurfaceImage$isAttachable() {
            this.throwISEIfImageIsInvalid();
            return this.mIsDetached.get();
        }

        private final ImageReader $$robo$$android_media_ImageReader_SurfaceImage$getOwner() {
            this.throwISEIfImageIsInvalid();
            return this.this$0;
        }

        private final long $$robo$$android_media_ImageReader_SurfaceImage$getNativeContext() {
            this.throwISEIfImageIsInvalid();
            return this.mNativeBuffer;
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$setDetached(boolean detached) {
            this.throwISEIfImageIsInvalid();
            this.mIsDetached.getAndSet(detached);
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$clearSurfacePlanes() {
            if (this.mIsImageValid && this.mPlanes != null) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private final synchronized SurfacePlane[] $$robo$$android_media_ImageReader_SurfaceImage$nativeCreatePlanes(int n, int n2) {
            return null;
        }

        private final synchronized int $$robo$$android_media_ImageReader_SurfaceImage$nativeGetWidth() {
            return 0;
        }

        private final synchronized int $$robo$$android_media_ImageReader_SurfaceImage$nativeGetHeight() {
            return 0;
        }

        private final synchronized int $$robo$$android_media_ImageReader_SurfaceImage$nativeGetFormat(int n) {
            return 0;
        }

        private final synchronized HardwareBuffer $$robo$$android_media_ImageReader_SurfaceImage$nativeGetHardwareBuffer() {
            return null;
        }

        static /* synthetic */ SurfacePlane[] access$102(SurfaceImage x0, SurfacePlane[] x1) {
            x0.mPlanes = x1;
            return x1;
        }

        private void __constructor__(ImageReader imageReader, int n) {
            this.$$robo$$android_media_ImageReader_SurfaceImage$__constructor__(imageReader, n);
        }

        public SurfaceImage(ImageReader imageReader, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageReader_SurfaceImage$__constructor__(android.media.ImageReader int ), this, imageReader, n);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_ImageReader_SurfaceImage$close(), this);
        }

        public ImageReader getReader() {
            return InvokeDynamicSupport.bootstrap("getReader", $$robo$$android_media_ImageReader_SurfaceImage$getReader(), this);
        }

        @Override
        public int getFormat() {
            return (int)InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_ImageReader_SurfaceImage$getFormat(), this);
        }

        @Override
        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_media_ImageReader_SurfaceImage$getWidth(), this);
        }

        @Override
        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_media_ImageReader_SurfaceImage$getHeight(), this);
        }

        @Override
        public long getTimestamp() {
            return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_ImageReader_SurfaceImage$getTimestamp(), this);
        }

        @Override
        public int getTransform() {
            return (int)InvokeDynamicSupport.bootstrap("getTransform", $$robo$$android_media_ImageReader_SurfaceImage$getTransform(), this);
        }

        @Override
        public int getScalingMode() {
            return (int)InvokeDynamicSupport.bootstrap("getScalingMode", $$robo$$android_media_ImageReader_SurfaceImage$getScalingMode(), this);
        }

        @Override
        public HardwareBuffer getHardwareBuffer() {
            return InvokeDynamicSupport.bootstrap("getHardwareBuffer", $$robo$$android_media_ImageReader_SurfaceImage$getHardwareBuffer(), this);
        }

        @Override
        public void setTimestamp(long l) {
            InvokeDynamicSupport.bootstrap("setTimestamp", $$robo$$android_media_ImageReader_SurfaceImage$setTimestamp(long ), this, l);
        }

        @Override
        public Image.Plane[] getPlanes() {
            return InvokeDynamicSupport.bootstrap("getPlanes", $$robo$$android_media_ImageReader_SurfaceImage$getPlanes(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_ImageReader_SurfaceImage$finalize(), this);
        }

        @Override
        boolean isAttachable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAttachable", $$robo$$android_media_ImageReader_SurfaceImage$isAttachable(), this);
        }

        @Override
        ImageReader getOwner() {
            return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$android_media_ImageReader_SurfaceImage$getOwner(), this);
        }

        @Override
        long getNativeContext() {
            return (long)InvokeDynamicSupport.bootstrap("getNativeContext", $$robo$$android_media_ImageReader_SurfaceImage$getNativeContext(), this);
        }

        private void setDetached(boolean bl) {
            InvokeDynamicSupport.bootstrap("setDetached", $$robo$$android_media_ImageReader_SurfaceImage$setDetached(boolean ), this, bl);
        }

        private void clearSurfacePlanes() {
            InvokeDynamicSupport.bootstrap("clearSurfacePlanes", $$robo$$android_media_ImageReader_SurfaceImage$clearSurfacePlanes(), this);
        }

        private synchronized SurfacePlane[] nativeCreatePlanes(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("nativeCreatePlanes", $$robo$$android_media_ImageReader_SurfaceImage$nativeCreatePlanes(int int ), this, n, n2);
        }

        private synchronized int nativeGetWidth() {
            return (int)InvokeDynamicSupport.bootstrap("nativeGetWidth", $$robo$$android_media_ImageReader_SurfaceImage$nativeGetWidth(), this);
        }

        private synchronized int nativeGetHeight() {
            return (int)InvokeDynamicSupport.bootstrap("nativeGetHeight", $$robo$$android_media_ImageReader_SurfaceImage$nativeGetHeight(), this);
        }

        private synchronized int nativeGetFormat(int n) {
            return (int)InvokeDynamicSupport.bootstrap("nativeGetFormat", $$robo$$android_media_ImageReader_SurfaceImage$nativeGetFormat(int ), this, n);
        }

        private synchronized HardwareBuffer nativeGetHardwareBuffer() {
            return InvokeDynamicSupport.bootstrap("nativeGetHardwareBuffer", $$robo$$android_media_ImageReader_SurfaceImage$nativeGetHardwareBuffer(), this);
        }

        public /* synthetic */ SurfaceImage() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceImage)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class SurfacePlane
        extends Image.Plane
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mPixelStride;
            private int mRowStride;
            private ByteBuffer mBuffer;
            /* synthetic */ SurfaceImage this$1;

            private void $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$__constructor__(SurfaceImage surfaceImage, int rowStride, int pixelStride, ByteBuffer buffer) {
                this.this$1 = surfaceImage;
                this.mRowStride = rowStride;
                this.mPixelStride = pixelStride;
                this.mBuffer = buffer;
                this.mBuffer.order(ByteOrder.nativeOrder());
            }

            private final ByteBuffer $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getBuffer() {
                this.this$1.throwISEIfImageIsInvalid();
                return this.mBuffer;
            }

            private final int $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getPixelStride() {
                this.this$1.throwISEIfImageIsInvalid();
                if (this.this$1.this$0.mFormat == 36) {
                    throw new UnsupportedOperationException("getPixelStride is not supported for RAW_PRIVATE plane");
                }
                return this.mPixelStride;
            }

            private final int $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getRowStride() {
                this.this$1.throwISEIfImageIsInvalid();
                if (this.this$1.this$0.mFormat == 36) {
                    throw new UnsupportedOperationException("getRowStride is not supported for RAW_PRIVATE plane");
                }
                return this.mRowStride;
            }

            private final void $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$clearBuffer() {
                if (this.mBuffer == null) {
                    return;
                }
                if (this.mBuffer.isDirect()) {
                    NioUtils.freeDirectBuffer(this.mBuffer);
                }
                this.mBuffer = null;
            }

            private void __constructor__(SurfaceImage surfaceImage, int n, int n2, ByteBuffer byteBuffer) {
                this.$$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$__constructor__(surfaceImage, n, n2, byteBuffer);
            }

            public SurfacePlane(SurfaceImage surfaceImage, int n, int n2, ByteBuffer byteBuffer) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$__constructor__(android.media.ImageReader$SurfaceImage int int java.nio.ByteBuffer ), this, surfaceImage, n, n2, byteBuffer);
            }

            @Override
            public ByteBuffer getBuffer() {
                return InvokeDynamicSupport.bootstrap("getBuffer", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getBuffer(), this);
            }

            @Override
            public int getPixelStride() {
                return (int)InvokeDynamicSupport.bootstrap("getPixelStride", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getPixelStride(), this);
            }

            @Override
            public int getRowStride() {
                return (int)InvokeDynamicSupport.bootstrap("getRowStride", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getRowStride(), this);
            }

            private void clearBuffer() {
                InvokeDynamicSupport.bootstrap("clearBuffer", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$clearBuffer(), this);
            }

            public /* synthetic */ SurfacePlane() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfacePlane)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ListenerHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ImageReader this$0;

        private void $$robo$$android_media_ImageReader_ListenerHandler$__constructor__(ImageReader imageReader, Looper looper) {
            this.this$0 = imageReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_ImageReader_ListenerHandler$handleMessage(Message msg) {
            OnImageAvailableListener listener;
            Object object = this.this$0.mListenerLock;
            synchronized (object) {
                listener = this.this$0.mListener;
            }
            boolean isReaderValid = false;
            Object object2 = this.this$0.mCloseLock;
            synchronized (object2) {
                isReaderValid = this.this$0.mIsReaderValid;
            }
            if (listener != null && isReaderValid) {
                listener.onImageAvailable(this.this$0);
            }
        }

        private void __constructor__(ImageReader imageReader, Looper looper) {
            this.$$robo$$android_media_ImageReader_ListenerHandler$__constructor__(imageReader, looper);
        }

        public ListenerHandler(ImageReader imageReader, Looper looper) {
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageReader_ListenerHandler$__constructor__(android.media.ImageReader android.os.Looper ), this, imageReader, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_ImageReader_ListenerHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ ListenerHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnImageAvailableListener {
        public void onImageAvailable(ImageReader var1);
    }
}

