/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.Image;
import android.media.ImageReader;
import android.media.ImageUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Size;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImageWriter
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Object mListenerLock;
    private OnImageReleasedListener mListener;
    private ListenerHandler mListenerHandler;
    private long mNativeContext;
    private int mWriterFormat;
    private int mMaxImages;
    private List<Image> mDequeuedImages;
    private int mEstimatedNativeAllocBytes;

    private static final ImageWriter $$robo$$android_media_ImageWriter$newInstance(Surface surface, int maxImages) {
        return new ImageWriter(surface, maxImages, 0);
    }

    private static final ImageWriter $$robo$$android_media_ImageWriter$newInstance(Surface surface, int maxImages, int format) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            throw new IllegalArgumentException("Invalid format is specified: " + format);
        }
        return new ImageWriter(surface, maxImages, format);
    }

    private void $$robo$$android_media_ImageWriter$__constructor__(Surface surface, int maxImages, int format) {
        this.mListenerLock = new Object();
        this.mDequeuedImages = new CopyOnWriteArrayList<Image>();
        if (surface == null || maxImages < 1) {
            throw new IllegalArgumentException("Illegal input argument: surface " + surface + ", maxImages: " + maxImages);
        }
        this.mMaxImages = maxImages;
        if (format == 0) {
            format = SurfaceUtils.getSurfaceFormat(surface);
        }
        this.mNativeContext = this.nativeInit(new WeakReference<ImageWriter>(this), surface, maxImages, format);
        Size surfSize = SurfaceUtils.getSurfaceSize(surface);
        this.mEstimatedNativeAllocBytes = ImageUtils.getEstimatedNativeAllocBytes(surfSize.getWidth(), surfSize.getHeight(), format, 1);
        VMRuntime.getRuntime().registerNativeAllocation(this.mEstimatedNativeAllocBytes);
    }

    private final int $$robo$$android_media_ImageWriter$getMaxImages() {
        return this.mMaxImages;
    }

    private final Image $$robo$$android_media_ImageWriter$dequeueInputImage() {
        if (this.mDequeuedImages.size() >= this.mMaxImages) {
            throw new IllegalStateException("Already dequeued max number of Images " + this.mMaxImages);
        }
        WriterSurfaceImage newImage = new WriterSurfaceImage(this);
        this.nativeDequeueInputImage(this.mNativeContext, newImage);
        this.mDequeuedImages.add(newImage);
        newImage.mIsImageValid = true;
        return newImage;
    }

    private final void $$robo$$android_media_ImageWriter$queueInputImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        boolean ownedByMe = this.isImageOwnedByMe(image);
        if (ownedByMe && !((WriterSurfaceImage)image).mIsImageValid) {
            throw new IllegalStateException("Image from ImageWriter is invalid");
        }
        if (!ownedByMe) {
            if (!(image.getOwner() instanceof ImageReader)) {
                throw new IllegalArgumentException("Only images from ImageReader can be queued to ImageWriter, other image source is not supported yet!");
            }
            ImageReader prevOwner = (ImageReader)image.getOwner();
            prevOwner.detachImage(image);
            this.attachAndQueueInputImage(image);
            image.close();
            return;
        }
        Rect crop = image.getCropRect();
        this.nativeQueueInputImage(this.mNativeContext, image, image.getTimestamp(), crop.left, crop.top, crop.right, crop.bottom, image.getTransform(), image.getScalingMode());
        if (ownedByMe) {
            this.mDequeuedImages.remove(image);
            WriterSurfaceImage wi = (WriterSurfaceImage)image;
            wi.clearSurfacePlanes();
            wi.mIsImageValid = false;
        }
    }

    private final int $$robo$$android_media_ImageWriter$getFormat() {
        return this.mWriterFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ImageWriter$setOnImageReleasedListener(OnImageReleasedListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (listener != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(this, looper);
                }
                this.mListener = listener;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
        }
    }

    private final void $$robo$$android_media_ImageWriter$close() {
        this.setOnImageReleasedListener(null, null);
        for (Image image : this.mDequeuedImages) {
            image.close();
        }
        this.mDequeuedImages.clear();
        this.nativeClose(this.mNativeContext);
        this.mNativeContext = 0L;
        if (this.mEstimatedNativeAllocBytes > 0) {
            VMRuntime.getRuntime().registerNativeFree(this.mEstimatedNativeAllocBytes);
            this.mEstimatedNativeAllocBytes = 0;
        }
    }

    private final void $$robo$$android_media_ImageWriter$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_media_ImageWriter$attachAndQueueInputImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        if (this.isImageOwnedByMe(image)) {
            throw new IllegalArgumentException("Can not attach an image that is owned ImageWriter already");
        }
        if (!image.isAttachable()) {
            throw new IllegalStateException("Image was not detached from last owner, or image  is not detachable");
        }
        Rect crop = image.getCropRect();
        this.nativeAttachAndQueueImage(this.mNativeContext, image.getNativeContext(), image.getFormat(), image.getTimestamp(), crop.left, crop.top, crop.right, crop.bottom, image.getTransform(), image.getScalingMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_ImageWriter$postEventFromNative(Object selfRef) {
        ListenerHandler handler;
        WeakReference weakSelf = (WeakReference)selfRef;
        ImageWriter iw = (ImageWriter)weakSelf.get();
        if (iw == null) {
            return;
        }
        Object object = iw.mListenerLock;
        synchronized (object) {
            handler = iw.mListenerHandler;
        }
        if (handler != null) {
            handler.sendEmptyMessage(0);
        }
    }

    private final void $$robo$$android_media_ImageWriter$abortImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        if (!this.mDequeuedImages.contains(image)) {
            throw new IllegalStateException("It is illegal to abort some image that is not dequeued yet");
        }
        WriterSurfaceImage wi = (WriterSurfaceImage)image;
        if (!wi.mIsImageValid) {
            return;
        }
        this.cancelImage(this.mNativeContext, image);
        this.mDequeuedImages.remove(image);
        wi.clearSurfacePlanes();
        wi.mIsImageValid = false;
    }

    private final boolean $$robo$$android_media_ImageWriter$isImageOwnedByMe(Image image) {
        if (!(image instanceof WriterSurfaceImage)) {
            return false;
        }
        WriterSurfaceImage wi = (WriterSurfaceImage)image;
        return wi.getOwner() == this;
    }

    private final synchronized long $$robo$$android_media_ImageWriter$nativeInit(Object object, Surface surface, int n, int n2) {
        return 0L;
    }

    private final synchronized void $$robo$$android_media_ImageWriter$nativeClose(long l) {
    }

    private final synchronized void $$robo$$android_media_ImageWriter$nativeDequeueInputImage(long l, Image image) {
    }

    private final synchronized void $$robo$$android_media_ImageWriter$nativeQueueInputImage(long l, Image image, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    private final synchronized int $$robo$$android_media_ImageWriter$nativeAttachAndQueueImage(long l, long l2, int n, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
        return 0;
    }

    private final synchronized void $$robo$$android_media_ImageWriter$cancelImage(long l, Image image) {
    }

    private static final void $$robo$$android_media_ImageWriter$nativeClassInit() {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        ImageWriter.nativeClassInit();
    }

    public static ImageWriter newInstance(Surface surface, int n) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_media_ImageWriter$newInstance(android.view.Surface int ), (Surface)surface, (int)n);
    }

    public static ImageWriter newInstance(Surface surface, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_media_ImageWriter$newInstance(android.view.Surface int int ), (Surface)surface, (int)n, (int)n2);
    }

    private void __constructor__(Surface surface, int n, int n2) {
        this.$$robo$$android_media_ImageWriter$__constructor__(surface, n, n2);
    }

    public ImageWriter(Surface surface, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageWriter$__constructor__(android.view.Surface int int ), this, surface, n, n2);
    }

    public int getMaxImages() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxImages", $$robo$$android_media_ImageWriter$getMaxImages(), this);
    }

    public Image dequeueInputImage() {
        return InvokeDynamicSupport.bootstrap("dequeueInputImage", $$robo$$android_media_ImageWriter$dequeueInputImage(), this);
    }

    public void queueInputImage(Image image) {
        InvokeDynamicSupport.bootstrap("queueInputImage", $$robo$$android_media_ImageWriter$queueInputImage(android.media.Image ), this, image);
    }

    public int getFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_ImageWriter$getFormat(), this);
    }

    public void setOnImageReleasedListener(OnImageReleasedListener onImageReleasedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnImageReleasedListener", $$robo$$android_media_ImageWriter$setOnImageReleasedListener(android.media.ImageWriter$OnImageReleasedListener android.os.Handler ), this, onImageReleasedListener, handler);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_ImageWriter$close(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_ImageWriter$finalize(), this);
    }

    private void attachAndQueueInputImage(Image image) {
        InvokeDynamicSupport.bootstrap("attachAndQueueInputImage", $$robo$$android_media_ImageWriter$attachAndQueueInputImage(android.media.Image ), this, image);
    }

    private static void postEventFromNative(Object object) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_ImageWriter$postEventFromNative(java.lang.Object ), (Object)object);
    }

    private void abortImage(Image image) {
        InvokeDynamicSupport.bootstrap("abortImage", $$robo$$android_media_ImageWriter$abortImage(android.media.Image ), this, image);
    }

    private boolean isImageOwnedByMe(Image image) {
        return (boolean)InvokeDynamicSupport.bootstrap("isImageOwnedByMe", $$robo$$android_media_ImageWriter$isImageOwnedByMe(android.media.Image ), this, image);
    }

    private synchronized long nativeInit(Object object, Surface surface, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("nativeInit", $$robo$$android_media_ImageWriter$nativeInit(java.lang.Object android.view.Surface int int ), this, object, surface, n, n2);
    }

    private synchronized void nativeClose(long l) {
        InvokeDynamicSupport.bootstrap("nativeClose", $$robo$$android_media_ImageWriter$nativeClose(long ), this, l);
    }

    private synchronized void nativeDequeueInputImage(long l, Image image) {
        InvokeDynamicSupport.bootstrap("nativeDequeueInputImage", $$robo$$android_media_ImageWriter$nativeDequeueInputImage(long android.media.Image ), this, l, image);
    }

    private synchronized void nativeQueueInputImage(long l, Image image, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("nativeQueueInputImage", $$robo$$android_media_ImageWriter$nativeQueueInputImage(long android.media.Image long int int int int int int ), this, l, image, l2, n, n2, n3, n4, n5, n6);
    }

    private synchronized int nativeAttachAndQueueImage(long l, long l2, int n, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
        return (int)InvokeDynamicSupport.bootstrap("nativeAttachAndQueueImage", $$robo$$android_media_ImageWriter$nativeAttachAndQueueImage(long long int long int int int int int int ), this, l, l2, n, l3, n2, n3, n4, n5, n6, n7);
    }

    private synchronized void cancelImage(long l, Image image) {
        InvokeDynamicSupport.bootstrap("cancelImage", $$robo$$android_media_ImageWriter$cancelImage(long android.media.Image ), this, l, image);
    }

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_media_ImageWriter$nativeClassInit());
    }

    static {
        RobolectricInternals.classInitializing(ImageWriter.class);
    }

    public /* synthetic */ ImageWriter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageWriter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class WriterSurfaceImage
    extends Image
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ImageWriter mOwner;
        private long mNativeBuffer;
        private int mNativeFenceFd;
        private SurfacePlane[] mPlanes;
        private int mHeight;
        private int mWidth;
        private int mFormat;
        private long DEFAULT_TIMESTAMP = Long.MIN_VALUE;
        private long mTimestamp;
        private int mTransform;
        private int mScalingMode;

        private void $$robo$$android_media_ImageWriter_WriterSurfaceImage$__constructor__(ImageWriter writer) {
            this.mNativeFenceFd = -1;
            this.mHeight = -1;
            this.mWidth = -1;
            this.mFormat = -1;
            this.DEFAULT_TIMESTAMP = Long.MIN_VALUE;
            this.mTimestamp = Long.MIN_VALUE;
            this.mTransform = 0;
            this.mScalingMode = 0;
            this.mOwner = writer;
        }

        private final int $$robo$$android_media_ImageWriter_WriterSurfaceImage$getFormat() {
            this.throwISEIfImageIsInvalid();
            if (this.mFormat == -1) {
                this.mFormat = this.nativeGetFormat();
            }
            return this.mFormat;
        }

        private final int $$robo$$android_media_ImageWriter_WriterSurfaceImage$getWidth() {
            this.throwISEIfImageIsInvalid();
            if (this.mWidth == -1) {
                this.mWidth = this.nativeGetWidth();
            }
            return this.mWidth;
        }

        private final int $$robo$$android_media_ImageWriter_WriterSurfaceImage$getHeight() {
            this.throwISEIfImageIsInvalid();
            if (this.mHeight == -1) {
                this.mHeight = this.nativeGetHeight();
            }
            return this.mHeight;
        }

        private final int $$robo$$android_media_ImageWriter_WriterSurfaceImage$getTransform() {
            this.throwISEIfImageIsInvalid();
            return this.mTransform;
        }

        private final int $$robo$$android_media_ImageWriter_WriterSurfaceImage$getScalingMode() {
            this.throwISEIfImageIsInvalid();
            return this.mScalingMode;
        }

        private final long $$robo$$android_media_ImageWriter_WriterSurfaceImage$getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        private final void $$robo$$android_media_ImageWriter_WriterSurfaceImage$setTimestamp(long timestamp) {
            this.throwISEIfImageIsInvalid();
            this.mTimestamp = timestamp;
        }

        private final HardwareBuffer $$robo$$android_media_ImageWriter_WriterSurfaceImage$getHardwareBuffer() {
            this.throwISEIfImageIsInvalid();
            return this.nativeGetHardwareBuffer();
        }

        private final Image.Plane[] $$robo$$android_media_ImageWriter_WriterSurfaceImage$getPlanes() {
            this.throwISEIfImageIsInvalid();
            if (this.mPlanes == null) {
                int numPlanes = ImageUtils.getNumPlanesForFormat(this.getFormat());
                this.mPlanes = this.nativeCreatePlanes(numPlanes, ((ImageWriter)this.getOwner()).getFormat());
            }
            return (Image.Plane[])this.mPlanes.clone();
        }

        private final boolean $$robo$$android_media_ImageWriter_WriterSurfaceImage$isAttachable() {
            this.throwISEIfImageIsInvalid();
            return false;
        }

        private final ImageWriter $$robo$$android_media_ImageWriter_WriterSurfaceImage$getOwner() {
            this.throwISEIfImageIsInvalid();
            return this.mOwner;
        }

        private final long $$robo$$android_media_ImageWriter_WriterSurfaceImage$getNativeContext() {
            this.throwISEIfImageIsInvalid();
            return this.mNativeBuffer;
        }

        private final void $$robo$$android_media_ImageWriter_WriterSurfaceImage$close() {
            if (this.mIsImageValid) {
                ((ImageWriter)this.getOwner()).abortImage(this);
            }
        }

        private final void $$robo$$android_media_ImageWriter_WriterSurfaceImage$finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private final void $$robo$$android_media_ImageWriter_WriterSurfaceImage$clearSurfacePlanes() {
            if (this.mIsImageValid && this.mPlanes != null) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private final synchronized SurfacePlane[] $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeCreatePlanes(int n, int n2) {
            return null;
        }

        private final synchronized int $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeGetWidth() {
            return 0;
        }

        private final synchronized int $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeGetHeight() {
            return 0;
        }

        private final synchronized int $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeGetFormat() {
            return 0;
        }

        private final synchronized HardwareBuffer $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeGetHardwareBuffer() {
            return null;
        }

        private void __constructor__(ImageWriter imageWriter) {
            this.$$robo$$android_media_ImageWriter_WriterSurfaceImage$__constructor__(imageWriter);
        }

        public WriterSurfaceImage(ImageWriter imageWriter) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageWriter_WriterSurfaceImage$__constructor__(android.media.ImageWriter ), this, imageWriter);
        }

        @Override
        public int getFormat() {
            return (int)InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getFormat(), this);
        }

        @Override
        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getWidth(), this);
        }

        @Override
        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getHeight(), this);
        }

        @Override
        public int getTransform() {
            return (int)InvokeDynamicSupport.bootstrap("getTransform", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getTransform(), this);
        }

        @Override
        public int getScalingMode() {
            return (int)InvokeDynamicSupport.bootstrap("getScalingMode", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getScalingMode(), this);
        }

        @Override
        public long getTimestamp() {
            return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getTimestamp(), this);
        }

        @Override
        public void setTimestamp(long l) {
            InvokeDynamicSupport.bootstrap("setTimestamp", $$robo$$android_media_ImageWriter_WriterSurfaceImage$setTimestamp(long ), this, l);
        }

        @Override
        public HardwareBuffer getHardwareBuffer() {
            return InvokeDynamicSupport.bootstrap("getHardwareBuffer", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getHardwareBuffer(), this);
        }

        @Override
        public Image.Plane[] getPlanes() {
            return InvokeDynamicSupport.bootstrap("getPlanes", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getPlanes(), this);
        }

        @Override
        boolean isAttachable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAttachable", $$robo$$android_media_ImageWriter_WriterSurfaceImage$isAttachable(), this);
        }

        @Override
        ImageWriter getOwner() {
            return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getOwner(), this);
        }

        @Override
        long getNativeContext() {
            return (long)InvokeDynamicSupport.bootstrap("getNativeContext", $$robo$$android_media_ImageWriter_WriterSurfaceImage$getNativeContext(), this);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_ImageWriter_WriterSurfaceImage$close(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_ImageWriter_WriterSurfaceImage$finalize(), this);
        }

        private void clearSurfacePlanes() {
            InvokeDynamicSupport.bootstrap("clearSurfacePlanes", $$robo$$android_media_ImageWriter_WriterSurfaceImage$clearSurfacePlanes(), this);
        }

        private synchronized SurfacePlane[] nativeCreatePlanes(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("nativeCreatePlanes", $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeCreatePlanes(int int ), this, n, n2);
        }

        private synchronized int nativeGetWidth() {
            return (int)InvokeDynamicSupport.bootstrap("nativeGetWidth", $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeGetWidth(), this);
        }

        private synchronized int nativeGetHeight() {
            return (int)InvokeDynamicSupport.bootstrap("nativeGetHeight", $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeGetHeight(), this);
        }

        private synchronized int nativeGetFormat() {
            return (int)InvokeDynamicSupport.bootstrap("nativeGetFormat", $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeGetFormat(), this);
        }

        private synchronized HardwareBuffer nativeGetHardwareBuffer() {
            return InvokeDynamicSupport.bootstrap("nativeGetHardwareBuffer", $$robo$$android_media_ImageWriter_WriterSurfaceImage$nativeGetHardwareBuffer(), this);
        }

        public /* synthetic */ WriterSurfaceImage() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WriterSurfaceImage)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class SurfacePlane
        extends Image.Plane
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private ByteBuffer mBuffer;
            private int mPixelStride;
            private int mRowStride;
            /* synthetic */ WriterSurfaceImage this$0;

            private void $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$__constructor__(WriterSurfaceImage writerSurfaceImage, int rowStride, int pixelStride, ByteBuffer buffer) {
                this.this$0 = writerSurfaceImage;
                this.mRowStride = rowStride;
                this.mPixelStride = pixelStride;
                this.mBuffer = buffer;
                this.mBuffer.order(ByteOrder.nativeOrder());
            }

            private final int $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$getRowStride() {
                this.this$0.throwISEIfImageIsInvalid();
                return this.mRowStride;
            }

            private final int $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$getPixelStride() {
                this.this$0.throwISEIfImageIsInvalid();
                return this.mPixelStride;
            }

            private final ByteBuffer $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$getBuffer() {
                this.this$0.throwISEIfImageIsInvalid();
                return this.mBuffer;
            }

            private final void $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$clearBuffer() {
                if (this.mBuffer == null) {
                    return;
                }
                if (this.mBuffer.isDirect()) {
                    NioUtils.freeDirectBuffer(this.mBuffer);
                }
                this.mBuffer = null;
            }

            private void __constructor__(WriterSurfaceImage writerSurfaceImage, int n, int n2, ByteBuffer byteBuffer) {
                this.$$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$__constructor__(writerSurfaceImage, n, n2, byteBuffer);
            }

            public SurfacePlane(WriterSurfaceImage writerSurfaceImage, int n, int n2, ByteBuffer byteBuffer) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$__constructor__(android.media.ImageWriter$WriterSurfaceImage int int java.nio.ByteBuffer ), this, writerSurfaceImage, n, n2, byteBuffer);
            }

            @Override
            public int getRowStride() {
                return (int)InvokeDynamicSupport.bootstrap("getRowStride", $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$getRowStride(), this);
            }

            @Override
            public int getPixelStride() {
                return (int)InvokeDynamicSupport.bootstrap("getPixelStride", $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$getPixelStride(), this);
            }

            @Override
            public ByteBuffer getBuffer() {
                return InvokeDynamicSupport.bootstrap("getBuffer", $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$getBuffer(), this);
            }

            private void clearBuffer() {
                InvokeDynamicSupport.bootstrap("clearBuffer", $$robo$$android_media_ImageWriter_WriterSurfaceImage_SurfacePlane$clearBuffer(), this);
            }

            public /* synthetic */ SurfacePlane() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfacePlane)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ListenerHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ImageWriter this$0;

        private void $$robo$$android_media_ImageWriter_ListenerHandler$__constructor__(ImageWriter imageWriter, Looper looper) {
            this.this$0 = imageWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_ImageWriter_ListenerHandler$handleMessage(Message msg) {
            OnImageReleasedListener listener;
            Object object = this.this$0.mListenerLock;
            synchronized (object) {
                listener = this.this$0.mListener;
            }
            if (listener != null) {
                listener.onImageReleased(this.this$0);
            }
        }

        private void __constructor__(ImageWriter imageWriter, Looper looper) {
            this.$$robo$$android_media_ImageWriter_ListenerHandler$__constructor__(imageWriter, looper);
        }

        public ListenerHandler(ImageWriter imageWriter, Looper looper) {
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageWriter_ListenerHandler$__constructor__(android.media.ImageWriter android.os.Looper ), this, imageWriter, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_ImageWriter_ListenerHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ ListenerHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnImageReleasedListener {
        public void onImageReleased(ImageWriter var1);
    }
}

