/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.SoundPool;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaActionSound
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int NUM_MEDIA_SOUND_STREAMS = 1;
    private SoundPool mSoundPool;
    private SoundState[] mSounds;
    private static String[] SOUND_DIRS;
    private static String[] SOUND_FILES;
    private static String TAG = "MediaActionSound";
    public static int SHUTTER_CLICK = 0;
    public static int FOCUS_COMPLETE = 1;
    public static int START_VIDEO_RECORDING = 2;
    public static int STOP_VIDEO_RECORDING = 3;
    private static int STATE_NOT_LOADED = 0;
    private static int STATE_LOADING = 1;
    private static int STATE_LOADING_PLAY_REQUESTED = 2;
    private static int STATE_LOADED = 3;
    private SoundPool.OnLoadCompleteListener mLoadCompleteListener;

    private void $$robo$$android_media_MediaActionSound$__constructor__() {
        this.mLoadCompleteListener = new SoundPool.OnLoadCompleteListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaActionSound this$0;

            private void $$robo$$android_media_MediaActionSound_1$__constructor__(MediaActionSound this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaActionSound_1$onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                for (SoundState sound : this.this$0.mSounds) {
                    if (sound.id != sampleId) continue;
                    int playSoundId = 0;
                    SoundState soundState = sound;
                    synchronized (soundState) {
                        if (status != 0) {
                            sound.state = 0;
                            sound.id = 0;
                            Log.e("MediaActionSound", "OnLoadCompleteListener() error: " + status + " loading sound: " + sound.name);
                            return;
                        }
                        switch (sound.state) {
                            case 1: {
                                sound.state = 3;
                                break;
                            }
                            case 2: {
                                playSoundId = sound.id;
                                sound.state = 3;
                                break;
                            }
                            default: {
                                Log.e("MediaActionSound", "OnLoadCompleteListener() called in wrong state: " + sound.state + " for sound: " + sound.name);
                            }
                        }
                    }
                    if (playSoundId == 0) break;
                    soundPool.play(playSoundId, 1.0f, 1.0f, 0, 0, 1.0f);
                    break;
                }
            }

            private void __constructor__(MediaActionSound mediaActionSound) {
                this.$$robo$$android_media_MediaActionSound_1$__constructor__(mediaActionSound);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaActionSound_1$__constructor__(android.media.MediaActionSound ), this, mediaActionSound);
            }

            @Override
            public void onLoadComplete(SoundPool soundPool, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onLoadComplete", $$robo$$android_media_MediaActionSound_1$onLoadComplete(android.media.SoundPool int int ), this, soundPool, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSoundPool = new SoundPool.Builder().setMaxStreams(1).setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setFlags(1).setContentType(4).build()).build();
        this.mSoundPool.setOnLoadCompleteListener(this.mLoadCompleteListener);
        this.mSounds = new SoundState[SOUND_FILES.length];
        for (int i = 0; i < this.mSounds.length; ++i) {
            this.mSounds[i] = new SoundState(this, i);
        }
    }

    private final int $$robo$$android_media_MediaActionSound$loadSound(SoundState sound) {
        String soundFileName = SOUND_FILES[sound.name];
        for (String soundDir : SOUND_DIRS) {
            int id2 = this.mSoundPool.load(soundDir + soundFileName, 1);
            if (id2 <= 0) continue;
            sound.state = 1;
            sound.id = id2;
            return id2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaActionSound$load(int soundName) {
        SoundState sound;
        if (soundName < 0 || soundName >= SOUND_FILES.length) {
            throw new RuntimeException("Unknown sound requested: " + soundName);
        }
        SoundState soundState = sound = this.mSounds[soundName];
        synchronized (soundState) {
            switch (sound.state) {
                case 0: {
                    if (this.loadSound(sound) > 0) break;
                    Log.e("MediaActionSound", "load() error loading sound: " + soundName);
                    break;
                }
                default: {
                    Log.e("MediaActionSound", "load() called in wrong state: " + sound + " for sound: " + soundName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaActionSound$play(int soundName) {
        SoundState sound;
        if (soundName < 0 || soundName >= SOUND_FILES.length) {
            throw new RuntimeException("Unknown sound requested: " + soundName);
        }
        SoundState soundState = sound = this.mSounds[soundName];
        synchronized (soundState) {
            switch (sound.state) {
                case 0: {
                    this.loadSound(sound);
                    if (this.loadSound(sound) <= 0) {
                        Log.e("MediaActionSound", "play() error loading sound: " + soundName);
                        break;
                    }
                }
                case 1: {
                    sound.state = 2;
                    break;
                }
                case 3: {
                    this.mSoundPool.play(sound.id, 1.0f, 1.0f, 0, 0, 1.0f);
                    break;
                }
                default: {
                    Log.e("MediaActionSound", "play() called in wrong state: " + sound.state + " for sound: " + soundName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaActionSound$release() {
        if (this.mSoundPool != null) {
            SoundState[] soundStateArray = this.mSounds;
            int n = soundStateArray.length;
            for (int i = 0; i < n; ++i) {
                SoundState sound;
                SoundState soundState = sound = soundStateArray[i];
                synchronized (soundState) {
                    sound.state = 0;
                    sound.id = 0;
                    continue;
                }
            }
            this.mSoundPool.release();
            this.mSoundPool = null;
        }
    }

    static void __staticInitializer__() {
        SOUND_DIRS = new String[]{"/product/media/audio/ui/", "/system/media/audio/ui/"};
        SOUND_FILES = new String[]{"camera_click.ogg", "camera_focus.ogg", "VideoRecord.ogg", "VideoStop.ogg"};
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaActionSound$__constructor__();
    }

    public MediaActionSound() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaActionSound$__constructor__(), this);
    }

    private int loadSound(SoundState soundState) {
        return (int)InvokeDynamicSupport.bootstrap("loadSound", $$robo$$android_media_MediaActionSound$loadSound(android.media.MediaActionSound$SoundState ), this, soundState);
    }

    public void load(int n) {
        InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_MediaActionSound$load(int ), this, n);
    }

    public void play(int n) {
        InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_MediaActionSound$play(int ), this, n);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaActionSound$release(), this);
    }

    static {
        RobolectricInternals.classInitializing(MediaActionSound.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaActionSound)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SoundState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int name;
        public int id;
        public int state;
        /* synthetic */ MediaActionSound this$0;

        private void $$robo$$android_media_MediaActionSound_SoundState$__constructor__(MediaActionSound mediaActionSound, int name) {
            this.this$0 = mediaActionSound;
            this.name = name;
            this.id = 0;
            this.state = 0;
        }

        private void __constructor__(MediaActionSound mediaActionSound, int n) {
            this.$$robo$$android_media_MediaActionSound_SoundState$__constructor__(mediaActionSound, n);
        }

        public SoundState(MediaActionSound mediaActionSound, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaActionSound_SoundState$__constructor__(android.media.MediaActionSound int ), this, mediaActionSound, n);
        }

        public /* synthetic */ SoundState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

