/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Rect;
import android.media.AudioSystem;
import android.media.Image;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaDescrambler;
import android.media.MediaFormat;
import android.media.Utils;
import android.os.Bundle;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaCodec
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int BUFFER_FLAG_SYNC_FRAME = 1;
    public static int BUFFER_FLAG_KEY_FRAME = 1;
    public static int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static int BUFFER_FLAG_END_OF_STREAM = 4;
    public static int BUFFER_FLAG_PARTIAL_FRAME = 8;
    public static int BUFFER_FLAG_MUXER_DATA = 16;
    private EventHandler mEventHandler;
    private EventHandler mOnFrameRenderedHandler;
    private EventHandler mCallbackHandler;
    private Callback mCallback;
    private OnFrameRenderedListener mOnFrameRenderedListener;
    private Object mListenerLock;
    private MediaCodecInfo mCodecInfo;
    private Object mCodecInfoLock;
    private static int EVENT_CALLBACK = 1;
    private static int EVENT_SET_CALLBACK = 2;
    private static int EVENT_FRAME_RENDERED = 3;
    private static int CB_INPUT_AVAILABLE = 1;
    private static int CB_OUTPUT_AVAILABLE = 2;
    private static int CB_ERROR = 3;
    private static int CB_OUTPUT_FORMAT_CHANGE = 4;
    private boolean mHasSurface;
    public static int CONFIGURE_FLAG_ENCODE = 1;
    public static int CRYPTO_MODE_UNENCRYPTED = 0;
    public static int CRYPTO_MODE_AES_CTR = 1;
    public static int CRYPTO_MODE_AES_CBC = 2;
    public static int INFO_TRY_AGAIN_LATER = -1;
    public static int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    private ByteBuffer[] mCachedInputBuffers;
    private ByteBuffer[] mCachedOutputBuffers;
    private BufferMap mDequeuedInputBuffers;
    private BufferMap mDequeuedOutputBuffers;
    private Map<Integer, BufferInfo> mDequeuedOutputInfos;
    private Object mBufferLock;
    public static int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    private long mNativeContext;

    private static final MediaCodec $$robo$$android_media_MediaCodec$createDecoderByType(String type) throws IOException {
        return new MediaCodec(type, true, false);
    }

    private static final MediaCodec $$robo$$android_media_MediaCodec$createEncoderByType(String type) throws IOException {
        return new MediaCodec(type, true, true);
    }

    private static final MediaCodec $$robo$$android_media_MediaCodec$createByCodecName(String name) throws IOException {
        return new MediaCodec(name, false, false);
    }

    private void $$robo$$android_media_MediaCodec$__constructor__(String name, boolean nameIsType, boolean encoder) {
        this.mListenerLock = new Object();
        this.mCodecInfoLock = new Object();
        this.mHasSurface = false;
        this.mDequeuedInputBuffers = new BufferMap(null);
        this.mDequeuedOutputBuffers = new BufferMap(null);
        this.mDequeuedOutputInfos = new HashMap<Integer, BufferInfo>();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, this, looper) : null);
        this.mCallbackHandler = this.mEventHandler;
        this.mOnFrameRenderedHandler = this.mEventHandler;
        this.mBufferLock = new Object();
        this.native_setup(name, nameIsType, encoder);
    }

    private final void $$robo$$android_media_MediaCodec$finalize() {
        this.native_finalize();
    }

    private final void $$robo$$android_media_MediaCodec$reset() {
        this.freeAllTrackedBuffers();
        this.native_reset();
    }

    private final void $$robo$$android_media_MediaCodec$native_reset() {
    }

    private final void $$robo$$android_media_MediaCodec$release() {
        this.freeAllTrackedBuffers();
        this.native_release();
    }

    private final void $$robo$$android_media_MediaCodec$native_release() {
    }

    private final void $$robo$$android_media_MediaCodec$configure(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        this.configure(format, surface, crypto, null, flags);
    }

    private final void $$robo$$android_media_MediaCodec$configure(MediaFormat format, Surface surface, int flags, MediaDescrambler descrambler) {
        this.configure(format, surface, null, descrambler != null ? descrambler.getBinder() : null, flags);
    }

    private final void $$robo$$android_media_MediaCodec$configure(MediaFormat format, Surface surface, MediaCrypto crypto, IHwBinder descramblerBinder, int flags) {
        if (crypto != null && descramblerBinder != null) {
            throw new IllegalArgumentException("Can't use crypto and descrambler together!");
        }
        String[] keys = null;
        Object[] values = null;
        if (format != null) {
            Map<String, Object> formatMap = format.getMap();
            keys = new String[formatMap.size()];
            values = new Object[formatMap.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : formatMap.entrySet()) {
                if (entry.getKey().equals("audio-session-id")) {
                    int sessionId = 0;
                    try {
                        sessionId = (Integer)entry.getValue();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Wrong Session ID Parameter!");
                    }
                    keys[i] = "audio-hw-sync";
                    values[i] = AudioSystem.getAudioHwSyncForSession(sessionId);
                } else {
                    keys[i] = entry.getKey();
                    values[i] = entry.getValue();
                }
                ++i;
            }
        }
        this.mHasSurface = surface != null;
        this.native_configure(keys, values, surface, crypto, descramblerBinder, flags);
    }

    private final void $$robo$$android_media_MediaCodec$setOutputSurface(Surface surface) {
        if (!this.mHasSurface) {
            throw new IllegalStateException("codec was not configured for an output surface");
        }
        this.native_setSurface(surface);
    }

    private final void $$robo$$android_media_MediaCodec$native_setSurface(Surface surface) {
    }

    private static final Surface $$robo$$android_media_MediaCodec$createPersistentInputSurface() {
        return MediaCodec.native_createPersistentInputSurface();
    }

    private final void $$robo$$android_media_MediaCodec$setInputSurface(Surface surface) {
        if (!(surface instanceof PersistentSurface)) {
            throw new IllegalArgumentException("not a PersistentSurface");
        }
        this.native_setInputSurface(surface);
    }

    private static final PersistentSurface $$robo$$android_media_MediaCodec$native_createPersistentInputSurface() {
        return null;
    }

    private static final void $$robo$$android_media_MediaCodec$native_releasePersistentInputSurface(Surface surface) {
    }

    private final void $$robo$$android_media_MediaCodec$native_setInputSurface(Surface surface) {
    }

    private final void $$robo$$android_media_MediaCodec$native_setCallback(Callback callback) {
    }

    private final void $$robo$$android_media_MediaCodec$native_configure(String[] stringArray, Object[] objectArray, Surface surface, MediaCrypto mediaCrypto, IHwBinder iHwBinder, int n) {
    }

    private final Surface $$robo$$android_media_MediaCodec$createInputSurface() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$start() {
        this.native_start();
        Object object = this.mBufferLock;
        synchronized (object) {
            this.cacheBuffers(true);
            this.cacheBuffers(false);
        }
    }

    private final void $$robo$$android_media_MediaCodec$native_start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$stop() {
        this.native_stop();
        this.freeAllTrackedBuffers();
        Object object = this.mListenerLock;
        synchronized (object) {
            if (this.mCallbackHandler != null) {
                this.mCallbackHandler.removeMessages(2);
                this.mCallbackHandler.removeMessages(1);
            }
            if (this.mOnFrameRenderedHandler != null) {
                this.mOnFrameRenderedHandler.removeMessages(3);
            }
        }
    }

    private final void $$robo$$android_media_MediaCodec$native_stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$flush() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffers(this.mCachedInputBuffers);
            this.invalidateByteBuffers(this.mCachedOutputBuffers);
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
        this.native_flush();
    }

    private final void $$robo$$android_media_MediaCodec$native_flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) throws CryptoException {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index);
            throw e;
        }
    }

    private final void $$robo$$android_media_MediaCodec$native_queueInputBuffer(int n, int n2, int n3, long l, int n4) throws CryptoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) throws CryptoException {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index);
            throw e;
        }
    }

    private final void $$robo$$android_media_MediaCodec$native_queueSecureInputBuffer(int n, int n2, CryptoInfo cryptoInfo, long l, int n3) throws CryptoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaCodec$dequeueInputBuffer(long timeoutUs) {
        int res = this.native_dequeueInputBuffer(timeoutUs);
        if (res >= 0) {
            Object object = this.mBufferLock;
            synchronized (object) {
                this.validateInputByteBuffer(this.mCachedInputBuffers, res);
            }
        }
        return res;
    }

    private final int $$robo$$android_media_MediaCodec$native_dequeueInputBuffer(long l) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaCodec$dequeueOutputBuffer(BufferInfo info, long timeoutUs) {
        int res = this.native_dequeueOutputBuffer(info, timeoutUs);
        Object object = this.mBufferLock;
        synchronized (object) {
            if (res == -3) {
                this.cacheBuffers(false);
            } else if (res >= 0) {
                this.validateOutputByteBuffer(this.mCachedOutputBuffers, res, info);
                if (this.mHasSurface) {
                    this.mDequeuedOutputInfos.put(res, info.dup());
                }
            }
        }
        return res;
    }

    private final int $$robo$$android_media_MediaCodec$native_dequeueOutputBuffer(BufferInfo bufferInfo, long l) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$releaseOutputBuffer(int index, boolean render) {
        BufferInfo info = null;
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.remove(index);
            if (this.mHasSurface) {
                info = this.mDequeuedOutputInfos.remove(index);
            }
        }
        this.releaseOutputBuffer(index, render, false, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$releaseOutputBuffer(int index, long renderTimestampNs) {
        BufferInfo info = null;
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.remove(index);
            if (this.mHasSurface) {
                info = this.mDequeuedOutputInfos.remove(index);
            }
        }
        this.releaseOutputBuffer(index, true, true, renderTimestampNs);
    }

    private final void $$robo$$android_media_MediaCodec$releaseOutputBuffer(int n, boolean bl, boolean bl2, long l) {
    }

    private final void $$robo$$android_media_MediaCodec$signalEndOfInputStream() {
    }

    private final MediaFormat $$robo$$android_media_MediaCodec$getOutputFormat() {
        return new MediaFormat(this.getFormatNative(false));
    }

    private final MediaFormat $$robo$$android_media_MediaCodec$getInputFormat() {
        return new MediaFormat(this.getFormatNative(true));
    }

    private final MediaFormat $$robo$$android_media_MediaCodec$getOutputFormat(int index) {
        return new MediaFormat(this.getOutputFormatNative(index));
    }

    private final Map<String, Object> $$robo$$android_media_MediaCodec$getFormatNative(boolean bl) {
        return null;
    }

    private final Map<String, Object> $$robo$$android_media_MediaCodec$getOutputFormatNative(int n) {
        return null;
    }

    private final void $$robo$$android_media_MediaCodec$invalidateByteBuffer(ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(false);
        }
    }

    private final void $$robo$$android_media_MediaCodec$validateInputByteBuffer(ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$revalidateByteBuffer(ByteBuffer[] buffers, int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            ByteBuffer buffer;
            if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
                buffer.setAccessible(true);
            }
        }
    }

    private final void $$robo$$android_media_MediaCodec$validateOutputByteBuffer(ByteBuffer[] buffers, int index, BufferInfo info) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.limit(info.offset + info.size).position(info.offset);
        }
    }

    private final void $$robo$$android_media_MediaCodec$invalidateByteBuffers(ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                if (buffer == null) continue;
                buffer.setAccessible(false);
            }
        }
    }

    private final void $$robo$$android_media_MediaCodec$freeByteBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            NioUtils.freeDirectBuffer(buffer);
        }
    }

    private final void $$robo$$android_media_MediaCodec$freeByteBuffers(ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                this.freeByteBuffer(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$freeAllTrackedBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.freeByteBuffers(this.mCachedInputBuffers);
            this.freeByteBuffers(this.mCachedOutputBuffers);
            this.mCachedInputBuffers = null;
            this.mCachedOutputBuffers = null;
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
    }

    private final void $$robo$$android_media_MediaCodec$cacheBuffers(boolean input) {
        ByteBuffer[] buffers = null;
        try {
            buffers = this.getBuffers(input);
            this.invalidateByteBuffers(buffers);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (input) {
            this.mCachedInputBuffers = buffers;
        } else {
            this.mCachedOutputBuffers = buffers;
        }
    }

    private final ByteBuffer[] $$robo$$android_media_MediaCodec$getInputBuffers() {
        if (this.mCachedInputBuffers == null) {
            throw new IllegalStateException();
        }
        return this.mCachedInputBuffers;
    }

    private final ByteBuffer[] $$robo$$android_media_MediaCodec$getOutputBuffers() {
        if (this.mCachedOutputBuffers == null) {
            throw new IllegalStateException();
        }
        return this.mCachedOutputBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer $$robo$$android_media_MediaCodec$getInputBuffer(int index) {
        ByteBuffer newBuffer = this.getBuffer(true, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Image $$robo$$android_media_MediaCodec$getInputImage(int index) {
        Image newImage = this.getImage(true, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.put(index, newImage);
        }
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer $$robo$$android_media_MediaCodec$getOutputBuffer(int index) {
        ByteBuffer newBuffer = this.getBuffer(false, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Image $$robo$$android_media_MediaCodec$getOutputImage(int index) {
        Image newImage = this.getImage(false, index);
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.put(index, newImage);
        }
        return newImage;
    }

    private final void $$robo$$android_media_MediaCodec$setVideoScalingMode(int n) {
    }

    private final String $$robo$$android_media_MediaCodec$getName() {
        return null;
    }

    private final PersistableBundle $$robo$$android_media_MediaCodec$getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private final PersistableBundle $$robo$$android_media_MediaCodec$native_getMetrics() {
        return null;
    }

    private final void $$robo$$android_media_MediaCodec$setParameters(Bundle params) {
        if (params == null) {
            return;
        }
        String[] keys = new String[params.size()];
        Object[] values = new Object[params.size()];
        int i = 0;
        Iterator<String> iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            keys[i] = key = iterator.next();
            values[i] = params.get(key);
            ++i;
        }
        this.setParameters(keys, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$setCallback(Callback cb, Handler handler) {
        if (cb != null) {
            Object object = this.mListenerLock;
            synchronized (object) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mCallbackHandler);
                if (newHandler != this.mCallbackHandler) {
                    this.mCallbackHandler.removeMessages(2);
                    this.mCallbackHandler.removeMessages(1);
                    this.mCallbackHandler = newHandler;
                }
            }
        } else if (this.mCallbackHandler != null) {
            this.mCallbackHandler.removeMessages(2);
            this.mCallbackHandler.removeMessages(1);
        }
        if (this.mCallbackHandler != null) {
            Message msg = this.mCallbackHandler.obtainMessage(2, 0, 0, cb);
            this.mCallbackHandler.sendMessage(msg);
            this.native_setCallback(cb);
        }
    }

    private final void $$robo$$android_media_MediaCodec$setCallback(Callback cb) {
        this.setCallback(cb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$setOnFrameRenderedListener(OnFrameRenderedListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mOnFrameRenderedListener = listener;
            if (listener != null) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mOnFrameRenderedHandler);
                if (newHandler != this.mOnFrameRenderedHandler) {
                    this.mOnFrameRenderedHandler.removeMessages(3);
                }
                this.mOnFrameRenderedHandler = newHandler;
            } else if (this.mOnFrameRenderedHandler != null) {
                this.mOnFrameRenderedHandler.removeMessages(3);
            }
            this.native_enableOnFrameRenderedListener(listener != null);
        }
    }

    private final void $$robo$$android_media_MediaCodec$native_enableOnFrameRenderedListener(boolean bl) {
    }

    private final EventHandler $$robo$$android_media_MediaCodec$getEventHandlerOn(Handler handler, EventHandler lastHandler) {
        if (handler == null) {
            return this.mEventHandler;
        }
        Looper looper = handler.getLooper();
        if (lastHandler.getLooper() == looper) {
            return lastHandler;
        }
        return new EventHandler(this, this, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaCodec$postEventFromNative(int what, int arg1, int arg2, Object obj) {
        Object object = this.mListenerLock;
        synchronized (object) {
            EventHandler handler = this.mEventHandler;
            if (what == 1) {
                handler = this.mCallbackHandler;
            } else if (what == 3) {
                handler = this.mOnFrameRenderedHandler;
            }
            if (handler != null) {
                Message msg = handler.obtainMessage(what, arg1, arg2, obj);
                handler.sendMessage(msg);
            }
        }
    }

    private final void $$robo$$android_media_MediaCodec$setParameters(String[] stringArray, Object[] objectArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MediaCodecInfo $$robo$$android_media_MediaCodec$getCodecInfo() {
        String name = this.getName();
        Object object = this.mCodecInfoLock;
        synchronized (object) {
            if (this.mCodecInfo == null) {
                this.mCodecInfo = this.getOwnCodecInfo();
                if (this.mCodecInfo == null) {
                    this.mCodecInfo = MediaCodecList.getInfoFor(name);
                }
            }
            return this.mCodecInfo;
        }
    }

    private final MediaCodecInfo $$robo$$android_media_MediaCodec$getOwnCodecInfo() {
        return null;
    }

    private final ByteBuffer[] $$robo$$android_media_MediaCodec$getBuffers(boolean bl) {
        return null;
    }

    private final ByteBuffer $$robo$$android_media_MediaCodec$getBuffer(boolean bl, int n) {
        return null;
    }

    private final Image $$robo$$android_media_MediaCodec$getImage(boolean bl, int n) {
        return null;
    }

    private static final void $$robo$$android_media_MediaCodec$native_init() {
    }

    private final void $$robo$$android_media_MediaCodec$native_setup(String string2, boolean bl, boolean bl2) {
    }

    private final void $$robo$$android_media_MediaCodec$native_finalize() {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaCodec.native_init();
    }

    public static MediaCodec createDecoderByType(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createDecoderByType", $$robo$$android_media_MediaCodec$createDecoderByType(java.lang.String ), (String)string2);
    }

    public static MediaCodec createEncoderByType(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createEncoderByType", $$robo$$android_media_MediaCodec$createEncoderByType(java.lang.String ), (String)string2);
    }

    public static MediaCodec createByCodecName(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createByCodecName", $$robo$$android_media_MediaCodec$createByCodecName(java.lang.String ), (String)string2);
    }

    private void __constructor__(String string2, boolean bl, boolean bl2) {
        this.$$robo$$android_media_MediaCodec$__constructor__(string2, bl, bl2);
    }

    public MediaCodec(String string2, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec$__constructor__(java.lang.String boolean boolean ), this, string2, bl, bl2);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaCodec$finalize(), this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_media_MediaCodec$reset(), this);
    }

    private void native_reset() {
        InvokeDynamicSupport.bootstrap("native_reset", $$robo$$android_media_MediaCodec$native_reset(), this);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaCodec$release(), this);
    }

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_MediaCodec$native_release(), this);
    }

    public void configure(MediaFormat mediaFormat, Surface surface, MediaCrypto mediaCrypto, int n) {
        InvokeDynamicSupport.bootstrap("configure", $$robo$$android_media_MediaCodec$configure(android.media.MediaFormat android.view.Surface android.media.MediaCrypto int ), this, mediaFormat, surface, mediaCrypto, n);
    }

    public void configure(MediaFormat mediaFormat, Surface surface, int n, MediaDescrambler mediaDescrambler) {
        InvokeDynamicSupport.bootstrap("configure", $$robo$$android_media_MediaCodec$configure(android.media.MediaFormat android.view.Surface int android.media.MediaDescrambler ), this, mediaFormat, surface, n, mediaDescrambler);
    }

    private void configure(MediaFormat mediaFormat, Surface surface, MediaCrypto mediaCrypto, IHwBinder iHwBinder, int n) {
        InvokeDynamicSupport.bootstrap("configure", $$robo$$android_media_MediaCodec$configure(android.media.MediaFormat android.view.Surface android.media.MediaCrypto android.os.IHwBinder int ), this, mediaFormat, surface, mediaCrypto, iHwBinder, n);
    }

    public void setOutputSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setOutputSurface", $$robo$$android_media_MediaCodec$setOutputSurface(android.view.Surface ), this, surface);
    }

    private void native_setSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("native_setSurface", $$robo$$android_media_MediaCodec$native_setSurface(android.view.Surface ), this, surface);
    }

    public static Surface createPersistentInputSurface() {
        return InvokeDynamicSupport.bootstrapStatic("createPersistentInputSurface", $$robo$$android_media_MediaCodec$createPersistentInputSurface());
    }

    public void setInputSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setInputSurface", $$robo$$android_media_MediaCodec$setInputSurface(android.view.Surface ), this, surface);
    }

    private static PersistentSurface native_createPersistentInputSurface() {
        return InvokeDynamicSupport.bootstrapStatic("native_createPersistentInputSurface", $$robo$$android_media_MediaCodec$native_createPersistentInputSurface());
    }

    private static void native_releasePersistentInputSurface(Surface surface) {
        InvokeDynamicSupport.bootstrapStatic("native_releasePersistentInputSurface", $$robo$$android_media_MediaCodec$native_releasePersistentInputSurface(android.view.Surface ), (Surface)surface);
    }

    private void native_setInputSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("native_setInputSurface", $$robo$$android_media_MediaCodec$native_setInputSurface(android.view.Surface ), this, surface);
    }

    private void native_setCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("native_setCallback", $$robo$$android_media_MediaCodec$native_setCallback(android.media.MediaCodec$Callback ), this, callback);
    }

    private void native_configure(String[] stringArray, Object[] objectArray, Surface surface, MediaCrypto mediaCrypto, IHwBinder iHwBinder, int n) {
        InvokeDynamicSupport.bootstrap("native_configure", $$robo$$android_media_MediaCodec$native_configure(java.lang.String[] java.lang.Object[] android.view.Surface android.media.MediaCrypto android.os.IHwBinder int ), this, stringArray, objectArray, surface, mediaCrypto, iHwBinder, n);
    }

    public Surface createInputSurface() {
        return InvokeDynamicSupport.bootstrap("createInputSurface", $$robo$$android_media_MediaCodec$createInputSurface(), this);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_media_MediaCodec$start(), this);
    }

    private void native_start() {
        InvokeDynamicSupport.bootstrap("native_start", $$robo$$android_media_MediaCodec$native_start(), this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_MediaCodec$stop(), this);
    }

    private void native_stop() {
        InvokeDynamicSupport.bootstrap("native_stop", $$robo$$android_media_MediaCodec$native_stop(), this);
    }

    public void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_media_MediaCodec$flush(), this);
    }

    private void native_flush() {
        InvokeDynamicSupport.bootstrap("native_flush", $$robo$$android_media_MediaCodec$native_flush(), this);
    }

    public void queueInputBuffer(int n, int n2, int n3, long l, int n4) throws CryptoException {
        InvokeDynamicSupport.bootstrap("queueInputBuffer", $$robo$$android_media_MediaCodec$queueInputBuffer(int int int long int ), this, n, n2, n3, l, n4);
    }

    private void native_queueInputBuffer(int n, int n2, int n3, long l, int n4) throws CryptoException {
        InvokeDynamicSupport.bootstrap("native_queueInputBuffer", $$robo$$android_media_MediaCodec$native_queueInputBuffer(int int int long int ), this, n, n2, n3, l, n4);
    }

    public void queueSecureInputBuffer(int n, int n2, CryptoInfo cryptoInfo, long l, int n3) throws CryptoException {
        InvokeDynamicSupport.bootstrap("queueSecureInputBuffer", $$robo$$android_media_MediaCodec$queueSecureInputBuffer(int int android.media.MediaCodec$CryptoInfo long int ), this, n, n2, cryptoInfo, l, n3);
    }

    private void native_queueSecureInputBuffer(int n, int n2, CryptoInfo cryptoInfo, long l, int n3) throws CryptoException {
        InvokeDynamicSupport.bootstrap("native_queueSecureInputBuffer", $$robo$$android_media_MediaCodec$native_queueSecureInputBuffer(int int android.media.MediaCodec$CryptoInfo long int ), this, n, n2, cryptoInfo, l, n3);
    }

    public int dequeueInputBuffer(long l) {
        return (int)InvokeDynamicSupport.bootstrap("dequeueInputBuffer", $$robo$$android_media_MediaCodec$dequeueInputBuffer(long ), this, l);
    }

    private int native_dequeueInputBuffer(long l) {
        return (int)InvokeDynamicSupport.bootstrap("native_dequeueInputBuffer", $$robo$$android_media_MediaCodec$native_dequeueInputBuffer(long ), this, l);
    }

    public int dequeueOutputBuffer(BufferInfo bufferInfo, long l) {
        return (int)InvokeDynamicSupport.bootstrap("dequeueOutputBuffer", $$robo$$android_media_MediaCodec$dequeueOutputBuffer(android.media.MediaCodec$BufferInfo long ), this, bufferInfo, l);
    }

    private int native_dequeueOutputBuffer(BufferInfo bufferInfo, long l) {
        return (int)InvokeDynamicSupport.bootstrap("native_dequeueOutputBuffer", $$robo$$android_media_MediaCodec$native_dequeueOutputBuffer(android.media.MediaCodec$BufferInfo long ), this, bufferInfo, l);
    }

    public void releaseOutputBuffer(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("releaseOutputBuffer", $$robo$$android_media_MediaCodec$releaseOutputBuffer(int boolean ), this, n, bl);
    }

    public void releaseOutputBuffer(int n, long l) {
        InvokeDynamicSupport.bootstrap("releaseOutputBuffer", $$robo$$android_media_MediaCodec$releaseOutputBuffer(int long ), this, n, l);
    }

    private void releaseOutputBuffer(int n, boolean bl, boolean bl2, long l) {
        InvokeDynamicSupport.bootstrap("releaseOutputBuffer", $$robo$$android_media_MediaCodec$releaseOutputBuffer(int boolean boolean long ), this, n, bl, bl2, l);
    }

    public void signalEndOfInputStream() {
        InvokeDynamicSupport.bootstrap("signalEndOfInputStream", $$robo$$android_media_MediaCodec$signalEndOfInputStream(), this);
    }

    public MediaFormat getOutputFormat() {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_media_MediaCodec$getOutputFormat(), this);
    }

    public MediaFormat getInputFormat() {
        return InvokeDynamicSupport.bootstrap("getInputFormat", $$robo$$android_media_MediaCodec$getInputFormat(), this);
    }

    public MediaFormat getOutputFormat(int n) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_media_MediaCodec$getOutputFormat(int ), this, n);
    }

    private Map<String, Object> getFormatNative(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getFormatNative", $$robo$$android_media_MediaCodec$getFormatNative(boolean ), this, bl);
    }

    private Map<String, Object> getOutputFormatNative(int n) {
        return InvokeDynamicSupport.bootstrap("getOutputFormatNative", $$robo$$android_media_MediaCodec$getOutputFormatNative(int ), this, n);
    }

    private void invalidateByteBuffer(ByteBuffer[] byteBufferArray, int n) {
        InvokeDynamicSupport.bootstrap("invalidateByteBuffer", $$robo$$android_media_MediaCodec$invalidateByteBuffer(java.nio.ByteBuffer[] int ), this, byteBufferArray, n);
    }

    private void validateInputByteBuffer(ByteBuffer[] byteBufferArray, int n) {
        InvokeDynamicSupport.bootstrap("validateInputByteBuffer", $$robo$$android_media_MediaCodec$validateInputByteBuffer(java.nio.ByteBuffer[] int ), this, byteBufferArray, n);
    }

    private void revalidateByteBuffer(ByteBuffer[] byteBufferArray, int n) {
        InvokeDynamicSupport.bootstrap("revalidateByteBuffer", $$robo$$android_media_MediaCodec$revalidateByteBuffer(java.nio.ByteBuffer[] int ), this, byteBufferArray, n);
    }

    private void validateOutputByteBuffer(ByteBuffer[] byteBufferArray, int n, BufferInfo bufferInfo) {
        InvokeDynamicSupport.bootstrap("validateOutputByteBuffer", $$robo$$android_media_MediaCodec$validateOutputByteBuffer(java.nio.ByteBuffer[] int android.media.MediaCodec$BufferInfo ), this, byteBufferArray, n, bufferInfo);
    }

    private void invalidateByteBuffers(ByteBuffer[] byteBufferArray) {
        InvokeDynamicSupport.bootstrap("invalidateByteBuffers", $$robo$$android_media_MediaCodec$invalidateByteBuffers(java.nio.ByteBuffer[] ), this, byteBufferArray);
    }

    private void freeByteBuffer(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("freeByteBuffer", $$robo$$android_media_MediaCodec$freeByteBuffer(java.nio.ByteBuffer ), this, byteBuffer);
    }

    private void freeByteBuffers(ByteBuffer[] byteBufferArray) {
        InvokeDynamicSupport.bootstrap("freeByteBuffers", $$robo$$android_media_MediaCodec$freeByteBuffers(java.nio.ByteBuffer[] ), this, byteBufferArray);
    }

    private void freeAllTrackedBuffers() {
        InvokeDynamicSupport.bootstrap("freeAllTrackedBuffers", $$robo$$android_media_MediaCodec$freeAllTrackedBuffers(), this);
    }

    private void cacheBuffers(boolean bl) {
        InvokeDynamicSupport.bootstrap("cacheBuffers", $$robo$$android_media_MediaCodec$cacheBuffers(boolean ), this, bl);
    }

    public ByteBuffer[] getInputBuffers() {
        return InvokeDynamicSupport.bootstrap("getInputBuffers", $$robo$$android_media_MediaCodec$getInputBuffers(), this);
    }

    public ByteBuffer[] getOutputBuffers() {
        return InvokeDynamicSupport.bootstrap("getOutputBuffers", $$robo$$android_media_MediaCodec$getOutputBuffers(), this);
    }

    public ByteBuffer getInputBuffer(int n) {
        return InvokeDynamicSupport.bootstrap("getInputBuffer", $$robo$$android_media_MediaCodec$getInputBuffer(int ), this, n);
    }

    public Image getInputImage(int n) {
        return InvokeDynamicSupport.bootstrap("getInputImage", $$robo$$android_media_MediaCodec$getInputImage(int ), this, n);
    }

    public ByteBuffer getOutputBuffer(int n) {
        return InvokeDynamicSupport.bootstrap("getOutputBuffer", $$robo$$android_media_MediaCodec$getOutputBuffer(int ), this, n);
    }

    public Image getOutputImage(int n) {
        return InvokeDynamicSupport.bootstrap("getOutputImage", $$robo$$android_media_MediaCodec$getOutputImage(int ), this, n);
    }

    public void setVideoScalingMode(int n) {
        InvokeDynamicSupport.bootstrap("setVideoScalingMode", $$robo$$android_media_MediaCodec$setVideoScalingMode(int ), this, n);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaCodec$getName(), this);
    }

    public PersistableBundle getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_media_MediaCodec$getMetrics(), this);
    }

    private PersistableBundle native_getMetrics() {
        return InvokeDynamicSupport.bootstrap("native_getMetrics", $$robo$$android_media_MediaCodec$native_getMetrics(), this);
    }

    public void setParameters(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setParameters", $$robo$$android_media_MediaCodec$setParameters(android.os.Bundle ), this, bundle);
    }

    public void setCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_MediaCodec$setCallback(android.media.MediaCodec$Callback android.os.Handler ), this, callback, handler);
    }

    public void setCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_MediaCodec$setCallback(android.media.MediaCodec$Callback ), this, callback);
    }

    public void setOnFrameRenderedListener(OnFrameRenderedListener onFrameRenderedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnFrameRenderedListener", $$robo$$android_media_MediaCodec$setOnFrameRenderedListener(android.media.MediaCodec$OnFrameRenderedListener android.os.Handler ), this, onFrameRenderedListener, handler);
    }

    private void native_enableOnFrameRenderedListener(boolean bl) {
        InvokeDynamicSupport.bootstrap("native_enableOnFrameRenderedListener", $$robo$$android_media_MediaCodec$native_enableOnFrameRenderedListener(boolean ), this, bl);
    }

    private EventHandler getEventHandlerOn(Handler handler, EventHandler eventHandler) {
        return InvokeDynamicSupport.bootstrap("getEventHandlerOn", $$robo$$android_media_MediaCodec$getEventHandlerOn(android.os.Handler android.media.MediaCodec$EventHandler ), this, handler, eventHandler);
    }

    private void postEventFromNative(int n, int n2, int n3, Object object) {
        InvokeDynamicSupport.bootstrap("postEventFromNative", $$robo$$android_media_MediaCodec$postEventFromNative(int int int java.lang.Object ), this, n, n2, n3, object);
    }

    private void setParameters(String[] stringArray, Object[] objectArray) {
        InvokeDynamicSupport.bootstrap("setParameters", $$robo$$android_media_MediaCodec$setParameters(java.lang.String[] java.lang.Object[] ), this, stringArray, objectArray);
    }

    public MediaCodecInfo getCodecInfo() {
        return InvokeDynamicSupport.bootstrap("getCodecInfo", $$robo$$android_media_MediaCodec$getCodecInfo(), this);
    }

    private MediaCodecInfo getOwnCodecInfo() {
        return InvokeDynamicSupport.bootstrap("getOwnCodecInfo", $$robo$$android_media_MediaCodec$getOwnCodecInfo(), this);
    }

    private ByteBuffer[] getBuffers(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getBuffers", $$robo$$android_media_MediaCodec$getBuffers(boolean ), this, bl);
    }

    private ByteBuffer getBuffer(boolean bl, int n) {
        return InvokeDynamicSupport.bootstrap("getBuffer", $$robo$$android_media_MediaCodec$getBuffer(boolean int ), this, bl, n);
    }

    private Image getImage(boolean bl, int n) {
        return InvokeDynamicSupport.bootstrap("getImage", $$robo$$android_media_MediaCodec$getImage(boolean int ), this, bl, n);
    }

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaCodec$native_init());
    }

    private void native_setup(String string2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaCodec$native_setup(java.lang.String boolean boolean ), this, string2, bl, bl2);
    }

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaCodec$native_finalize(), this);
    }

    static {
        RobolectricInternals.classInitializing(MediaCodec.class);
    }

    public /* synthetic */ MediaCodec() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaCodec)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MetricsConstants
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static String CODEC = "android.media.mediacodec.codec";
        public static String MIME_TYPE = "android.media.mediacodec.mime";
        public static String MODE = "android.media.mediacodec.mode";
        public static String MODE_AUDIO = "audio";
        public static String MODE_VIDEO = "video";
        public static String ENCODER = "android.media.mediacodec.encoder";
        public static String SECURE = "android.media.mediacodec.secure";
        public static String WIDTH = "android.media.mediacodec.width";
        public static String HEIGHT = "android.media.mediacodec.height";
        public static String ROTATION = "android.media.mediacodec.rotation";

        private void $$robo$$android_media_MediaCodec_MetricsConstants$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodec_MetricsConstants$__constructor__();
        }

        public MetricsConstants() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_MetricsConstants$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MetricsConstants)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MediaImage
    extends Image
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mIsReadOnly;
        private int mWidth;
        private int mHeight;
        private int mFormat;
        private long mTimestamp;
        private Image.Plane[] mPlanes;
        private ByteBuffer mBuffer;
        private ByteBuffer mInfo;
        private int mXOffset;
        private int mYOffset;
        private static int TYPE_YUV = 1;
        private int mTransform = 0;
        private int mScalingMode = 0;

        private final int $$robo$$android_media_MediaCodec_MediaImage$getFormat() {
            this.throwISEIfImageIsInvalid();
            return this.mFormat;
        }

        private final int $$robo$$android_media_MediaCodec_MediaImage$getHeight() {
            this.throwISEIfImageIsInvalid();
            return this.mHeight;
        }

        private final int $$robo$$android_media_MediaCodec_MediaImage$getWidth() {
            this.throwISEIfImageIsInvalid();
            return this.mWidth;
        }

        private final int $$robo$$android_media_MediaCodec_MediaImage$getTransform() {
            this.throwISEIfImageIsInvalid();
            return 0;
        }

        private final int $$robo$$android_media_MediaCodec_MediaImage$getScalingMode() {
            this.throwISEIfImageIsInvalid();
            return 0;
        }

        private final long $$robo$$android_media_MediaCodec_MediaImage$getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        private final Image.Plane[] $$robo$$android_media_MediaCodec_MediaImage$getPlanes() {
            this.throwISEIfImageIsInvalid();
            return Arrays.copyOf(this.mPlanes, this.mPlanes.length);
        }

        private final void $$robo$$android_media_MediaCodec_MediaImage$close() {
            if (this.mIsImageValid) {
                NioUtils.freeDirectBuffer(this.mBuffer);
                this.mIsImageValid = false;
            }
        }

        private final void $$robo$$android_media_MediaCodec_MediaImage$setCropRect(Rect cropRect) {
            if (this.mIsReadOnly) {
                throw new ReadOnlyBufferException();
            }
            super.setCropRect(cropRect);
        }

        private void $$robo$$android_media_MediaCodec_MediaImage$__constructor__(ByteBuffer buffer, ByteBuffer info, boolean readOnly, long timestamp, int xOffset, int yOffset, Rect cropRect) {
            this.mTransform = 0;
            this.mScalingMode = 0;
            this.mFormat = 35;
            this.mTimestamp = timestamp;
            this.mIsImageValid = true;
            this.mIsReadOnly = buffer.isReadOnly();
            this.mBuffer = buffer.duplicate();
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            this.mInfo = info;
            if (info.remaining() == 104) {
                int type = info.getInt();
                if (type != 1) {
                    throw new UnsupportedOperationException("unsupported type: " + type);
                }
                int numPlanes = info.getInt();
                if (numPlanes != 3) {
                    throw new RuntimeException("unexpected number of planes: " + numPlanes);
                }
                this.mWidth = info.getInt();
                this.mHeight = info.getInt();
                if (this.mWidth < 1 || this.mHeight < 1) {
                    throw new UnsupportedOperationException("unsupported size: " + this.mWidth + "x" + this.mHeight);
                }
                int bitDepth = info.getInt();
                if (bitDepth != 8) {
                    throw new UnsupportedOperationException("unsupported bit depth: " + bitDepth);
                }
                int bitDepthAllocated = info.getInt();
                if (bitDepthAllocated != 8) {
                    throw new UnsupportedOperationException("unsupported allocated bit depth: " + bitDepthAllocated);
                }
                this.mPlanes = new MediaPlane[numPlanes];
                for (int ix = 0; ix < numPlanes; ++ix) {
                    int vert;
                    int planeOffset = info.getInt();
                    int colInc = info.getInt();
                    int rowInc = info.getInt();
                    int horiz = info.getInt();
                    if (horiz != (vert = info.getInt()) || horiz != (ix == 0 ? 1 : 2)) {
                        throw new UnsupportedOperationException("unexpected subsampling: " + horiz + "x" + vert + " on plane " + ix);
                    }
                    if (colInc < 1 || rowInc < 1) {
                        throw new UnsupportedOperationException("unexpected strides: " + colInc + " pixel, " + rowInc + " row on plane " + ix);
                    }
                    buffer.clear();
                    buffer.position(this.mBuffer.position() + planeOffset + xOffset / horiz * colInc + yOffset / vert * rowInc);
                    buffer.limit(buffer.position() + Utils.divUp(bitDepth, 8) + (this.mHeight / vert - 1) * rowInc + (this.mWidth / horiz - 1) * colInc);
                    this.mPlanes[ix] = new MediaPlane(this, buffer.slice(), rowInc, colInc);
                }
            } else {
                throw new UnsupportedOperationException("unsupported info length: " + info.remaining());
            }
            if (cropRect == null) {
                cropRect = new Rect(0, 0, this.mWidth, this.mHeight);
            }
            cropRect.offset(-xOffset, -yOffset);
            super.setCropRect(cropRect);
        }

        @Override
        public int getFormat() {
            return (int)InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_MediaCodec_MediaImage$getFormat(), this);
        }

        @Override
        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_media_MediaCodec_MediaImage$getHeight(), this);
        }

        @Override
        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_media_MediaCodec_MediaImage$getWidth(), this);
        }

        @Override
        public int getTransform() {
            return (int)InvokeDynamicSupport.bootstrap("getTransform", $$robo$$android_media_MediaCodec_MediaImage$getTransform(), this);
        }

        @Override
        public int getScalingMode() {
            return (int)InvokeDynamicSupport.bootstrap("getScalingMode", $$robo$$android_media_MediaCodec_MediaImage$getScalingMode(), this);
        }

        @Override
        public long getTimestamp() {
            return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_MediaCodec_MediaImage$getTimestamp(), this);
        }

        @Override
        public Image.Plane[] getPlanes() {
            return InvokeDynamicSupport.bootstrap("getPlanes", $$robo$$android_media_MediaCodec_MediaImage$getPlanes(), this);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaCodec_MediaImage$close(), this);
        }

        @Override
        public void setCropRect(Rect rect) {
            InvokeDynamicSupport.bootstrap("setCropRect", $$robo$$android_media_MediaCodec_MediaImage$setCropRect(android.graphics.Rect ), this, rect);
        }

        private void __constructor__(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl, long l, int n, int n2, Rect rect) {
            this.$$robo$$android_media_MediaCodec_MediaImage$__constructor__(byteBuffer, byteBuffer2, bl, l, n, n2, rect);
        }

        public MediaImage(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl, long l, int n, int n2, Rect rect) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_MediaImage$__constructor__(java.nio.ByteBuffer java.nio.ByteBuffer boolean long int int android.graphics.Rect ), this, byteBuffer, byteBuffer2, bl, l, n, n2, rect);
        }

        public /* synthetic */ MediaImage() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaImage)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class MediaPlane
        extends Image.Plane
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mRowInc;
            private int mColInc;
            private ByteBuffer mData;
            /* synthetic */ MediaImage this$0;

            private void $$robo$$android_media_MediaCodec_MediaImage_MediaPlane$__constructor__(MediaImage mediaImage, ByteBuffer buffer, int rowInc, int colInc) {
                this.this$0 = mediaImage;
                this.mData = buffer;
                this.mRowInc = rowInc;
                this.mColInc = colInc;
            }

            private final int $$robo$$android_media_MediaCodec_MediaImage_MediaPlane$getRowStride() {
                this.this$0.throwISEIfImageIsInvalid();
                return this.mRowInc;
            }

            private final int $$robo$$android_media_MediaCodec_MediaImage_MediaPlane$getPixelStride() {
                this.this$0.throwISEIfImageIsInvalid();
                return this.mColInc;
            }

            private final ByteBuffer $$robo$$android_media_MediaCodec_MediaImage_MediaPlane$getBuffer() {
                this.this$0.throwISEIfImageIsInvalid();
                return this.mData;
            }

            private void __constructor__(MediaImage mediaImage, ByteBuffer byteBuffer, int n, int n2) {
                this.$$robo$$android_media_MediaCodec_MediaImage_MediaPlane$__constructor__(mediaImage, byteBuffer, n, n2);
            }

            public MediaPlane(MediaImage mediaImage, ByteBuffer byteBuffer, int n, int n2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_MediaImage_MediaPlane$__constructor__(android.media.MediaCodec$MediaImage java.nio.ByteBuffer int int ), this, mediaImage, byteBuffer, n, n2);
            }

            @Override
            public int getRowStride() {
                return (int)InvokeDynamicSupport.bootstrap("getRowStride", $$robo$$android_media_MediaCodec_MediaImage_MediaPlane$getRowStride(), this);
            }

            @Override
            public int getPixelStride() {
                return (int)InvokeDynamicSupport.bootstrap("getPixelStride", $$robo$$android_media_MediaCodec_MediaImage_MediaPlane$getPixelStride(), this);
            }

            @Override
            public ByteBuffer getBuffer() {
                return InvokeDynamicSupport.bootstrap("getBuffer", $$robo$$android_media_MediaCodec_MediaImage_MediaPlane$getBuffer(), this);
            }

            public /* synthetic */ MediaPlane() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaPlane)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_MediaCodec_Callback$__constructor__() {
        }

        public abstract void onInputBufferAvailable(MediaCodec var1, int var2);

        public abstract void onOutputBufferAvailable(MediaCodec var1, int var2, BufferInfo var3);

        public abstract void onError(MediaCodec var1, CodecException var2);

        public abstract void onOutputFormatChanged(MediaCodec var1, MediaFormat var2);

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodec_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_Callback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnFrameRenderedListener {
        public void onFrameRendered(MediaCodec var1, long var2, long var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoScalingMode {
    }

    private static class BufferMap
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Map<Integer, CodecBuffer> mMap;

        private void $$robo$$android_media_MediaCodec_BufferMap$__constructor__() {
            this.mMap = new HashMap<Integer, CodecBuffer>();
        }

        private final void $$robo$$android_media_MediaCodec_BufferMap$remove(int index) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer != null) {
                buffer.free();
                this.mMap.remove(index);
            }
        }

        private final void $$robo$$android_media_MediaCodec_BufferMap$put(int index, ByteBuffer newBuffer) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer(null);
                this.mMap.put(index, buffer);
            }
            buffer.setByteBuffer(newBuffer);
        }

        private final void $$robo$$android_media_MediaCodec_BufferMap$put(int index, Image newImage) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer(null);
                this.mMap.put(index, buffer);
            }
            buffer.setImage(newImage);
        }

        private final void $$robo$$android_media_MediaCodec_BufferMap$clear() {
            for (CodecBuffer buffer : this.mMap.values()) {
                buffer.free();
            }
            this.mMap.clear();
        }

        private /* synthetic */ void $$robo$$android_media_MediaCodec_BufferMap$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodec_BufferMap$__constructor__();
        }

        public BufferMap() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_BufferMap$__constructor__(), this);
        }

        public void remove(int n) {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_media_MediaCodec_BufferMap$remove(int ), this, n);
        }

        public void put(int n, ByteBuffer byteBuffer) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_media_MediaCodec_BufferMap$put(int java.nio.ByteBuffer ), this, n, byteBuffer);
        }

        public void put(int n, Image image) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_media_MediaCodec_BufferMap$put(int android.media.Image ), this, n, image);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_media_MediaCodec_BufferMap$clear(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_media_MediaCodec_BufferMap$__constructor__(var1_1);
        }

        public /* synthetic */ BufferMap(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_BufferMap$__constructor__(android.media.MediaCodec$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BufferMap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class CodecBuffer
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private Image mImage;
            private ByteBuffer mByteBuffer;

            private void $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$__constructor__() {
            }

            private final void $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$free() {
                if (this.mByteBuffer != null) {
                    NioUtils.freeDirectBuffer(this.mByteBuffer);
                    this.mByteBuffer = null;
                }
                if (this.mImage != null) {
                    this.mImage.close();
                    this.mImage = null;
                }
            }

            private final void $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$setImage(Image image) {
                this.free();
                this.mImage = image;
            }

            private final void $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$setByteBuffer(ByteBuffer buffer) {
                this.free();
                this.mByteBuffer = buffer;
            }

            private /* synthetic */ void $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$__constructor__();
            }

            public CodecBuffer() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$__constructor__(), this);
            }

            public void free() {
                InvokeDynamicSupport.bootstrap("free", $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$free(), this);
            }

            public void setImage(Image image) {
                InvokeDynamicSupport.bootstrap("setImage", $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$setImage(android.media.Image ), this, image);
            }

            public void setByteBuffer(ByteBuffer byteBuffer) {
                InvokeDynamicSupport.bootstrap("setByteBuffer", $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$setByteBuffer(java.nio.ByteBuffer ), this, byteBuffer);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$__constructor__(var1_1);
            }

            public /* synthetic */ CodecBuffer(1 var1_1) {
                this();
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_BufferMap_CodecBuffer$__constructor__(android.media.MediaCodec$1 ), this, var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CodecBuffer)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OutputBufferInfo {
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CryptoInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int numSubSamples;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public byte[] key;
        public byte[] iv;
        public int mode;
        private Pattern zeroPattern;
        private Pattern pattern;

        private void $$robo$$android_media_MediaCodec_CryptoInfo$__constructor__() {
            this.zeroPattern = new Pattern(0, 0);
        }

        private final void $$robo$$android_media_MediaCodec_CryptoInfo$set(int newNumSubSamples, int[] newNumBytesOfClearData, int[] newNumBytesOfEncryptedData, byte[] newKey, byte[] newIV, int newMode) {
            this.numSubSamples = newNumSubSamples;
            this.numBytesOfClearData = newNumBytesOfClearData;
            this.numBytesOfEncryptedData = newNumBytesOfEncryptedData;
            this.key = newKey;
            this.iv = newIV;
            this.mode = newMode;
            this.pattern = this.zeroPattern;
        }

        private final void $$robo$$android_media_MediaCodec_CryptoInfo$setPattern(Pattern newPattern) {
            this.pattern = newPattern;
        }

        private final void $$robo$$android_media_MediaCodec_CryptoInfo$setPattern(int blocksToEncrypt, int blocksToSkip) {
            this.pattern = new Pattern(blocksToEncrypt, blocksToSkip);
        }

        private final String $$robo$$android_media_MediaCodec_CryptoInfo$toString() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append(this.numSubSamples + " subsamples, key [");
            String hexdigits = "0123456789abcdef";
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.key[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.key[i] & 0xF));
            }
            builder.append("], iv [");
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.iv[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.iv[i] & 0xF));
            }
            builder.append("], clear ");
            builder.append(Arrays.toString(this.numBytesOfClearData));
            builder.append(", encrypted ");
            builder.append(Arrays.toString(this.numBytesOfEncryptedData));
            return builder.toString();
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodec_CryptoInfo$__constructor__();
        }

        public CryptoInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_CryptoInfo$__constructor__(), this);
        }

        public void set(int n, int[] nArray, int[] nArray2, byte[] byArray, byte[] byArray2, int n2) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_media_MediaCodec_CryptoInfo$set(int int[] int[] byte[] byte[] int ), this, n, nArray, nArray2, byArray, byArray2, n2);
        }

        public void setPattern(Pattern pattern) {
            InvokeDynamicSupport.bootstrap("setPattern", $$robo$$android_media_MediaCodec_CryptoInfo$setPattern(android.media.MediaCodec$CryptoInfo$Pattern ), this, pattern);
        }

        private void setPattern(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setPattern", $$robo$$android_media_MediaCodec_CryptoInfo$setPattern(int int ), this, n, n2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaCodec_CryptoInfo$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CryptoInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Pattern
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mEncryptBlocks;
            private int mSkipBlocks;

            private void $$robo$$android_media_MediaCodec_CryptoInfo_Pattern$__constructor__(int blocksToEncrypt, int blocksToSkip) {
                this.set(blocksToEncrypt, blocksToSkip);
            }

            private final void $$robo$$android_media_MediaCodec_CryptoInfo_Pattern$set(int blocksToEncrypt, int blocksToSkip) {
                this.mEncryptBlocks = blocksToEncrypt;
                this.mSkipBlocks = blocksToSkip;
            }

            private final int $$robo$$android_media_MediaCodec_CryptoInfo_Pattern$getSkipBlocks() {
                return this.mSkipBlocks;
            }

            private final int $$robo$$android_media_MediaCodec_CryptoInfo_Pattern$getEncryptBlocks() {
                return this.mEncryptBlocks;
            }

            private void __constructor__(int n, int n2) {
                this.$$robo$$android_media_MediaCodec_CryptoInfo_Pattern$__constructor__(n, n2);
            }

            public Pattern(int n, int n2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_CryptoInfo_Pattern$__constructor__(int int ), this, n, n2);
            }

            public void set(int n, int n2) {
                InvokeDynamicSupport.bootstrap("set", $$robo$$android_media_MediaCodec_CryptoInfo_Pattern$set(int int ), this, n, n2);
            }

            public int getSkipBlocks() {
                return (int)InvokeDynamicSupport.bootstrap("getSkipBlocks", $$robo$$android_media_MediaCodec_CryptoInfo_Pattern$getSkipBlocks(), this);
            }

            public int getEncryptBlocks() {
                return (int)InvokeDynamicSupport.bootstrap("getEncryptBlocks", $$robo$$android_media_MediaCodec_CryptoInfo_Pattern$getEncryptBlocks(), this);
            }

            public /* synthetic */ Pattern() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Pattern)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CryptoException
    extends RuntimeException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int ERROR_NO_KEY = 1;
        public static int ERROR_KEY_EXPIRED = 2;
        public static int ERROR_RESOURCE_BUSY = 3;
        public static int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        public static int ERROR_SESSION_NOT_OPENED = 5;
        public static int ERROR_UNSUPPORTED_OPERATION = 6;
        private int mErrorCode;

        private void $$robo$$android_media_MediaCodec_CryptoException$__constructor__(int errorCode, String detailMessage) {
            this.mErrorCode = errorCode;
        }

        private final int $$robo$$android_media_MediaCodec_CryptoException$getErrorCode() {
            return this.mErrorCode;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_media_MediaCodec_CryptoException$__constructor__(n, string2);
        }

        public CryptoException(int n, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_CryptoException$__constructor__(int java.lang.String ), this, n, string2);
        }

        public int getErrorCode() {
            return (int)InvokeDynamicSupport.bootstrap("getErrorCode", $$robo$$android_media_MediaCodec_CryptoException$getErrorCode(), this);
        }

        public /* synthetic */ CryptoException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CryptoException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CryptoErrorCode {
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CodecException
    extends IllegalStateException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int ERROR_INSUFFICIENT_RESOURCE = 1100;
        public static int ERROR_RECLAIMED = 1101;
        private static int ACTION_TRANSIENT = 1;
        private static int ACTION_RECOVERABLE = 2;
        private String mDiagnosticInfo;
        private int mErrorCode;
        private int mActionCode;

        private void $$robo$$android_media_MediaCodec_CodecException$__constructor__(int errorCode, int actionCode, String detailMessage) {
            this.mErrorCode = errorCode;
            this.mActionCode = actionCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaCodec.error_" + sign + Math.abs(errorCode);
        }

        private final boolean $$robo$$android_media_MediaCodec_CodecException$isTransient() {
            return this.mActionCode == 1;
        }

        private final boolean $$robo$$android_media_MediaCodec_CodecException$isRecoverable() {
            return this.mActionCode == 2;
        }

        private final int $$robo$$android_media_MediaCodec_CodecException$getErrorCode() {
            return this.mErrorCode;
        }

        private final String $$robo$$android_media_MediaCodec_CodecException$getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }

        private void __constructor__(int n, int n2, String string2) {
            this.$$robo$$android_media_MediaCodec_CodecException$__constructor__(n, n2, string2);
        }

        public CodecException(int n, int n2, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_CodecException$__constructor__(int int java.lang.String ), this, n, n2, string2);
        }

        public boolean isTransient() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTransient", $$robo$$android_media_MediaCodec_CodecException$isTransient(), this);
        }

        public boolean isRecoverable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRecoverable", $$robo$$android_media_MediaCodec_CodecException$isRecoverable(), this);
        }

        public int getErrorCode() {
            return (int)InvokeDynamicSupport.bootstrap("getErrorCode", $$robo$$android_media_MediaCodec_CodecException$getErrorCode(), this);
        }

        public String getDiagnosticInfo() {
            return InvokeDynamicSupport.bootstrap("getDiagnosticInfo", $$robo$$android_media_MediaCodec_CodecException$getDiagnosticInfo(), this);
        }

        public /* synthetic */ CodecException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CodecException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ReasonCode {
        }
    }

    public static class PersistentSurface
    extends Surface
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mPersistentObject;

        private void $$robo$$android_media_MediaCodec_PersistentSurface$__constructor__() {
        }

        private final void $$robo$$android_media_MediaCodec_PersistentSurface$release() {
            MediaCodec.native_releasePersistentInputSurface(this);
            super.release();
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodec_PersistentSurface$__constructor__();
        }

        public PersistentSurface() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_PersistentSurface$__constructor__(), this);
        }

        @Override
        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaCodec_PersistentSurface$release(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PersistentSurface)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigureFlag {
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private MediaCodec mCodec;
        /* synthetic */ MediaCodec this$0;

        private void $$robo$$android_media_MediaCodec_EventHandler$__constructor__(MediaCodec mediaCodec, MediaCodec codec, Looper looper) {
            this.this$0 = mediaCodec;
            this.mCodec = codec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaCodec_EventHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.handleCallback(msg);
                    break;
                }
                case 2: {
                    this.this$0.mCallback = (Callback)msg.obj;
                    break;
                }
                case 3: {
                    Object object = this.this$0.mListenerLock;
                    synchronized (object) {
                        Map map = (Map)msg.obj;
                        int i = 0;
                        while (true) {
                            Object mediaTimeUs = map.get(i + "-media-time-us");
                            Object systemNano = map.get(i + "-system-nano");
                            if (mediaTimeUs == null || systemNano == null || this.this$0.mOnFrameRenderedListener == null) break;
                            this.this$0.mOnFrameRenderedListener.onFrameRendered(this.mCodec, (Long)mediaTimeUs, (Long)systemNano);
                            ++i;
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaCodec_EventHandler$handleCallback(Message msg) {
            if (this.this$0.mCallback == null) {
                return;
            }
            switch (msg.arg1) {
                case 1: {
                    int index = msg.arg2;
                    Object object = this.this$0.mBufferLock;
                    synchronized (object) {
                        this.this$0.validateInputByteBuffer(this.this$0.mCachedInputBuffers, index);
                    }
                    this.this$0.mCallback.onInputBufferAvailable(this.mCodec, index);
                    break;
                }
                case 2: {
                    int index = msg.arg2;
                    BufferInfo info = (BufferInfo)msg.obj;
                    Object object = this.this$0.mBufferLock;
                    synchronized (object) {
                        this.this$0.validateOutputByteBuffer(this.this$0.mCachedOutputBuffers, index, info);
                    }
                    this.this$0.mCallback.onOutputBufferAvailable(this.mCodec, index, info);
                    break;
                }
                case 3: {
                    this.this$0.mCallback.onError(this.mCodec, (CodecException)msg.obj);
                    break;
                }
                case 4: {
                    this.this$0.mCallback.onOutputFormatChanged(this.mCodec, new MediaFormat((Map)msg.obj));
                    break;
                }
            }
        }

        private void __constructor__(MediaCodec mediaCodec, MediaCodec mediaCodec2, Looper looper) {
            this.$$robo$$android_media_MediaCodec_EventHandler$__constructor__(mediaCodec, mediaCodec2, looper);
        }

        public EventHandler(MediaCodec mediaCodec, MediaCodec mediaCodec2, Looper looper) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_EventHandler$__constructor__(android.media.MediaCodec android.media.MediaCodec android.os.Looper ), this, mediaCodec, mediaCodec2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaCodec_EventHandler$handleMessage(android.os.Message ), this, message);
        }

        private void handleCallback(Message message) {
            InvokeDynamicSupport.bootstrap("handleCallback", $$robo$$android_media_MediaCodec_EventHandler$handleCallback(android.os.Message ), this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BufferFlag {
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class BufferInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int offset;
        public int size;
        public long presentationTimeUs;
        public int flags;

        private void $$robo$$android_media_MediaCodec_BufferInfo$__constructor__() {
        }

        private final void $$robo$$android_media_MediaCodec_BufferInfo$set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            this.offset = newOffset;
            this.size = newSize;
            this.presentationTimeUs = newTimeUs;
            this.flags = newFlags;
        }

        private final BufferInfo $$robo$$android_media_MediaCodec_BufferInfo$dup() {
            BufferInfo copy = new BufferInfo();
            copy.set(this.offset, this.size, this.presentationTimeUs, this.flags);
            return copy;
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodec_BufferInfo$__constructor__();
        }

        public BufferInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodec_BufferInfo$__constructor__(), this);
        }

        public void set(int n, int n2, long l, int n3) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_media_MediaCodec_BufferInfo$set(int int long int ), this, n, n2, l, n3);
        }

        public BufferInfo dup() {
            return InvokeDynamicSupport.bootstrap("dup", $$robo$$android_media_MediaCodec_BufferInfo$dup(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BufferInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

