/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IMediaHTTPConnection;
import android.media.IMediaHTTPService;
import android.media.MediaHTTPConnection;
import android.os.IBinder;
import android.util.Log;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaHTTPService
extends IMediaHTTPService.Stub
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaHTTPService";
    private List<HttpCookie> mCookies;
    private Boolean mCookieStoreInitialized;

    private void $$robo$$android_media_MediaHTTPService$__constructor__(List<HttpCookie> cookies) {
        this.mCookieStoreInitialized = new Boolean(false);
        this.mCookies = cookies;
        Log.v("MediaHTTPService", "MediaHTTPService(" + this + "): Cookies: " + cookies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IMediaHTTPConnection $$robo$$android_media_MediaHTTPService$makeHTTPConnection() {
        Boolean bl = this.mCookieStoreInitialized;
        synchronized (bl) {
            if (!this.mCookieStoreInitialized.booleanValue()) {
                CookieHandler cookieHandler = CookieHandler.getDefault();
                if (cookieHandler == null) {
                    cookieHandler = new CookieManager();
                    CookieHandler.setDefault(cookieHandler);
                    Log.v("MediaHTTPService", "makeHTTPConnection: CookieManager created: " + cookieHandler);
                } else {
                    Log.v("MediaHTTPService", "makeHTTPConnection: CookieHandler (" + cookieHandler + ") exists.");
                }
                if (this.mCookies != null) {
                    if (cookieHandler instanceof CookieManager) {
                        CookieManager cookieManager = (CookieManager)cookieHandler;
                        CookieStore store = cookieManager.getCookieStore();
                        for (HttpCookie cookie : this.mCookies) {
                            try {
                                store.add(null, cookie);
                            }
                            catch (Exception e) {
                                Log.v("MediaHTTPService", "makeHTTPConnection: CookieStore.add" + e);
                            }
                        }
                    } else {
                        Log.w("MediaHTTPService", "makeHTTPConnection: The installed CookieHandler is not a CookieManager. Can\u2019t add the provided cookies to the cookie store.");
                    }
                }
                this.mCookieStoreInitialized = true;
                Log.v("MediaHTTPService", "makeHTTPConnection(" + this + "): cookieHandler: " + cookieHandler + " Cookies: " + this.mCookies);
            }
        }
        return new MediaHTTPConnection();
    }

    private static final IBinder $$robo$$android_media_MediaHTTPService$createHttpServiceBinderIfNecessary(String path) {
        return MediaHTTPService.createHttpServiceBinderIfNecessary(path, null);
    }

    private static final IBinder $$robo$$android_media_MediaHTTPService$createHttpServiceBinderIfNecessary(String path, List<HttpCookie> cookies) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            return new MediaHTTPService(cookies).asBinder();
        }
        if (path.startsWith("widevine://")) {
            Log.d("MediaHTTPService", "Widevine classic is no longer supported");
        }
        return null;
    }

    private void __constructor__(List<HttpCookie> list) {
        this.$$robo$$android_media_MediaHTTPService$__constructor__(list);
    }

    public MediaHTTPService(List<HttpCookie> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaHTTPService$__constructor__(java.util.List<java.net.HttpCookie> ), this, list);
    }

    @Override
    public IMediaHTTPConnection makeHTTPConnection() {
        return InvokeDynamicSupport.bootstrap("makeHTTPConnection", $$robo$$android_media_MediaHTTPService$makeHTTPConnection(), this);
    }

    static IBinder createHttpServiceBinderIfNecessary(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createHttpServiceBinderIfNecessary", $$robo$$android_media_MediaHTTPService$createHttpServiceBinderIfNecessary(java.lang.String ), (String)string2);
    }

    static IBinder createHttpServiceBinderIfNecessary(String string2, List<HttpCookie> list) {
        return InvokeDynamicSupport.bootstrapStatic("createHttpServiceBinderIfNecessary", $$robo$$android_media_MediaHTTPService$createHttpServiceBinderIfNecessary(java.lang.String java.util.List<java.net.HttpCookie> ), (String)string2, list);
    }

    public /* synthetic */ MediaHTTPService() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaHTTPService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

