/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.IMediaScannerListener;
import android.media.IMediaScannerService;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaScannerConnection
implements ServiceConnection,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaScannerConnection";
    private Context mContext;
    private MediaScannerConnectionClient mClient;
    private IMediaScannerService mService;
    private boolean mConnected;
    private IMediaScannerListener.Stub mListener;

    private void $$robo$$android_media_MediaScannerConnection$__constructor__(Context context, MediaScannerConnectionClient client) {
        this.mListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaScannerConnection this$0;

            private void $$robo$$android_media_MediaScannerConnection_1$__constructor__(MediaScannerConnection this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_media_MediaScannerConnection_1$scanCompleted(String path, Uri uri) {
                MediaScannerConnectionClient client = this.this$0.mClient;
                if (client != null) {
                    client.onScanCompleted(path, uri);
                }
            }

            private void __constructor__(MediaScannerConnection mediaScannerConnection) {
                this.$$robo$$android_media_MediaScannerConnection_1$__constructor__(mediaScannerConnection);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScannerConnection_1$__constructor__(android.media.MediaScannerConnection ), this, mediaScannerConnection);
            }

            @Override
            public void scanCompleted(String string2, Uri uri) {
                InvokeDynamicSupport.bootstrap("scanCompleted", $$robo$$android_media_MediaScannerConnection_1$scanCompleted(java.lang.String android.net.Uri ), this, string2, uri);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScannerConnection$connect() {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            if (!this.mConnected) {
                Intent intent = new Intent(IMediaScannerService.class.getName());
                intent.setComponent(new ComponentName("com.android.providers.media", "com.android.providers.media.MediaScannerService"));
                this.mContext.bindService(intent, this, 1);
                this.mConnected = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScannerConnection$disconnect() {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            if (this.mConnected) {
                try {
                    this.mContext.unbindService(this);
                    if (this.mClient instanceof ClientProxy) {
                        this.mClient = null;
                    }
                    this.mService = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.mConnected = false;
            }
        }
    }

    private final synchronized boolean $$robo$$android_media_MediaScannerConnection$isConnected() {
        return this.mService != null && this.mConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScannerConnection$scanFile(String path, String mimeType) {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            if (this.mService == null || !this.mConnected) {
                throw new IllegalStateException("not connected to MediaScannerService");
            }
            try {
                this.mService.requestScanFile(path, mimeType, this.mListener);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private static final void $$robo$$android_media_MediaScannerConnection$scanFile(Context context, String[] paths, String[] mimeTypes, OnScanCompletedListener callback) {
        MediaScannerConnection connection;
        ClientProxy client = new ClientProxy(paths, mimeTypes, callback);
        client.mConnection = connection = new MediaScannerConnection(context, client);
        connection.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScannerConnection$onServiceConnected(ComponentName className, IBinder service) {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            this.mService = IMediaScannerService.Stub.asInterface(service);
            if (this.mService != null && this.mClient != null) {
                this.mClient.onMediaScannerConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScannerConnection$onServiceDisconnected(ComponentName className) {
        MediaScannerConnection mediaScannerConnection = this;
        synchronized (mediaScannerConnection) {
            this.mService = null;
        }
    }

    private void __constructor__(Context context, MediaScannerConnectionClient mediaScannerConnectionClient) {
        this.$$robo$$android_media_MediaScannerConnection$__constructor__(context, mediaScannerConnectionClient);
    }

    public MediaScannerConnection(Context context, MediaScannerConnectionClient mediaScannerConnectionClient) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScannerConnection$__constructor__(android.content.Context android.media.MediaScannerConnection$MediaScannerConnectionClient ), this, context, mediaScannerConnectionClient);
    }

    public void connect() {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_media_MediaScannerConnection$connect(), this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_media_MediaScannerConnection$disconnect(), this);
    }

    public synchronized boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_media_MediaScannerConnection$isConnected(), this);
    }

    public void scanFile(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("scanFile", $$robo$$android_media_MediaScannerConnection$scanFile(java.lang.String java.lang.String ), this, string2, string3);
    }

    public static void scanFile(Context context, String[] stringArray, String[] stringArray2, OnScanCompletedListener onScanCompletedListener) {
        InvokeDynamicSupport.bootstrapStatic("scanFile", $$robo$$android_media_MediaScannerConnection$scanFile(android.content.Context java.lang.String[] java.lang.String[] android.media.MediaScannerConnection$OnScanCompletedListener ), (Context)context, (String[])stringArray, (String[])stringArray2, (OnScanCompletedListener)onScanCompletedListener);
    }

    @Override
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_media_MediaScannerConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
    }

    @Override
    public void onServiceDisconnected(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_media_MediaScannerConnection$onServiceDisconnected(android.content.ComponentName ), this, componentName);
    }

    public /* synthetic */ MediaScannerConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaScannerConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ClientProxy
    implements MediaScannerConnectionClient,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String[] mPaths;
        String[] mMimeTypes;
        OnScanCompletedListener mClient;
        MediaScannerConnection mConnection;
        int mNextPath;

        private void $$robo$$android_media_MediaScannerConnection_ClientProxy$__constructor__(String[] paths, String[] mimeTypes, OnScanCompletedListener client) {
            this.mPaths = paths;
            this.mMimeTypes = mimeTypes;
            this.mClient = client;
        }

        private final void $$robo$$android_media_MediaScannerConnection_ClientProxy$onMediaScannerConnected() {
            this.scanNextPath();
        }

        private final void $$robo$$android_media_MediaScannerConnection_ClientProxy$onScanCompleted(String path, Uri uri) {
            if (this.mClient != null) {
                this.mClient.onScanCompleted(path, uri);
            }
            this.scanNextPath();
        }

        private final void $$robo$$android_media_MediaScannerConnection_ClientProxy$scanNextPath() {
            if (this.mNextPath >= this.mPaths.length) {
                this.mConnection.disconnect();
                this.mConnection = null;
                return;
            }
            String mimeType = this.mMimeTypes != null ? this.mMimeTypes[this.mNextPath] : null;
            this.mConnection.scanFile(this.mPaths[this.mNextPath], mimeType);
            ++this.mNextPath;
        }

        private void __constructor__(String[] stringArray, String[] stringArray2, OnScanCompletedListener onScanCompletedListener) {
            this.$$robo$$android_media_MediaScannerConnection_ClientProxy$__constructor__(stringArray, stringArray2, onScanCompletedListener);
        }

        public ClientProxy(String[] stringArray, String[] stringArray2, OnScanCompletedListener onScanCompletedListener) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScannerConnection_ClientProxy$__constructor__(java.lang.String[] java.lang.String[] android.media.MediaScannerConnection$OnScanCompletedListener ), this, stringArray, stringArray2, onScanCompletedListener);
        }

        @Override
        public void onMediaScannerConnected() {
            InvokeDynamicSupport.bootstrap("onMediaScannerConnected", $$robo$$android_media_MediaScannerConnection_ClientProxy$onMediaScannerConnected(), this);
        }

        @Override
        public void onScanCompleted(String string2, Uri uri) {
            InvokeDynamicSupport.bootstrap("onScanCompleted", $$robo$$android_media_MediaScannerConnection_ClientProxy$onScanCompleted(java.lang.String android.net.Uri ), this, string2, uri);
        }

        void scanNextPath() {
            InvokeDynamicSupport.bootstrap("scanNextPath", $$robo$$android_media_MediaScannerConnection_ClientProxy$scanNextPath(), this);
        }

        public /* synthetic */ ClientProxy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClientProxy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface MediaScannerConnectionClient
    extends OnScanCompletedListener {
        public void onMediaScannerConnected();

        @Override
        public void onScanCompleted(String var1, Uri var2);
    }

    public static interface OnScanCompletedListener {
        public void onScanCompleted(String var1, Uri var2);
    }
}

