/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Equalizer
extends AudioEffect
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Equalizer";
    public static int PARAM_NUM_BANDS = 0;
    public static int PARAM_LEVEL_RANGE = 1;
    public static int PARAM_BAND_LEVEL = 2;
    public static int PARAM_CENTER_FREQ = 3;
    public static int PARAM_BAND_FREQ_RANGE = 4;
    public static int PARAM_GET_BAND = 5;
    public static int PARAM_CURRENT_PRESET = 6;
    public static int PARAM_GET_NUM_OF_PRESETS = 7;
    public static int PARAM_GET_PRESET_NAME = 8;
    private static int PARAM_PROPERTIES = 9;
    public static int PARAM_STRING_SIZE_MAX = 32;
    private short mNumBands;
    private int mNumPresets;
    private String[] mPresetNames;
    private OnParameterChangeListener mParamListener;
    private BaseParameterListener mBaseParamListener;
    private Object mParamListenerLock;

    private void $$robo$$android_media_audiofx_Equalizer$__constructor__(int priority, int audioSession) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        this.mNumBands = 0;
        this.mParamListener = null;
        this.mBaseParamListener = null;
        this.mParamListenerLock = new Object();
        if (audioSession == 0) {
            Log.w("Equalizer", "WARNING: attaching an Equalizer to global output mix is deprecated!");
        }
        this.getNumberOfBands();
        this.mNumPresets = this.getNumberOfPresets();
        if (this.mNumPresets != 0) {
            this.mPresetNames = new String[this.mNumPresets];
            byte[] value = new byte[32];
            int[] param = new int[2];
            param[0] = 8;
            for (int i = 0; i < this.mNumPresets; ++i) {
                param[1] = i;
                this.checkStatus(this.getParameter(param, value));
                int length = 0;
                while (value[length] != 0) {
                    ++length;
                }
                try {
                    this.mPresetNames[i] = new String(value, 0, length, "ISO-8859-1");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    Log.e("Equalizer", "preset name decode error");
                }
            }
        }
    }

    private final short $$robo$$android_media_audiofx_Equalizer$getNumberOfBands() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (this.mNumBands != 0) {
            return this.mNumBands;
        }
        int[] param = new int[]{0};
        short[] result = new short[1];
        this.checkStatus(this.getParameter(param, result));
        this.mNumBands = result[0];
        return this.mNumBands;
    }

    private final short[] $$robo$$android_media_audiofx_Equalizer$getBandLevelRange() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] result = new short[2];
        this.checkStatus(this.getParameter(1, result));
        return result;
    }

    private final void $$robo$$android_media_audiofx_Equalizer$setBandLevel(short band, short level) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] param = new int[2];
        short[] value = new short[1];
        param[0] = 2;
        param[1] = band;
        value[0] = level;
        this.checkStatus(this.setParameter(param, value));
    }

    private final short $$robo$$android_media_audiofx_Equalizer$getBandLevel(short band) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] param = new int[2];
        short[] result = new short[1];
        param[0] = 2;
        param[1] = band;
        this.checkStatus(this.getParameter(param, result));
        return result[0];
    }

    private final int $$robo$$android_media_audiofx_Equalizer$getCenterFreq(short band) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] param = new int[2];
        int[] result = new int[1];
        param[0] = 3;
        param[1] = band;
        this.checkStatus(this.getParameter(param, result));
        return result[0];
    }

    private final int[] $$robo$$android_media_audiofx_Equalizer$getBandFreqRange(short band) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] param = new int[2];
        int[] result = new int[2];
        param[0] = 4;
        param[1] = band;
        this.checkStatus(this.getParameter(param, result));
        return result;
    }

    private final short $$robo$$android_media_audiofx_Equalizer$getBand(int frequency) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] param = new int[2];
        short[] result = new short[1];
        param[0] = 5;
        param[1] = frequency;
        this.checkStatus(this.getParameter(param, result));
        return result[0];
    }

    private final short $$robo$$android_media_audiofx_Equalizer$getCurrentPreset() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] result = new short[1];
        this.checkStatus(this.getParameter(6, result));
        return result[0];
    }

    private final void $$robo$$android_media_audiofx_Equalizer$usePreset(short preset) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(6, preset));
    }

    private final short $$robo$$android_media_audiofx_Equalizer$getNumberOfPresets() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] result = new short[1];
        this.checkStatus(this.getParameter(7, result));
        return result[0];
    }

    private final String $$robo$$android_media_audiofx_Equalizer$getPresetName(short preset) {
        if (preset >= 0 && preset < this.mNumPresets) {
            return this.mPresetNames[preset];
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_Equalizer$setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = listener;
                this.mBaseParamListener = new BaseParameterListener(this, null);
                super.setParameterListener(this.mBaseParamListener);
            }
        }
    }

    private final Settings $$robo$$android_media_audiofx_Equalizer$getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[4 + this.mNumBands * 2];
        this.checkStatus(this.getParameter(9, param));
        Settings settings = new Settings();
        settings.curPreset = Equalizer.byteArrayToShort(param, 0);
        settings.numBands = Equalizer.byteArrayToShort(param, 2);
        settings.bandLevels = new short[this.mNumBands];
        for (int i = 0; i < this.mNumBands; ++i) {
            settings.bandLevels[i] = Equalizer.byteArrayToShort(param, 4 + 2 * i);
        }
        return settings;
    }

    private final void $$robo$$android_media_audiofx_Equalizer$setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (settings.numBands != settings.bandLevels.length || settings.numBands != this.mNumBands) {
            throw new IllegalArgumentException("settings invalid band count: " + settings.numBands);
        }
        byte[] param = Equalizer.concatArrays(Equalizer.shortToByteArray(settings.curPreset), Equalizer.shortToByteArray(this.mNumBands));
        for (int i = 0; i < this.mNumBands; ++i) {
            param = Equalizer.concatArrays(param, Equalizer.shortToByteArray(settings.bandLevels[i]));
        }
        this.checkStatus(this.setParameter(9, param));
    }

    private void __constructor__(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        this.$$robo$$android_media_audiofx_Equalizer$__constructor__(n, n2);
    }

    public Equalizer(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_EQUALIZER, EFFECT_TYPE_NULL, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Equalizer$__constructor__(int int ), this, n, n2);
    }

    public short getNumberOfBands() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (short)InvokeDynamicSupport.bootstrap("getNumberOfBands", $$robo$$android_media_audiofx_Equalizer$getNumberOfBands(), this);
    }

    public short[] getBandLevelRange() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return InvokeDynamicSupport.bootstrap("getBandLevelRange", $$robo$$android_media_audiofx_Equalizer$getBandLevelRange(), this);
    }

    public void setBandLevel(short s, short s2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("setBandLevel", $$robo$$android_media_audiofx_Equalizer$setBandLevel(short short ), this, s, s2);
    }

    public short getBandLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (short)InvokeDynamicSupport.bootstrap("getBandLevel", $$robo$$android_media_audiofx_Equalizer$getBandLevel(short ), this, s);
    }

    public int getCenterFreq(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (int)InvokeDynamicSupport.bootstrap("getCenterFreq", $$robo$$android_media_audiofx_Equalizer$getCenterFreq(short ), this, s);
    }

    public int[] getBandFreqRange(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return InvokeDynamicSupport.bootstrap("getBandFreqRange", $$robo$$android_media_audiofx_Equalizer$getBandFreqRange(short ), this, s);
    }

    public short getBand(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (short)InvokeDynamicSupport.bootstrap("getBand", $$robo$$android_media_audiofx_Equalizer$getBand(int ), this, n);
    }

    public short getCurrentPreset() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (short)InvokeDynamicSupport.bootstrap("getCurrentPreset", $$robo$$android_media_audiofx_Equalizer$getCurrentPreset(), this);
    }

    public void usePreset(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("usePreset", $$robo$$android_media_audiofx_Equalizer$usePreset(short ), this, s);
    }

    public short getNumberOfPresets() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return (short)InvokeDynamicSupport.bootstrap("getNumberOfPresets", $$robo$$android_media_audiofx_Equalizer$getNumberOfPresets(), this);
    }

    public String getPresetName(short s) {
        return InvokeDynamicSupport.bootstrap("getPresetName", $$robo$$android_media_audiofx_Equalizer$getPresetName(short ), this, s);
    }

    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        InvokeDynamicSupport.bootstrap("setParameterListener", $$robo$$android_media_audiofx_Equalizer$setParameterListener(android.media.audiofx.Equalizer$OnParameterChangeListener ), this, onParameterChangeListener);
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return InvokeDynamicSupport.bootstrap("getProperties", $$robo$$android_media_audiofx_Equalizer$getProperties(), this);
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("setProperties", $$robo$$android_media_audiofx_Equalizer$setProperties(android.media.audiofx.Equalizer$Settings ), this, settings);
    }

    public /* synthetic */ Equalizer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Equalizer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Settings
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public short curPreset;
        public short numBands;
        public short[] bandLevels;

        private void $$robo$$android_media_audiofx_Equalizer_Settings$__constructor__() {
            this.numBands = 0;
            this.bandLevels = null;
        }

        private void $$robo$$android_media_audiofx_Equalizer_Settings$__constructor__(String settings) {
            this.numBands = 0;
            this.bandLevels = null;
            StringTokenizer st = new StringTokenizer(settings, "=;");
            int tokens = st.countTokens();
            if (st.countTokens() < 5) {
                throw new IllegalArgumentException("settings: " + settings);
            }
            String key = st.nextToken();
            if (!key.equals("Equalizer")) {
                throw new IllegalArgumentException("invalid settings for Equalizer: " + key);
            }
            try {
                key = st.nextToken();
                if (!key.equals("curPreset")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.curPreset = Short.parseShort(st.nextToken());
                key = st.nextToken();
                if (!key.equals("numBands")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.numBands = Short.parseShort(st.nextToken());
                if (st.countTokens() != this.numBands * 2) {
                    throw new IllegalArgumentException("settings: " + settings);
                }
                this.bandLevels = new short[this.numBands];
                for (int i = 0; i < this.numBands; ++i) {
                    key = st.nextToken();
                    if (!key.equals("band" + (i + 1) + "Level")) {
                        throw new IllegalArgumentException("invalid key name: " + key);
                    }
                    this.bandLevels[i] = Short.parseShort(st.nextToken());
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid value for key: " + key);
            }
        }

        private final String $$robo$$android_media_audiofx_Equalizer_Settings$toString() {
            String str = new String("Equalizer;curPreset=" + Short.toString(this.curPreset) + ";numBands=" + Short.toString(this.numBands));
            for (int i = 0; i < this.numBands; ++i) {
                str = str.concat(";band" + (i + 1) + "Level=" + Short.toString(this.bandLevels[i]));
            }
            return str;
        }

        private void __constructor__() {
            this.$$robo$$android_media_audiofx_Equalizer_Settings$__constructor__();
        }

        public Settings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Equalizer_Settings$__constructor__(), this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_audiofx_Equalizer_Settings$__constructor__(string2);
        }

        public Settings(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Equalizer_Settings$__constructor__(java.lang.String ), this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiofx_Equalizer_Settings$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Settings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ Equalizer this$0;

        private void $$robo$$android_media_audiofx_Equalizer_BaseParameterListener$__constructor__(Equalizer equalizer) {
            this.this$0 = equalizer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_audiofx_Equalizer_BaseParameterListener$onParameterChange(AudioEffect effect, int status, byte[] param, byte[] value) {
            OnParameterChangeListener l = null;
            Object object = this.this$0.mParamListenerLock;
            synchronized (object) {
                if (this.this$0.mParamListener != null) {
                    l = this.this$0.mParamListener;
                }
            }
            if (l != null) {
                int p1 = -1;
                int p2 = -1;
                int v = -1;
                if (param.length >= 4) {
                    p1 = AudioEffect.byteArrayToInt(param, 0);
                    if (param.length >= 8) {
                        p2 = AudioEffect.byteArrayToInt(param, 4);
                    }
                }
                if (value.length == 2) {
                    v = AudioEffect.byteArrayToShort(value, 0);
                } else if (value.length == 4) {
                    v = AudioEffect.byteArrayToInt(value, 0);
                }
                if (p1 != -1 && v != -1) {
                    l.onParameterChange(this.this$0, status, p1, p2, v);
                }
            }
        }

        private /* synthetic */ void $$robo$$android_media_audiofx_Equalizer_BaseParameterListener$__constructor__(Equalizer x0, 1 x1) {
        }

        private void __constructor__(Equalizer equalizer) {
            this.$$robo$$android_media_audiofx_Equalizer_BaseParameterListener$__constructor__(equalizer);
        }

        public BaseParameterListener(Equalizer equalizer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Equalizer_BaseParameterListener$__constructor__(android.media.audiofx.Equalizer ), this, equalizer);
        }

        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            InvokeDynamicSupport.bootstrap("onParameterChange", $$robo$$android_media_audiofx_Equalizer_BaseParameterListener$onParameterChange(android.media.audiofx.AudioEffect int byte[] byte[] ), this, audioEffect, n, byArray, byArray2);
        }

        private /* synthetic */ void __constructor__(Equalizer equalizer, 1 var2_2) {
            this.$$robo$$android_media_audiofx_Equalizer_BaseParameterListener$__constructor__(equalizer, var2_2);
        }

        public /* synthetic */ BaseParameterListener(Equalizer equalizer, 1 var2_2) {
            this(equalizer);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_Equalizer_BaseParameterListener$__constructor__(android.media.audiofx.Equalizer android.media.audiofx.Equalizer$1 ), this, equalizer, var2_2);
        }

        public /* synthetic */ BaseParameterListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseParameterListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(Equalizer var1, int var2, int var3, int var4, int var5);
    }
}

