/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.soundtrigger.SoundTriggerDetector;
import android.os.Bundle;
import android.os.Handler;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.app.ISoundTriggerService;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SoundTriggerManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "SoundTriggerManager";
    private Context mContext;
    private ISoundTriggerService mSoundTriggerService;
    private HashMap<UUID, SoundTriggerDetector> mReceiverInstanceMap;
    public static int FLAG_MESSAGE_TYPE_UNKNOWN = -1;
    public static int FLAG_MESSAGE_TYPE_RECOGNITION_EVENT = 0;
    public static int FLAG_MESSAGE_TYPE_RECOGNITION_ERROR = 1;
    public static int FLAG_MESSAGE_TYPE_RECOGNITION_PAUSED = 2;
    public static int FLAG_MESSAGE_TYPE_RECOGNITION_RESUMED = 3;
    public static String EXTRA_MESSAGE_TYPE = "android.media.soundtrigger.MESSAGE_TYPE";
    public static String EXTRA_RECOGNITION_EVENT = "android.media.soundtrigger.RECOGNITION_EVENT";
    public static String EXTRA_STATUS = "android.media.soundtrigger.STATUS";

    private void $$robo$$android_media_soundtrigger_SoundTriggerManager$__constructor__(Context context, ISoundTriggerService soundTriggerService) {
        this.mSoundTriggerService = soundTriggerService;
        this.mContext = context;
        this.mReceiverInstanceMap = new HashMap();
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerManager$updateModel(Model model) {
        try {
            this.mSoundTriggerService.updateSoundModel(model.getGenericSoundModel());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Model $$robo$$android_media_soundtrigger_SoundTriggerManager$getModel(UUID soundModelId) {
        try {
            return new Model(this.mSoundTriggerService.getSoundModel(new ParcelUuid(soundModelId)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerManager$deleteModel(UUID soundModelId) {
        try {
            this.mSoundTriggerService.deleteSoundModel(new ParcelUuid(soundModelId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final SoundTriggerDetector $$robo$$android_media_soundtrigger_SoundTriggerManager$createSoundTriggerDetector(UUID soundModelId, SoundTriggerDetector.Callback callback, Handler handler) {
        if (soundModelId == null) {
            return null;
        }
        SoundTriggerDetector oldInstance = this.mReceiverInstanceMap.get(soundModelId);
        if (oldInstance != null) {
            // empty if block
        }
        SoundTriggerDetector newInstance = new SoundTriggerDetector(this.mSoundTriggerService, soundModelId, callback, handler);
        this.mReceiverInstanceMap.put(soundModelId, newInstance);
        return newInstance;
    }

    private final int $$robo$$android_media_soundtrigger_SoundTriggerManager$loadSoundModel(SoundTrigger.SoundModel soundModel) {
        if (soundModel == null) {
            return Integer.MIN_VALUE;
        }
        try {
            switch (soundModel.type) {
                case 1: {
                    return this.mSoundTriggerService.loadGenericSoundModel((SoundTrigger.GenericSoundModel)soundModel);
                }
                case 0: {
                    return this.mSoundTriggerService.loadKeyphraseSoundModel((SoundTrigger.KeyphraseSoundModel)soundModel);
                }
            }
            Slog.e("SoundTriggerManager", "Unkown model type");
            return Integer.MIN_VALUE;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_soundtrigger_SoundTriggerManager$startRecognition(UUID soundModelId, PendingIntent callbackIntent, SoundTrigger.RecognitionConfig config) {
        if (soundModelId == null || callbackIntent == null || config == null) {
            return Integer.MIN_VALUE;
        }
        try {
            return this.mSoundTriggerService.startRecognitionForIntent(new ParcelUuid(soundModelId), callbackIntent, config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_soundtrigger_SoundTriggerManager$startRecognition(UUID soundModelId, Bundle params, ComponentName detectionService, SoundTrigger.RecognitionConfig config) {
        Preconditions.checkNotNull(soundModelId);
        Preconditions.checkNotNull(detectionService);
        Preconditions.checkNotNull(config);
        try {
            return this.mSoundTriggerService.startRecognitionForService(new ParcelUuid(soundModelId), params, detectionService, config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_soundtrigger_SoundTriggerManager$stopRecognition(UUID soundModelId) {
        if (soundModelId == null) {
            return Integer.MIN_VALUE;
        }
        try {
            return this.mSoundTriggerService.stopRecognitionForIntent(new ParcelUuid(soundModelId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_soundtrigger_SoundTriggerManager$unloadSoundModel(UUID soundModelId) {
        if (soundModelId == null) {
            return Integer.MIN_VALUE;
        }
        try {
            return this.mSoundTriggerService.unloadSoundModel(new ParcelUuid(soundModelId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_soundtrigger_SoundTriggerManager$isRecognitionActive(UUID soundModelId) {
        if (soundModelId == null) {
            return false;
        }
        try {
            return this.mSoundTriggerService.isRecognitionActive(new ParcelUuid(soundModelId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_soundtrigger_SoundTriggerManager$getDetectionServiceOperationsTimeout() {
        try {
            return Settings.Global.getInt(this.mContext.getContentResolver(), "sound_trigger_detection_service_op_timeout");
        }
        catch (Settings.SettingNotFoundException e) {
            return Integer.MAX_VALUE;
        }
    }

    private void __constructor__(Context context, ISoundTriggerService iSoundTriggerService) {
        this.$$robo$$android_media_soundtrigger_SoundTriggerManager$__constructor__(context, iSoundTriggerService);
    }

    public SoundTriggerManager(Context context, ISoundTriggerService iSoundTriggerService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerManager$__constructor__(android.content.Context com.android.internal.app.ISoundTriggerService ), this, context, iSoundTriggerService);
    }

    public void updateModel(Model model) {
        InvokeDynamicSupport.bootstrap("updateModel", $$robo$$android_media_soundtrigger_SoundTriggerManager$updateModel(android.media.soundtrigger.SoundTriggerManager$Model ), this, model);
    }

    public Model getModel(UUID uUID) {
        return InvokeDynamicSupport.bootstrap("getModel", $$robo$$android_media_soundtrigger_SoundTriggerManager$getModel(java.util.UUID ), this, uUID);
    }

    public void deleteModel(UUID uUID) {
        InvokeDynamicSupport.bootstrap("deleteModel", $$robo$$android_media_soundtrigger_SoundTriggerManager$deleteModel(java.util.UUID ), this, uUID);
    }

    public SoundTriggerDetector createSoundTriggerDetector(UUID uUID, SoundTriggerDetector.Callback callback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("createSoundTriggerDetector", $$robo$$android_media_soundtrigger_SoundTriggerManager$createSoundTriggerDetector(java.util.UUID android.media.soundtrigger.SoundTriggerDetector$Callback android.os.Handler ), this, uUID, callback, handler);
    }

    public int loadSoundModel(SoundTrigger.SoundModel soundModel) {
        return (int)InvokeDynamicSupport.bootstrap("loadSoundModel", $$robo$$android_media_soundtrigger_SoundTriggerManager$loadSoundModel(android.hardware.soundtrigger.SoundTrigger$SoundModel ), this, soundModel);
    }

    public int startRecognition(UUID uUID, PendingIntent pendingIntent, SoundTrigger.RecognitionConfig recognitionConfig) {
        return (int)InvokeDynamicSupport.bootstrap("startRecognition", $$robo$$android_media_soundtrigger_SoundTriggerManager$startRecognition(java.util.UUID android.app.PendingIntent android.hardware.soundtrigger.SoundTrigger$RecognitionConfig ), this, uUID, pendingIntent, recognitionConfig);
    }

    public int startRecognition(UUID uUID, Bundle bundle, ComponentName componentName, SoundTrigger.RecognitionConfig recognitionConfig) {
        return (int)InvokeDynamicSupport.bootstrap("startRecognition", $$robo$$android_media_soundtrigger_SoundTriggerManager$startRecognition(java.util.UUID android.os.Bundle android.content.ComponentName android.hardware.soundtrigger.SoundTrigger$RecognitionConfig ), this, uUID, bundle, componentName, recognitionConfig);
    }

    public int stopRecognition(UUID uUID) {
        return (int)InvokeDynamicSupport.bootstrap("stopRecognition", $$robo$$android_media_soundtrigger_SoundTriggerManager$stopRecognition(java.util.UUID ), this, uUID);
    }

    public int unloadSoundModel(UUID uUID) {
        return (int)InvokeDynamicSupport.bootstrap("unloadSoundModel", $$robo$$android_media_soundtrigger_SoundTriggerManager$unloadSoundModel(java.util.UUID ), this, uUID);
    }

    public boolean isRecognitionActive(UUID uUID) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecognitionActive", $$robo$$android_media_soundtrigger_SoundTriggerManager$isRecognitionActive(java.util.UUID ), this, uUID);
    }

    public int getDetectionServiceOperationsTimeout() {
        return (int)InvokeDynamicSupport.bootstrap("getDetectionServiceOperationsTimeout", $$robo$$android_media_soundtrigger_SoundTriggerManager$getDetectionServiceOperationsTimeout(), this);
    }

    public /* synthetic */ SoundTriggerManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundTriggerManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Model
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private SoundTrigger.GenericSoundModel mGenericSoundModel;

        private void $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$__constructor__(SoundTrigger.GenericSoundModel soundTriggerModel) {
            this.mGenericSoundModel = soundTriggerModel;
        }

        private static final Model $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$create(UUID modelUuid, UUID vendorUuid, byte[] data) {
            return new Model(new SoundTrigger.GenericSoundModel(modelUuid, vendorUuid, data));
        }

        private final UUID $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getModelUuid() {
            return this.mGenericSoundModel.uuid;
        }

        private final UUID $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getVendorUuid() {
            return this.mGenericSoundModel.vendorUuid;
        }

        private final byte[] $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getModelData() {
            return this.mGenericSoundModel.data;
        }

        private final SoundTrigger.GenericSoundModel $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getGenericSoundModel() {
            return this.mGenericSoundModel;
        }

        private void __constructor__(SoundTrigger.GenericSoundModel genericSoundModel) {
            this.$$robo$$android_media_soundtrigger_SoundTriggerManager_Model$__constructor__(genericSoundModel);
        }

        public Model(SoundTrigger.GenericSoundModel genericSoundModel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$__constructor__(android.hardware.soundtrigger.SoundTrigger$GenericSoundModel ), this, genericSoundModel);
        }

        public static Model create(UUID uUID, UUID uUID2, byte[] byArray) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$create(java.util.UUID java.util.UUID byte[] ), (UUID)uUID, (UUID)uUID2, (byte[])byArray);
        }

        public UUID getModelUuid() {
            return InvokeDynamicSupport.bootstrap("getModelUuid", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getModelUuid(), this);
        }

        public UUID getVendorUuid() {
            return InvokeDynamicSupport.bootstrap("getVendorUuid", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getVendorUuid(), this);
        }

        public byte[] getModelData() {
            return InvokeDynamicSupport.bootstrap("getModelData", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getModelData(), this);
        }

        SoundTrigger.GenericSoundModel getGenericSoundModel() {
            return InvokeDynamicSupport.bootstrap("getGenericSoundModel", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getGenericSoundModel(), this);
        }

        public /* synthetic */ Model() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Model)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

