/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.HexDump;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IpSecAlgorithm
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "IpSecAlgorithm";
    public static String CRYPT_NULL = "ecb(cipher_null)";
    public static String CRYPT_AES_CBC = "cbc(aes)";
    public static String AUTH_HMAC_MD5 = "hmac(md5)";
    public static String AUTH_HMAC_SHA1 = "hmac(sha1)";
    public static String AUTH_HMAC_SHA256 = "hmac(sha256)";
    public static String AUTH_HMAC_SHA384 = "hmac(sha384)";
    public static String AUTH_HMAC_SHA512 = "hmac(sha512)";
    public static String AUTH_CRYPT_AES_GCM = "rfc4106(gcm(aes))";
    private String mName;
    private byte[] mKey;
    private int mTruncLenBits;
    public static Parcelable.Creator<IpSecAlgorithm> CREATOR;

    private void $$robo$$android_net_IpSecAlgorithm$__constructor__(String algorithm, byte[] key) {
    }

    private void $$robo$$android_net_IpSecAlgorithm$__constructor__(String algorithm, byte[] key, int truncLenBits) {
        this.mName = algorithm;
        this.mKey = (byte[])key.clone();
        this.mTruncLenBits = truncLenBits;
        IpSecAlgorithm.checkValidOrThrow(this.mName, this.mKey.length * 8, this.mTruncLenBits);
    }

    private final String $$robo$$android_net_IpSecAlgorithm$getName() {
        return this.mName;
    }

    private final byte[] $$robo$$android_net_IpSecAlgorithm$getKey() {
        return (byte[])this.mKey.clone();
    }

    private final int $$robo$$android_net_IpSecAlgorithm$getTruncationLengthBits() {
        return this.mTruncLenBits;
    }

    private final int $$robo$$android_net_IpSecAlgorithm$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_IpSecAlgorithm$writeToParcel(Parcel out, int flags) {
        out.writeString(this.mName);
        out.writeByteArray(this.mKey);
        out.writeInt(this.mTruncLenBits);
    }

    private static final void $$robo$$android_net_IpSecAlgorithm$checkValidOrThrow(String name, int keyLen, int truncLen) {
        boolean isValidLen = true;
        boolean isValidTruncLen = true;
        switch (name) {
            case "cbc(aes)": {
                isValidLen = keyLen == 128 || keyLen == 192 || keyLen == 256;
                break;
            }
            case "hmac(md5)": {
                isValidLen = keyLen == 128;
                isValidTruncLen = truncLen >= 96 && truncLen <= 128;
                break;
            }
            case "hmac(sha1)": {
                isValidLen = keyLen == 160;
                isValidTruncLen = truncLen >= 96 && truncLen <= 160;
                break;
            }
            case "hmac(sha256)": {
                isValidLen = keyLen == 256;
                isValidTruncLen = truncLen >= 96 && truncLen <= 256;
                break;
            }
            case "hmac(sha384)": {
                isValidLen = keyLen == 384;
                isValidTruncLen = truncLen >= 192 && truncLen <= 384;
                break;
            }
            case "hmac(sha512)": {
                isValidLen = keyLen == 512;
                isValidTruncLen = truncLen >= 256 && truncLen <= 512;
                break;
            }
            case "rfc4106(gcm(aes))": {
                isValidLen = keyLen == 160 || keyLen == 224 || keyLen == 288;
                isValidTruncLen = truncLen == 64 || truncLen == 96 || truncLen == 128;
                break;
            }
            default: {
                throw new IllegalArgumentException("Couldn't find an algorithm: " + name);
            }
        }
        if (!isValidLen) {
            throw new IllegalArgumentException("Invalid key material keyLength: " + keyLen);
        }
        if (!isValidTruncLen) {
            throw new IllegalArgumentException("Invalid truncation keyLength: " + truncLen);
        }
    }

    private final boolean $$robo$$android_net_IpSecAlgorithm$isAuthentication() {
        switch (this.getName()) {
            case "hmac(md5)": 
            case "hmac(sha1)": 
            case "hmac(sha256)": 
            case "hmac(sha384)": 
            case "hmac(sha512)": {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_IpSecAlgorithm$isEncryption() {
        return this.getName().equals("cbc(aes)");
    }

    private final boolean $$robo$$android_net_IpSecAlgorithm$isAead() {
        return this.getName().equals("rfc4106(gcm(aes))");
    }

    private static final boolean $$robo$$android_net_IpSecAlgorithm$isUnsafeBuild() {
        return Build.IS_DEBUGGABLE && Build.IS_ENG;
    }

    private final String $$robo$$android_net_IpSecAlgorithm$toString() {
        return "{mName=" + this.mName + ", mKey=" + (IpSecAlgorithm.isUnsafeBuild() ? HexDump.toHexString(this.mKey) : "<hidden>") + ", mTruncLenBits=" + this.mTruncLenBits + "}";
    }

    @VisibleForTesting
    private static final boolean $$robo$$android_net_IpSecAlgorithm$equals(IpSecAlgorithm lhs, IpSecAlgorithm rhs) {
        if (lhs == null || rhs == null) {
            return lhs == rhs;
        }
        return lhs.mName.equals(rhs.mName) && Arrays.equals(lhs.mKey, rhs.mKey) && lhs.mTruncLenBits == rhs.mTruncLenBits;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<IpSecAlgorithm>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_IpSecAlgorithm_1$__constructor__() {
            }

            private final IpSecAlgorithm $$robo$$android_net_IpSecAlgorithm_1$createFromParcel(Parcel in) {
                String name = in.readString();
                byte[] key = in.createByteArray();
                int truncLenBits = in.readInt();
                return new IpSecAlgorithm(name, key, truncLenBits);
            }

            private final IpSecAlgorithm[] $$robo$$android_net_IpSecAlgorithm_1$newArray(int size) {
                return new IpSecAlgorithm[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_IpSecAlgorithm_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecAlgorithm_1$__constructor__(), this);
            }

            @Override
            public IpSecAlgorithm createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_IpSecAlgorithm_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public IpSecAlgorithm[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_IpSecAlgorithm_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, byte[] byArray) {
        this.$$robo$$android_net_IpSecAlgorithm$__constructor__(string2, byArray);
    }

    public IpSecAlgorithm(String string2, byte[] byArray) {
        this(string2, byArray, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecAlgorithm$__constructor__(java.lang.String byte[] ), this, string2, byArray);
    }

    private void __constructor__(String string2, byte[] byArray, int n) {
        this.$$robo$$android_net_IpSecAlgorithm$__constructor__(string2, byArray, n);
    }

    public IpSecAlgorithm(String string2, byte[] byArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecAlgorithm$__constructor__(java.lang.String byte[] int ), this, string2, byArray, n);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_net_IpSecAlgorithm$getName(), this);
    }

    public byte[] getKey() {
        return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_net_IpSecAlgorithm$getKey(), this);
    }

    public int getTruncationLengthBits() {
        return (int)InvokeDynamicSupport.bootstrap("getTruncationLengthBits", $$robo$$android_net_IpSecAlgorithm$getTruncationLengthBits(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_IpSecAlgorithm$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_IpSecAlgorithm$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private static void checkValidOrThrow(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkValidOrThrow", $$robo$$android_net_IpSecAlgorithm$checkValidOrThrow(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    public boolean isAuthentication() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAuthentication", $$robo$$android_net_IpSecAlgorithm$isAuthentication(), this);
    }

    public boolean isEncryption() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEncryption", $$robo$$android_net_IpSecAlgorithm$isEncryption(), this);
    }

    public boolean isAead() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAead", $$robo$$android_net_IpSecAlgorithm$isAead(), this);
    }

    private static boolean isUnsafeBuild() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUnsafeBuild", $$robo$$android_net_IpSecAlgorithm$isUnsafeBuild());
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_IpSecAlgorithm$toString(), this);
    }

    public static boolean equals(IpSecAlgorithm ipSecAlgorithm, IpSecAlgorithm ipSecAlgorithm2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equals", $$robo$$android_net_IpSecAlgorithm$equals(android.net.IpSecAlgorithm android.net.IpSecAlgorithm ), (IpSecAlgorithm)ipSecAlgorithm, (IpSecAlgorithm)ipSecAlgorithm2);
    }

    static {
        RobolectricInternals.classInitializing(IpSecAlgorithm.class);
    }

    public /* synthetic */ IpSecAlgorithm() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpSecAlgorithm)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlgorithmName {
    }
}

