/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkUtils;
import android.net.util.IpUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.OsConstants;
import android.util.Log;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeepalivePacketData
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "KeepalivePacketData";
    public InetAddress srcAddress;
    public InetAddress dstAddress;
    public int srcPort;
    public int dstPort;
    private byte[] mPacket;
    private static int IPV4_HEADER_LENGTH = 20;
    private static int UDP_HEADER_LENGTH = 8;
    public static Parcelable.Creator<KeepalivePacketData> CREATOR;

    private void $$robo$$android_net_KeepalivePacketData$__constructor__(InetAddress srcAddress, int srcPort, InetAddress dstAddress, int dstPort, byte[] data) throws InvalidPacketException {
        this.srcAddress = srcAddress;
        this.dstAddress = dstAddress;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
        this.mPacket = data;
        if (srcAddress == null || dstAddress == null || !srcAddress.getClass().getName().equals(dstAddress.getClass().getName())) {
            Log.e("KeepalivePacketData", "Invalid or mismatched InetAddresses in KeepalivePacketData");
            throw new InvalidPacketException(-21);
        }
        if (!IpUtils.isValidUdpOrTcpPort(srcPort) || !IpUtils.isValidUdpOrTcpPort(dstPort)) {
            Log.e("KeepalivePacketData", "Invalid ports in KeepalivePacketData");
            throw new InvalidPacketException(-22);
        }
    }

    private final byte[] $$robo$$android_net_KeepalivePacketData$getPacket() {
        return (byte[])this.mPacket.clone();
    }

    private static final KeepalivePacketData $$robo$$android_net_KeepalivePacketData$nattKeepalivePacket(InetAddress srcAddress, int srcPort, InetAddress dstAddress, int dstPort) throws InvalidPacketException {
        if (!(srcAddress instanceof Inet4Address) || !(dstAddress instanceof Inet4Address)) {
            throw new InvalidPacketException(-21);
        }
        if (dstPort != 4500) {
            throw new InvalidPacketException(-22);
        }
        int length = 29;
        ByteBuffer buf = ByteBuffer.allocate(length);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putShort((short)17664);
        buf.putShort((short)length);
        buf.putInt(0);
        buf.put((byte)64);
        buf.put((byte)OsConstants.IPPROTO_UDP);
        int ipChecksumOffset = buf.position();
        buf.putShort((short)0);
        buf.put(srcAddress.getAddress());
        buf.put(dstAddress.getAddress());
        buf.putShort((short)srcPort);
        buf.putShort((short)dstPort);
        buf.putShort((short)(length - 20));
        int udpChecksumOffset = buf.position();
        buf.putShort((short)0);
        buf.put((byte)-1);
        buf.putShort(ipChecksumOffset, IpUtils.ipChecksum(buf, 0));
        buf.putShort(udpChecksumOffset, IpUtils.udpChecksum(buf, 0, 20));
        return new KeepalivePacketData(srcAddress, srcPort, dstAddress, dstPort, buf.array());
    }

    private final int $$robo$$android_net_KeepalivePacketData$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_KeepalivePacketData$writeToParcel(Parcel out, int flags) {
        out.writeString(this.srcAddress.getHostAddress());
        out.writeString(this.dstAddress.getHostAddress());
        out.writeInt(this.srcPort);
        out.writeInt(this.dstPort);
        out.writeByteArray(this.mPacket);
    }

    private void $$robo$$android_net_KeepalivePacketData$__constructor__(Parcel in) {
        this.srcAddress = NetworkUtils.numericToInetAddress(in.readString());
        this.dstAddress = NetworkUtils.numericToInetAddress(in.readString());
        this.srcPort = in.readInt();
        this.dstPort = in.readInt();
        this.mPacket = in.createByteArray();
    }

    private /* synthetic */ void $$robo$$android_net_KeepalivePacketData$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<KeepalivePacketData>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_KeepalivePacketData_1$__constructor__() {
            }

            private final KeepalivePacketData $$robo$$android_net_KeepalivePacketData_1$createFromParcel(Parcel in) {
                return new KeepalivePacketData(in, null);
            }

            private final KeepalivePacketData[] $$robo$$android_net_KeepalivePacketData_1$newArray(int size) {
                return new KeepalivePacketData[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_KeepalivePacketData_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_KeepalivePacketData_1$__constructor__(), this);
            }

            @Override
            public KeepalivePacketData createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_KeepalivePacketData_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public KeepalivePacketData[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_KeepalivePacketData_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, byte[] byArray) throws InvalidPacketException {
        this.$$robo$$android_net_KeepalivePacketData$__constructor__(inetAddress, n, inetAddress2, n2, byArray);
    }

    public KeepalivePacketData(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, byte[] byArray) throws InvalidPacketException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_KeepalivePacketData$__constructor__(java.net.InetAddress int java.net.InetAddress int byte[] ), this, inetAddress, n, inetAddress2, n2, byArray);
    }

    public byte[] getPacket() {
        return InvokeDynamicSupport.bootstrap("getPacket", $$robo$$android_net_KeepalivePacketData$getPacket(), this);
    }

    public static KeepalivePacketData nattKeepalivePacket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws InvalidPacketException {
        return InvokeDynamicSupport.bootstrapStatic("nattKeepalivePacket", $$robo$$android_net_KeepalivePacketData$nattKeepalivePacket(java.net.InetAddress int java.net.InetAddress int ), (InetAddress)inetAddress, (int)n, (InetAddress)inetAddress2, (int)n2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_KeepalivePacketData$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_KeepalivePacketData$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_net_KeepalivePacketData$__constructor__(parcel);
    }

    public KeepalivePacketData(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_KeepalivePacketData$__constructor__(android.os.Parcel ), this, parcel);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_net_KeepalivePacketData$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ KeepalivePacketData(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_KeepalivePacketData$__constructor__(android.os.Parcel android.net.KeepalivePacketData$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(KeepalivePacketData.class);
    }

    public /* synthetic */ KeepalivePacketData() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeepalivePacketData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class InvalidPacketException
    extends Exception
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int error;

        private void $$robo$$android_net_KeepalivePacketData_InvalidPacketException$__constructor__(int error) {
            this.error = error;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_net_KeepalivePacketData_InvalidPacketException$__constructor__(n);
        }

        public InvalidPacketException(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_KeepalivePacketData_InvalidPacketException$__constructor__(int ), this, n);
        }

        public /* synthetic */ InvalidPacketException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InvalidPacketException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

