/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkSpecifier;
import android.net.UidRange;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NetworkCapabilities
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkCapabilities";
    private static int INVALID_UID = -1;
    private long mNetworkCapabilities;
    private long mUnwantedNetworkCapabilities;
    public static int NET_CAPABILITY_MMS = 0;
    public static int NET_CAPABILITY_SUPL = 1;
    public static int NET_CAPABILITY_DUN = 2;
    public static int NET_CAPABILITY_FOTA = 3;
    public static int NET_CAPABILITY_IMS = 4;
    public static int NET_CAPABILITY_CBS = 5;
    public static int NET_CAPABILITY_WIFI_P2P = 6;
    public static int NET_CAPABILITY_IA = 7;
    public static int NET_CAPABILITY_RCS = 8;
    public static int NET_CAPABILITY_XCAP = 9;
    public static int NET_CAPABILITY_EIMS = 10;
    public static int NET_CAPABILITY_NOT_METERED = 11;
    public static int NET_CAPABILITY_INTERNET = 12;
    public static int NET_CAPABILITY_NOT_RESTRICTED = 13;
    public static int NET_CAPABILITY_TRUSTED = 14;
    public static int NET_CAPABILITY_NOT_VPN = 15;
    public static int NET_CAPABILITY_VALIDATED = 16;
    public static int NET_CAPABILITY_CAPTIVE_PORTAL = 17;
    public static int NET_CAPABILITY_NOT_ROAMING = 18;
    public static int NET_CAPABILITY_FOREGROUND = 19;
    public static int NET_CAPABILITY_NOT_CONGESTED = 20;
    public static int NET_CAPABILITY_NOT_SUSPENDED = 21;
    @SystemApi
    public static int NET_CAPABILITY_OEM_PAID = 22;
    private static int MIN_NET_CAPABILITY = 0;
    private static int MAX_NET_CAPABILITY = 22;
    private static long MUTABLE_CAPABILITIES = 4145152L;
    private static long NON_REQUESTABLE_CAPABILITIES = 0x3F0000L;
    private static long DEFAULT_CAPABILITIES = 57344L;
    @VisibleForTesting
    static long RESTRICTED_CAPABILITIES = 1980L;
    private static long FORCE_RESTRICTED_CAPABILITIES = 0x400000L;
    @VisibleForTesting
    static long UNRESTRICTED_CAPABILITIES = 4163L;
    private long mTransportTypes;
    public static int TRANSPORT_CELLULAR = 0;
    public static int TRANSPORT_WIFI = 1;
    public static int TRANSPORT_BLUETOOTH = 2;
    public static int TRANSPORT_ETHERNET = 3;
    public static int TRANSPORT_VPN = 4;
    public static int TRANSPORT_WIFI_AWARE = 5;
    public static int TRANSPORT_LOWPAN = 6;
    public static int MIN_TRANSPORT = 0;
    public static int MAX_TRANSPORT = 6;
    private static String[] TRANSPORT_NAMES;
    private int mEstablishingVpnAppUid;
    public static int LINK_BANDWIDTH_UNSPECIFIED = 0;
    private int mLinkUpBandwidthKbps;
    private int mLinkDownBandwidthKbps;
    private NetworkSpecifier mNetworkSpecifier;
    public static int SIGNAL_STRENGTH_UNSPECIFIED = Integer.MIN_VALUE;
    private int mSignalStrength;
    private ArraySet<UidRange> mUids;
    private String mSSID;
    public static Parcelable.Creator<NetworkCapabilities> CREATOR;

    private void $$robo$$android_net_NetworkCapabilities$__constructor__() {
        this.mEstablishingVpnAppUid = -1;
        this.mLinkUpBandwidthKbps = 0;
        this.mLinkDownBandwidthKbps = 0;
        this.mNetworkSpecifier = null;
        this.mSignalStrength = Integer.MIN_VALUE;
        this.mUids = null;
        this.clearAll();
        this.mNetworkCapabilities = 57344L;
    }

    private void $$robo$$android_net_NetworkCapabilities$__constructor__(NetworkCapabilities nc) {
        this.mEstablishingVpnAppUid = -1;
        this.mLinkUpBandwidthKbps = 0;
        this.mLinkDownBandwidthKbps = 0;
        this.mNetworkSpecifier = null;
        this.mSignalStrength = Integer.MIN_VALUE;
        this.mUids = null;
        if (nc != null) {
            this.set(nc);
        }
    }

    private final void $$robo$$android_net_NetworkCapabilities$clearAll() {
        this.mUnwantedNetworkCapabilities = 0L;
        this.mTransportTypes = 0L;
        this.mNetworkCapabilities = 0L;
        this.mLinkDownBandwidthKbps = 0;
        this.mLinkUpBandwidthKbps = 0;
        this.mNetworkSpecifier = null;
        this.mSignalStrength = Integer.MIN_VALUE;
        this.mUids = null;
        this.mEstablishingVpnAppUid = -1;
        this.mSSID = null;
    }

    private final void $$robo$$android_net_NetworkCapabilities$set(NetworkCapabilities nc) {
        this.mNetworkCapabilities = nc.mNetworkCapabilities;
        this.mTransportTypes = nc.mTransportTypes;
        this.mLinkUpBandwidthKbps = nc.mLinkUpBandwidthKbps;
        this.mLinkDownBandwidthKbps = nc.mLinkDownBandwidthKbps;
        this.mNetworkSpecifier = nc.mNetworkSpecifier;
        this.mSignalStrength = nc.mSignalStrength;
        this.setUids(nc.mUids);
        this.mEstablishingVpnAppUid = nc.mEstablishingVpnAppUid;
        this.mUnwantedNetworkCapabilities = nc.mUnwantedNetworkCapabilities;
        this.mSSID = nc.mSSID;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$addCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        this.mNetworkCapabilities |= (long)(1 << capability);
        this.mUnwantedNetworkCapabilities &= (long)(~(1 << capability));
        return this;
    }

    private final void $$robo$$android_net_NetworkCapabilities$addUnwantedCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        this.mUnwantedNetworkCapabilities |= (long)(1 << capability);
        this.mNetworkCapabilities &= (long)(~(1 << capability));
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$removeCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        long mask = ~(1 << capability);
        this.mNetworkCapabilities &= mask;
        this.mUnwantedNetworkCapabilities &= mask;
        return this;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setCapability(int capability, boolean value) {
        if (value) {
            this.addCapability(capability);
        } else {
            this.removeCapability(capability);
        }
        return this;
    }

    private final int[] $$robo$$android_net_NetworkCapabilities$getCapabilities() {
        return BitUtils.unpackBits(this.mNetworkCapabilities);
    }

    private final int[] $$robo$$android_net_NetworkCapabilities$getUnwantedCapabilities() {
        return BitUtils.unpackBits(this.mUnwantedNetworkCapabilities);
    }

    private final void $$robo$$android_net_NetworkCapabilities$setCapabilities(int[] capabilities, int[] unwantedCapabilities) {
        this.mNetworkCapabilities = BitUtils.packBits(capabilities);
        this.mUnwantedNetworkCapabilities = BitUtils.packBits(unwantedCapabilities);
    }

    @Deprecated
    private final void $$robo$$android_net_NetworkCapabilities$setCapabilities(int[] capabilities) {
        this.setCapabilities(capabilities, new int[0]);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasCapability(int capability) {
        return NetworkCapabilities.isValidCapability(capability) && (this.mNetworkCapabilities & (long)(1 << capability)) != 0L;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasUnwantedCapability(int capability) {
        return NetworkCapabilities.isValidCapability(capability) && (this.mUnwantedNetworkCapabilities & (long)(1 << capability)) != 0L;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineNetCapabilities(NetworkCapabilities nc) {
        this.mNetworkCapabilities |= nc.mNetworkCapabilities;
        this.mUnwantedNetworkCapabilities |= nc.mUnwantedNetworkCapabilities;
    }

    private final String $$robo$$android_net_NetworkCapabilities$describeFirstNonRequestableCapability() {
        long nonRequestable = (this.mNetworkCapabilities | this.mUnwantedNetworkCapabilities) & 0x3F0000L;
        if (nonRequestable != 0L) {
            return NetworkCapabilities.capabilityNameOf(BitUtils.unpackBits(nonRequestable)[0]);
        }
        if (this.mLinkUpBandwidthKbps != 0 || this.mLinkDownBandwidthKbps != 0) {
            return "link bandwidth";
        }
        if (this.hasSignalStrength()) {
            return "signalStrength";
        }
        return null;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByNetCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        long requestedCapabilities = this.mNetworkCapabilities;
        long requestedUnwantedCapabilities = this.mUnwantedNetworkCapabilities;
        long providedCapabilities = nc.mNetworkCapabilities;
        if (onlyImmutable) {
            requestedCapabilities &= 0xFFFFFFFFFFC0BFFFL;
            requestedUnwantedCapabilities &= 0xFFFFFFFFFFC0BFFFL;
        }
        return (providedCapabilities & requestedCapabilities) == requestedCapabilities && (requestedUnwantedCapabilities & providedCapabilities) == 0L;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsNetCapabilities(NetworkCapabilities nc) {
        return nc.mNetworkCapabilities == this.mNetworkCapabilities && nc.mUnwantedNetworkCapabilities == this.mUnwantedNetworkCapabilities;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsNetCapabilitiesRequestable(NetworkCapabilities that) {
        return (this.mNetworkCapabilities & 0xFFFFFFFFFFC0FFFFL) == (that.mNetworkCapabilities & 0xFFFFFFFFFFC0FFFFL) && (this.mUnwantedNetworkCapabilities & 0xFFFFFFFFFFC0FFFFL) == (that.mUnwantedNetworkCapabilities & 0xFFFFFFFFFFC0FFFFL);
    }

    private final void $$robo$$android_net_NetworkCapabilities$maybeMarkCapabilitiesRestricted() {
        boolean hasRestrictedCapabilities;
        boolean forceRestrictedCapability = (this.mNetworkCapabilities & 0x400000L) != 0L;
        boolean hasUnrestrictedCapabilities = (this.mNetworkCapabilities & 0x1043L) != 0L;
        boolean bl = hasRestrictedCapabilities = (this.mNetworkCapabilities & 0x7BCL) != 0L;
        if (forceRestrictedCapability || hasRestrictedCapabilities && !hasUnrestrictedCapabilities) {
            this.removeCapability(13);
        }
    }

    private static final boolean $$robo$$android_net_NetworkCapabilities$isValidTransport(int transportType) {
        return 0 <= transportType && transportType <= 6;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$addTransportType(int transportType) {
        NetworkCapabilities.checkValidTransportType(transportType);
        this.mTransportTypes |= (long)(1 << transportType);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$removeTransportType(int transportType) {
        NetworkCapabilities.checkValidTransportType(transportType);
        this.mTransportTypes &= (long)(~(1 << transportType));
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setTransportType(int transportType, boolean value) {
        if (value) {
            this.addTransportType(transportType);
        } else {
            this.removeTransportType(transportType);
        }
        return this;
    }

    private final int[] $$robo$$android_net_NetworkCapabilities$getTransportTypes() {
        return BitUtils.unpackBits(this.mTransportTypes);
    }

    private final void $$robo$$android_net_NetworkCapabilities$setTransportTypes(int[] transportTypes) {
        this.mTransportTypes = BitUtils.packBits(transportTypes);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasTransport(int transportType) {
        return NetworkCapabilities.isValidTransport(transportType) && (this.mTransportTypes & (long)(1 << transportType)) != 0L;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineTransportTypes(NetworkCapabilities nc) {
        this.mTransportTypes |= nc.mTransportTypes;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByTransportTypes(NetworkCapabilities nc) {
        return this.mTransportTypes == 0L || (this.mTransportTypes & nc.mTransportTypes) != 0L;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsTransportTypes(NetworkCapabilities nc) {
        return nc.mTransportTypes == this.mTransportTypes;
    }

    private final void $$robo$$android_net_NetworkCapabilities$setEstablishingVpnAppUid(int uid) {
        this.mEstablishingVpnAppUid = uid;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setLinkUpstreamBandwidthKbps(int upKbps) {
        this.mLinkUpBandwidthKbps = upKbps;
        return this;
    }

    private final int $$robo$$android_net_NetworkCapabilities$getLinkUpstreamBandwidthKbps() {
        return this.mLinkUpBandwidthKbps;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setLinkDownstreamBandwidthKbps(int downKbps) {
        this.mLinkDownBandwidthKbps = downKbps;
        return this;
    }

    private final int $$robo$$android_net_NetworkCapabilities$getLinkDownstreamBandwidthKbps() {
        return this.mLinkDownBandwidthKbps;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineLinkBandwidths(NetworkCapabilities nc) {
        this.mLinkUpBandwidthKbps = Math.max(this.mLinkUpBandwidthKbps, nc.mLinkUpBandwidthKbps);
        this.mLinkDownBandwidthKbps = Math.max(this.mLinkDownBandwidthKbps, nc.mLinkDownBandwidthKbps);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps <= nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps <= nc.mLinkDownBandwidthKbps;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps == nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps == nc.mLinkDownBandwidthKbps;
    }

    private static final int $$robo$$android_net_NetworkCapabilities$minBandwidth(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    private static final int $$robo$$android_net_NetworkCapabilities$maxBandwidth(int a, int b) {
        return Math.max(a, b);
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
        if (networkSpecifier != null && Long.bitCount(this.mTransportTypes) != 1) {
            throw new IllegalStateException("Must have a single transport specified to use setNetworkSpecifier");
        }
        this.mNetworkSpecifier = networkSpecifier;
        return this;
    }

    private final NetworkSpecifier $$robo$$android_net_NetworkCapabilities$getNetworkSpecifier() {
        return this.mNetworkSpecifier;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineSpecifiers(NetworkCapabilities nc) {
        if (this.mNetworkSpecifier != null && !this.mNetworkSpecifier.equals(nc.mNetworkSpecifier)) {
            throw new IllegalStateException("Can't combine two networkSpecifiers");
        }
        this.setNetworkSpecifier(nc.mNetworkSpecifier);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedBySpecifier(NetworkCapabilities nc) {
        return this.mNetworkSpecifier == null || this.mNetworkSpecifier.satisfiedBy(nc.mNetworkSpecifier) || nc.mNetworkSpecifier instanceof MatchAllNetworkSpecifier;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsSpecifier(NetworkCapabilities nc) {
        return Objects.equals(this.mNetworkSpecifier, nc.mNetworkSpecifier);
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setSignalStrength(int signalStrength) {
        this.mSignalStrength = signalStrength;
        return this;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasSignalStrength() {
        return this.mSignalStrength > Integer.MIN_VALUE;
    }

    private final int $$robo$$android_net_NetworkCapabilities$getSignalStrength() {
        return this.mSignalStrength;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineSignalStrength(NetworkCapabilities nc) {
        this.mSignalStrength = Math.max(this.mSignalStrength, nc.mSignalStrength);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedBySignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength <= nc.mSignalStrength;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsSignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength == nc.mSignalStrength;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setSingleUid(int uid) {
        ArraySet<UidRange> identity = new ArraySet<UidRange>(1);
        identity.add(new UidRange(uid, uid));
        this.setUids(identity);
        return this;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setUids(Set<UidRange> uids) {
        this.mUids = null == uids ? null : new ArraySet<UidRange>(uids);
        return this;
    }

    private final Set<UidRange> $$robo$$android_net_NetworkCapabilities$getUids() {
        return null == this.mUids ? null : new ArraySet<UidRange>(this.mUids);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$appliesToUid(int uid) {
        if (null == this.mUids) {
            return true;
        }
        for (UidRange range : this.mUids) {
            if (!range.contains(uid)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    private final boolean $$robo$$android_net_NetworkCapabilities$equalsUids(NetworkCapabilities nc) {
        ArraySet<UidRange> comparedUids = nc.mUids;
        if (null == comparedUids) {
            return null == this.mUids;
        }
        if (null == this.mUids) {
            return false;
        }
        ArraySet<UidRange> uids = new ArraySet<UidRange>(this.mUids);
        for (UidRange range : comparedUids) {
            if (!uids.contains(range)) {
                return false;
            }
            uids.remove(range);
        }
        return uids.isEmpty();
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByUids(NetworkCapabilities nc) {
        if (null == nc.mUids || null == this.mUids) {
            return true;
        }
        for (UidRange requiredRange : this.mUids) {
            if (requiredRange.contains(nc.mEstablishingVpnAppUid)) {
                return true;
            }
            if (nc.appliesToUidRange(requiredRange)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    private final boolean $$robo$$android_net_NetworkCapabilities$appliesToUidRange(UidRange requiredRange) {
        if (null == this.mUids) {
            return true;
        }
        for (UidRange uidRange : this.mUids) {
            if (!uidRange.containsRange(requiredRange)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineUids(NetworkCapabilities nc) {
        if (null == nc.mUids || null == this.mUids) {
            this.mUids = null;
            return;
        }
        this.mUids.addAll(nc.mUids);
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$setSSID(String ssid) {
        this.mSSID = ssid;
        return this;
    }

    private final String $$robo$$android_net_NetworkCapabilities$getSSID() {
        return this.mSSID;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsSSID(NetworkCapabilities nc) {
        return Objects.equals(this.mSSID, nc.mSSID);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedBySSID(NetworkCapabilities nc) {
        return this.mSSID == null || this.mSSID.equals(nc.mSSID);
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineSSIDs(NetworkCapabilities nc) {
        if (this.mSSID != null && !this.mSSID.equals(nc.mSSID)) {
            throw new IllegalStateException("Can't combine two SSIDs");
        }
        this.setSSID(nc.mSSID);
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineCapabilities(NetworkCapabilities nc) {
        this.combineNetCapabilities(nc);
        this.combineTransportTypes(nc);
        this.combineLinkBandwidths(nc);
        this.combineSpecifiers(nc);
        this.combineSignalStrength(nc);
        this.combineUids(nc);
        this.combineSSIDs(nc);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        return !(nc == null || !this.satisfiedByNetCapabilities(nc, onlyImmutable) || !this.satisfiedByTransportTypes(nc) || !onlyImmutable && !this.satisfiedByLinkBandwidths(nc) || !this.satisfiedBySpecifier(nc) || !onlyImmutable && !this.satisfiedBySignalStrength(nc) || !onlyImmutable && !this.satisfiedByUids(nc) || !onlyImmutable && !this.satisfiedBySSID(nc));
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, false);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByImmutableNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, true);
    }

    private final String $$robo$$android_net_NetworkCapabilities$describeImmutableDifferences(NetworkCapabilities that) {
        Object after;
        Object before;
        if (that == null) {
            return "other NetworkCapabilities was null";
        }
        StringJoiner joiner = new StringJoiner(", ");
        long mask = -4147201L;
        long oldImmutableCapabilities = this.mNetworkCapabilities & 0xFFFFFFFFFFC0B7FFL;
        long newImmutableCapabilities = that.mNetworkCapabilities & 0xFFFFFFFFFFC0B7FFL;
        if (oldImmutableCapabilities != newImmutableCapabilities) {
            before = NetworkCapabilities.capabilityNamesOf(BitUtils.unpackBits(oldImmutableCapabilities));
            after = NetworkCapabilities.capabilityNamesOf(BitUtils.unpackBits(newImmutableCapabilities));
            joiner.add(String.format("immutable capabilities changed: %s -> %s", before, after));
        }
        if (!this.equalsSpecifier(that)) {
            before = this.getNetworkSpecifier();
            after = that.getNetworkSpecifier();
            joiner.add(String.format("specifier changed: %s -> %s", before, after));
        }
        if (!this.equalsTransportTypes(that)) {
            before = NetworkCapabilities.transportNamesOf(this.getTransportTypes());
            after = NetworkCapabilities.transportNamesOf(that.getTransportTypes());
            joiner.add(String.format("transports changed: %s -> %s", before, after));
        }
        return joiner.toString();
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalRequestableCapabilities(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        return this.equalsNetCapabilitiesRequestable(nc) && this.equalsTransportTypes(nc) && this.equalsSpecifier(nc);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkCapabilities)) {
            return false;
        }
        NetworkCapabilities that = (NetworkCapabilities)obj;
        return this.equalsNetCapabilities(that) && this.equalsTransportTypes(that) && this.equalsLinkBandwidths(that) && this.equalsSignalStrength(that) && this.equalsSpecifier(that) && this.equalsUids(that) && this.equalsSSID(that);
    }

    private final int $$robo$$android_net_NetworkCapabilities$hashCode() {
        return (int)(this.mNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) + (int)(this.mNetworkCapabilities >> 32) * 3 + (int)(this.mUnwantedNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) * 5 + (int)(this.mUnwantedNetworkCapabilities >> 32) * 7 + (int)(this.mTransportTypes & 0xFFFFFFFFFFFFFFFFL) * 11 + (int)(this.mTransportTypes >> 32) * 13 + this.mLinkUpBandwidthKbps * 17 + this.mLinkDownBandwidthKbps * 19 + Objects.hashCode(this.mNetworkSpecifier) * 23 + this.mSignalStrength * 29 + Objects.hashCode(this.mUids) * 31 + Objects.hashCode(this.mSSID) * 37;
    }

    private final int $$robo$$android_net_NetworkCapabilities$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_NetworkCapabilities$writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mNetworkCapabilities);
        dest.writeLong(this.mUnwantedNetworkCapabilities);
        dest.writeLong(this.mTransportTypes);
        dest.writeInt(this.mLinkUpBandwidthKbps);
        dest.writeInt(this.mLinkDownBandwidthKbps);
        dest.writeParcelable((Parcelable)((Object)this.mNetworkSpecifier), flags);
        dest.writeInt(this.mSignalStrength);
        dest.writeArraySet(this.mUids);
        dest.writeString(this.mSSID);
    }

    private final String $$robo$$android_net_NetworkCapabilities$toString() {
        StringBuilder sb = new StringBuilder("[");
        if (0L != this.mTransportTypes) {
            sb.append(" Transports: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mTransportTypes, NetworkCapabilities::transportNameOf, "|");
        }
        if (0L != this.mNetworkCapabilities) {
            sb.append(" Capabilities: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mNetworkCapabilities, NetworkCapabilities::capabilityNameOf, "&");
        }
        if (0L != this.mNetworkCapabilities) {
            sb.append(" Unwanted: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mUnwantedNetworkCapabilities, NetworkCapabilities::capabilityNameOf, "&");
        }
        if (this.mLinkUpBandwidthKbps > 0) {
            sb.append(" LinkUpBandwidth>=").append(this.mLinkUpBandwidthKbps).append("Kbps");
        }
        if (this.mLinkDownBandwidthKbps > 0) {
            sb.append(" LinkDnBandwidth>=").append(this.mLinkDownBandwidthKbps).append("Kbps");
        }
        if (this.mNetworkSpecifier != null) {
            sb.append(" Specifier: <").append(this.mNetworkSpecifier).append(">");
        }
        if (this.hasSignalStrength()) {
            sb.append(" SignalStrength: ").append(this.mSignalStrength);
        }
        if (null != this.mUids) {
            if (1 == this.mUids.size() && this.mUids.valueAt(0).count() == 1) {
                sb.append(" Uid: ").append(this.mUids.valueAt((int)0).start);
            } else {
                sb.append(" Uids: <").append(this.mUids).append(">");
            }
        }
        if (this.mEstablishingVpnAppUid != -1) {
            sb.append(" EstablishingAppUid: ").append(this.mEstablishingVpnAppUid);
        }
        if (null != this.mSSID) {
            sb.append(" SSID: ").append(this.mSSID);
        }
        sb.append("]");
        return sb.toString();
    }

    private static final void $$robo$$android_net_NetworkCapabilities$appendStringRepresentationOfBitMaskToStringBuilder(StringBuilder sb, long bitMask, NameOf nameFetcher, String separator) {
        int bitPos = 0;
        boolean firstElementAdded = false;
        while (bitMask != 0L) {
            if ((bitMask & 1L) != 0L) {
                if (firstElementAdded) {
                    sb.append(separator);
                } else {
                    firstElementAdded = true;
                }
                sb.append(nameFetcher.nameOf(bitPos));
            }
            bitMask >>= 1;
            ++bitPos;
        }
    }

    private final void $$robo$$android_net_NetworkCapabilities$writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        for (int transport : this.getTransportTypes()) {
            proto.write(2259152797697L, transport);
        }
        for (int capability : this.getCapabilities()) {
            proto.write(0x20E00000002L, capability);
        }
        proto.write(1120986464259L, this.mLinkUpBandwidthKbps);
        proto.write(1120986464260L, this.mLinkDownBandwidthKbps);
        if (this.mNetworkSpecifier != null) {
            proto.write(1138166333445L, this.mNetworkSpecifier.toString());
        }
        proto.write(1133871366150L, this.hasSignalStrength());
        proto.write(0x11100000007L, this.mSignalStrength);
        proto.end(token);
    }

    private static final String $$robo$$android_net_NetworkCapabilities$capabilityNamesOf(int[] capabilities) {
        StringJoiner joiner = new StringJoiner("|");
        if (capabilities != null) {
            for (int c : capabilities) {
                joiner.add(NetworkCapabilities.capabilityNameOf(c));
            }
        }
        return joiner.toString();
    }

    private static final String $$robo$$android_net_NetworkCapabilities$capabilityNameOf(int capability) {
        switch (capability) {
            case 0: {
                return "MMS";
            }
            case 1: {
                return "SUPL";
            }
            case 2: {
                return "DUN";
            }
            case 3: {
                return "FOTA";
            }
            case 4: {
                return "IMS";
            }
            case 5: {
                return "CBS";
            }
            case 6: {
                return "WIFI_P2P";
            }
            case 7: {
                return "IA";
            }
            case 8: {
                return "RCS";
            }
            case 9: {
                return "XCAP";
            }
            case 10: {
                return "EIMS";
            }
            case 11: {
                return "NOT_METERED";
            }
            case 12: {
                return "INTERNET";
            }
            case 13: {
                return "NOT_RESTRICTED";
            }
            case 14: {
                return "TRUSTED";
            }
            case 15: {
                return "NOT_VPN";
            }
            case 16: {
                return "VALIDATED";
            }
            case 17: {
                return "CAPTIVE_PORTAL";
            }
            case 18: {
                return "NOT_ROAMING";
            }
            case 19: {
                return "FOREGROUND";
            }
            case 20: {
                return "NOT_CONGESTED";
            }
            case 21: {
                return "NOT_SUSPENDED";
            }
            case 22: {
                return "OEM_PAID";
            }
        }
        return Integer.toString(capability);
    }

    private static final String $$robo$$android_net_NetworkCapabilities$transportNamesOf(int[] types) {
        StringJoiner joiner = new StringJoiner("|");
        if (types != null) {
            for (int t : types) {
                joiner.add(NetworkCapabilities.transportNameOf(t));
            }
        }
        return joiner.toString();
    }

    private static final String $$robo$$android_net_NetworkCapabilities$transportNameOf(int transport) {
        if (!NetworkCapabilities.isValidTransport(transport)) {
            return "UNKNOWN";
        }
        return TRANSPORT_NAMES[transport];
    }

    private static final void $$robo$$android_net_NetworkCapabilities$checkValidTransportType(int transport) {
        Preconditions.checkArgument(NetworkCapabilities.isValidTransport(transport), "Invalid TransportType " + transport);
    }

    private static final boolean $$robo$$android_net_NetworkCapabilities$isValidCapability(int capability) {
        return capability >= 0 && capability <= 22;
    }

    private static final void $$robo$$android_net_NetworkCapabilities$checkValidCapability(int capability) {
        Preconditions.checkArgument(NetworkCapabilities.isValidCapability(capability), "NetworkCapability " + capability + "out of range");
    }

    static void __staticInitializer__() {
        TRANSPORT_NAMES = new String[]{"CELLULAR", "WIFI", "BLUETOOTH", "ETHERNET", "VPN", "WIFI_AWARE", "LOWPAN"};
        CREATOR = new Parcelable.Creator<NetworkCapabilities>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkCapabilities_1$__constructor__() {
            }

            private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities_1$createFromParcel(Parcel in) {
                NetworkCapabilities netCap = new NetworkCapabilities();
                netCap.mNetworkCapabilities = in.readLong();
                netCap.mUnwantedNetworkCapabilities = in.readLong();
                netCap.mTransportTypes = in.readLong();
                netCap.mLinkUpBandwidthKbps = in.readInt();
                netCap.mLinkDownBandwidthKbps = in.readInt();
                netCap.mNetworkSpecifier = (NetworkSpecifier)in.readParcelable(null);
                netCap.mSignalStrength = in.readInt();
                netCap.mUids = in.readArraySet(null);
                netCap.mSSID = in.readString();
                return netCap;
            }

            private final NetworkCapabilities[] $$robo$$android_net_NetworkCapabilities_1$newArray(int size) {
                return new NetworkCapabilities[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkCapabilities_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities_1$__constructor__(), this);
            }

            @Override
            public NetworkCapabilities createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkCapabilities_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public NetworkCapabilities[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkCapabilities_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_NetworkCapabilities$__constructor__();
    }

    public NetworkCapabilities() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities$__constructor__(), this);
    }

    private void __constructor__(NetworkCapabilities networkCapabilities) {
        this.$$robo$$android_net_NetworkCapabilities$__constructor__(networkCapabilities);
    }

    public NetworkCapabilities(NetworkCapabilities networkCapabilities) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities$__constructor__(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public void clearAll() {
        InvokeDynamicSupport.bootstrap("clearAll", $$robo$$android_net_NetworkCapabilities$clearAll(), this);
    }

    public void set(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_net_NetworkCapabilities$set(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public NetworkCapabilities addCapability(int n) {
        return InvokeDynamicSupport.bootstrap("addCapability", $$robo$$android_net_NetworkCapabilities$addCapability(int ), this, n);
    }

    public void addUnwantedCapability(int n) {
        InvokeDynamicSupport.bootstrap("addUnwantedCapability", $$robo$$android_net_NetworkCapabilities$addUnwantedCapability(int ), this, n);
    }

    public NetworkCapabilities removeCapability(int n) {
        return InvokeDynamicSupport.bootstrap("removeCapability", $$robo$$android_net_NetworkCapabilities$removeCapability(int ), this, n);
    }

    public NetworkCapabilities setCapability(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("setCapability", $$robo$$android_net_NetworkCapabilities$setCapability(int boolean ), this, n, bl);
    }

    public int[] getCapabilities() {
        return InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_net_NetworkCapabilities$getCapabilities(), this);
    }

    public int[] getUnwantedCapabilities() {
        return InvokeDynamicSupport.bootstrap("getUnwantedCapabilities", $$robo$$android_net_NetworkCapabilities$getUnwantedCapabilities(), this);
    }

    public void setCapabilities(int[] nArray, int[] nArray2) {
        InvokeDynamicSupport.bootstrap("setCapabilities", $$robo$$android_net_NetworkCapabilities$setCapabilities(int[] int[] ), this, nArray, nArray2);
    }

    @Deprecated
    public void setCapabilities(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setCapabilities", $$robo$$android_net_NetworkCapabilities$setCapabilities(int[] ), this, nArray);
    }

    public boolean hasCapability(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCapability", $$robo$$android_net_NetworkCapabilities$hasCapability(int ), this, n);
    }

    public boolean hasUnwantedCapability(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUnwantedCapability", $$robo$$android_net_NetworkCapabilities$hasUnwantedCapability(int ), this, n);
    }

    private void combineNetCapabilities(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineNetCapabilities", $$robo$$android_net_NetworkCapabilities$combineNetCapabilities(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public String describeFirstNonRequestableCapability() {
        return InvokeDynamicSupport.bootstrap("describeFirstNonRequestableCapability", $$robo$$android_net_NetworkCapabilities$describeFirstNonRequestableCapability(), this);
    }

    private boolean satisfiedByNetCapabilities(NetworkCapabilities networkCapabilities, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByNetCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByNetCapabilities(android.net.NetworkCapabilities boolean ), this, networkCapabilities, bl);
    }

    public boolean equalsNetCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsNetCapabilities", $$robo$$android_net_NetworkCapabilities$equalsNetCapabilities(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean equalsNetCapabilitiesRequestable(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsNetCapabilitiesRequestable", $$robo$$android_net_NetworkCapabilities$equalsNetCapabilitiesRequestable(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public void maybeMarkCapabilitiesRestricted() {
        InvokeDynamicSupport.bootstrap("maybeMarkCapabilitiesRestricted", $$robo$$android_net_NetworkCapabilities$maybeMarkCapabilitiesRestricted(), this);
    }

    public static boolean isValidTransport(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidTransport", $$robo$$android_net_NetworkCapabilities$isValidTransport(int ), (int)n);
    }

    public NetworkCapabilities addTransportType(int n) {
        return InvokeDynamicSupport.bootstrap("addTransportType", $$robo$$android_net_NetworkCapabilities$addTransportType(int ), this, n);
    }

    public NetworkCapabilities removeTransportType(int n) {
        return InvokeDynamicSupport.bootstrap("removeTransportType", $$robo$$android_net_NetworkCapabilities$removeTransportType(int ), this, n);
    }

    public NetworkCapabilities setTransportType(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("setTransportType", $$robo$$android_net_NetworkCapabilities$setTransportType(int boolean ), this, n, bl);
    }

    public int[] getTransportTypes() {
        return InvokeDynamicSupport.bootstrap("getTransportTypes", $$robo$$android_net_NetworkCapabilities$getTransportTypes(), this);
    }

    public void setTransportTypes(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setTransportTypes", $$robo$$android_net_NetworkCapabilities$setTransportTypes(int[] ), this, nArray);
    }

    public boolean hasTransport(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTransport", $$robo$$android_net_NetworkCapabilities$hasTransport(int ), this, n);
    }

    private void combineTransportTypes(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineTransportTypes", $$robo$$android_net_NetworkCapabilities$combineTransportTypes(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean satisfiedByTransportTypes(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByTransportTypes", $$robo$$android_net_NetworkCapabilities$satisfiedByTransportTypes(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public boolean equalsTransportTypes(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsTransportTypes", $$robo$$android_net_NetworkCapabilities$equalsTransportTypes(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public void setEstablishingVpnAppUid(int n) {
        InvokeDynamicSupport.bootstrap("setEstablishingVpnAppUid", $$robo$$android_net_NetworkCapabilities$setEstablishingVpnAppUid(int ), this, n);
    }

    public NetworkCapabilities setLinkUpstreamBandwidthKbps(int n) {
        return InvokeDynamicSupport.bootstrap("setLinkUpstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$setLinkUpstreamBandwidthKbps(int ), this, n);
    }

    public int getLinkUpstreamBandwidthKbps() {
        return (int)InvokeDynamicSupport.bootstrap("getLinkUpstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$getLinkUpstreamBandwidthKbps(), this);
    }

    public NetworkCapabilities setLinkDownstreamBandwidthKbps(int n) {
        return InvokeDynamicSupport.bootstrap("setLinkDownstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$setLinkDownstreamBandwidthKbps(int ), this, n);
    }

    public int getLinkDownstreamBandwidthKbps() {
        return (int)InvokeDynamicSupport.bootstrap("getLinkDownstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$getLinkDownstreamBandwidthKbps(), this);
    }

    private void combineLinkBandwidths(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineLinkBandwidths", $$robo$$android_net_NetworkCapabilities$combineLinkBandwidths(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean satisfiedByLinkBandwidths(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByLinkBandwidths", $$robo$$android_net_NetworkCapabilities$satisfiedByLinkBandwidths(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean equalsLinkBandwidths(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsLinkBandwidths", $$robo$$android_net_NetworkCapabilities$equalsLinkBandwidths(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public static int minBandwidth(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("minBandwidth", $$robo$$android_net_NetworkCapabilities$minBandwidth(int int ), (int)n, (int)n2);
    }

    public static int maxBandwidth(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("maxBandwidth", $$robo$$android_net_NetworkCapabilities$maxBandwidth(int int ), (int)n, (int)n2);
    }

    public NetworkCapabilities setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
        return InvokeDynamicSupport.bootstrap("setNetworkSpecifier", $$robo$$android_net_NetworkCapabilities$setNetworkSpecifier(android.net.NetworkSpecifier ), this, networkSpecifier);
    }

    public NetworkSpecifier getNetworkSpecifier() {
        return InvokeDynamicSupport.bootstrap("getNetworkSpecifier", $$robo$$android_net_NetworkCapabilities$getNetworkSpecifier(), this);
    }

    private void combineSpecifiers(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineSpecifiers", $$robo$$android_net_NetworkCapabilities$combineSpecifiers(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean satisfiedBySpecifier(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedBySpecifier", $$robo$$android_net_NetworkCapabilities$satisfiedBySpecifier(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean equalsSpecifier(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsSpecifier", $$robo$$android_net_NetworkCapabilities$equalsSpecifier(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public NetworkCapabilities setSignalStrength(int n) {
        return InvokeDynamicSupport.bootstrap("setSignalStrength", $$robo$$android_net_NetworkCapabilities$setSignalStrength(int ), this, n);
    }

    public boolean hasSignalStrength() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSignalStrength", $$robo$$android_net_NetworkCapabilities$hasSignalStrength(), this);
    }

    public int getSignalStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$android_net_NetworkCapabilities$getSignalStrength(), this);
    }

    private void combineSignalStrength(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineSignalStrength", $$robo$$android_net_NetworkCapabilities$combineSignalStrength(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean satisfiedBySignalStrength(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedBySignalStrength", $$robo$$android_net_NetworkCapabilities$satisfiedBySignalStrength(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean equalsSignalStrength(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsSignalStrength", $$robo$$android_net_NetworkCapabilities$equalsSignalStrength(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public NetworkCapabilities setSingleUid(int n) {
        return InvokeDynamicSupport.bootstrap("setSingleUid", $$robo$$android_net_NetworkCapabilities$setSingleUid(int ), this, n);
    }

    public NetworkCapabilities setUids(Set<UidRange> set) {
        return InvokeDynamicSupport.bootstrap("setUids", $$robo$$android_net_NetworkCapabilities$setUids(java.util.Set<android.net.UidRange> ), this, set);
    }

    public Set<UidRange> getUids() {
        return InvokeDynamicSupport.bootstrap("getUids", $$robo$$android_net_NetworkCapabilities$getUids(), this);
    }

    public boolean appliesToUid(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("appliesToUid", $$robo$$android_net_NetworkCapabilities$appliesToUid(int ), this, n);
    }

    public boolean equalsUids(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsUids", $$robo$$android_net_NetworkCapabilities$equalsUids(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public boolean satisfiedByUids(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByUids", $$robo$$android_net_NetworkCapabilities$satisfiedByUids(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public boolean appliesToUidRange(UidRange uidRange) {
        return (boolean)InvokeDynamicSupport.bootstrap("appliesToUidRange", $$robo$$android_net_NetworkCapabilities$appliesToUidRange(android.net.UidRange ), this, uidRange);
    }

    private void combineUids(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineUids", $$robo$$android_net_NetworkCapabilities$combineUids(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public NetworkCapabilities setSSID(String string2) {
        return InvokeDynamicSupport.bootstrap("setSSID", $$robo$$android_net_NetworkCapabilities$setSSID(java.lang.String ), this, string2);
    }

    public String getSSID() {
        return InvokeDynamicSupport.bootstrap("getSSID", $$robo$$android_net_NetworkCapabilities$getSSID(), this);
    }

    public boolean equalsSSID(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsSSID", $$robo$$android_net_NetworkCapabilities$equalsSSID(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public boolean satisfiedBySSID(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedBySSID", $$robo$$android_net_NetworkCapabilities$satisfiedBySSID(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private void combineSSIDs(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineSSIDs", $$robo$$android_net_NetworkCapabilities$combineSSIDs(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public void combineCapabilities(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineCapabilities", $$robo$$android_net_NetworkCapabilities$combineCapabilities(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    private boolean satisfiedByNetworkCapabilities(NetworkCapabilities networkCapabilities, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByNetworkCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(android.net.NetworkCapabilities boolean ), this, networkCapabilities, bl);
    }

    public boolean satisfiedByNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByNetworkCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public boolean satisfiedByImmutableNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByImmutableNetworkCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByImmutableNetworkCapabilities(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public String describeImmutableDifferences(NetworkCapabilities networkCapabilities) {
        return InvokeDynamicSupport.bootstrap("describeImmutableDifferences", $$robo$$android_net_NetworkCapabilities$describeImmutableDifferences(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public boolean equalRequestableCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalRequestableCapabilities", $$robo$$android_net_NetworkCapabilities$equalRequestableCapabilities(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkCapabilities$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkCapabilities$hashCode(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkCapabilities$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkCapabilities$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkCapabilities$toString(), this);
    }

    public static void appendStringRepresentationOfBitMaskToStringBuilder(StringBuilder stringBuilder, long l, NameOf nameOf, String string2) {
        InvokeDynamicSupport.bootstrapStatic("appendStringRepresentationOfBitMaskToStringBuilder", $$robo$$android_net_NetworkCapabilities$appendStringRepresentationOfBitMaskToStringBuilder(java.lang.StringBuilder long android.net.NetworkCapabilities$NameOf java.lang.String ), (StringBuilder)stringBuilder, (long)l, (NameOf)nameOf, (String)string2);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_net_NetworkCapabilities$writeToProto(android.util.proto.ProtoOutputStream long ), this, protoOutputStream, l);
    }

    public static String capabilityNamesOf(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("capabilityNamesOf", $$robo$$android_net_NetworkCapabilities$capabilityNamesOf(int[] ), (int[])nArray);
    }

    public static String capabilityNameOf(int n) {
        return InvokeDynamicSupport.bootstrapStatic("capabilityNameOf", $$robo$$android_net_NetworkCapabilities$capabilityNameOf(int ), (int)n);
    }

    public static String transportNamesOf(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("transportNamesOf", $$robo$$android_net_NetworkCapabilities$transportNamesOf(int[] ), (int[])nArray);
    }

    public static String transportNameOf(int n) {
        return InvokeDynamicSupport.bootstrapStatic("transportNameOf", $$robo$$android_net_NetworkCapabilities$transportNameOf(int ), (int)n);
    }

    private static void checkValidTransportType(int n) {
        InvokeDynamicSupport.bootstrapStatic("checkValidTransportType", $$robo$$android_net_NetworkCapabilities$checkValidTransportType(int ), (int)n);
    }

    private static boolean isValidCapability(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidCapability", $$robo$$android_net_NetworkCapabilities$isValidCapability(int ), (int)n);
    }

    private static void checkValidCapability(int n) {
        InvokeDynamicSupport.bootstrapStatic("checkValidCapability", $$robo$$android_net_NetworkCapabilities$checkValidCapability(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(NetworkCapabilities.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkCapabilities)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static interface NameOf {
        public String nameOf(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transport {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetCapability {
    }
}

