/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkFactory
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int BASE = 536576;
    public static int CMD_REQUEST_NETWORK = 536576;
    public static int CMD_CANCEL_REQUEST = 536577;
    private static int CMD_SET_SCORE = 536578;
    private static int CMD_SET_FILTER = 536579;
    private Context mContext;
    private String LOG_TAG;
    private SparseArray<NetworkRequestInfo> mNetworkRequests;
    private int mScore;
    private NetworkCapabilities mCapabilityFilter;
    private int mRefCount;
    private Messenger mMessenger;

    private void $$robo$$android_net_NetworkFactory$__constructor__(Looper looper, Context context, String logTag, NetworkCapabilities filter) {
        this.mNetworkRequests = new SparseArray();
        this.mRefCount = 0;
        this.mMessenger = null;
        this.LOG_TAG = logTag;
        this.mContext = context;
        this.mCapabilityFilter = filter;
    }

    private final void $$robo$$android_net_NetworkFactory$register() {
        this.log("Registering NetworkFactory");
        if (this.mMessenger == null) {
            this.mMessenger = new Messenger(this);
            ConnectivityManager.from(this.mContext).registerNetworkFactory(this.mMessenger, this.LOG_TAG);
        }
    }

    private final void $$robo$$android_net_NetworkFactory$unregister() {
        this.log("Unregistering NetworkFactory");
        if (this.mMessenger != null) {
            ConnectivityManager.from(this.mContext).unregisterNetworkFactory(this.mMessenger);
            this.mMessenger = null;
        }
    }

    private final void $$robo$$android_net_NetworkFactory$handleMessage(Message msg) {
        switch (msg.what) {
            case 536576: {
                this.handleAddRequest((NetworkRequest)msg.obj, msg.arg1);
                break;
            }
            case 536577: {
                this.handleRemoveRequest((NetworkRequest)msg.obj);
                break;
            }
            case 536578: {
                this.handleSetScore(msg.arg1);
                break;
            }
            case 536579: {
                this.handleSetFilter((NetworkCapabilities)msg.obj);
            }
        }
    }

    @VisibleForTesting
    private final void $$robo$$android_net_NetworkFactory$handleAddRequest(NetworkRequest request, int score) {
        NetworkRequestInfo n = this.mNetworkRequests.get(request.requestId);
        if (n == null) {
            this.log("got request " + request + " with score " + score);
            n = new NetworkRequestInfo(this, request, score);
            this.mNetworkRequests.put(n.request.requestId, n);
        } else {
            n.score = score;
        }
        this.evalRequest(n);
    }

    @VisibleForTesting
    private final void $$robo$$android_net_NetworkFactory$handleRemoveRequest(NetworkRequest request) {
        NetworkRequestInfo n = this.mNetworkRequests.get(request.requestId);
        if (n != null) {
            this.mNetworkRequests.remove(request.requestId);
            if (n.requested) {
                this.releaseNetworkFor(n.request);
            }
        }
    }

    private final void $$robo$$android_net_NetworkFactory$handleSetScore(int score) {
        this.mScore = score;
        this.evalRequests();
    }

    private final void $$robo$$android_net_NetworkFactory$handleSetFilter(NetworkCapabilities netCap) {
        this.mCapabilityFilter = netCap;
        this.evalRequests();
    }

    private final boolean $$robo$$android_net_NetworkFactory$acceptRequest(NetworkRequest request, int score) {
        return true;
    }

    private final void $$robo$$android_net_NetworkFactory$evalRequest(NetworkRequestInfo n) {
        if (!n.requested && n.score < this.mScore && n.request.networkCapabilities.satisfiedByNetworkCapabilities(this.mCapabilityFilter) && this.acceptRequest(n.request, n.score)) {
            this.needNetworkFor(n.request, n.score);
            n.requested = true;
        } else if (!(!n.requested || n.score <= this.mScore && n.request.networkCapabilities.satisfiedByNetworkCapabilities(this.mCapabilityFilter) && this.acceptRequest(n.request, n.score))) {
            this.releaseNetworkFor(n.request);
            n.requested = false;
        }
    }

    private final void $$robo$$android_net_NetworkFactory$evalRequests() {
        for (int i = 0; i < this.mNetworkRequests.size(); ++i) {
            NetworkRequestInfo n = this.mNetworkRequests.valueAt(i);
            this.evalRequest(n);
        }
    }

    private final void $$robo$$android_net_NetworkFactory$reevaluateAllRequests() {
        this.post(() -> this.evalRequests());
    }

    private final void $$robo$$android_net_NetworkFactory$startNetwork() {
    }

    private final void $$robo$$android_net_NetworkFactory$stopNetwork() {
    }

    private final void $$robo$$android_net_NetworkFactory$needNetworkFor(NetworkRequest networkRequest, int score) {
        if (++this.mRefCount == 1) {
            this.startNetwork();
        }
    }

    private final void $$robo$$android_net_NetworkFactory$releaseNetworkFor(NetworkRequest networkRequest) {
        if (--this.mRefCount == 0) {
            this.stopNetwork();
        }
    }

    private final void $$robo$$android_net_NetworkFactory$addNetworkRequest(NetworkRequest networkRequest, int score) {
        this.sendMessage(this.obtainMessage(536576, new NetworkRequestInfo(this, networkRequest, score)));
    }

    private final void $$robo$$android_net_NetworkFactory$removeNetworkRequest(NetworkRequest networkRequest) {
        this.sendMessage(this.obtainMessage(536577, networkRequest));
    }

    private final void $$robo$$android_net_NetworkFactory$setScoreFilter(int score) {
        this.sendMessage(this.obtainMessage(536578, score, 0));
    }

    private final void $$robo$$android_net_NetworkFactory$setCapabilityFilter(NetworkCapabilities netCap) {
        this.sendMessage(this.obtainMessage(536579, new NetworkCapabilities(netCap)));
    }

    @VisibleForTesting
    private final int $$robo$$android_net_NetworkFactory$getRequestCount() {
        return this.mNetworkRequests.size();
    }

    private final void $$robo$$android_net_NetworkFactory$log(String s) {
        Log.d(this.LOG_TAG, s);
    }

    private final void $$robo$$android_net_NetworkFactory$dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(this.toString());
        pw.increaseIndent();
        for (int i = 0; i < this.mNetworkRequests.size(); ++i) {
            pw.println(this.mNetworkRequests.valueAt(i));
        }
        pw.decreaseIndent();
    }

    private final String $$robo$$android_net_NetworkFactory$toString() {
        StringBuilder sb = new StringBuilder("{").append(this.LOG_TAG).append(" - ScoreFilter=").append(this.mScore).append(", Filter=").append(this.mCapabilityFilter).append(", requests=").append(this.mNetworkRequests.size()).append(", refCount=").append(this.mRefCount).append("}");
        return sb.toString();
    }

    private void __constructor__(Looper looper, Context context, String string2, NetworkCapabilities networkCapabilities) {
        this.$$robo$$android_net_NetworkFactory$__constructor__(looper, context, string2, networkCapabilities);
    }

    public NetworkFactory(Looper looper, Context context, String string2, NetworkCapabilities networkCapabilities) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkFactory$__constructor__(android.os.Looper android.content.Context java.lang.String android.net.NetworkCapabilities ), this, looper, context, string2, networkCapabilities);
    }

    public void register() {
        InvokeDynamicSupport.bootstrap("register", $$robo$$android_net_NetworkFactory$register(), this);
    }

    public void unregister() {
        InvokeDynamicSupport.bootstrap("unregister", $$robo$$android_net_NetworkFactory$unregister(), this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_NetworkFactory$handleMessage(android.os.Message ), this, message);
    }

    protected void handleAddRequest(NetworkRequest networkRequest, int n) {
        InvokeDynamicSupport.bootstrap("handleAddRequest", $$robo$$android_net_NetworkFactory$handleAddRequest(android.net.NetworkRequest int ), this, networkRequest, n);
    }

    protected void handleRemoveRequest(NetworkRequest networkRequest) {
        InvokeDynamicSupport.bootstrap("handleRemoveRequest", $$robo$$android_net_NetworkFactory$handleRemoveRequest(android.net.NetworkRequest ), this, networkRequest);
    }

    private void handleSetScore(int n) {
        InvokeDynamicSupport.bootstrap("handleSetScore", $$robo$$android_net_NetworkFactory$handleSetScore(int ), this, n);
    }

    private void handleSetFilter(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("handleSetFilter", $$robo$$android_net_NetworkFactory$handleSetFilter(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    public boolean acceptRequest(NetworkRequest networkRequest, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("acceptRequest", $$robo$$android_net_NetworkFactory$acceptRequest(android.net.NetworkRequest int ), this, networkRequest, n);
    }

    private void evalRequest(NetworkRequestInfo networkRequestInfo) {
        InvokeDynamicSupport.bootstrap("evalRequest", $$robo$$android_net_NetworkFactory$evalRequest(android.net.NetworkFactory$NetworkRequestInfo ), this, networkRequestInfo);
    }

    private void evalRequests() {
        InvokeDynamicSupport.bootstrap("evalRequests", $$robo$$android_net_NetworkFactory$evalRequests(), this);
    }

    protected void reevaluateAllRequests() {
        InvokeDynamicSupport.bootstrap("reevaluateAllRequests", $$robo$$android_net_NetworkFactory$reevaluateAllRequests(), this);
    }

    protected void startNetwork() {
        InvokeDynamicSupport.bootstrap("startNetwork", $$robo$$android_net_NetworkFactory$startNetwork(), this);
    }

    protected void stopNetwork() {
        InvokeDynamicSupport.bootstrap("stopNetwork", $$robo$$android_net_NetworkFactory$stopNetwork(), this);
    }

    protected void needNetworkFor(NetworkRequest networkRequest, int n) {
        InvokeDynamicSupport.bootstrap("needNetworkFor", $$robo$$android_net_NetworkFactory$needNetworkFor(android.net.NetworkRequest int ), this, networkRequest, n);
    }

    protected void releaseNetworkFor(NetworkRequest networkRequest) {
        InvokeDynamicSupport.bootstrap("releaseNetworkFor", $$robo$$android_net_NetworkFactory$releaseNetworkFor(android.net.NetworkRequest ), this, networkRequest);
    }

    public void addNetworkRequest(NetworkRequest networkRequest, int n) {
        InvokeDynamicSupport.bootstrap("addNetworkRequest", $$robo$$android_net_NetworkFactory$addNetworkRequest(android.net.NetworkRequest int ), this, networkRequest, n);
    }

    public void removeNetworkRequest(NetworkRequest networkRequest) {
        InvokeDynamicSupport.bootstrap("removeNetworkRequest", $$robo$$android_net_NetworkFactory$removeNetworkRequest(android.net.NetworkRequest ), this, networkRequest);
    }

    public void setScoreFilter(int n) {
        InvokeDynamicSupport.bootstrap("setScoreFilter", $$robo$$android_net_NetworkFactory$setScoreFilter(int ), this, n);
    }

    public void setCapabilityFilter(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("setCapabilityFilter", $$robo$$android_net_NetworkFactory$setCapabilityFilter(android.net.NetworkCapabilities ), this, networkCapabilities);
    }

    protected int getRequestCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestCount", $$robo$$android_net_NetworkFactory$getRequestCount(), this);
    }

    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_net_NetworkFactory$log(java.lang.String ), this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_NetworkFactory$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkFactory$toString(), this);
    }

    public /* synthetic */ NetworkFactory() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkFactory)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NetworkRequestInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public NetworkRequest request;
        public int score;
        public boolean requested;
        /* synthetic */ NetworkFactory this$0;

        private void $$robo$$android_net_NetworkFactory_NetworkRequestInfo$__constructor__(NetworkFactory networkFactory, NetworkRequest request, int score) {
            this.this$0 = networkFactory;
            this.request = request;
            this.score = score;
            this.requested = false;
        }

        private final String $$robo$$android_net_NetworkFactory_NetworkRequestInfo$toString() {
            return "{" + this.request + ", score=" + this.score + ", requested=" + this.requested + "}";
        }

        private void __constructor__(NetworkFactory networkFactory, NetworkRequest networkRequest, int n) {
            this.$$robo$$android_net_NetworkFactory_NetworkRequestInfo$__constructor__(networkFactory, networkRequest, n);
        }

        public NetworkRequestInfo(NetworkFactory networkFactory, NetworkRequest networkRequest, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkFactory_NetworkRequestInfo$__constructor__(android.net.NetworkFactory android.net.NetworkRequest int ), this, networkFactory, networkRequest, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkFactory_NetworkRequestInfo$toString(), this);
        }

        public /* synthetic */ NetworkRequestInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkRequestInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

