/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkIdentity;
import android.net.NetworkStats;
import android.net.wifi.WifiInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.BackupUtils;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkTemplate
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkTemplate";
    private static int BACKUP_VERSION = 1;
    public static int MATCH_MOBILE = 1;
    public static int MATCH_WIFI = 4;
    public static int MATCH_ETHERNET = 5;
    public static int MATCH_MOBILE_WILDCARD = 6;
    public static int MATCH_WIFI_WILDCARD = 7;
    public static int MATCH_BLUETOOTH = 8;
    public static int MATCH_PROXY = 9;
    private static boolean sForceAllNetworkTypes;
    private int mMatchRule;
    private String mSubscriberId;
    private String[] mMatchSubscriberIds;
    private String mNetworkId;
    private int mMetered;
    private int mRoaming;
    private int mDefaultNetwork;
    public static Parcelable.Creator<NetworkTemplate> CREATOR;

    private static final boolean $$robo$$android_net_NetworkTemplate$isKnownMatchRule(int rule) {
        switch (rule) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private static final void $$robo$$android_net_NetworkTemplate$forceAllNetworkTypes() {
        sForceAllNetworkTypes = true;
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateMobileAll(String subscriberId) {
        return new NetworkTemplate(1, subscriberId, null);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateMobileWildcard() {
        return new NetworkTemplate(6, null, null);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateWifiWildcard() {
        return new NetworkTemplate(7, null, null);
    }

    @Deprecated
    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateWifi() {
        return NetworkTemplate.buildTemplateWifiWildcard();
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateWifi(String networkId) {
        return new NetworkTemplate(4, null, networkId);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateEthernet() {
        return new NetworkTemplate(5, null, null);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateBluetooth() {
        return new NetworkTemplate(8, null, null);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateProxy() {
        return new NetworkTemplate(9, null, null);
    }

    private void $$robo$$android_net_NetworkTemplate$__constructor__(int matchRule, String subscriberId, String networkId) {
    }

    private void $$robo$$android_net_NetworkTemplate$__constructor__(int matchRule, String subscriberId, String[] matchSubscriberIds, String networkId) {
    }

    private void $$robo$$android_net_NetworkTemplate$__constructor__(int matchRule, String subscriberId, String[] matchSubscriberIds, String networkId, int metered, int roaming, int defaultNetwork) {
        this.mMatchRule = matchRule;
        this.mSubscriberId = subscriberId;
        this.mMatchSubscriberIds = matchSubscriberIds;
        this.mNetworkId = networkId;
        this.mMetered = metered;
        this.mRoaming = roaming;
        this.mDefaultNetwork = defaultNetwork;
        if (!NetworkTemplate.isKnownMatchRule(matchRule)) {
            Log.e("NetworkTemplate", "Unknown network template rule " + matchRule + " will not match any identity.");
        }
    }

    private void $$robo$$android_net_NetworkTemplate$__constructor__(Parcel in) {
        this.mMatchRule = in.readInt();
        this.mSubscriberId = in.readString();
        this.mMatchSubscriberIds = in.createStringArray();
        this.mNetworkId = in.readString();
        this.mMetered = in.readInt();
        this.mRoaming = in.readInt();
        this.mDefaultNetwork = in.readInt();
    }

    private final void $$robo$$android_net_NetworkTemplate$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMatchRule);
        dest.writeString(this.mSubscriberId);
        dest.writeStringArray(this.mMatchSubscriberIds);
        dest.writeString(this.mNetworkId);
        dest.writeInt(this.mMetered);
        dest.writeInt(this.mRoaming);
        dest.writeInt(this.mDefaultNetwork);
    }

    private final int $$robo$$android_net_NetworkTemplate$describeContents() {
        return 0;
    }

    private final String $$robo$$android_net_NetworkTemplate$toString() {
        StringBuilder builder = new StringBuilder("NetworkTemplate: ");
        builder.append("matchRule=").append(NetworkTemplate.getMatchRuleName(this.mMatchRule));
        if (this.mSubscriberId != null) {
            builder.append(", subscriberId=").append(NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mMatchSubscriberIds != null) {
            builder.append(", matchSubscriberIds=").append(Arrays.toString(NetworkIdentity.scrubSubscriberId(this.mMatchSubscriberIds)));
        }
        if (this.mNetworkId != null) {
            builder.append(", networkId=").append(this.mNetworkId);
        }
        if (this.mMetered != -1) {
            builder.append(", metered=").append(NetworkStats.meteredToString(this.mMetered));
        }
        if (this.mRoaming != -1) {
            builder.append(", roaming=").append(NetworkStats.roamingToString(this.mRoaming));
        }
        if (this.mDefaultNetwork != -1) {
            builder.append(", defaultNetwork=").append(NetworkStats.defaultNetworkToString(this.mDefaultNetwork));
        }
        return builder.toString();
    }

    private final int $$robo$$android_net_NetworkTemplate$hashCode() {
        return Objects.hash(this.mMatchRule, this.mSubscriberId, this.mNetworkId, this.mMetered, this.mRoaming, this.mDefaultNetwork);
    }

    private final boolean $$robo$$android_net_NetworkTemplate$equals(Object obj) {
        if (obj instanceof NetworkTemplate) {
            NetworkTemplate other = (NetworkTemplate)obj;
            return this.mMatchRule == other.mMatchRule && Objects.equals(this.mSubscriberId, other.mSubscriberId) && Objects.equals(this.mNetworkId, other.mNetworkId) && this.mMetered == other.mMetered && this.mRoaming == other.mRoaming && this.mDefaultNetwork == other.mDefaultNetwork;
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$isMatchRuleMobile() {
        switch (this.mMatchRule) {
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$isPersistable() {
        switch (this.mMatchRule) {
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    private final int $$robo$$android_net_NetworkTemplate$getMatchRule() {
        return this.mMatchRule;
    }

    private final String $$robo$$android_net_NetworkTemplate$getSubscriberId() {
        return this.mSubscriberId;
    }

    private final String $$robo$$android_net_NetworkTemplate$getNetworkId() {
        return this.mNetworkId;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matches(NetworkIdentity ident) {
        if (!this.matchesMetered(ident)) {
            return false;
        }
        if (!this.matchesRoaming(ident)) {
            return false;
        }
        if (!this.matchesDefaultNetwork(ident)) {
            return false;
        }
        switch (this.mMatchRule) {
            case 1: {
                return this.matchesMobile(ident);
            }
            case 4: {
                return this.matchesWifi(ident);
            }
            case 5: {
                return this.matchesEthernet(ident);
            }
            case 6: {
                return this.matchesMobileWildcard(ident);
            }
            case 7: {
                return this.matchesWifiWildcard(ident);
            }
            case 8: {
                return this.matchesBluetooth(ident);
            }
            case 9: {
                return this.matchesProxy(ident);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesMetered(NetworkIdentity ident) {
        return this.mMetered == -1 || this.mMetered == 1 && ident.mMetered || this.mMetered == 0 && !ident.mMetered;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesRoaming(NetworkIdentity ident) {
        return this.mRoaming == -1 || this.mRoaming == 1 && ident.mRoaming || this.mRoaming == 0 && !ident.mRoaming;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesDefaultNetwork(NetworkIdentity ident) {
        return this.mDefaultNetwork == -1 || this.mDefaultNetwork == 1 && ident.mDefaultNetwork || this.mDefaultNetwork == 0 && !ident.mDefaultNetwork;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesSubscriberId(String subscriberId) {
        return ArrayUtils.contains(this.mMatchSubscriberIds, subscriberId);
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesMobile(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return (sForceAllNetworkTypes || ident.mType == 0 && ident.mMetered) && !ArrayUtils.isEmpty(this.mMatchSubscriberIds) && ArrayUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId);
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesWifi(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: {
                return Objects.equals(WifiInfo.removeDoubleQuotes(this.mNetworkId), WifiInfo.removeDoubleQuotes(ident.mNetworkId));
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesEthernet(NetworkIdentity ident) {
        return ident.mType == 9;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesMobileWildcard(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return sForceAllNetworkTypes || ident.mType == 0 && ident.mMetered;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesWifiWildcard(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesBluetooth(NetworkIdentity ident) {
        return ident.mType == 7;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesProxy(NetworkIdentity ident) {
        return ident.mType == 16;
    }

    private static final String $$robo$$android_net_NetworkTemplate$getMatchRuleName(int matchRule) {
        switch (matchRule) {
            case 1: {
                return "MOBILE";
            }
            case 4: {
                return "WIFI";
            }
            case 5: {
                return "ETHERNET";
            }
            case 6: {
                return "MOBILE_WILDCARD";
            }
            case 7: {
                return "WIFI_WILDCARD";
            }
            case 8: {
                return "BLUETOOTH";
            }
            case 9: {
                return "PROXY";
            }
        }
        return "UNKNOWN(" + matchRule + ")";
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$normalize(NetworkTemplate template, String[] merged) {
        if (template.isMatchRuleMobile() && ArrayUtils.contains(merged, template.mSubscriberId)) {
            return new NetworkTemplate(template.mMatchRule, merged[0], merged, template.mNetworkId);
        }
        return template;
    }

    private final byte[] $$robo$$android_net_NetworkTemplate$getBytesForBackup() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(1);
        out.writeInt(this.mMatchRule);
        BackupUtils.writeString(out, this.mSubscriberId);
        BackupUtils.writeString(out, this.mNetworkId);
        return baos.toByteArray();
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$getNetworkTemplateFromBackup(DataInputStream in) throws IOException, BackupUtils.BadVersionException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new BackupUtils.BadVersionException("Unknown Backup Serialization Version");
        }
        int matchRule = in.readInt();
        String subscriberId = BackupUtils.readString(in);
        String networkId = BackupUtils.readString(in);
        if (!NetworkTemplate.isKnownMatchRule(matchRule)) {
            throw new BackupUtils.BadVersionException("Restored network template contains unknown match rule " + matchRule);
        }
        return new NetworkTemplate(matchRule, subscriberId, networkId);
    }

    private /* synthetic */ void $$robo$$android_net_NetworkTemplate$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        sForceAllNetworkTypes = false;
        CREATOR = new Parcelable.Creator<NetworkTemplate>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkTemplate_1$__constructor__() {
            }

            private final NetworkTemplate $$robo$$android_net_NetworkTemplate_1$createFromParcel(Parcel in) {
                return new NetworkTemplate(in, null);
            }

            private final NetworkTemplate[] $$robo$$android_net_NetworkTemplate_1$newArray(int size) {
                return new NetworkTemplate[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkTemplate_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate_1$__constructor__(), this);
            }

            @Override
            public NetworkTemplate createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkTemplate_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public NetworkTemplate[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkTemplate_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private static boolean isKnownMatchRule(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isKnownMatchRule", $$robo$$android_net_NetworkTemplate$isKnownMatchRule(int ), (int)n);
    }

    public static void forceAllNetworkTypes() {
        InvokeDynamicSupport.bootstrapStatic("forceAllNetworkTypes", $$robo$$android_net_NetworkTemplate$forceAllNetworkTypes());
    }

    public static NetworkTemplate buildTemplateMobileAll(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateMobileAll", $$robo$$android_net_NetworkTemplate$buildTemplateMobileAll(java.lang.String ), (String)string2);
    }

    public static NetworkTemplate buildTemplateMobileWildcard() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateMobileWildcard", $$robo$$android_net_NetworkTemplate$buildTemplateMobileWildcard());
    }

    public static NetworkTemplate buildTemplateWifiWildcard() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateWifiWildcard", $$robo$$android_net_NetworkTemplate$buildTemplateWifiWildcard());
    }

    @Deprecated
    public static NetworkTemplate buildTemplateWifi() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateWifi", $$robo$$android_net_NetworkTemplate$buildTemplateWifi());
    }

    public static NetworkTemplate buildTemplateWifi(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateWifi", $$robo$$android_net_NetworkTemplate$buildTemplateWifi(java.lang.String ), (String)string2);
    }

    public static NetworkTemplate buildTemplateEthernet() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateEthernet", $$robo$$android_net_NetworkTemplate$buildTemplateEthernet());
    }

    public static NetworkTemplate buildTemplateBluetooth() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateBluetooth", $$robo$$android_net_NetworkTemplate$buildTemplateBluetooth());
    }

    public static NetworkTemplate buildTemplateProxy() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateProxy", $$robo$$android_net_NetworkTemplate$buildTemplateProxy());
    }

    private void __constructor__(int n, String string2, String string3) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(n, string2, string3);
    }

    public NetworkTemplate(int n, String string2, String string3) {
        this(n, string2, new String[]{string2}, string3);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate$__constructor__(int java.lang.String java.lang.String ), this, n, string2, string3);
    }

    private void __constructor__(int n, String string2, String[] stringArray, String string3) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(n, string2, stringArray, string3);
    }

    public NetworkTemplate(int n, String string2, String[] stringArray, String string3) {
        this(n, string2, stringArray, string3, -1, -1, -1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate$__constructor__(int java.lang.String java.lang.String[] java.lang.String ), this, n, string2, stringArray, string3);
    }

    private void __constructor__(int n, String string2, String[] stringArray, String string3, int n2, int n3, int n4) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(n, string2, stringArray, string3, n2, n3, n4);
    }

    public NetworkTemplate(int n, String string2, String[] stringArray, String string3, int n2, int n3, int n4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate$__constructor__(int java.lang.String java.lang.String[] java.lang.String int int int ), this, n, string2, stringArray, string3, n2, n3, n4);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(parcel);
    }

    public NetworkTemplate(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkTemplate$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkTemplate$describeContents(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkTemplate$toString(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkTemplate$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkTemplate$equals(java.lang.Object ), this, object);
    }

    public boolean isMatchRuleMobile() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMatchRuleMobile", $$robo$$android_net_NetworkTemplate$isMatchRuleMobile(), this);
    }

    public boolean isPersistable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPersistable", $$robo$$android_net_NetworkTemplate$isPersistable(), this);
    }

    public int getMatchRule() {
        return (int)InvokeDynamicSupport.bootstrap("getMatchRule", $$robo$$android_net_NetworkTemplate$getMatchRule(), this);
    }

    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$android_net_NetworkTemplate$getSubscriberId(), this);
    }

    public String getNetworkId() {
        return InvokeDynamicSupport.bootstrap("getNetworkId", $$robo$$android_net_NetworkTemplate$getNetworkId(), this);
    }

    public boolean matches(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_net_NetworkTemplate$matches(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesMetered(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesMetered", $$robo$$android_net_NetworkTemplate$matchesMetered(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesRoaming(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesRoaming", $$robo$$android_net_NetworkTemplate$matchesRoaming(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesDefaultNetwork(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesDefaultNetwork", $$robo$$android_net_NetworkTemplate$matchesDefaultNetwork(android.net.NetworkIdentity ), this, networkIdentity);
    }

    public boolean matchesSubscriberId(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesSubscriberId", $$robo$$android_net_NetworkTemplate$matchesSubscriberId(java.lang.String ), this, string2);
    }

    private boolean matchesMobile(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesMobile", $$robo$$android_net_NetworkTemplate$matchesMobile(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesWifi(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesWifi", $$robo$$android_net_NetworkTemplate$matchesWifi(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesEthernet(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesEthernet", $$robo$$android_net_NetworkTemplate$matchesEthernet(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesMobileWildcard(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesMobileWildcard", $$robo$$android_net_NetworkTemplate$matchesMobileWildcard(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesWifiWildcard(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesWifiWildcard", $$robo$$android_net_NetworkTemplate$matchesWifiWildcard(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesBluetooth(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesBluetooth", $$robo$$android_net_NetworkTemplate$matchesBluetooth(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private boolean matchesProxy(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesProxy", $$robo$$android_net_NetworkTemplate$matchesProxy(android.net.NetworkIdentity ), this, networkIdentity);
    }

    private static String getMatchRuleName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getMatchRuleName", $$robo$$android_net_NetworkTemplate$getMatchRuleName(int ), (int)n);
    }

    public static NetworkTemplate normalize(NetworkTemplate networkTemplate, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_net_NetworkTemplate$normalize(android.net.NetworkTemplate java.lang.String[] ), (NetworkTemplate)networkTemplate, (String[])stringArray);
    }

    public byte[] getBytesForBackup() throws IOException {
        return InvokeDynamicSupport.bootstrap("getBytesForBackup", $$robo$$android_net_NetworkTemplate$getBytesForBackup(), this);
    }

    public static NetworkTemplate getNetworkTemplateFromBackup(DataInputStream dataInputStream) throws IOException, BackupUtils.BadVersionException {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkTemplateFromBackup", $$robo$$android_net_NetworkTemplate$getNetworkTemplateFromBackup(java.io.DataInputStream ), (DataInputStream)dataInputStream);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ NetworkTemplate(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate$__constructor__(android.os.Parcel android.net.NetworkTemplate$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkTemplate.class);
    }

    public /* synthetic */ NetworkTemplate() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkTemplate)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

