/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.INetd;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.util.SharedLog;
import android.os.INetworkManagementService;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.OsConstants;
import java.net.InetAddress;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InterfaceController
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private String mIfName;
    private INetworkManagementService mNMS;
    private INetd mNetd;
    private SharedLog mLog;

    private void $$robo$$android_net_ip_InterfaceController$__constructor__(String ifname, INetworkManagementService nms, INetd netd, SharedLog log) {
        this.mIfName = ifname;
        this.mNMS = nms;
        this.mNetd = netd;
        this.mLog = log;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$setIPv4Address(LinkAddress address) {
        InterfaceConfiguration ifcg = new InterfaceConfiguration();
        ifcg.setLinkAddress(address);
        try {
            this.mNMS.setInterfaceConfig(this.mIfName, ifcg);
        }
        catch (RemoteException | IllegalStateException e) {
            this.logError("IPv4 configuration failed: %s", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$clearIPv4Address() {
        try {
            InterfaceConfiguration ifcg = new InterfaceConfiguration();
            ifcg.setLinkAddress(new LinkAddress("0.0.0.0/0"));
            this.mNMS.setInterfaceConfig(this.mIfName, ifcg);
        }
        catch (RemoteException | IllegalStateException e) {
            this.logError("Failed to clear IPv4 address on interface %s: %s", this.mIfName, e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$enableIPv6() {
        try {
            this.mNMS.enableIpv6(this.mIfName);
        }
        catch (RemoteException | IllegalStateException e) {
            this.logError("enabling IPv6 failed: %s", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$disableIPv6() {
        try {
            this.mNMS.disableIpv6(this.mIfName);
        }
        catch (RemoteException | IllegalStateException e) {
            this.logError("disabling IPv6 failed: %s", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$setIPv6PrivacyExtensions(boolean enabled) {
        try {
            this.mNMS.setInterfaceIpv6PrivacyExtensions(this.mIfName, enabled);
        }
        catch (RemoteException | IllegalStateException e) {
            this.logError("error setting IPv6 privacy extensions: %s", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$setIPv6AddrGenModeIfSupported(int mode) {
        block3: {
            try {
                this.mNMS.setIPv6AddrGenMode(this.mIfName, mode);
            }
            catch (RemoteException e) {
                this.logError("Unable to set IPv6 addrgen mode: %s", e);
                return false;
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == OsConstants.EOPNOTSUPP) break block3;
                this.logError("Unable to set IPv6 addrgen mode: %s", e);
                return false;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$addAddress(LinkAddress addr) {
        return this.addAddress(addr.getAddress(), addr.getPrefixLength());
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$addAddress(InetAddress ip, int prefixLen) {
        try {
            this.mNetd.interfaceAddAddress(this.mIfName, ip.getHostAddress(), prefixLen);
        }
        catch (RemoteException | ServiceSpecificException e) {
            this.logError("failed to add %s/%d: %s", ip, prefixLen, e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$removeAddress(InetAddress ip, int prefixLen) {
        try {
            this.mNetd.interfaceDelAddress(this.mIfName, ip.getHostAddress(), prefixLen);
        }
        catch (RemoteException | ServiceSpecificException e) {
            this.logError("failed to remove %s/%d: %s", ip, prefixLen, e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_InterfaceController$clearAllAddresses() {
        try {
            this.mNMS.clearInterfaceAddresses(this.mIfName);
        }
        catch (Exception e) {
            this.logError("Failed to clear addresses: %s", e);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_net_ip_InterfaceController$logError(String fmt, Object ... args) {
        this.mLog.e(String.format(fmt, args));
    }

    private void __constructor__(String string2, INetworkManagementService iNetworkManagementService, INetd iNetd, SharedLog sharedLog) {
        this.$$robo$$android_net_ip_InterfaceController$__constructor__(string2, iNetworkManagementService, iNetd, sharedLog);
    }

    public InterfaceController(String string2, INetworkManagementService iNetworkManagementService, INetd iNetd, SharedLog sharedLog) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_InterfaceController$__constructor__(java.lang.String android.os.INetworkManagementService android.net.INetd android.net.util.SharedLog ), this, string2, iNetworkManagementService, iNetd, sharedLog);
    }

    public boolean setIPv4Address(LinkAddress linkAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("setIPv4Address", $$robo$$android_net_ip_InterfaceController$setIPv4Address(android.net.LinkAddress ), this, linkAddress);
    }

    public boolean clearIPv4Address() {
        return (boolean)InvokeDynamicSupport.bootstrap("clearIPv4Address", $$robo$$android_net_ip_InterfaceController$clearIPv4Address(), this);
    }

    public boolean enableIPv6() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableIPv6", $$robo$$android_net_ip_InterfaceController$enableIPv6(), this);
    }

    public boolean disableIPv6() {
        return (boolean)InvokeDynamicSupport.bootstrap("disableIPv6", $$robo$$android_net_ip_InterfaceController$disableIPv6(), this);
    }

    public boolean setIPv6PrivacyExtensions(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setIPv6PrivacyExtensions", $$robo$$android_net_ip_InterfaceController$setIPv6PrivacyExtensions(boolean ), this, bl);
    }

    public boolean setIPv6AddrGenModeIfSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setIPv6AddrGenModeIfSupported", $$robo$$android_net_ip_InterfaceController$setIPv6AddrGenModeIfSupported(int ), this, n);
    }

    public boolean addAddress(LinkAddress linkAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("addAddress", $$robo$$android_net_ip_InterfaceController$addAddress(android.net.LinkAddress ), this, linkAddress);
    }

    public boolean addAddress(InetAddress inetAddress, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("addAddress", $$robo$$android_net_ip_InterfaceController$addAddress(java.net.InetAddress int ), this, inetAddress, n);
    }

    public boolean removeAddress(InetAddress inetAddress, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAddress", $$robo$$android_net_ip_InterfaceController$removeAddress(java.net.InetAddress int ), this, inetAddress, n);
    }

    public boolean clearAllAddresses() {
        return (boolean)InvokeDynamicSupport.bootstrap("clearAllAddresses", $$robo$$android_net_ip_InterfaceController$clearAllAddresses(), this);
    }

    private void logError(String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrap("logError", $$robo$$android_net_ip_InterfaceController$logError(java.lang.String java.lang.Object[] ), this, string2, objectArray);
    }

    public /* synthetic */ InterfaceController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InterfaceController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

