/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.LinkProperties;
import android.net.RouteInfo;
import android.net.ip.IpNeighborMonitor;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.IpReachabilityEvent;
import android.net.util.InterfaceParams;
import android.net.util.MultinetworkPolicyTracker;
import android.net.util.SharedLog;
import android.os.Handler;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DumpUtils;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IpReachabilityMonitor
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "IpReachabilityMonitor";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    private InterfaceParams mInterfaceParams;
    private IpNeighborMonitor mIpNeighborMonitor;
    private SharedLog mLog;
    private Callback mCallback;
    private Dependencies mDependencies;
    private MultinetworkPolicyTracker mMultinetworkPolicyTracker;
    private IpConnectivityLog mMetricsLog;
    private LinkProperties mLinkProperties;
    private Map<InetAddress, IpNeighborMonitor.NeighborEvent> mNeighborWatchList;
    private volatile long mLastProbeTimeMs;

    private void $$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(Context context, InterfaceParams ifParams, Handler h, SharedLog log, Callback callback, MultinetworkPolicyTracker tracker) {
    }

    @VisibleForTesting
    private void $$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(InterfaceParams ifParams, Handler h, SharedLog log, Callback callback, MultinetworkPolicyTracker tracker, Dependencies dependencies) {
        this.mMetricsLog = new IpConnectivityLog();
        this.mLinkProperties = new LinkProperties();
        this.mNeighborWatchList = new HashMap<InetAddress, IpNeighborMonitor.NeighborEvent>();
        if (ifParams == null) {
            throw new IllegalArgumentException("null InterfaceParams");
        }
        this.mInterfaceParams = ifParams;
        this.mLog = log.forSubComponent("IpReachabilityMonitor");
        this.mCallback = callback;
        this.mMultinetworkPolicyTracker = tracker;
        this.mDependencies = dependencies;
        this.mIpNeighborMonitor = new IpNeighborMonitor(h, this.mLog, event -> {
            if (this.mInterfaceParams.index != event.ifindex) {
                return;
            }
            if (!this.mNeighborWatchList.containsKey(event.ip)) {
                return;
            }
            IpNeighborMonitor.NeighborEvent prev = this.mNeighborWatchList.put(event.ip, event);
            if (event.nudState == 32) {
                this.mLog.w("ALERT neighbor went from: " + prev + " to: " + event);
                this.handleNeighborLost(event);
            }
        });
        this.mIpNeighborMonitor.start();
    }

    private final void $$robo$$android_net_ip_IpReachabilityMonitor$stop() {
        this.mIpNeighborMonitor.stop();
        this.clearLinkProperties();
    }

    private final void $$robo$$android_net_ip_IpReachabilityMonitor$dump(PrintWriter pw) {
        DumpUtils.dumpAsync(this.mIpNeighborMonitor.getHandler(), new DumpUtils.Dump(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ IpReachabilityMonitor this$0;

            private void $$robo$$android_net_ip_IpReachabilityMonitor_1$__constructor__(IpReachabilityMonitor this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_net_ip_IpReachabilityMonitor_1$dump(PrintWriter pw, String prefix) {
                pw.println(this.this$0.describeWatchList("\n"));
            }

            private void __constructor__(IpReachabilityMonitor ipReachabilityMonitor) {
                this.$$robo$$android_net_ip_IpReachabilityMonitor_1$__constructor__(ipReachabilityMonitor);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpReachabilityMonitor_1$__constructor__(android.net.ip.IpReachabilityMonitor ), this, ipReachabilityMonitor);
            }

            @Override
            public void dump(PrintWriter printWriter, String string2) {
                InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_ip_IpReachabilityMonitor_1$dump(java.io.PrintWriter java.lang.String ), this, printWriter, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, pw, "", 1000L);
    }

    private final String $$robo$$android_net_ip_IpReachabilityMonitor$describeWatchList() {
        return this.describeWatchList(" ");
    }

    private final String $$robo$$android_net_ip_IpReachabilityMonitor$describeWatchList(String sep) {
        StringBuilder sb = new StringBuilder();
        sb.append("iface{" + this.mInterfaceParams + "}," + sep);
        sb.append("ntable=[" + sep);
        String delimiter = "";
        for (Map.Entry<InetAddress, IpNeighborMonitor.NeighborEvent> entry : this.mNeighborWatchList.entrySet()) {
            sb.append(delimiter).append(entry.getKey().getHostAddress() + "/" + entry.getValue());
            delimiter = "," + sep;
        }
        sb.append("]");
        return sb.toString();
    }

    private static final boolean $$robo$$android_net_ip_IpReachabilityMonitor$isOnLink(List<RouteInfo> routes, InetAddress ip) {
        for (RouteInfo route : routes) {
            if (route.hasGateway() || !route.matches(ip)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_net_ip_IpReachabilityMonitor$updateLinkProperties(LinkProperties lp) {
        if (!this.mInterfaceParams.name.equals(lp.getInterfaceName())) {
            Log.wtf("IpReachabilityMonitor", "requested LinkProperties interface '" + lp.getInterfaceName() + "' does not match: " + this.mInterfaceParams.name);
            return;
        }
        this.mLinkProperties = new LinkProperties(lp);
        HashMap<InetAddress, IpNeighborMonitor.NeighborEvent> newNeighborWatchList = new HashMap<InetAddress, IpNeighborMonitor.NeighborEvent>();
        List<RouteInfo> routes = this.mLinkProperties.getRoutes();
        for (RouteInfo route : routes) {
            InetAddress gw;
            if (!route.hasGateway() || !IpReachabilityMonitor.isOnLink(routes, gw = route.getGateway())) continue;
            newNeighborWatchList.put(gw, this.mNeighborWatchList.getOrDefault(gw, null));
        }
        for (InetAddress dns : lp.getDnsServers()) {
            if (!IpReachabilityMonitor.isOnLink(routes, dns)) continue;
            newNeighborWatchList.put(dns, this.mNeighborWatchList.getOrDefault(dns, null));
        }
        this.mNeighborWatchList = newNeighborWatchList;
    }

    private final void $$robo$$android_net_ip_IpReachabilityMonitor$clearLinkProperties() {
        this.mLinkProperties.clear();
        this.mNeighborWatchList.clear();
    }

    private final void $$robo$$android_net_ip_IpReachabilityMonitor$handleNeighborLost(IpNeighborMonitor.NeighborEvent event) {
        LinkProperties whatIfLp = new LinkProperties(this.mLinkProperties);
        InetAddress ip = null;
        for (Map.Entry<InetAddress, IpNeighborMonitor.NeighborEvent> entry : this.mNeighborWatchList.entrySet()) {
            if (entry.getValue().nudState != 32) continue;
            ip = entry.getKey();
            for (RouteInfo route : this.mLinkProperties.getRoutes()) {
                if (!ip.equals(route.getGateway())) continue;
                whatIfLp.removeRoute(route);
            }
            if (!this.avoidingBadLinks() && ip instanceof Inet6Address) continue;
            whatIfLp.removeDnsServer(ip);
        }
        LinkProperties.ProvisioningChange delta = LinkProperties.compareProvisioning(this.mLinkProperties, whatIfLp);
        if (delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING) {
            String logMsg = "FAILURE: LOST_PROVISIONING, " + event;
            Log.w("IpReachabilityMonitor", logMsg);
            if (this.mCallback != null) {
                this.mCallback.notifyLost(ip, logMsg);
            }
        }
        this.logNudFailed(delta);
    }

    private final boolean $$robo$$android_net_ip_IpReachabilityMonitor$avoidingBadLinks() {
        return this.mMultinetworkPolicyTracker == null || this.mMultinetworkPolicyTracker.getAvoidBadWifi();
    }

    private final void $$robo$$android_net_ip_IpReachabilityMonitor$probeAll() {
        ArrayList<InetAddress> ipProbeList = new ArrayList<InetAddress>(this.mNeighborWatchList.keySet());
        if (!ipProbeList.isEmpty()) {
            this.mDependencies.acquireWakeLock(IpReachabilityMonitor.getProbeWakeLockDuration());
        }
        for (InetAddress ip : ipProbeList) {
            int rval = IpNeighborMonitor.startKernelNeighborProbe(this.mInterfaceParams.index, ip);
            this.mLog.log(String.format("put neighbor %s into NUD_PROBE state (rval=%d)", ip.getHostAddress(), rval));
            this.logEvent(256, rval);
        }
        this.mLastProbeTimeMs = SystemClock.elapsedRealtime();
    }

    private static final long $$robo$$android_net_ip_IpReachabilityMonitor$getProbeWakeLockDuration() {
        long numUnicastProbes = 3L;
        long retransTimeMs = 1000L;
        long gracePeriodMs = 500L;
        return 3500L;
    }

    private final void $$robo$$android_net_ip_IpReachabilityMonitor$logEvent(int probeType, int errorCode) {
        int eventType = probeType | errorCode & 0xFF;
        this.mMetricsLog.log(this.mInterfaceParams.name, (Parcelable)new IpReachabilityEvent(eventType));
    }

    private final void $$robo$$android_net_ip_IpReachabilityMonitor$logNudFailed(LinkProperties.ProvisioningChange delta) {
        long duration = SystemClock.elapsedRealtime() - this.mLastProbeTimeMs;
        boolean isFromProbe = duration < IpReachabilityMonitor.getProbeWakeLockDuration();
        boolean isProvisioningLost = delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        int eventType = IpReachabilityEvent.nudFailureEventType(isFromProbe, isProvisioningLost);
        this.mMetricsLog.log(this.mInterfaceParams.name, (Parcelable)new IpReachabilityEvent(eventType));
    }

    private void __constructor__(Context context, InterfaceParams interfaceParams, Handler handler, SharedLog sharedLog, Callback callback, MultinetworkPolicyTracker multinetworkPolicyTracker) {
        this.$$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(context, interfaceParams, handler, sharedLog, callback, multinetworkPolicyTracker);
    }

    public IpReachabilityMonitor(Context context, InterfaceParams interfaceParams, Handler handler, SharedLog sharedLog, Callback callback, MultinetworkPolicyTracker multinetworkPolicyTracker) {
        this(interfaceParams, handler, sharedLog, callback, multinetworkPolicyTracker, Dependencies.makeDefault(context, interfaceParams.name));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(android.content.Context android.net.util.InterfaceParams android.os.Handler android.net.util.SharedLog android.net.ip.IpReachabilityMonitor$Callback android.net.util.MultinetworkPolicyTracker ), this, context, interfaceParams, handler, sharedLog, callback, multinetworkPolicyTracker);
    }

    private void __constructor__(InterfaceParams interfaceParams, Handler handler, SharedLog sharedLog, Callback callback, MultinetworkPolicyTracker multinetworkPolicyTracker, Dependencies dependencies) {
        this.$$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(interfaceParams, handler, sharedLog, callback, multinetworkPolicyTracker, dependencies);
    }

    public IpReachabilityMonitor(InterfaceParams interfaceParams, Handler handler, SharedLog sharedLog, Callback callback, MultinetworkPolicyTracker multinetworkPolicyTracker, Dependencies dependencies) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(android.net.util.InterfaceParams android.os.Handler android.net.util.SharedLog android.net.ip.IpReachabilityMonitor$Callback android.net.util.MultinetworkPolicyTracker android.net.ip.IpReachabilityMonitor$Dependencies ), this, interfaceParams, handler, sharedLog, callback, multinetworkPolicyTracker, dependencies);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_ip_IpReachabilityMonitor$stop(), this);
    }

    public void dump(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_ip_IpReachabilityMonitor$dump(java.io.PrintWriter ), this, printWriter);
    }

    private String describeWatchList() {
        return InvokeDynamicSupport.bootstrap("describeWatchList", $$robo$$android_net_ip_IpReachabilityMonitor$describeWatchList(), this);
    }

    private String describeWatchList(String string2) {
        return InvokeDynamicSupport.bootstrap("describeWatchList", $$robo$$android_net_ip_IpReachabilityMonitor$describeWatchList(java.lang.String ), this, string2);
    }

    private static boolean isOnLink(List<RouteInfo> list, InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOnLink", $$robo$$android_net_ip_IpReachabilityMonitor$isOnLink(java.util.List<android.net.RouteInfo> java.net.InetAddress ), list, (InetAddress)inetAddress);
    }

    public void updateLinkProperties(LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("updateLinkProperties", $$robo$$android_net_ip_IpReachabilityMonitor$updateLinkProperties(android.net.LinkProperties ), this, linkProperties);
    }

    public void clearLinkProperties() {
        InvokeDynamicSupport.bootstrap("clearLinkProperties", $$robo$$android_net_ip_IpReachabilityMonitor$clearLinkProperties(), this);
    }

    private void handleNeighborLost(IpNeighborMonitor.NeighborEvent neighborEvent) {
        InvokeDynamicSupport.bootstrap("handleNeighborLost", $$robo$$android_net_ip_IpReachabilityMonitor$handleNeighborLost(android.net.ip.IpNeighborMonitor$NeighborEvent ), this, neighborEvent);
    }

    private boolean avoidingBadLinks() {
        return (boolean)InvokeDynamicSupport.bootstrap("avoidingBadLinks", $$robo$$android_net_ip_IpReachabilityMonitor$avoidingBadLinks(), this);
    }

    public void probeAll() {
        InvokeDynamicSupport.bootstrap("probeAll", $$robo$$android_net_ip_IpReachabilityMonitor$probeAll(), this);
    }

    private static long getProbeWakeLockDuration() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getProbeWakeLockDuration", $$robo$$android_net_ip_IpReachabilityMonitor$getProbeWakeLockDuration());
    }

    private void logEvent(int n, int n2) {
        InvokeDynamicSupport.bootstrap("logEvent", $$robo$$android_net_ip_IpReachabilityMonitor$logEvent(int int ), this, n, n2);
    }

    private void logNudFailed(LinkProperties.ProvisioningChange provisioningChange) {
        InvokeDynamicSupport.bootstrap("logNudFailed", $$robo$$android_net_ip_IpReachabilityMonitor$logNudFailed(android.net.LinkProperties$ProvisioningChange ), this, provisioningChange);
    }

    public /* synthetic */ IpReachabilityMonitor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpReachabilityMonitor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface Dependencies {
        public void acquireWakeLock(long var1);

        public static Dependencies makeDefault(Context context, String iface) {
            String lockName = "IpReachabilityMonitor." + iface;
            PowerManager pm = (PowerManager)context.getSystemService("power");
            PowerManager.WakeLock lock = pm.newWakeLock(1, lockName);
            return new Dependencies(lock){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ PowerManager.WakeLock val$lock;

                private void $$robo$$android_net_ip_IpReachabilityMonitor_Dependencies_1$__constructor__(PowerManager.WakeLock wakeLock) {
                    this.val$lock = wakeLock;
                }

                private final void $$robo$$android_net_ip_IpReachabilityMonitor_Dependencies_1$acquireWakeLock(long durationMs) {
                    this.val$lock.acquire(durationMs);
                }

                private void __constructor__(PowerManager.WakeLock wakeLock) {
                    this.$$robo$$android_net_ip_IpReachabilityMonitor_Dependencies_1$__constructor__(wakeLock);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpReachabilityMonitor_Dependencies_1$__constructor__(android.os.PowerManager$WakeLock ), this, wakeLock);
                }

                @Override
                public void acquireWakeLock(long l) {
                    InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$android_net_ip_IpReachabilityMonitor_Dependencies_1$acquireWakeLock(long ), this, l);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
    }

    public static interface Callback {
        public void notifyLost(InetAddress var1, String var2);
    }
}

