/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.NetlinkMessage;
import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructTimeval;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetlinkSocket
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NetlinkSocket";
    public static int DEFAULT_RECV_BUFSIZE = 8192;
    public static int SOCKET_RECV_BUFSIZE = 65536;

    private void $$robo$$android_net_netlink_NetlinkSocket$__constructor__() {
    }

    private static final void $$robo$$android_net_netlink_NetlinkSocket$sendOneShotKernelMessage(int nlProto, byte[] msg) throws ErrnoException {
        block10: {
            String errPrefix = "Error in NetlinkSocket.sendOneShotKernelMessage";
            long IO_TIMEOUT = 300L;
            FileDescriptor fd = NetlinkSocket.forProto(nlProto);
            try {
                String errmsg;
                NetlinkSocket.connectToKernel(fd);
                NetlinkSocket.sendMessage(fd, msg, 0, msg.length, 300L);
                ByteBuffer bytes = NetlinkSocket.recvMessage(fd, 8192, 300L);
                NetlinkMessage response = NetlinkMessage.parse(bytes);
                if (response != null && response instanceof NetlinkErrorMessage && ((NetlinkErrorMessage)response).getNlMsgError() != null) {
                    int errno = ((NetlinkErrorMessage)response).getNlMsgError().error;
                    if (errno != 0) {
                        Log.e("NetlinkSocket", "Error in NetlinkSocket.sendOneShotKernelMessage, errmsg=" + response.toString());
                        throw new ErrnoException(response.toString(), Math.abs(errno));
                    }
                    break block10;
                }
                if (response == null) {
                    bytes.position(0);
                    errmsg = "raw bytes: " + NetlinkConstants.hexify(bytes);
                } else {
                    errmsg = response.toString();
                }
                Log.e("NetlinkSocket", "Error in NetlinkSocket.sendOneShotKernelMessage, errmsg=" + errmsg);
                throw new ErrnoException(errmsg, OsConstants.EPROTO);
            }
            catch (InterruptedIOException e) {
                Log.e("NetlinkSocket", "Error in NetlinkSocket.sendOneShotKernelMessage", e);
                throw new ErrnoException("Error in NetlinkSocket.sendOneShotKernelMessage", OsConstants.ETIMEDOUT, e);
            }
            catch (SocketException e) {
                Log.e("NetlinkSocket", "Error in NetlinkSocket.sendOneShotKernelMessage", e);
                throw new ErrnoException("Error in NetlinkSocket.sendOneShotKernelMessage", OsConstants.EIO, e);
            }
            finally {
                IoUtils.closeQuietly(fd);
            }
        }
    }

    private static final FileDescriptor $$robo$$android_net_netlink_NetlinkSocket$forProto(int nlProto) throws ErrnoException {
        FileDescriptor fd = Os.socket(OsConstants.AF_NETLINK, OsConstants.SOCK_DGRAM, nlProto);
        Os.setsockoptInt(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, 65536);
        return fd;
    }

    private static final void $$robo$$android_net_netlink_NetlinkSocket$connectToKernel(FileDescriptor fd) throws ErrnoException, SocketException {
        Os.connect(fd, new NetlinkSocketAddress(0, 0));
    }

    private static final void $$robo$$android_net_netlink_NetlinkSocket$checkTimeout(long timeoutMs) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Negative timeouts not permitted");
        }
    }

    private static final ByteBuffer $$robo$$android_net_netlink_NetlinkSocket$recvMessage(FileDescriptor fd, int bufsize, long timeoutMs) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        NetlinkSocket.checkTimeout(timeoutMs);
        Os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_RCVTIMEO, StructTimeval.fromMillis(timeoutMs));
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufsize);
        int length = Os.read(fd, byteBuffer);
        if (length == bufsize) {
            Log.w("NetlinkSocket", "maximum read");
        }
        byteBuffer.position(0);
        byteBuffer.limit(length);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    private static final int $$robo$$android_net_netlink_NetlinkSocket$sendMessage(FileDescriptor fd, byte[] bytes, int offset, int count, long timeoutMs) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        NetlinkSocket.checkTimeout(timeoutMs);
        Os.setsockoptTimeval(fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, StructTimeval.fromMillis(timeoutMs));
        return Os.write(fd, bytes, offset, count);
    }

    private void __constructor__() {
        this.$$robo$$android_net_netlink_NetlinkSocket$__constructor__();
    }

    public NetlinkSocket() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_netlink_NetlinkSocket$__constructor__(), this);
    }

    public static void sendOneShotKernelMessage(int n, byte[] byArray) throws ErrnoException {
        InvokeDynamicSupport.bootstrapStatic("sendOneShotKernelMessage", $$robo$$android_net_netlink_NetlinkSocket$sendOneShotKernelMessage(int byte[] ), (int)n, (byte[])byArray);
    }

    public static FileDescriptor forProto(int n) throws ErrnoException {
        return InvokeDynamicSupport.bootstrapStatic("forProto", $$robo$$android_net_netlink_NetlinkSocket$forProto(int ), (int)n);
    }

    public static void connectToKernel(FileDescriptor fileDescriptor) throws ErrnoException, SocketException {
        InvokeDynamicSupport.bootstrapStatic("connectToKernel", $$robo$$android_net_netlink_NetlinkSocket$connectToKernel(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    private static void checkTimeout(long l) {
        InvokeDynamicSupport.bootstrapStatic("checkTimeout", $$robo$$android_net_netlink_NetlinkSocket$checkTimeout(long ), (long)l);
    }

    public static ByteBuffer recvMessage(FileDescriptor fileDescriptor, int n, long l) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        return InvokeDynamicSupport.bootstrapStatic("recvMessage", $$robo$$android_net_netlink_NetlinkSocket$recvMessage(java.io.FileDescriptor int long ), (FileDescriptor)fileDescriptor, (int)n, (long)l);
    }

    public static int sendMessage(FileDescriptor fileDescriptor, byte[] byArray, int n, int n2, long l) throws ErrnoException, IllegalArgumentException, InterruptedIOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("sendMessage", $$robo$$android_net_netlink_NetlinkSocket$sendMessage(java.io.FileDescriptor byte[] int int long ), (FileDescriptor)fileDescriptor, (byte[])byArray, (int)n, (int)n2, (long)l);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetlinkSocket)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

