/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.net.MacAddress;
import android.net.dhcp.DhcpPacket;
import android.net.util.NetworkConstants;
import android.system.OsConstants;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringJoiner;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConnectivityPacketSummary
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private byte[] mHwAddr;
    private byte[] mBytes;
    private int mLength;
    private ByteBuffer mPacket;
    private String mSummary;

    private static final String $$robo$$android_net_util_ConnectivityPacketSummary$summarize(MacAddress hwaddr, byte[] buffer) {
        return ConnectivityPacketSummary.summarize(hwaddr, buffer, buffer.length);
    }

    private static final String $$robo$$android_net_util_ConnectivityPacketSummary$summarize(MacAddress macAddr, byte[] buffer, int length) {
        if (macAddr == null || buffer == null) {
            return null;
        }
        length = Math.min(length, buffer.length);
        return new ConnectivityPacketSummary(macAddr, buffer, length).toString();
    }

    private void $$robo$$android_net_util_ConnectivityPacketSummary$__constructor__(MacAddress macAddr, byte[] buffer, int length) {
        this.mHwAddr = macAddr.toByteArray();
        this.mBytes = buffer;
        this.mLength = Math.min(length, this.mBytes.length);
        this.mPacket = ByteBuffer.wrap(this.mBytes, 0, this.mLength);
        this.mPacket.order(ByteOrder.BIG_ENDIAN);
        StringJoiner sj = new StringJoiner(" ");
        this.parseEther(sj);
        this.mSummary = sj.toString();
    }

    private final String $$robo$$android_net_util_ConnectivityPacketSummary$toString() {
        return this.mSummary;
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseEther(StringJoiner sj) {
        if (this.mPacket.remaining() < 14) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        this.mPacket.position(6);
        ByteBuffer srcMac = (ByteBuffer)this.mPacket.slice().limit(6);
        sj.add(ByteBuffer.wrap(this.mHwAddr).equals(srcMac) ? "TX" : "RX");
        sj.add(ConnectivityPacketSummary.getMacAddressString(srcMac));
        this.mPacket.position(0);
        ByteBuffer dstMac = (ByteBuffer)this.mPacket.slice().limit(6);
        sj.add(">").add(ConnectivityPacketSummary.getMacAddressString(dstMac));
        this.mPacket.position(12);
        int etherType = NetworkConstants.asUint(this.mPacket.getShort());
        switch (etherType) {
            case 2054: {
                sj.add("arp");
                this.parseARP(sj);
                break;
            }
            case 2048: {
                sj.add("ipv4");
                this.parseIPv4(sj);
                break;
            }
            case 34525: {
                sj.add("ipv6");
                this.parseIPv6(sj);
                break;
            }
            default: {
                sj.add("ethtype").add(NetworkConstants.asString(etherType));
            }
        }
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseARP(StringJoiner sj) {
        if (this.mPacket.remaining() < 28) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        if (NetworkConstants.asUint(this.mPacket.getShort()) != 1 || NetworkConstants.asUint(this.mPacket.getShort()) != 2048 || NetworkConstants.asUint(this.mPacket.get()) != 6 || NetworkConstants.asUint(this.mPacket.get()) != 4) {
            sj.add("unexpected header");
            return;
        }
        int opCode = NetworkConstants.asUint(this.mPacket.getShort());
        String senderHwAddr = ConnectivityPacketSummary.getMacAddressString(this.mPacket);
        String senderIPv4 = ConnectivityPacketSummary.getIPv4AddressString(this.mPacket);
        ConnectivityPacketSummary.getMacAddressString(this.mPacket);
        String targetIPv4 = ConnectivityPacketSummary.getIPv4AddressString(this.mPacket);
        if (opCode == 1) {
            sj.add("who-has").add(targetIPv4);
        } else if (opCode == 2) {
            sj.add("reply").add(senderIPv4).add(senderHwAddr);
        } else {
            sj.add("unknown opcode").add(NetworkConstants.asString(opCode));
        }
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseIPv4(StringJoiner sj) {
        if (!this.mPacket.hasRemaining()) {
            sj.add("runt");
            return;
        }
        int startOfIpLayer = this.mPacket.position();
        int ipv4HeaderLength = (this.mPacket.get(startOfIpLayer) & 0xF) * 4;
        if (this.mPacket.remaining() < ipv4HeaderLength || this.mPacket.remaining() < 20) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        int startOfTransportLayer = startOfIpLayer + ipv4HeaderLength;
        this.mPacket.position(startOfIpLayer + 6);
        int flagsAndFragment = NetworkConstants.asUint(this.mPacket.getShort());
        boolean isFragment = (flagsAndFragment & 0x1FFF) != 0;
        this.mPacket.position(startOfIpLayer + 9);
        int protocol = NetworkConstants.asUint(this.mPacket.get());
        this.mPacket.position(startOfIpLayer + 12);
        String srcAddr = ConnectivityPacketSummary.getIPv4AddressString(this.mPacket);
        this.mPacket.position(startOfIpLayer + 16);
        String dstAddr = ConnectivityPacketSummary.getIPv4AddressString(this.mPacket);
        sj.add(srcAddr).add(">").add(dstAddr);
        this.mPacket.position(startOfTransportLayer);
        if (protocol == OsConstants.IPPROTO_UDP) {
            sj.add("udp");
            if (isFragment) {
                sj.add("fragment");
            } else {
                this.parseUDP(sj);
            }
        } else {
            sj.add("proto").add(NetworkConstants.asString(protocol));
            if (isFragment) {
                sj.add("fragment");
            }
        }
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseIPv6(StringJoiner sj) {
        if (this.mPacket.remaining() < 40) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        int startOfIpLayer = this.mPacket.position();
        this.mPacket.position(startOfIpLayer + 6);
        int protocol = NetworkConstants.asUint(this.mPacket.get());
        this.mPacket.position(startOfIpLayer + 8);
        String srcAddr = ConnectivityPacketSummary.getIPv6AddressString(this.mPacket);
        String dstAddr = ConnectivityPacketSummary.getIPv6AddressString(this.mPacket);
        sj.add(srcAddr).add(">").add(dstAddr);
        this.mPacket.position(startOfIpLayer + 40);
        if (protocol == OsConstants.IPPROTO_ICMPV6) {
            sj.add("icmp6");
            this.parseICMPv6(sj);
        } else {
            sj.add("proto").add(NetworkConstants.asString(protocol));
        }
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6(StringJoiner sj) {
        if (this.mPacket.remaining() < 4) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        int icmp6Type = NetworkConstants.asUint(this.mPacket.get());
        int icmp6Code = NetworkConstants.asUint(this.mPacket.get());
        this.mPacket.getShort();
        switch (icmp6Type) {
            case 133: {
                sj.add("rs");
                this.parseICMPv6RouterSolicitation(sj);
                break;
            }
            case 134: {
                sj.add("ra");
                this.parseICMPv6RouterAdvertisement(sj);
                break;
            }
            case 135: {
                sj.add("ns");
                this.parseICMPv6NeighborMessage(sj);
                break;
            }
            case 136: {
                sj.add("na");
                this.parseICMPv6NeighborMessage(sj);
                break;
            }
            default: {
                sj.add("type").add(NetworkConstants.asString(icmp6Type));
                sj.add("code").add(NetworkConstants.asString(icmp6Code));
            }
        }
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6RouterSolicitation(StringJoiner sj) {
        int RESERVED = 4;
        if (this.mPacket.remaining() < 4) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        this.mPacket.position(this.mPacket.position() + 4);
        this.parseICMPv6NeighborDiscoveryOptions(sj);
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6RouterAdvertisement(StringJoiner sj) {
        int FLAGS_AND_TIMERS = 12;
        if (this.mPacket.remaining() < 12) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        this.mPacket.position(this.mPacket.position() + 12);
        this.parseICMPv6NeighborDiscoveryOptions(sj);
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6NeighborMessage(StringJoiner sj) {
        int RESERVED = 4;
        int minReq = 20;
        if (this.mPacket.remaining() < 20) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        this.mPacket.position(this.mPacket.position() + 4);
        sj.add(ConnectivityPacketSummary.getIPv6AddressString(this.mPacket));
        this.parseICMPv6NeighborDiscoveryOptions(sj);
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6NeighborDiscoveryOptions(StringJoiner sj) {
        while (this.mPacket.remaining() >= 8) {
            int ndType = NetworkConstants.asUint(this.mPacket.get());
            int ndLength = NetworkConstants.asUint(this.mPacket.get());
            int ndBytes = ndLength * 8 - 2;
            if (ndBytes < 0 || ndBytes > this.mPacket.remaining()) {
                sj.add("<malformed>");
                break;
            }
            int position = this.mPacket.position();
            switch (ndType) {
                case 1: {
                    sj.add("slla");
                    sj.add(ConnectivityPacketSummary.getMacAddressString(this.mPacket));
                    break;
                }
                case 2: {
                    sj.add("tlla");
                    sj.add(ConnectivityPacketSummary.getMacAddressString(this.mPacket));
                    break;
                }
                case 5: {
                    sj.add("mtu");
                    short reserved = this.mPacket.getShort();
                    sj.add(NetworkConstants.asString(this.mPacket.getInt()));
                    break;
                }
            }
            this.mPacket.position(position + ndBytes);
        }
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseUDP(StringJoiner sj) {
        if (this.mPacket.remaining() < 8) {
            sj.add("runt:").add(NetworkConstants.asString(this.mPacket.remaining()));
            return;
        }
        int previous = this.mPacket.position();
        int srcPort = NetworkConstants.asUint(this.mPacket.getShort());
        int dstPort = NetworkConstants.asUint(this.mPacket.getShort());
        sj.add(NetworkConstants.asString(srcPort)).add(">").add(NetworkConstants.asString(dstPort));
        this.mPacket.position(previous + 8);
        if (srcPort == 68 || dstPort == 68) {
            sj.add("dhcp4");
            this.parseDHCPv4(sj);
        }
    }

    private final void $$robo$$android_net_util_ConnectivityPacketSummary$parseDHCPv4(StringJoiner sj) {
        try {
            DhcpPacket dhcpPacket = DhcpPacket.decodeFullPacket(this.mBytes, this.mLength, 0);
            sj.add(dhcpPacket.toString());
        }
        catch (DhcpPacket.ParseException e) {
            sj.add("parse error: " + e);
        }
    }

    private static final String $$robo$$android_net_util_ConnectivityPacketSummary$getIPv4AddressString(ByteBuffer ipv4) {
        return ConnectivityPacketSummary.getIpAddressString(ipv4, 4);
    }

    private static final String $$robo$$android_net_util_ConnectivityPacketSummary$getIPv6AddressString(ByteBuffer ipv6) {
        return ConnectivityPacketSummary.getIpAddressString(ipv6, 16);
    }

    private static final String $$robo$$android_net_util_ConnectivityPacketSummary$getIpAddressString(ByteBuffer ip, int byteLength) {
        if (ip == null || ip.remaining() < byteLength) {
            return "invalid";
        }
        byte[] bytes = new byte[byteLength];
        ip.get(bytes, 0, byteLength);
        try {
            InetAddress addr = InetAddress.getByAddress(bytes);
            return addr.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            return "unknown";
        }
    }

    private static final String $$robo$$android_net_util_ConnectivityPacketSummary$getMacAddressString(ByteBuffer mac) {
        if (mac == null || mac.remaining() < 6) {
            return "invalid";
        }
        byte[] bytes = new byte[6];
        mac.get(bytes, 0, bytes.length);
        Object[] printableBytes = new Object[bytes.length];
        int i = 0;
        for (byte b : bytes) {
            printableBytes[i++] = new Byte(b);
        }
        String MAC48_FORMAT = "%02x:%02x:%02x:%02x:%02x:%02x";
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", printableBytes);
    }

    static void __staticInitializer__() {
        TAG = ConnectivityPacketSummary.class.getSimpleName();
    }

    public static String summarize(MacAddress macAddress, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("summarize", $$robo$$android_net_util_ConnectivityPacketSummary$summarize(android.net.MacAddress byte[] ), (MacAddress)macAddress, (byte[])byArray);
    }

    public static String summarize(MacAddress macAddress, byte[] byArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("summarize", $$robo$$android_net_util_ConnectivityPacketSummary$summarize(android.net.MacAddress byte[] int ), (MacAddress)macAddress, (byte[])byArray, (int)n);
    }

    private void __constructor__(MacAddress macAddress, byte[] byArray, int n) {
        this.$$robo$$android_net_util_ConnectivityPacketSummary$__constructor__(macAddress, byArray, n);
    }

    public ConnectivityPacketSummary(MacAddress macAddress, byte[] byArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_ConnectivityPacketSummary$__constructor__(android.net.MacAddress byte[] int ), this, macAddress, byArray, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_util_ConnectivityPacketSummary$toString(), this);
    }

    private void parseEther(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseEther", $$robo$$android_net_util_ConnectivityPacketSummary$parseEther(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseARP(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseARP", $$robo$$android_net_util_ConnectivityPacketSummary$parseARP(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseIPv4(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseIPv4", $$robo$$android_net_util_ConnectivityPacketSummary$parseIPv4(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseIPv6(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseIPv6", $$robo$$android_net_util_ConnectivityPacketSummary$parseIPv6(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseICMPv6(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseICMPv6", $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseICMPv6RouterSolicitation(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseICMPv6RouterSolicitation", $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6RouterSolicitation(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseICMPv6RouterAdvertisement(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseICMPv6RouterAdvertisement", $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6RouterAdvertisement(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseICMPv6NeighborMessage(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseICMPv6NeighborMessage", $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6NeighborMessage(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseICMPv6NeighborDiscoveryOptions(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseICMPv6NeighborDiscoveryOptions", $$robo$$android_net_util_ConnectivityPacketSummary$parseICMPv6NeighborDiscoveryOptions(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseUDP(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseUDP", $$robo$$android_net_util_ConnectivityPacketSummary$parseUDP(java.util.StringJoiner ), this, stringJoiner);
    }

    private void parseDHCPv4(StringJoiner stringJoiner) {
        InvokeDynamicSupport.bootstrap("parseDHCPv4", $$robo$$android_net_util_ConnectivityPacketSummary$parseDHCPv4(java.util.StringJoiner ), this, stringJoiner);
    }

    private static String getIPv4AddressString(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("getIPv4AddressString", $$robo$$android_net_util_ConnectivityPacketSummary$getIPv4AddressString(java.nio.ByteBuffer ), (ByteBuffer)byteBuffer);
    }

    private static String getIPv6AddressString(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("getIPv6AddressString", $$robo$$android_net_util_ConnectivityPacketSummary$getIPv6AddressString(java.nio.ByteBuffer ), (ByteBuffer)byteBuffer);
    }

    private static String getIpAddressString(ByteBuffer byteBuffer, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getIpAddressString", $$robo$$android_net_util_ConnectivityPacketSummary$getIpAddressString(java.nio.ByteBuffer int ), (ByteBuffer)byteBuffer, (int)n);
    }

    private static String getMacAddressString(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("getMacAddressString", $$robo$$android_net_util_ConnectivityPacketSummary$getMacAddressString(java.nio.ByteBuffer ), (ByteBuffer)byteBuffer);
    }

    static {
        RobolectricInternals.classInitializing(ConnectivityPacketSummary.class);
    }

    public /* synthetic */ ConnectivityPacketSummary() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectivityPacketSummary)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

